!
! Split an input set of concatenated xyz files into individual xyz files
! in ncores subdirectories.
!
PROGRAM MYSPLIT
IMPLICIT NONE
INTEGER NCORES, NATOMS, NFRAMES, J1, J2, J3, NDUMMY
CHARACTER(LEN=80) FILENAME, SDUMMY
CHARACTER(LEN=20) DSTRING, FSTRING
DOUBLE PRECISION DUMMY, DUMMYX, DUMMYY, DUMMYZ

OPEN(UNIT=1,FILE='mysplit.data',STATUS='OLD')
READ(1,*) NCORES, NATOMS, FILENAME
CLOSE(1)

NFRAMES=0
OPEN(UNIT=1,FILE=TRIM(ADJUSTL(FILENAME)),STATUS='OLD')
DO
   READ(1,*,END=123) SDUMMY
   READ(1,*,END=123) SDUMMY
   DO J1=1,NATOMS
      READ(1,*,END=123) SDUMMY, DUMMY, DUMMY, DUMMY
   ENDDO
   NFRAMES=NFRAMES+1
ENDDO
CLOSE(1)

123 PRINT '(A,I12)','Number of minima=',NFRAMES

OPEN(UNIT=1,FILE=TRIM(ADJUSTL(FILENAME)),STATUS='OLD')
REWIND(1)
DO J1=1,NCORES
   WRITE(DSTRING,'(I6)') J1
   CALL SYSTEM('mkdir '//TRIM(ADJUSTL(DSTRING)))
   DO J2=1,NFRAMES/NCORES
      WRITE(FSTRING,'(I8)') J2
      FSTRING=TRIM(ADJUSTL(DSTRING))//'/min.'//TRIM(ADJUSTL(FSTRING))
      OPEN(UNIT=2,FILE=FSTRING,STATUS='UNKNOWN')
      READ(1,*) SDUMMY
      WRITE(2,'(A)') SDUMMY
      READ(1,*) SDUMMY
      WRITE(2,'(A)') SDUMMY
      DO J3=1,NATOMS
         READ(1,*) SDUMMY, DUMMYX, DUMMYY, DUMMYZ
         WRITE(2,'(A,3G20.10)') TRIM(ADJUSTL(SDUMMY)), DUMMYX, DUMMYY, DUMMYZ
      ENDDO
      CLOSE(2)
!     PRINT *,'J1,J2=',J1,J2
   ENDDO
   IF (J1.EQ.NCORES) THEN
!
! Number of minima per directory = NDUMMY=NFRAMES/NCORES
! Number of minima left over for directory J1 = (NFRAMES-NDUMMY*NCORES)
!
      NDUMMY=NFRAMES/NCORES
      PRINT *,'NDUMMY,NFRAMES,extra min=',NDUMMY,NFRAMES,NFRAMES-NDUMMY*NCORES
!     DO J2=NCORES*NDUMMY+1,NFRAMES
      DO J2=NDUMMY+1,NDUMMY+NFRAMES-NDUMMY*NCORES
         WRITE(FSTRING,'(I8)') J2
         FSTRING=TRIM(ADJUSTL(DSTRING))//'/min.'//TRIM(ADJUSTL(FSTRING))
         OPEN(UNIT=2,FILE=FSTRING,STATUS='UNKNOWN')
         READ(1,*) SDUMMY
         WRITE(2,'(A)') SDUMMY
         READ(1,*) SDUMMY
         WRITE(2,'(A)') SDUMMY
         DO J3=1,NATOMS
            READ(1,*) SDUMMY, DUMMYX, DUMMYY, DUMMYZ
            WRITE(2,'(A,3G20.10)') TRIM(ADJUSTL(SDUMMY)), DUMMYX, DUMMYY, DUMMYZ
         ENDDO
         CLOSE(2)
!        PRINT *,'J1,J2=',J1,J2
      ENDDO
   ENDIF
ENDDO
CLOSE(1)

END PROGRAM MYSPLIT
