(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72519,       1783]
NotebookOptionsPosition[     70177,       1707]
NotebookOutlinePosition[     70562,       1724]
CellTagsIndexPosition[     70519,       1721]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\

(*   Set up the points of a master icosahedron   *)
Clear[golden,myu,myv,dist]
myu = ((5 - 5^(1/2))^(1/2)*(1 + 5^(1/2)))/40^(1/2);
myv = (5 - 5^(1/2))^(1/2)/10^(1/2);
nicos=12;
points={ { 0, myu, myv},
         { 0, myu,-myv},
         { 0,-myu, myv},
         { 0,-myu,-myv},
         { myv, 0, myu},
         { myv, 0,-myu},
         {-myv, 0, myu},
         {-myv, 0,-myu},
         { myu, myv, 0},
         { myu,-myv, 0},
         {-myu, myv, 0},
         {-myu,-myv, 0} };
threefold = FullSimplify[Normalize[(points[[1]]+points[[2]]+points[[9]])/3]]
fivefold=Simplify[PowerExpand[points[[1]]]]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 CellChangeTimes->{{3.438442270228303*^9, 3.438442271178949*^9}, {
  3.43868916956741*^9, 3.438689253371257*^9}, {3.4386892965326653`*^9, 
  3.438689343824605*^9}, {3.438689383824272*^9, 3.438689445245462*^9}},
 ShowSpecialCharacters->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox[
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       SqrtBox["5"]}], ")"}]}]], ",", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       SqrtBox["5"]}], ")"}]}]], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.438689223253503*^9, 3.4386892543978987`*^9}, {
   3.4386893142059517`*^9, 3.4386893447284*^9}, {3.438689389214952*^9, 
   3.438689445581297*^9}, 3.440326229647089*^9, 3.468577542267126*^9, 
   3.469284782195616*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     RowBox[{
      FractionBox["1", "10"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SqrtBox["5"]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}]}], ",", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "10"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       SqrtBox["5"]}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.438689223253503*^9, 3.4386892543978987`*^9}, {
   3.4386893142059517`*^9, 3.4386893447284*^9}, {3.438689389214952*^9, 
   3.438689445581297*^9}, 3.440326229647089*^9, 3.468577542267126*^9, 
   3.469284782235898*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rvec", "[", 
   RowBox[{"x0_", ",", "p_", ",", "alpha_"}], "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"x0", " ", "*", " ", 
    RowBox[{"Cos", "[", "alpha", "]"}]}], "+", " ", 
   RowBox[{"p", " ", "*", " ", 
    RowBox[{"(", 
     RowBox[{"p", " ", ".", " ", "x0"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "alpha", "]"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"Cross", "[", 
     RowBox[{"x0", ",", "p"}], "]"}], "*", 
    RowBox[{"Sin", "[", "alpha", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4386927295468607`*^9, 3.4386928319775667`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"x0", " ", 
   RowBox[{"Cos", "[", "alpha", "]"}]}], "+", 
  RowBox[{"p", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "alpha", "]"}]}], ")"}], " ", 
   RowBox[{"p", ".", "x0"}]}], "+", 
  RowBox[{
   RowBox[{"x0", "\[Cross]", "p"}], " ", 
   RowBox[{"Sin", "[", "alpha", "]"}]}]}]], "Output",
 CellChangeTimes->{3.4386928340667677`*^9, 3.440326235636836*^9, 
  3.4685775468181677`*^9, 3.4685903903667088`*^9, 3.469284785385089*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"rvec", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", "threefold", ",", 
    RowBox[{"2", "*", 
     RowBox[{"Pi", "/", "3"}]}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4386928475934258`*^9, 3.4386929070027246`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox["5"]}], ")"}]}], ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["5"]}], ")"}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.4386928683983994`*^9, 3.438692907295361*^9}, 
   3.440326238333185*^9, 3.468577566911796*^9, 3.469284788094297*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Icosahedral", " ", "point", " ", "group", " ", "operations"}], " ",
   "*)"}]], "Input",
 CellChangeTimes->{{3.468579892800482*^9, 3.468579902420989*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", "1", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "[", "3", "]"}], " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"rvec", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", "threefold", ",", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "2"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"Simplify", "[", 
     RowBox[{"rvec", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "threefold", ",", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "3"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"Simplify", "[", 
     RowBox[{"rvec", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "threefold", ",", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "3"}]}]}], "]"}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "[", "4", "]"}], " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"rvec", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", "fivefold", ",", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "5"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"Simplify", "[", 
     RowBox[{"rvec", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "fivefold", ",", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "5"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"Simplify", "[", 
     RowBox[{"rvec", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "fivefold", ",", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "5"}]}]}], "]"}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "[", "5", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.435490460139764*^9, 3.435490498957847*^9}, {
   3.435490547022942*^9, 3.435490575982529*^9}, 3.435490631464485*^9, {
   3.435490727401437*^9, 3.435490744795464*^9}, {3.435491039270012*^9, 
   3.435491058159955*^9}, {3.43549115278763*^9, 3.435491174111682*^9}, {
   3.435640884911413*^9, 3.435640897637712*^9}, {3.435641033491124*^9, 
   3.435641042873039*^9}, {3.436087135214255*^9, 3.436087183850333*^9}, {
   3.436087252256742*^9, 3.436087330534114*^9}, {3.43609821834722*^9, 
   3.436098218951631*^9}, {3.436106073322009*^9, 3.436106073792375*^9}, {
   3.4386926104246397`*^9, 3.438692717190619*^9}, {3.438692894693964*^9, 
   3.4386930093873787`*^9}, {3.44032610468865*^9, 3.440326117367382*^9}, {
   3.4695147051535263`*^9, 3.4695147076337748`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SqrtBox["5"]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          SqrtBox["5"]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SqrtBox["5"]}], ")"}]}]]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          SqrtBox["5"]}], ")"}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.438692967431735*^9, 3.438693009724738*^9, 
  3.440326119962772*^9, 3.44032624050883*^9, 3.46857758155173*^9, 
  3.469284792249674*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{
      FractionBox["1", "40"], " ", 
      SqrtBox[
       RowBox[{"5", "-", 
        SqrtBox["5"]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "40"]}], " ", 
      SqrtBox[
       RowBox[{"5", "-", 
        SqrtBox["5"]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}], ",", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.438692967431735*^9, 3.438693009724738*^9, 
  3.440326119962772*^9, 3.44032624050883*^9, 3.46857758155173*^9, 
  3.469284792397677*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.438692967431735*^9, 3.438693009724738*^9, 
  3.440326119962772*^9, 3.44032624050883*^9, 3.46857758155173*^9, 
  3.469284792400526*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "[", "1", "]"}], " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "[", "9", "]"}], " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"2.0", "*", 
          RowBox[{"Pi", "/", "7"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"2.0", "*", 
          RowBox[{"Pi", "/", "7"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"2.0", "*", 
          RowBox[{"Pi", "/", "7"}]}]}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"2.0", "*", 
          RowBox[{"Pi", "/", "8"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"2.0", "*", 
          RowBox[{"Pi", "/", "8"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"2.0", "*", 
          RowBox[{"Pi", "/", "8"}]}]}], "]"}], "]"}]}], "}"}], " ", ".", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{"S4", ",", "6", ",", "8"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"R", "[", "9", "]"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"rvec", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "/", 
         RowBox[{"Sqrt", "[", "3", "]"}]}], ",", 
        RowBox[{"2", "*", 
         RowBox[{"Pi", "/", "3"}]}]}], "]"}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{"rvec", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"Normalize", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"2", "*", 
         RowBox[{"Pi", "/", "3"}]}]}], "]"}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{"rvec", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"Normalize", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"2", "*", 
         RowBox[{"Pi", "/", "3"}]}]}], "]"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "[", "9", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"vertical", " ", "mirror", " ", "plane", " ", "xz"}], " ", "*)"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "[", "9", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "[", "9", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"horizontal", " ", "mirror", " ", "plane", " ", "z"}], "=", "0"}],
    " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "[", "9", "]"}], " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "8"}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "8"}]}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"2", "*", 
          RowBox[{"Pi", "/", "2"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "8"}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "8"}]}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"2", "*", 
          RowBox[{"Pi", "/", "2"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{"rvec", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "8"}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{"Pi", "/", "8"}]}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"2", "*", 
          RowBox[{"Pi", "/", "2"}]}]}], "]"}], "]"}]}], "}"}]}], ";", 
   RowBox[{"(*", " ", 
    RowBox[{
    "C2", " ", "perpendicular", " ", "element", " ", "off", " ", "x", " ", 
     "axis", " ", "for", " ", "Dnd"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "[", "9", "]"}], " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"R", "[", "9", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", 
  RowBox[{"(*", " ", 
   RowBox[{
   "C2", " ", "perpendicular", " ", "element", " ", "along", " ", "x", " ", 
    "axis", " ", "for", " ", "Dnh"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"R", "[", "9", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], " ", ";", "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"horizontal", " ", "mirror", " ", "plane", " ", "z"}], "=", "0"}],
    " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.435490460139764*^9, 3.435490498957847*^9}, {
   3.435490547022942*^9, 3.435490575982529*^9}, 3.435490631464485*^9, {
   3.435490727401437*^9, 3.435490744795464*^9}, {3.435491039270012*^9, 
   3.435491058159955*^9}, {3.43549115278763*^9, 3.435491174111682*^9}, {
   3.435640884911413*^9, 3.435640897637712*^9}, {3.435641033491124*^9, 
   3.435641042873039*^9}, {3.436087135214255*^9, 3.436087183850333*^9}, {
   3.436087252256742*^9, 3.436087330534114*^9}, {3.43609821834722*^9, 
   3.436098218951631*^9}, {3.436106073322009*^9, 3.436106073792375*^9}, {
   3.4386926104246397`*^9, 3.438692717190619*^9}, {3.438692894693964*^9, 
   3.4386930093873787`*^9}, {3.44032610468865*^9, 3.440326117367382*^9}, {
   3.468580026585643*^9, 3.468580103157071*^9}, {3.468580377311674*^9, 
   3.4685803930819483`*^9}, {3.4685805279679623`*^9, 3.468580540030931*^9}, {
   3.4685809079645987`*^9, 3.4685809620352097`*^9}, {3.46859042217275*^9, 
   3.468590432869389*^9}, {3.4685906709949207`*^9, 3.468590715988229*^9}, {
   3.468590770680483*^9, 3.468590814885209*^9}, {3.4685908699984503`*^9, 
   3.468590871819223*^9}, {3.468590996926558*^9, 3.468591016511589*^9}, {
   3.46859104665075*^9, 3.4685911068963947`*^9}, {3.468591218472245*^9, 
   3.4685912752009077`*^9}, {3.468591386969619*^9, 3.4685914370446033`*^9}, {
   3.468591607280943*^9, 3.468591626522434*^9}, {3.4685917077651777`*^9, 
   3.468591779210671*^9}, {3.468592137235979*^9, 3.468592137706695*^9}, {
   3.468592468915416*^9, 3.4685924933455563`*^9}, {3.468592580892219*^9, 
   3.4685926408488703`*^9}, {3.468592794381678*^9, 3.4685927948575068`*^9}, {
   3.46859283657565*^9, 3.468592837208005*^9}, {3.468593029701527*^9, 
   3.468593059610114*^9}, {3.468593121298374*^9, 3.4685931218573723`*^9}, {
   3.4692848007933083`*^9, 3.469284818067675*^9}, {3.469513230504756*^9, 
   3.469513230875359*^9}, {3.4695132823071632`*^9, 3.469513282778884*^9}, {
   3.4695133506459913`*^9, 3.469513374823676*^9}, {3.4695134270347357`*^9, 
   3.469513469422781*^9}, {3.4695135661519833`*^9, 3.469513596218292*^9}, {
   3.469513641914468*^9, 3.4695136491148367`*^9}, {3.469513691607955*^9, 
   3.469513703338874*^9}, {3.4695137459039583`*^9, 3.469513749503776*^9}, {
   3.469513795186288*^9, 3.4695137985488*^9}, {3.4695138302415657`*^9, 
   3.469513861182096*^9}, {3.4695139364749727`*^9, 3.469513958643487*^9}, {
   3.4695139931029673`*^9, 3.469513999027274*^9}, {3.469514041419956*^9, 
   3.469514045347199*^9}, {3.46951408390689*^9, 3.46951416488815*^9}, {
   3.469514207194705*^9, 3.4695142107991467`*^9}, {3.469514312556192*^9, 
   3.4695143153588657`*^9}, {3.4695143543910007`*^9, 3.469514364944762*^9}, {
   3.46951440342809*^9, 3.469514410083152*^9}, {3.469514493519971*^9, 
   3.469514517941432*^9}, {3.469514564642913*^9, 3.469514572718183*^9}, {
   3.4695146061553173`*^9, 3.469514627277545*^9}, {3.469514661517014*^9, 
   3.469514677192316*^9}, {3.469514730241714*^9, 3.469514730639165*^9}, {
   3.4695147666207733`*^9, 3.469514769689795*^9}, {3.469516087748304*^9, 
   3.4695160910309067`*^9}, {3.469516148086364*^9, 3.469516161752186*^9}, {
   3.469516196649495*^9, 3.4695162358882103`*^9}, {3.469516273985951*^9, 
   3.4695162814328833`*^9}, {3.46951634936563*^9, 3.4695163647283173`*^9}, {
   3.469516407747407*^9, 3.4695165051226597`*^9}, {3.4695165553706217`*^9, 
   3.469516597762981*^9}}],

Cell[TextData[{
 "\nSet the current number of group operations to ",
 StyleBox["whatever",
  FontColor->RGBColor[1, 0, 0]],
 " and work out how many ",
 StyleBox["distinct",
  FontColor->RGBColor[1, 0, 0]],
 " operations the group has by ",
 StyleBox["multiplying",
  FontColor->RGBColor[1, 0, 0]],
 " all the current members together and testing to see if we get anything ",
 StyleBox["different",
  FontColor->RGBColor[1, 0, 0]],
 ":"
}], "Text",
 CellChangeTimes->{{3.435490460139764*^9, 3.435490498957847*^9}, {
   3.435490547022942*^9, 3.435490575982529*^9}, 3.435490631464485*^9, {
   3.435490727401437*^9, 3.435490744795464*^9}, {3.435491039270012*^9, 
   3.435491058159955*^9}, {3.43549115278763*^9, 3.435491174111682*^9}, {
   3.435640884911413*^9, 3.435640897637712*^9}, {3.435641033491124*^9, 
   3.435641042873039*^9}, {3.436087135214255*^9, 3.436087183850333*^9}, {
   3.436087252256742*^9, 3.436087330534114*^9}, {3.43609821834722*^9, 
   3.436098218951631*^9}, {3.436106073322009*^9, 3.436106073792375*^9}, {
   3.4386926104246397`*^9, 3.4386926970799417`*^9}, {3.4403261263667173`*^9, 
   3.440326132735455*^9}, {3.468579935558601*^9, 3.4685799424232607`*^9}},
 FontSize->24],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ngroup", "=", "2"}], ";"}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FirstOperation", "=", "1"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"FirstOperation", "<", 
     RowBox[{"ngroup", "+", "1"}]}], ",", "       ", "\[IndentingNewLine]", 
    "         ", 
    RowBox[{
     RowBox[{"SecondOperation", "=", "1"}], ";", "\[IndentingNewLine]", 
     "         ", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"SecondOperation", "<", 
        RowBox[{"ngroup", "+", "1"}]}], ",", "\[IndentingNewLine]", 
       "             ", 
       RowBox[{
        RowBox[{"Rnew", "=", 
         RowBox[{"Simplify", "[", 
          RowBox[{
           RowBox[{"R", "[", "FirstOperation", "]"}], ".", 
           RowBox[{"R", "[", "SecondOperation", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "             ", 
        RowBox[{"new", "=", "True"}], ";", " ", 
        RowBox[{"testop", "=", "1"}], ";", "\[IndentingNewLine]", 
        "             ", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"new", " ", "&&", " ", 
           RowBox[{"testop", " ", "<", " ", 
            RowBox[{"ngroup", "+", "1"}]}]}], ",", "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Sum", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Rnew", "[", 
                    RowBox[{"[", "j1", "]"}], "]"}], "[", 
                    RowBox[{"[", "j2", "]"}], "]"}], "-", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"R", "[", "testop", "]"}], "[", 
                    RowBox[{"[", "j1", "]"}], "]"}], "[", 
                    RowBox[{"[", "j2", "]"}], "]"}]}], ")"}], "^", "2"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j1", ",", "1", ",", "3"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j2", ",", "1", ",", "3"}], "}"}]}], "]"}], "<", 
              "0.000001"}], ",", "      ", "\[IndentingNewLine]", 
             "                                     ", 
             RowBox[{"new", "=", "False"}], ","}], "\[IndentingNewLine]", 
            "                           ", "]"}], ";", "\[IndentingNewLine]", 
           "                          ", 
           RowBox[{"testop", "=", 
            RowBox[{"testop", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]", 
         "                         ", "]"}], ";", "\[IndentingNewLine]", 
        "            ", 
        RowBox[{"If", "[", 
         RowBox[{
         "new", ",", "\[IndentingNewLine]", "                          ", 
          RowBox[{
           RowBox[{"ngroup", "=", 
            RowBox[{"ngroup", "+", "1"}]}], ";", "\[IndentingNewLine]", 
           "                          ", 
           RowBox[{
            RowBox[{"R", "[", "ngroup", "]"}], "=", "Rnew"}], ";", 
           "\[IndentingNewLine]", "                          ", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<R[\>\"", ",", "ngroup", ",", "\"\<]=\>\"", ",", 
             RowBox[{"Chop", "[", 
              RowBox[{"N", "[", 
               RowBox[{"R", "[", "ngroup", "]"}], "]"}], "]"}]}], "]"}], ";", 
           "\[IndentingNewLine]", "                          ", 
           RowBox[{"Print", "[", 
            RowBox[{"\"\<ngroup=\>\"", ",", "ngroup"}], "]"}], ";", 
           "\[IndentingNewLine]", "                          ", 
           RowBox[{"FirstOperation", "=", "1"}], ";", "\[IndentingNewLine]", 
           "                          ", 
           RowBox[{"SecondOperation", "=", "0"}]}], ","}], 
         "\[IndentingNewLine]", "                ", "]"}], ";", " ", 
        "\[IndentingNewLine]", "               ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ngroup", ">", "125"}], ",", 
          RowBox[{"Goto", "[", "junk", "]"}], ","}], "]"}], ";", 
        "\[IndentingNewLine]", "        ", 
        RowBox[{"SecondOperation", "=", 
         RowBox[{"SecondOperation", "+", "1"}]}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", "      ", 
     RowBox[{"FirstOperation", "=", 
      RowBox[{"FirstOperation", "+", "1"}]}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.436087362190903*^9, 3.436087366516582*^9}, {
   3.436087444201408*^9, 3.43608759750073*^9}, {3.436089895638327*^9, 
   3.436089919396312*^9}, {3.436089985605849*^9, 3.436090279110622*^9}, {
   3.436090342464579*^9, 3.436090399093755*^9}, 3.436090433940231*^9, {
   3.436090466004328*^9, 3.436090624539181*^9}, {3.436090658908407*^9, 
   3.436090701488853*^9}, {3.436090763503882*^9, 3.436090821890008*^9}, {
   3.436090988711989*^9, 3.436091003921238*^9}, {3.436091052730779*^9, 
   3.436091146050983*^9}, {3.436091306652562*^9, 3.436091307757552*^9}, {
   3.43609137565529*^9, 3.436091426690929*^9}, 3.43609152916584*^9, {
   3.436091616378984*^9, 3.43609161852117*^9}, {3.436091681618275*^9, 
   3.436091922956782*^9}, {3.436092021293244*^9, 3.436092021873238*^9}, {
   3.436092056055727*^9, 3.436092072291895*^9}, {3.436092102379013*^9, 
   3.43609213779925*^9}, {3.436092195287632*^9, 3.436092222149046*^9}, {
   3.4360922571378*^9, 3.43609227221027*^9}, {3.436098222894315*^9, 
   3.436098223160854*^9}, 3.436098387519473*^9, {3.436098736314841*^9, 
   3.436098790413844*^9}, {3.436106077115126*^9, 3.436106089689814*^9}, {
   3.438693024794908*^9, 3.438693026358067*^9}, {3.438693066088748*^9, 
   3.438693070708322*^9}, {3.438693148098955*^9, 3.4386931637537193`*^9}, {
   3.438693233018346*^9, 3.4386932421670847`*^9}, {3.440326146637179*^9, 
   3.4403261468720417`*^9}, {3.440326247730138*^9, 3.4403262490372887`*^9}, {
   3.4685795505024443`*^9, 3.468579550988241*^9}, {3.468580118827353*^9, 
   3.468580119204934*^9}, {3.4685802514058933`*^9, 3.468580252384327*^9}, {
   3.4685806282891483`*^9, 3.468580628632101*^9}, {3.4685809775082903`*^9, 
   3.468580978905241*^9}, {3.46858106975484*^9, 3.46858107134866*^9}, {
   3.468590448361877*^9, 3.468590448717676*^9}, {3.468590563240752*^9, 
   3.468590563641543*^9}, {3.4685908760754747`*^9, 3.468590876516329*^9}, {
   3.468591135708997*^9, 3.468591136224784*^9}, {3.46859125952326*^9, 
   3.468591259858054*^9}, {3.468591295161263*^9, 3.468591295948201*^9}, {
   3.468591366043297*^9, 3.468591378906415*^9}, {3.468591446173153*^9, 
   3.468591446789205*^9}, {3.4685915119941177`*^9, 3.4685915125493307`*^9}, {
   3.468591632148521*^9, 3.468591632596133*^9}, {3.468591679029401*^9, 
   3.468591679505088*^9}, {3.468592875267432*^9, 3.468592875734894*^9}, {
   3.468593141170319*^9, 3.4685931416105137`*^9}, {3.4692848240729094`*^9, 
   3.469284824388776*^9}, {3.4695132402870903`*^9, 3.4695132405645647`*^9}, {
   3.4695135112261763`*^9, 3.4695135116368217`*^9}, {3.469513654681916*^9, 
   3.4695136552570133`*^9}, {3.469513707374599*^9, 3.469513707830212*^9}, {
   3.4695138355180407`*^9, 3.469513835934929*^9}, {3.469514004998012*^9, 
   3.469514005343671*^9}, {3.4695140488811617`*^9, 3.469514049276165*^9}, {
   3.469514449703576*^9, 3.469514450100425*^9}, {3.4695145786546164`*^9, 
   3.46951457899895*^9}, {3.469514734277238*^9, 3.469514734732308*^9}, {
   3.469516165309795*^9, 3.469516165718581*^9}, {3.4695162862921743`*^9, 
   3.4695162866094723`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1.`"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]}],
  SequenceForm["R[", 3, "]=", {{0, -1., 0}, {1., 0, 0}, {0, 0, 1.}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601228846*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ngroup=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["ngroup=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601264617*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865474`"}], ",", 
       RowBox[{"-", "0.7071067811865477`"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7071067811865477`", ",", 
       RowBox[{"-", "0.7071067811865474`"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1.`"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "R[", 4, "]=", {{-0.7071067811865474, -0.7071067811865477, 0}, {
    0.7071067811865477, -0.7071067811865474, 0}, {0, 0, -1.}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.4695166012997417`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ngroup=\"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["ngroup=", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601337391*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1.`"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]}],
  SequenceForm["R[", 5, "]=", {{-1., 0, 0}, {0, -1., 0}, {0, 0, 1.}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601375696*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ngroup=\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["ngroup=", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601416123*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865478`"}], ",", "0.7071067811865472`", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865472`"}], ",", 
       RowBox[{"-", "0.7071067811865478`"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1.`"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "R[", 6, "]=", {{-0.7071067811865478, 0.7071067811865472, 
     0}, {-0.7071067811865472, -0.7071067811865478, 0}, {0, 0, -1.}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601456983*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ngroup=\"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["ngroup=", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.4695166014994783`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]}],
  SequenceForm["R[", 7, "]=", {{0, 1., 0}, {-1., 0, 0}, {0, 0, 1.}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601625608*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ngroup=\"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["ngroup=", 7],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601669765*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865471`", ",", "0.7071067811865479`", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7071067811865479`"}], ",", "0.7071067811865471`", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1.`"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "R[", 8, "]=", {{
    0.7071067811865471, 0.7071067811865479, 0}, {-0.7071067811865479, 
     0.7071067811865471, 0}, {0, 0, -1.}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601714312*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ngroup=\"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["ngroup=", 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.469514735649983*^9, 3.469514773150979*^9, 
  3.469516094118711*^9, 3.469516166634758*^9, 3.4695162392632513`*^9, 
  3.469516294512109*^9, 3.469516368490758*^9, 3.4695165112314663`*^9, 
  3.469516565539318*^9, 3.469516601761548*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FirstOperation", "=", "1"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"FirstOperation", "<", 
     RowBox[{"ngroup", "+", "1"}]}], ",", "       ", "\[IndentingNewLine]", 
    "         ", 
    RowBox[{
     RowBox[{"SecondOperation", "=", "1"}], ";", "\[IndentingNewLine]", 
     "         ", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"SecondOperation", "<", 
        RowBox[{"ngroup", "+", "1"}]}], ",", "\[IndentingNewLine]", 
       "             ", 
       RowBox[{
        RowBox[{"Rnew", "=", 
         RowBox[{
          RowBox[{"R", "[", "FirstOperation", "]"}], ".", 
          RowBox[{"R", "[", "SecondOperation", "]"}]}]}], ";", 
        "\[IndentingNewLine]", "             ", 
        RowBox[{"new", "=", "True"}], ";", " ", 
        RowBox[{"testop", "=", "1"}], ";", "\[IndentingNewLine]", 
        "             ", 
        RowBox[{"While", "[", 
         RowBox[{
          RowBox[{"new", " ", "&&", " ", 
           RowBox[{"testop", " ", "<", " ", 
            RowBox[{"ngroup", "+", "1"}]}]}], ",", "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{
           RowBox[{"If", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Sum", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Rnew", "[", 
                    RowBox[{"[", "j1", "]"}], "]"}], "[", 
                    RowBox[{"[", "j2", "]"}], "]"}], "-", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"R", "[", "testop", "]"}], "[", 
                    RowBox[{"[", "j1", "]"}], "]"}], "[", 
                    RowBox[{"[", "j2", "]"}], "]"}]}], ")"}], "^", "2"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j1", ",", "1", ",", "3"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j2", ",", "1", ",", "3"}], "}"}]}], "]"}], "<", 
              "0.000001"}], ",", "      ", "\[IndentingNewLine]", 
             "                                     ", 
             RowBox[{
              RowBox[{"new", "=", "False"}], ";", "\[IndentingNewLine]", 
              "   ", 
              RowBox[{
               RowBox[{"prod", "[", 
                RowBox[{"FirstOperation", ",", "SecondOperation"}], "]"}], 
               "=", "testop"}]}], ","}], "\[IndentingNewLine]", 
            "                           ", "]"}], ";", "\[IndentingNewLine]", 
           "                          ", 
           RowBox[{"testop", "=", 
            RowBox[{"testop", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]", 
         "                         ", "]"}], ";", "\[IndentingNewLine]", 
        "            ", 
        RowBox[{"If", "[", 
         RowBox[{
         "new", ",", "\[IndentingNewLine]", "                          ", 
          RowBox[{
           RowBox[{"Print", "[", "\"\<ERROR\>\"", "]"}], ";", 
           "\[IndentingNewLine]", "                          ", 
           RowBox[{"Goto", "[", "junk", "]"}]}], ","}], "\[IndentingNewLine]",
          "                ", "]"}], ";", "\[IndentingNewLine]", "        ", 
        RowBox[{"SecondOperation", "=", 
         RowBox[{"SecondOperation", "+", "1"}]}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", "      ", 
     RowBox[{"FirstOperation", "=", 
      RowBox[{"FirstOperation", "+", "1"}]}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.436087362190903*^9, 3.436087366516582*^9}, {
   3.436087444201408*^9, 3.43608759750073*^9}, {3.436089895638327*^9, 
   3.436089919396312*^9}, {3.436089985605849*^9, 3.436090279110622*^9}, {
   3.436090342464579*^9, 3.436090399093755*^9}, 3.436090433940231*^9, {
   3.436090466004328*^9, 3.436090624539181*^9}, {3.436090658908407*^9, 
   3.436090701488853*^9}, {3.436090763503882*^9, 3.436090821890008*^9}, {
   3.436090988711989*^9, 3.436091003921238*^9}, {3.436091052730779*^9, 
   3.436091146050983*^9}, {3.436091306652562*^9, 3.436091307757552*^9}, {
   3.43609137565529*^9, 3.436091426690929*^9}, 3.43609152916584*^9, {
   3.436091616378984*^9, 3.43609161852117*^9}, {3.436091681618275*^9, 
   3.436091922956782*^9}, {3.436092021293244*^9, 3.436092021873238*^9}, {
   3.436092056055727*^9, 3.436092072291895*^9}, {3.436092102379013*^9, 
   3.43609213779925*^9}, {3.436092195287632*^9, 3.436092222149046*^9}, {
   3.4360922571378*^9, 3.43609227221027*^9}, {3.436098222894315*^9, 
   3.436098223160854*^9}, {3.436098272146605*^9, 3.43609847024062*^9}, {
   3.436098811673486*^9, 3.436098812385979*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"products", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"prod", "[", 
      RowBox[{"j1", ",", "j2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j1", ",", "1", ",", "ngroup"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j2", ",", "1", ",", "ngroup"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.436098572962016*^9, 3.436098641771045*^9}, {
   3.436098819959092*^9, 3.436098874936814*^9}, 3.436106119659409*^9, {
   3.468580264048669*^9, 3.468580265645425*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"j1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", " ", "[", 
  RowBox[{"\"\<  \>\"", ",", 
   RowBox[{"products", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"j1", "=", "1"}], ",", 
   RowBox[{"j1", "<", 
    RowBox[{"ngroup", "+", "1"}]}], ",", 
   RowBox[{"j1", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"j1", ",", "\"\< \>\"", ",", 
     RowBox[{"products", "[", 
      RowBox[{"[", "j1", "]"}], "]"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.436098887070632*^9, 3.436098915326525*^9}, {
  3.436099088254203*^9, 3.436099103382809*^9}, {3.436103779325726*^9, 
  3.436103868917112*^9}, {3.436106141884745*^9, 3.436106152869813*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}]}],
  SequenceForm["  ", {1, 2, 3, 4, 5, 6, 7, 8}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516613696859*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
     "8"}], "}"}]}],
  SequenceForm[1, " ", {1, 2, 3, 4, 5, 6, 7, 8}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516613733385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", 
     "1"}], "}"}]}],
  SequenceForm[2, " ", {2, 3, 4, 5, 6, 7, 8, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516613778224*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "1", ",", 
     "2"}], "}"}]}],
  SequenceForm[3, " ", {3, 4, 5, 6, 7, 8, 1, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.46951661382397*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "1", ",", "2", ",", 
     "3"}], "}"}]}],
  SequenceForm[4, " ", {4, 5, 6, 7, 8, 1, 2, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516613870874*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "6", ",", "7", ",", "8", ",", "1", ",", "2", ",", "3", ",", 
     "4"}], "}"}]}],
  SequenceForm[5, " ", {5, 6, 7, 8, 1, 2, 3, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.4695166139197493`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "7", ",", "8", ",", "1", ",", "2", ",", "3", ",", "4", ",", 
     "5"}], "}"}]}],
  SequenceForm[6, " ", {6, 7, 8, 1, 2, 3, 4, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516613968083*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "7", ",", "8", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", 
     "6"}], "}"}]}],
  SequenceForm[7, " ", {7, 8, 1, 2, 3, 4, 5, 6}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516614111088*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", 
     "7"}], "}"}]}],
  SequenceForm[8, " ", {8, 1, 2, 3, 4, 5, 6, 7}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.468580172110796*^9, 3.468580268901574*^9, 3.4685805643445387`*^9, 
   3.46858064645735*^9, 3.4685809921006308`*^9, 3.468581083952239*^9, 
   3.4685904631679153`*^9, 3.468590736121274*^9, 3.4685908366237288`*^9, 
   3.468590905108775*^9, 3.468592038231*^9, 3.4685932578234043`*^9, 
   3.469284834593625*^9, 3.469513259470244*^9, 3.46951330997565*^9, 
   3.469513390758827*^9, 3.469513535157441*^9, 3.469513612196537*^9, 
   3.4695136656458673`*^9, 3.469513720443637*^9, 3.4695137634287767`*^9, 
   3.4695138094716587`*^9, 3.469513906688324*^9, 3.469513970708487*^9, 
   3.469514013670033*^9, 3.469514057965271*^9, 3.469514145813746*^9, 
   3.4695141853262053`*^9, 3.469514333413485*^9, 3.469514376612298*^9, 
   3.469514471808779*^9, 3.469514532707488*^9, 3.469514586851492*^9, 
   3.469514641654151*^9, 3.469514689384304*^9, {3.4695147518416157`*^9, 
   3.469514781315632*^9}, 3.469516101415724*^9, 3.469516174925672*^9, 
   3.469516250687223*^9, 3.4695163762863827`*^9, 3.469516525009727*^9, 
   3.46951657563268*^9, 3.469516614161531*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"j1", "=", "1"}], ",", 
   RowBox[{"j1", "<", 
    RowBox[{"ngroup", "+", "1"}]}], ",", 
   RowBox[{"j1", "++"}], ",", 
   RowBox[{
    RowBox[{"R", "[", 
     RowBox[{"j1", "+", "ngroup"}], "]"}], "=", 
    RowBox[{"Inverse", "[", 
     RowBox[{"R", "[", "j1", "]"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.468578354924588*^9, 3.468578389687417*^9}, 
   3.468581095374935*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"outfile", "=", 
  RowBox[{"OpenWrite", "[", 
   RowBox[{"\"\<S8.ops\>\"", ",", 
    RowBox[{"FormatType", "\[Rule]", "OutputForm"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"j1", "=", "1"}], ",", 
    RowBox[{"j1", "<", 
     RowBox[{
      RowBox[{"2", "*", "ngroup"}], "+", "1"}]}], ",", 
    RowBox[{"j1", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Write", "[", 
      RowBox[{"outfile", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "12"}], "]"}], "]"}], ",", 
       "\"\<,  \>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "12"}], "]"}], " ", "]"}], 
       ",", "\"\<,  \>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", "12"}], "]"}], " ", "]"}], 
       ",", "\"\<,  \>\""}], "]"}], " ", "\[IndentingNewLine]", 
     RowBox[{"Write", "[", 
      RowBox[{"outfile", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "12"}], "]"}], "]"}], ",", 
       "\"\<,  \>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "12"}], "]"}], " ", "]"}], 
       ",", "\"\<,  \>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", "12"}], "]"}], " ", "]"}], 
       ",", "\"\<,  \>\""}], "]"}], " ", "\[IndentingNewLine]", 
     RowBox[{"Write", "[", 
      RowBox[{"outfile", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "12"}], "]"}], "]"}], ",", 
       "\"\<,  \>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "12"}], "]"}], " ", "]"}], 
       ",", "\"\<,  \>\"", ",", "\[IndentingNewLine]", 
       RowBox[{"Chop", "[", 
        RowBox[{"N", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"R", "[", "j1", "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", "12"}], "]"}], " ", "]"}], 
       " ", ",", "\"\<,  \>\""}], "]"}]}]}], " ", "]"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"Close", "[", "outfile", "]"}]}], "Input",
 CellChangeTimes->{{3.438693867296741*^9, 3.438693950736269*^9}, {
   3.438693985404985*^9, 3.438694232349947*^9}, {3.438694347032968*^9, 
   3.4386943521311083`*^9}, 3.4386943917961283`*^9, {3.438694502339602*^9, 
   3.438694510959639*^9}, {3.438694542914859*^9, 3.438694547982279*^9}, {
   3.440326355921254*^9, 3.4403263562668343`*^9}, {3.440340057778612*^9, 
   3.440340066439848*^9}, {3.468578143462657*^9, 3.4685782335163317`*^9}, {
   3.4685783349331083`*^9, 3.468578337715934*^9}, {3.468578448265957*^9, 
   3.468578448751256*^9}, {3.4685785160171337`*^9, 3.468578547863693*^9}, {
   3.468578581716339*^9, 3.468578606753788*^9}, {3.468578752843212*^9, 
   3.468578809013517*^9}, {3.4685791365151978`*^9, 3.468579205252783*^9}, {
   3.468579280757483*^9, 3.4685793064358597`*^9}, {3.468579377324525*^9, 
   3.468579377963077*^9}, {3.468579414046604*^9, 3.46857941731524*^9}, 
   3.46857979604423*^9, {3.468580188750351*^9, 3.468580189585414*^9}, 
   3.4685802792383413`*^9, {3.468580577322404*^9, 3.4685805781112337`*^9}, 
   3.468580656906115*^9, {3.4685810123451014`*^9, 3.468581014106085*^9}, 
   3.468581100022964*^9, 3.4685904855765944`*^9, 3.468590609395919*^9, {
   3.468590742135244*^9, 3.4685907462889643`*^9}, {3.468590843160943*^9, 
   3.4685908448020267`*^9}, 3.468590912527008*^9, {3.4685920454343777`*^9, 
   3.4685920457738256`*^9}, {3.469284841886108*^9, 3.469284843307551*^9}, {
   3.46951326650175*^9, 3.469513266910821*^9}, {3.469513317672694*^9, 
   3.469513319550446*^9}, {3.469513396821698*^9, 3.469513397209293*^9}, {
   3.46951354786509*^9, 3.4695135483391113`*^9}, {3.469513617497428*^9, 
   3.4695136178188543`*^9}, {3.4695136705923147`*^9, 3.469513671788455*^9}, {
   3.469513725947632*^9, 3.469513726392336*^9}, {3.469513770824395*^9, 
   3.469513773223721*^9}, {3.469513814189436*^9, 3.469513814598699*^9}, {
   3.469513914137898*^9, 3.469513914583981*^9}, {3.469513978321685*^9, 
   3.469513978655991*^9}, {3.4695140176141033`*^9, 3.469514018996737*^9}, {
   3.46951406923945*^9, 3.469514069681172*^9}, {3.469514192251693*^9, 
   3.469514194463895*^9}, {3.4695143404352503`*^9, 3.4695143409073143`*^9}, {
   3.4695143826917152`*^9, 3.469514383182479*^9}, {3.469514480105372*^9, 
   3.4695144825937*^9}, {3.469514541388571*^9, 3.4695145417054*^9}, {
   3.4695145929718637`*^9, 3.4695145946719522`*^9}, {3.469514648826564*^9, 
   3.469514649474077*^9}, {3.469514694497369*^9, 3.469514694902898*^9}, {
   3.469514756746963*^9, 3.469514787609252*^9}, {3.469516106672021*^9, 
   3.469516107633555*^9}, {3.469516180799294*^9, 3.469516182559628*^9}, {
   3.469516256184416*^9, 3.4695162566234207`*^9}, {3.4695163810824614`*^9, 
   3.469516382357078*^9}, {3.4695165310676126`*^9, 3.469516532183565*^9}, {
   3.469516580424065*^9, 3.469516580902685*^9}, {3.4695166186476717`*^9, 
   3.469516619091001*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"S8.ops\"\>", ",", "51"}], "]"}]], "Output",
 CellChangeTimes->{
  3.468579315934026*^9, 3.468579378856759*^9, 3.468579445742694*^9, 
   3.468579798684825*^9, 3.468580194129025*^9, 3.468580280125898*^9, 
   3.468580579257523*^9, 3.468580658540245*^9, 3.468581015233115*^9, 
   3.468581101088632*^9, {3.468590478985511*^9, 3.468590487920907*^9}, 
   3.468590610226411*^9, 3.468590747418716*^9, {3.468590846036683*^9, 
   3.468590852557612*^9}, 3.4685909157998238`*^9, 3.46859205051797*^9, 
   3.468593265894782*^9, 3.469284845263692*^9, 3.469513267982626*^9, 
   3.469513320274713*^9, 3.469513397867128*^9, 3.469513549237749*^9, 
   3.469513618667465*^9, 3.469513672833413*^9, 3.469513728972823*^9, 
   3.469513774693986*^9, 3.469513815309393*^9, 3.46951391546397*^9, 
   3.469513979146122*^9, 3.469514024424223*^9, 3.4695140704487133`*^9, 
   3.469514150508024*^9, 3.469514195312624*^9, {3.469514337147296*^9, 
   3.469514347838438*^9}, 3.46951438403329*^9, 3.4695144832511377`*^9, 
   3.469514542035096*^9, 3.469514595473723*^9, 3.4695146501940002`*^9, 
   3.4695146952166853`*^9, {3.4695147583368893`*^9, 3.46951478827601*^9}, 
   3.469516108925054*^9, 3.469516184756967*^9, 3.469516259218589*^9, 
   3.4695163830756407`*^9, 3.469516533079865*^9, 3.469516582036963*^9, 
   3.4695166197075033`*^9}],

Cell[BoxData["\<\"S8.ops\"\>"], "Output",
 CellChangeTimes->{
  3.468579315934026*^9, 3.468579378856759*^9, 3.468579445742694*^9, 
   3.468579798684825*^9, 3.468580194129025*^9, 3.468580280125898*^9, 
   3.468580579257523*^9, 3.468580658540245*^9, 3.468581015233115*^9, 
   3.468581101088632*^9, {3.468590478985511*^9, 3.468590487920907*^9}, 
   3.468590610226411*^9, 3.468590747418716*^9, {3.468590846036683*^9, 
   3.468590852557612*^9}, 3.4685909157998238`*^9, 3.46859205051797*^9, 
   3.468593265894782*^9, 3.469284845263692*^9, 3.469513267982626*^9, 
   3.469513320274713*^9, 3.469513397867128*^9, 3.469513549237749*^9, 
   3.469513618667465*^9, 3.469513672833413*^9, 3.469513728972823*^9, 
   3.469513774693986*^9, 3.469513815309393*^9, 3.46951391546397*^9, 
   3.469513979146122*^9, 3.469514024424223*^9, 3.4695140704487133`*^9, 
   3.469514150508024*^9, 3.469514195312624*^9, {3.469514337147296*^9, 
   3.469514347838438*^9}, 3.46951438403329*^9, 3.4695144832511377`*^9, 
   3.469514542035096*^9, 3.469514595473723*^9, 3.4695146501940002`*^9, 
   3.4695146952166853`*^9, {3.4695147583368893`*^9, 3.46951478827601*^9}, 
   3.469516108925054*^9, 3.469516184756967*^9, 3.469516259218589*^9, 
   3.4695163830756407`*^9, 3.469516533079865*^9, 3.469516582036963*^9, 
   3.469516619743256*^9}]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1016, 742},
WindowMargins->{{Automatic, 1}, {9, Automatic}},
ShowSelection->True,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 916, 27, 374, "Input",
 InitializationCell->True],
Cell[1486, 51, 585, 18, 56, "Output"],
Cell[2074, 71, 717, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2828, 99, 622, 17, 32, "Input"],
Cell[3453, 118, 492, 13, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3982, 136, 317, 8, 32, "Input"],
Cell[4302, 146, 542, 18, 56, "Output"]
}, Open  ]],
Cell[4859, 167, 200, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[5084, 175, 3688, 102, 165, "Input"],
Cell[8775, 279, 1608, 59, 56, "Output"],
Cell[10386, 340, 1613, 59, 84, "Output"],
Cell[12002, 401, 479, 14, 31, "Output"]
}, Open  ]],
Cell[12496, 418, 12725, 324, 583, "Input"],
Cell[25224, 744, 1191, 25, 139, "Text"],
Cell[CellGroupData[{
Cell[26440, 773, 7541, 145, 583, "Input"],
Cell[CellGroupData[{
Cell[34006, 922, 780, 18, 24, "Print"],
Cell[34789, 942, 403, 8, 24, "Print"],
Cell[35195, 952, 996, 23, 24, "Print"],
Cell[36194, 977, 403, 8, 24, "Print"],
Cell[36600, 987, 804, 19, 24, "Print"],
Cell[37407, 1008, 403, 8, 24, "Print"],
Cell[37813, 1018, 1003, 24, 24, "Print"],
Cell[38819, 1044, 405, 8, 24, "Print"],
Cell[39227, 1054, 780, 18, 24, "Print"],
Cell[40010, 1074, 403, 8, 24, "Print"],
Cell[40416, 1084, 967, 24, 24, "Print"],
Cell[41386, 1110, 403, 8, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[41816, 1122, 4719, 100, 473, "Input"],
Cell[46538, 1224, 534, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[47097, 1242, 804, 19, 99, "Input"],
Cell[CellGroupData[{
Cell[47926, 1265, 1348, 24, 24, "Print"],
Cell[49277, 1291, 1375, 24, 24, "Print"],
Cell[50655, 1317, 1375, 24, 24, "Print"],
Cell[52033, 1343, 1374, 24, 24, "Print"],
Cell[53410, 1369, 1375, 24, 24, "Print"],
Cell[54788, 1395, 1377, 24, 24, "Print"],
Cell[56168, 1421, 1375, 24, 24, "Print"],
Cell[57546, 1447, 1375, 24, 24, "Print"],
Cell[58924, 1473, 1375, 24, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[60326, 1501, 446, 13, 32, "Input"],
Cell[CellGroupData[{
Cell[60797, 1518, 6706, 142, 341, "Input"],
Cell[67506, 1662, 1358, 21, 31, "Output"],
Cell[68867, 1685, 1294, 19, 31, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
