elements = {}
elements[  0] = elements[ 'Xx'] = {'symbol':  'Xx', 'name':       'unknown', 'mass':   1.00000000, 'radius':  1.0000, 'color': [1.000, 0.078, 0.576]}
elements[  1] = elements[  'H'] = {'symbol':   'H', 'name':      'hydrogen', 'mass':   1.00794000, 'radius':  1.2000, 'color': [1.000, 1.000, 1.000]}
elements[  2] = elements[ 'He'] = {'symbol':  'He', 'name':        'helium', 'mass':   4.00260200, 'radius':  1.4000, 'color': [0.851, 1.000, 1.000]}
elements[  3] = elements[ 'Li'] = {'symbol':  'Li', 'name':       'lithium', 'mass':   6.94100000, 'radius':  1.8200, 'color': [0.800, 0.502, 1.000]}
elements[  4] = elements[ 'Be'] = {'symbol':  'Be', 'name':     'beryllium', 'mass':   9.01218200, 'radius':  1.7000, 'color': [0.761, 1.000, 0.000]}
elements[  5] = elements[  'B'] = {'symbol':   'B', 'name':         'boron', 'mass':  10.81100000, 'radius':  2.0800, 'color': [1.000, 0.710, 0.710]}
elements[  6] = elements[  'C'] = {'symbol':   'C', 'name':        'carbon', 'mass':  12.01070000, 'radius':  1.9500, 'color': [0.565, 0.565, 0.565]}
elements[  7] = elements[  'N'] = {'symbol':   'N', 'name':      'nitrogen', 'mass':  14.00670000, 'radius':  1.8500, 'color': [0.188, 0.314, 0.973]}
elements[  8] = elements[  'O'] = {'symbol':   'O', 'name':        'oxygen', 'mass':  15.99940000, 'radius':  1.7000, 'color': [1.000, 0.051, 0.051]}
elements[  9] = elements[  'F'] = {'symbol':   'F', 'name':      'fluorine', 'mass':  18.99840320, 'radius':  1.7300, 'color': [0.565, 0.878, 0.314]}
elements[ 10] = elements[ 'Ne'] = {'symbol':  'Ne', 'name':          'neon', 'mass':  20.17970000, 'radius':  1.5400, 'color': [0.702, 0.890, 0.961]}
elements[ 11] = elements[ 'Na'] = {'symbol':  'Na', 'name':        'sodium', 'mass':  22.98976928, 'radius':  2.2700, 'color': [0.671, 0.361, 0.949]}
elements[ 12] = elements[ 'Mg'] = {'symbol':  'Mg', 'name':     'magnesium', 'mass':  24.30500000, 'radius':  1.7300, 'color': [0.541, 1.000, 0.000]}
elements[ 13] = elements[ 'Al'] = {'symbol':  'Al', 'name':      'aluminum', 'mass':  26.98153860, 'radius':  2.0500, 'color': [0.749, 0.651, 0.651]}
elements[ 14] = elements[ 'Si'] = {'symbol':  'Si', 'name':       'silicon', 'mass':  28.08550000, 'radius':  2.1000, 'color': [0.941, 0.784, 0.627]}
elements[ 15] = elements[  'P'] = {'symbol':   'P', 'name':    'phosphorus', 'mass':  30.97376200, 'radius':  2.0800, 'color': [1.000, 0.502, 0.000]}
elements[ 16] = elements[  'S'] = {'symbol':   'S', 'name':        'sulfur', 'mass':  32.06500000, 'radius':  2.0000, 'color': [1.000, 1.000, 0.188]}
elements[ 17] = elements[ 'Cl'] = {'symbol':  'Cl', 'name':      'chlorine', 'mass':  35.45300000, 'radius':  1.9700, 'color': [0.122, 0.941, 0.122]}
elements[ 18] = elements[ 'Ar'] = {'symbol':  'Ar', 'name':         'argon', 'mass':  39.94800000, 'radius':  1.8800, 'color': [0.502, 0.820, 0.890]}
elements[ 19] = elements[  'K'] = {'symbol':   'K', 'name':     'potassium', 'mass':  39.09830000, 'radius':  2.7500, 'color': [0.561, 0.251, 0.831]}
elements[ 20] = elements[ 'Ca'] = {'symbol':  'Ca', 'name':       'calcium', 'mass':  40.07800000, 'radius':  1.9730, 'color': [0.239, 1.000, 0.000]}
elements[ 21] = elements[ 'Sc'] = {'symbol':  'Sc', 'name':      'scandium', 'mass':  44.95591200, 'radius':  1.7000, 'color': [0.902, 0.902, 0.902]}
elements[ 22] = elements[ 'Ti'] = {'symbol':  'Ti', 'name':      'titanium', 'mass':  47.86700000, 'radius':  1.7000, 'color': [0.749, 0.761, 0.780]}
elements[ 23] = elements[  'V'] = {'symbol':   'V', 'name':      'vanadium', 'mass':  50.94150000, 'radius':  1.7000, 'color': [0.651, 0.651, 0.671]}
elements[ 24] = elements[ 'Cr'] = {'symbol':  'Cr', 'name':      'chromium', 'mass':  51.99610000, 'radius':  1.7000, 'color': [0.541, 0.600, 0.780]}
elements[ 25] = elements[ 'Mn'] = {'symbol':  'Mn', 'name':     'manganese', 'mass':  54.93804500, 'radius':  1.7000, 'color': [0.611, 0.478, 0.780]}
elements[ 26] = elements[ 'Fe'] = {'symbol':  'Fe', 'name':          'iron', 'mass':  55.84500000, 'radius':  1.7000, 'color': [0.878, 0.400, 0.200]}
elements[ 27] = elements[ 'Co'] = {'symbol':  'Co', 'name':        'cobalt', 'mass':  58.69340000, 'radius':  1.7000, 'color': [0.941, 0.565, 0.627]}
elements[ 28] = elements[ 'Ni'] = {'symbol':  'Ni', 'name':        'nickel', 'mass':  58.93319500, 'radius':  1.6300, 'color': [0.314, 0.816, 0.314]}
elements[ 29] = elements[ 'Cu'] = {'symbol':  'Cu', 'name':        'copper', 'mass':  63.54600000, 'radius':  1.4000, 'color': [0.784, 0.502, 0.200]}
elements[ 30] = elements[ 'Zn'] = {'symbol':  'Zn', 'name':          'zinc', 'mass':  65.38000000, 'radius':  1.3900, 'color': [0.490, 0.502, 0.690]}
elements[ 31] = elements[ 'Ga'] = {'symbol':  'Ga', 'name':       'gallium', 'mass':  69.72300000, 'radius':  1.8700, 'color': [0.761, 0.561, 0.561]}
elements[ 32] = elements[ 'Ge'] = {'symbol':  'Ge', 'name':     'germanium', 'mass':  72.64000000, 'radius':  1.7000, 'color': [0.400, 0.561, 0.561]}
elements[ 33] = elements[ 'As'] = {'symbol':  'As', 'name':       'arsenic', 'mass':  74.92160000, 'radius':  1.8500, 'color': [0.741, 0.502, 0.890]}
elements[ 34] = elements[ 'Se'] = {'symbol':  'Se', 'name':      'selenium', 'mass':  78.96000000, 'radius':  1.9000, 'color': [1.000, 0.631, 0.000]}
elements[ 35] = elements[ 'Br'] = {'symbol':  'Br', 'name':       'bromine', 'mass':  79.90400000, 'radius':  2.1000, 'color': [0.651, 0.161, 0.161]}
elements[ 36] = elements[ 'Kr'] = {'symbol':  'Kr', 'name':       'krypton', 'mass':  83.79800000, 'radius':  2.0200, 'color': [0.361, 0.722, 0.820]}
elements[ 37] = elements[ 'Rb'] = {'symbol':  'Rb', 'name':      'rubidium', 'mass':  85.46780000, 'radius':  1.7000, 'color': [0.439, 0.180, 0.690]}
elements[ 38] = elements[ 'Sr'] = {'symbol':  'Sr', 'name':     'strontium', 'mass':  87.62000000, 'radius':  1.7000, 'color': [0.000, 1.000, 0.000]}
elements[ 39] = elements[  'Y'] = {'symbol':   'Y', 'name':       'yttrium', 'mass':  88.90585000, 'radius':  1.7000, 'color': [0.580, 1.000, 1.000]}
elements[ 40] = elements[ 'Zr'] = {'symbol':  'Zr', 'name':     'zirconium', 'mass':  91.22400000, 'radius':  1.7000, 'color': [0.580, 0.878, 0.878]}
elements[ 41] = elements[ 'Nb'] = {'symbol':  'Nb', 'name':       'niobium', 'mass':  92.90638000, 'radius':  1.7000, 'color': [0.451, 0.761, 0.788]}
elements[ 42] = elements[ 'Mo'] = {'symbol':  'Mo', 'name':    'molybdenum', 'mass':  95.96000000, 'radius':  1.7000, 'color': [0.329, 0.710, 0.710]}
elements[ 43] = elements[ 'Tc'] = {'symbol':  'Tc', 'name':    'technetium', 'mass':  98.00000000, 'radius':  1.7000, 'color': [0.231, 0.620, 0.620]}
elements[ 44] = elements[ 'Ru'] = {'symbol':  'Ru', 'name':     'ruthenium', 'mass': 101.07000000, 'radius':  1.7000, 'color': [0.141, 0.561, 0.561]}
elements[ 45] = elements[ 'Rh'] = {'symbol':  'Rh', 'name':       'rhodium', 'mass': 102.90550000, 'radius':  1.7000, 'color': [0.039, 0.490, 0.549]}
elements[ 46] = elements[ 'Pd'] = {'symbol':  'Pd', 'name':     'palladium', 'mass': 106.42000000, 'radius':  1.6300, 'color': [0.000, 0.412, 0.522]}
elements[ 47] = elements[ 'Ag'] = {'symbol':  'Ag', 'name':        'silver', 'mass': 107.86820000, 'radius':  1.7200, 'color': [0.753, 0.753, 0.753]}
elements[ 48] = elements[ 'Cd'] = {'symbol':  'Cd', 'name':       'cadmium', 'mass': 112.41100000, 'radius':  1.5800, 'color': [1.000, 0.851, 0.561]}
elements[ 49] = elements[ 'In'] = {'symbol':  'In', 'name':        'indium', 'mass': 114.81800000, 'radius':  1.9300, 'color': [0.651, 0.459, 0.451]}
elements[ 50] = elements[ 'Sn'] = {'symbol':  'Sn', 'name':           'tin', 'mass': 118.71000000, 'radius':  2.1700, 'color': [0.400, 0.502, 0.502]}
elements[ 51] = elements[ 'Sb'] = {'symbol':  'Sb', 'name':      'antimony', 'mass': 121.76000000, 'radius':  2.2000, 'color': [0.620, 0.388, 0.710]}
elements[ 52] = elements[ 'Te'] = {'symbol':  'Te', 'name':     'tellurium', 'mass': 127.60000000, 'radius':  2.0600, 'color': [0.831, 0.478, 0.000]}
elements[ 53] = elements[  'I'] = {'symbol':   'I', 'name':        'iodine', 'mass': 126.90470000, 'radius':  2.1500, 'color': [0.580, 0.000, 0.580]}
elements[ 54] = elements[ 'Xe'] = {'symbol':  'Xe', 'name':         'xenon', 'mass': 131.29300000, 'radius':  2.1600, 'color': [0.259, 0.620, 0.690]}
elements[ 55] = elements[ 'Cs'] = {'symbol':  'Cs', 'name':        'cesium', 'mass': 132.90545190, 'radius':  1.7000, 'color': [0.341, 0.090, 0.561]}
elements[ 56] = elements[ 'Ba'] = {'symbol':  'Ba', 'name':        'barium', 'mass': 137.32700000, 'radius':  1.7000, 'color': [0.000, 0.788, 0.000]}
elements[ 57] = elements[ 'La'] = {'symbol':  'La', 'name':     'lanthanum', 'mass': 138.90547000, 'radius':  1.7000, 'color': [0.439, 0.831, 1.000]}
elements[ 58] = elements[ 'Ce'] = {'symbol':  'Ce', 'name':        'cerium', 'mass': 140.11600000, 'radius':  1.7000, 'color': [1.000, 1.000, 0.780]}
elements[ 59] = elements[ 'Pr'] = {'symbol':  'Pr', 'name':  'praseodymium', 'mass': 140.90765000, 'radius':  1.7000, 'color': [0.851, 1.000, 0.780]}
elements[ 60] = elements[ 'Nd'] = {'symbol':  'Nd', 'name':     'neodymium', 'mass': 144.24200000, 'radius':  1.7000, 'color': [0.780, 1.000, 0.780]}
elements[ 61] = elements[ 'Pm'] = {'symbol':  'Pm', 'name':    'promethium', 'mass': 145.00000000, 'radius':  1.7000, 'color': [0.639, 1.000, 0.780]}
elements[ 62] = elements[ 'Sm'] = {'symbol':  'Sm', 'name':      'samarium', 'mass': 150.36000000, 'radius':  1.7000, 'color': [0.561, 1.000, 0.780]}
elements[ 63] = elements[ 'Eu'] = {'symbol':  'Eu', 'name':      'europium', 'mass': 151.96400000, 'radius':  1.7000, 'color': [0.380, 1.000, 0.780]}
elements[ 64] = elements[ 'Gd'] = {'symbol':  'Gd', 'name':    'gadolinium', 'mass': 157.25000000, 'radius':  1.7000, 'color': [0.271, 1.000, 0.780]}
elements[ 65] = elements[ 'Tb'] = {'symbol':  'Tb', 'name':       'terbium', 'mass': 158.92535000, 'radius':  1.7000, 'color': [0.189, 1.000, 0.780]}
elements[ 66] = elements[ 'Dy'] = {'symbol':  'Dy', 'name':    'dysprosium', 'mass': 162.50000000, 'radius':  1.7000, 'color': [0.122, 1.000, 0.780]}
elements[ 67] = elements[ 'Ho'] = {'symbol':  'Ho', 'name':       'holmium', 'mass': 164.93032000, 'radius':  1.7000, 'color': [0.000, 1.000, 0.612]}
elements[ 68] = elements[ 'Er'] = {'symbol':  'Er', 'name':        'erbium', 'mass': 167.25900000, 'radius':  1.7000, 'color': [0.000, 0.902, 0.459]}
elements[ 69] = elements[ 'Tm'] = {'symbol':  'Tm', 'name':       'thulium', 'mass': 168.93421000, 'radius':  1.7000, 'color': [0.000, 0.831, 0.322]}
elements[ 70] = elements[ 'Yb'] = {'symbol':  'Yb', 'name':     'ytterbium', 'mass': 173.05400000, 'radius':  1.7000, 'color': [0.000, 0.749, 0.220]}
elements[ 71] = elements[ 'Lu'] = {'symbol':  'Lu', 'name':      'lutetium', 'mass': 174.96680000, 'radius':  1.7000, 'color': [0.000, 0.671, 0.141]}
elements[ 72] = elements[ 'Hf'] = {'symbol':  'Hf', 'name':       'hafnium', 'mass': 178.49000000, 'radius':  1.7000, 'color': [0.302, 0.761, 1.000]}
elements[ 73] = elements[ 'Ta'] = {'symbol':  'Ta', 'name':      'tantalum', 'mass': 180.94788000, 'radius':  1.7000, 'color': [0.302, 0.651, 1.000]}
elements[ 74] = elements[  'W'] = {'symbol':   'W', 'name':      'tungsten', 'mass': 183.84000000, 'radius':  1.7000, 'color': [0.129, 0.580, 0.839]}
elements[ 75] = elements[ 'Re'] = {'symbol':  'Re', 'name':       'rhenium', 'mass': 186.20700000, 'radius':  1.7000, 'color': [0.149, 0.490, 0.671]}
elements[ 76] = elements[ 'Os'] = {'symbol':  'Os', 'name':        'osmium', 'mass': 190.23000000, 'radius':  1.7000, 'color': [0.149, 0.400, 0.588]}
elements[ 77] = elements[ 'Ir'] = {'symbol':  'Ir', 'name':       'iridium', 'mass': 192.21700000, 'radius':  1.7000, 'color': [0.090, 0.329, 0.529]}
elements[ 78] = elements[ 'Pt'] = {'symbol':  'Pt', 'name':      'platinum', 'mass': 195.08400000, 'radius':  1.7200, 'color': [0.816, 0.816, 0.878]}
elements[ 79] = elements[ 'Au'] = {'symbol':  'Au', 'name':          'gold', 'mass': 196.96656900, 'radius':  1.6600, 'color': [1.000, 0.820, 0.137]}
elements[ 80] = elements[ 'Hg'] = {'symbol':  'Hg', 'name':       'mercury', 'mass': 200.59000000, 'radius':  1.5500, 'color': [0.722, 0.722, 0.816]}
elements[ 81] = elements[ 'Tl'] = {'symbol':  'Tl', 'name':      'thallium', 'mass': 204.38330000, 'radius':  1.9600, 'color': [0.651, 0.329, 0.302]}
elements[ 82] = elements[ 'Pb'] = {'symbol':  'Pb', 'name':          'lead', 'mass': 207.20000000, 'radius':  2.0200, 'color': [0.341, 0.349, 0.380]}
elements[ 83] = elements[ 'Bi'] = {'symbol':  'Bi', 'name':       'bismuth', 'mass': 208.98040000, 'radius':  1.7000, 'color': [0.620, 0.310, 0.710]}
elements[ 84] = elements[ 'Po'] = {'symbol':  'Po', 'name':      'polonium', 'mass': 210.00000000, 'radius':  1.7000, 'color': [0.671, 0.361, 0.000]}
elements[ 85] = elements[ 'At'] = {'symbol':  'At', 'name':      'astatine', 'mass': 210.00000000, 'radius':  1.7000, 'color': [0.459, 0.310, 0.271]}
elements[ 86] = elements[ 'Rn'] = {'symbol':  'Rn', 'name':         'radon', 'mass': 220.00000000, 'radius':  1.7000, 'color': [0.259, 0.510, 0.588]}
elements[ 87] = elements[ 'Fr'] = {'symbol':  'Fr', 'name':      'francium', 'mass': 223.00000000, 'radius':  1.7000, 'color': [0.259, 0.000, 0.400]}
elements[ 88] = elements[ 'Ra'] = {'symbol':  'Ra', 'name':        'radium', 'mass': 226.00000000, 'radius':  1.7000, 'color': [0.000, 0.490, 0.000]}
elements[ 89] = elements[ 'Ac'] = {'symbol':  'Ac', 'name':      'actinium', 'mass': 227.00000000, 'radius':  1.7000, 'color': [0.439, 0.671, 0.980]}
elements[ 90] = elements[ 'Th'] = {'symbol':  'Th', 'name':       'thorium', 'mass': 231.03588000, 'radius':  1.7000, 'color': [0.000, 0.729, 1.000]}
elements[ 91] = elements[ 'Pa'] = {'symbol':  'Pa', 'name':  'protactinium', 'mass': 232.03806000, 'radius':  1.7000, 'color': [0.000, 0.631, 1.000]}
elements[ 92] = elements[  'U'] = {'symbol':   'U', 'name':       'uranium', 'mass': 237.00000000, 'radius':  1.8600, 'color': [0.000, 0.561, 1.000]}
elements[ 93] = elements[ 'Np'] = {'symbol':  'Np', 'name':     'neptunium', 'mass': 238.02891000, 'radius':  1.7000, 'color': [0.000, 0.502, 1.000]}
elements[ 94] = elements[ 'Pu'] = {'symbol':  'Pu', 'name':     'plutonium', 'mass': 243.00000000, 'radius':  1.7000, 'color': [0.000, 0.420, 1.000]}
elements[ 95] = elements[ 'Am'] = {'symbol':  'Am', 'name':     'americium', 'mass': 244.00000000, 'radius':  1.7000, 'color': [0.329, 0.361, 0.949]}
elements[ 96] = elements[ 'Cm'] = {'symbol':  'Cm', 'name':        'curium', 'mass': 247.00000000, 'radius':  1.7000, 'color': [0.471, 0.361, 0.890]}
elements[ 97] = elements[ 'Bk'] = {'symbol':  'Bk', 'name':     'berkelium', 'mass': 247.00000000, 'radius':  1.7000, 'color': [0.541, 0.310, 0.890]}
elements[ 98] = elements[ 'Cf'] = {'symbol':  'Cf', 'name':   'californium', 'mass': 251.00000000, 'radius':  1.7000, 'color': [0.631, 0.212, 0.831]}
elements[ 99] = elements[ 'Es'] = {'symbol':  'Es', 'name':   'einsteinium', 'mass': 252.00000000, 'radius':  1.7000, 'color': [0.702, 0.122, 0.831]}
elements[100] = elements[ 'Fm'] = {'symbol':  'Fm', 'name':       'fermium', 'mass': 257.00000000, 'radius':  1.7000, 'color': [0.702, 0.122, 0.729]}
elements[101] = elements[ 'Md'] = {'symbol':  'Md', 'name':   'mendelevium', 'mass': 258.00000000, 'radius':  1.7000, 'color': [0.702, 0.051, 0.651]}
elements[102] = elements[ 'No'] = {'symbol':  'No', 'name':      'nobelium', 'mass': 259.00000000, 'radius':  1.7000, 'color': [0.741, 0.051, 0.529]}
elements[103] = elements[ 'Lr'] = {'symbol':  'Lr', 'name':    'lawrencium', 'mass': 262.00000000, 'radius':  1.7000, 'color': [0.780, 0.000, 0.400]}
elements[104] = elements[ 'Rf'] = {'symbol':  'Rf', 'name': 'rutherfordium', 'mass': 261.00000000, 'radius':  1.7000, 'color': [0.800, 0.000, 0.349]}
elements[105] = elements[ 'Db'] = {'symbol':  'Db', 'name':       'dubnium', 'mass': 262.00000000, 'radius':  1.7000, 'color': [0.820, 0.000, 0.310]}
elements[106] = elements[ 'Sg'] = {'symbol':  'Sg', 'name':    'seaborgium', 'mass': 266.00000000, 'radius':  1.7000, 'color': [0.851, 0.000, 0.271]}
elements[107] = elements[ 'Bh'] = {'symbol':  'Bh', 'name':       'bohrium', 'mass': 264.00000000, 'radius':  1.7000, 'color': [0.878, 0.000, 0.220]}
elements[108] = elements[ 'Hs'] = {'symbol':  'Hs', 'name':       'hassium', 'mass': 277.00000000, 'radius':  1.7000, 'color': [0.902, 0.000, 0.180]}
elements[109] = elements[ 'Mt'] = {'symbol':  'Mt', 'name':    'meitnerium', 'mass': 268.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[110] = elements[ 'Ds'] = {'symbol':  'Ds', 'name':            'Ds', 'mass': 271.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[111] = elements['Uuu'] = {'symbol': 'Uuu', 'name':           'Uuu', 'mass': 272.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[112] = elements['Uub'] = {'symbol': 'Uub', 'name':           'Uub', 'mass': 285.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[113] = elements['Uut'] = {'symbol': 'Uut', 'name':           'Uut', 'mass': 284.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[114] = elements['Uuq'] = {'symbol': 'Uuq', 'name':           'Uuq', 'mass': 289.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[115] = elements['Uup'] = {'symbol': 'Uup', 'name':           'Uup', 'mass': 288.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[116] = elements['Uuh'] = {'symbol': 'Uuh', 'name':           'Uuh', 'mass': 292.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[117] = elements['Uus'] = {'symbol': 'Uus', 'name':           'Uus', 'mass': 294.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}
elements[118] = elements['Uuo'] = {'symbol': 'Uuo', 'name':           'Uuo', 'mass': 296.00000000, 'radius':  1.7000, 'color': [0.922, 0.000, 0.149]}

bondlengths = dict()

def set_bondlength(e1, e2, b):
    bondlengths[e1,e2]=b
    bondlengths[e2,e1]=b

set_bondlength("H",  "H" , None)
set_bondlength("O",  "O" , None)
set_bondlength("C",  "C" , 1.650000)
set_bondlength("C",  "O" , 1.550000)
set_bondlength("C",  "N" , 1.550000)
set_bondlength("C",  "H" , 1.250000)
set_bondlength("N",  "H" , 1.200000)
set_bondlength("N",  "O" , 1.550000)
set_bondlength("O",  "H" , 1.200000)
set_bondlength("C",  "F" , 1.450000)
set_bondlength("C",  "Cl", 1.950000)
set_bondlength("C",  "Br", 1.950000)
set_bondlength("N",  "N" , 1.550000)
set_bondlength("C",  "S" , 1.900000)
set_bondlength("O",  "S" , 1.500000)
set_bondlength("N",  "S" , 1.700000)
set_bondlength("B",  "F" , 1.450000)
set_bondlength("B",  "C" , 1.650000)
set_bondlength("N",  "Hg", 2.800000)
set_bondlength("I",  "Hg", 2.800000)
set_bondlength("Br", "Hg", 2.500000)
set_bondlength("C", "F",  1.6)
set_bondlength("H", "F",  0.0)
set_bondlength("F", "F",  0.0)
set_bondlength("O", "F",  0.0)
set_bondlength("N", "F",  0.0)

def lookup_element_by_mass(mass):
    mass = float(mass)
    closest_mass = min((value["mass"] for value in elements.values()), key = lambda x: abs(x - mass))
    return (value["symbol"] for value in elements.values() if value["mass"] == closest_mass).next()

if __name__ == "__main__":
    import numpy as np
    masses = np.random.uniform(low=1.0, high=150.0, size=1000)
    for mass in masses:
        element = lookup_element_by_mass(mass)
        print element, mass, elements[element]["mass"]