!   PATHSAMPLE: A driver for OPTIM to create stationary point databases using discrete path sampling and perform kinetic analysis
!   Copyright (C) 1999-2009 David J. Wales
!   This file is part of PATHSAMPLE. 
!   
!   PATHSAMPLE is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or 
!   (at your option) any later version.
!   
!   PATHSAMPLE is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!   
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!   

C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C  Produce CONNECTIONS connected minima for minimum MINDEX.
C  New transition states must be added to ts.data and new minima must be added to min.data.
C  If we find a connection to an existing minimum we should update its sum of rates. 
C
      SUBROUTINE TSSEARCH(MINDEX,NADD)
      USE PORFUNCS
      USE COMMONS
      IMPLICIT NONE
      INTEGER NOFFSET, ISTAT, NCOUNT, NTRIPLES, NDUMMY
      INTEGER MINDEX, L1, L2, HORDERPLUS, HTS, HORDERMINUS, ECON, NADD, NINIT, J1, DMODE, J3,
     1        NDONE, PID(NCPU+NCPU+1), J2, LNTS, STATUS, J4, DUMMYI
! file numbers are offset by an additional NCPU to avoid overwriting output from connect runs.
      LOGICAL LTEST1, LTEST2, T1, T2, FINISHED(NCPU+NCPU+1), NOPATH(NCPU+NCPU+1), KILLED(NCPU+NCPU+1)
      LOGICAL BADTRIPLE
      DOUBLE PRECISION POINTS(3*NATOMS), POINTSPLUSLOCAL(3*NATOMS), POINTSMINUSLOCAL(3*NATOMS), POINTSTSLOCAL(3*NATOMS),
     1                 EPLUS, ETSLOCAL, EMINUS, FRQSPLUS(3*NATOMS), FRQSTS(3*NATOMS), FRQSMINUS(3*NATOMS),
     2                 IXPLUS, IYPLUS, IZPLUS, IXMINUS, IYMINUS, IZMINUS, IXM ,IYM ,IZM, DPERT, 
     3                 DUMMY, RANDOM, RANARRAY(3*NATOMS), DPRAND, LOCALPOINTS2(3*NATOMS),
     4                 DISTANCE, DIST2, RMAT(3,3), NEWIXMIN,NEWIYMIN,NEWIZMIN,FRICTIONFAC,NEWNEGEIG
      CHARACTER(LEN=10) J3STR, PIDSTR
      CHARACTER(LEN=80) FPOO
      CHARACTER(LEN=1) DUMMYSTRING
C     INTEGER CONNECTEDMIN(MAXCONN) ! would need to make this allocatable
      DOUBLE PRECISION TINIT, TNEW

      NOFFSET=NCPU+1
      NNEW=0
      IF (.NOT.ALLOCATED(FROZEN)) ALLOCATE(FROZEN(NATOMS))

      CALL CPU_TIME(TINIT)
C     CALL MYSYSTEM(STATUS,DEBUG,'rm points.repel')
C
C  How many connections do we already have?
C
      NTOTAL=0
C     OPEN(UNIT=47,FILE='points.repel',STATUS='UNKNOWN')
      DO L1=1,NTS
         LTEST1=PLUS(L1).EQ.MINDEX
         LTEST2=MINUS(L1).EQ.MINDEX
         IF ((LTEST1.OR.LTEST2).AND.(PLUS(L1).NE.MINUS(L1))) THEN
            NTOTAL=NTOTAL+1
C           IF (NTOTAL.GT.MAXCONN) THEN
C              WRITE(*,'(A)') 'tssearch> too many connected minima - increase MAXCONN'
C              STOP
C           ENDIF
C           IF (LTEST1) CONNECTEDMIN(NTOTAL)=MINUS(L1)
C           IF (LTEST2) CONNECTEDMIN(NTOTAL)=PLUS(L1)
C           CONNECTEDBYTS(NTOTAL)=L1
C           IF (DEBUG) WRITE(*,'(A,I6,A,I6,A,I6)') 'minimum ',MINDEX,' is connected to minimum ',CONNECTEDMIN(NTOTAL),' by ts ',L1
            READ(UTS,REC=L1) (POINTS(L2),L2=1,3*NATOMS)
C           WRITE(47,'(3F20.10)') (POINTS(L2),L2=1,3*NATOMS)
         ENDIF
      ENDDO
C     CLOSE(47)
      IF (DEBUG) WRITE(*,'(A,I6,A,I6,A)') 'tssearch> minimum ',MINDEX,' has ',NTOTAL,' connections to different structures' 
      NINIT=NTOTAL
      IF (NTOTAL.GE.MAX(CONNECTIONS,NINIT+NADD)) RETURN
      WRITE(*,'(A,I6,A,I6,A)') 'tssearch> minimum ',MINDEX,' has ',NTOTAL,' connections to different structures - looking for more'

      READ(UMIN,REC=MINDEX) (POINTS(L2),L2=1,3*NATOMS)
      DO L1=1,MAXTSATTEMPTS
C
C  To use NCPU cpu.s first set up NCPU odata.n files and run
C  NCPU OPTIM jobs. Need to offset the indices or the path.info.n
C  files will overwrite the ones generated by connect runs.
C
         DO J3=1+NOFFSET,NCPU+NOFFSET
            WRITE(J3STR,'(I10)') J3
            IF (CHARMMT) THEN
               FPOO='odata.'//TRIM(ADJUSTL(J3STR)) ! workaround for Sun compiler bug
               OPEN(1,FILE=TRIM(ADJUSTL(FPOO)),STATUS='UNKNOWN')
               DPERT=60.0D0 * PERTVALUE
C              CALL RANDOM_NUMBER(RANDOM)
               RANDOM=DPRAND()

C csw34> The user used to have to specify the number of internal
C coordinates that were dihedrals in the pathdata file after CHARMM.
C This number - NDIHE was then used below to choose one dihedral that is
C specified for change in the odata.x file produced. This is time 
C consuming for the user, and doesn't guarentee that omega and chiral
C dihedrals are not touched. Instead - we now simply pass a random
C number to OPTIM on the TWISTDIHE line of odata.x. OPTIM uses this
C number to select a dihedral from an array of twistable dihedrals.
C               DMODE=NINT(RANDOM*NDIHE*2)
C               DMODE=DMODE-NDIHE
C               IF (DMODE.EQ.0) DMODE=1
C               WRITE(1,'(A,I7,F15.5)') 'TWISTDIHE  ',DMODE,DPERT
               WRITE(1,'(A,F18.11,F15.5)') 'TWISTDIHE  ',RANDOM,DPERT
               CLOSE(1)
               CALL MYSYSTEM(STATUS,DEBUG,'cat odata.tssearch >> odata.'//TRIM(ADJUSTL(J3STR)))
               if (machine) then
                    CALL CHARMMDUMP(POINTS,'points1.inp.'//TRIM(ADJUSTL(J3STR)))
               else
                    CALL CHARMMDUMP(POINTS,'input.crd.'//TRIM(ADJUSTL(J3STR)))
               endif
            ELSE IF (UNRST) THEN 
               FPOO='odata.'//TRIM(ADJUSTL(J3STR)) ! workaround for Sun compiler bug
               OPEN(1,FILE=TRIM(ADJUSTL(FPOO)),STATUS='UNKNOWN')
C jmc do something slightly smarter to determine which dihedral to twist
C first determine whether to twist backbone or side chain dihe:
C              CALL RANDOM_NUMBER(RANDOM)
               RANDOM=DPRAND()
               IF (RANDOM.LT.0.75D0) THEN ! bias towards twisting backbone
                  DPERT=30.0D0 * PERTVALUE
C                 CALL RANDOM_NUMBER(RANDOM)
                  RANDOM=DPRAND()
                  DMODE=NINT(RANDOM*((NATOMS/2)-3)*2)
                  DMODE=DMODE-(NATOMS/2)+3
                  IF (DMODE.EQ.0) DMODE=1
               ELSE
C side chain: there are ndihe - natoms/2 + 3 of these.  Choose any with equal probability.
                  DPERT=60.0D0 * PERTVALUE
C                 CALL RANDOM_NUMBER(RANDOM)
                  RANDOM=DPRAND()
                  DMODE=(NATOMS/2)-3+NINT(RANDOM*(NDIHE-(NATOMS/2)+3))
                  IF (DMODE.EQ.(NATOMS/2-3)) DMODE=1+DMODE
                  IF (RANDOM.GT.0.5D0) DMODE=-DMODE
               ENDIF
C jmc          DPERT=60.0D0 * PERTVALUE
C C jmc          CALL RANDOM_NUMBER(RANDOM)
C jmc          RANDOM=DPRAND()
C jmc          DMODE=NINT(RANDOM*NDIHE*2) 
C jmc          DMODE=DMODE-NDIHE 
C jmc          IF (DMODE.EQ.0) DMODE=1
               WRITE(1,'(A,I6,F15.5)') 'TWISTDIHE  ',DMODE,DPERT
               CLOSE(1)
               CALL MYSYSTEM(STATUS,DEBUG,'cat odata.tssearch >> odata.'//TRIM(ADJUSTL(J3STR)))
               CALL MYUNRESDUMP(POINTS,'coords.'//TRIM(ADJUSTL(J3STR)))
            ELSE IF (AMBERT) THEN
               CALL MYSYSTEM(STATUS,DEBUG,'cp odata.tssearch odata.'//TRIM(ADJUSTL(J3STR)))
               FPOO='start.'//TRIM(ADJUSTL(J3STR)) ! workaround for Sun compiler bug
               OPEN(1,FILE=TRIM(ADJUSTL(FPOO)),STATUS='UNKNOWN')
               DO L2=1,NATOMS
                  IF (FROZEN(L2)) THEN
                     RANARRAY(3*(L2-1)+1)=0.0D0
                     RANARRAY(3*(L2-1)+2)=0.0D0
                     RANARRAY(3*(L2-1)+3)=0.0D0
                  ELSE
                     RANDOM=DPRAND()
                     RANARRAY(3*(L2-1)+1)=(RANDOM-0.5D0)*2.0D0*PERTVALUE
                     RANDOM=DPRAND()
                     RANARRAY(3*(L2-1)+2)=(RANDOM-0.5D0)*2.0D0*PERTVALUE
                     RANDOM=DPRAND()
                     RANARRAY(3*(L2-1)+3)=(RANDOM-0.5D0)*2.0D0*PERTVALUE
                  ENDIF
               ENDDO
               WRITE(1,'(3F20.10)') (POINTS(3*(L2-1)+1)+RANARRAY(3*(L2-1)+1),
     &                               POINTS(3*(L2-1)+2)+RANARRAY(3*(L2-1)+2),
     &                               POINTS(3*(L2-1)+3)+RANARRAY(3*(L2-1)+3),L2=1,NATOMS)
               CLOSE(1)
            ELSE
               CALL MYSYSTEM(STATUS,DEBUG,'cp odata.tssearch odata.'//TRIM(ADJUSTL(J3STR)))
               FPOO='odata.'//TRIM(ADJUSTL(J3STR)) ! this line works around a Sun compiler bug
               OPEN(1,FILE=TRIM(ADJUSTL(FPOO)),STATUS='OLD',POSITION='APPEND')
C              WRITE(1,'(A,F20.10)') 'FIXD  ',PERTVALUE
               WRITE(1,'(A)') 'POINTS'
C              WRITE(1,'(A2,2X,3F20.10)') (ZSYMBOL(L2),POINTS(3*(L2-1)+1),POINTS(3*(L2-1)+2),POINTS(3*(L2-1)+3),L2=1,NATOMS)
               DO L2=1,NATOMS
                  IF (FROZEN(L2)) THEN
                     RANARRAY(3*(L2-1)+1)=0.0D0
                     RANARRAY(3*(L2-1)+2)=0.0D0
                     RANARRAY(3*(L2-1)+3)=0.0D0
                  ELSE
                     RANDOM=DPRAND()
                     RANARRAY(3*(L2-1)+1)=(RANDOM-0.5D0)*2.0D0*PERTVALUE
                     RANDOM=DPRAND()
                     RANARRAY(3*(L2-1)+2)=(RANDOM-0.5D0)*2.0D0*PERTVALUE
                     RANDOM=DPRAND()
                     RANARRAY(3*(L2-1)+3)=(RANDOM-0.5D0)*2.0D0*PERTVALUE
                     IF (TWOD) RANARRAY(3*(L2-1)+3)=0.0D0
                  ENDIF
               ENDDO
               WRITE(1,'(A2,2X,3F20.10)') (ZSYMBOL(L2),POINTS(3*(L2-1)+1)+RANARRAY(3*(L2-1)+1),
     &                                                 POINTS(3*(L2-1)+2)+RANARRAY(3*(L2-1)+2),
     &                                                 POINTS(3*(L2-1)+3)+RANARRAY(3*(L2-1)+3),L2=1,NATOMS)
               CLOSE(1)
            ENDIF
            CALL FLUSH(6,ISTAT) ! The child process may duplicate output without this line
            call fork_subr(PID(J3))
            IF (PID(J3).EQ.0) CALL SUBMITOPTIMJOB(J3-NOFFSET,CHARMMT,UNRST,J3,EXEC,DEBUG,'OPTIM.tssearch.')
         ENDDO
         WRITE(*,'(A)') 'tssearch> Printing to prevent error on sinister (line 204)'
         NOPATH(1:NCPU+NCPU+1)=.FALSE.
         CALL MYWAIT(NCPU,NOFFSET,PID,NOPATH,KILLED,DEBUG) ! manage the forked processes
         WRITE(*,'(A)') 'tssearch> all forked ts searches completed or killed'

         analyse_paths: DO J3=1+NOFFSET,NCPU+NOFFSET
            WRITE(PIDSTR,'(I10)') PID(J3)
            CALL MYSYSTEM(STATUS,DEBUG,'cp path.info.'//TRIM(ADJUSTL(PIDSTR))//' path.info')
            IF (STATUS.EQ.0) CALL GETALLPATHS
         ENDDO analyse_paths
         IF (NTOTAL.GE.MAX(CONNECTIONS,NINIT+NADD)) CALL CPU_TIME(TNEW) 
         IF (NTOTAL.GE.MAX(CONNECTIONS,NINIT+NADD)) GOTO 20
      ENDDO
 
20      TTSSEARCH=TTSSEARCH+TNEW-TINIT

      RETURN
      END
