!   PATHSAMPLE: A DRIVER FOR OPTIM TO CREATE STATIONARY POINT DATABASES USING DISCRETE PATH SAMPLING AND PERFORM KINETIC ANALYSIS
!   COPYRIGHT (C) 1999-2009 DAVID J. WALES
!   THIS FILE IS PART OF PATHSAMPLE.
!
!   PATHSAMPLE IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
!   IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
!   THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
!   (AT YOUR OPTION) ANY LATER VERSION.
!
!   PATHSAMPLE IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
!   BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
!   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
!   GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
!   YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
!   ALONG WITH THIS PROGRAM; IF NOT, WRITE TO THE FREE SOFTWARE
!   FOUNDATION, INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA  02111-1307  USA
!

      SUBROUTINE AMHDUMP(COORDS,FNAME)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      CHARACTER(LEN=*)  FNAME
      INTEGER I525
      DOUBLE PRECISION COORDS(3*NATOMS)
      INTEGER JTGRES,NRES,J
      INTEGER MEMIRES(800)
      DOUBLE PRECISION CPRCORD_X(3*NATOMS),CPRCORD_Y(3*NATOMS),CPRCORD_Z(3*NATOMS)
      DOUBLE PRECISION NITCORD_X(3*NATOMS),NITCORD_Y(3*NATOMS),NITCORD_Z(3*NATOMS)
      CHARACTER RES_TYPE*3, AANAME(20)*3,TARFL*5

      DATA AANAME /'ALA','ARG','ASN','ASP','CYS','GLN','GLU','GLY','HIS', &
         'ILE','LEU','LYS','MET','PHE','PRO','SER','THR','TRP','TYR','VAL'/

          IF (AMHT)THEN
            WRITE(1,334)NATOMS/3,3,1,1
334         FORMAT(4(I8,1X),' NMRES NMCRD NUMPRO NMSNAP')
            WRITE(1,683)1,1,1,1.0,1
683         FORMAT(3(I6,1X),F8.4,1X,I5,' STUCT SNAP T T TID')

          DO 525 I525=1,NATOMS*3,9
           WRITE(1,332)COORDS(I525),COORDS(I525+1),COORDS(I525+2), &
             COORDS(I525+3),COORDS(I525+4),COORDS(I525+5), &
             COORDS(I525+6),COORDS(I525+7),COORDS(I525+8)
332           FORMAT('CA: ',3(F8.3,1X),'CB: ',3(F8.3,1X),'OX: ', 3(F8.3,1X))
525       CONTINUE

         DO 625 I525=1,NATOMS*3,9
          WRITE(1,'(3F25.15)')COORDS(I525),COORDS(I525+1),COORDS(I525+2)
          WRITE(1,'(3F25.15)')COORDS(I525+3),COORDS(I525+4),COORDS(I525+5)
          WRITE(1,'(3F25.15)')COORDS(I525+6),COORDS(I525+7),COORDS(I525+8)
625      CONTINUE

        OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
         READ (30,1000)TARFL
1000          FORMAT(A5)
        CLOSE(30)

        OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
           READ(17,201)(MEMIRES(J),J=1,NRES)
201        FORMAT (25(I2,1X))
         CLOSE(17)

          DO JTGRES = 1,NRES
             CPRCORD_X(JTGRES)=0.D0
             CPRCORD_Y(JTGRES)=0.D0
             CPRCORD_Z(JTGRES)=0.D0
             NITCORD_X(JTGRES)=0.D0
             NITCORD_Y(JTGRES)=0.D0
             NITCORD_Z(JTGRES)=0.D0
          ENDDO 

         DO JTGRES = 0,NRES-1 
!          PRINT '(A,5I6)','NATOMS,3*NATOMS,NRES,JTGRES,9*(JTGRES+1)+1=',NATOMS,3*NATOMS,NRES,JTGRES,9*(JTGRES+1)+1
          CPRCORD_X(JTGRES+1)=0.4436538D0*COORDS(9*(JTGRES)+1) &
                             +0.2352006D0*COORDS(9*(JTGRES+1)+1) &
                             +0.3211456D0*COORDS(9*(JTGRES)+7)

          CPRCORD_Y(JTGRES+1)=0.4436538D0*COORDS(9*(JTGRES)+2) &
                             +0.2352006D0*COORDS(9*(JTGRES+1)+2) &
                             +0.3211456D0*COORDS(9*(JTGRES)+8)

          CPRCORD_Z(JTGRES+1)=0.4436538D0*COORDS(9*(JTGRES)+3) &
                             +0.2352006D0*COORDS(9*(JTGRES+1)+3) &
                             +0.3211456D0*COORDS(9*(JTGRES)+9)
         ENDDO

         DO JTGRES = 1,NRES      ! NITROGENS
          NITCORD_X(JTGRES+1)=0.4831806D0*COORDS(9*(JTGRES-1)+1) &
                             +0.7032820D0*COORDS(9*(JTGRES)+1) &
                             -0.1864626D0*COORDS(9*(JTGRES-1)+7)

          NITCORD_Y(JTGRES+1)=0.4831806D0*COORDS(9*(JTGRES-1)+2) &
                             +0.7032820D0*COORDS(9*(JTGRES)+2) &
                             -0.1864626D0*COORDS(9*(JTGRES-1)+8)

          NITCORD_Z(JTGRES+1)=0.4831806D0*COORDS(9*(JTGRES-1)+3) &
                             +0.7032820D0*COORDS(9*(JTGRES)+3) &
                             -0.1864626D0*COORDS(9*(JTGRES-1)+9)
         ENDDO 

       OPEN(UNIT=199,FILE=FNAME, STATUS='UNKNOWN')

          DO JTGRES = 1,NRES    
             RES_TYPE=AANAME(MEMIRES(JTGRES))

       IF (JTGRES .NE. 1 ) THEN
        WRITE(199,56)JTGRES,RES_TYPE,JTGRES, &
            NITCORD_X(JTGRES),NITCORD_Y(JTGRES),NITCORD_Z(JTGRES),JTGRES
56       FORMAT('ATOM',4X,I3,2X,'N ',2X,A3,1X,'A',1X,I3,4X,F8.3,F8.3,F8.3, &
                2X,'1.00',2X,'0.00',6X,'TPDB',1X,I3)
       ENDIF

        WRITE(199,52)JTGRES,RES_TYPE,JTGRES,COORDS(9*(JTGRES-1)+1), &
           COORDS(9*(JTGRES-1)+2),COORDS(9*(JTGRES-1)+3),JTGRES
52       FORMAT('ATOM',4X,I3,2X,'CA',2X,A3,1X,'A',1X,I3,4X,F8.3,F8.3,F8.3, &
              2X,'1.00',2X,'0.00',6X,'TPDB',1X,I3)

         IF (MEMIRES(JTGRES).NE.8) THEN
        WRITE(199,53)JTGRES,RES_TYPE,JTGRES,COORDS(9*(JTGRES-1)+4), &
       COORDS(9*(JTGRES-1)+5),COORDS(9*(JTGRES-1)+6),JTGRES
53       FORMAT('ATOM',4X,I3,2X,'CB',2X,A3,1X,'A',1X,I3,4X,F8.3,F8.3,F8.3, &
                2X,'1.00',2X,'0.00',6X,'TPDB',1X,I3)
          ENDIF

       IF (JTGRES .NE. NRES)THEN
        WRITE(199,55)JTGRES,RES_TYPE,JTGRES, &
                CPRCORD_X(JTGRES),CPRCORD_Y(JTGRES),CPRCORD_Z(JTGRES),JTGRES
55       FORMAT('ATOM',4X,I3,2X,'C ',2X,A3,1X,'A',1X,I3,4X,F8.3,F8.3,F8.3, & 
                2X,'1.00',2X,'0.00',6X,'TPDB',1X,I3)
       ENDIF

        WRITE(199,54)JTGRES,RES_TYPE,JTGRES,COORDS(9*(JTGRES-1)+7), &
       COORDS(9*(JTGRES-1)+8),COORDS(9*(JTGRES-1)+9),JTGRES
54      FORMAT('ATOM',4X,I3,2X,'O ',2X,A3,1X,'A',1X,I3,4X,F8.3,F8.3,F8.3, &
                2X,'1.00',2X,'0.00',6X,'TPDB',1X,I3)
        ENDDO
       ENDIF
      END

      SUBROUTINE AMHALLATOMMIN
        IMPLICIT NONE
        INTEGER STATUS
        LOGICAL DEBUG
        CALL MYSYSTEM(STATUS,DEBUG,'~/bin/scwrl3 -i amhmin.pdb -o amhmin.pdb.scwrl > scwrl_out ')
       END

      SUBROUTINE AMHALLATOMTS
        IMPLICIT NONE
        INTEGER STATUS
        LOGICAL DEBUG
        CALL MYSYSTEM(STATUS,DEBUG,'~/bin/scwrl3 -i amhts.pdb -o amhts.pdb.scwrl > scwrl_out ')
       END

!   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCC QQQQQQQQQQ CCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE AMHQ(NUM)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      INTEGER J2,NUM,III,MAXRES,ISKIP
      PARAMETER (MAXRES=350)
      DOUBLE PRECISION LOCALPOINTS(3*NATOMS)
      DOUBLE PRECISION TGDIST(MAXRES,MAXRES)
      DOUBLE PRECISION PATHDIST(MAXRES,MAXRES),DEL
      REAL TGCORD(MAXRES,3,3)
      INTEGER NRES,J,ICOORD,I,I1,I2,INIT1,INIT2 
      INTEGER SEQ(MAXRES), K ,L
      INTEGER   GAP(MAXRES),TEMPGAP
      INTEGER   NUM_FOLDON,FOLDSTRT_MIN(10),FOLDSTRT_MAX(10)
      INTEGER   SEGLIST(MAXRES),NUMCONST

      DOUBLE PRECISION :: WIDTH0,WIDTHEXP
      DOUBLE PRECISION :: FINCORD(MAXRES,3,3),RG

      DOUBLE PRECISION :: QPOS,QTOT,QSEGTOT,Q,WIDTH(MAXRES)
      DOUBLE PRECISION :: Q_SHORT,Q_MEDIUM,Q_LONG
      DOUBLE PRECISION :: QPOS_SHORT,QPOS_MEDIUM,QPOS_LONG
      DOUBLE PRECISION :: QTOT_SHORT,QTOT_MEDIUM,QTOT_LONG

      CHARACTER TARFL*5

      DATA WIDTH0,WIDTHEXP / 1.0D0, 0.15D0 /  ! WAS 1.0, 0.5

!     READING NATIVE STRUCTURE 
!     PRINT '(A,I6)', 'SETUP> EXTRACTING MINIMUM ',WHICHMIN
      PRINT '(A,I6)', 'SETUP> AMHQ '  
      READ(UMIN,REC=WHICHMIN) (LOCALPOINTS(J2),J2=1,3*NATOMS)

        OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
         READ (30,1000)TARFL
1000          FORMAT(A5)
        CLOSE(30)

        OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
!           WRITE(6,*)NRES
           READ(17,201)(SEQ(J),J=1,NRES)
201        FORMAT (25(I2,1X))
          DO 130 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,1),I1=1,NRES)
1023        FORMAT(8(F8.3,1X))
130       CONTINUE
          DO 140 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,2),I1=1,NRES)
140       CONTINUE
          DO 150 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,3),I1=1,NRES)
150       CONTINUE

         CLOSE(17)

!        IF (CA) I2=1
!        IF (CB) I2=2
!        IF (OX) I2=3 
        I2=1

        DO 205 INIT1 = 1,MAXRES
           DO 206 INIT2 = 1,MAXRES
                TGDIST(INIT1,INIT2) = 0.0D0
206        CONTINUE
205     CONTINUE

        DO 200 I=1,NRES-1
          DO 210 J=I+1,NRES
            TGDIST(I,J)=DSQRT( DBLE((TGCORD(I,1,I2)) &
                          -   DBLE(TGCORD(J,1,I2)))**2 &
                         + DBLE((TGCORD(I,2,I2)) &
                          -DBLE(TGCORD(J,2,I2)))**2 &
                         + DBLE((TGCORD(I,3,I2)) &
                           -DBLE(TGCORD(J,3,I2)))**2  )
            TGDIST(J,I)=TGDIST(I,J)

210       CONTINUE
200     CONTINUE

        DO 305 INIT1 = 1,MAXRES
           DO 306 INIT2 = 1,MAXRES
                PATHDIST(INIT1,INIT2) = 0.0D0
306        CONTINUE
305     CONTINUE

         DO 525 III=1,NRES 
          FINCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
          FINCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
          FINCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
          FINCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
          FINCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
          FINCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
          FINCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
          FINCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
          FINCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
525      CONTINUE

        RG=0.D0

        DO 300 I=1,NRES-1
          DO 310 J=I+1,NRES
            PATHDIST(I,J)=DSQRT((FINCORD(I,1,I2)-FINCORD(J,1,I2))**2 &
       +(FINCORD(I,2,I2)-FINCORD(J,2,I2))**2 +(FINCORD(I,3,I2)-FINCORD(J,3,I2))**2 )
            PATHDIST(J,I)=PATHDIST(I,J)
            RG=RG+PATHDIST(I,J)*PATHDIST(I,J)
310       CONTINUE
300     CONTINUE

         RG=DSQRT((RG)/DBLE(NRES)) 

          DO 260 ISKIP=1,MAXRES
            DEL=DBLE(ISKIP)
            WIDTH(ISKIP)=1.0D0/(WIDTH0*(DEL)**WIDTHEXP)
260       CONTINUE

         QPOS=(NRES)*((NRES)-1.0D0)/2.0D0-(NRES)+1.0D0

         QTOT=0.0D0
         QSEGTOT=0.0D0
         QTOT_SHORT=0.0D0
         QTOT_MEDIUM=0.0D0
         QTOT_LONG=0.0D0
         QPOS_SHORT=0.0D0
         QPOS_MEDIUM=0.0D0
         QPOS_LONG=0.0D0

          DO I = 1, MAXRES
             GAP(I) = 0
          ENDDO

          NUM_FOLDON = 1 
          FOLDSTRT_MIN(1) = 1
          FOLDSTRT_MAX(1) = NRES

          IF ( NUM_FOLDON .NE. 1) THEN
             DO I = 1,NUM_FOLDON - 1
                  GAP(I) = FOLDSTRT_MIN(I+1) - FOLDSTRT_MAX(I) - 1
             ENDDO
          ENDIF

          DO I = 1,NUM_FOLDON
          IF ( I .EQ. 1) THEN
            DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                SEGLIST(J - (FOLDSTRT_MIN(I)-1)) = J
                NUMCONST = J - (FOLDSTRT_MIN(I)-1)
            ENDDO
          ENDIF

          TEMPGAP = 0

          IF ( I .NE. 1) THEN
              DO K = 1 , I - 1
                  TEMPGAP = TEMPGAP + GAP(K)
              ENDDO
              DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                  SEGLIST(J - TEMPGAP -  (FOLDSTRT_MIN(1)-1)) = J
                  NUMCONST = J - TEMPGAP  - (FOLDSTRT_MIN(1)-1)
              ENDDO
          ENDIF   ! IF ( I .NE. 1) THEN
          ENDDO

!             DO I = 1, NUMCONST
!                WRITE(6,*)SEGLIST(I)
!             ENDDO

       DO 270 K = 1,  NUMCONST - 2
!               WRITE(6,*)'NUMCONST   SEGLIST(K)', NUMCONST,   SEGLIST(K)
               I = SEGLIST(K)

        DO 280 L = K+2, NUMCONST
             J = SEGLIST(L)
             DEL=(TGDIST(I,J)-PATHDIST(I,J))*WIDTH(J-I)
             QTOT=QTOT+EXP(-DEL*DEL*0.5D0)

             IF (J-I.LT.5) THEN
              QTOT_SHORT=QTOT_SHORT+EXP(-DEL*DEL*0.5D0)
               QPOS_SHORT=QPOS_SHORT+1.0D0
             ELSEIF (J-I.LT.13) THEN
               QTOT_MEDIUM=QTOT_MEDIUM+EXP(-DEL*DEL*0.5D0)
               QPOS_MEDIUM=QPOS_MEDIUM+1.0D0
             ELSE
               QTOT_LONG=QTOT_LONG+EXP(-DEL*DEL*0.5D0)
               QPOS_LONG=QPOS_LONG+1.0D0
             ENDIF
280        CONTINUE
270      CONTINUE

         Q=QTOT/QPOS
         Q_SHORT=QTOT_SHORT/QPOS_SHORT
         Q_MEDIUM=QTOT_MEDIUM/QPOS_MEDIUM
         Q_LONG=QTOT_LONG/QPOS_LONG

         PRINT '(A,(G15.7),I6)', 'AMHQ       ',Q,NUM
         PRINT '(A,(G15.7),I6)', 'AMHRG      ',RG,NUM
         PRINT '(A,(G15.7),I6)', 'AMH_SHORT  ',Q_SHORT,NUM
         PRINT '(A,(G15.7),I6)', 'AMH_MEDIUM ',Q_MEDIUM,NUM
         PRINT '(A,(G15.7),I6)', 'AMH_LONG   ',Q_LONG,NUM
      END

!   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCC QQQQQQQQQQ 2  ENG MIN   CCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE AMHQENGMIN(NUM)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      INTEGER J2,NUM,III,MAXRES,ISKIP
      PARAMETER (MAXRES=350)
      DOUBLE PRECISION LOCALPOINTS(3*NATOMS), EMINPOINTS(3*NATOMS)
      DOUBLE PRECISION TGDIST(MAXRES,MAXRES), PATHDIST(MAXRES,MAXRES),DEL
      REAL TGCORD(MAXRES,3,3)
      INTEGER NRES,J,ICOORD,I,I1,I2,INIT1,INIT2
      INTEGER SEQ(MAXRES), K ,L
      INTEGER   GAP(MAXRES),TEMPGAP
      INTEGER   NUM_FOLDON,FOLDSTRT_MIN(10),FOLDSTRT_MAX(10)
      INTEGER   SEGLIST(MAXRES),NUMCONST,J1,tempmin

      DOUBLE PRECISION :: WIDTH0,WIDTHEXP,EMIN_Q(1000000)
      DOUBLE PRECISION :: FINCORD(MAXRES,3,3),RG

      DOUBLE PRECISION :: QPOS,QTOT,QSEGTOT,Q,WIDTH(MAXRES)
      DOUBLE PRECISION :: Q_SHORT,Q_MEDIUM,Q_LONG
      DOUBLE PRECISION :: QPOS_SHORT,QPOS_MEDIUM,QPOS_LONG
      DOUBLE PRECISION :: QTOT_SHORT,QTOT_MEDIUM,QTOT_LONG

      CHARACTER TARFL*5

      CHARACTER(len=1000) :: LINE
      DOUBLE PRECISION :: X(1000000)
      INTEGER :: N, IO

      DATA WIDTH0,WIDTHEXP / 1.0D0, 0.15D0 /  ! WAS 1.0, 0.5

!     READING SPECIFIED STRUCTURE
      PRINT '(A,I6)', 'SETUP> EXTRACTING MINIMUM ',WHICHMIN
      PRINT '(A,I6)', 'SETUP> CALCULATE Q 2 ENERGY MINIMUM '
      READ(UMIN,REC=WHICHMIN) (LOCALPOINTS(J2),J2=1,3*NATOMS)

!     EXTRACT MIN DATA
!        OPEN(10, FILE = 'min.data')
!        NMIN = 0
!        DO 
!          READ(10, '(A)',IOSTAT=IO)LINE
!          if (IO < 0)EXIT
!          NMIN = NMIN + 1
!          READ (LINE, *) EMIN_Q(NMIN)
!         WRITE (6,*) EMIN_Q(NMIN)
!        END DO 
!        CLOSE(10) 
 
!      EXTRACTS INDEX OF LOWEST ENERGY STRUCTURE
!       TEMPMIN = MINLOC(EMIN_Q(1:NMIN),1)

        TEMPMIN = 37467

        PRINT '(A,I6)', 'SETUP> EXTRACTING GLOBAL ENERGY MINIMUM',TEMPMIN
        READ(UMIN,REC=TEMPMIN) (EMINPOINTS(J2),J2=1,3*NATOMS)


!      SET NRES via PROTEIN FILE 
        OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
           READ (30,1000)TARFL
1000       FORMAT(A5)
        CLOSE(30)

        OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
!           WRITE(6,*)NRES
           READ(17,201)(SEQ(J),J=1,NRES)
201        FORMAT (25(I2,1X))
         CLOSE(17)

!    CALCULATE DISTANCE MATRIX FOR GLOBAL E MIN

!        IF (CA) I2=1
!        IF (CB) I2=2
!        IF (OX) I2=3
        I2=1 

        DO 205 INIT1 = 1,MAXRES
           DO 206 INIT2 = 1,MAXRES
                TGDIST(INIT1,INIT2) = 0.0D0
206        CONTINUE
205     CONTINUE

         DO 525 III=1,NRES
          TGCORD(III, 1, 1) = EMINPOINTS(9*(III-1)+1)!  CA X
          TGCORD(III, 2, 1) = EMINPOINTS(9*(III-1)+2)!  CA Y
          TGCORD(III, 3, 1) = EMINPOINTS(9*(III-1)+3)!  CA Z
          TGCORD(III, 1, 2) = EMINPOINTS(9*(III-1)+4)!  CB X
          TGCORD(III, 2, 2) = EMINPOINTS(9*(III-1)+5)!  CB Y
          TGCORD(III, 3, 2) = EMINPOINTS(9*(III-1)+6)!  CB Z
          TGCORD(III, 1, 3) = EMINPOINTS(9*(III-1)+7)!  O X
          TGCORD(III, 2, 3) = EMINPOINTS(9*(III-1)+8)!  O Y
          TGCORD(III, 3, 3) = EMINPOINTS(9*(III-1)+9)!  O Z
525      CONTINUE

        DO 200 I=1,NRES-1
          DO 210 J=I+1,NRES
            TGDIST(I,J)=DSQRT( DBLE((TGCORD(I,1,I2)) &
                          -   DBLE(TGCORD(J,1,I2)))**2 &
                         + DBLE((TGCORD(I,2,I2)) &
                          -DBLE(TGCORD(J,2,I2)))**2 &
                         + DBLE((TGCORD(I,3,I2)) &
                           -DBLE(TGCORD(J,3,I2)))**2  )
            TGDIST(J,I)=TGDIST(I,J)
210       CONTINUE
200     CONTINUE

!    CALCULATE DISTANCE MATRIX FOR INPUT STRUCTURE

        DO 305 INIT1 = 1,MAXRES
          DO 306 INIT2 = 1,MAXRES
                PATHDIST(INIT1,INIT2) = 0.0D0
306        CONTINUE
305     CONTINUE

         DO 625 III=1,NRES
            FINCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
            FINCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
            FINCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
            FINCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
            FINCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
            FINCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
            FINCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
            FINCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
            FINCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
625      CONTINUE

        DO 300 I=1,NRES-1
          DO 310 J=I+1,NRES

            PATHDIST(I,J)=DSQRT((FINCORD(I,1,I2)-FINCORD(J,1,I2))**2 &
       +(FINCORD(I,2,I2)-FINCORD(J,2,I2))**2 +(FINCORD(I,3,I2)-FINCORD(J,3,I2))**2 )
            PATHDIST(J,I)=PATHDIST(I,J)
310       CONTINUE
300     CONTINUE

           DO 260 ISKIP=1,MAXRES
             DEL=DBLE(ISKIP)
             WIDTH(ISKIP)=1.0D0/(WIDTH0*(DEL)**WIDTHEXP)
 260       CONTINUE

          QPOS=DBLE(NRES)*(DBLE(NRES)-1.0D0)/2.0D0-DBLE(NRES)+1.0D0

          QTOT=0.0D0
          QSEGTOT=0.0D0
          QTOT_SHORT=0.0D0
          QTOT_MEDIUM=0.0D0
          QTOT_LONG=0.0D0
          QPOS_SHORT=0.0D0
          QPOS_MEDIUM=0.0D0
          QPOS_LONG=0.0D0
 
           DO I = 1, MAXRES
              GAP(I) = 0
           ENDDO
 
           NUM_FOLDON = 1
           FOLDSTRT_MIN(1) = 1
           FOLDSTRT_MAX(1) = NRES
 
           IF ( NUM_FOLDON .NE. 1) THEN
              DO I = 1,NUM_FOLDON - 1
                   GAP(I) = FOLDSTRT_MIN(I+1) - FOLDSTRT_MAX(I) - 1
              ENDDO
           ENDIF
 
           DO I = 1,NUM_FOLDON
           IF ( I .EQ. 1) THEN
             DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                 SEGLIST(J - (FOLDSTRT_MIN(I)-1)) = J
                 NUMCONST = J - (FOLDSTRT_MIN(I)-1)
             ENDDO
           ENDIF
 
           TEMPGAP = 0
 
           IF ( I .NE. 1) THEN
              DO K = 1 , I - 1
                  TEMPGAP = TEMPGAP + GAP(K)
              ENDDO
              DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                  SEGLIST(J - TEMPGAP -  (FOLDSTRT_MIN(1)-1)) = J
                  NUMCONST = J - TEMPGAP  - (FOLDSTRT_MIN(1)-1)
              ENDDO
          ENDIF   ! IF ( I .NE. 1) THEN
          ENDDO

          DO 270 K = 1,  NUMCONST - 2
           I = SEGLIST(K)
            DO 280 L = K+2, NUMCONST
             J = SEGLIST(L)
             DEL=(TGDIST(I,J)-PATHDIST(I,J))*WIDTH(J-I)
             QTOT=QTOT+EXP(-DEL*DEL*0.5D0)

             IF (J-I.LT.5) THEN
              QTOT_SHORT=QTOT_SHORT+EXP(-DEL*DEL*0.5D0)
               QPOS_SHORT=QPOS_SHORT+1.0D0
             ELSEIF (J-I.LT.13) THEN
               QTOT_MEDIUM=QTOT_MEDIUM+EXP(-DEL*DEL*0.5D0)
               QPOS_MEDIUM=QPOS_MEDIUM+1.0D0
             ELSE
               QTOT_LONG=QTOT_LONG+EXP(-DEL*DEL*0.5D0)
               QPOS_LONG=QPOS_LONG+1.0D0
             ENDIF
280        CONTINUE
270      CONTINUE

         Q=QTOT/QPOS
         Q_SHORT=QTOT_SHORT/QPOS_SHORT
         Q_MEDIUM=QTOT_MEDIUM/QPOS_MEDIUM
         Q_LONG=QTOT_LONG/QPOS_LONG

         PRINT '(A,(G15.7),I6)', 'Q2EMIN  ',Q,NUM
         PRINT '(A,(G15.7),I6)', 'Q_SHORT   2 ENERGY MINIMUM  ',Q_SHORT,NUM
         PRINT '(A,(G15.7),I6)', 'Q_MEDIUM  2 ENERGY MINIMUM  ',Q_MEDIUM,NUM
         PRINT '(A,(G15.7),I6)', 'Q_LONG    2 ENERGY MINIMUM  ',Q_LONG,NUM
      END

!   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCC  CONTACT_ORDER  CCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE AMH_RELCO(NUM,RCUT)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      INTEGER J2,NUM,III,MAXRES,ISKIP
      PARAMETER (MAXRES=350)
      DOUBLE PRECISION LOCALPOINTS(3*NATOMS)
      DOUBLE PRECISION TGDIST(MAXRES,MAXRES)
      DOUBLE PRECISION PATHDIST(MAXRES,MAXRES),DEL
      INTEGER NRES,J,ICOORD,I,I1,I2,INIT1,INIT2 
      INTEGER SEQ(MAXRES), K ,L
      INTEGER GAP(MAXRES),TEMPGAP
      INTEGER NUM_FOLDON,FOLDSTRT_MIN(10),FOLDSTRT_MAX(10)
      INTEGER SEGLIST(MAXRES),NUMCONST

      DOUBLE PRECISION :: WIDTH0,WIDTHEXP,RCUT, FINCORD(MAXRES,3,3)
      DOUBLE PRECISION :: TOTAL_CO, CUT_OFF_CO, COUNT_CO, REL_CO 

      CHARACTER TARFL*5

      DATA WIDTH0,WIDTHEXP / 1.0D0, 0.15D0 /  ! WAS 1.0, 0.5

!     READING NATIVE STRUCTURE 
!      PRINT '(A,I6)', 'SETUP> EXTRACTING MINIMUM FOR RELCO',WHICHMIN
      READ(UMIN,REC=WHICHMIN) (LOCALPOINTS(J2),J2=1,3*NATOMS)

!        PRINT '(A,G20.10)', 'AMH RCUT ',RCUT

        DO 305 INIT1 = 1,MAXRES
           DO 306 INIT2 = 1,MAXRES
                PATHDIST(INIT1,INIT2) = 0.0D0
306        CONTINUE
305     CONTINUE

        OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
         READ (30,1000)TARFL
1000          FORMAT(A5)
        CLOSE(30)

        OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
        CLOSE(17)

!        IF (CA) I2=1
!        IF (CB) I2=2
!        IF (OX) I2=3 
        I2=1

         DO 525 III=1,NRES 
          FINCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
          FINCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
          FINCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
          FINCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
          FINCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
          FINCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
          FINCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
          FINCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
          FINCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
525      CONTINUE

!        PRINT '(A,I6)', 'NRES ',NRES
        DO 300 I=1,NRES-1
          DO 310 J=I+1,NRES
            PATHDIST(I,J)=DSQRT((FINCORD(I,1,I2)-FINCORD(J,1,I2))**2 + &
                                (FINCORD(I,2,I2)-FINCORD(J,2,I2))**2 + &
                                (FINCORD(I,3,I2)-FINCORD(J,3,I2))**2 )
            PATHDIST(J,I)=PATHDIST(I,J)
!            PRINT '(A,G20.10)', 'PATH1 ',PATHDIST(I,J)
310       CONTINUE
300     CONTINUE

        TOTAL_CO=0.0D0
        COUNT_CO=0.0D0

!        PRINT '(A,G20.10)', 'AMH CUT ',RCUT
        DO 400 I=1,NRES-1
          DO 410 J=I+1,NRES
!        PRINT '(A,G20.10)', 'AMH PATHDIST ',PATHDIST(I,J)
          IF (PATHDIST(I,J).LE.RCUT) THEN
             TOTAL_CO = TOTAL_CO + J-I
             COUNT_CO = COUNT_CO + 1
          ENDIF
410       CONTINUE
400     CONTINUE

        REL_CO = TOTAL_CO/COUNT_CO/NRES

!        PRINT '(A,G20.10)', 'AMH TOTAL_CO    ',TOTAL_CO
!        PRINT '(A,G20.10)', 'AMH COUNT_CO    ',COUNT_CO
!        PRINT '(A,(G20.10),I6)', 'AMH NRES ',NRES
        PRINT '(A,(G20.10),I6)', 'AMH RELCO    ',REL_CO,NUM
            
          END

!CCCCCCCCCCCCCCCCCCCCCCCCCCCCC RMSRMSRMS CCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE AMHRMSD(NUM)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      INTEGER J2,NUM,III,MAXRES
      PARAMETER (MAXRES=350)
      DOUBLE PRECISION LOCALPOINTS(3*NATOMS)
      REAL TGCORD(MAXRES,3,3)
      INTEGER SEQ(MAXRES), NRES,J,ICOORD,I1,I2
      INTEGER  I_RES,I_CORD,I_ATOM,I_CORD2,I_ITER,I_TOT
      INTEGER, PARAMETER:: MAX_ITS=20

      DOUBLE PRECISION :: W(MAXRES,3),NORM,  &
         CENTROID_NAT(3), FINCORD(MAXRES,3,3),  &
         CENTROID(3),E,V(3,3),G(3,3),S(3,3),L(3), &
         H_CONST,G_CONST,DENOM,S_THETA,C_THETA,IDENTITY_MAT(3,3), &
         L1(3,3),L2(3,3),R(3,3),R_TOT(3,3),RMS 

      CHARACTER TARFL*5

      IDENTITY_MAT=0.0D0
      IDENTITY_MAT(1,1)=1.0D0
      IDENTITY_MAT(2,2)=1.0D0
      IDENTITY_MAT(3,3)=1.0D0

!     READING NATIVE STRUCTURE 
!      PRINT '(A,I6)', 'SETUP> EXTRACTING MINIMUM ',WHICHMIN
      PRINT '(A,I6)', 'SETUP> IN RMSD '
      READ(UMIN,REC=WHICHMIN) (LOCALPOINTS(J2),J2=1,3*NATOMS)

        OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
         READ (30,1000)TARFL
1000          FORMAT(A5)
        CLOSE(30)

         OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
           READ(17,201)(SEQ(J),J=1,NRES)
201        FORMAT (25(I2,1X))
          DO 130 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,1),I1=1,NRES)
1023        FORMAT(8(F8.3,1X))
130       CONTINUE
          DO 140 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,2),I1=1,NRES)
140       CONTINUE
          DO 150 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,3),I1=1,NRES)
150       CONTINUE
         CLOSE(17)

         I2=1

! FIND TARGET STRUCTURE CENTRE OF MASS AND SUBTRACT THIS OUT

      DO I1=1,NRES
        W(I1,1)=1.D0    !CA WEIGHT
        W(I1,2)=0.D0    !CB WEIGHT
        W(I1,3)=0.D0    !O WEIGHT
      ENDDO

      NORM=0.D0
      DO I1=1,NRES
      DO I_ATOM=1,3
        NORM=NORM+W(I1,I_ATOM)
      ENDDO
      ENDDO

      DO I_CORD=1,3
        CENTROID_NAT(I_CORD)=0.D0
        DO I_RES=1,NRES
        DO I_ATOM=1,3
          CENTROID_NAT(I_CORD)=CENTROID_NAT(I_CORD)+TGCORD(I_RES,I_CORD,I_ATOM)*W(I_RES,I_ATOM)
        ENDDO
        ENDDO
        CENTROID_NAT(I_CORD)=CENTROID_NAT(I_CORD)/NORM
      ENDDO

       DO I_RES = 1,NRES
        DO I_ATOM=1,3
         DO I_CORD=1,3
           TGCORD(I_RES,I_CORD,I_ATOM)=TGCORD(I_RES,I_CORD,I_ATOM)-CENTROID_NAT(I_CORD)
         ENDDO
        ENDDO
       ENDDO

        DO 525 III=1,NRES 
          FINCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
          FINCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
          FINCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
          FINCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
          FINCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
          FINCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
          FINCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
          FINCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
          FINCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
525     CONTINUE

      CENTROID=0.D0
        DO I_CORD=1,3                 !SUBTRACT OFF GLOBULE CENTRE OF MASS
          DO I_RES=1,NRES
          DO I_ATOM=1,3
            CENTROID(I_CORD)=CENTROID(I_CORD)+FINCORD(I_RES,I_CORD,I_ATOM)*W(I_RES,I_ATOM)
          ENDDO
          ENDDO
          CENTROID(I_CORD)=CENTROID(I_CORD)/NORM
        ENDDO

      DO I_RES = 1,NRES
      DO I_ATOM=1,3
      DO I_CORD=1,3
        FINCORD(I_RES,I_CORD,I_ATOM)=FINCORD(I_RES,I_CORD,I_ATOM)-CENTROID(I_CORD)
      ENDDO
      ENDDO
      ENDDO

!CCCCCCCCCCCCCC

        R_TOT=IDENTITY_MAT

        V=0.D0
        DO I_CORD=1,3      !CALCULATE INITIL V
        DO I_CORD2=1,3
          DO I_RES=1,NRES
          DO I_ATOM=1,3
            V(I_CORD,I_CORD2)= &
       V(I_CORD,I_CORD2)+W(I_RES,I_ATOM)*FINCORD(I_RES,I_CORD,I_ATOM)* &
                  TGCORD(I_RES,I_CORD2,I_ATOM)
          ENDDO
          ENDDO
        ENDDO
        ENDDO

        E=0.0                 !CALCULATE INITIAL E
      DO I_RES=1,NRES
       DO I_ATOM=1,3
        E=E+0.5D0*DOT_PRODUCT( FINCORD(I_RES,:,I_ATOM)-TGCORD(I_RES,:,I_ATOM),&
           FINCORD(I_RES,:,I_ATOM)-TGCORD(I_RES,:,I_ATOM) )*W(I_RES,I_ATOM)
       ENDDO
      ENDDO

        I_TOT=0
        I_ITER=0
        DO    !ITERATIVE LOOP
          I_ITER=MOD(I_ITER,3)+1
          I_TOT=I_TOT+1

          G(1,I_ITER)=V(2,3)-V(3,2)   ! CALCULATE G
          G(2,I_ITER)=V(3,1)-V(1,3)
          G(3,I_ITER)=V(1,2)-V(2,1)

          IF (DOT_PRODUCT(G(:,I_ITER),G(:,I_ITER)).EQ.0.D0) EXIT

          IF (I_ITER.EQ.1) THEN       ! CALCULATE ROTATION AXIS L
            S(:,I_ITER)=G(:,I_ITER)
          ELSE
            S(:,I_ITER)=G(:,I_ITER)+( DOT_PRODUCT(G(:,I_ITER),G(:,I_ITER))/ &
                    DOT_PRODUCT(G(:,I_ITER-1),G(:,I_ITER-1)) )*S(:,I_ITER-1)
          ENDIF
          L=S(:,I_ITER)/DSQRT(DOT_PRODUCT(S(:,I_ITER),S(:,I_ITER)))

          G_CONST=DOT_PRODUCT(G(:,I_ITER),L)       !CALCULATE G AND H
          H_CONST=V(1,1)+V(2,2)+V(3,3)
          DO I_CORD=1,3
          DO I_CORD2=1,3
            H_CONST=H_CONST-L(I_CORD)*L(I_CORD2)*V(I_CORD,I_CORD2)
          ENDDO
          ENDDO

          DENOM=DSQRT(G_CONST**2+H_CONST**2) !CALCULATE SIN(THETA) AND COS(THETA)
          S_THETA=G_CONST/DENOM              !FOR OPTIMAL ROTATION THETA
          C_THETA=H_CONST/DENOM

          E=E-G_CONST*S_THETA+H_CONST*(1.D0-C_THETA)        !UPDATE E

          IF (S_THETA.LT.1.D-10) EXIT        !IF THETA SMALL HAVE CONVERGED

          DO I_CORD=1,3    !CALCULATE ROTATION MATRIX R
          DO I_CORD2=1,3
            L1(I_CORD,I_CORD2)=L(I_CORD)*L(I_CORD2)
          ENDDO
          ENDDO

          L2=0.D0
          L2(1,2)=-L(3)
          L2(1,3)=L(2)
          L2(2,1)=L(3)
          L2(2,3)=-L(1)
          L2(3,1)=-L(2)
          L2(3,2)=L(1)

          R=C_THETA*IDENTITY_MAT+(1.D0-C_THETA)*L1+S_THETA*L2

          V=MATMUL(R,V)                         !UPDATE V

          R_TOT=MATMUL(R,R_TOT)

          IF (I_TOT.EQ.MAX_ITS) THEN
             WRITE(6,*) 'TOO MANY ITERATIONS'
             STOP
          ENDIF

        ENDDO

        RMS=DSQRT(2.D0*E/NORM)
!        PRINT '(A,(G15.7),I6,G15.7)', 'AMHRMS       ',RMS,NUM,NORM
        PRINT '(A,(G15.7),I6)', 'AMHRMS       ',RMS, WHICHMIN

        END 

!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCC QRELQRELQRELQREL  CCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE AMHRELQ(NUM,NUMNUM)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      INTEGER J2,NUM,NUMNUM,III,MAXRES,ISKIP
      PARAMETER (MAXRES=350)
      DOUBLE PRECISION LOCALPOINTS(3*NATOMS)
      DOUBLE PRECISION TGDIST(MAXRES,MAXRES)
      DOUBLE PRECISION PATHDIST(MAXRES,MAXRES),DEL
      DOUBLE PRECISION TGCORD(MAXRES,3,3)
      INTEGER NRES,J,I,I2,INIT1,INIT2 
      INTEGER SEQ(MAXRES), K ,L
      INTEGER   GAP(MAXRES),TEMPGAP
      INTEGER   NUM_FOLDON,FOLDSTRT_MIN(10),FOLDSTRT_MAX(10)
      INTEGER   SEGLIST(MAXRES),NUMCONST

      DOUBLE PRECISION :: WIDTH0,WIDTHEXP
      DOUBLE PRECISION :: FINCORD(MAXRES,3,3)

      DOUBLE PRECISION :: QPOS,QTOT,QSEGTOT,Q,WIDTH(MAXRES)
      DOUBLE PRECISION :: Q_SHORT,Q_MEDIUM,Q_LONG
      DOUBLE PRECISION :: QPOS_SHORT,QPOS_MEDIUM,QPOS_LONG
      DOUBLE PRECISION :: QTOT_SHORT,QTOT_MEDIUM,QTOT_LONG

      CHARACTER TARFL*5

      DATA WIDTH0,WIDTHEXP / 1.0D0, 0.15D0 /  ! WAS 1.0, 0.5

!     READING NATIVE STRUCTURE 

        OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
         READ (30,1000)TARFL
1000          FORMAT(A5)
        CLOSE(30)

        OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
           READ(17,201)(SEQ(J),J=1,NRES)
201        FORMAT (25(I2,1X))
         CLOSE(17)

        I2=1

      PRINT '(A,I6,I6)', 'SETUP> EXTRACTING MINIMUM AMHQREL',NUM, NUMNUM
      READ(UMIN,REC=NUM) (LOCALPOINTS(J2),J2=1,3*NATOMS)

        DO 525 III=1,NRES
          FINCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
          FINCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
          FINCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
          FINCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
          FINCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
          FINCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
          FINCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
          FINCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
          FINCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
525     CONTINUE

        DO 300 I=1,NRES-1
          DO 310 J=I+1,NRES
            PATHDIST(I,J)=DSQRT((FINCORD(I,1,I2)-FINCORD(J,1,I2))**2 &
      +(FINCORD(I,2,I2)-FINCORD(J,2,I2))**2 +(FINCORD(I,3,I2)-FINCORD(J,3,I2))**2 )
            PATHDIST(J,I)=PATHDIST(I,J)
310       CONTINUE
300     CONTINUE


      READ(UMIN,REC=NUMNUM) (LOCALPOINTS(J2),J2=1,3*NATOMS)

        DO 625 III=1,NRES
          TGCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
          TGCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
          TGCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
          TGCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
          TGCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
          TGCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
          TGCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
          TGCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
          TGCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
625     CONTINUE

        DO 205 INIT1 = 1,MAXRES
           DO 206 INIT2 = 1,MAXRES
                TGDIST(INIT1,INIT2) = 0.0D0
206        CONTINUE
205     CONTINUE

        DO 200 I=1,NRES-1
          DO 210 J=I+1,NRES
            TGDIST(I,J)=DSQRT((TGCORD(I,1,I2)-TGCORD(J,1,I2))**2 &
     +(TGCORD(I,2,I2)-TGCORD(J,2,I2))**2+(TGCORD(I,3,I2)-TGCORD(J,3,I2))**2 )
210       CONTINUE
200     CONTINUE

          DO 260 ISKIP=1,MAXRES
            DEL=DBLE(ISKIP)
            WIDTH(ISKIP)=1.0D0/(WIDTH0*(DEL)**WIDTHEXP)
260       CONTINUE

         QPOS=(NRES)*((NRES)-1.0D0)/2.0D0-(NRES)+1.0D0

         QTOT=0.0D0
         QSEGTOT=0.0D0
         QTOT_SHORT=0.0D0
         QTOT_MEDIUM=0.0D0
         QTOT_LONG=0.0D0
         QPOS_SHORT=0.0D0
         QPOS_MEDIUM=0.0D0
         QPOS_LONG=0.0D0

          DO I = 1, MAXRES
             GAP(I) = 0
          ENDDO

          NUM_FOLDON = 1 
          FOLDSTRT_MIN(1) = 1
          FOLDSTRT_MAX(1) = NRES

          IF ( NUM_FOLDON .NE. 1) THEN
             DO I = 1,NUM_FOLDON - 1
                  GAP(I) = FOLDSTRT_MIN(I+1) - FOLDSTRT_MAX(I) - 1
             ENDDO
          ENDIF

          DO I = 1,NUM_FOLDON
          IF ( I .EQ. 1) THEN
            DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                SEGLIST(J - (FOLDSTRT_MIN(I)-1)) = J
                NUMCONST = J - (FOLDSTRT_MIN(I)-1)
            ENDDO
          ENDIF

          TEMPGAP = 0

          IF ( I .NE. 1) THEN
              DO K = 1 , I - 1
                  TEMPGAP = TEMPGAP + GAP(K)
              ENDDO
              DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                  SEGLIST(J - TEMPGAP -  (FOLDSTRT_MIN(1)-1)) = J
                  NUMCONST = J - TEMPGAP  - (FOLDSTRT_MIN(1)-1)
              ENDDO
          ENDIF   ! IF ( I .NE. 1) THEN
          ENDDO

       DO 270 K = 1,  NUMCONST - 2
               I = SEGLIST(K)
        DO 280 L = K+2, NUMCONST
             J = SEGLIST(L)
             DEL=(TGDIST(I,J)-PATHDIST(I,J))*WIDTH(J-I)
             QTOT=QTOT+EXP(-DEL*DEL*0.5D0)

             IF (J-I.LT.5) THEN
              QTOT_SHORT=QTOT_SHORT+EXP(-DEL*DEL*0.5D0)
               QPOS_SHORT=QPOS_SHORT+1.0D0
             ELSEIF (J-I.LT.13) THEN
               QTOT_MEDIUM=QTOT_MEDIUM+EXP(-DEL*DEL*0.5D0)
               QPOS_MEDIUM=QPOS_MEDIUM+1.0D0
             ELSE
               QTOT_LONG=QTOT_LONG+EXP(-DEL*DEL*0.5D0)
               QPOS_LONG=QPOS_LONG+1.0D0
             ENDIF
280        CONTINUE
270      CONTINUE

         Q=QTOT/QPOS
         Q_SHORT=QTOT_SHORT/QPOS_SHORT
         Q_MEDIUM=QTOT_MEDIUM/QPOS_MEDIUM
         Q_LONG=QTOT_LONG/QPOS_LONG

         PRINT '(A,(G15.7),I6,I6)', 'AMHRELQ       ',Q,NUM,NUMNUM
         PRINT '(A,(G15.7),I6,I6)', 'AMHREL_SHORT  ',Q_SHORT,NUM,NUMNUM
         PRINT '(A,(G15.7),I6,I6)', 'AMHREL_MEDIUM ',Q_MEDIUM,NUM,NUMNUM
         PRINT '(A,(G15.7),I6,I6)', 'AMHREL_LONG   ',Q_LONG,NUM,NUMNUM
      END

!CCCC Q CONTACT Q CONTACT Q CONTACT Q CONTACT Q CONTACT CCCCCCCCCCC

      SUBROUTINE AMHQCONT(NUM,RCUT)
      USE UTILS
      USE COMMONS
      IMPLICIT NONE
      INTEGER J2,NUM,III,MAXRES,ISKIP
      PARAMETER (MAXRES=350)
      DOUBLE PRECISION LOCALPOINTS(3*NATOMS)
      DOUBLE PRECISION TGDIST(MAXRES,MAXRES)
      DOUBLE PRECISION PATHDIST(MAXRES,MAXRES),DEL
      REAL TGCORD(MAXRES,3,3)
      INTEGER NRES,J,ICOORD,I,I1,I2,INIT1,INIT2 
      INTEGER SEQ(MAXRES), K ,L
      INTEGER   GAP(MAXRES),TEMPGAP
      INTEGER   NUM_FOLDON,FOLDSTRT_MIN(10),FOLDSTRT_MAX(10)
      INTEGER   SEGLIST(MAXRES),NUMCONST

      DOUBLE PRECISION :: WIDTH0,WIDTHEXP
      DOUBLE PRECISION :: FINCORD(MAXRES,3,3),RCUT
      DOUBLE PRECISION :: QPOS_CUT,QTOT_CUT,QSEGTOT,Q,WIDTH(MAXRES)
      DOUBLE PRECISION :: Q_SHORT,Q_MEDIUM,Q_LONG
      DOUBLE PRECISION :: QPOS_SHORT_CUT,QPOS_MEDIUM_CUT,QPOS_LONG_CUT
      DOUBLE PRECISION :: QTOT_SHORT_CUT,QTOT_MEDIUM_CUT,QTOT_LONG_CUT

      CHARACTER TARFL*5

      DATA WIDTH0,WIDTHEXP / 1.0D0, 0.15D0 /  ! WAS 1.0, 0.5

      READ(UMIN,REC=WHICHMIN) (LOCALPOINTS(J2),J2=1,3*NATOMS)

      OPEN(UNIT=30,FILE='pro.list',STATUS='OLD',FORM='FORMATTED')
         READ (30,1000)TARFL
1000          FORMAT(A5)
      CLOSE(30)

        OPEN(17,FILE='proteins/'//TARFL,STATUS='OLD')
           READ(17,*)
           READ(17,*)NRES
           READ(17,201)(SEQ(J),J=1,NRES)
201        FORMAT (25(I2,1X))
          DO 130 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,1),I1=1,NRES)
1023        FORMAT(8(F8.3,1X))
130       CONTINUE
          DO 140 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,2),I1=1,NRES)
140       CONTINUE
          DO 150 ICOORD=1,3
            READ (17,1023) (TGCORD(I1,ICOORD,3),I1=1,NRES)
150       CONTINUE
         CLOSE(17)

        I2=1

        DO 205 INIT1 = 1,MAXRES
           DO 206 INIT2 = 1,MAXRES
                TGDIST(INIT1,INIT2) = 0.0D0
206        CONTINUE
205     CONTINUE

        DO 200 I=1,NRES-1
          DO 210 J=I+1,NRES
            TGDIST(I,J)=DSQRT( DBLE((TGCORD(I,1,I2)) &
                           -   DBLE(TGCORD(J,1,I2)))**2 &
                           +   DBLE((TGCORD(I,2,I2)) &
                           -   DBLE(TGCORD(J,2,I2)))**2 &
                           +   DBLE((TGCORD(I,3,I2)) &
                           -   DBLE(TGCORD(J,3,I2)))**2  )
            TGDIST(J,I)=TGDIST(I,J)
210       CONTINUE
200     CONTINUE

        DO 305 INIT1 = 1,MAXRES
           DO 306 INIT2 = 1,MAXRES
                PATHDIST(INIT1,INIT2) = 0.0D0
306        CONTINUE
305     CONTINUE

        DO 525 III=1,NRES 
          FINCORD(III, 1, 1) = LOCALPOINTS(9*(III-1)+1)!  CA X
          FINCORD(III, 2, 1) = LOCALPOINTS(9*(III-1)+2)!  CA Y
          FINCORD(III, 3, 1) = LOCALPOINTS(9*(III-1)+3)!  CA Z
          FINCORD(III, 1, 2) = LOCALPOINTS(9*(III-1)+4)!  CB X
          FINCORD(III, 2, 2) = LOCALPOINTS(9*(III-1)+5)!  CB Y
          FINCORD(III, 3, 2) = LOCALPOINTS(9*(III-1)+6)!  CB Z
          FINCORD(III, 1, 3) = LOCALPOINTS(9*(III-1)+7)!  O X
          FINCORD(III, 2, 3) = LOCALPOINTS(9*(III-1)+8)!  O Y
          FINCORD(III, 3, 3) = LOCALPOINTS(9*(III-1)+9)!  O Z
525     CONTINUE

        DO 300 I=1,NRES-1
          DO 310 J=I+1,NRES
            PATHDIST(I,J)=DSQRT((FINCORD(I,1,I2)-FINCORD(J,1,I2))**2 &
      +(FINCORD(I,2,I2)-FINCORD(J,2,I2))**2 +(FINCORD(I,3,I2)-FINCORD(J,3,I2))**2 )
            PATHDIST(J,I)=PATHDIST(I,J)
310       CONTINUE
300     CONTINUE

        DO 260 ISKIP=1,MAXRES
            DEL=DBLE(ISKIP)
            WIDTH(ISKIP)=1.0D0/(WIDTH0*(DEL)**WIDTHEXP)
260     CONTINUE

         QTOT_CUT=0.0D0
         QSEGTOT=0.0D0
         QTOT_SHORT_CUT=0.0D0
         QTOT_MEDIUM_CUT=0.0D0
         QTOT_LONG_CUT=0.0D0
         QPOS_SHORT_CUT=0.0D0
         QPOS_MEDIUM_CUT=0.0D0
         QPOS_LONG_CUT=0.0D0

          DO I = 1, MAXRES
             GAP(I) = 0
          ENDDO

          NUM_FOLDON = 1 
          FOLDSTRT_MIN(1) = 1
          FOLDSTRT_MAX(1) = NRES

          IF ( NUM_FOLDON .NE. 1) THEN
             DO I = 1,NUM_FOLDON - 1
                  GAP(I) = FOLDSTRT_MIN(I+1) - FOLDSTRT_MAX(I) - 1
             ENDDO
          ENDIF

          DO I = 1,NUM_FOLDON
          IF ( I .EQ. 1) THEN
            DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                SEGLIST(J - (FOLDSTRT_MIN(I)-1)) = J
                NUMCONST = J - (FOLDSTRT_MIN(I)-1)
            ENDDO
          ENDIF

          TEMPGAP = 0

          IF ( I .NE. 1) THEN
              DO K = 1 , I - 1
                  TEMPGAP = TEMPGAP + GAP(K)
              ENDDO
              DO J = FOLDSTRT_MIN(I), FOLDSTRT_MAX(I)
                  SEGLIST(J - TEMPGAP -  (FOLDSTRT_MIN(1)-1)) = J
                  NUMCONST = J - TEMPGAP  - (FOLDSTRT_MIN(1)-1)
              ENDDO
          ENDIF   ! IF ( I .NE. 1) THEN
          ENDDO

       DO 270 K = 1,  NUMCONST - 2
               I = SEGLIST(K)
        DO 280 L = K+2, NUMCONST
           J = SEGLIST(L)
           DEL=(TGDIST(I,J)-PATHDIST(I,J))*WIDTH(J-I)
             IF (TGDIST(I,J).LT.RCUT) THEN
                 QTOT_CUT=QTOT_CUT+EXP(-DEL*DEL*0.5D0)
                 QPOS_CUT=QPOS_CUT+1.0
               IF (J-I.LT.5) THEN
                  QTOT_SHORT_CUT=QTOT_SHORT_CUT+EXP(-DEL*DEL*0.5)
                  QPOS_SHORT_CUT=QPOS_SHORT_CUT+1.0
               ELSEIF (J-I.LT.13) THEN
                  QTOT_MEDIUM_CUT=QTOT_MEDIUM_CUT+EXP(-DEL*DEL*0.5)
                  QPOS_MEDIUM_CUT=QPOS_MEDIUM_CUT+1.0
               ELSE
                  QTOT_LONG_CUT=QTOT_LONG_CUT+EXP(-DEL*DEL*0.5)
                  QPOS_LONG_CUT=QPOS_LONG_CUT+1.0
             ENDIF
            ENDIF
280        CONTINUE
270       CONTINUE
         Q=QTOT_CUT/QPOS_CUT
         Q_SHORT=QTOT_SHORT_CUT/QPOS_SHORT_CUT
         Q_MEDIUM=QTOT_MEDIUM_CUT/QPOS_MEDIUM_CUT
         Q_LONG=QTOT_LONG_CUT/QPOS_LONG_CUT

         PRINT '(A,(G15.7),I6)', 'AMH_CONTACT       ',Q,NUM
         PRINT '(A,(G15.7),I6)', 'AMH_SHORTCONTACT  ',Q_SHORT,NUM
         PRINT '(A,(G15.7),I6)', 'AMH_MEDIUMCONTACT ',Q_MEDIUM,NUM
         PRINT '(A,(G15.7),I6)', 'AMH_LONGCONNTACT  ',Q_LONG,NUM
      END
