module ttm3f_mod
!----------------------------------------------------------------------------!
! Parameters of the TTM3F potential                                         !
!----------------------------------------------------------------------------!
! (12-10-6) inverse polynomial + exponential parameters for the vdw ineractions
double precision, parameter ::   &
                                 vdwC=-0.72298855D+03,vdwD=0.10211829D+06, vdwE=0.37170376D+01
! smearing factors for dipole-dipole(aDD), charge-charge/charge-dipole(aCCaCD)
double precision, parameter :: aDD=0.175d0, aCCaCD=0.175d0
!   ........... polarizabilities
double precision, parameter :: polarM=1.444d0
double precision, parameter :: polfacO=0.837d0, polfacH = 0.496d0, polfacM=0.837d0
double precision, parameter :: dms_param1 =0.5d0,dms_param2 = 0.9578d0, dms_param3=0.012d0
!   ...........   gammaM
double precision, parameter :: gammaM=0.46d0
!----------------------------------------------------------------------------!
! Parameters related to the accuracy of the energy/derivatives calculation   !
!----------------------------------------------------------------------------!
integer, parameter          :: MAXITER  = 400
double precision, parameter :: diptol   = 1.d-15 
double precision, parameter :: dmix     = 0.7d0
!----------------------------------------------------------------------------!
! CONSTANTS                                                                  !
!----------------------------------------------------------------------------!
double precision, parameter :: CHARGECON = 18.22234397655801030455d0
double precision, parameter :: DEBYE  = 4.8033324d0
!----------------------------------------------------------------------------!
! Variables and allocatable arrays needed by the "ttm3f" subroutine         !
!----------------------------------------------------------------------------!
integer :: fO, lO, fH, lH, fM, lM, fO3, lO3, fH3, lH3, fM3, lM3
integer :: Nw_old
integer :: Nats, Natsd, Natsq
double precision, dimension(:,:), allocatable :: RM
double precision, dimension(:,:), allocatable :: dRM
double precision, dimension(:,:), allocatable :: DDT
double precision, dimension( : ), allocatable :: dip
double precision, dimension( : ), allocatable :: pr_dip
double precision, dimension( : ), allocatable :: Efq
double precision, dimension( : ), allocatable :: Efd
double precision, dimension( : ), allocatable :: charge
double precision, dimension( : ), allocatable :: phi
double precision, dimension(:,:,:,:), allocatable :: grdq
end module ttm3f_mod
!*** Parameters used for the calculation of the potential energy and the
!*** Dipole moment of the water monomer. Taken from:
!*** "H. Partridge and D. W. Schwenke, J. Chem. Phys. 106, 4618 (1997)"
module mnasa_mod
implicit none
integer, dimension(245,3) :: idx
integer, dimension(84 ,3) :: idxD
double precision, dimension(84) :: coefD
double precision, dimension(245) :: c5zA, cbasis, ccore, crest
integer, dimension(9,3) :: idxm
double precision, dimension(9) :: cmass 
double precision :: reoh,thetae,b1,roh,alphaoh,deohA,phh1A,phh2
double precision :: f5z,fbasis,fcore,frest
double precision :: a,b,c0,c1,c2,b1D
data idx(:,1)/  &
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2,  &
       2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,  &
       2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,  &
       3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3,  &
       3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,  &
       4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4,  &
       4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6,  &
       6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5,  &
       6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5,  &
       5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7,  &
       7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6,  &
       6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 9, 9,  &
       9, 9, 9, 9, 9/
data idx(:,2)/ &
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  &
       1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,  &
       2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2,  &
       2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3,  &
       3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,  &
       2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3,  &
       3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,  &
       1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3,  &
       2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4,  &
       4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2,  &
       2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4,  &
       4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1,  &
       1, 1, 1, 1, 1/
data idx(:,3)/ &
       1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15, 1, 2, 3, 4, 5,  &
       6, 7, 8, 9,10,11,12,13,14, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,  &
      12,13, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13, 1, 2, 3, 4, 5,  &
       6, 7, 8, 9,10,11,12, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12, 1,  &
       2, 3, 4, 5, 6, 7, 8, 9,10,11, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,  &
      11, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11, 1, 2, 3, 4, 5, 6, 7, 8,  &
       9,10, 1, 2, 3, 4, 5, 6, 7, 8, 9,10, 1, 2, 3, 4, 5, 6, 7, 8,  &
       9,10, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9,  &
       1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2,  &
       3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6,  &
       7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3,  &
       4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2,  &
       3, 4, 5, 6, 7/
data c5zA(1:245)/  &
       4.2278462684916D+04, 4.5859382909906D-02, 9.4804986183058D+03, &
       7.5485566680955D+02, 1.9865052511496D+03, 4.3768071560862D+02, &
       1.4466054104131D+03, 1.3591924557890D+02,-1.4299027252645D+03, &
       6.6966329416373D+02, 3.8065088734195D+03,-5.0582552618154D+02, &
      -3.2067534385604D+03, 6.9673382568135D+02, 1.6789085874578D+03, &
      -3.5387509130093D+03,-1.2902326455736D+04,-6.4271125232353D+03, &
      -6.9346876863641D+03,-4.9765266152649D+02,-3.4380943579627D+03, &
       3.9925274973255D+03,-1.2703668547457D+04,-1.5831591056092D+04, &
       2.9431777405339D+04, 2.5071411925779D+04,-4.8518811956397D+04, &
      -1.4430705306580D+04, 2.5844109323395D+04,-2.3371683301770D+03, &
       1.2333872678202D+04, 6.6525207018832D+03,-2.0884209672231D+03, &
      -6.3008463062877D+03, 4.2548148298119D+04, 2.1561445953347D+04, &
      -1.5517277060400D+05, 2.9277086555691D+04, 2.6154026873478D+05, &
      -1.3093666159230D+05,-1.6260425387088D+05, 1.2311652217133D+05, &
      -5.1764697159603D+04, 2.5287599662992D+03, 3.0114701659513D+04, &
      -2.0580084492150D+03, 3.3617940269402D+04, 1.3503379582016D+04, &
      -1.0401149481887D+05,-6.3248258344140D+04, 2.4576697811922D+05, &
       8.9685253338525D+04,-2.3910076031416D+05,-6.5265145723160D+04, &
       8.9184290973880D+04,-8.0850272976101D+03,-3.1054961140464D+04, &
      -1.3684354599285D+04, 9.3754012976495D+03,-7.4676475789329D+04, &
      -1.8122270942076D+05, 2.6987309391410D+05, 4.0582251904706D+05, &
      -4.7103517814752D+05,-3.6115503974010D+05, 3.2284775325099D+05, &
       1.3264691929787D+04, 1.8025253924335D+05,-1.2235925565102D+04, &
      -9.1363898120735D+03,-4.1294242946858D+04,-3.4995730900098D+04, &
       3.1769893347165D+05, 2.8395605362570D+05,-1.0784536354219D+06, &
      -5.9451106980882D+05, 1.5215430060937D+06, 4.5943167339298D+05, &
      -7.9957883936866D+05,-9.2432840622294D+04, 5.5825423140341D+03, &
       3.0673594098716D+03, 8.7439532014842D+04, 1.9113438435651D+05, &
      -3.4306742659939D+05,-3.0711488132651D+05, 6.2118702580693D+05, &
      -1.5805976377422D+04,-4.2038045404190D+05, 3.4847108834282D+05, &
      -1.3486811106770D+04, 3.1256632170871D+04, 5.3344700235019D+03, &
       2.6384242145376D+04, 1.2917121516510D+05,-1.3160848301195D+05, &
      -4.5853998051192D+05, 3.5760105069089D+05, 6.4570143281747D+05, &
      -3.6980075904167D+05,-3.2941029518332D+05,-3.5042507366553D+05, &
       2.1513919629391D+03, 6.3403845616538D+04, 6.2152822008047D+04, &
      -4.8805335375295D+05,-6.3261951398766D+05, 1.8433340786742D+06, &
       1.4650263449690D+06,-2.9204939728308D+06,-1.1011338105757D+06, &
       1.7270664922758D+06, 3.4925947462024D+05,-1.9526251371308D+04, &
      -3.2271030511683D+04,-3.7601575719875D+05, 1.8295007005531D+05, &
       1.5005699079799D+06,-1.2350076538617D+06,-1.8221938812193D+06, &
       1.5438780841786D+06,-3.2729150692367D+03, 1.0546285883943D+04, &
      -4.7118461673723D+04,-1.1458551385925D+05, 2.7704588008958D+05, &
       7.4145816862032D+05,-6.6864945408289D+05,-1.6992324545166D+06, &
       6.7487333473248D+05, 1.4361670430046D+06,-2.0837555267331D+05, &
       4.7678355561019D+05,-1.5194821786066D+04,-1.1987249931134D+05, &
       1.3007675671713D+05, 9.6641544907323D+05,-5.3379849922258D+05, &
      -2.4303858824867D+06, 1.5261649025605D+06, 2.0186755858342D+06, &
      -1.6429544469130D+06,-1.7921520714752D+04, 1.4125624734639D+04, &
      -2.5345006031695D+04, 1.7853375909076D+05,-5.4318156343922D+04, &
      -3.6889685715963D+05, 4.2449670705837D+05, 3.5020329799394D+05, &
       9.3825886484788D+03,-8.0012127425648D+05, 9.8554789856472D+04, &
       4.9210554266522D+05,-6.4038493953446D+05,-2.8398085766046D+06, &
       2.1390360019254D+06, 6.3452935017176D+06,-2.3677386290925D+06, &
      -3.9697874352050D+06,-1.9490691547041D+04, 4.4213579019433D+04, &
       1.6113884156437D+05,-7.1247665213713D+05,-1.1808376404616D+06, &
       3.0815171952564D+06, 1.3519809705593D+06,-3.4457898745450D+06, &
       2.0705775494050D+05,-4.3778169926622D+05, 8.7041260169714D+03, &
       1.8982512628535D+05,-2.9708215504578D+05,-8.8213012222074D+05, &
       8.6031109049755D+05, 1.0968800857081D+06,-1.0114716732602D+06, &
       1.9367263614108D+05, 2.8678295007137D+05,-9.4347729862989D+04, &
       4.4154039394108D+04, 5.3686756196439D+05, 1.7254041770855D+05, &
      -2.5310674462399D+06,-2.0381171865455D+06, 3.3780796258176D+06, &
       7.8836220768478D+05,-1.5307728782887D+05,-3.7573362053757D+05, &
       1.0124501604626D+06, 2.0929686545723D+06,-5.7305706586465D+06, &
      -2.6200352535413D+06, 7.1543745536691D+06,-1.9733601879064D+04, &
       8.5273008477607D+04, 6.1062454495045D+04,-2.2642508675984D+05, &
       2.4581653864150D+05,-9.0376851105383D+05,-4.4367930945690D+05, &
       1.5740351463593D+06, 2.4563041445249D+05,-3.4697646046367D+03, &
      -2.1391370322552D+05, 4.2358948404842D+05, 5.6270081955003D+05, &
      -8.5007851251980D+05,-6.1182429537130D+05, 5.6690751824341D+05, &
      -3.5617502919487D+05,-8.1875263381402D+02,-2.4506258140060D+05, &
       2.5830513731509D+05, 6.0646114465433D+05,-6.9676584616955D+05, &
       5.1937406389690D+05, 1.7261913546007D+05,-1.7405787307472D+04, &
      -3.8301842660567D+05, 5.4227693205154D+05, 2.5442083515211D+06, &
      -1.1837755702370D+06,-1.9381959088092D+06,-4.0642141553575D+05, &
       1.1840693827934D+04,-1.5334500255967D+05, 4.9098619510989D+05, &
       6.1688992640977D+05, 2.2351144690009D+05,-1.8550462739570D+06, &
       9.6815110649918D+03,-8.1526584681055D+04,-8.0810433155289D+04, &
       3.4520506615177D+05, 2.5509863381419D+05,-1.3331224992157D+05, &
      -4.3119301071653D+05,-5.9818343115856D+04, 1.7863692414573D+03, &
       8.9440694919836D+04,-2.5558967650731D+05,-2.2130423988459D+04, &
       4.4973674518316D+05,-2.2094939343618D+05/
!
!     expansion coefficients for basis correction
!
data cbasis(1:245)/ &
       6.9770019624764D-04,-2.4209870001642D+01, 1.8113927151562D+01, &
       3.5107416275981D+01,-5.4600021126735D+00,-4.8731149608386D+01, &
       3.6007189184766D+01, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
      -7.7178474355102D+01,-3.8460795013977D+01,-4.6622480912340D+01, &
       5.5684951167513D+01, 1.2274939911242D+02,-1.4325154752086D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00,-6.0800589055949D+00, &
       8.6171499453475D+01,-8.4066835441327D+01,-5.8228085624620D+01, &
       2.0237393793875D+02, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       3.3525582670313D+02, 7.0056962392208D+01,-4.5312502936708D+01, &
      -3.0441141194247D+02, 2.8111438108965D+02, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-1.2983583774779D+02, 3.9781671212935D+01, &
      -6.6793945229609D+01,-1.9259805675433D+02, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-8.2855757669957D+02,-5.7003072730941D+01, &
      -3.5604806670066D+01, 9.6277766002709D+01, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 8.8645622149112D+02,-7.6908409772041D+01, &
       6.8111763314154D+01, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       2.5090493428062D+02,-2.3622141780572D+02, 5.8155647658455D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 2.8919570295095D+03, &
      -1.7871014635921D+02,-1.3515667622500D+02, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-3.6965613754734D+03, 2.1148158286617D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00,-1.4795670139431D+03, &
       3.6210798138768D+02, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
      -5.3552886800881D+03, 3.1006384016202D+02, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 1.6241824368764D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 4.3764909606382D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 1.0940849243716D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 3.0743267832931D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00/
!
!     expansion coefficients for core correction
!
data ccore(1:245)/ &
       2.4332191647159D-02,-2.9749090113656D+01, 1.8638980892831D+01, &
      -6.1272361746520D+00, 2.1567487597605D+00,-1.5552044084945D+01, &
       8.9752150543954D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
      -3.5693557878741D+02,-3.0398393196894D+00,-6.5936553294576D+00, &
       1.6056619388911D+01, 7.8061422868204D+01,-8.6270891686359D+01, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00,-3.1688002530217D+01, &
       3.7586725583944D+01,-3.2725765966657D+01,-5.6458213299259D+00, &
       2.1502613314595D+01, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       5.2789943583277D+02,-4.2461079404962D+00,-2.4937638543122D+01, &
      -1.1963809321312D+02, 2.0240663228078D+02, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-6.2574211352272D+02,-6.9617539465382D+00, &
      -5.9440243471241D+01, 1.4944220180218D+01, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-1.2851139918332D+03,-6.5043516710835D+00, &
       4.0410829440249D+01,-6.7162452402027D+01, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 1.0031942127832D+03, 7.6137226541944D+01, &
      -2.7279242226902D+01, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
      -3.3059000871075D+01, 2.4384498749480D+01,-1.4597931874215D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 1.6559579606045D+03, &
       1.5038996611400D+02,-7.3865347730818D+01, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-1.9738401290808D+03,-1.4149993809415D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00,-1.2756627454888D+02, &
       4.1487702227579D+01, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
      -1.7406770966429D+03,-9.3812204399266D+01, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-1.1890301282216D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 2.3723447727360D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-1.0279968223292D+03, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 5.7153838472603D+02, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00/
!
!     expansion coefficients for v rest
!
data crest(1:245)/ &
       0.0000000000000D+00,-4.7430930170000D+00,-1.4422132560000D+01, &
      -1.8061146510000D+01, 7.5186735000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
      -2.7962099800000D+02, 1.7616414260000D+01,-9.9741392630000D+01, &
       7.1402447000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00,-7.8571336480000D+01, &
       5.2434353250000D+01, 7.7696745000000D+01, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       1.7799123760000D+02, 1.4564532380000D+02, 2.2347226000000D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-4.3823284100000D+02,-7.2846553000000D+02, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00,-2.6752313750000D+02, 3.6170310000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00, 0.0000000000000D+00, &
       0.0000000000000D+00, 0.0000000000000D+00/
!
!     expansion indicies for mass correction
!
       data idxm/1,2,1,1,3,2,1,2,1, &
                 2,1,1,3,1,2,2,1,1, &
                 1,1,2,1,1,1,2,2,3/
!
!     expansion coefficients for mass correction
!
       data cmass/ -8.3554183D+00,3.7036552D+01,-5.2722136D+00, &
            1.6843857D+01,-7.0929741D+01,5.5380337D+00,-2.9962997D+01, &
            1.3637682D+02,-3.0530195d+00/
!
!     two body parameters
!
       data reoh,thetae,b1,roh,alphaoh,deohA,phh1A,phh2/0.958649d0, &
            104.3475d0,2.0d0,0.9519607159623009d0,2.587949757553683d0, &
            42290.92019288289d0,16.94879431193463d0,12.66426998162947d0/
!
!     scaling factors for contributions to emperical potential
!
       data f5z,fbasis,fcore,frest/0.99967788500000d0, &
           0.15860145369897d0,-1.6351695982132d0,1d0/

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
data idxD(1:84,1)/ &
       1, 1, 1, 2, 1, 1, 1, 2, 2, 3, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, &
       1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 1, 1, 1, 1, 1, &
       1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 6, 1, 1, 1, 1, &
       1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, &
       5, 6, 6, 7/ 
data idxD(1:84,2)/ &
       1, 1, 2, 1, 1, 2, 3, 1, 2, 1, 1, 2, 3, 4, 1, 2, 3, 1, 2, 1, &
       1, 2, 3, 4, 5, 1, 2, 3, 4, 1, 2, 3, 1, 2, 1, 1, 2, 3, 4, 5, &
       6, 1, 2, 3, 4, 5, 1, 2, 3, 4, 1, 2, 3, 1, 2, 1, 1, 2, 3, 4, &
       5, 6, 7, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 1, 2, 3, 4, 1, 2, &
       3, 1, 2, 1/
data idxD(1:84,3)/ &
       1, 2, 1, 1, 3, 2, 1, 2, 1, 1, 4, 3, 2, 1, 3, 2, 1, 2, 1, 1, &
       5, 4, 3, 2, 1, 4, 3, 2, 1, 3, 2, 1, 2, 1, 1, 6, 5, 4, 3, 2, &
       1, 5, 4, 3, 2, 1, 4, 3, 2, 1, 3, 2, 1, 2, 1, 1, 7, 6, 5, 4, &
       3, 2, 1, 6, 5, 4, 3, 2, 1, 5, 4, 3, 2, 1, 4, 3, 2, 1, 3, 2, &
       1, 2, 1, 1/
data coefD(1:84) /&
      -2.1689686086730D-03, 1.4910379754728D-02, 5.3546078430060D-02, &
      -7.4055995388666D-02,-3.7764333017616D-03, 1.4089887256484D-01, &
      -6.2584207687264D-02,-1.1260393113022D-01,-5.7824159269319D-02, &
       1.4360743650655D-02,-1.5469680141070D-02,-1.3036350092795D-02, &
       2.7515837781556D-02, 1.4098478875076D-01,-2.7663168397781D-02, &
      -5.2378176254797D-03,-1.0237198381792D-02, 8.9571999265473D-02, &
       7.2920263098603D-03,-2.6873260551686D-01, 2.0220870325864D-02, &
      -7.0764766270927D-02, 1.2140640273760D-01, 2.0978491966341D-02, &
      -1.9443840512668D-01, 4.0826835370618D-02,-4.5365190474650D-02, &
       6.2779900072132D-02,-1.3194351021000D-01,-1.4673032718563D-01, &
       1.1894031277247D-01,-6.4952851564679D-03, 8.8503610374493D-02, &
       1.4899437409291D-01, 1.3962841511565D-01,-2.6459446720450D-02, &
      -5.0128914532773D-02, 1.8329676428116D-01,-1.5559089125095D-01, &
      -4.0176879767592D-02, 3.6192059996636D-01, 1.0202887240343D-01, &
       1.9318668580051D-01,-4.3435977107932D-01,-4.2080828803311D-02, &
       1.9144626027273D-01,-1.7851138969948D-01, 1.0524533875070D-01, &
      -1.7954071602185D-02, 5.2022455612120D-02,-2.8891891146828D-01, &
      -4.7452036576319D-02,-1.0939400546289D-01, 3.5916564473568D-01, &
      -2.0162789820172D-01,-3.5838629543696D-01, 5.6706523551202D-03, &
       1.3849337488211D-01,-4.1733982195604D-01, 4.1641570764241D-01, &
      -1.2243429796296D-01, 4.7141730971228D-02,-1.8224510249551D-01, &
      -1.8880981556620D-01,-3.1992359561800D-01,-1.8567550546587D-01, &
       6.1850530431280D-01,-6.1142756235141D-02,-1.6996135584933D-01, &
       5.4252879499871D-01, 6.6128603899427D-01, 1.2107016404639D-02, &
      -1.9633639729189D-01, 2.7652059420824D-03,-2.2684111109778D-01, &
      -4.7924491598635D-01, 2.4287790137314D-01,-1.4296023329441D-01, &
       8.9664665907006D-02,-1.4003228575602D-01,-1.3321543452254D-01,&
      -1.8340983193745D-01, 2.3426707273520D-01, 1.5141050914514D-01/
data b1D/1.d0/
data a,b,c0,c1,c2/0.2999d0,-0.6932d0,1.0099d0,-0.1801d0,0.0892d0/

end module mnasa_mod

function gamma1(x)
implicit none
double precision :: x
double precision :: gamma1
integer :: J
double precision :: SER,STP,TMP,Y
double precision, DIMENSION(6) :: COF
SAVE cof,stp
data COF,STP/76.18009172947146D0,-86.50532032941677d0,24.01409824083091D0,  &
            -1.231739572450155D0,.1208650973866179D-2,-.5395239384953D-5, &
            2.5066282746310005D0/
Y=X
TMP=X+5.5D0
TMP=(X+0.5D0)*DLOG(TMP)-TMP
SER=1.000000000190015D0
do j=1,6
   Y=Y+1.D0
   SER=SER+COF(J)/Y
enddo
gamma1=TMP+DLOG(STP*SER/X)
END FUNCTION gamma1
function gamma4(a,x)
implicit none
double precision :: gamma4
double precision :: a, x
double precision :: gamser, gammcf, gln
if (x<a+1.d0) then
   call gamma2(gamser, a, x, gln)
   gamma4 = 1.d0 - gamser
else
   call gamma3(gammcf, a, x, gln)
   gamma4 = gammcf
endif
end function gamma4
subroutine gamma2(gamser, a, x, gln)
implicit none
double precision :: gamser
double precision :: a, x, gln
integer          :: n
integer, parameter :: ITMAX = 800
double precision, parameter :: EPS = 3.d-7
double precision :: ap, ssum, del, gamma1
gln = gamma1(a)
ap = a
ssum = 1.d0 / a
del =ssum
do n=1, ITMAX
   ap = ap+1.d0
   del = del*x/ap
   ssum = ssum+del
   if (dabs(del) .lt. dabs(ssum)*EPS) goto 1
enddo
1 gamser = ssum*dexp(-x+a*dlog(x)-gln)
end subroutine gamma2
subroutine gamma3(gammcf, a, x, gln)
implicit none
double precision :: gammcf
double precision :: a, x, gln
integer          :: i
double precision :: an, b, c, d, del, h, gamma1
integer,parameter :: ITMAX = 100
double precision, parameter :: EPS = 3.d-7, FPMIN=1.d-30
gln = gamma1(a)
b = x+1.d0-a
c = 1.d0/FPMIN
d = 1.d0/b
h=d
do i=1, ITMAX
   an = -i*(i-a)
   b = b+2.d0
   d = an*d+b
   if (dabs(d) < FPMIN) d=FPMIN
   c = b+an/c
   if (dabs(c) < FPMIN) c=FPMIN
   d = 1.d0/d
   del = d*c
   h = h*del
   if (dabs(del-1.d0) < EPS) goto 1
enddo
1 gammcf=dexp(-x+a*dlog(x)-gln)*h
end subroutine gamma3
subroutine smear01(drsq, pol12, a, ts0, ts1)
implicit none
double precision, parameter :: g23=1.3541179394264d0
double precision, intent(in) :: drsq, pol12, a
double precision, intent(out) :: ts0, ts1
double precision :: dd,dri,drsqi,AA, rA,rA3,exp1, a_sqrt3 
double precision, external :: gamma4

dd = dsqrt(drsq)
dri = 1.d0/dd
drsqi = dri*dri

AA = (pol12)**(1.d0/6.d0)
rA = dd/AA
rA3 = rA**3
exp1 = dexp(-a*rA3)
a_sqrt3 = a**(1.d0/3.d0)

ts0 = (1.d0-exp1 + a_sqrt3*rA*g23*gamma4(2.d0/3.d0,a*ra3))*dri
ts1 = (1.d0 -exp1)*dri*drsqi
end subroutine smear01
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine smear1(drsq, pol12, a, ts1)
implicit none
double precision, intent(in) :: drsq, pol12, a
double precision, intent(out) :: ts1
double precision :: dd,dri,drsqi,AA, rA,rA3,exp1
double precision, external :: gamma4

dd = dsqrt(drsq)
dri = 1.d0/dd
drsqi = dri*dri

AA = (pol12)**(1.d0/6.d0)
rA = dd/AA
rA3 = rA**3
exp1 = dexp(-a*rA3)
ts1 = (1.d0 -exp1)*dri*drsqi
end subroutine smear1
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine smear2(drsq, pol12, a, ts1, ts2)
implicit none
double precision, intent(in) :: drsq, pol12, a
double precision, intent(out) :: ts1, ts2
double precision :: dd,dri,drsqi,AA, rA,rA3,exp1

dd = dsqrt(drsq)
dri = 1.d0/dd
drsqi = dri*dri

AA = (pol12)**(1.d0/6.d0)
rA = dd/AA
rA3 = rA**3
exp1 = dexp(-a*rA3)
ts1 = (1.d0 -exp1)*dri*drsqi
ts2 = (ts1 - exp1*a/AA**3) *drsqi
end subroutine smear2
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine smear3(drsq, pol12, a, ts1, ts2, ts3)
implicit none
double precision, intent(in) :: drsq, pol12, a
double precision, intent(out) :: ts1, ts2, ts3
double precision :: dd,dri,drsqi,AA, rA,rA3,exp1

dd = dsqrt(drsq)
dri = 1.d0/dd
drsqi = dri*dri

AA = (pol12)**(1.d0/6.d0)
rA = dd/AA
rA3 = rA**3
exp1 = dexp(-a*rA3)
ts1 = (1.d0 -exp1)*dri*drsqi
ts2 = (ts1 - exp1*a/AA**3) *drsqi
ts3 = (ts2 - 0.6d0*exp1*dd*a*a/AA**6) * drsqi

end subroutine smear3

!***
!***  allocate necessery arrays needed for the calculation of the potenial
!***
subroutine init_ttm3f(Nw)
use ttm3f_mod
implicit none
integer, intent(in) :: Nw
logical :: alloc


if (.not. allocated(RM)) then
   alloc = .true.
else if (Nw/=Nw_old) then
   alloc = .true.
   deallocate( RM )    ! temporary array keeping the coordinates of the Msite
   deallocate( dRM )   ! temporary array keeping the derivatives of the Msite
   deallocate( DDT )   ! dipole tensor
   deallocate( dip )   ! array containg the induced dipoles
   deallocate( pr_dip )  ! 
   deallocate( phi )    ! electrostatic potential
   deallocate( Efq )     ! electric field from charges
   deallocate( Efd )     ! electric field from dipoles
   deallocate( charge )  ! charges 
   deallocate( grdq )    ! dericatives of charge wrt monomer geometry
else
   alloc = .false.
endif

if (alloc) then
   Natsq = 3*Nw       ! # of atoms with charge   (including M-sites)
   Natsd =   Nw       ! # of atoms with dipole   (including M-sites)
   Nats  = 4*Nw       ! # of total atoms         (including M-sites)
   Nw_old = Nw
   fO = 1             ! index on the first oxygen
   lO = Nw            ! index on the last oxygen        
   fH = Nw+1          ! index on the first hydrogen
   lH = 3*Nw          ! index on the last hydrogen
   fM = 3*Nw+1        ! index on the first M-site
   lM = 4*Nw          ! index on the lst M-site
   fO3 = 3*fO-2  ! index on the x-comp. (out of the x,y,z) of the first oxygen
   lO3 = 3*lO    ! index on the x-comp. (out of the x,y,z) of the last oxygen
   fH3 = 3*fH-2  ! index on the x-comp. (out of the x,y,z) of the first hydrogen
   lH3 = 3*lH    ! index on the x-comp. (out of the x,y,z) of the last hydrogen
   fM3 = 3*fM-2  ! index on the x-comp. (out of the x,y,z) of the first M-site
   lM3 = 3*lM    ! index on the x-comp. (out of the x,y,z) of the last M-site

   allocate(charge(fO:lM))          
   allocate(RM (3, fM:lM))          
   allocate(dRM(3, fM:lM))         
   allocate(dip(fM3:lM3))
   allocate(pr_dip(fM3:lM3))
   allocate(phi(fH:lM))
   allocate(Efq(fO3:lM3))
   allocate(Efd(fM3:lM3))
   allocate( DDT(fM3:lM3, fM3:lM3) )
   allocate( grdq(Nw, 3, 3, 3) )
endif

end subroutine init_ttm3f
subroutine ttm3f(Nw,RR,dRR,En)
!** for a system of "Nw" water molecules returns the potential energy (En) and 
!** the derivatives of the energy wrt the atomic displacements (dRR).
!** The coordinates of the atoms are found in the array "RR".
!** NOTE. It is very important the input coordinates to be stored in the
!** array RR in the proper way. The first column of RR has dimension 3 that
!** corresponds to the x,y,z- cartesian coordinates, while in the second one 
!** all the oxygens of the system should be saved before the hydrogens.
!** It follows an example for a system with 3-water molecules (Nw=3)
!**   RR(1:3, 1)   = x,y,z-coordinates of the Oxygen of the first molecule
!**   RR(1:3, 2)   = x,y,z-coordinates of the Oxygen of the second molecule
!**   RR(1:3, 3)   = x,y,z-coordinates of the Oxygen of the third molecule
!**   RR(1:3, 4)   = x,y,z-coordinates of the hydrogen-1 of the first molecule
!**   RR(1:3, 5)   = x,y,z-coordinates of the hydrogen-2 of the first molecule
!**   RR(1:3, 6)   = x,y,z-coordinates of the hydrogen-1 of the second molecule
!**   RR(1:3, 7)   = x,y,z-coordinates of the hydrogen-2 of the second molecule
!**   RR(1:3, 8)   = x,y,z-coordinates of the hydrogen-1 of the third molecule
!**   RR(1:3, 9)   = x,y,z-coordinates of the hydrogen-2 of the third molecule
use ttm3f_mod
implicit none
integer, intent(in) :: Nw
double precision, dimension(3, 3*Nw), intent(in)  ::  RR
double precision, dimension(3, 3*Nw), intent(out) :: dRR
double precision, intent(out) :: En
!
integer :: iter, i3, j3, isp, jsp, ix, iy, iw, jw, iat, jat, iO, iH1, iH2, iM
double precision, dimension(3) :: Ri, Rij
double precision, dimension(3,3) :: r1, dr1, dd3
double precision, dimension(3) :: q3, di, dj, derij
double precision, dimension(3,3,3) :: dq3
double precision :: dRijsq, dRij, dR6, dR10, dR12
double precision :: Eint, Evdw, Eelec, Eind, e1
double precision :: deltadip,tmp,expon, stath, didj, dir, djr,qi,qj
double precision :: ts0, ts1, ts2, ts3

!-------------------------------------------------------------------------!
! initialize (if neccesary) some arrays, needed for following calculations!
!-------------------------------------------------------------------------!
call init_ttm3f(Nw)
dRR = 0.d0
dRM = 0.d0
Eint = 0.d0
Evdw = 0.d0
Eelec = 0.d0
Eind = 0.d0
Efq = 0.d0
phi = 0.d0
ddt = 0.d0
!-------------------------------------------------------------------------!
! calculate the coordinates of the Msites and store them in RM            !
!-------------------------------------------------------------------------!
do iw=1, Nw
   iO  = fO + iw-1
   iH1 = fH + 2*iw - 2
   iH2 = fH + 2*iw - 1
   iM  = fM + iw-1
   RM(1:3,iM) = RR(1:3,iO)*(1.d0-gammaM) + &
                           0.5d0*gammaM*( RR(1:3,iH1) + RR(1:3,iH2) )
enddo
!-------------------------------------------------------------------------!
! calculates the INTRA-molecular energy and Dipole Moment Surface         !
!                     according the Partridge Sw  (JCP     )              !
!-------------------------------------------------------------------------!
tmp = 0.5d0*gammaM/(1.d0-gammaM)
do iw=1, Nw
   iO  = fO + iw-1
   iH1 = fH+2*iw-2
   iH2 = fH+2*iw-1
   iM  = fM + iw-1
   r1(1:3, 1:3) = RR(1:3, (/iO, iH1, iH2/) )
   call pot_nasa(r1, dr1, e1)
   call dms_nasa(r1, q3, dq3)
   Eint = Eint + e1
   dRR(1:3, (/iO,iH1,iH2/) ) = dr1
   charge(iH1)  = q3(2)+tmp*(q3(2)+q3(3) )
   charge(iH2)  = q3(3)+tmp*(q3(2)+q3(3) )
   charge(iM )  = q3(1) / (1.d0-gammaM)
   grdq(iw,1,1,:)= dq3(1,1,:) + tmp*(dq3(1,1,:)+dq3(1,2,:))
   grdq(iw,2,1,:)= dq3(2,1,:) + tmp*(dq3(2,1,:)+dq3(2,2,:))
   grdq(iw,3,1,:)= dq3(3,1,:) + tmp*(dq3(3,1,:)+dq3(3,2,:))

   grdq(iw,1,2,:)= dq3(1,2,:) + tmp*(dq3(1,1,:)+dq3(1,2,:))
   grdq(iw,2,2,:)= dq3(2,2,:) + tmp*(dq3(2,1,:)+dq3(2,2,:))
   grdq(iw,3,2,:)= dq3(3,2,:) + tmp*(dq3(3,1,:)+dq3(3,2,:))

   grdq(iw,1,3,:)= dq3(1,3,:)-2.d0*tmp*(dq3(1,1,:)+dq3(1,2,:))
   grdq(iw,2,3,:)= dq3(2,3,:)-2.d0*tmp*(dq3(2,1,:)+dq3(2,2,:))
   grdq(iw,3,3,:)= dq3(3,3,:)-2.d0*tmp*(dq3(3,1,:)+dq3(3,2,:))
enddo
charge = charge*CHARGECON
grdq   = grdq*CHARGECON
!-------------------------------------------------------------------------!
! Calculate the CHARGE-CHARGE interactions for all atoms                  !
!-------------------------------------------------------------------------!
do iw=1, Nw-1
   do jw=iw+1, Nw
      !Oxygen-Oxygen interactions
      iat=fO+iw-1          ! iat=Oxygen-1   
      jat=fO+jw-1          ! jat=Oxygen-2
      Rij=RR(:,iat) - RR(:,jat)
      dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
      dRij = dsqrt(dRijsq)
      !... vdw interactions
      dR6 = dRijsq**3
      dR10=dR6*dRijsq*dRijsq
      dR12=dR6*dR6
      expon = vdwD*dexp(-vdwE*dRij)
      Evdw = Evdw + vdwC/dR6 + expon
      tmp=-(6.d0*vdwC/dR6)/dRijsq -vdwE*expon/dRij
      dRR(:,iat) = dRR(:,iat) + tmp * Rij
      dRR(:,jat) = dRR(:,jat) - tmp * Rij
      !Hydrogen-Hydrogen interactions
      do isp=1, 2
         iat=fH+2*(iw-1)+ isp-1   ! iat=Hydrogen-1A/Hydrogen-1B
         Ri = RR(1:3, iat)
         do jsp=1, 2
            jat=fH+2*(jw-1)+ jsp-1   ! jat=Hydrogen-2A/Hydrogen-2B
            Rij = Ri - RR(1:3, jat)
            dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
            call smear01(dRijsq, polfacH**2, aCCaCD, ts0, ts1)
            phi(iat) = phi(iat) + ts0*charge(jat)
            phi(jat) = phi(jat) + ts0*charge(iat)
            Efq(3*iat-2:3*iat) = Efq(3*iat-2:3*iat) + ts1*charge(jat)*Rij
            Efq(3*jat-2:3*jat) = Efq(3*jat-2:3*jat) - ts1*charge(iat)*Rij
         enddo
      enddo
      !Msite-Msite interactions
      iat=fM+iw-1          ! iat=Msite-1   
      jat=fM+jw-1          ! jat=Msite-2
      Rij=RM(:,iat) - RM(:,jat)
      dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
      call smear01(dRijsq, polfacM**2, aCCaCD, ts0, ts1)
      phi(iat) = phi(iat) + ts0*charge(jat)
      phi(jat) = phi(jat) + ts0*charge(iat)
      Efq(3*iat-2:3*iat) = Efq(3*iat-2:3*iat) + ts1*charge(jat)*Rij
      Efq(3*jat-2:3*jat) = Efq(3*jat-2:3*jat) - ts1*charge(iat)*Rij
   enddo
enddo
do iw=1, Nw
   do jw=1, Nw
      if (iw/=jw) then
         !Msite-Hydrogen interactions
         iat = fM + iw -1   ! iat=Msite
         Ri = RM(1:3, iat)
         do jsp=1,2
            jat = fH+2*(jw-1) + jsp-1  !jat = hydrogen-2
            Rij = Ri - RR(1:3, jat)
            dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
            call smear01(dRijsq, polfacH*polfacM, aCCaCD, ts0, ts1)
            phi(iat) = phi(iat) + ts0*charge(jat)
            phi(jat) = phi(jat) + ts0*charge(iat)
            Efq(3*iat-2:3*iat) = Efq(3*iat-2:3*iat) + ts1*charge(jat)*Rij
            Efq(3*jat-2:3*jat) = Efq(3*jat-2:3*jat) - ts1*charge(iat)*Rij
         enddo
      endif 
   enddo
enddo
!-------------------------------------------------------------------------!
! Calculate the DIPOLE-DIPOLE TENSOR Array.  (according to the Tholes   --!  
!   model the intra-molecular interactions  should be also considered)  --!
!-------------------------------------------------------------------------!
do iat=fM, lM-1
   i3=3*iat-2
   Ri = RM(:, iat)
   do jat=iat+1, lM
      j3=3*jat-2
      Rij = Ri - RM(:, jat)
      dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
      call smear2(dRijsq, polfacM**2, aDD, ts1, ts2)
      dd3(1,1) = 3.d0*ts2*Rij(1)*Rij(1) - ts1
      dd3(2,2) = 3.d0*ts2*Rij(2)*Rij(2) - ts1
      dd3(3,3) = 3.d0*ts2*Rij(3)*Rij(3) - ts1
      dd3(1,2) = 3.d0*ts2*Rij(1)*Rij(2)
      dd3(1,3) = 3.d0*ts2*Rij(1)*Rij(3)
      dd3(2,3) = 3.d0*ts2*Rij(2)*Rij(3)
      dd3(2,1)=dd3(1,2); dd3(3,1)=dd3(1,3); dd3(3,2)=dd3(2,3)
      ddt(i3:i3+2, j3:j3+2) = dd3
      ddt(j3:j3+2, i3:i3+2) = dd3
   enddo  ! do jat=iat+1, Natsd
enddo  ! do iat=1, Natsd
!-------------------------------------------------------------------------!
! Calculate the induced Electric Field using an iterative proced.         !
!-------------------------------------------------------------------------!
dip(fM3:lM3) = polarM*Efq(fM3:lM3)
pr_dip(fM3:lM3) = dip(fM3:lM3)   ! keep the previous dipole

stath = DEBYE/CHARGECON/dsqrt(dble(Natsd))
do iter=1, MAXITER
   Efd = matmul(ddt, dip)
   dip(fM3:lM3) = polarM*( Efq(fM3:lM3) + Efd(fM3:lM3) )
   dip(fM3:lM3) = dmix*dip(fM3:lM3) + (1.d0-dmix)*pr_dip(fM3:lM3)
   deltadip = sum(  (dip(fM3:lM3)-pr_dip(fM3:lM3))**2  )
   deltadip = dsqrt(deltadip)*stath
!   print*,'iter=',iter, deltadip
   if (deltadip<diptol) then
      goto 100
   else
      pr_dip(fM3:lM3) = dip(fM3:lM3)
   endif
enddo
100 Continue
Eelec = 0.5d0*sum(charge(fH:lM)*phi(fH:lM))
Eind = -0.5d0*sum(dip(fM3:lM3)*Efq(fM3:lM3))
En = Eint + Evdw + Eelec + Eind
!print*,'Eint=',Eint; print*,'Evdw', Evdw; print*,'Eelec=',Eelec; print*,'Eind=',Eind
!-------------------------------------------------------------------------!
!---------  Calculate the remaining part of the derivatives   ------------!
!-------------------------------------------------------------------------!
!....... derivatives due to charge-charge interaction
do iat=fH, lH
   dRR(:,iat) = dRR(:,iat) - charge(iat)*Efq(3*iat-2:3*iat)
enddo
do iat=fM, lM
   dRM(:,iat) = dRM(:,iat) - charge(iat)*Efq(3*iat-2:3*iat)
enddo
!....... derivatives due to charge-dipole and dipole-dipole interaction
do iw=1, Nw-1
   do jw=iw+1, Nw
      !Msite-Msite interactions
      iat=fM+iw-1          ! iat=Msite-1   
      jat=fM+jw-1          ! jat=Msite-2
      Rij=RM(:,iat) - RM(:,jat)
      dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
      call smear3(dRijsq, polfacM**2, aDD, ts1, ts2, ts3)
      qi = charge(iat)
      qj = charge(jat)
      di = dip(3*iat-2:3*iat)  ! dipole-I
      dj = dip(3*jat-2:3*jat)  ! dipole-J
      didj = di(1)*dj(1) + di(2)*dj(2) + di(3)*dj(3)
      dir = di(1)*Rij(1) + di(2)*Rij(2) + di(3)*Rij(3)
      djr = dj(1)*Rij(1) + dj(2)*Rij(2) + dj(3)*Rij(3)
      derij=-3.d0*ts2*(didj*Rij+djr*di+dir*dj) + 15.d0*ts3*dir*djr*Rij 
      derij=derij-3.d0*ts2*qi*djr*Rij + ts1*qi*dj
      derij=derij+3.d0*ts2*qj*dir*Rij - ts1*qj*di
      dRM(:,iat) = dRM(:,iat) + derij 
      dRM(:,jat) = dRM(:,jat) - derij 
      phi(iat) = phi(iat) + ts1*djr
      phi(jat) = phi(jat) - ts1*dir
   enddo
enddo
!Hydrogen-Msite interactions
do iw=1, Nw
   iat = fM + iw -1   ! iat=Msite
   qi = charge(iat)         ! charge-I
   di = dip(3*iat-2:3*iat)
   Ri = RM(1:3, iat)
   do jw=1, Nw
      if (iw/=jw) then
         do jsp=1,2
            jat = fH+2*(jw-1) + jsp-1  !jat = hydrogen-2
            qj = charge(jat)         ! charge-J
            Rij = Ri - RR(1:3, jat)
            dRijsq=Rij(1)*Rij(1) + Rij(2)*Rij(2) + Rij(3)*Rij(3)
            call smear2(dRijsq, polfacH*polfacM, aCCaCD, ts1, ts2)
            dir  = di(1)*Rij(1) + di(2)*Rij(2) + di(3)*Rij(3)
            derij=   3.d0*ts2*qj*dir*Rij - ts1*qj*di
            dRM(:,iat) = dRM(:,iat) + derij
            dRR(:,jat) = dRR(:,jat) - derij
            phi(jat) = phi(jat)-ts1*dir
         enddo
      endif
   enddo
enddo
!----derivatives from the adjustable charges of the NASA PES
do iw=1,Nw
   iO  = fO + iw-1
   iH1 = fH + 2*iw-2
   iH2 = fH + 2*iw-1
   iM  = fM + iw-1
   dRR(:,iH1)=dRR(:,iH1)+(grdq(iw,1,1,:)*phi(iH1)+  &
                          grdq(iw,1,2,:)*phi(iH2)+grdq(iw,1,3,:)*phi(iM))
   dRR(:,iH2)=dRR(:,iH2)+(grdq(iw,2,1,:)*phi(iH1)+  & 
                          grdq(iw,2,2,:)*phi(iH2)+grdq(iw,2,3,:)*phi(iM))
   dRR(:,iO )=dRR(:,iO )+(grdq(iw,3,1,:)*phi(iH1)+  &  
                          grdq(iw,3,2,:)*phi(iH2)+grdq(iw,3,3,:)*phi(iM))
enddo
!-------------------------------------------------------------------------!
!-- Redistribute the ders from the sites (H,H,M) to the atoms (O,H,H)     !
!-------------------------------------------------------------------------!
do iw=1, Nw
   iO  = fO + iw-1
   iH1 = fH + 2*iw-2
   iH2 = fH + 2*iw-1
   iM  = fM + iw-1
   dRR(:,iH1) = dRR(:,iH1) +  0.5d0*gammaM*dRM(:,iM)
   dRR(:,iH2) = dRR(:,iH2) +  0.5d0*gammaM*dRM(:,iM)
   dRR(:, iO) = dRR(:, iO) + (1.d0-gammaM)*dRM(:,iM)
enddo

end subroutine ttm3f
subroutine pot_nasa(r1, dr1, e1)
!****
!**** calculates the energy (e1) and the derivatives (dr1) of a water monomer
!**** (coordinates in the array r1). The potential has been developed by
!**** "H. Partridge and D. W. Schwenke, J. Chem. Phys. 106, 4618 (1997)".
!**** Some extra code for the calculation of the energy derivatives has been
!**** added  by C. J. Burnham.
!****
use mnasa_mod
implicit none
double precision, dimension(3, 3), intent(in) :: r1
double precision, dimension(3, 3), intent(out) :: dr1
double precision, intent(out) :: e1
double precision, dimension(3) :: ROH1, ROH2, RHH
double precision, dimension(0:15,3) :: fmat
double precision :: dROH1, dROH2, dROH1OH2, dRHH
double precision :: Va, Vb, Vc
double precision :: dVa1,dVa2,dVb, dVcdr1, dVcdr2, dVcdcth, sum0,sum1,sum2,sum3
double precision :: x1, x2, x3
double precision :: costhe, costh, sinth
double precision :: exp1, exp2, efac
integer          :: i, j, inI, inJ, inK, ix, iy
double precision :: deoh, phh1
double precision, dimension(245) :: c5z
double precision :: P1, P2, PL1, PL2, PC0

ROH1(:) = r1(1:3, 2) - r1(1:3,1)
ROH2(:) = r1(1:3, 3) - r1(1:3,1)
RHH(:)  = r1(1:3, 2) - r1(1:3,3)
dROH1 = dsqrt(dot_product(ROH1, ROH1))
dROH2 = dsqrt(dot_product(ROH2, ROH2))
dRHH  = dsqrt(dot_product(RHH , RHH ))
costh = (ROH1(1)*ROH2(1) + ROH1(2)*ROH2(2) + ROH1(3)*ROH2(3) ) / (dROH1*dROH2)


c5z = f5z*c5zA + fbasis*cbasis + fcore*ccore + frest*crest
deoh = f5z*deohA
phh1 = f5z*phh1A
phh1 = phh1*dexp(phh2)

costhe = -.24780227221366464506d0

exp1 = dexp(-alphaoh*(dROH1-roh))
exp2 = dexp(-alphaoh*(dROH2-roh))
Va = deoh*(exp1*(exp1-2.d0)+exp2*(exp2-2.d0))
Vb  = phh1*dexp(-phh2*dRHH)
dVa1= 2.d0*alphaoh*deoh*exp1*(1.d0-exp1)/dROH1
dVa2= 2.d0*alphaoh*deoh*exp2*(1.d0-exp2)/dROH2
dVb = -phh2*Vb/dRHH
x1 = (dROH1-reoh)/reoh
x2 = (dROH2-reoh)/reoh
x3 = costh - costhe
fmat(0,1:3) = 0.d0
fmat(1,1:3) = 1.d0
do j=2,15
   fmat(j,1) = fmat(j-1,1)*x1
   fmat(j,2) = fmat(j-1,2)*x2
   fmat(j,3) = fmat(j-1,3)*x3
enddo

efac = dexp(-b1*(  (dROH1-reoh)**2 + (dROH2-reoh)**2))

sum0 = 0.d0; sum1 = 0.d0; sum2 = 0.d0; sum3 = 0.d0
do j=2,245
   inI = idx(j,1)
   inJ = idx(j,2)
   inK = idx(j,3)
   sum0 = sum0 + c5z(j) *  ( fmat(inI,1)*fmat(inJ,2) +   &
        fmat(inJ,1)*fmat(inI,2)) *fmat(inK,3) 
   sum1 = sum1 + c5z(j) *  ( dble(inI-1)*fmat(inI-1,1)*fmat(inJ,2) +   &
        dble(inJ-1)*fmat(inJ-1,1)*fmat(inI,2)  )*fmat(inK,3) 
   sum2 = sum2 + c5z(j) *  ( dble(inJ-1)*fmat(inI,1)*fmat(inJ-1,2) +   &
        dble(inI-1)*fmat(inJ,1)*fmat(inI-1,2)  )*fmat(inK,3) 
   sum3 = sum3 + c5z(j) *  ( fmat(inI,1)*fmat(inJ,2) +   &
        fmat(inJ,1)*fmat(inI,2)) * dble(inK-1)*fmat(inK-1,3) 
enddo     

!.... energy..........
Vc= 2.d0*c5z(1)+efac*sum0
e1 = Va+Vb+Vc
e1 = e1+0.44739574026257d0! correction
e1 = e1*0.00285914375100642899d0 ! cm-1 --> Kcal/mol
!.... derivatives .............
dVcdr1 = (-2.d0*b1*efac*(dROH1-reoh)*sum0 + efac*sum1/reoh)/dROH1
dVcdr2 = (-2.d0*b1*efac*(dROH2-reoh)*sum0 + efac*sum2/reoh)/dROH2
dVcdcth = efac*sum3

dr1(:,2) = dVa1*ROH1 + dVb*RHH + dVcdr1*ROH1 + &
       dVcdcth*(ROH2(:)/(dROH1*dROH2)-costh*ROH1(:)/(dROH1*dROH1))
dr1(:,3) = dVa2*ROH2-dVb*RHH +dVcdr2*ROH2  + &
       dVcdcth*(ROH1(:)/(dROH1*dROH2)-costh*ROH2(:)/(dROH2*dROH2))
dr1(:,1) = -(dr1(:,2)+dr1(:,3))
dr1 = dr1*.00285914375100642899d0

end subroutine pot_nasa
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subroutine dms_nasa(r1, q3, gradq)
!****
!**** calculates the charges (q3) on the Oxygen and the Hydrogen sites that
!**** reproduce the dipole moment surface  of a water monomer
!**** (coordinates in the array r1). The model has been developed by
!**** "H. Partridge and D. W. Schwenke, J. Chem. Phys. 106, 4618 (1997)"
!**** while some extra code for the calculation of the deivatives of the 
!**** charges with respect to the atomic displacemets (gradq) has
!**** added  by C. J. Burnham.
!*** ------------------------------------------------------------------------
!***  In the version 3.0 of the TTM3-F model some additional terms have been
!***  used for the calculation of the charges (See the comments)
!*** ------------------------------------------------------------------------

use mnasa_mod
use ttm3f_mod
implicit none
double precision, dimension(3, 3) :: R1
double precision, dimension(3):: q3
double precision, dimension(3,3,3):: gradq
double precision, dimension(3) :: ROH1, ROH2, RHH, AxB
double precision, dimension(0:15,3) :: fmat
double precision :: dROH1, dROH2, dRHH, dAxB, ang, ath0
double precision :: x1, x2, x3
double precision :: costhe, costh, sinth
double precision :: exp1, exp2, efac
integer          :: i, j, inI, inJ, inK, ix, iy
double precision :: deoh, phh1
double precision :: p1, p2, pl1, pl2, pc0
double precision :: dp1dr1, dp1dr2, dp1dcabc, dp2dr1, dp2dr2, dp2dcabc
double precision :: defacdr1, defacdr2, dpc0dr1, dpc0dr2, dpc0dcabc
double precision :: f1q1r13, f1q1r23, f2q1r23, f2q1r13
double precision :: f1q2r13, f1q2r23, f2q2r23, f2q2r13
double precision :: bfac
integer :: ll1, ll2


deoh = f5z*deohA
phh1 = f5z*phh1A
phh1 = phh1*dexp(phh2)

ath0 = 1.82400520401572996557d0
costhe = -.24780227221366464506d0

ROH1 = R1(:,2) - R1(:,1)
ROH2 = R1(:,3) - R1(:,1)
RHH  = R1(:,2) - R1(:,3)
dROH1 = dsqrt(dot_product(ROH1, ROH1))
dROH2 = dsqrt(dot_product(ROH2, ROH2))
dRHH  = dsqrt(dot_product(RHH, RHH))
costh = dot_product(ROH1, ROH2)/(dROH1*dROH2)
efac = dexp(-b1D*(  (dROH1-reoh)**2 + (dROH2-reoh)**2))
   
x1 = (dROH1-reoh)/reoh
x2 = (dROH2-reoh)/reoh
x3 = costh - costhe
fmat(0,1:3) = 0.d0
fmat(1,1:3) = 1.d0
do j=2,15
   fmat(j,1) = fmat(j-1,1)*x1
   fmat(j,2) = fmat(j-1,2)*x2
   fmat(j,3) = fmat(j-1,3)*x3
enddo
!
!    Calculate dipole moment
!
P1 = 0.d0; 
P2 = 0.d0
PL1 = costh
PL2 = 0.5d0*(3.d0*PL1*PL1-1.d0)
dp1dr1 = 0.d0
dp1dr2 = 0.d0
dp1dcabc = 0.d0
dp2dr1 = 0.d0
dp2dr2 = 0.d0
dp2dcabc = 0.d0
do j=2,84
   inI = idxD(j,1)
   inJ = idxD(j,2)
   inK = idxD(j,3)
   P1 = P1 + coefD(j) * fmat(inI ,1)*fmat(inJ, 2)*fmat(inK, 3)
   P2 = P2 + coefD(j) * fmat(inJ ,1)*fmat(inI, 2)*fmat(inK, 3)
   dp1dr1 =dp1dr1+coefD(j)*(dble(inI-1)*fmat(inI-1,1)*fmat(inJ,2)*fmat(inK,3))
   dp1dr2 =dp1dr2+coefD(j)*(dble(inJ-1)*fmat(inI,1)*fmat(inJ-1,2)*fmat(inK,3))
  dp1dcabc=dp1dcabc+coefD(j)*(dble(inK-1)*fmat(inI,1)*fmat(inJ,2)*fmat(inK-1,3))

   dp2dr1 = dp2dr1+coefD(j)*( dble(inJ-1)*fmat(inJ-1,1)*fmat(inI,2)*fmat(inK,3))
   dp2dr2 = dp2dr2+coefD(j)*( dble(inI-1)*fmat(inJ,1)*fmat(inI-1,2)*fmat(inK,3))
  dp2dcabc=dp2dcabc+coefD(j)*(dble(inK-1)*fmat(inJ,1)*fmat(inI,2)*fmat(inK-1,3))
enddo
dp1dr1=dp1dr1 / reoh*0.529177249d0
dp1dr2=dp1dr2 / reoh*0.529177249d0
dp2dr1=dp2dr1 / reoh*0.529177249d0
dp2dr2=dp2dr2 / reoh*0.529177249d0
PC0 = A*((dROH1**B)+(dROH2**B))*(C0+PL1*C1+PL2*C2)
dpc0dr1=a*(b*dROH1**(b-1))*(c0+pl1*c1+pl2*c2)*0.529177249d0*0.529177249d0
dpc0dr2=a*(b*dROH2**(b-1))*(c0+pl1*c1+pl2*c2)*0.529177249d0*0.529177249d0
dpc0dcabc=a*((dROH1**b)+(dROH2**b))*(c1+0.5d0*(6.d0*pl1)*c2)*0.529177249d0
defacdr1 =-2.d0*b1D*(dROH1-reoh)*efac*0.529177249d0
defacdr2 =-2.d0*b1D*(dROH2-reoh)*efac*0.529177249d0
dp1dr1=dp1dr1*efac+p1*defacdr1+dpc0dr1
dp1dr2=dp1dr2*efac+p1*defacdr2+dpc0dr2
dp1dcabc=dp1dcabc*efac+dpc0dcabc
dp2dr1=dp2dr1*efac+p2*defacdr1+dpc0dr1
dp2dr2=dp2dr2*efac+p2*defacdr2+dpc0dr2
dp2dcabc=dp2dcabc*efac+dpc0dcabc
P1 = coefD(1)+P1*efac+PC0*0.529177249d0
P2 = coefD(1)+P2*efac+PC0*0.529177249d0
bfac=1.d0/0.529177249
q3(1) = -(P1+P2)   ! Oxygen
q3(2) = P1   ! Hydrogen-1
q3(3) = P2   !  Hydrogen-2
dp1dr1=dp1dr1*bfac
dp1dr2=dp1dr2*bfac
dp2dr1=dp2dr1*bfac
dp2dr2=dp2dr2*bfac
!--------------------------------------------------------------------------------
!............. Modification of the gas-phase dipole moment surface...........
!--------------------------------------------------------------------------------
   AxB(1) = ROH1(2)*ROH2(3) - ROH1(3)*ROH2(2)
   AxB(2) =-ROH1(1)*ROH2(3) + ROH1(3)*ROH2(1)
   AxB(3) = ROH1(1)*ROH2(2) - ROH1(2)*ROH2(1)
   dAxB = dsqrt(dot_product(AxB, AxB) )
   sinth = dAxB / (dROH1*dROH2)
   ang = atan2(sinth, costh)
   P1 = dms_param1*(dROH1 -dms_param2) + dms_param3*(ang-ath0)
   P2 = dms_param1*(dROH2 -dms_param2) + dms_param3*(ang-ath0)
   q3(1) = q3(1) - (P1+P2)
   q3(2) = q3(2) + P1
   q3(3) = q3(3) + P2
   dp1dr1 = dp1dr1 + dms_param1
   dp2dr2 = dp2dr2 + dms_param1
   dp1dcabc = dp1dcabc   - dms_param3/sinth
   dp2dcabc = dp2dcabc   - dms_param3/sinth
!--------------------------------------------------------------------------------

f1q1r13=(dp1dr1-(dp1dcabc*costh/dROH1))/dROH1
f1q1r23=dp1dcabc/(dROH1*dROH2)
f2q1r23=(dp1dr2-(dp1dcabc*costh/dROH2))/dROH2
f2q1r13=dp1dcabc/(dROH2*dROH1)
f1q2r13=(dp2dr1-(dp2dcabc*costh/dROH1))/dROH1
f1q2r23=dp2dcabc/(dROH1*dROH2)
f2q2r23=(dp2dr2-(dp2dcabc*costh/dROH2))/dROH2
f2q2r13=dp2dcabc/(dROH2*dROH1)


!gradient of charge h1 wrt displacement of h1
gradq(1,1,1)=f1q1r13*ROH1(1)+f1q1r23*ROH2(1)
gradq(1,1,2)=f1q1r13*ROH1(2)+f1q1r23*ROH2(2)
gradq(1,1,3)=f1q1r13*ROH1(3)+f1q1r23*ROH2(3)
!gradient of charge h1 wrt displacement of h2
gradq(2,1,1)=f2q1r13*ROH1(1)+f2q1r23*ROH2(1)
gradq(2,1,2)=f2q1r13*ROH1(2)+f2q1r23*ROH2(2)
gradq(2,1,3)=f2q1r13*ROH1(3)+f2q1r23*ROH2(3)
!gradient of charge h1 wrt displacement of O
gradq(3,1,1)=-(gradq(1,1,1)+gradq(2,1,1))
gradq(3,1,2)=-(gradq(1,1,2)+gradq(2,1,2))
gradq(3,1,3)=-(gradq(1,1,3)+gradq(2,1,3))
!gradient of charge h2 wrt displacement of h1
gradq(1,2,1)=f1q2r13*ROH1(1)+f1q2r23*ROH2(1)
gradq(1,2,2)=f1q2r13*ROH1(2)+f1q2r23*ROH2(2)
gradq(1,2,3)=f1q2r13*ROH1(3)+f1q2r23*ROH2(3)
!gradient of charge h2 wrt displacement of h2
gradq(2,2,1)=f2q2r13*ROH1(1)+f2q2r23*ROH2(1)
gradq(2,2,2)=f2q2r13*ROH1(2)+f2q2r23*ROH2(2)
gradq(2,2,3)=f2q2r13*ROH1(3)+f2q2r23*ROH2(3)
!gradient of charge h2 wrt displacement of O
gradq(3,2,1)=-(gradq(1,2,1)+gradq(2,2,1))
gradq(3,2,2)=-(gradq(1,2,2)+gradq(2,2,2))
gradq(3,2,3)=-(gradq(1,2,3)+gradq(2,2,3))
!gradient of charge O wrt displacement of h1
gradq(1,3,1)=-(gradq(1,1,1)+gradq(1,2,1))
gradq(1,3,2)=-(gradq(1,1,2)+gradq(1,2,2))
gradq(1,3,3)=-(gradq(1,1,3)+gradq(1,2,3))
!gradient of charge O wrt displacement of h2
gradq(2,3,1)=-(gradq(2,1,1)+gradq(2,2,1))
gradq(2,3,2)=-(gradq(2,1,2)+gradq(2,2,2))
gradq(2,3,3)=-(gradq(2,1,3)+gradq(2,2,3))
!gradient of charge O wrt displacement of O
gradq(3,3,1)=-(gradq(3,1,1)+gradq(3,2,1))
gradq(3,3,2)=-(gradq(3,1,2)+gradq(3,2,2))
gradq(3,3,3)=-(gradq(3,1,3)+gradq(3,2,3))
    
end subroutine dms_nasa

subroutine ttm3fcall(Nw, coords, energy, vnew) !adds energy and gradient
implicit none
integer :: Nw
double precision, intent(in) :: coords(9*Nw)
double precision, intent(inout) :: energy, vnew(9*Nw)
double precision :: En, dRR(3,size(vnew)/3)
call ttm3f(Nw, reshape(coords,(/3,3*Nw/)), dRR, En)
vnew = vnew + reshape(dRR, (/9*Nw/))
energy = energy + En
end subroutine ttm3fcall
