SUBROUTINE OPTIM_QUIP_WRAPPER(NAT,CRDS,GRAD,ENRG,BOXX,BOXY,BOXZ,QARGSTRING,QATOMTYPE)

USE COMMONS, ONLY : NATOMS

IMPLICIT NONE

INTEGER, INTENT(IN) :: NAT
DOUBLE PRECISION, DIMENSION(3*NAT), INTENT(IN) :: CRDS
DOUBLE PRECISION, DIMENSION(3*NAT), INTENT(OUT) :: GRAD
DOUBLE PRECISION, INTENT(OUT) :: ENRG
DOUBLE PRECISION, INTENT(IN) :: BOXX, BOXY, BOXZ
CHARACTER(LEN=10240), INTENT(IN) :: QARGSTRING
CHARACTER(LEN=3), INTENT(IN) :: QATOMTYPE 

INTEGER :: I
DOUBLE PRECISION, DIMENSION(3,3) :: LATT, VIR
DOUBLE PRECISION, DIMENSION(3,NATOMS) :: NEW_COORDS, FORCES
CHARACTER(LEN=3), DIMENSION(NATOMS) :: SYMB

LATT = RESHAPE((/ BOXX, 0.0D0, 0.0D0, 0.0D0, BOXY, 0.0D0, 0.0D0, 0.0D0, BOXZ /), SHAPE(LATT))

SYMB = QATOMTYPE 

NEW_COORDS = RESHAPE(CRDS, (/ 3, NAT /))

!CALL QUIP_WRAPPER(NAT,LATT,SYMB,NEW_COORDS,QARGSTRING,ENRG,FORCES,VIR)

!Virial is not passed back to OPTIM

GRAD = RESHAPE(FORCES, SHAPE(GRAD))
DO I = 1, 3*NAT
   GRAD(I) = -1.0D0*GRAD(I)
END DO

END SUBROUTINE OPTIM_QUIP_WRAPPER
