!   Copyright (C) 2010- David J. Wales
!
!   OPTIM is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   OPTIM is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
SUBROUTINE MAKE_CONPOT(NCPFIT,MINCOORDS)
USE KEY, ONLY : INTCONSEP, NREPMAX, NREPULSIVE, CONDISTREF, REPCON, INTCONSTRAINTREP, &
  & REPCUT, NCONSTRAINT, CONI, CONJ, CONDISTREFLOCAL, INTCONMAX, CONACTIVE, &
  & INTCONSTRAINREPCUT, INTREPSEP, REPI, REPJ, INTCONSTRAINTTOL, REPCUT, NREPI, NREPJ, NREPCUT, &
  & NCONGEOM, CONGEOM, NNREPULSIVE, BULKT, RIGIDBODY, TWOD, &
  & INTFROZEN, FREEZE, INTFREEZET, INTFREEZETOL, INTFREEZEMIN, CONIFIX, CONJFIX, CONDISTREFFIX, REPIFIX, REPJFIX, &
  & REPCUTFIX, NCONGEOM, NREPULSIVEFIX, CONDATT, NCONSTRAINTFIX, CONCUTLOCAL, CONCUTFIX, CONCUT, &
  & CONCUTABST, CONCUTFRACT, CONCUTABS, CONCUTFRAC
USE COMMONS, ONLY : NATOMS,DEBUG,PARAM1,PARAM2,PARAM3

IMPLICIT NONE 
DOUBLE PRECISION DS, DF, DSHORT, D, DIST2, RMAT(3,3), DISTANCE
INTEGER :: J2,ISTAT,J1,J3,J4,NCPFIT,J5,NQCIFREEZE,NDUMMY,LUNIT,GETUNIT
INTEGER NCONFORNEWATOM, CONLIST(NATOMS)
DOUBLE PRECISION :: DUMMY, NDIST, CONDIST(NATOMS), MINCOORDS(NCPFIT,3*NATOMS), DMIN, LINTCONSTRAINTTOL, &
  &                 LXYZ(6*NATOMS), CCLOCAL
DOUBLE PRECISION :: DMOVED(NATOMS)
LOGICAL CHANGED, ADDREP(NATOMS)
INTEGER NDIST1(NATOMS), NCYCLE, DMIN1, DMAX1, NUNCON1, DLIST(NATOMS)
LOGICAL :: YESNO, CALLED=.FALSE.
SAVE CALLED

IF (NCONGEOM.GE.2) THEN
!
! If this is not the first call, and we are being passed two minima,
! then we are doing an interpolation metric for a new pair of minima.
! We should optimise the permutational isomers on reference minimum 1
! and then do the overall alignment with newmindist, fixing the
! permutational isomers. This should put the permutational isomers
! in register with the constraints, which were calculated for all
! the reference minima after aligning with the first.
!
   IF ((CALLED.OR.CONDATT).AND.(NCPFIT.EQ.2)) THEN
      CALL MINPERMDIST(CONGEOM(1,1:3*NATOMS),MINCOORDS(1,1:3*NATOMS),NATOMS,DEBUG, &
  &                       PARAM1,PARAM2,PARAM3,BULKT,TWOD,D,DIST2,RIGIDBODY,RMAT)
      CALL MINPERMDIST(CONGEOM(1,1:3*NATOMS),MINCOORDS(2,1:3*NATOMS),NATOMS,DEBUG, &
  &                       PARAM1,PARAM2,PARAM3,BULKT,TWOD,D,DIST2,RIGIDBODY,RMAT)
      CALL NEWMINDIST(MINCOORDS(1,1:3*NATOMS),MINCOORDS(2,1:3*NATOMS),NATOMS,DISTANCE, &
  &                   BULKT,TWOD,'AX   ',.FALSE.,RIGIDBODY,DEBUG,RMAT)
   ENDIF
ENDIF

NQCIFREEZE=0
IF (FREEZE) THEN
   PRINT '(A)',' make_conpot> ERROR *** QCI has not been coded for frozen atoms yet'
   STOP
ENDIF
IF (ALLOCATED(INTFROZEN)) DEALLOCATE(INTFROZEN)
ALLOCATE(INTFROZEN(NATOMS))
INTFROZEN(1:NATOMS)=.FALSE.
DLIST(1:NATOMS)=-1
DMOVED(1:NATOMS)=1.0D100
IF (INTFREEZET) THEN
   IF (NCPFIT.GT.1) THEN
      DO J1=1,NATOMS
         DF=SQRT((MINCOORDS(1,3*(J1-1)+1)-MINCOORDS(2,3*(J1-1)+1))**2 &
  &             +(MINCOORDS(1,3*(J1-1)+2)-MINCOORDS(2,3*(J1-1)+2))**2 &
  &             +(MINCOORDS(1,3*(J1-1)+3)-MINCOORDS(2,3*(J1-1)+3))**2)
         IF (DF.LT.INTFREEZETOL) THEN
            NQCIFREEZE=NQCIFREEZE+1
            INTFROZEN(J1)=.TRUE.
!           IF (DEBUG) PRINT '(A,I6,A,F12.6,A,I6)',' make_conpot> atom ',J1, &
! &                          ' moves less than threshold: distance=',DF,' total=',NQCIFREEZE
         ENDIF
         sortd: DO J2=1,J1
            IF (DF.LT.DMOVED(J2)) THEN
               DO J3=J1,J2+1,-1
                  DMOVED(J3)=DMOVED(J3-1)
                  DLIST(J3)=DLIST(J3-1)
               ENDDO
               DMOVED(J2)=DF
               DLIST(J2)=J1
               EXIT sortd
            ENDIF
         ENDDO sortd
      ENDDO
   ENDIF
   IF (DEBUG) PRINT '(A,I6,A,F12.6,A,I6)',' make_conpot> Total number of atoms moving less than threshold=',NQCIFREEZE
ENDIF

IF (NATOMS-NQCIFREEZE.LT.INTFREEZEMIN) THEN
   DO J1=NATOMS,NATOMS-INTFREEZEMIN+1,-1
      INTFROZEN(DLIST(J1))=.FALSE.
   ENDDO
   NQCIFREEZE=NATOMS-INTFREEZEMIN
   IF (DEBUG) PRINT '(A,I6,A)',' make_conpot> Freezing ',NQCIFREEZE,' atoms'
ENDIF

IF (.NOT.ALLOCATED(CONI)) THEN 
   ALLOCATE(CONI(INTCONMAX),CONJ(INTCONMAX),CONDISTREF(INTCONMAX),CONCUT(INTCONMAX))
   ALLOCATE(REPI(NREPMAX),REPJ(NREPMAX),NREPI(NREPMAX),NREPJ(NREPMAX),REPCUT(NREPMAX),NREPCUT(NREPMAX))
ENDIF

IF (NQCIFREEZE.EQ.NATOMS) THEN
   NREPULSIVE=0
   NNREPULSIVE=0
   NCONSTRAINT=0
   IF (DEBUG) PRINT '(A,2I10,A,G20.10)',' make_conpot> Total number of constraints and repulsions=', &
  &   NCONSTRAINT,NREPULSIVE
   
   IF (ALLOCATED(CONACTIVE)) DEALLOCATE(CONACTIVE)
   ALLOCATE(CONACTIVE(NCONSTRAINT))
   CONACTIVE(1:NCONSTRAINT)=.TRUE. 
   IF (ALLOCATED(CONDISTREFLOCAL)) DEALLOCATE(CONDISTREFLOCAL)
   ALLOCATE(CONDISTREFLOCAL(NCONSTRAINT))
   IF (ALLOCATED(CONCUTLOCAL)) DEALLOCATE(CONCUTLOCAL)
   ALLOCATE(CONCUTLOCAL(NCONSTRAINT))
   RETURN
ENDIF

LXYZ(1:3*NATOMS)=MINCOORDS(1,1:3*NATOMS)
IF (NCPFIT.GT.1) LXYZ(3*NATOMS+1:6*NATOMS)=MINCOORDS(2,1:3*NATOMS)
CALL CHECKPERC(LXYZ,LINTCONSTRAINTTOL,NQCIFREEZE,NCPFIT)

! PRINT '(A,I6,2(A,F15.5))',' make_conpot> total distance constraints=',NCONSTRAINT
! REPCON=-INTCONSTRAINTREP/INTCONSTRAINREPCUT**6

!
! Fixed repulsions based on congeom file entries
! Just need to adjust the list based on any frozen atoms and check
! to make sure a new pair of minima don't have repulsive atoms within
! the current cutoff.
! 
IF (NCONGEOM.GE.2) THEN
   IF (CALLED.OR.CONDATT) THEN
      J2=0
      DO J1=1,NREPULSIVEFIX
!
! If called with two minima check that REPCUTFIX doesn't exceed the separation in 
! either minimum.
!
         IF (NCPFIT.EQ.2) THEN
            DF=MIN(SQRT((MINCOORDS(1,3*(REPIFIX(J1)-1)+1)-MINCOORDS(1,3*(REPJFIX(J1)-1)+1))**2+ &
  &                     (MINCOORDS(1,3*(REPIFIX(J1)-1)+2)-MINCOORDS(1,3*(REPJFIX(J1)-1)+2))**2+ &
  &                     (MINCOORDS(1,3*(REPIFIX(J1)-1)+3)-MINCOORDS(1,3*(REPJFIX(J1)-1)+3))**2),&
                   SQRT((MINCOORDS(2,3*(REPIFIX(J1)-1)+1)-MINCOORDS(2,3*(REPJFIX(J1)-1)+1))**2+ &
  &                     (MINCOORDS(2,3*(REPIFIX(J1)-1)+2)-MINCOORDS(2,3*(REPJFIX(J1)-1)+2))**2+ &
  &                     (MINCOORDS(2,3*(REPIFIX(J1)-1)+3)-MINCOORDS(2,3*(REPJFIX(J1)-1)+3))**2))
            IF (DF.LT.REPCUTFIX(J1)) THEN
               PRINT '(A,2I6,2(A,G15.5))',' make_conpot> Reducing repulsive cutoff for atoms ', &
  &                       REPIFIX(J1),REPJFIX(J1),' from ',REPCUTFIX(J1),' to ',DF-1.0D-3
               REPCUTFIX(J1)=DF-1.0D-3
            ENDIF
         ENDIF
         IF (INTFROZEN(REPIFIX(J1)).AND.INTFROZEN(REPJFIX(J1))) CYCLE
         J2=J2+1
         REPI(J2)=REPIFIX(J1)
         REPJ(J2)=REPJFIX(J1)
         REPCUT(J2)=REPCUTFIX(J1)
      ENDDO
      NREPULSIVE=J2
!     PRINT '(A,I6,A)',' make_conpot> After allowing for frozen atoms there are ',NREPULSIVE,' possible repulsions'
      NREPI(1:NREPULSIVE)=REPI(1:NREPULSIVE)
      NREPJ(1:NREPULSIVE)=REPJ(1:NREPULSIVE)
      NNREPULSIVE=NREPULSIVE
      NREPCUT(1:NREPULSIVE)=REPCUT(1:NREPULSIVE)
      IF (ALLOCATED(CONACTIVE)) DEALLOCATE(CONACTIVE)
      ALLOCATE(CONACTIVE(NCONSTRAINT))
      CONACTIVE(1:NCONSTRAINT)=.TRUE. 
      IF (ALLOCATED(CONDISTREFLOCAL)) DEALLOCATE(CONDISTREFLOCAL)
      ALLOCATE(CONDISTREFLOCAL(NCONSTRAINT))
      CONDISTREFLOCAL(1:NCONSTRAINT)=CONDISTREF(1:NCONSTRAINT)
      IF (ALLOCATED(CONCUTLOCAL)) DEALLOCATE(CONCUTLOCAL)
      ALLOCATE(CONCUTLOCAL(NCONSTRAINT))
      CONCUTLOCAL(1:NCONSTRAINT)=CONCUT(1:NCONSTRAINT)
      RETURN 
   ELSE
      ALLOCATE(REPIFIX(NREPMAX),REPJFIX(NREPMAX),REPCUTFIX(NREPMAX))
   ENDIF
ENDIF
!
! The rest of this code is for initial setup. It isn't needed if CONDATT is true.
!
REPCON=-INTCONSTRAINTREP/INTCONSTRAINREPCUT
IF (ALLOCATED(CONDISTREFLOCAL)) DEALLOCATE(CONDISTREFLOCAL)
ALLOCATE(CONDISTREFLOCAL(NCONSTRAINT))
CONDISTREFLOCAL(1:NCONSTRAINT)=CONDISTREF(1:NCONSTRAINT)
IF (ALLOCATED(CONCUTLOCAL)) DEALLOCATE(CONCUTLOCAL)
ALLOCATE(CONCUTLOCAL(NCONSTRAINT))
CONCUTLOCAL(1:NCONSTRAINT)=CONCUT(1:NCONSTRAINT)
DUMMY=1.0D100
NREPULSIVEFIX=0
!
! Add repulsions to non-constrained atoms.
! Note that we do not limit the number of constraints per site in this
! routine, unlike NEB/lbfgs.f90, where the result will depend on the
! order in which the constraints are turned on. 
!
NDUMMY=1
DO J1=1,NATOMS
!
! Make a list of repelling atoms here and then use it
! CONI(j2) is always less than CONJ(j2) so we only need to
! cycle over a given range of constraints and continue from
! where we left off for the next atom j1
!
   ADDREP(1:MIN(J1+INTREPSEP,NATOMS))=.FALSE.
   IF (J1+INTREPSEP+1.LT.NATOMS) THEN
      ADDREP(J1+INTREPSEP+1:NATOMS)=.TRUE. ! no repulsion for atoms too close in sequence
   ENDIF
   IF (INTFROZEN(J1)) THEN
      DO J2=J1+INTREPSEP+1,NATOMS
         IF (INTFROZEN(J2)) ADDREP(J2)=.FALSE.
      ENDDO
   ENDIF
   addloop: DO J2=NDUMMY,NCONSTRAINT
      IF (CONI(J2).EQ.J1) THEN
         ADDREP(CONJ(J2))=.FALSE.
      ELSE
         NDUMMY=J2 ! for next atom
         EXIT addloop
      ENDIF
   ENDDO addloop
   rep2: DO J2=J1+INTREPSEP+1,NATOMS

      IF (.NOT.ADDREP(J2)) CYCLE

      DMIN=1.0D100
      DO J3=1,NCPFIT
         DF=SQRT((MINCOORDS(J3,3*(J1-1)+1)-MINCOORDS(J3,3*(J2-1)+1))**2+ &
  &              (MINCOORDS(J3,3*(J1-1)+2)-MINCOORDS(J3,3*(J2-1)+2))**2+ &
  &              (MINCOORDS(J3,3*(J1-1)+3)-MINCOORDS(J3,3*(J2-1)+3))**2)
         IF (DF.LT.DMIN) DMIN=DF
      ENDDO
      
      NREPULSIVEFIX=NREPULSIVEFIX+1
      IF (NREPULSIVEFIX.GT.NREPMAX) CALL REPDOUBLE
      IF (NCONGEOM.GE.2) THEN
         REPIFIX(NREPULSIVEFIX)=J1
         REPJFIX(NREPULSIVEFIX)=J2
         REPCUTFIX(NREPULSIVEFIX)=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
      ENDIF
      REPI(NREPULSIVEFIX)=J1
      REPJ(NREPULSIVEFIX)=J2
!
! Use the minimum of the end point distances and INTCONSTRAINREPCUT for each contact.
!
      REPCUT(NREPULSIVEFIX)=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
!     IF (DEBUG) PRINT '(A,I6,A,I6,A,F15.5,A,I10)',' make_conpot> Adding repulsion for atom ',J1, &
! &              ' with atom ',J2,' cutoff=',DMIN,' # repulsions ',NREPULSIVEFIX
   ENDDO rep2
ENDDO
NREPULSIVE=NREPULSIVEFIX

IF (DEBUG) PRINT '(A,2I10,A,G20.10)',' make_conpot> Total number of constraints and repulsions=', &
  &   NCONSTRAINT,NREPULSIVE,' for tolerance parameter ',LINTCONSTRAINTTOL

IF (ALLOCATED(CONACTIVE)) DEALLOCATE(CONACTIVE)
ALLOCATE(CONACTIVE(NCONSTRAINT))
CONACTIVE(1:NCONSTRAINT)=.TRUE. 
!
! congrad routines actually use NREPI, NREPJ, etc., so we must assign these.
!
NREPI(1:NREPULSIVE)=REPI(1:NREPULSIVE)
NREPJ(1:NREPULSIVE)=REPJ(1:NREPULSIVE)
NNREPULSIVE=NREPULSIVE
NREPCUT(1:NREPULSIVE)=REPCUT(1:NREPULSIVE)

IF (NCONGEOM.GE.1) THEN
   LUNIT=GETUNIT()
   OPEN(LUNIT,FILE='congeom.dat',STATUS='UNKNOWN')
   WRITE(LUNIT,'(I8)') NCONGEOM
   WRITE(LUNIT,'(3G20.10)') CONGEOM(1,1:3*NATOMS)
   WRITE(LUNIT,'(I8)') NCONSTRAINTFIX
   WRITE(LUNIT,'(10I8)') CONIFIX(1:NCONSTRAINTFIX)
   WRITE(LUNIT,'(10I8)') CONJFIX(1:NCONSTRAINTFIX)
   WRITE(LUNIT,'(6G20.10)') CONDISTREFFIX(1:NCONSTRAINTFIX)
   WRITE(LUNIT,'(6G20.10)') CONCUTFIX(1:NCONSTRAINTFIX)
   WRITE(LUNIT,'(I8)') NREPULSIVEFIX
   WRITE(LUNIT,'(10I8)') REPIFIX(1:NREPULSIVEFIX)
   WRITE(LUNIT,'(10I8)') REPJFIX(1:NREPULSIVEFIX)
   WRITE(LUNIT,'(6G20.10)') REPCUTFIX(1:NREPULSIVEFIX)
   CLOSE(LUNIT)
   STOP
ENDIF

CALLED=.TRUE.

RETURN
END SUBROUTINE MAKE_CONPOT

SUBROUTINE CONPOT(COORDS1,COORDS2,ETOTAL)
USE KEY, ONLY : NREPMAX, NREPULSIVE, CONDISTREF, INTCONSTRAINTDEL, CONCUT, CONCUTLOCAL, &
  & REPCUT, NCONSTRAINT, CONI, CONJ, INTCONMAX, INTCONSTRAINTREP, &
  & INTCONSTRAINREPCUT, REPI, REPJ, REPCUT, CONDISTREFLOCAL, NNREPULSIVE, NREPCUT, NREPI, NREPJ, &
  & CONCUTABST, CONCUTABS, CONCUTFRAC, CONCUTFRACT
USE COMMONS, ONLY : NATOMS, DEBUG
IMPLICIT NONE
           
INTEGER :: J1,J2,NI,NJ
DOUBLE PRECISION :: ECON, EREP, ETOTAL
DOUBLE PRECISION R1AX,R1AY,R1AZ,R2AX,R2AY,R2AZ,R1BX,R1BY,R1BZ,R2BX,R2BY,R2BZ,DMIN,DMAX
DOUBLE PRECISION G1MAX(3),G2MIN(3),DINT,G1INT(3),G2INT(3),CCLOCAL
DOUBLE PRECISION DUMMY, REPGRAD(3), INtCONST, D12, DSQ0, DSQP, DSQI, COORDS1(3*NATOMS), COORDS2(3*NATOMS)
DOUBLE PRECISION, PARAMETER :: MINCONPOT=1.0D-2
LOGICAL NOINT

ECON=0.0D0; EREP=0.0D0
!
!  Constraint potential energy and (optionally) forces.
!
DO J2=1,NCONSTRAINT
   CCLOCAL=CONCUTLOCAL(J2)
   IF (CONCUTABST) CCLOCAL=CCLOCAL+CONCUTABS
   IF (CONCUTFRACT) CCLOCAL=CCLOCAL+CONCUTFRAC*CONDISTREFLOCAL(J2)
!
! We consider the line segment between COORDS1 and COORDS2
! A and B refer to atoms, 1 and 2 to COORDS1 and COORDS2
!
   NI=3*(CONI(J2)-1)
   NJ=3*(CONJ(J2)-1)
   R1AX=COORDS1(NI+1); R1AY=COORDS1(NI+2); R1AZ=COORDS1(NI+3)
   R1BX=COORDS1(NJ+1); R1BY=COORDS1(NJ+2); R1BZ=COORDS1(NJ+3)
   R2AX=COORDS2(NI+1); R2AY=COORDS2(NI+2); R2AZ=COORDS2(NI+3)
   R2BX=COORDS2(NJ+1); R2BY=COORDS2(NJ+2); R2BZ=COORDS2(NJ+3)
   CALL MINMAXD2(R1AX,R1AY,R1AZ,R2AX,R2AY,R2AZ,R1BX,R1BY,R1BZ,R2BX,R2BY,R2BZ, &
  &              DMIN,DMAX,DINT,G1MAX,G2MIN,G1INT,G2INT,NOINT,.FALSE.)
!
! Need to include both DMIN and DMAX contributions if they are both outside tolerance.
! Otherwise we get discontinuities if they are very close and swap over.
!
! terms for image J1 - non-zero derivatives only for J1
!
   IF (ABS(DMIN-CONDISTREFLOCAL(J2)).GT.CCLOCAL) THEN 
      DUMMY=DMIN-CONDISTREFLOCAL(J2)  
      ECON=ECON+INTCONSTRAINTDEL*(DUMMY**2-CCLOCAL**2)**2/(2.0D0*CCLOCAL**2)
   ENDIF
!
! terms for image J1-1 - non-zero derivatives only for J1-1
!
   IF (ABS(DMAX-CONDISTREFLOCAL(J2)).GT.CCLOCAL) THEN  
      DUMMY=DMAX-CONDISTREFLOCAL(J2)  
      ECON=ECON+INTCONSTRAINTDEL*(DUMMY**2-CCLOCAL**2)**2/(2.0D0*CCLOCAL**2)
   ENDIF
   IF ((.NOT.NOINT).AND.(ABS(DINT-CONDISTREFLOCAL(J2)).GT.CCLOCAL)) THEN
      DUMMY=DINT-CONDISTREFLOCAL(J2)  
      ECON=ECON+INTCONSTRAINTDEL*(DUMMY**2-CCLOCAL**2)**2/(2.0D0*CCLOCAL**2)
   ENDIF
ENDDO

DO J2=1,NNREPULSIVE
!  INTCONST=NREPCUT(J2)**13
   INTCONST=NREPCUT(J2)**3
   NI=3*(NREPI(J2)-1)
   NJ=3*(NREPJ(J2)-1)
   R1AX=COORDS1(NI+1); R1AY=COORDS1(NI+2); R1AZ=COORDS1(NI+3)
   R1BX=COORDS1(NJ+1); R1BY=COORDS1(NJ+2); R1BZ=COORDS1(NJ+3)
   R2AX=COORDS2(NI+1); R2AY=COORDS2(NI+2); R2AZ=COORDS2(NI+3)
   R2BX=COORDS2(NJ+1); R2BY=COORDS2(NJ+2); R2BZ=COORDS2(NJ+3)
   CALL MINMAXD2R(R1AX,R1AY,R1AZ,R2AX,R2AY,R2AZ,R1BX,R1BY,R1BZ,R2BX,R2BY,R2BZ, &
  &                 DMIN,DMAX,DINT,DSQ0,DSQP,DSQI,G1MAX,G2MIN,G1INT,G2INT,NOINT,.FALSE.,NREPCUT(J2))
   DUMMY=0.0D0 
   IF (DMIN.LT.NREPCUT(J2)) THEN ! terms for image J1 - non-zero derivatives only for J1
!     D12=DSQ0**6
      D12=DSQ0 ! this is a squared distance
!     DUMMY=INTCONSTRAINTREP*(1.0D0/D12+(12.0D0*DMIN-13.0D0*NREPCUT(J2))/INTCONST)
      DUMMY=INTCONSTRAINTREP*(1.0D0/D12+(2.0D0*DMIN-3.0D0*NREPCUT(J2))/INTCONST)
      EREP=EREP+DUMMY
   ENDIF
   DUMMY=0.0D0
   IF (DMAX.LT.NREPCUT(J2)) THEN ! terms for image J1-1 - non-zero derivatives only for J1-1
!     D12=DSQP**6
      D12=DSQP
!     DUMMY=INTCONSTRAINTREP*(1.0D0/D12+(12.0D0*DMAX-13.0D0*NREPCUT(J2))/INTCONST)
      DUMMY=INTCONSTRAINTREP*(1.0D0/D12+(2.0D0*DMAX-3.0D0*NREPCUT(J2))/INTCONST)
      EREP=EREP+DUMMY
   ENDIF
   DUMMY=0.0D0
   IF ((.NOT.NOINT).AND.(DINT.LT.NREPCUT(J2))) THEN
!     D12=DSQI**6
      D12=DSQI
!     DUMMY=INTCONSTRAINTREP*(1.0D0/D12+(12.0D0*DINT-13.0D0*NREPCUT(J2))/INTCONST)
      DUMMY=INTCONSTRAINTREP*(1.0D0/D12+(2.0D0*DINT-3.0D0*NREPCUT(J2))/INTCONST)
      EREP=EREP+DUMMY
   ENDIF
ENDDO

ETOTAL=MAX(EREP+ECON,MINCONPOT)

END SUBROUTINE CONPOT


SUBROUTINE REPDOUBLE
USE KEY, ONLY : NREPMAX, REPI, REPJ, REPCUT, NREPI, NREPJ, NREPCUT, NCONGEOM, REPIFIX, REPJFIX, REPCUTFIX
IMPLICIT NONE
INTEGER, ALLOCATABLE :: IREPTEMP(:)
DOUBLE PRECISION, ALLOCATABLE :: REPTEMP(:)

ALLOCATE(IREPTEMP(NREPMAX),REPTEMP(NREPMAX))

IF (NCONGEOM.GE.2) THEN
   IREPTEMP(1:NREPMAX)=REPIFIX(1:NREPMAX)
   DEALLOCATE(REPIFIX)
   ALLOCATE(REPIFIX(2*NREPMAX))
   REPIFIX(1:NREPMAX)=IREPTEMP(1:NREPMAX)
   IREPTEMP(1:NREPMAX)=REPJFIX(1:NREPMAX)
   DEALLOCATE(REPJFIX)
   ALLOCATE(REPJFIX(2*NREPMAX))
   REPJFIX(1:NREPMAX)=IREPTEMP(1:NREPMAX)
   REPTEMP(1:NREPMAX)=REPCUTFIX(1:NREPMAX)
   DEALLOCATE(REPCUTFIX)
   ALLOCATE(REPCUTFIX(2*NREPMAX))
   REPCUTFIX(1:NREPMAX)=REPTEMP(1:NREPMAX)
ENDIF

IREPTEMP(1:NREPMAX)=REPI(1:NREPMAX)
DEALLOCATE(REPI)
ALLOCATE(REPI(2*NREPMAX))
REPI(1:NREPMAX)=IREPTEMP(1:NREPMAX)
IREPTEMP(1:NREPMAX)=REPJ(1:NREPMAX)
DEALLOCATE(REPJ)
ALLOCATE(REPJ(2*NREPMAX))
REPJ(1:NREPMAX)=IREPTEMP(1:NREPMAX)
REPTEMP(1:NREPMAX)=REPCUT(1:NREPMAX)
DEALLOCATE(REPCUT)
ALLOCATE(REPCUT(2*NREPMAX))
REPCUT(1:NREPMAX)=REPTEMP(1:NREPMAX)

IREPTEMP(1:NREPMAX)=NREPI(1:NREPMAX)
DEALLOCATE(NREPI)
ALLOCATE(NREPI(2*NREPMAX))
NREPI(1:NREPMAX)=IREPTEMP(1:NREPMAX)
IREPTEMP(1:NREPMAX)=NREPJ(1:NREPMAX)
DEALLOCATE(NREPJ)
ALLOCATE(NREPJ(2*NREPMAX))
NREPJ(1:NREPMAX)=IREPTEMP(1:NREPMAX)
REPTEMP(1:NREPMAX)=NREPCUT(1:NREPMAX)
DEALLOCATE(NREPCUT)
ALLOCATE(NREPCUT(2*NREPMAX))
NREPCUT(1:NREPMAX)=REPTEMP(1:NREPMAX)

DEALLOCATE(IREPTEMP,REPTEMP)
NREPMAX=2*NREPMAX

END SUBROUTINE REPDOUBLE


SUBROUTINE CONDOUBLE
USE KEY, ONLY : CONI, CONJ, CONDISTREF, INTCONMAX, CONIFIX, CONJFIX, CONDISTREFFIX, NCONGEOM, &
  &             CONCUT, CONCUTFIX
IMPLICIT NONE
DOUBLE PRECISION, ALLOCATABLE :: CPTEMP(:)
INTEGER, ALLOCATABLE :: ICPTEMP(:)

ALLOCATE(ICPTEMP(INTCONMAX))
ALLOCATE(CPTEMP(1:INTCONMAX))
                
ICPTEMP(1:INTCONMAX)=CONI(1:INTCONMAX)
DEALLOCATE(CONI)
ALLOCATE(CONI(2*INTCONMAX))
CONI(1:INTCONMAX)=ICPTEMP(1:INTCONMAX)

IF (NCONGEOM.GE.2) THEN
   ICPTEMP(1:INTCONMAX)=CONIFIX(1:INTCONMAX)
   DEALLOCATE(CONIFIX)
   ALLOCATE(CONIFIX(2*INTCONMAX))
   CONIFIX(1:INTCONMAX)=ICPTEMP(1:INTCONMAX)
               
   ICPTEMP(1:INTCONMAX)=CONJFIX(1:INTCONMAX)
   DEALLOCATE(CONJFIX)
   ALLOCATE(CONJFIX(2*INTCONMAX))
   CONJFIX(1:INTCONMAX)=ICPTEMP(1:INTCONMAX)
               
   CPTEMP(1:INTCONMAX)=CONDISTREFFIX(1:INTCONMAX)
   DEALLOCATE(CONDISTREFFIX)
   ALLOCATE(CONDISTREFFIX(2*INTCONMAX))
   CONDISTREFFIX(1:INTCONMAX)=CPTEMP(1:INTCONMAX)
               
   CPTEMP(1:INTCONMAX)=CONCUTFIX(1:INTCONMAX)
   DEALLOCATE(CONCUTFIX)
   ALLOCATE(CONCUTFIX(2*INTCONMAX))
   CONCUTFIX(1:INTCONMAX)=CPTEMP(1:INTCONMAX)
ENDIF
               
ICPTEMP(1:INTCONMAX)=CONJ(1:INTCONMAX)
DEALLOCATE(CONJ)
ALLOCATE(CONJ(2*INTCONMAX))
CONJ(1:INTCONMAX)=ICPTEMP(1:INTCONMAX)
               
CPTEMP(1:INTCONMAX)=CONDISTREF(1:INTCONMAX)
DEALLOCATE(CONDISTREF)
ALLOCATE(CONDISTREF(2*INTCONMAX))
CONDISTREF(1:INTCONMAX)=CPTEMP(1:INTCONMAX)
               
CPTEMP(1:INTCONMAX)=CONCUT(1:INTCONMAX)
DEALLOCATE(CONCUT)
ALLOCATE(CONCUT(2*INTCONMAX))
CONCUT(1:INTCONMAX)=CPTEMP(1:INTCONMAX)

INTCONMAX=2*INTCONMAX
DEALLOCATE(CPTEMP)
DEALLOCATE(ICPTEMP)

END SUBROUTINE CONDOUBLE
