!   Copyright (C) 2003-2010 David J. Wales
!   This file is part of OPTIM.
!
!   OPTIM is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   OPTIM is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
SUBROUTINE INTLBFGS(QSTART,QFINISH,LMINFOUND,LTSFOUND,MYMINFOUND,MYTSFOUND,MIN1ID,MIN2ID)
USE PORFUNCS
USE KEYNEB, ONLY : NIMAGE, NITERMAX
USE MODCHARMM, ONLY : CHRMMT
USE NEWNEBMODULE
USE NEBTOCONNECT
USE CONNECTUTILS, ONLY : ISNEWMIN, ADDNEWMIN
USE CONNECTDATA, ONLY : NMIN, MI
USE KEYCONNECT, ONLY :  IMAGEMAX, IMAGEDENSITY, ITERDENSITY, NTRIESMAX, IMAGEINCR
USE KEY, ONLY : FREEZENODEST, FREEZETOL, MAXINTBFGS, INTNEBIMAGES, &
     & INTRMSTOL, INTIMAGE, NREPMAX, NREPULSIVE, INTMUPDATE, INTDGUESS, &
     & NCONSTRAINT, CONI, CONJ, CONDISTREF, INTCONMAX, &
     & INTCONSTRAINREPCUT, REPCON, INTCONSTRAINTREP, INTREPSEP, NREPI, NREPJ, &
     & CONDISTREFLOCAL, INTCONFRAC, CONACTIVE, NITSTART, REPI, &
     & REPJ, NREPMAX, ATOMACTIVE, NCONSTRAINTON, CONION, CONJON, CONDISTREFLOCALON, CONDISTREFON, &
     & NREPCUT, REPCUT, CHECKCONINT, INTCONSTEPS, INTRELSTEPS, MAXCONE, COLDFUSIONLIMIT, &
     & INTSTEPS1, DUMPINTXYZ, DUMPINTXYZFREQ, DUMPINTEOS, DUMPINTEOSFREQ, MUPDATE, BFGSSTEPS, INTTST, &
     & BFGSTST, NSTEPS, IMSEPMIN, IMSEPMAX, MAXINTIMAGE, EDIFFTOL, INTFREEZET, INTFREEZETOL, FREEZE, &
     & INTFROZEN, CHECKREPINTERVAL, NNREPULSIVE, INTFREEZEMIN, RIGIDBODY, TWOD, BULKT, INTIMAGECHECK, &
     & CONCUT, NCONGEOM, CONCUTLOCAL, NONEBMAX, WHOLEDNEB
USE COMMONS, ONLY: NATOMS, NOPT, ZSYM, DEBUG, PARAM1, PARAM2, PARAM3, REDOPATH
USE MODEFOL

IMPLICIT NONE 

DOUBLE PRECISION, INTENT(IN) :: QSTART(NOPT), QFINISH(NOPT)  ! The two end points
INTEGER D, U
DOUBLE PRECISION DMAX, DF, DMIN
INTEGER NDECREASE, NFAIL, NMAXINT, NMININT, JMAX, JMIN, INTIMAGESAVE, NOFF, J1, J2, ISTAT, POSITION, M1, M2
LOGICAL KNOWE, KNOWG, KNOWH, ADDATOM, PTEST, MFLAG, PRINTOPTIMIZETS, PRINTOPTIMIZEMIN, ADDREP(NATOMS), &
   &    INTMAXT, MINNEW
COMMON /KNOWN/ KNOWE, KNOWG, KNOWH

DOUBLE PRECISION EDUMMY,EVALMIN,EVALMAX,DUMMY,DUMMY2(1)
INTEGER POINT,NPT,J3,J4,NIMAGEFREEZE,NACTIVE,NBEST,NEWATOM,LMINFOUND,NSIDE,ITDONE,LTSFOUND,MIN1ID,MIN2ID
INTEGER STARTID, FINISHID
INTEGER TURNONORDER(NATOMS),NBACKTRACK,NQCIFREEZE
DOUBLE PRECISION, DIMENSION(3*NATOMS) :: LGDUMMY, VECS, XDIAG
INTEGER NDUMMY, NLASTGOODE, NSTEPSMAX
INTEGER NTRIES(NATOMS), NITERDONE, EXITSTATUS, DLIST(NATOMS)
DOUBLE PRECISION :: DDOT,STPMIN,PREVGRAD,EMINUS,EPLUS, STARTTIME, TIME0, DISTPREV, EMINPREV, EMINPREVPREV, &
  &                 DINCREMENT, ETOTALTMP, RMSTMP, USEFRAC, STIME, FTIME, DISTPREVPREV, &
  &                 ETOTAL, LASTGOODE, RMS, STEPTOT, LINTCONSTRAINTTOL, INTMAXE, INTMAXDIST, &
  &                 INTMAXCOORDS(NOPT), LXYZ(2*NOPT), EINITIAL, EFINAL, &
  &                 VNEW(NOPT), ENERGY, RMS2, EREAL, LOCALCOORDS(3*NATOMS), DIST2, RMAT(3,3), CMIN1(3*NATOMS)
DOUBLE PRECISION, POINTER :: PINTERPCOORDS(:), PENERGY
INTEGER INVERT, INDEX(NATOMS), IMATCH
LOGICAL PERMUTE

LOGICAL TSCONVERGED, TSRESET
DOUBLE PRECISION, DIMENSION(INTMUPDATE)     :: RHO1,ALPHA
DOUBLE PRECISION :: EOLD, DIFF, DIST, DTOTAL, DMOVED(NATOMS)
LOGICAL SWITCHED
DOUBLE PRECISION, POINTER :: X(:), G(:)
DOUBLE PRECISION, ALLOCATABLE :: GLOCAL(:), EWINDOW(:)
!
! These declarations have to match those in NEB/ntc.f90
!
! TYPE MINFOUNDTYPE
!    DOUBLE PRECISION,POINTER :: E
!    DOUBLE PRECISION,POINTER :: COORD(:)
! END TYPE MINFOUNDTYPE
! INTEGER,PARAMETER :: NMINMAX = 3000 ! Maximal number of min to be checked in one intlbfgs run
TYPE (MINFOUNDTYPE) :: MYMINFOUND(NMINMAX)

! INTEGER,PARAMETER :: NTSMAX = 3000 ! Maximal number of ts to be checked in one intlbfgs run
! TYPE TSFOUNDTYPE
!      DOUBLE PRECISION,POINTER :: E
!      DOUBLE PRECISION,POINTER :: EVALMIN
!      DOUBLE PRECISION,POINTER :: COORD(:)
!      DOUBLE PRECISION,POINTER :: VECS(:)
! END TYPE TSFOUNDTYPE

TYPE (TSFOUNDTYPE) :: MYTSFOUND(NTSMAX)

!
! If we USE NEBTOCONNECT then intlbfgs should have direct access to
! NTSFOUND, NMINFOUND, MINFOUND and TSFOUND. We should be able to delete
! the local variables, change MYTSFOUND and MYMINFOUND to TSFOUND and
! MINFOUND, and remove the subroutine arguments and LTSFOUND and LMINFOUND. 
! Not yet done, since INTLBFGSLJ needs to be changed in the same way. 
!

!
! efk: for freezenodes
!
DOUBLE PRECISION :: TESTG, TOTGNORM
INTEGER :: IM
!
! Dimensions involving INTIMAGE
!
DOUBLE PRECISION, ALLOCATABLE :: TRUEEE(:), &
  &              EEETMP(:), MYGTMP(:), EEE(:), STEPIMAGE(:), &
  &              GTMP(:), DIAG(:), STP(:), SEARCHSTEP(:,:), GDIF(:,:), GLAST(:), XSAVE(:)
DOUBLE PRECISION, ALLOCATABLE, TARGET :: XYZ(:), GGG(:), DPTMP(:), D2TMP(:,:)
LOGICAL, ALLOCATABLE :: CHECKG(:), IMGFREEZE(:)

ALLOCATE(TRUEEE(INTIMAGE+2), &
  &      EEETMP(INTIMAGE+2), MYGTMP(3*NATOMS*INTIMAGE), &
  &      GTMP(3*NATOMS*INTIMAGE), &
  &      DIAG(3*NATOMS*INTIMAGE), STP(3*NATOMS*INTIMAGE), SEARCHSTEP(0:INTMUPDATE,NOPT*INTIMAGE), &
  &      GDIF(0:INTMUPDATE,NOPT*INTIMAGE),GLAST(NOPT*INTIMAGE), XSAVE(NOPT*INTIMAGE), &
  &      XYZ(NOPT*(INTIMAGE+2)), GGG(NOPT*(INTIMAGE+2)), CHECKG(NOPT*INTIMAGE), IMGFREEZE(INTIMAGE), &
  &      EEE(INTIMAGE+2), STEPIMAGE(INTIMAGE))

SWITCHED=.FALSE.
INTIMAGESAVE=INTIMAGE
NBACKTRACK=1
CALL MYCPU_TIME(STIME,.FALSE.)
PRINT '(A,I6)',' intlbfgs> Maximum number of steps for constraint potential phase is ',INTSTEPS1
PREVGRAD=1.0D100
ADDATOM=.FALSE.
INTTST=.TRUE.  ! must set this before any possible exit
NFAIL=0
IF (FREEZENODEST) IMGFREEZE(1:INTIMAGE)=.FALSE.
D=NOPT*INTIMAGE
U=INTMUPDATE
NITERDONE=1

IF ( D<=0 ) THEN
   PRINT *, 'd is not positive, d=',d
   CALL TSUMMARY
   STOP
ENDIF
IF ( U<=0 ) THEN
   PRINT *, 'u is not positive, u=',u
   CALL TSUMMARY
   STOP
ENDIF
IF (INTSTEPS1 < 0) THEN
   PRINT '(1x,a)', 'Maximal number of iterations is less than zero! Stop.'
   CALL TSUMMARY
   STOP
ENDIF
!
! XYZ, GGG, EEE include the end point images
! X, G do not.
!
IF (.NOT.ALLOCATED(CONI)) THEN 
   ALLOCATE(CONI(INTCONMAX),CONJ(INTCONMAX),CONDISTREF(INTCONMAX),CONCUT(INTCONMAX))
   ALLOCATE(REPI(NREPMAX),REPJ(NREPMAX),NREPI(NREPMAX),NREPJ(NREPMAX),REPCUT(NREPMAX),NREPCUT(NREPMAX))
ENDIF
X=>XYZ(NOPT+1:NOPT*(INTIMAGE+1))
G=>GGG(NOPT+1:NOPT*(INTIMAGE+1))
!
! Initialise XYZ
!
XYZ(1:NOPT)=QSTART(1:NOPT)
XYZ(NOPT*(INTIMAGE+1)+1:NOPT*(INTIMAGE+2))=QFINISH(1:NOPT)
DO J1=1,INTIMAGE+2
   XYZ((J1-1)*NOPT+1:J1*NOPT)=((INTIMAGE+2-J1)*QSTART(1:NOPT)+(J1-1)*QFINISH(1:NOPT))/(INTIMAGE+1)
ENDDO

NQCIFREEZE=0
IF (FREEZE) THEN
   PRINT '(A)',' intlbfgs> ERROR *** QCI has not been coded for frozen atoms yet'
   STOP     
ENDIF
IF (ALLOCATED(INTFROZEN)) DEALLOCATE(INTFROZEN)
ALLOCATE(INTFROZEN(NATOMS))
INTFROZEN(1:NATOMS)=.FALSE.
DLIST(1:NATOMS)=-1
DMOVED(1:NATOMS)=1.0D100
IF (INTFREEZET) THEN
   DUMMY=INTFREEZETOL**2
   DO J1=1,NATOMS
      DF=(XYZ(3*(J1-1)+1)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+1))**2 &
  &     +(XYZ(3*(J1-1)+2)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+2))**2 &
  &     +(XYZ(3*(J1-1)+3)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+3))**2
      IF (DF.LT.DUMMY) THEN
         NQCIFREEZE=NQCIFREEZE+1
         INTFROZEN(J1)=.TRUE.
!        IF (DEBUG) PRINT '(A,I6,A,F12.6,A,I6)',' intlbfgs> atom ',J1,' moves less than threshold: dist^2=',DF,' total=',NQCIFREEZE
      ENDIF
      sortd: DO J2=1,J1
         IF (DF.LT.DMOVED(J2)) THEN
            DO J3=J1,J2+1,-1
               DMOVED(J3)=DMOVED(J3-1)
               DLIST(J3)=DLIST(J3-1)
            ENDDO
            DMOVED(J2)=DF
            DLIST(J2)=J1
            EXIT sortd
         ENDIF
      ENDDO sortd
   ENDDO
   PRINT '(A,I6,A,F12.6,A,I6)',' intlbfgs> Total number of atoms moving less than threshold=',NQCIFREEZE
ENDIF

IF (NATOMS-NQCIFREEZE.LT.INTFREEZEMIN) THEN
   DO J1=NATOMS,NATOMS-INTFREEZEMIN+1,-1
      INTFROZEN(DLIST(J1))=.FALSE.
   ENDDO
   NQCIFREEZE=NATOMS-INTFREEZEMIN
   PRINT '(A,I6,A)',' intlbfgs> Freezing ',NQCIFREEZE,' atoms'
ENDIF

NLASTGOODE=0
LASTGOODE=1.0D100

!
! Constraints are collected in a list and activated via the CONACTIVE(J1)
! logical array. There will generally be of order NATOMS. However, the
! repulsions will scale as NATOMS**2 and are treated differently. The
! active repulsions are stored sequentially as atoms are added to the
! growing list. This is done even if we have congeom or congeom.dat files
! available. In this case we use the fixed list of possible constraints
! via CHECKPERC, but the list of repulsions and cutoffs is recreated on
! the fly. The fixed lists are used in make_conpot, since this is called
! for pairs of minima with all atoms active to obtain an interpolation
! metric.
!
! Perhaps we should use the fixed list to activate the repulsions below?
! A neighbour list for repulsions is maintained to make the constraint
! potential evaluation scale as order N.
!
IF (NQCIFREEZE.LT.NATOMS) THEN
   LXYZ(1:NOPT)=QSTART(1:NOPT)
   LXYZ(NOPT+1:2*NOPT)=QFINISH(1:NOPT)
   CALL CHECKPERC(LXYZ,LINTCONSTRAINTTOL,NQCIFREEZE,2)
ELSE
   IF (.NOT.ALLOCATED(ATOMACTIVE)) ALLOCATE(ATOMACTIVE(NATOMS))
   NCONSTRAINT=0
   PRINT '(A)',' intlbfgs> All atoms move less than threshold - skip to linear interpolation for end points'
   INTIMAGE=0
   XYZ(1:NOPT)=QSTART(1:NOPT)
   XYZ(NOPT*(INTIMAGE+1)+1:NOPT*(INTIMAGE+2))=QFINISH(1:NOPT)
   DO J1=1,INTIMAGE+2
      XYZ((J1-1)*NOPT+1:J1*NOPT)=((INTIMAGE+2-J1)*QSTART(1:NOPT)+(J1-1)*QFINISH(1:NOPT))/(INTIMAGE+1)
   ENDDO
   GOTO 678
ENDIF

NACTIVE=0
ATOMACTIVE(1:NATOMS)=.FALSE.
IF (INTFREEZET) THEN
   DO J1=1,NATOMS
      IF (INTFROZEN(J1)) THEN
! 
! linear interpolation 
! 
         DO J2=2,INTIMAGE+1
            XYZ((J2-1)*3*NATOMS+3*(J1-1)+1:(J2-1)*3*NATOMS+3*(J1-1)+3)= &
  &            (INTIMAGE-J2+2)*XYZ(3*(J1-1)+1:3*(J1-1)+3)/(INTIMAGE+1) &
  &           +(J2-1)*XYZ(3*NATOMS*(INTIMAGE+1)+3*(J1-1)+1:3*NATOMS*(INTIMAGE+1)+3*(J1-1)+3)/(INTIMAGE+1)
         ENDDO
         ATOMACTIVE(J1)=.TRUE.
         NACTIVE=NACTIVE+1
         TURNONORDER(NACTIVE)=J1
         NTRIES(J1)=1
      ENDIF
   ENDDO
ENDIF

REPCON=-INTCONSTRAINTREP/INTCONSTRAINREPCUT**6 ! also needed for congrad.f90 potential
IF (ALLOCATED(CONDISTREFLOCAL)) DEALLOCATE(CONDISTREFLOCAL)
IF (ALLOCATED(CONCUTLOCAL)) DEALLOCATE(CONCUTLOCAL)
ALLOCATE(CONDISTREFLOCAL(NCONSTRAINT))
ALLOCATE(CONCUTLOCAL(NCONSTRAINT))
IF (ALLOCATED(CONDISTREFLOCALON)) DEALLOCATE(CONDISTREFLOCALON)
IF (ALLOCATED(CONDISTREFON)) DEALLOCATE(CONDISTREFON)
IF (ALLOCATED(CONION)) DEALLOCATE(CONION)
IF (ALLOCATED(CONJON)) DEALLOCATE(CONJON)
ALLOCATE(CONDISTREFLOCALON(NCONSTRAINT),CONDISTREFON(NCONSTRAINT),CONION(NCONSTRAINT),CONJON(NCONSTRAINT))
CONDISTREFLOCAL(1:NCONSTRAINT)=CONDISTREF(1:NCONSTRAINT)
CONCUTLOCAL(1:NCONSTRAINT)=CONCUT(1:NCONSTRAINT)
DUMMY=1.0D100
IF (NCONSTRAINT.EQ.0) THEN
   NACTIVE=NATOMS
   EOLD=ETOTAL
   SWITCHED=.TRUE.
   USEFRAC=1.0D0
   NREPULSIVE=0
   NNREPULSIVE=0
   GLAST(1:D)=G(1:D)
   XSAVE(1:D)=X(1:D)
   GOTO 567
ENDIF
DO J1=1,NCONSTRAINT
   DF=SQRT((XYZ(3*(CONI(J1)-1)+1)-XYZ((INTIMAGE+1)*3*NATOMS+3*(CONI(J1)-1)+1))**2 &
  &       +(XYZ(3*(CONI(J1)-1)+2)-XYZ((INTIMAGE+1)*3*NATOMS+3*(CONI(J1)-1)+2))**2 &
  &       +(XYZ(3*(CONI(J1)-1)+3)-XYZ((INTIMAGE+1)*3*NATOMS+3*(CONI(J1)-1)+3))**2)&
  &  +SQRT((XYZ(3*(CONJ(J1)-1)+1)-XYZ((INTIMAGE+1)*3*NATOMS+3*(CONJ(J1)-1)+1))**2 &
  &       +(XYZ(3*(CONJ(J1)-1)+2)-XYZ((INTIMAGE+1)*3*NATOMS+3*(CONJ(J1)-1)+2))**2 &
  &       +(XYZ(3*(CONJ(J1)-1)+3)-XYZ((INTIMAGE+1)*3*NATOMS+3*(CONJ(J1)-1)+3))**2)
   IF (DF.LT.DUMMY) THEN
      NBEST=J1
      DUMMY=DF
   ENDIF
ENDDO
IF (DEBUG) PRINT '(A,I6,A,2I6,A,F15.5)',' intlbfgs> Smallest overall motion for constraint ',NBEST,' atoms ', &
  &                           CONI(NBEST),CONJ(NBEST),' distance=',DUMMY

TURNONORDER(1:NATOMS)=0
NTRIES(1:NATOMS)=1
IF (ALLOCATED(CONACTIVE)) DEALLOCATE(CONACTIVE)
IF (ALLOCATED(NITSTART)) DEALLOCATE(NITSTART)
ALLOCATE(CONACTIVE(NCONSTRAINT),NITSTART(NCONSTRAINT))
CONACTIVE(1:NCONSTRAINT)=.FALSE.
CONACTIVE(NBEST)=.TRUE.
NITSTART(NBEST)=1
ATOMACTIVE(CONI(NBEST))=.TRUE.
ATOMACTIVE(CONJ(NBEST))=.TRUE.
IF (.NOT.INTFROZEN(CONI(NBEST))) THEN
   TURNONORDER(NACTIVE+1)=CONI(NBEST)
   NACTIVE=NACTIVE+1
ENDIF
IF (.NOT.INTFROZEN(CONJ(NBEST))) THEN
   TURNONORDER(NACTIVE+2)=CONJ(NBEST)
   NACTIVE=NACTIVE+1
ENDIF
NTRIES(CONI(NBEST))=1
NTRIES(CONJ(NBEST))=1
NREPULSIVE=0
NCONSTRAINTON=1
CONDISTREFLOCALON(1)=CONDISTREFLOCAL(NBEST)
CONDISTREFON(1)=CONDISTREF(NBEST)
CONION(1)=CONI(NBEST)
CONJON(1)=CONJ(NBEST)
IF (DEBUG) PRINT '(A,I6)',' intlbfgs> Number of active atoms is now ',NACTIVE
!
! If INTFREEZET is true we need to add constraints and replusions to the frozen atoms.
!
IF (INTFREEZET) THEN
DO J1=1,NCONSTRAINT
   IF (CONACTIVE(J1)) CYCLE
   IF ((CONI(J1).EQ.CONI(NBEST)).AND.(ATOMACTIVE(CONJ(J1))).OR.(CONJ(J1).EQ.CONI(NBEST)).AND.(ATOMACTIVE(CONI(J1)))) THEN
      CONACTIVE(J1)=.TRUE.
      IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning on constraint ',J1,' for atoms ',CONI(J1),CONJ(J1)
   ENDIF
   IF ((CONI(J1).EQ.CONJ(NBEST)).AND.(ATOMACTIVE(CONJ(J1))).OR.(CONJ(J1).EQ.CONJ(NBEST)).AND.(ATOMACTIVE(CONI(J1)))) THEN
      CONACTIVE(J1)=.TRUE.
      IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning on constraint ',J1,' for atoms ',CONI(J1),CONJ(J1)
   ENDIF
ENDDO

DO J1=1,NATOMS
   IF (.NOT.ATOMACTIVE(J1)) CYCLE ! identify active atoms
   IF (ABS(J1-CONI(NBEST)).LE.INTREPSEP) CYCLE ! no repulsion for atoms too close in sequence
   IF (INTFROZEN(J1).AND.INTFROZEN(CONI(NBEST))) CYCLE
   DO J2=1,NCONSTRAINT
!
!  With MAXCONUSE set to a finite value there could be constraints for the new atom that are
!  not active. We don't want these to be changed to repulsion, surely?!
!  Or perhaps we do need to do something with them?
!
      IF (.NOT.CONACTIVE(J2)) CYCLE ! identify active constraints
      IF (((CONI(J2).EQ.J1).AND.(CONJ(J2).EQ.CONI(NBEST))).OR.((CONJ(J2).EQ.J1).AND.(CONI(J2).EQ.CONI(NBEST)))) GOTO 545
   ENDDO
   DMIN=1.0D100
   DMAX=-1.0D0
   DO J2=1,INTIMAGE+2,INTIMAGE+1 ! only consider the end-point distances
      DF=SQRT((XYZ((J2-1)*3*NATOMS+3*(CONI(NBEST)-1)+1)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+1))**2+ &
  &           (XYZ((J2-1)*3*NATOMS+3*(CONI(NBEST)-1)+2)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+2))**2+ &
  &           (XYZ((J2-1)*3*NATOMS+3*(CONI(NBEST)-1)+3)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+3))**2)
      IF (DF.GT.DMAX) DMAX=DF
      IF (DF.LT.DMIN) DMIN=DF
   ENDDO
!
! Use the minimum of the end point distances and INTCONSTRAINREPCUT for each contact.
!
   DMIN=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
   NREPULSIVE=NREPULSIVE+1
   IF (NREPULSIVE.GT.NREPMAX) CALL REPDOUBLE
   REPI(NREPULSIVE)=J1
   REPJ(NREPULSIVE)=CONI(NBEST)
   REPCUT(NREPULSIVE)=DMIN
!  IF (DEBUG) PRINT '(A,I6,A,I6,A,F15.5)',' intlbfgs> Adding repulsion for new atom ',CONI(NBEST),' with atom ',J1, &
! &                                          ' cutoff=',DMIN
545 CONTINUE
ENDDO

DO J1=1,NATOMS
   IF (ABS(J1-CONJ(NBEST)).LE.INTREPSEP) CYCLE ! no repulsion for atoms too close in sequence
   IF (INTFROZEN(J1).AND.INTFROZEN(CONJ(NBEST))) CYCLE
   DO J2=1,NCONSTRAINT
!
!  With MAXCONUSE set to a finite value there could be constraints for the new atom that are
!  not active. We don't want these to be changed to repulsion, surely?!
!  Or perhaps we do need to do something with them?
!
      IF (.NOT.CONACTIVE(J2)) CYCLE ! identify active constraints
      IF (((CONI(J2).EQ.J1).AND.(CONJ(J2).EQ.CONJ(NBEST))).OR.((CONJ(J2).EQ.J1).AND.(CONI(J2).EQ.CONJ(NBEST)))) GOTO 541
   ENDDO
   DMIN=1.0D100
   DMAX=-1.0D0
   DO J2=1,INTIMAGE+2,INTIMAGE+1 ! only consider the end-point distances
      DF=SQRT((XYZ((J2-1)*3*NATOMS+3*(CONJ(NBEST)-1)+1)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+1))**2+ &
  &           (XYZ((J2-1)*3*NATOMS+3*(CONJ(NBEST)-1)+2)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+2))**2+ &
  &           (XYZ((J2-1)*3*NATOMS+3*(CONJ(NBEST)-1)+3)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+3))**2)
      IF (DF.GT.DMAX) DMAX=DF
      IF (DF.LT.DMIN) DMIN=DF
   ENDDO
!
! Use the minimum of the end point distances and INTCONSTRAINREPCUT for each contact.
!
   DMIN=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
   NREPULSIVE=NREPULSIVE+1
   IF (NREPULSIVE.GT.NREPMAX) CALL REPDOUBLE
   REPI(NREPULSIVE)=J1
   REPJ(NREPULSIVE)=CONJ(NBEST)
   REPCUT(NREPULSIVE)=DMIN
!  IF (DEBUG) PRINT '(A,I6,A,I6,A,F15.5)',' intlbfgs> Adding repulsion for new atom ',CONJ(NBEST),' with atom ',J1, &
! &                                          ' cutoff=',DMIN
541 CONTINUE
ENDDO
ENDIF
CALL MYCPU_TIME(FTIME,.FALSE.)
PRINT '(A,F10.1)',' intlbfgs> constrained potential finished, time=',FTIME-STIME
STIME=FTIME
!
! Don;t want to redistribute images before even taking a step, so don;t call CHECKSEP.
! Must call CHECKREP to initialise NNREULSIVE, NREPI, NREPJ, etc. SEGV otherwise on second cycle!
!
CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
IF (CHECKCONINT) THEN
   CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
ELSE
   CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
ENDIF
EOLD=ETOTAL
GLAST(1:D)=G(1:D)
XSAVE(1:D)=X(1:D)

IF (ETOTAL/INTIMAGE.LT.COLDFUSIONLIMIT) THEN
   WRITE(*,'(A,2G20.10)') ' intlbfgs> Cold fusion diagnosed - step discarded, energy, limit=', &
  &                       ETOTAL/INTIMAGE,COLDFUSIONLIMIT
   DEALLOCATE(CONI,CONJ,CONDISTREF,REPI,REPJ,NREPI,NREPJ,REPCUT,NREPCUT,CONCUT)
   DEALLOCATE(TRUEEE, EEETMP, MYGTMP, GTMP, &
  &      DIAG, STP, SEARCHSTEP, GDIF,GLAST, XSAVE, XYZ, GGG, CHECKG, IMGFREEZE, EEE, STEPIMAGE)
   INTIMAGE=INTIMAGESAVE
   LTSFOUND=0
   LMINFOUND=0
   RETURN
ENDIF

! IF (DEBUG) WRITE(*,'(A6,A20,A20,A9,A9)') 'Iter','Energy per image','RMS Force','Step'
NSTEPSMAX=INTSTEPS1

567 CONTINUE

DO ! Main do loop with counter NITERDONE, initially set to one
!
!  Add next atom to active set if ADDATOM is true. 
!  Constraints to atoms already in the active set are turned on
!  and short-range repulsions to active atoms that are not distance constrained are turned on.
!  *** OLD Find nearest atom to active set attached by a constraint
!  *** NEW Find atom with most constraints to active set
!  Turn on constraint terms for this atom with all previous members of the active set
!  Add repulsions to non-constrained atoms in this set
!  NTOADD is the number of atoms to add to the active set in each pass. 1 seems best!
!
   IF (ADDATOM.AND.(NACTIVE.LT.NATOMS)) THEN
      CALL DOADDATOM(NCONSTRAINT,NTRIES,NEWATOM,IMGFREEZE,INTIMAGE,XYZ,EEE,GGG,TURNONORDER,NITERDONE,NACTIVE)
      IF (FREEZENODEST) NIMAGEFREEZE=0
      NLASTGOODE=NITERDONE
      LASTGOODE=ETOTAL
   ENDIF
   CALL MAKESTEP(NITERDONE,POINT,DIAG,INTIMAGE,SEARCHSTEP,G,GTMP,STP,GDIF,NPT,D,RHO1,ALPHA)
!
! If the number of images has changed since G was declared then G is not the same
! size as Gtmp and Dot_Product cannot be used.
!
!  IF (Dot_Product(G,Gtmp)/SQRT( Dot_Product(G,G)*Dot_Product(Gtmp,Gtmp) ) > 0.0D0) THEN
!
!  Separate sqrt;s to avoid overflow.
!
   IF (DDOT(D,G,1,GTMP,1)/MAX(1.0D-100,SQRT( DDOT(D,G,1,G,1))*SQRT(DDOT(D,GTMP,1,GTMP,1)) ) > 0.0D0) THEN
        IF (DEBUG) PRINT*,'Search direction has positive projection onto gradient - reversing step'
        GTMP(1:D)=-GTMP(1:D)
        SEARCHSTEP(POINT,1:D)=GTMP(1:D)
   ENDIF
   GTMP(1:D)=G(1:D)

!  We should apply the maximum LBFGS step to each image separately.
!  However, using different scale factors for different images leads to huge
!  discontinuities! Now take the minimum scale factor for all images. DJW 26/11/07

   STPMIN=1.0D0
   DO J2=1,INTIMAGE
      STEPIMAGE(J2) = SQRT(DOT_PRODUCT(SEARCHSTEP(POINT,NOPT*(J2-1)+1:NOPT*J2),SEARCHSTEP(POINT,NOPT*(J2-1)+1:NOPT*J2)))
      DUMMY=STEPIMAGE(J2)
      IF (STEPIMAGE(J2) > MAXINTBFGS) THEN
           STP(NOPT*(J2-1)+1:NOPT*J2) = MAXINTBFGS/STEPIMAGE(J2)
           STPMIN=MIN(STPMIN,STP(NOPT*(J2-1)+1))
      ENDIF
!     PRINT '(A,I8,3G20.10)',' image,initial step size,STP,prod=',J2,DUMMY,STP(NOPT*(J2-1)+1),STEPIMAGE(J2)*STP(NOPT*(J2-1)+1)
   ENDDO
   STP(1:D)=STPMIN

! EFK: decide whether to freeze some nodes
   IF (FREEZENODEST) THEN
      TOTGNORM=SQRT(DOT_PRODUCT(G(1:NOPT*INTIMAGE),G(1:NOPT*INTIMAGE))/INTIMAGE)
      NIMAGEFREEZE=0
      DO IM=1,INTIMAGE
         TESTG=SQRT(DOT_PRODUCT(G(NOPT*(IM-1)+1:NOPT*IM),G(NOPT*(IM-1)+1:NOPT*IM)))
         IMGFREEZE(IM)=.FALSE.
         IF (TOTGNORM.NE.0.0D0) THEN
!           IF (TESTG/TOTGNORM.LT.FREEZETOL) THEN
            IF (TESTG/SQRT(3.0D0*NATOMS).LT.FREEZETOL) THEN
!              IF (DEBUG) PRINT '(A,I6,3G20.10)', ' intlbfgs> Freezing image: ',IM,TESTG,FREEZETOL,TOTGNORM
               IMGFREEZE(IM)=.TRUE.
               STEPIMAGE(IM)=0.0D0
               NIMAGEFREEZE=NIMAGEFREEZE+1
               STP(NOPT*(IM-1)+1:NOPT*IM)=0.0D0
            ENDIF
         ENDIF
      ENDDO
      IF (DEBUG) PRINT '(2(A,I6))', ' intlbfgs> Number of frozen images=',NIMAGEFREEZE,' / ',INTIMAGE
   ENDIF
   !  We now have the proposed step - update geometry and calculate new gradient
   NDECREASE=0
20 X(1:D) = X(1:D) + STP(1:D)*SEARCHSTEP(POINT,1:D)

!  IF (.NOT.SWITCHED) THEN
   IF (.TRUE.) THEN
!     IF ((RMS.LT.INTRMSTOL*1.0D10).AND.(MOD(NITERDONE,10).EQ.0).AND.(NSTEPSMAX-NITERDONE.GT.100)) &
! &               CALL CHECKSEP(NMAXINT,NMININT,INTIMAGE,XYZ,NOPT,NATOMS)
      IF (MOD(NITERDONE,INTIMAGECHECK).EQ.0) THEN
864      CONTINUE ! for adding more than one image at a time
         DMAX=0.0D0
         DMIN=HUGE(1.0D0)
         DO J1=1,INTIMAGE+1
            DUMMY=0.0D0
            DO J2=1,3*NATOMS
               IF (ATOMACTIVE((J2-1)/3+1)) THEN
                  DUMMY=DUMMY+( XYZ((J1-1)*3*NATOMS+J2) - XYZ(J1*3*NATOMS+J2) )**2
               ENDIF
            ENDDO
            DUMMY=SQRT(DUMMY)
            IF (DUMMY.GT.DMAX) THEN
               DMAX=DUMMY
               JMAX=J1
            ENDIF
            IF (DUMMY.LT.DMIN) THEN
               DMIN=DUMMY
               JMIN=J1
            ENDIF
!           IF (DEBUG) PRINT '(A,I6,A,I6,A,G20.10)',' intlbfgs> distance between images ', &
! &                                                  J1,' and ',J1+1,' is ',DUMMY
         ENDDO
         IF ((DMAX.GT.IMSEPMAX).AND.(INTIMAGE.LT.MAXINTIMAGE)) THEN
!           PRINT '(A,I6,A,I6)',' intlbfgs> Add an image between ',JMAX,' and ',JMAX+1
            ALLOCATE(DPTMP(3*NATOMS*(INTIMAGE+2)))
            DPTMP(1:3*NATOMS*(INTIMAGE+2))=XYZ(1:3*NATOMS*(INTIMAGE+2))
            DEALLOCATE(XYZ)
            ALLOCATE(XYZ(3*NATOMS*(INTIMAGE+3)))
            XYZ(1:3*NATOMS*JMAX)=DPTMP(1:3*NATOMS*JMAX)
            XYZ(3*NATOMS*JMAX+1:3*NATOMS*(JMAX+1))=(DPTMP(3*NATOMS*(JMAX-1)+1:3*NATOMS*JMAX) &
  &                                               + DPTMP(3*NATOMS*JMAX+1:3*NATOMS*(JMAX+1)))/2.0D0
            XYZ(3*NATOMS*(JMAX+1)+1:3*NATOMS*(INTIMAGE+3))=DPTMP(3*NATOMS*JMAX+1:3*NATOMS*(INTIMAGE+2))
!
! Save step-taking memories in SEARCHSTEP and GDIF.
! These arrays run from 0 to INTMUPDATE over memories and
! 1:NOPT*INTIMAGE over only the variable images.
!
            DEALLOCATE(DPTMP)
            ALLOCATE(D2TMP(0:INTMUPDATE,1:NOPT*INTIMAGE))
            D2TMP(0:INTMUPDATE,1:NOPT*INTIMAGE)=SEARCHSTEP(0:INTMUPDATE,1:NOPT*INTIMAGE)
            DEALLOCATE(SEARCHSTEP)
            ALLOCATE(SEARCHSTEP(0:INTMUPDATE,1:NOPT*(INTIMAGE+1)))
            DO J1=0,INTMUPDATE
               IF (JMAX.GT.1) SEARCHSTEP(J1,1:3*NATOMS*(JMAX-1))=D2TMP(J1,1:3*NATOMS*(JMAX-1))
               IF (JMAX.LT.INTIMAGE+1) SEARCHSTEP(J1,3*NATOMS*JMAX+1:3*NATOMS*(INTIMAGE+1))= &
  &                 D2TMP(J1,3*NATOMS*(JMAX-1)+1:3*NATOMS*INTIMAGE)
               SEARCHSTEP(J1,3*NATOMS*(JMAX-1)+1:3*NATOMS*JMAX)= &
  &                             D2TMP(J1,3*NATOMS*(MIN(JMAX,INTIMAGE)-1)+1:3*NATOMS*MIN(JMAX,INTIMAGE))
            ENDDO
            D2TMP(0:INTMUPDATE,1:NOPT*INTIMAGE)=GDIF(0:INTMUPDATE,1:NOPT*INTIMAGE)
            DEALLOCATE(GDIF)
            ALLOCATE(GDIF(0:INTMUPDATE,1:NOPT*(INTIMAGE+1)))
            DO J1=0,INTMUPDATE
               IF (JMAX.GT.1) GDIF(J1,1:3*NATOMS*(JMAX-1))=D2TMP(J1,1:3*NATOMS*(JMAX-1))
               IF (JMAX.LT.INTIMAGE+1) GDIF(J1,3*NATOMS*JMAX+1:3*NATOMS*(INTIMAGE+1))= &
  &                 D2TMP(J1,3*NATOMS*(JMAX-1)+1:3*NATOMS*INTIMAGE)
               GDIF(J1,3*NATOMS*(JMAX-1)+1:3*NATOMS*JMAX)= &
  &                       D2TMP(J1,3*NATOMS*(MIN(JMAX,INTIMAGE)-1)+1:3*NATOMS*MIN(JMAX,INTIMAGE))
            ENDDO
            DEALLOCATE(D2TMP)

            DEALLOCATE(TRUEEE,EEETMP,MYGTMP,GTMP,GGG, &
  &                    DIAG,STP,GLAST,XSAVE,EEE,STEPIMAGE,CHECKG,IMGFREEZE)
            ALLOCATE(TRUEEE(INTIMAGE+3), &
  &                  EEETMP(INTIMAGE+3), MYGTMP(3*NATOMS*(INTIMAGE+1)), &
  &                  GTMP(3*NATOMS*(INTIMAGE+1)), &
  &                  DIAG(3*NATOMS*(INTIMAGE+1)), STP(3*NATOMS*(INTIMAGE+1)), &
  &                  GLAST(NOPT*(INTIMAGE+1)), &
  &                  XSAVE(NOPT*(INTIMAGE+1)), CHECKG(NOPT*(INTIMAGE+1)), IMGFREEZE(INTIMAGE+1), &
  &                  EEE(INTIMAGE+3), STEPIMAGE(INTIMAGE+1), GGG(3*NATOMS*(INTIMAGE+3)))
            GGG(1:3*NATOMS*(INTIMAGE+3))=0.0D0
            TRUEEE(1:INTIMAGE+3)=0.0D0
            EEETMP(1:INTIMAGE+3)=0.0D0
            MYGTMP(1:3*NATOMS*(INTIMAGE+1))=0.0D0
            GTMP(1:3*NATOMS*(INTIMAGE+1))=0.0D0
            DIAG(1:3*NATOMS*(INTIMAGE+1))=0.0D0
            STP(1:3*NATOMS*(INTIMAGE+1))=0.0D0
            GLAST(1:NOPT*(INTIMAGE+1))=0.0D0
            XSAVE(1:NOPT*(INTIMAGE+1))=0.0D0
            CHECKG(1:NOPT*(INTIMAGE+1))=.FALSE.
            IMGFREEZE(1:INTIMAGE+1)=.FALSE.
            EEE(1:INTIMAGE+3)=0.0D0
            STEPIMAGE(1:INTIMAGE+1)=0.0D0

            X=>XYZ(NOPT+1:NOPT*(INTIMAGE+2))
            G=>GGG(NOPT+1:NOPT*(INTIMAGE+2))
            INTIMAGE=INTIMAGE+1
            D=NOPT*INTIMAGE
            CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
            IF (CHECKCONINT) THEN
               CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ELSE
               CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ENDIF
!           GOTO 864
         ELSEIF ((DMIN.LT.IMSEPMIN).AND.(INTIMAGE.GT.1)) THEN
            IF (JMIN.EQ.1) JMIN=2
!           PRINT '(A,I6,A,I6)',' intlbfgs> Remove image ',JMIN
            ALLOCATE(DPTMP(3*NATOMS*(INTIMAGE+2)))
            DPTMP(1:3*NATOMS*(INTIMAGE+2))=XYZ(1:3*NATOMS*(INTIMAGE+2))
            DEALLOCATE(XYZ)
            ALLOCATE(XYZ(3*NATOMS*(INTIMAGE+1)))
            XYZ(1:3*NATOMS*(JMIN-1))=DPTMP(1:3*NATOMS*(JMIN-1))
            XYZ(3*NATOMS*(JMIN-1)+1:3*NATOMS*(INTIMAGE+1))=DPTMP(3*NATOMS*JMIN+1:3*NATOMS*(INTIMAGE+2))

            DEALLOCATE(DPTMP)
!
! Save step-taking memories in SEARCHSTEP and GDIF.
! These arrays run from 0 to INTMUPDATE over memories and
! 1:NOPT*INTIMAGE over only the variable images.
!
            ALLOCATE(D2TMP(0:INTMUPDATE,1:NOPT*INTIMAGE))
            D2TMP(0:INTMUPDATE,1:NOPT*INTIMAGE)=SEARCHSTEP(0:INTMUPDATE,1:NOPT*INTIMAGE)
            DEALLOCATE(SEARCHSTEP)
            ALLOCATE(SEARCHSTEP(0:INTMUPDATE,1:NOPT*(INTIMAGE-1)))
            DO J1=0,INTMUPDATE
               SEARCHSTEP(J1,1:3*NATOMS*(JMIN-2))=D2TMP(J1,1:3*NATOMS*(JMIN-2))
               SEARCHSTEP(J1,3*NATOMS*(JMIN-2)+1:3*NATOMS*(INTIMAGE-1))= &
  &                     D2TMP(J1,3*NATOMS*(JMIN-1)+1:3*NATOMS*INTIMAGE)
            ENDDO
            D2TMP(0:INTMUPDATE,1:NOPT*INTIMAGE)=GDIF(0:INTMUPDATE,1:NOPT*INTIMAGE)
            DEALLOCATE(GDIF)
            ALLOCATE(GDIF(0:INTMUPDATE,1:NOPT*(INTIMAGE-1)))
            DO J1=0,INTMUPDATE
               GDIF(J1,1:3*NATOMS*(JMIN-2))=D2TMP(J1,1:3*NATOMS*(JMIN-2))
               GDIF(J1,3*NATOMS*(JMIN-2)+1:3*NATOMS*(INTIMAGE-1))= &
  &                     D2TMP(J1,3*NATOMS*(JMIN-1)+1:3*NATOMS*INTIMAGE)
            ENDDO
            DEALLOCATE(D2TMP)

            DEALLOCATE(TRUEEE,EEETMP,MYGTMP,GTMP,GGG, &
  &                    DIAG,STP,GLAST,XSAVE,EEE,STEPIMAGE,CHECKG,IMGFREEZE)
            ALLOCATE(TRUEEE(INTIMAGE+1),&
  &                  EEETMP(INTIMAGE+1), MYGTMP(3*NATOMS*(INTIMAGE-1)), &
  &                  GTMP(3*NATOMS*(INTIMAGE-1)), &
  &                  DIAG(3*NATOMS*(INTIMAGE-1)), STP(3*NATOMS*(INTIMAGE-1)), &
  &                  GLAST(NOPT*(INTIMAGE-1)), &
  &                  XSAVE(NOPT*(INTIMAGE-1)), CHECKG(NOPT*(INTIMAGE-1)), IMGFREEZE(INTIMAGE-1), &
  &                  EEE(INTIMAGE+1), STEPIMAGE(INTIMAGE-1), GGG(3*NATOMS*(INTIMAGE+1)))
            GGG(1:3*NATOMS*(INTIMAGE+1))=0.0D0
            TRUEEE(1:INTIMAGE+1)=0.0D0
            EEETMP(1:INTIMAGE+1)=0.0D0
            MYGTMP(1:3*NATOMS*(INTIMAGE-1))=0.0D0
            GTMP(1:3*NATOMS*(INTIMAGE-1))=0.0D0
            DIAG(1:3*NATOMS*(INTIMAGE-1))=0.0D0
            STP(1:3*NATOMS*(INTIMAGE-1))=0.0D0
            GLAST(1:NOPT*(INTIMAGE-1))=0.0D0
            XSAVE(1:NOPT*(INTIMAGE-1))=0.0D0
            CHECKG(1:NOPT*(INTIMAGE-1))=.FALSE.
            IMGFREEZE(1:INTIMAGE-1)=.FALSE.
            EEE(1:INTIMAGE+1)=0.0D0
            STEPIMAGE(1:INTIMAGE-1)=0.0D0

            X=>XYZ(NOPT+1:NOPT*(INTIMAGE))
            G=>GGG(NOPT+1:NOPT*(INTIMAGE))
            INTIMAGE=INTIMAGE-1
            D=NOPT*INTIMAGE
            CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
            IF (CHECKCONINT) THEN
               CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ELSE
               CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ENDIF
!           GOTO 864
         ENDIF
      ENDIF
   ENDIF
!
! End of add/subtract images block.
!
   IF (.NOT.SWITCHED) THEN
      IF (MOD(NITERDONE,CHECKREPINTERVAL).EQ.0) CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
      IF (CHECKCONINT) THEN
         CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
      ELSE
         CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
      ENDIF
      IF ((ETOTAL-EOLD.LT.1.0D100).OR.ADDATOM) THEN ! MAXERISE effectively set to 1.0D100 here
         EOLD=ETOTAL
         GLAST(1:D)=G(1:D)
         XSAVE(1:D)=X(1:D)
      ELSE
         NDECREASE=NDECREASE+1
         IF (NDECREASE.GT.5) THEN
            NFAIL=NFAIL+1
            WRITE(*,'(A,I6)') ' intlbfgs> WARNING *** in lbfgs cannot find a lower energy, NFAIL=',NFAIL
            X(1:D)=XSAVE(1:D)
            G(1:D)=GLAST(1:D)
         ELSE
            X(1:D)=XSAVE(1:D)
            G(1:D)=GLAST(1:D)
            STP(1:D)=STP(1:D)/10.0D0
            WRITE(*,'(A,G25.15,A,G25.15,A)') ' intlbfgs> energy increased from ',EOLD,' to ',ETOTAL, &
     &          ' decreasing step size'
            GOTO 20
         ENDIF
      ENDIF
      ADDATOM=.FALSE.
   ELSE ! combine constraint and true potentials
!     IF ((RMS.LT.INTRMSTOL*1.0D10).AND.(MOD(NITERDONE,10).EQ.0).AND.(NSTEPSMAX-NITERDONE.GT.100)) &
! &               CALL CHECKSEP(NMAXINT,NMININT,INTIMAGE,XYZ,NOPT)

!!!
!
! Check that MAKE_CONPOT produces the same constraints and repulsions - this is to debug MAKE_CONPOT
!
!     MINCOORDS(1,1:NOPT)=XYZ(1:NOPT)
!     MINCOORDS(2,1:NOPT)=XYZ(NOPT*(INTIMAGE+1)+1:NOPT*(INTIMAGE+2))
!     PRINT '(A)',' intlbfgs> Before make_conpot'
!     CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
!     DO J2=1,NCONSTRAINT
!        PRINT '(A,I6,L5,2I6,2F20.10)','J2,CONACTIVE,CONI,CONJ,CONDISTREF,CONDISTREFLOCAL=', &
! &                      J2,CONACTIVE(J2),CONI(J2),CONJ(J2),CONDISTREF(J2),CONDISTREFLOCAL(J2)
!     ENDDO
!     DO J2=1,NREPULSIVE
!        PRINT '(A,3I6,F20.10)','J2,REPI,REPJ,REPCUT=',J2,REPI(J2),REPJ(J2),REPCUT(J2)
!     ENDDO
!     DO J2=1,NNREPULSIVE
!        PRINT '(A,3I6,F20.10)','J2,NREPI,NREPJ,NREPCUT=',J2,NREPI(J2),NREPJ(J2),NREPCUT(J2)
!     ENDDO
!     PRINT '(A)',' intlbfgs> Calling make_conpot'
!     CALL MAKE_CONPOT(2,MINCOORDS)
!     CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
!     DO J2=1,NCONSTRAINT
!        PRINT '(A,I6,L5,2I6,2F20.10)','J2,CONACTIVE,CONI,CONJ,CONDISTREF,CONDISTREFLOCAL=', &
! &                      J2,CONACTIVE(J2),CONI(J2),CONJ(J2),CONDISTREF(J2),CONDISTREFLOCAL(J2)
!     ENDDO
!     DO J2=1,NREPULSIVE
!        PRINT '(A,3I6,F20.10)','J2,REPI,REPJ,REPCUT=',J2,REPI(J2),REPJ(J2),REPCUT(J2)
!     ENDDO
!     DO J2=1,NNREPULSIVE
!        PRINT '(A,3I6,F20.10)','J2,NREPI,NREPJ,NREPCUT=',J2,NREPI(J2),NREPJ(J2),NREPCUT(J2)
!     ENDDO
!     STOP
!!! DJW
      IF (MOD(NITERDONE,CHECKREPINTERVAL).EQ.0) CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
      ETOTALTMP=0.0D0
      DO J4=2,INTIMAGE+1
         IF (CHRMMT) CALL UPDATENBONDS(XYZ(NOPT*(J4-1)+1:NOPT*J4))
         CALL POTENTIAL(XYZ(NOPT*(J4-1)+1:NOPT*J4),EEE(J4),GGG(NOPT*(J4-1)+1:NOPT*J4),.TRUE.,.FALSE.,RMS,.FALSE.,.FALSE.)
         ETOTALTMP=ETOTALTMP+EEE(J4)
      ENDDO
      RMSTMP=RMS
      EEETMP(1:INTIMAGE+2)=EEE(1:INTIMAGE+2)
      MYGTMP(1:D)=G(1:D)
      IF (USEFRAC.LT.1.0D0) THEN
         IF (CHECKCONINT) THEN
            CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
         ELSE
            CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
         ENDIF
      ELSE
         ETOTAL=0.0D0
         G(1:D)=0.0D0
      ENDIF
      ETOTAL=USEFRAC*ETOTALTMP+(1.0D0-USEFRAC)*ETOTAL
      RMS=USEFRAC*RMSTMP+(1.0D0-USEFRAC)*RMS
      G(1:D)=USEFRAC*MYGTMP(1:D)+(1.0D0-USEFRAC)*G(1:D)
      EEE(1:INTIMAGE+2)=USEFRAC*EEETMP(1:INTIMAGE+2)+(1.0D0-USEFRAC)*EEE(1:INTIMAGE+2)
!     USEFRAC=USEFRAC+INTCONFRAC
!     IF (USEFRAC.GE.1.0D0) PRINT '(A,I6)',' intlbfgs> switching off constraint potential completely at step ',NITERDONE
   ENDIF
   IF (ETOTAL/INTIMAGE.LT.COLDFUSIONLIMIT) THEN
      WRITE(*,'(A,2G20.10)') ' intlbfgs> Cold fusion diagnosed - step discarded, energy, limit=',ETOTAL/INTIMAGE,COLDFUSIONLIMIT
      DEALLOCATE(CONI,CONJ,CONDISTREF,REPI,REPJ,NREPI,NREPJ,REPCUT,NREPCUT,CONCUT)
      DEALLOCATE(TRUEEE, EEETMP, MYGTMP, GTMP, &
  &              DIAG, STP, SEARCHSTEP, GDIF,GLAST, XSAVE, XYZ, GGG, CHECKG, IMGFREEZE, EEE, STEPIMAGE)
      INTIMAGE=INTIMAGESAVE
      LTSFOUND=0
      LMINFOUND=0
      RETURN
   ENDIF

   STEPTOT = SUM(STEPIMAGE)/INTIMAGE

   IF (DEBUG) THEN
      WRITE(*,'(A,I6,2G20.10,G20.10,I8)') ' intlbfgs> steps: ',NITERDONE,ETOTAL/INTIMAGE,RMS,STEPTOT,NACTIVE
      CALL FLUSH(6,ISTAT)
   ENDIF

   IF (.NOT.SWITCHED) THEN
      IF ((NITERDONE-NLASTGOODE.GT.INTRELSTEPS).AND.((ETOTAL.GT.LASTGOODE).OR.(ETOTAL/INTIMAGE.GT.MAXCONE*1.0D8))) THEN
         PRINT '(2(A,I6))',' intlbfgs> Backtracking ',NBACKTRACK,' steps, current active atoms=',NACTIVE
         NTRIES(NEWATOM)=NTRIES(NEWATOM)+1
         IF (FREEZENODEST) IMGFREEZE(1:INTIMAGE)=.FALSE.
!
! Backtrack by removing the last NBACKTRACK atoms along with their active constraints and
! repulsions.
!
         NOFF=0
         DO J1=1,NBACKTRACK
            NDUMMY=TURNONORDER(NACTIVE-J1+1)
            IF (INTFROZEN(NDUMMY)) THEN
               IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Not turning off frozen active atom ',NDUMMY
               CYCLE
            ENDIF
            IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning off active atom ',NDUMMY
            DO J2=1,NCONSTRAINT
               IF (.NOT.CONACTIVE(J2)) CYCLE 
               IF ((CONI(J2).EQ.NDUMMY).OR.(CONJ(J2).EQ.NDUMMY)) THEN
                  CONACTIVE(J2)=.FALSE.
                  IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning off constraint ',J2,' for atoms ',CONI(J2),CONJ(J2)
               ENDIF
            ENDDO
            ATOMACTIVE(NDUMMY)=.FALSE.
            NOFF=NOFF+1
         ENDDO
         NACTIVE=NACTIVE-NOFF
!
! Reconstruct repulsions. 
!
!          NREPULSIVE=0
!          DO J1=1,NATOMS
!             IF (.NOT.ATOMACTIVE(J1)) CYCLE ! identify active atoms
!             DO J2=J1+1,NATOMS
!                IF (.NOT.ATOMACTIVE(J2)) CYCLE ! identify active atoms
!                IF (ABS(J1-J2).LE.INTREPSEP) CYCLE ! no repulsion for atoms too close in sequence
!                IF (INTFROZEN(J1).AND.INTFROZEN(J2)) CYCLE 
!                DO J3=1,NCONSTRAINT
!                   IF (.NOT.CONACTIVE(J3)) CYCLE ! identify active constraints 
!                   IF (((CONI(J3).EQ.J1).AND.(CONJ(J3).EQ.J2)).OR. &
!   &                   ((CONJ(J3).EQ.J1).AND.(CONI(J3).EQ.J2))) GOTO 548
!                ENDDO
!                DMIN=1.0D100
!                DO J3=1,INTIMAGE+2,INTIMAGE+1 ! only consider the end-point distances
!                   DF=SQRT((XYZ((J3-1)*3*NATOMS+3*(J2-1)+1)-XYZ((J3-1)*3*NATOMS+3*(J1-1)+1))**2+ &
!   &                       (XYZ((J3-1)*3*NATOMS+3*(J2-1)+2)-XYZ((J3-1)*3*NATOMS+3*(J1-1)+2))**2+ &
!   &                       (XYZ((J3-1)*3*NATOMS+3*(J2-1)+3)-XYZ((J3-1)*3*NATOMS+3*(J1-1)+3))**2)
!                   IF (DF.LT.DMIN) DMIN=DF
!                ENDDO
! !
! ! Use the minimum of the end point distances and INTCONSTRAINREPCUT for each contact.
! !
!                DMIN=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
!                NREPULSIVE=NREPULSIVE+1
!                REPI(NREPULSIVE)=J1
!                REPJ(NREPULSIVE)=J2
!                REPCUT(NREPULSIVE)=DMIN
! 548            CONTINUE
!             ENDDO
!          ENDDO

           NDUMMY=1
           NREPULSIVE=0
           DO J1=1,NATOMS
! 
! Make a list of repelling atoms here and then use it
! CONI(J2) is always less than CONJ(J2) so we only need to
! cycle over a given range of constraints and continue from
! where we left off for the next atom j1
!  
              ADDREP(1:J1+INTREPSEP)=.FALSE.
              ADDREP(J1+INTREPSEP+1:NATOMS)=.TRUE. ! no repulsion for atoms too close in sequence
              IF (INTFROZEN(J1)) THEN
                 DO J2=J1+INTREPSEP+1,NATOMS
                    IF (INTFROZEN(J2)) ADDREP(J2)=.FALSE.
                 ENDDO
              ENDIF
              addloop: DO J2=NDUMMY,NCONSTRAINT
                 IF (CONI(J2).EQ.J1) THEN
                    ADDREP(CONJ(J2))=.FALSE.
                 ELSE
                    NDUMMY=J2 ! for next atom
                    EXIT addloop
                 ENDIF
              ENDDO addloop
              rep2: DO J2=J1+INTREPSEP+1,NATOMS

                 IF (.NOT.ADDREP(J2)) CYCLE

                 DMIN=1.0D100
                 DO J3=1,INTIMAGE+2,INTIMAGE+1 ! only consider the end-point distances
                    DF=SQRT((XYZ((J3-1)*3*NATOMS+3*(J2-1)+1)-XYZ((J3-1)*3*NATOMS+3*(J1-1)+1))**2+ &
    &                       (XYZ((J3-1)*3*NATOMS+3*(J2-1)+2)-XYZ((J3-1)*3*NATOMS+3*(J1-1)+2))**2+ &
    &                       (XYZ((J3-1)*3*NATOMS+3*(J2-1)+3)-XYZ((J3-1)*3*NATOMS+3*(J1-1)+3))**2)
                    IF (DF.LT.DMIN) DMIN=DF
                 ENDDO

                 NREPULSIVE=NREPULSIVE+1
                 IF (NREPULSIVE.GT.NREPMAX) CALL REPDOUBLE
                 REPI(NREPULSIVE)=J1
                 REPJ(NREPULSIVE)=J2
! 
! Use the minimum of the end point distances and INTCONSTRAINREPCUT for each contact.
!
                 REPCUT(NREPULSIVE)=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
   ENDDO rep2
ENDDO


!        NBACKTRACK=MAX(MIN(MIN(1.0D0*(NBACKTRACK+1),1.0D0*50),0.1D0*(NACTIVE-2-NQCIFREEZE)),1)
         NBACKTRACK=MAX(MIN(MIN(1.0D0*(NBACKTRACK+1),1.0D0*50),1.0D0*(NACTIVE-2-NQCIFREEZE)),1.0D0)
!        IF (DEBUG) PRINT '(A,I6)',' intlbfgs> Number of atoms to backtrack is now ',NBACKTRACK
         NDUMMY=0
         DO J1=1,NATOMS
            IF (ATOMACTIVE(J1)) NDUMMY=NDUMMY+1
         ENDDO
         IF (NDUMMY.NE.NACTIVE) THEN
            PRINT '(A,I6)',' intlbfgs> ERROR *** inconsistency in number of active atoms. ',NDUMMY,' should be ',NACTIVE
            DO J1=1,NATOMS
               IF (ATOMACTIVE(J1)) PRINT '(A,I6)',' active atom ',J1
            ENDDO
            STOP
         ENDIF
         ADDATOM=.TRUE.

         CALL CHECKREP(INTIMAGE,XYZ,NOPT,0,1)
         IF (CHECKCONINT) THEN
            CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
         ELSE
            CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
         ENDIF
      ENDIF
      LASTGOODE=ETOTAL
   ENDIF
   EXITSTATUS=0
   INTDGUESS=DIAG(1) ! should be ok for subsequent runs of the same system DJW
   IF ((RMS<=INTRMSTOL.AND.NITERDONE>1).AND.(.NOT.SWITCHED)) EXITSTATUS=1 ! prevents premature convergence in second phase
   IF (NITERDONE==NSTEPSMAX) EXITSTATUS=2

!    IF (.FALSE.) THEN
!       CHECKG(1:D)=.FALSE.
!       DO J1=1,D
!          IF (ABS(G(J1)).GT.1.0D-6) THEN
!             PRINT '(3I6,G20.10)',J1,2+(J1-1)/(3*NATOMS),(J1-3*NATOMS*((J1-1)/(3*NATOMS))-1)/3+1,G(J1)
!             CHECKG(J1)=.TRUE.
!          ENDIF
!      ENDDO
! !!!!!!!!!!!!!!!!!!!
! !     NDUMMY=NREPULSIVE
! !     NCONSTRAINT=0
! !     NREPULSIVE=0
! !!!!!!!!!!!!!!!!!!!
!       IF (CHECKCONINT) THEN
!          CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
!       ELSE
!          CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
!       ENDIF
!       GLAST(1:D)=G(1:D)
!       DIFF=1.0D-6
!       PRINT '(A,I6)',' intlbfgs> analytic and numerical gradients: D=',D
!       DO J2=1,D
!          IF (.NOT.CHECKG(J2)) CYCLE
!          X(J2)=X(J2)+DIFF
! !        PRINT '(A,I6)',' intlbfgs> calling congrad + for coordinate J2'
!          IF (CHECKCONINT) THEN
!             CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
!          ELSE
!             CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
!          ENDIF
!          EPLUS=ETOTAL
!          X(J2)=X(J2)-2.0D0*DIFF
! !        PRINT '(A,I6)',' intlbfgs> calling congrad - for coordinate J2'
!          IF (CHECKCONINT) THEN
!             CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
!          ELSE
!             CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
!          ENDIF
!          EMINUS=ETOTAL
!          X(J2)=X(J2)+DIFF
!          IF (ABS(GLAST(J2)).NE.0.0D0) THEN
!             IF (100.0D0*ABS((GLAST(J2)-(EPLUS-EMINUS)/(2.0D0*DIFF))/GLAST(J2)).GT.10.0D0) THEN
!                WRITE(*,'(A,3I8,3G20.10)') 'error ',(J2-1)/NOPT+1,(J2-NOPT*((J2-1)/NOPT)-1)/3+1,J2, &
!   &                                 GLAST(J2),(EPLUS-EMINUS)/(2.0D0*DIFF), &
!   &                                 (EPLUS-EMINUS)/(2.0D0*DIFF*GLAST(J2))
!             ELSE
!                WRITE(*,'(A,3I8,3G20.10)') 'OK    ',(J2-1)/NOPT+1,(J2-NOPT*((J2-1)/NOPT)-1)/3+1,J2, &
!   &                                       GLAST(J2),(EPLUS-EMINUS)/(2.0D0*DIFF), &
!   &                                       (EPLUS-EMINUS)/(2.0D0*DIFF*GLAST(J2))
!             ENDIF
!          ENDIF
!       ENDDO
!    ENDIF

   IF (EXITSTATUS > 0) THEN  
      IF ((.NOT.SWITCHED).AND.(EXITSTATUS.EQ.1)) THEN ! add active atom or restart with true potential on
         IF (ETOTAL/INTIMAGE.GT.MAXCONE) GOTO 777
         IF (NACTIVE.LT.NATOMS) THEN 
            ADDATOM=.TRUE.
            GOTO 777
         ENDIF
         CALL MYCPU_TIME(FTIME,.FALSE.)
         PRINT '(A,I6,A,F12.6,A,I6,A,F10.1)',' intlbfgs> switch on true potential at step ',NITERDONE, &
  &                                     ' fraction=',INTCONFRAC,' images=',INTIMAGE,' time=',FTIME-STIME
         PRINT '(A,I6,A,F15.6)',' intlbfgs> Allowing ',INTCONSTEPS,' further optimization steps'
         DO J1=1,NATOMS
            IF (.NOT.ATOMACTIVE(J1)) THEN
               PRINT '(A,I6,A,I6,A)',' intlbfgs> ERROR *** number of active atoms=',NACTIVE,' but atom ',J1,' is not active'
            ENDIF
         ENDDO
         NSTEPSMAX=NITERDONE+INTCONSTEPS
         SWITCHED=.TRUE.
         NIMAGEFREEZE=0
         RMS=INTRMSTOL*10.0D0 ! to prevent premature convergence
         G(1:NOPT*INTIMAGE)=INTRMSTOL*10.0D0
         USEFRAC=INTCONFRAC
         GOTO 777
      ELSEIF ((.NOT.SWITCHED).AND.(EXITSTATUS.EQ.2)) THEN 
         PRINT '(A,I6)',' intlbfgs> ERROR *** number of active atoms at final step=',NACTIVE
         LTSFOUND=0
         LMINFOUND=0
         CALL FLUSH(6,ISTAT)
         RETURN
      ELSEIF (DEBUG) THEN
         PRINT '(A,I6,A,I6)','intlbfgs> energies for images:'
         PRINT '(I6,F20.10)',(J2,EEE(J2),J2=1,INTIMAGE+2)
      ENDIF
      EXIT
   ENDIF
   777 CONTINUE
!
! Compute the new step and gradient change
!
   NPT=POINT*D
   SEARCHSTEP(POINT,:) = STP*SEARCHSTEP(POINT,:)
   GDIF(POINT,:)=G-GTMP
   POINT=POINT+1; IF (POINT==INTMUPDATE) POINT=0

   IF (DUMPINTXYZ.AND.MOD(NITERDONE,DUMPINTXYZFREQ)==0) CALL RWG(NITERDONE,INTIMAGE,XYZ)
   IF (DUMPINTEOS.AND.MOD(NITERDONE,DUMPINTEOSFREQ)==0) CALL WRITEPROFILE(NITERDONE,EEE,INTIMAGE)
   PREVGRAD=RMS

   NITERDONE=NITERDONE+1
   IF (NITERDONE.GT.NSTEPSMAX) EXIT
   IF ((NIMAGEFREEZE.EQ.INTIMAGE).AND.(NACTIVE.EQ.NATOMS)) THEN
      IF (SWITCHED) THEN
         EXIT
      ELSE
         CALL MYCPU_TIME(FTIME,.FALSE.)
         PRINT '(A,I6,A,F12.6,A,I6,A,F10.1)',' intlbfgs> switch on true potential at step ',NITERDONE, &
  &                                     ' fraction=',INTCONFRAC,' images=',INTIMAGE,' time=',FTIME-STIME
         PRINT '(A,I6,A,F15.6)',' intlbfgs> Allowing ',INTCONSTEPS,' further optimization steps'
         DO J1=1,NATOMS
            IF (.NOT.ATOMACTIVE(J1)) THEN
               PRINT '(A,I6,A,I6,A)',' intlbfgs> ERROR *** number of active atoms=',NACTIVE,' but atom ',J1,' is not active'
            ENDIF
         ENDDO
         NSTEPSMAX=NITERDONE+INTCONSTEPS
         SWITCHED=.TRUE.
         IF (FREEZENODEST) THEN
            IMGFREEZE(1:INTIMAGE)=.FALSE.
            NIMAGEFREEZE=0
         ENDIF
         RMS=INTRMSTOL*10.0D0 ! to prevent premature convergence
         USEFRAC=INTCONFRAC
      ENDIF
   ENDIF

ENDDO ! end of main do loop over counter NITERDONE

      CALL FLUSH(6,ISTAT)

IF (.NOT.SWITCHED) THEN 
   PRINT '(A,I6,A)',' intlbfgs> ERROR *** number of active atoms at final step=',NACTIVE,' no potential switch'
   STOP
ENDIF
IF (EXITSTATUS.EQ.1) THEN
   WRITE(*,'(A,I6,A,G20.10,A,G15.10,A,I4)') ' intlbfgs> Converged after ',NITERDONE,' steps, energy/image=',ETOTAL/INTIMAGE, &
  &                               ' RMS=',RMS,' images=',INTIMAGE
ELSEIF (EXITSTATUS.EQ.2) THEN
   WRITE(*,'(A,I6,A,G20.10,A,G15.10,A,I4)') ' intlbfgs> After ',NITERDONE,' steps, energy/image=',ETOTAL/INTIMAGE, &
  &                               ' RMS=',RMS,' images=',INTIMAGE
ENDIF
!
! Linear interpolation for constraint potential and real potential separately.
! Constraint potential need not be flat if we have done some steps with both
! potentials turned on.
!
678 CONTINUE
DINCREMENT=0.02D0
DTOTAL=0.0D0
OPEN(UNIT=753,FILE='intenergy',STATUS='UNKNOWN')
!
! local maxima must have NSIDE higher energies on each side
! This has the desirable side-effect that we don't bother with
! images that are essentially collapsed on each other - their
! spacing will probably be < DINCREMENT, or 5*DINCREMENT.
!
NSIDE=10
! EWINDOW(1:2*NSIDE+1)=-1.0D20
LTSFOUND=0
LMINFOUND=0
PRINTOPTIMIZETS=DEBUG
! IF (.FALSE.) THEN
! ALLOCATE(EWINDOW(2*NSIDE+1))
! DO J1=1,INTIMAGE+1
!    DUMMY=0.0D0
!    DO J2=1,3*NATOMS
!       DUMMY=DUMMY+( XYZ((J1-1)*3*NATOMS+J2) - XYZ(J1*3*NATOMS+J2) )**2
!    ENDDO
!    DUMMY=SQRT(DUMMY)
!    DIST=0.0D0
!    IF (DEBUG) PRINT '(A,I6,A,I6,A,G20.10)',' intlbfgs> distance between images ',J1,' and ',J1+1,' is ',DUMMY
!    NDUMMY=DUMMY/DINCREMENT+1
!    J3=1
! 
!    intloop: DO
!       LOCALCOORDS(1:3*NATOMS)=((DUMMY-DIST)*XYZ((J1-1)*3*NATOMS+1:J1*3*NATOMS)+ &
!   &                                    DIST*XYZ(J1*3*NATOMS+1:(J1+1)*3*NATOMS))/DUMMY
!       CALL POTENTIAL(LOCALCOORDS,EREAL,VNEW,.FALSE.,.FALSE.,RMS,.FALSE.,.FALSE.)
!       If (DEBUG) PRINT '(A,3G20.10)',' intlbfgs> ',DTOTAL+DIST,EREAL
!       WRITE(753,'(3G20.10)') DTOTAL+DIST,EREAL
!       DIST=DIST+DINCREMENT
!       DO J4=1,2*NSIDE
!          EWINDOW(J4)=EWINDOW(J4+1)
!       ENDDO
!       EWINDOW(2*NSIDE+1)=EREAL
!       IF ((J3.EQ.1).AND.(J1.EQ.1)) EWINDOW(1:2*NSIDE+1)=EREAL
!       IF (.FALSE.) THEN
!          DO J4=2,2*NSIDE
!             PRINT '(A,3I4,3G18.10)','J3,J4,NSIDE,EWINDOW(NSIDE+1),EWINDOW(J4),diff=', &
!   &                                  J3,J4,NSIDE,EWINDOW(NSIDE+1),EWINDOW(J4),EWINDOW(NSIDE+1)-EWINDOW(J4)
!             IF (J4.EQ.NSIDE+1) CYCLE
! !           IF (EWINDOW(NSIDE+1).LT.EWINDOW(J4)+EDIFFTOL) GOTO 432
!             IF (EWINDOW(NSIDE+1).LT.EWINDOW(J4)) GOTO 432
!          ENDDO
!          IF (EWINDOW(NSIDE+1).LT.EWINDOW(1)+EDIFFTOL) GOTO 432
!          IF (EWINDOW(NSIDE+1).LT.EWINDOW(2*NSIDE+1)+EDIFFTOL) GOTO 432
! !
! ! We have a ts candidate. Try optimising it!
! !
!          PRINT '(A,I8,A,F20.10)',' local maximum in QCI profile for NSIDE+1=',NSIDE+1,' dist=',DTOTAL+(J3-NSIDE-1)*DINCREMENT
!          CALL MYCPU_TIME(STARTTIME,.FALSE.)
!          KNOWG=.FALSE.
!          KNOWE=.FALSE. ! to be safe!
!          LOCALCOORDS(1:NOPT)= &
!   &              ((DUMMY-(J3-NSIDE-1)*DINCREMENT)*XYZ((J1-1)*NOPT+1:J1*NOPT)+ &
!   &                      (J3-NSIDE-1)*DINCREMENT *XYZ(J1*NOPT+1:(J1+1)*NOPT))/DUMMY
! 
!          IF (BFGSTST) THEN
!             VECS(1:NOPT)=(XYZ((J1-1)*NOPT+1:J1*NOPT)-XYZ(J1*NOPT+1:(J1+1)*NOPT))/DUMMY
!             CALL BFGSTS(NSTEPS,LOCALCOORDS,  &
!   &            EDUMMY,LGDUMMY,TSCONVERGED,RMS,EVALMIN,EVALMAX,VECS,ITDONE,.TRUE.,PRINTOPTIMIZETS)
!          ELSE
!             CALL EFOL(LOCALCOORDS,TSCONVERGED,NSTEPS,EDUMMY,ITDONE,EVALMIN,DEBUG,XDIAG,2)
!          ENDIF
!          CALL MYCPU_TIME(TIME0,.FALSE.)
!          IF (TSCONVERGED) THEN
!             LTSFOUND=LTSFOUND+1
! !
! ! Save coordinates and direction vector between images to use as starting guess
! ! for the eigenvector.
! !
!             ALLOCATE(MYTSFOUND(LTSFOUND)%E,MYTSFOUND(LTSFOUND)%COORD(NOPT), &
!   &                  MYTSFOUND(LTSFOUND)%EVALMIN,MYTSFOUND(LTSFOUND)%VECS(NOPT))
!             MYTSFOUND(LTSFOUND)%VECS(1:NOPT)=VECS(1:NOPT)
!             MYTSFOUND(LTSFOUND)%COORD(1:NOPT)=LOCALCOORDS(1:NOPT)
!             MYTSFOUND(LTSFOUND)%E=EDUMMY
!             MYTSFOUND(LTSFOUND)%EVALMIN=EVALMIN
!             PRINT '(A,I6,A,G20.10,A,F10.1)',' intlbfgs> transition state found, iterations=',ITDONE, &
!   &                               ' energy=',EDUMMY,' time=',TIME0-STARTTIME
!          ELSE
!             PRINT '(A,I6,A,G20.10,A,F10.1)',' intlbfgs> transition state search failed in ',ITDONE, &
!   &                               ' iterations energy=',EDUMMY,' time=',TIME0-STARTTIME
!          ENDIF
! 432      CONTINUE
!       ENDIF
!       J3=J3+1
!       IF (DIST.GT.DUMMY) EXIT INTLOOP
!       IF (J3.GT.NDUMMY) THEN
!          PRINT '(A,I6)',' intlbfgs> ERROR *** number of interpolated energies should not be ',J3
!       ENDIF
!    ENDDO intloop
!    DTOTAL=DTOTAL+DUMMY
! ENDDO
! DEALLOCATE(EWINDOW)
! ENDIF

WHOLEDNEB=.TRUE.

IF (WHOLEDNEB) THEN
   PRINT '(A,I6,2(A,G20.10))',' intlbfgs> First  minimum number ',MIN1ID
   PRINT '(A,I6,2(A,G20.10))',' intlbfgs> Second minimum number ',MIN2ID
!
! Run DNEB.
!
   STARTID=MIN1ID
   FINISHID=MIN2ID
   M1=MAX(STARTID,FINISHID)
   M2=MIN(STARTID,FINISHID)
!
!  Work out total distance along int path
!
   DTOTAL=0.0D0
   DO J1=1,INTIMAGE+1
      DUMMY=0.0D0
      DO J2=1,3*NATOMS
         DUMMY=DUMMY+( XYZ((J1-1)*3*NATOMS+J2) - XYZ(J1*3*NATOMS+J2) )**2
      ENDDO
      DUMMY=SQRT(DUMMY)
      DTOTAL=DTOTAL+DUMMY
   ENDDO
   IF (DEBUG) PRINT '(A,G20.10)',' intlbfgs> Total interpolated distance between end points is  ',DUMMY

   NIMAGE=DTOTAL*(IMAGEDENSITY+IMAGEINCR*MI(M1)%DATA%NTRIES(M2))

   IF (NIMAGE >= IMAGEMAX) NIMAGE=IMAGEMAX
   IF (NIMAGE >= IMAGEMAX) MI(MAX(STARTID,FINISHID))%DATA%NTRIES(MIN(STARTID,FINISHID))=NTRIESMAX
   IF (NIMAGE < 2 ) NIMAGE=2
12 NITERMAX=NIMAGE*ITERDENSITY 
!  PRINT '(A,I8,G20.10,2F12.2,I8)',' NIMAGE,dist,IMAGEDENSITY,IMAGEINCR,NATTEMPTS=', &
! &    NIMAGE,DTOTAL-DISTPREV,IMAGEDENSITY,IMAGEINCR,MI(M1)%DATA%NTRIES(M2)

   DISTPREV=0.0D0
   DINCREMENT=DTOTAL/(10.0D0*NIMAGE)
   CALL MAKEINTNEBIMAGES(NIMAGE,INTIMAGE,DINCREMENT,DISTPREV,DTOTAL,XYZ)
!  CALL MAKEINTNEBIMAGES2(NIMAGE,INTIMAGE,DINCREMENT,DISTPREV,DTOTAL,XYZ)
   PRINT '(A,2I6,A,G12.4,A,3I6)',' intlbfgs> DNEB for minima ',STARTID,FINISHID,' dist=', &
  &            DTOTAL,' Attempts, images and iterations=', &
  &                       MI(M1)%DATA%NTRIES(M2), NIMAGE, NITERMAX
   MI(M1)%DATA%NTRIES(M2)=MI(M1)%DATA%NTRIES(M2)+1
   TSRESET=.TRUE.
   CMIN1(1:3*NATOMS)=QSTART(1:3*NATOMS)
   LOCALCOORDS(1:3*NATOMS)=QFINISH(1:3*NATOMS)
   CALL POTENTIAL(QSTART,EINITIAL,VNEW,.FALSE.,.FALSE.,RMS,.FALSE.,.FALSE.)
   CALL POTENTIAL(QFINISH,EFINAL,VNEW,.FALSE.,.FALSE.,RMS,.FALSE.,.FALSE.)
   CALL NEWNEB(.FALSE.,DUMMY2,EINITIAL,CMIN1,EFINAL,LOCALCOORDS,TSRESET)
!
! If the DNEB profile had no maximum then
! allow a retry with more images and iterations.
!
! Should not be necessary!
!
!  IF (NONEBMAX.AND.(NIMAGE.LT.IMAGEMAX)) THEN 
!     NIMAGE=2*NIMAGE+1
!     IF (NIMAGE >= IMAGEMAX) NIMAGE=IMAGEMAX
!     IF (NIMAGE >= IMAGEMAX) MI(MAX(STARTID,FINISHID))%DATA%NTRIES(MIN(STARTID,FINISHID))=NTRIESMAX
!     CALL FLUSH(6,ISTAT)
!     GOTO 12
!  ENDIF
   LTSFOUND=NTSFOUND
   DEALLOCATE(INTNEBIMAGES)
   CLOSE(753)
ELSE
!
! Run DNEB for connections between local minima when changes are detected.
!
   LOCALCOORDS(1:3*NATOMS)=XYZ((INTIMAGE+1)*3*NATOMS+1:(INTIMAGE+2)*3*NATOMS)
   IF (CHRMMT) CALL UPDATENBONDS(LOCALCOORDS)
   CALL POTENTIAL(LOCALCOORDS,EREAL,VNEW,.FALSE.,.FALSE.,RMS,.FALSE.,.FALSE.)
   IF (DEBUG) PRINT '(A,3G20.10)',' intlbfgs> ',DTOTAL,EREAL
   WRITE(753,'(3G20.10)') DTOTAL,EREAL
   CLOSE(753)
!
! local minima must have NSIDE higher energies on each side.
!
   DTOTAL=0.0D0
   NSIDE=10
   ALLOCATE(EWINDOW(2*NSIDE+1))
   LMINFOUND=0
   LTSFOUND=0
   PRINTOPTIMIZEMIN=DEBUG
   PTEST=.FALSE.
   INTMAXT=.FALSE.
   INTMAXE=-1.0D100
   INTMAXDIST=0.0D0
   INTMAXCOORDS(1:3*NATOMS)=0.0D0
   OPEN(UNIT=753,FILE='intenergy',STATUS='UNKNOWN')
   CMIN1(1:3*NATOMS)=0.0D0
   DO J1=1,INTIMAGE+1
      DUMMY=0.0D0
      DO J2=1,3*NATOMS
         DUMMY=DUMMY+( XYZ((J1-1)*3*NATOMS+J2) - XYZ(J1*3*NATOMS+J2) )**2
      ENDDO
      DUMMY=SQRT(DUMMY)
      DIST=0.0D0
      IF (DEBUG) PRINT '(A,I6,A,I6,A,G20.10)',' intlbfgs> distance between images ',J1,' and ',J1+1,' is ',DUMMY
!     PRINT '(2(A,I6))',' intlbfgs> Now doing image ',J1,' to ',J1+1
      NDUMMY=DUMMY/DINCREMENT+1
      J3=1
      intloop2: DO
         LOCALCOORDS(1:3*NATOMS)=((DUMMY-DIST)*XYZ((J1-1)*3*NATOMS+1:J1*3*NATOMS)+ &
  &                                    DIST*XYZ(J1*3*NATOMS+1:(J1+1)*3*NATOMS))/DUMMY
         IF (CHRMMT) CALL UPDATENBONDS(LOCALCOORDS)
         CALL POTENTIAL(LOCALCOORDS,EREAL,VNEW,.FALSE.,.FALSE.,RMS,.FALSE.,.FALSE.)
         WRITE(753,'(3G20.10)') DTOTAL+DIST,EREAL
!
! Save energy and coordinates of starting image.
!
         IF ((J3.EQ.1).AND.(J1.EQ.1)) THEN
            EMINPREV=EREAL
            CMIN1(1:3*NATOMS)=LOCALCOORDS(1:3*NATOMS)
            STARTID=MIN1ID
            DISTPREV=0.0D0
            PRINT '(A)',' '
            PRINT '(2(A,G20.10))',' intlbfgs> Start  minimum energy=',EMINPREV,' distance=',DISTPREV
         ENDIF
         IF (DEBUG) PRINT '(A,3G20.10)',' intlbfgs> ',DTOTAL+DIST,EREAL
         DIST=DIST+DINCREMENT
         DO J4=1,2*NSIDE
            EWINDOW(J4)=EWINDOW(J4+1)
         ENDDO
         EWINDOW(2*NSIDE+1)=EREAL
         IF ((J3.EQ.1).AND.(J1.EQ.1)) EWINDOW(1:2*NSIDE+1)=EREAL
!
! Look for local maximum
!
         DO J4=2,2*NSIDE
!        PRINT '(A,3I4,3G18.10)','J3,J4,NSIDE,EWINDOW(NSIDE+1),EWINDOW(J4),diff=', &
! &                                  J3,J4,NSIDE,EWINDOW(NSIDE+1),EWINDOW(J4),EWINDOW(NSIDE+1)-EWINDOW(J4)
         IF (J4.EQ.NSIDE+1) CYCLE
!        IF (EWINDOW(NSIDE+1).LT.EWINDOW(J4)+EDIFFTOL) GOTO 423
            IF (EWINDOW(NSIDE+1).LT.EWINDOW(J4)) GOTO 423
         ENDDO
         IF (EWINDOW(NSIDE+1).LT.EWINDOW(1)+EDIFFTOL) GOTO 423
         IF (EWINDOW(NSIDE+1).LT.EWINDOW(2*NSIDE+1)+EDIFFTOL) GOTO 423
         IF (DEBUG) PRINT '(A,I8,2(A,F20.10))',' local maximum in QCI profile for NSIDE+1=',NSIDE+1,' energy=', &
  &                               EWINDOW(NSIDE+1),' dist=',DTOTAL+(J3-NSIDE-1)*DINCREMENT
!
! Update coordinates of highest maximum since last reset.
!
         IF ((.NOT.INTMAXT).OR.(EWINDOW(NSIDE+1).GT.INTMAXE)) THEN
            INTMAXT=.TRUE.
            INTMAXE=EWINDOW(NSIDE+1)
            INTMAXDIST=DTOTAL+(J3-NSIDE-1)*DINCREMENT
            INTMAXCOORDS(1:3*NATOMS)=&
  &           ((DUMMY-(J3-NSIDE-1)*DINCREMENT)*XYZ((J1-1)*NOPT+1:J1*NOPT)+ &
  &                   (J3-NSIDE-1)*DINCREMENT *XYZ(J1*NOPT+1:(J1+1)*NOPT))/DUMMY
         ENDIF
423      CONTINUE

         DO J4=2,2*NSIDE
!        PRINT '(A,3I4,3G18.10)','J3,J4,NSIDE,EWINDOW(NSIDE+1),EWINDOW(J4),diff=', &
! &                                  J3,J4,NSIDE,EWINDOW(NSIDE+1),EWINDOW(J4),EWINDOW(NSIDE+1)-EWINDOW(J4)
            IF (J4.EQ.NSIDE+1) CYCLE
!        IF (EWINDOW(J4).LT.EWINDOW(NSIDE+1)+EDIFFTOL) GOTO 431
            IF (EWINDOW(J4).LT.EWINDOW(NSIDE+1)) GOTO 431
         ENDDO
         IF (EWINDOW(1).LT.EWINDOW(NSIDE+1)+EDIFFTOL) GOTO 431
         IF (EWINDOW(2*NSIDE+1).LT.EWINDOW(NSIDE+1)+EDIFFTOL) GOTO 431
!
! We have a min candidate. Try optimising it!
!
         IF (DEBUG) PRINT '(A,I8,A,F20.10)',' local minimum in QCI profile for NSIDE+1=',NSIDE+1,' dist=', &
  &                    DTOTAL+(J3-NSIDE-1)*DINCREMENT
         CALL MYCPU_TIME(STARTTIME,.FALSE.)
         KNOWG=.FALSE.
         KNOWE=.FALSE. ! to be safe!
         LOCALCOORDS(1:NOPT)= &
  &           ((DUMMY-(J3-NSIDE-1)*DINCREMENT)*XYZ((J1-1)*NOPT+1:J1*NOPT)+ &
  &                   (J3-NSIDE-1)*DINCREMENT *XYZ(J1*NOPT+1:(J1+1)*NOPT))/DUMMY

         CALL MYLBFGS(NOPT,MUPDATE,LOCALCOORDS,.FALSE., &
  &               MFLAG,EDUMMY,RMS2,EREAL,RMS,BFGSSTEPS,.TRUE.,ITDONE,PTEST,VNEW,.TRUE.,.FALSE.)

         ALLOCATE(MINFOUND(NMIN+1)%E,MINFOUND(NMIN+1)%COORD(NOPT))
         MINFOUND(NMIN+1)%COORD(1:NOPT)=LOCALCOORDS(1:NOPT)
         MINFOUND(NMIN+1)%E=EDUMMY
      
         CALL MYCPU_TIME(TIME0,.FALSE.)
         IF (MFLAG) THEN
            PRINT '(A,I6,A,G20.10,A,F10.1)',' intlbfgs> minimum found, iterations=',ITDONE, &
  &                            ' energy=',EDUMMY,' time=',TIME0-STARTTIME
!
!  This is the procedure to identify and add a new minimum.
!
            NULLIFY(PINTERPCOORDS,PENERGY)
            ALLOCATE(PINTERPCOORDS(NOPT),PENERGY)
            OPEN(UNIT=781,FILE='minscratch',STATUS='UNKNOWN')
            WRITE(781,*) EDUMMY,LOCALCOORDS(1:NOPT)
            REWIND(781)
            READ(781,*) PENERGY,PINTERPCOORDS
            CLOSE(781)
            CALL ISNEWMIN(PENERGY,PINTERPCOORDS,POSITION,MINNEW,REDOPATH,PERMUTE,INVERT,INDEX,IMATCH)

            IF (MINNEW) THEN
               CALL ADDNEWMIN(PENERGY,PINTERPCOORDS)
!              PRINT*, PINTERPCOORDS(:)
               WRITE(*,'(A,I7,A,G20.10)') ' intlbfgs> added new minimum ',NMIN,' energy=',PENERGY
            ELSE
               WRITE(*,'(A,I7)') ' tryconnect> found old minimum ',POSITION
               NULLIFY(PINTERPCOORDS,PENERGY)
               DEALLOCATE(MINFOUND(NMIN+1)%E,MINFOUND(NMIN+1)%COORD)
            ENDIF
            FINISHID=POSITION

            IF (STARTID.NE.FINISHID) THEN
               PRINT '(A)',' intlbfgs> Minimum has changed'
               PRINT '(A,I6,2(A,G20.10))',' intlbfgs> First  minimum number ',STARTID,' energy=',EMINPREV,' distance=',DISTPREV
               PRINT '(A,I6,2(A,G20.10))',' intlbfgs> Second minimum number ',FINISHID,' energy=',EDUMMY,' distance=', &
  &               DTOTAL+(J3-NSIDE-1)*DINCREMENT
               PRINT '(2(A,G20.10))',' intlbfgs> Highest maximum between minima energy=',INTMAXE, &
  &                                  ' distance=',INTMAXDIST
!
! Run DNEB.
!
               M1=MAX(STARTID,FINISHID)
               M2=MIN(STARTID,FINISHID)
               NIMAGE=(DTOTAL+(J3-NSIDE-1)*DINCREMENT-DISTPREV)*(IMAGEDENSITY+IMAGEINCR*MI(M1)%DATA%NTRIES(M2))

               IF (NIMAGE >= IMAGEMAX) NIMAGE=IMAGEMAX
               IF (NIMAGE >= IMAGEMAX) MI(MAX(STARTID,FINISHID))%DATA%NTRIES(MIN(STARTID,FINISHID))=NTRIESMAX
               IF (NIMAGE < 2 ) NIMAGE=2
               NITERMAX=NIMAGE*ITERDENSITY 
               PRINT '(A,I8,G20.10,2F12.2,I8)',' NIMAGE,dist,IMAGEDENSITY,IMAGEINCR,NATTEMPTS=', &
  &                NIMAGE,DTOTAL-DISTPREV,IMAGEDENSITY,IMAGEINCR,MI(M1)%DATA%NTRIES(M2)

!              CALL MINPERMDIST(CMIN1,LOCALCOORDS,NATOMS,DEBUG,PARAM1,PARAM2,PARAM3,BULKT,TWOD,D,DIST2, &
!  &                             RIGIDBODY,RMAT)
               CALL MAKEINTNEBIMAGES(NIMAGE,INTIMAGE,DINCREMENT,DISTPREV,DTOTAL+(J3-NSIDE-1)*DINCREMENT,XYZ)
               PRINT '(A,2I6,A,G12.4,A,3I6)',' intlbfgs> DNEB for minima ',STARTID,FINISHID,' dist=', &
  &                        DTOTAL+(J3-NSIDE-1)*DINCREMENT-DISTPREV,' Attempts, images and iterations=', &
  &                                   MI(M1)%DATA%NTRIES(M2), NIMAGE, NITERMAX
               MI(M1)%DATA%NTRIES(M2)=MI(M1)%DATA%NTRIES(M2)+1
               TSRESET=.FALSE.
               IF (LTSFOUND.EQ.0) TSRESET=.TRUE.
               CALL NEWNEB(.FALSE.,DUMMY2,EMINPREV,CMIN1,EDUMMY,LOCALCOORDS,TSRESET)
               LTSFOUND=NTSFOUND
!              PRINT '(A,I6)','NTSFOUND,LTSFOUND=',NTSFOUND,LTSFOUND
               DEALLOCATE(INTNEBIMAGES)

               EMINPREVPREV=EMINPREV
               DISTPREVPREV=DISTPREV
            ELSE
               PRINT '(A)',' intlbfgs> Minimum has not changed'
            ENDIF
            EMINPREV=EDUMMY
            DISTPREV=DTOTAL+(J3-NSIDE-1)*DINCREMENT
            CMIN1(1:3*NATOMS)=LOCALCOORDS(1:3*NATOMS)
            STARTID=FINISHID
         ELSE
            PRINT '(A,I6,A,G20.10,A,F10.1)',' intlbfgs> minimisation failed in ',ITDONE, &
  &                            ' iterations energy=',EDUMMY,' time=',TIME0-STARTTIME
         ENDIF
431      CONTINUE

         J3=J3+1
         IF (DIST.GT.DUMMY) EXIT intloop2
         IF (J3.GT.NDUMMY) THEN
            PRINT '(A,I6)',' intlbfgs> ERROR *** number of interpolated energies should not be ',J3
         ENDIF
      ENDDO intloop2
      DTOTAL=DTOTAL+DUMMY
   ENDDO
!
! Now check energy of the FINISH end minimum to see if there is another maximum
! we might have bracketed.
!
   LOCALCOORDS(1:3*NATOMS)=XYZ((INTIMAGE+1)*3*NATOMS+1:(INTIMAGE+2)*3*NATOMS)
   IF (CHRMMT) CALL UPDATENBONDS(LOCALCOORDS)
   CALL POTENTIAL(LOCALCOORDS,EDUMMY,VNEW,.FALSE.,.FALSE.,RMS,.FALSE.,.FALSE.)
   WRITE(753,'(3G20.10)') DTOTAL,EREAL
   CLOSE(753)
   FINISHID=MIN2ID

! IF (ABS(EDUMMY-EMINPREV).GT.EDIFFTOL) THEN
   IF (STARTID.NE.FINISHID) THEN
!
! Now run DNEB for the last two minima, including the end minimum.
!
      PRINT '(A,G20.10)',' intlbfgs> Now running final transition state search involving end point minimum'
      PRINT '(A,I6,2(A,G20.10))',' intlbfgs> First  minimum number ',STARTID,' energy=',EMINPREV,' distance=',DISTPREV
      PRINT '(A,I6,2(A,G20.10))',' intlbfgs> Second minimum number ',FINISHID,' energy=',EDUMMY,' distance=', &
  &               DTOTAL+(J3-NSIDE-1)*DINCREMENT

      M1=MAX(STARTID,FINISHID)
      M2=MIN(STARTID,FINISHID)
      NIMAGE=(DTOTAL-DISTPREV)*(IMAGEDENSITY+IMAGEINCR*MI(M1)%DATA%NTRIES(M2))

      IF (NIMAGE >= IMAGEMAX) NIMAGE=IMAGEMAX
      IF (NIMAGE >= IMAGEMAX) MI(M1)%DATA%NTRIES(M2)=NTRIESMAX
      IF (NIMAGE < 2 ) NIMAGE=2
      NITERMAX=NIMAGE*ITERDENSITY 

      PRINT '(A,I8,G20.10,2F12.2,I8)',' NIMAGE,dist,IMAGEDENSITY,IMAGEINCR,NATTEMPTS=', &
  &                 NIMAGE,DTOTAL-DISTPREV,IMAGEDENSITY,IMAGEINCR,MI(M1)%DATA%NTRIES(M2)

!  CALL MINPERMDIST(CMIN1,LOCALCOORDS,NATOMS,DEBUG,PARAM1,PARAM2,PARAM3,BULKT,TWOD,D,DIST2,RIGIDBODY,RMAT)
      CALL MAKEINTNEBIMAGES(NIMAGE,INTIMAGE,DINCREMENT,DISTPREV,DTOTAL,XYZ)
      PRINT '(A,2I6,A,G12.4,A,3I6)',' intlbfgs> DNEB run for minima ',STARTID,FINISHID,' dist=', &
  &       DTOTAL-DISTPREV,' Attempts, images and iterations=', &
  &          MI(M1)%DATA%NTRIES(M2), NIMAGE, NITERMAX

      MI(M1)%DATA%NTRIES(M2)=MI(M1)%DATA%NTRIES(M2)+1
      TSRESET=.FALSE.
      IF (LTSFOUND.EQ.0) TSRESET=.TRUE.
      CALL NEWNEB(.FALSE.,DUMMY2,EMINPREV,CMIN1,EDUMMY,LOCALCOORDS,TSRESET)
      DEALLOCATE(INTNEBIMAGES)
      LTSFOUND=NTSFOUND
!  PRINT '(A,I6)','NTSFOUND,LTSFOUND=',NTSFOUND,LTSFOUND
   ENDIF
   PRINT '(A,I6)',' intlbfgs> Total number of transition states located=',LTSFOUND
   DEALLOCATE(EWINDOW)
ENDIF

DEALLOCATE(CONI,CONJ,CONDISTREF,REPI,REPJ,NREPI,NREPJ,REPCUT,NREPCUT,CONCUT)
DEALLOCATE(TRUEEE, EEETMP, MYGTMP, GTMP, &
  &      DIAG, STP, SEARCHSTEP, GDIF,GLAST, XSAVE, XYZ, GGG, CHECKG, IMGFREEZE, EEE, STEPIMAGE)
INTIMAGE=INTIMAGESAVE

END SUBROUTINE INTLBFGS
!
! Possible redistribution of images for INTCONSTRAINT depending upon distances.
!
SUBROUTINE CHECKSEP(NMAXINT,NMININT,INTIMAGE,XYZ,NOPT,NATOMS)
IMPLICIT NONE
INTEGER NSEPMAX, NSEPMIN, J, NMININT, NMAXINT, INTIMAGE, NOPT, J1, J2, NATOMS
DOUBLE PRECISION SEPMAX, SEPMIN, XYZ(*), DUMMY

RETURN !!! DJW

IF ((NMININT.EQ.NMAXINT).OR.(NMININT.EQ.NMAXINT+1)) THEN
   PRINT '(A,2I6)',' checksep> skipping image redistribution for images ',NMININT,NMAXINT
   RETURN
ENDIF
IF ((NMININT.EQ.1).OR.(NMININT.EQ.INTIMAGE+2)) THEN
   PRINT '(A,I6)',' checksep> ERROR *** NMININT=',NMININT
ENDIF
IF ((NMAXINT.EQ.1).OR.(NMAXINT.EQ.INTIMAGE+2)) THEN
   PRINT '(A,I6)',' checksep> ERROR *** NMAXINT=',NMAXINT
ENDIF
! 
! DVEC(J) contains the distance between image J and image J+1
!
!      SEPMAX=-1.0D0
!      SEPMIN=1.0D100
!      DO J=1,INTIMAGE+1
!         IF (DVEC(J).GT.SEPMAX) THEN
!            SEPMAX=DVEC(J)
!            NSEPMAX=J
!         ENDIF
!      ENDDO
!      DO J=2,INTIMAGE+1
!         IF (DVEC(J-1)+DVEC(J).LT.SEPMIN) THEN
!            SEPMIN=DVEC(J-1)+DVEC(J)
!            NSEPMIN=J
!         ENDIF
!      ENDDO
!      PRINT '(A,F20.10,A,I6,A,I6)',' checksep> maximum image separation=',SEPMAX,' for images ',NSEPMAX,' and ',NSEPMAX+1
!      PRINT '(A,F20.10,A,I6)',' checksep> minimum sum of image separations=',SEPMIN,' for image ',NSEPMIN

!    IF (SEPMIN*2.0D0.LT.SEPMAX) THEN ! redistribute images

IF (.TRUE.) THEN ! redistribute images
   PRINT '(A,I6,A,2I6)',' checksep> removing image ',NMININT,' and adding one between images ',NMAXINT,NMAXINT+1
!  IF (NSEPMIN.LT.NSEPMAX) THEN
   IF (NMININT.LT.NMAXINT) THEN
!     DO J=NSEPMIN,NSEPMAX-1 ! move image J+1 to position J for images J=NSEPMIN+1 to NSEPMAX-1
      DO J=NMININT,NMAXINT-1 ! move image J+1 to position J for images J=NMININT+1 to NMAXINT-1
         XYZ(NOPT*(J-1)+1:NOPT*J)=XYZ(NOPT*J+1:NOPT*(J+1))
      ENDDO
!     XYZ(NOPT*(NSEPMAX-1)+1:NOPT*NSEPMAX)=(XYZ(NOPT*(NSEPMAX-1)+1:NOPT*NSEPMAX)+XYZ(NOPT*NSEPMAX+1:NOPT*(NSEPMAX+1)))/2.0D0
      XYZ(NOPT*(NMAXINT-1)+1:NOPT*NMAXINT)=(XYZ(NOPT*(NMAXINT-1)+1:NOPT*NMAXINT)+XYZ(NOPT*NMAXINT+1:NOPT*(NMAXINT+1)))/2.0D0
   ELSE
!     DO J=NSEPMIN,NSEPMAX+2,-1 ! move image J-1 to position J for images J=NSEPMIN-1 to NSEPMAX+1
      DO J=NMININT,NMAXINT+2,-1 ! move image J-1 to position J for images J=NMININT-1 to NMAXINT+1
         PRINT '(2(A,I6))',' putting image ',J-1,' in image ',J
         XYZ(NOPT*(J-1)+1:NOPT*J)=XYZ(NOPT*(J-2)+1:NOPT*(J-1))
      ENDDO
      XYZ(NOPT*NMAXINT+1:NOPT*(NMAXINT+1))=(XYZ(NOPT*NMAXINT+1:NOPT*(NMAXINT+1))+XYZ(NOPT*(NMAXINT-1)+1:NOPT*NMAXINT))/2.0D0
   ENDIF
ENDIF

END SUBROUTINE CHECKSEP
!
! Neighbour list for repulsions to reduce cost of constraint potential.
!
SUBROUTINE CHECKREP(INTIMAGE,XYZ,NOPT,NNSTART,NSTART)
USE KEY,ONLY : NREPI, NREPJ, NREPCUT, NNREPULSIVE, NREPULSIVE, REPI, REPJ, REPCUT, CHECKREPCUTOFF
USE COMMONS,ONLY : DEBUG
USE PORFUNCS
IMPLICIT NONE
INTEGER JJ, KK, NI1, NJ1, NI2, NJ2, INTIMAGE, NOPT, ISTAT, NI, NJ, NNSTART, NSTART
DOUBLE PRECISION LDIST, XYZ(NOPT*(INTIMAGE+2)),COMPARE
DOUBLE PRECISION R1AX,R1AY,R1AZ,R2AX,R2AY,R2AZ,R1BX,R1BY,R1BZ,R2BX,R2BY,R2BZ,DMIN
LOGICAL NOINT

NNREPULSIVE=NNSTART
DO JJ=NSTART,NREPULSIVE
   COMPARE=(CHECKREPCUTOFF*REPCUT(JJ))**2
   NI=REPI(JJ)
   NJ=REPJ(JJ)
   DO KK=1,INTIMAGE+2 ! first check for standard distances within threshold
      LDIST=(XYZ((KK-1)*NOPT+3*(NI-1)+1)-XYZ((KK-1)*NOPT+3*(NJ-1)+1))**2 &
  &        +(XYZ((KK-1)*NOPT+3*(NI-1)+2)-XYZ((KK-1)*NOPT+3*(NJ-1)+2))**2 &
  &        +(XYZ((KK-1)*NOPT+3*(NI-1)+3)-XYZ((KK-1)*NOPT+3*(NJ-1)+3))**2
      IF (LDIST.LT.COMPARE) THEN
         NNREPULSIVE=NNREPULSIVE+1
         NREPI(NNREPULSIVE)=NI
         NREPJ(NNREPULSIVE)=NJ
         NREPCUT(NNREPULSIVE)=REPCUT(JJ)
         GOTO 246
      ENDIF
   ENDDO 
   COMPARE=CHECKREPCUTOFF*REPCUT(JJ)
   DO KK=2,INTIMAGE+2 ! now check internal minima within threshold
      DMIN=1.0D10
      NI2=NOPT*(KK-2)+3*(NI-1)
      NI1=NOPT*(KK-1)+3*(NI-1)
      NJ2=NOPT*(KK-2)+3*(NJ-1)
      NJ1=NOPT*(KK-1)+3*(NJ-1)
      R1AX=XYZ(NI2+1); R1AY=XYZ(NI2+2); R1AZ=XYZ(NI2+3)
      R1BX=XYZ(NJ2+1); R1BY=XYZ(NJ2+2); R1BZ=XYZ(NJ2+3)
      R2AX=XYZ(NI1+1); R2AY=XYZ(NI1+2); R2AZ=XYZ(NI1+3)
      R2BX=XYZ(NJ1+1); R2BY=XYZ(NJ1+2); R2BZ=XYZ(NJ1+3)
      CALL INTMINONLY(R1AX,R1AY,R1AZ,R2AX,R2AY,R2AZ,R1BX,R1BY,R1BZ,R2BX,R2BY,R2BZ,DMIN,NOINT)

      IF (NOINT) CYCLE
      IF (DMIN.LT.COMPARE) THEN
         NNREPULSIVE=NNREPULSIVE+1
         NREPI(NNREPULSIVE)=NI
         NREPJ(NNREPULSIVE)=NJ
         NREPCUT(NNREPULSIVE)=REPCUT(JJ)
         GOTO 246
      ENDIF
   ENDDO 
246 CONTINUE
ENDDO
IF (DEBUG) PRINT '(A,2I8)',' checkrep> number of active repulsions and total=',NNREPULSIVE,NREPULSIVE

END SUBROUTINE CHECKREP

SUBROUTINE RWG(NITER,INTIMAGE,XYZ)
USE PORFUNCS
USE KEY,ONLY: FILTH,FILTHSTR,STOCKT,AMHT,SEQ,NUMGLY,STOCKAAT, RBAAT
USE COMMONS, ONLY: ZSYM, NRBSITES 
USE AMHGLOBALS, ONLY : NMRES
USE COMMONS, ONLY: NATOMS, NOPT
IMPLICIT NONE
CHARACTER(LEN=10) :: XYZFILE   = 'int.xyz   '
CHARACTER(LEN=12) :: RBXYZFILE = 'rbint.xyz   '
INTEGER,INTENT(IN) :: NITER
INTEGER :: J1,J2,GLY_COUNT,INTIMAGE
CHARACTER(LEN=80) :: FILENAME,FILENAME2,DUMMYS,DUMMYS2
DOUBLE PRECISION XYZ(NOPT*(INTIMAGE+2))

IF (FILTH.EQ.0) THEN
   FILENAME=XYZFILE
   IF (RBAAT) FILENAME2=RBXYZFILE
ELSE
   FILENAME=TRIM(XYZFILE)//'.'//TRIM(ADJUSTL(FILTHSTR))
   IF (RBAAT) FILENAME2=TRIM(RBXYZFILE)//'.'//TRIM(ADJUSTL(FILTHSTR))
ENDIF 

IF (NITER.GT.0) THEN
   IF (FILTH.EQ.0) THEN
      WRITE(DUMMYS,'(I8)') NITER
      DUMMYS2=TRIM(ADJUSTL(FILENAME))
      FILENAME='int.' // TRIM(ADJUSTL(DUMMYS)) // '.xyz' ! so that vmd recognises the file type!
      FILENAME2='rbint.' // TRIM(ADJUSTL(DUMMYS)) // '.xyz'
   ELSE 
      WRITE(DUMMYS,'(I8)') NITER
      DUMMYS2=TRIM(ADJUSTL(FILENAME))
      FILENAME='int.' // TRIM(ADJUSTL(DUMMYS)) // '.' // TRIM(ADJUSTL(FILTHSTR)) // '.xyz' 
      FILENAME2='rbint.' // TRIM(ADJUSTL(DUMMYS)) // '.' // TRIM(ADJUSTL(FILTHSTR)) // '.xyz'
   ENDIF
ENDIF
OPEN(UNIT=993,FILE=FILENAME,STATUS='replace')
IF (STOCKT .OR. STOCKAAT) THEN
   DO J2=1,INTIMAGE+2 
      WRITE(993,'(i4/)') (natoms/2)
      DO J1=1,(natoms/2) 
         WRITE(993,'(a5,1x,6f20.10)') ZSYM((j1+2)/3), &
  & XYZ((J2-1)*NOPT+3*(J1-1)+1), XYZ((J2-1)*NOPT+3*(J1-1)+2), XYZ((J2-1)*NOPT+3*(J1-1)+3), &
  &    XYZ((J2-1)*NOPT+3*((natoms/2)+J1-1)+1), XYZ((J2-1)*NOPT+3*((natoms/2)+J1-1)+2), XYZ((J2-1)*NOPT+3*((natoms/2)+J1-1)+3)
      ENDDO
   ENDDO
ELSEIF (RBAAT .AND. (.NOT. STOCKAAT)) THEN
   PRINT '(A)',' intlbfgs> ERROR *** RGW routine needs to be taught STXYZ for this potential'
   STOP
!  OPEN(UNIT=114,FILE=FILENAME2,STATUS='unknown')
!  DO J2=1,INTIMAGE+2
!     WRITE(993,'(i4/)') NATOMS/2
!     DO J1=1,(NATOMS/2) 
!        WRITE(993,'(a5,1x,3f20.10)') 'O', &
! & XYZ((J2-1)*NOPT+3*(J1-1)+1), XYZ((J2-1)*NOPT+3*(J1-1)+2), XYZ((J2-1)*NOPT+3*(J1-1)+3)
!     ENDDO
!     CALL SITEPOS(XYZ((J2-1)*NOPT+1:J2*NOPT),STXYZ)
!     WRITE(114,'(i4/)') (NATOMS/2)*NRBSITES
!     DO J1=1,(NATOMS/2)*NRBSITES
!        J3 = 3*J1
!        WRITE(114,'(a5,1x,3f20.10)') 'O', STXYZ(J3-2), STXYZ(J3-1), STXYZ(J3)
!     ENDDO
!  ENDDO
!  CLOSE(UNIT=114)
ELSEIF (AMHT) THEN
   DO J2=1,INTIMAGE+2
!  GLY set getparams.f
!               WRITE(993,'(i4)')NATOMS +NUMGLY
!  GLY printing turned off DJW
      WRITE(993,'(i4)')NATOMS
      WRITE(993,*)'Energy'
      GLY_COUNT = 0

      DO J1=1,NMRES
         IF (SEQ(J1).EQ.8) THEN
            WRITE(993,'(a5,1x,3f20.10)') 'C1   ',XYZ((J2-1)*NOPT+9*(J1-1)+1-GLY_COUNT*3),XYZ((J2-1)*NOPT+9*(J1-1)+2-GLY_COUNT*3), &
     &                                  XYZ((J2-1)*NOPT+9*(J1-1)+3-GLY_COUNT*3)
!  GLY printing turned off DJW
!           WRITE(993,'(a5,1x,3f20.10)') 'C1   ',XYZ((J2-1)*NOPT+9*(J1-1)+1-GLY_COUNT*3),XYZ((J2-1)*NOPT+9*(J1-1)+2-GLY_COUNT*3), &
!    &                                  XYZ((J2-1)*NOPT+9*(J1-1)+3-GLY_COUNT*3)
            WRITE(993,'(a5,1x,3f20.10)') 'O    ',XYZ((J2-1)*NOPT+9*(J1-1)+4-GLY_COUNT*3),XYZ((J2-1)*NOPT+9*(J1-1)+5-GLY_COUNT*3), &
     &                                  XYZ((J2-1)*NOPT+9*(J1-1)+6-GLY_COUNT*3)
            GLY_COUNT = GLY_COUNT +1
         ELSE
            WRITE(993,'(a5,1x,3f20.10)') 'C1   ',XYZ((J2-1)*NOPT+9*(J1-1)+1-GLY_COUNT*3),XYZ((J2-1)*NOPT+9*(J1-1)+2-GLY_COUNT*3), &
     &                                  XYZ((J2-1)*NOPT+9*(J1-1)+3-GLY_COUNT*3)
            WRITE(993,'(a5,1x,3f20.10)') 'C2   ',XYZ((J2-1)*NOPT+9*(J1-1)+4-GLY_COUNT*3),XYZ((J2-1)*NOPT+9*(J1-1)+5-GLY_COUNT*3), &
     &                                  XYZ((J2-1)*NOPT+9*(J1-1)+6-GLY_COUNT*3)
            WRITE(993,'(a5,1x,3f20.10)') 'O    ',XYZ((J2-1)*NOPT+9*(J1-1)+7-GLY_COUNT*3),XYZ((J2-1)*NOPT+9*(J1-1)+8-GLY_COUNT*3), &
     &                                  XYZ((J2-1)*NOPT+9*(J1-1)+9-GLY_COUNT*3)
         ENDIF
      ENDDO
   ENDDO
ELSE
   DO J2=1,INTIMAGE+2
      WRITE(993,'(i4/)') natoms
      WRITE(993,'(a5,1x,3f20.10)') (ZSYM((j1+2)/3),xyz( (j2-1)*Nopt+j1),&
    & XYZ((J2-1)*NOPT+J1+1), XYZ((J2-1)*NOPT+J1+2),J1=1,NOPT,3)
   ENDDO
ENDIF

PRINT *, 'rwg> Interpolated image coordinates were saved to xyz file "'//TRIM(FILENAME)//'"'

CLOSE(UNIT=993)
END SUBROUTINE RWG

SUBROUTINE WRITEPROFILE(NITER,EEE,INTIMAGE)
USE KEY,ONLY: FILTH,FILTHSTR
IMPLICIT NONE 
INTEGER,INTENT(IN) :: NITER, INTIMAGE
INTEGER :: I,UNIT
DOUBLE PRECISION :: EEE(INTIMAGE+2)
CHARACTER(LEN=20) :: FILENAME

UNIT=992
IF (NITER.GT.0) THEN
   WRITE(FILENAME,'(I8)') NITER
   FILENAME='int.EofS.' // TRIM(ADJUSTL(FILENAME))
ELSE   
   FILENAME='int.EofS'
ENDIF
IF (.NOT.FILTH==0) THEN
   FILENAME=TRIM(FILENAME)//'.'//TRIM(ADJUSTL(FILTHSTR))
ENDIF
OPEN(UNIT=UNIT,FILE=FILENAME,STATUS='replace')

WRITE(UNIT=UNIT,FMT='(2g24.13)') EEE(1)
DO I=2,INTIMAGE+1
   WRITE(UNIT=UNIT,FMT='(2G24.13)') EEE(I)
ENDDO
WRITE(UNIT=UNIT,FMT='(2G24.13)') EEE(INTIMAGE+2)

CLOSE(UNIT)
PRINT '(A)',' writeprofile> Interpolated energy profile was saved to file "'//trim(filename)//'"'

END SUBROUTINE WRITEPROFILE

SUBROUTINE DOADDATOM(NCONSTRAINT,NTRIES,NEWATOM,IMGFREEZE,INTIMAGE,XYZ,EEE,GGG,TURNONORDER,NITERDONE,NACTIVE)
USE KEY, ONLY : CONACTIVE, CONI, CONJ, ATOMACTIVE, CONDISTREF, REPI, REPJ, REPCUT, INTREPSEP,  &
  &             INTCONSTRAINREPCUT, NREPULSIVE, NREPMAX, MAXCONUSE, NREPCUT, CHECKCONINT, INTFROZEN, &
  &             FREEZENODEST, NNREPULSIVE, NREPI, NREPJ, CONCUT
USE COMMONS, ONLY: NATOMS, NOPT, ZSYM, DEBUG
IMPLICIT NONE
INTEGER INTIMAGE
INTEGER NBEST, NCONTOACTIVE(NATOMS),  NCONSTRAINT, J2, NTRIES(NATOMS), NEWATOM,  CONLIST(NATOMS), N1, N2, N3, &
  &     NTOADD, NADDED, NMININT, NMAXINT, TURNONORDER(NATOMS), NDUMMY, J1, J3, NITERDONE, NCONFORNEWATOM, NACTIVE
DOUBLE PRECISION DUMMY, DUMMY2, DPRAND, RANDOM, CONDIST(NATOMS), DMIN, DMAX
INTEGER, ALLOCATABLE :: IREPTEMP(:)
DOUBLE PRECISION, ALLOCATABLE :: REPTEMP(:)
INTEGER NDFORNEWATOM, BESTPRESERVEDN(NATOMS)
DOUBLE PRECISION BESTPRESERVEDD(NATOMS), BESTCLOSESTD(NATOMS), INVDTOACTIVE(NATOMS)
LOGICAL IMGFREEZE(INTIMAGE)
DOUBLE PRECISION C1, C2, C3, VEC1(3), VEC2(3), VEC3(3), ESAVED, ESAVEC, ESAVE0
INTEGER NCFORNEWATOM, BESTCLOSESTN(NATOMS), NNREPSAVE, NREPSAVE
DOUBLE PRECISION XYZ(NOPT*(INTIMAGE+2)), XSAVED(3,INTIMAGE+2), XSAVEC(3,INTIMAGE+2), XSAVE0(3,INTIMAGE+2),FRAC,RAN1, &
  &              RMS,EEE(INTIMAGE+2),GGG(NOPT*(INTIMAGE+2)),ETOTAL,DS,DF

NTOADD=1
!  NTOADD=NATOMS-2  !!!! DJW
NADDED=0

!
! Save current number of repulsions and number that are active to speed up the
! calls to CHECKREP
!
NNREPSAVE=NNREPULSIVE
NREPSAVE=NREPULSIVE
542   CONTINUE
!     DUMMY=1.0D100
      NBEST=0
      NCONTOACTIVE(1:NATOMS)=0
      INVDTOACTIVE(1:NATOMS)=0.0D0
      DO J2=1,NCONSTRAINT
         IF (CONACTIVE(J2)) CYCLE   ! count new, inactive constraints
         IF (ATOMACTIVE(CONI(J2))) THEN
            IF (.NOT.ATOMACTIVE(CONJ(J2))) THEN
               NCONTOACTIVE(CONJ(J2))=NCONTOACTIVE(CONJ(J2))+1
               INVDTOACTIVE(CONJ(J2))=INVDTOACTIVE(CONJ(J2))+1.0D0/CONDISTREF(J2)
            ENDIF
         ENDIF
         IF (ATOMACTIVE(CONJ(J2))) THEN
            IF (.NOT.ATOMACTIVE(CONI(J2))) THEN
               NCONTOACTIVE(CONI(J2))=NCONTOACTIVE(CONI(J2))+1
               INVDTOACTIVE(CONI(J2))=INVDTOACTIVE(CONI(J2))+1.0D0/CONDISTREF(J2)
            ENDIF
         ENDIF
         IF (NCONTOACTIVE(CONI(J2)).GT.NBEST) THEN
            NBEST=NCONTOACTIVE(CONI(J2))
         ENDIF
         IF (NCONTOACTIVE(CONJ(J2)).GT.NBEST) THEN
            NBEST=NCONTOACTIVE(CONJ(J2))
         ENDIF
!        PRINT '(A,7I6)','J2,NCONTOACTIVEI,NCONTOACTOVEJ,CONI,CONJ,NEWATOM,NBEST=', &
! &                             J2,NCONTOACTIVE(CONI(J2)),NCONTOACTIVE(CONJ(J2)),CONI(J2),CONJ(J2),NEWATOM,NBEST

      ENDDO
!
!  Choose NEWATOM stochastically. Bias towards atoms with the maximum constraints.
!  Use a normalised probability and generate a random number between 0 and 1.
!
      DUMMY2=0.0D0
      DO J2=1,NATOMS
         IF (NCONTOACTIVE(J2).EQ.0) CYCLE
         IF (ATOMACTIVE(J2)) CYCLE
!        DUMMY2=DUMMY2+((1.0D0*NCONTOACTIVE(J2))/(1.0D0*CONDISTREF(J2)*NTRIES(J2)))**4 
         DUMMY2=DUMMY2+((1.0D0*INVDTOACTIVE(J2))/(1.0D0*NTRIES(J2)))**4 
!        PRINT '(A,I6,A,G20.10)',' intlbfgs> Unnormalised probability for choosing atom ',J2,' is ', &
! &                ((1.0D0*INVDTOACTIVE(J2))/(1.0D0*NTRIES(J2)))**4
      ENDDO

      RANDOM=DUMMY2*DPRAND()
      DUMMY2=0.0D0
      choosenew: DO J2=1,NATOMS
         IF (NCONTOACTIVE(J2).EQ.0) CYCLE
         IF (ATOMACTIVE(J2)) CYCLE
!        DUMMY2=DUMMY2+((1.0D0*NCONTOACTIVE(J2))/(1.0D0*CONDISTREF(J2)*NTRIES(J2)))**4 
         DUMMY2=DUMMY2+((1.0D0*INVDTOACTIVE(J2))/(1.0D0*NTRIES(J2)))**4 
         IF (DUMMY2.GE.RANDOM) THEN
            NEWATOM=J2
            IF (DEBUG) PRINT '(3(A,I6))',' intlbfgs> Choosing new active atom ',NEWATOM,' new constraints=', &
  &                                       NCONTOACTIVE(J2),' maximum=',NBEST
            EXIT choosenew
         ENDIF
      ENDDO choosenew
          
      IF (NEWATOM*NBEST.EQ.0) THEN ! sanity check
         PRINT '(A,I6,A,2I6)',' intlbfgs> ERROR *** new active atom not set'
         STOP
      ELSE
!
!  We need a sorted list of up to 3 active atoms, sorted according to how well the
!  end point distance is preserved, even if they don't satisfy the constraint 
!  condition. We want three atoms to use for a local axis system in the interpolation.
!
!  Try sorting on the shortest average distances in the endpoint structures instead, to avoid
!  problems with distant atoms acidentally having a well-preserved distance.
!
         NDFORNEWATOM=0
         BESTPRESERVEDD(1:NATOMS)=1.0D100
         DO J1=1,NATOMS
            IF (.NOT.ATOMACTIVE(J1)) CYCLE
            DS=SQRT((XYZ(3*(NEWATOM-1)+1)-XYZ(3*(J1-1)+1))**2 &
  &                +(XYZ(3*(NEWATOM-1)+2)-XYZ(3*(J1-1)+2))**2 &
  &                +(XYZ(3*(NEWATOM-1)+3)-XYZ(3*(J1-1)+3))**2) 
            DF=SQRT((XYZ((INTIMAGE+1)*3*NATOMS+3*(NEWATOM-1)+1)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+1))**2 &
  &                +(XYZ((INTIMAGE+1)*3*NATOMS+3*(NEWATOM-1)+2)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+2))**2 &
  &                +(XYZ((INTIMAGE+1)*3*NATOMS+3*(NEWATOM-1)+3)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+3))**2) 
            DUMMY=ABS(DS-DF)
            NDFORNEWATOM=NDFORNEWATOM+1
            DO J2=1,NDFORNEWATOM 
               IF (DUMMY.LT.BESTPRESERVEDD(J2)) THEN
!                 PRINT '(A,I6,G12.4,I6,G12.4)','J1,DUMMY < J2,BESTPRESERVEDD: ',J1,DUMMY,J2,BESTPRESERVEDD(J2)
                  DO J3=NDFORNEWATOM,J2+1,-1 
!                    PRINT '(A,I6,A,I6,A,G12.4)',' moving diff and list from ',J3-1,' to ',J3, &
!&                                               ' DIFF=',BESTPRESERVEDD(J3-1)
                     BESTPRESERVEDD(J3)=BESTPRESERVEDD(J3-1)
                     BESTPRESERVEDN(J3)=BESTPRESERVEDN(J3-1)
                  ENDDO
                  BESTPRESERVEDD(J2)=DUMMY
!                 PRINT '(A,I6,A,G12.4)',' setting BESTPRESERVEDD element ',J2,' to ',DUMMY
                  BESTPRESERVEDN(J2)=J1
!                 PRINT '(A,I6,A,G12.4)',' setting BESTPRESERVEDN element ',J2,' to ',J1
                  GOTO 653
               ENDIF
            ENDDO
653         CONTINUE
         ENDDO
         IF (DEBUG) THEN
            PRINT '(A,I6,A,I6,A)',' intlbfgs> New active atom ',NEWATOM,' best preserved distances:'
            PRINT '(20I6)',BESTPRESERVEDN(1:MIN(10,NDFORNEWATOM))
            PRINT '(A,I6,A,I6,A)',' intlbfgs> sorted differences:'
            PRINT '(10G12.4)',BESTPRESERVEDD(1:MIN(10,NDFORNEWATOM))
         ENDIF
         IF (FREEZENODEST) IMGFREEZE(1:INTIMAGE)=.FALSE.

         NCFORNEWATOM=0
         BESTCLOSESTD(1:NATOMS)=1.0D100
         DO J1=1,NATOMS
            IF (.NOT.ATOMACTIVE(J1)) CYCLE
            DS=SQRT((XYZ(3*(NEWATOM-1)+1)-XYZ(3*(J1-1)+1))**2 &
  &                +(XYZ(3*(NEWATOM-1)+2)-XYZ(3*(J1-1)+2))**2 &
  &                +(XYZ(3*(NEWATOM-1)+3)-XYZ(3*(J1-1)+3))**2) 
            DF=SQRT((XYZ((INTIMAGE+1)*3*NATOMS+3*(NEWATOM-1)+1)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+1))**2 &
  &                +(XYZ((INTIMAGE+1)*3*NATOMS+3*(NEWATOM-1)+2)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+2))**2 &
  &                +(XYZ((INTIMAGE+1)*3*NATOMS+3*(NEWATOM-1)+3)-XYZ((INTIMAGE+1)*3*NATOMS+3*(J1-1)+3))**2) 
            DUMMY=(DS+DF)/2.0D0
            NCFORNEWATOM=NCFORNEWATOM+1
            DO J2=1,NCFORNEWATOM
               IF (DUMMY.LT.BESTCLOSESTD(J2)) THEN
!                 PRINT '(A,I6,G12.4,I6,G12.4)','J1,DUMMY < J2,BESTCLOSESTD: ',J1,DUMMY,J2,BESTCLOSESTD(J2)
                  DO J3=NCFORNEWATOM,J2+1,-1
!                    PRINT '(A,I6,A,I6,A,G12.4)',' moving diff and list from ',J3-1,' to ',J3, &
!&                                               ' DIFF=',BESTCLOSESTD(J3-1)
                     BESTCLOSESTD(J3)=BESTCLOSESTD(J3-1)
                     BESTCLOSESTN(J3)=BESTCLOSESTN(J3-1)
                  ENDDO
                  BESTCLOSESTD(J2)=DUMMY
!                 PRINT '(A,I6,A,G12.4)',' setting BESTCLOSESTD element ',J2,' to ',DUMMY
                  BESTCLOSESTN(J2)=J1
!                 PRINT '(A,I6,A,G12.4)',' setting BESTCLOSESTN element ',J2,' to ',J1
                  GOTO 659
               ENDIF
            ENDDO
659         CONTINUE
         ENDDO
         IF (DEBUG) THEN
            PRINT '(A,I6,A,I6,A)',' intlbfgs> New active atom ',NEWATOM,' shortest average distances in endpoints:'
            PRINT '(20I6)',BESTCLOSESTN(1:MIN(10,NCFORNEWATOM))
            PRINT '(A,I6,A,I6,A)',' intlbfgs> sorted differences:'
            PRINT '(10G12.4)',BESTCLOSESTN(1:MIN(10,NCFORNEWATOM))
         ENDIF
!
!  Maintain a sorted list of active atoms that are constrained to the new atom, sorted
!  according to their distance.
!
         NCONFORNEWATOM=0
         CONDIST(1:NATOMS)=1.0D100
         IF (DEBUG) PRINT '(3(A,I6))',' intlbfgs> New active atom is number ',NEWATOM,' total=',NACTIVE+1, &
 &                        ' steps=',NITERDONE
         DO J1=1,NCONSTRAINT
            IF (CONACTIVE(J1)) CYCLE
            IF ((CONI(J1).EQ.NEWATOM).AND.(ATOMACTIVE(CONJ(J1))).OR.(CONJ(J1).EQ.NEWATOM).AND.(ATOMACTIVE(CONI(J1)))) THEN  
                 NCONFORNEWATOM=NCONFORNEWATOM+1
!                CONACTIVE(J1)=.TRUE.
!                NITSTART(J1)=NITERDONE
!                NCONSTRAINTON=NCONSTRAINTON+1
! !
! ! The ...ON variables are not actually used in congrad.f90.
! !
!                CONDISTREFLOCALON(NCONSTRAINTON)=CONDISTREFLOCAL(J1)
!                CONDISTREFON(NCONSTRAINTON)=CONDISTREF(J1)
!                CONION(NCONSTRAINTON)=CONI(J1)
!                CONJON(NCONSTRAINTON)=CONJ(J1)
! 
!                IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning on constraint ',J1,' for atoms ',CONI(J1),CONJ(J1)
               IF (NCONFORNEWATOM.EQ.1) THEN
                  CONDIST(1)=CONDISTREF(J1)
                  IF (CONI(J1).EQ.NEWATOM) CONLIST(1)=CONJ(J1)
                  IF (CONJ(J1).EQ.NEWATOM) CONLIST(1)=CONI(J1)
               ENDIF
               DO J2=1,NCONFORNEWATOM-1
                  IF (CONDISTREF(J1).LT.CONDIST(J2)) THEN
!                    PRINT '(A,I6,G12.4,I6,G12.4)','J1,CONDISTREF < J2,CONDIST: ',J1,CONDISTREF(J1),J2,CONDIST(J2)
                     DO J3=NCONFORNEWATOM,J2+1,-1
!                       PRINT '(A,I6,A,I6,A,G12.4)',' moving dist and list from ',J3-1,' to ',J3,' CONDIST=',CONDIST(J3-1)
                        CONDIST(J3)=CONDIST(J3-1)
                        CONLIST(J3)=CONLIST(J3-1)
                     ENDDO
                     CONDIST(J2)=CONDISTREF(J1)
!                    PRINT '(A,I6,A,G12.4)',' setting condist element ',J2,' to ',CONDISTREF(J1)
                     IF (CONI(J1).EQ.NEWATOM) CONLIST(J2)=CONJ(J1)
                     IF (CONJ(J1).EQ.NEWATOM) CONLIST(J2)=CONI(J1)
!                    PRINT '(A,I6,A,G12.4)',' setting conlist element ',J2,' to ',CONLIST(J2)
                     GOTO 654
                  ENDIF
               ENDDO 
               CONDIST(NCONFORNEWATOM)=CONDISTREF(J1)
!              PRINT '(A,I6,A,G12.4)',' setting condist element ',NCONFORNEWATOM,' to ',CONDISTREF(J1)
               IF (CONI(J1).EQ.NEWATOM) CONLIST(NCONFORNEWATOM)=CONJ(J1)
               IF (CONJ(J1).EQ.NEWATOM) CONLIST(NCONFORNEWATOM)=CONI(J1)
!              PRINT '(A,I6,A,G12.4)',' setting conlist element ',NCONFORNEWATOM,' to ',CONLIST(NCONFORNEWATOM)
654          CONTINUE
            ENDIF
         ENDDO 
         IF (DEBUG) THEN
            PRINT '(A,I6,A,I6,A)',' intlbfgs> New active atom ',NEWATOM,' is constrained to ',NCONFORNEWATOM,' other active atoms:'
            PRINT '(20I6)',CONLIST(1:NCONFORNEWATOM)
            PRINT '(A,I6,A,I6,A)',' intlbfgs> sorted distances:'
            PRINT '(10G12.4)',CONDIST(1:NCONFORNEWATOM)
         ENDIF
         DO J1=1,MIN(MAXCONUSE,NCONFORNEWATOM)
            DO J2=1,NCONSTRAINT
               IF ((CONI(J2).EQ.NEWATOM).AND.(CONJ(J2).EQ.CONLIST(J1))) THEN
                     CONACTIVE(J2)=.TRUE.
                     IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning on constraint ',J2,' for atoms ',CONI(J2),CONJ(J2)
               ELSE IF ((CONJ(J2).EQ.NEWATOM).AND.(CONI(J2).EQ.CONLIST(J1))) THEN
                     CONACTIVE(J2)=.TRUE.
                     IF (DEBUG) PRINT '(A,I6,A,2I6)',' intlbfgs> Turning on constraint ',J2,' for atoms ',CONI(J2),CONJ(J2)
               ENDIF
            ENDDO
         ENDDO
         DO J1=1,NATOMS
            IF (.NOT.ATOMACTIVE(J1)) CYCLE ! identify active atoms
            IF (ABS(J1-NEWATOM).LE.INTREPSEP) CYCLE ! no repulsion for atoms too close in sequence
            DO J2=1,NCONSTRAINT
!
!  With MAXCONUSE set to a finite value there could be constraints for the new atom that are
!  not active. We don't want these to be changed to repulsion, surely?!
!  Or perhaps we do need to do something with them?
!
               IF (.NOT.CONACTIVE(J2)) CYCLE ! identify active constraints 
               IF (((CONI(J2).EQ.J1).AND.(CONJ(J2).EQ.NEWATOM)).OR.((CONJ(J2).EQ.J1).AND.(CONI(J2).EQ.NEWATOM))) GOTO 543
            ENDDO
            DMIN=1.0D100
            DO J2=1,INTIMAGE+2,INTIMAGE+1 ! only consider the end-point distances
               DF=SQRT((XYZ((J2-1)*3*NATOMS+3*(NEWATOM-1)+1)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+1))**2+ &
  &                    (XYZ((J2-1)*3*NATOMS+3*(NEWATOM-1)+2)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+2))**2+ &
  &                    (XYZ((J2-1)*3*NATOMS+3*(NEWATOM-1)+3)-XYZ((J2-1)*3*NATOMS+3*(J1-1)+3))**2)
               IF (DF.LT.DMIN) DMIN=DF
            ENDDO
!
! Use the minimum of the end point distances and INTCONSTRAINREPCUT for each contact.
!
            DMIN=MIN(DMIN-1.0D-3,INTCONSTRAINREPCUT)
            NREPULSIVE=NREPULSIVE+1
            IF (NREPULSIVE.GT.NREPMAX) CALL REPDOUBLE
            REPI(NREPULSIVE)=J1
            REPJ(NREPULSIVE)=NEWATOM
            REPCUT(NREPULSIVE)=DMIN
!           IF (DEBUG) PRINT '(A,I6,A,I6,A,F15.5)',' intlbfgs> Adding repulsion for new atom ',NEWATOM,' with atom ',J1, &
! &                                                   ' cutoff=',DMIN
543         CONTINUE
         ENDDO
         ATOMACTIVE(NEWATOM)=.TRUE.
         NACTIVE=NACTIVE+1

         NDUMMY=0
         DO J1=1,NATOMS
            IF (ATOMACTIVE(J1)) NDUMMY=NDUMMY+1
         ENDDO
         IF (NDUMMY.NE.NACTIVE) THEN
            PRINT '(A,I6)',' intlbfgs> ERROR *** inconsistency in number of active atoms. ',NDUMMY,' should be ',NACTIVE
            DO J1=1,NATOMS
               IF (ATOMACTIVE(J1)) PRINT '(A,I6)',' active atom ',J1
            ENDDO
            STOP
         ENDIF

         TURNONORDER(NACTIVE)=NEWATOM
!
! Initial guess for new active atom position. This is crucial for success in INTCONSTRAINT schemes!
!
         ESAVED=1.0D100
         ESAVE0=1.0D100
         ESAVEC=1.0D100
         IF (NCONFORNEWATOM.GE.3) THEN
!
! Move the new atom consistently in the local environment of its three nearest actively constrained atoms.
! Make a local orthogonal coordinate system and use constant components in this basis.
!
            IF (DEBUG) PRINT '(A)',' intlbfgs> initial guess from closest three constrained active atoms'
            VEC1(1:3)=XYZ(3*(CONLIST(2)-1)+1:3*(CONLIST(2)-1)+3)-XYZ(3*(CONLIST(1)-1)+1:3*(CONLIST(1)-1)+3)
            DUMMY=SQRT(VEC1(1)**2+VEC1(2)**2+VEC1(3)**2)
            IF (DUMMY.NE.0.0D0) VEC1(1:3)=VEC1(1:3)/DUMMY
            VEC2(1:3)=XYZ(3*(CONLIST(3)-1)+1:3*(CONLIST(3)-1)+3)-XYZ(3*(CONLIST(1)-1)+1:3*(CONLIST(1)-1)+3)
            DUMMY=VEC1(1)*VEC2(1)+VEC1(2)*VEC2(2)+VEC1(3)*VEC2(3)
            VEC2(1:3)=VEC2(1:3)-DUMMY*VEC1(1:3)
            DUMMY=SQRT(VEC2(1)**2+VEC2(2)**2+VEC2(3)**2)
            IF (DUMMY.NE.0.0D0) VEC2(1:3)=VEC2(1:3)/DUMMY
            VEC3(1)= VEC1(2)*VEC2(3)-VEC1(3)*VEC2(2)
            VEC3(2)=-VEC1(1)*VEC2(3)+VEC1(3)*VEC2(1)
            VEC3(3)= VEC1(1)*VEC2(2)-VEC1(2)*VEC2(1)
            C1=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(CONLIST(1)-1)+1))*VEC1(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(CONLIST(1)-1)+2))*VEC1(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(CONLIST(1)-1)+3))*VEC1(3)
            C2=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(CONLIST(1)-1)+1))*VEC2(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(CONLIST(1)-1)+2))*VEC2(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(CONLIST(1)-1)+3))*VEC2(3)
            C3=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(CONLIST(1)-1)+1))*VEC3(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(CONLIST(1)-1)+2))*VEC3(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(CONLIST(1)-1)+3))*VEC3(3)
            DO J1=2,INTIMAGE+1
               VEC1(1:3)=XYZ((J1-1)*3*NATOMS+3*(CONLIST(2)-1)+1:(J1-1)*3*NATOMS+3*(CONLIST(2)-1)+3) &
  &                     -XYZ((J1-1)*3*NATOMS+3*(CONLIST(1)-1)+1:(J1-1)*3*NATOMS+3*(CONLIST(1)-1)+3)
               DUMMY=SQRT(VEC1(1)**2+VEC1(2)**2+VEC1(3)**2)
               IF (DUMMY.NE.0.0D0) VEC1(1:3)=VEC1(1:3)/DUMMY
               VEC2(1:3)=XYZ((J1-1)*3*NATOMS+3*(CONLIST(3)-1)+1:(J1-1)*3*NATOMS+3*(CONLIST(3)-1)+3) &
  &                     -XYZ((J1-1)*3*NATOMS+3*(CONLIST(1)-1)+1:(J1-1)*3*NATOMS+3*(CONLIST(1)-1)+3)
               DUMMY=VEC1(1)*VEC2(1)+VEC1(2)*VEC2(2)+VEC1(3)*VEC2(3)
               VEC2(1:3)=VEC2(1:3)-DUMMY*VEC1(1:3)
               DUMMY=SQRT(VEC2(1)**2+VEC2(2)**2+VEC2(3)**2)
               IF (DUMMY.NE.0.0D0) VEC2(1:3)=VEC2(1:3)/DUMMY
               VEC3(1)= VEC1(2)*VEC2(3)-VEC1(3)*VEC2(2)
               VEC3(2)=-VEC1(1)*VEC2(3)+VEC1(3)*VEC2(1)
               VEC3(3)= VEC1(1)*VEC2(2)-VEC1(2)*VEC2(1)
               XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)= &
  &            XYZ((J1-1)*3*NATOMS+3*(CONLIST(1)-1)+1:(J1-1)*3*NATOMS+3*(CONLIST(1)-1)+3)+C1*VEC1(1:3)+C2*VEC2(1:3)+C3*VEC3(1:3)
            ENDDO
            CALL CHECKREP(INTIMAGE,XYZ,NOPT,NNREPSAVE,NREPSAVE+1) ! set up repulsive neighbour list
            IF (CHECKCONINT) THEN
               CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ELSE
               CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ENDIF
            ESAVE0=ETOTAL
            DO J1=2,INTIMAGE+1
               XSAVE0(1:3,J1)=XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)
            ENDDO
         ENDIF
         IF (NDFORNEWATOM.GE.3) THEN
!
! Choose three atoms from the BESTPRESERVEDN list at random with bias towards the 
! start of the list. Let the relative weight for position i be 1/i**2 and calculate
! the sum to normalise.
!
            DUMMY=0.0D0
            DO J1=1,NDFORNEWATOM
!              DUMMY=DUMMY+1.0D0/(1.0D0*J1)
!              DUMMY=DUMMY+1.0D0/(1.0D0*BESTPRESERVEDD(J1))
               DUMMY=DUMMY+1.0D0/(1.0D0*J1**2)
            ENDDO
            N1=0; N2=0; N3=0
            DO WHILE (N3.EQ.0)
               DUMMY2=0.0D0
               RAN1=DPRAND()*DUMMY
               DO J1=1,NDFORNEWATOM
!                 DUMMY2=DUMMY2+1.0D0/(1.0D0*J1)
!                 DUMMY2=DUMMY2+1.0D0/(1.0D0*BESTPRESERVEDD(J1))
                  DUMMY2=DUMMY2+1.0D0/(1.0D0*J1**2)
                  IF (DUMMY2.GE.RAN1) THEN
                     IF ((J1.EQ.N1).OR.(J1.EQ.N2)) EXIT ! already chosen
                     IF (N1.EQ.0) THEN
                        N1=J1
                        EXIT
                     ENDIF
                     IF (N2.EQ.0) THEN
                        N2=J1
                        EXIT
                     ENDIF
                     N3=J1
                     EXIT
                  ENDIF
               ENDDO
            ENDDO
            IF (DEBUG) PRINT '(A,3I6,A)',' intlbfgs> choosing positions ',N1,N2,N3,' in best preserved list'
            IF (DEBUG) PRINT '(A,3I6)',' intlbfgs> atoms are ',BESTPRESERVEDN(N1),BESTPRESERVEDN(N2),BESTPRESERVEDN(N3)
!           IF (DEBUG) PRINT '(A,3I6,A)',' intlbfgs> full list has length ',NDFORNEWATOM
!           IF (DEBUG) PRINT '(20I6)',BESTPRESERVEDN(1:NDFORNEWATOM)

!
! Move the new atom consistently in the local environment of the three active atoms with the
! best preserved absolute distances or the shortest average distances in the end points.
! Check the energies and compare linear interpolation as well, then choose the interpolation
! with the lowest energy.
! Make a local orthogonal coordinate system and use constant components in this basis.
!
            VEC1(1:3)=XYZ(3*(BESTPRESERVEDN(N2)-1)+1:3*(BESTPRESERVEDN(N2)-1)+3) &
  &                  -XYZ(3*(BESTPRESERVEDN(N1)-1)+1:3*(BESTPRESERVEDN(N1)-1)+3)
            DUMMY=SQRT(VEC1(1)**2+VEC1(2)**2+VEC1(3)**2)
            IF (DUMMY.NE.0.0D0) VEC1(1:3)=VEC1(1:3)/DUMMY
            VEC2(1:3)=XYZ(3*(BESTPRESERVEDN(N3)-1)+1:3*(BESTPRESERVEDN(N3)-1)+3) &
  &                  -XYZ(3*(BESTPRESERVEDN(N1)-1)+1:3*(BESTPRESERVEDN(N1)-1)+3)
            DUMMY=VEC1(1)*VEC2(1)+VEC1(2)*VEC2(2)+VEC1(3)*VEC2(3)
            VEC2(1:3)=VEC2(1:3)-DUMMY*VEC1(1:3)
            DUMMY=SQRT(VEC2(1)**2+VEC2(2)**2+VEC2(3)**2)
            IF (DUMMY.NE.0.0D0) VEC2(1:3)=VEC2(1:3)/DUMMY
            VEC3(1)= VEC1(2)*VEC2(3)-VEC1(3)*VEC2(2)
            VEC3(2)=-VEC1(1)*VEC2(3)+VEC1(3)*VEC2(1)
            VEC3(3)= VEC1(1)*VEC2(2)-VEC1(2)*VEC2(1)
            C1=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(BESTPRESERVEDN(N1)-1)+1))*VEC1(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(BESTPRESERVEDN(N1)-1)+2))*VEC1(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(BESTPRESERVEDN(N1)-1)+3))*VEC1(3)
            C2=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(BESTPRESERVEDN(N1)-1)+1))*VEC2(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(BESTPRESERVEDN(N1)-1)+2))*VEC2(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(BESTPRESERVEDN(N1)-1)+3))*VEC2(3)
            C3=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(BESTPRESERVEDN(N1)-1)+1))*VEC3(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(BESTPRESERVEDN(N1)-1)+2))*VEC3(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(BESTPRESERVEDN(N1)-1)+3))*VEC3(3)
            DO J1=2,INTIMAGE+1
               VEC1(1:3)=XYZ((J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N2)-1)+1:(J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N2)-1)+3) &
  &                     -XYZ((J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N1)-1)+1:(J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N1)-1)+3)
               DUMMY=SQRT(VEC1(1)**2+VEC1(2)**2+VEC1(3)**2)
               IF (DUMMY.NE.0.0D0) VEC1(1:3)=VEC1(1:3)/DUMMY
               VEC2(1:3)=XYZ((J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N3)-1)+1:(J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N3)-1)+3) &
  &                     -XYZ((J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N1)-1)+1:(J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N1)-1)+3)
               DUMMY=VEC1(1)*VEC2(1)+VEC1(2)*VEC2(2)+VEC1(3)*VEC2(3)
               VEC2(1:3)=VEC2(1:3)-DUMMY*VEC1(1:3)
               DUMMY=SQRT(VEC2(1)**2+VEC2(2)**2+VEC2(3)**2)
               IF (DUMMY.NE.0.0D0) VEC2(1:3)=VEC2(1:3)/DUMMY
               VEC3(1)= VEC1(2)*VEC2(3)-VEC1(3)*VEC2(2)
               VEC3(2)=-VEC1(1)*VEC2(3)+VEC1(3)*VEC2(1)
               VEC3(3)= VEC1(1)*VEC2(2)-VEC1(2)*VEC2(1)
               XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)= &
  &            XYZ((J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N1)-1)+1:(J1-1)*3*NATOMS+3*(BESTPRESERVEDN(N1)-1)+3)+ &
  &                   C1*VEC1(1:3)+C2*VEC2(1:3)+C3*VEC3(1:3)
            ENDDO

            CALL CHECKREP(INTIMAGE,XYZ,NOPT,NNREPSAVE,NREPSAVE+1) ! set up repulsive neighbour list
            IF (CHECKCONINT) THEN
               CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ELSE
               CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ENDIF
            ESAVED=ETOTAL
            DO J1=2,INTIMAGE+1
               XSAVED(1:3,J1)=XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)
            ENDDO
         ENDIF

         IF (NCFORNEWATOM.GE.3) THEN
!
! Choose three atoms from the BESTCLOSEST list at random with bias towards the
! start of the list. Let the relative weight for position i be 1/i**2 and calculate
! the sum to normalise.
!
            DUMMY=0.0D0
            DO J1=1,NCFORNEWATOM
!              DUMMY=DUMMY+1.0D0/(1.0D0*J1)
!              DUMMY=DUMMY+1.0D0/(1.0D0*BESTCLOSESTD(J1))
               DUMMY=DUMMY+1.0D0/(1.0D0*J1**2)
            ENDDO
            N1=0; N2=0; N3=0
            DO WHILE (N3.EQ.0)
               DUMMY2=0.0D0
               RAN1=DPRAND()*DUMMY
               DO J1=1,NCFORNEWATOM
!                 DUMMY2=DUMMY2+1.0D0/(1.0D0*J1)
!                 DUMMY2=DUMMY2+1.0D0/(1.0D0*BESTCLOSESTD(J1))
                  DUMMY2=DUMMY2+1.0D0/(1.0D0*J1**2)
                  IF (DUMMY2.GE.RAN1) THEN
                     IF ((J1.EQ.N1).OR.(J1.EQ.N2)) EXIT ! already chosen
                     IF (N1.EQ.0) THEN
                        N1=J1
                        EXIT
                     ENDIF
                     IF (N2.EQ.0) THEN
                        N2=J1
                        EXIT
                     ENDIF
                     N3=J1
                     EXIT
                  ENDIF
               ENDDO
            ENDDO
            IF (DEBUG) PRINT '(A,3I6,A)',' intlbfgs> choosing positions ',N1,N2,N3,' in closest list'

            VEC1(1:3)=XYZ(3*(BESTCLOSESTN(N2)-1)+1:3*(BESTCLOSESTN(N2)-1)+3)-XYZ(3*(BESTCLOSESTN(N1)-1)+1:3*(BESTCLOSESTN(N1)-1)+3)
            DUMMY=SQRT(VEC1(1)**2+VEC1(2)**2+VEC1(3)**2)
            IF (DUMMY.NE.0.0D0) VEC1(1:3)=VEC1(1:3)/DUMMY
            VEC2(1:3)=XYZ(3*(BESTCLOSESTN(N3)-1)+1:3*(BESTCLOSESTN(N3)-1)+3)-XYZ(3*(BESTCLOSESTN(N1)-1)+1:3*(BESTCLOSESTN(N1)-1)+3)
            DUMMY=VEC1(1)*VEC2(1)+VEC1(2)*VEC2(2)+VEC1(3)*VEC2(3)
            VEC2(1:3)=VEC2(1:3)-DUMMY*VEC1(1:3)
            DUMMY=SQRT(VEC2(1)**2+VEC2(2)**2+VEC2(3)**2)
            IF (DUMMY.NE.0.0D0) VEC2(1:3)=VEC2(1:3)/DUMMY
            VEC3(1)= VEC1(2)*VEC2(3)-VEC1(3)*VEC2(2)
            VEC3(2)=-VEC1(1)*VEC2(3)+VEC1(3)*VEC2(1)
            VEC3(3)= VEC1(1)*VEC2(2)-VEC1(2)*VEC2(1)
            C1=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(BESTCLOSESTN(N1)-1)+1))*VEC1(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(BESTCLOSESTN(N1)-1)+2))*VEC1(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(BESTCLOSESTN(N1)-1)+3))*VEC1(3)
            C2=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(BESTCLOSESTN(N1)-1)+1))*VEC2(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(BESTCLOSESTN(N1)-1)+2))*VEC2(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(BESTCLOSESTN(N1)-1)+3))*VEC2(3)
            C3=(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(BESTCLOSESTN(N1)-1)+1))*VEC3(1)+ &
  &            (XYZ(3*(NEWATOM-1)+2)-XYZ(3*(BESTCLOSESTN(N1)-1)+2))*VEC3(2)+ &
  &            (XYZ(3*(NEWATOM-1)+3)-XYZ(3*(BESTCLOSESTN(N1)-1)+3))*VEC3(3)
            DO J1=2,INTIMAGE+1
               VEC1(1:3)=XYZ((J1-1)*3*NATOMS+3*(BESTCLOSESTN(N2)-1)+1:(J1-1)*3*NATOMS+3*(BESTCLOSESTN(N2)-1)+3) &
  &                     -XYZ((J1-1)*3*NATOMS+3*(BESTCLOSESTN(N1)-1)+1:(J1-1)*3*NATOMS+3*(BESTCLOSESTN(N1)-1)+3)
               DUMMY=SQRT(VEC1(1)**2+VEC1(2)**2+VEC1(3)**2)
               IF (DUMMY.NE.0.0D0) VEC1(1:3)=VEC1(1:3)/DUMMY
               VEC2(1:3)=XYZ((J1-1)*3*NATOMS+3*(BESTCLOSESTN(N3)-1)+1:(J1-1)*3*NATOMS+3*(BESTCLOSESTN(N3)-1)+3) &
  &                     -XYZ((J1-1)*3*NATOMS+3*(BESTCLOSESTN(N1)-1)+1:(J1-1)*3*NATOMS+3*(BESTCLOSESTN(N1)-1)+3)
               DUMMY=VEC1(1)*VEC2(1)+VEC1(2)*VEC2(2)+VEC1(3)*VEC2(3)
               VEC2(1:3)=VEC2(1:3)-DUMMY*VEC1(1:3)
               DUMMY=SQRT(VEC2(1)**2+VEC2(2)**2+VEC2(3)**2)
               IF (DUMMY.NE.0.0D0) VEC2(1:3)=VEC2(1:3)/DUMMY
               VEC3(1)= VEC1(2)*VEC2(3)-VEC1(3)*VEC2(2)
               VEC3(2)=-VEC1(1)*VEC2(3)+VEC1(3)*VEC2(1)
               VEC3(3)= VEC1(1)*VEC2(2)-VEC1(2)*VEC2(1)
               XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)= &
  &            XYZ((J1-1)*3*NATOMS+3*(BESTCLOSESTN(N1)-1)+1:(J1-1)*3*NATOMS+3*(BESTCLOSESTN(N1)-1)+3)+ &
  &                   C1*VEC1(1:3)+C2*VEC2(1:3)+C3*VEC3(1:3)
            ENDDO

            CALL CHECKREP(INTIMAGE,XYZ,NOPT,NNREPSAVE,NREPSAVE+1) ! set up repulsive neighbour list
            IF (CHECKCONINT) THEN
               CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ELSE
               CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
            ENDIF
            ESAVEC=ETOTAL
            DO J1=2,INTIMAGE+1
               XSAVEC(1:3,J1)=XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)
            ENDDO
         ENDIF
!
! Standard linear interpolation, with constraint distance scaled by FRAC.
! Works for FRAC as small as 0.1 with repulsion turned off.
! We use an appropriately weighted displacement from atom CONLIST(1) using the displacements
! in the two end points.
!
         FRAC=1.0D0
         DO J1=2,INTIMAGE+1
            XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1)=XYZ((J1-1)*3*NATOMS+3*(CONLIST(1)-1)+1)  &
 &            +(INTIMAGE-J1+2)*FRAC*(XYZ(3*(NEWATOM-1)+1)-XYZ(3*(CONLIST(1)-1)+1))/(INTIMAGE+1) &
 &   +(J1-1)*(XYZ(3*NATOMS*(INTIMAGE+1)+3*(NEWATOM-1)+1)-XYZ(3*NATOMS*(INTIMAGE+1)+3*(CONLIST(1)-1)+1))/(INTIMAGE+1)
            XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+2)=XYZ((J1-1)*3*NATOMS+3*(CONLIST(1)-1)+2)  &
 &            +(INTIMAGE-J1+2)*FRAC*(XYZ(3*(NEWATOM-1)+2)-XYZ(3*(CONLIST(1)-1)+2))/(INTIMAGE+1) &
 &   +(J1-1)*(XYZ(3*NATOMS*(INTIMAGE+1)+3*(NEWATOM-1)+2)-XYZ(3*NATOMS*(INTIMAGE+1)+3*(CONLIST(1)-1)+2))/(INTIMAGE+1)
            XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+3)=XYZ((J1-1)*3*NATOMS+3*(CONLIST(1)-1)+3)  &
 &            +(INTIMAGE-J1+2)*FRAC*(XYZ(3*(NEWATOM-1)+3)-XYZ(3*(CONLIST(1)-1)+3))/(INTIMAGE+1) &
 &   +(J1-1)*(XYZ(3*NATOMS*(INTIMAGE+1)+3*(NEWATOM-1)+3)-XYZ(3*NATOMS*(INTIMAGE+1)+3*(CONLIST(1)-1)+3))/(INTIMAGE+1)
         ENDDO
         CALL CHECKREP(INTIMAGE,XYZ,NOPT,NNREPSAVE,NREPSAVE+1) ! set up repulsive neighbour list
         IF (CHECKCONINT) THEN
            CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
         ELSE
            CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
         ENDIF
         IF (DEBUG) PRINT '(A,4G15.5)',' intlbfgs> energies for constrained, preserved, closest, and linear schemes=', &
  &                 ESAVE0,ESAVED,ESAVEC,ETOTAL
         IF ((ETOTAL.LT.ESAVEC).AND.(ETOTAL.LT.ESAVED).AND.(ETOTAL.LT.ESAVE0)) THEN
            IF (DEBUG) PRINT '(A,2G20.10)',' intlbfgs> lowest energy from linear interpolation'
         ELSE IF ((ESAVEC.LT.ESAVED).AND.(ESAVEC.LT.ESAVE0)) THEN
            IF (DEBUG) PRINT '(A,2G20.10)',' intlbfgs> lowest energy from interpolation using closest atoms'
            DO J1=2,INTIMAGE+1
               XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)=XSAVEC(1:3,J1)
            ENDDO
            ETOTAL=ESAVEC
         ELSE IF (ESAVED.LT.ESAVE0) THEN
            IF (DEBUG) PRINT '(A,2G20.10)',' intlbfgs> lowest energy from interpolation using preserved distances'
            DO J1=2,INTIMAGE+1
               XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)=XSAVED(1:3,J1)
            ENDDO
            ETOTAL=ESAVED
         ELSE 
            IF (DEBUG) PRINT '(A,2G20.10)',' intlbfgs> lowest energy from interpolation using closest constraints'
            DO J1=2,INTIMAGE+1
               XYZ((J1-1)*3*NATOMS+3*(NEWATOM-1)+1:(J1-1)*3*NATOMS+3*(NEWATOM-1)+3)=XSAVE0(1:3,J1)
            ENDDO
            ETOTAL=ESAVE0
         ENDIF
      ENDIF
      NADDED=NADDED+1
      IF (NADDED.LT.NTOADD) GOTO 542
!
! Turn frozen images off for new added atom.
!
!     IF (DEBUG) PRINT '(A)',' intlbfgs> turning off frozen images'
!     IF (FREEZENODEST) IMGFREEZE(1:INTIMAGE)=.FALSE.
      CALL CHECKREP(INTIMAGE,XYZ,NOPT,NNREPSAVE,NREPSAVE+1) ! set up repulsive neighbour list
!
! need a new gradient since the active atom has changed !
!
      IF (CHECKCONINT) THEN
         CALL CONGRAD2(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
      ELSE
         CALL CONGRAD(NMAXINT,NMININT,ETOTAL,XYZ,GGG,EEE,IMGFREEZE,RMS)
      ENDIF

END SUBROUTINE DOADDATOM

SUBROUTINE CHECKPERC(LXYZ,LINTCONSTRAINTTOL,NQCIFREEZE,NCPFIT)
USE KEY, ONLY : ATOMACTIVE, NCONSTRAINT, INTFROZEN, CONI, CONJ, CONDISTREF, INTCONMAX, INTCONSTRAINTTOL, &
  &             INTCONSEP, INTFREEZET, NCONGEOM, CONGEOM, CONIFIX, CONJFIX, CONDISTREFFIX, &
  &             NCONSTRAINTFIX, BULKT, TWOD, RIGIDBODY, CONDATT, CONCUT, CONCUTFIX
USE COMMONS, ONLY: NATOMS, DEBUG, NOPT, PARAM1, PARAM2, PARAM3
IMPLICIT NONE
INTEGER NDIST1(NATOMS), NCYCLE, DMIN1, DMAX1, NUNCON1, J1, J2, J3, NQCIFREEZE, J4, NCPFIT
DOUBLE PRECISION LINTCONSTRAINTTOL, MAXCONDIST, MINCONDIST, DS, DF, LXYZ(NOPT*2)
DOUBLE PRECISION DSMIN, DSMAX, DSMEAN, D, DIST2, RMAT(3,3)
LOGICAL CHANGED
LOGICAL :: CALLED=.FALSE.
SAVE CALLED

LINTCONSTRAINTTOL=INTCONSTRAINTTOL

IF (.NOT.ALLOCATED(ATOMACTIVE)) ALLOCATE(ATOMACTIVE(NATOMS))
!
! Fixed constraints based on congeom file entries
! Just need to adjust the list based on any frozen atoms. We
! want to exclude any constraints between two frozen atoms 
! from the list, because subsequent code depends on this.
!

IF (NCONGEOM.GE.2) THEN
   IF (CALLED.OR.CONDATT) THEN
      J2=0
      DO J1=1,NCONSTRAINTFIX
!
! If called with two minima check that CONCUTFIX is large enough to
! accommodate the separation of the two atoms in both minima.
!
         IF (NCPFIT.EQ.2) THEN
            DF=MAX(ABS(CONDISTREFFIX(J1)- &
  &                SQRT((LXYZ(3*(CONIFIX(J1)-1)+1)-LXYZ(3*(CONJFIX(J1)-1)+1))**2+ &
  &                     (LXYZ(3*(CONIFIX(J1)-1)+2)-LXYZ(3*(CONJFIX(J1)-1)+2))**2+ &
  &                     (LXYZ(3*(CONIFIX(J1)-1)+3)-LXYZ(3*(CONJFIX(J1)-1)+3))**2)),&
                   ABS(CONDISTREFFIX(J1)- &
  &                SQRT((LXYZ(NOPT+3*(CONIFIX(J1)-1)+1)-LXYZ(NOPT+3*(CONJFIX(J1)-1)+1))**2+ &
  &                     (LXYZ(NOPT+3*(CONIFIX(J1)-1)+2)-LXYZ(NOPT+3*(CONJFIX(J1)-1)+2))**2+ &
  &                     (LXYZ(NOPT+3*(CONIFIX(J1)-1)+3)-LXYZ(NOPT+3*(CONJFIX(J1)-1)+3))**2)))
            IF (DF.GT.CONCUTFIX(J1)) THEN
               IF (ABS(DF-CONCUTFIX(J1)).GT.1.0D-6) &
  &                PRINT '(A,2I5,3(A,G15.5))',' checkperc> Increasing con cutoff atoms ', &
  &                CONIFIX(J1),CONJFIX(J1),' from ',CONCUTFIX(J1),' to ',DF,' ref=',CONDISTREFFIX(J1)
               CONCUTFIX(J1)=DF
            ENDIF
         ENDIF
         IF (INTFROZEN(CONIFIX(J1)).AND.INTFROZEN(CONJFIX(J1))) CYCLE
         J2=J2+1
         CONI(J2)=CONIFIX(J1)
         CONJ(J2)=CONJFIX(J1)
         CONDISTREF(J2)=CONDISTREFFIX(J1)
         CONCUT(J2)=CONCUTFIX(J1)
      ENDDO
      NCONSTRAINT=J2
!     PRINT '(A,I6,A)',' checkperc> After allowing for frozen atoms there are ',NCONSTRAINT,' constraints'
      RETURN 
   ELSE
!
! Put reference minima in optimal permutational alignment with reference minimum one.
!
      DO J2=2,NCONGEOM
         CALL MINPERMDIST(CONGEOM(1,1:3*NATOMS),CONGEOM(J2,1:3*NATOMS),NATOMS,DEBUG, &
  &                       PARAM1,PARAM2,PARAM3,BULKT,TWOD,D,DIST2,RIGIDBODY,RMAT)
      ENDDO
   ENDIF
   ALLOCATE(CONIFIX(INTCONMAX),CONJFIX(INTCONMAX),CONCUTFIX(INTCONMAX),CONDISTREFFIX(INTCONMAX))
ENDIF

51   NCONSTRAINT=0 
MAXCONDIST=-1.0D0
MINCONDIST=1.0D100
IF (NCONGEOM.LT.2) THEN 
   DO J2=1,NATOMS
      DO J3=J2+1,NATOMS

         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A)','checkperc> doing atoms 700 and 701'
         IF (J3-J2.GT.INTCONSEP) CYCLE ! forbid constraints corresponding to atoms distant in sequence
         IF (INTFROZEN(J2).AND.INTFROZEN(J3)) CYCLE ! no constraints between intfrozen atoms
         DS=SQRT((LXYZ(3*(J2-1)+1)-LXYZ(3*(J3-1)+1))**2 &
  &             +(LXYZ(3*(J2-1)+2)-LXYZ(3*(J3-1)+2))**2 &
  &             +(LXYZ(3*(J2-1)+3)-LXYZ(3*(J3-1)+3))**2) 
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A,G20.10)','checkperc> DS=',DS
         IF (DS.GT.5.0D0) CYCLE ! don't allow constraints if either endpoint separation is too large DJW
!        IF (DS.GT.15.0D0) CYCLE ! don't allow constraints if either endpoint separation is too large DJW
         DF=SQRT((LXYZ(3*NATOMS+3*(J2-1)+1)-LXYZ(3*NATOMS+3*(J3-1)+1))**2 &
  &             +(LXYZ(3*NATOMS+3*(J2-1)+2)-LXYZ(3*NATOMS+3*(J3-1)+2))**2 &
  &             +(LXYZ(3*NATOMS+3*(J2-1)+3)-LXYZ(3*NATOMS+3*(J3-1)+3))**2) 
         IF (DF.GT.5.0D0) CYCLE ! don't allow constraints if either endpoint separation is too large DJW
!        IF (DF.GT.15.0D0) CYCLE ! don't allow constraints if either endpoint separation is too large DJW
!        IF (2.0D0*ABS(DS-DF)/(DS+DF).LT.LINTCONSTRAINTTOL) THEN
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A,G20.10)','checkperc> DF=',DF
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A,2G20.10)','checkperc> ABS(DS-DF), &
  &                                      LINTCONSTRAINTTOL=',ABS(DS-DF),LINTCONSTRAINTTOL
         IF (ABS(DS-DF).LT.LINTCONSTRAINTTOL) THEN
!
!  Add constraint for this distance to the list.
!
            NCONSTRAINT=NCONSTRAINT+1
!           PRINT '(A,2I6,A,I6)','checkperc> Adding constraint for atoms ',J2,J3,'  total=',NCONSTRAINT
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A,2I6,A,I6)','checkperc> Adding constraint for atoms ', &
  &                                                        J2,J3,'  total=',NCONSTRAINT
            IF (NCONSTRAINT.GT.INTCONMAX) CALL CONDOUBLE
            CONI(NCONSTRAINT)=J2
            CONJ(NCONSTRAINT)=J3
            CONDISTREF(NCONSTRAINT)=(DF+DS)/2.0D0
            CONCUT(NCONSTRAINT)=ABS(DF-DS)/2.0D0
            IF (CONDISTREF(NCONSTRAINT).GT.MAXCONDIST) MAXCONDIST=CONDISTREF(NCONSTRAINT)
            IF (CONDISTREF(NCONSTRAINT).LT.MINCONDIST) MINCONDIST=CONDISTREF(NCONSTRAINT)
!           IF (DEBUG) PRINT '(A,2I6,A,2F12.2,A,F12.4,A,I8)',' checkperc> constrain distance for atoms ',CONI(NCONSTRAINT), &
! &                 CONJ(NCONSTRAINT),' values are ',DS,DF,' fraction=',2*ABS(DS-DF)/(DS+DF), &
! &                ' # constraints=',NCONSTRAINT
         ENDIF
      ENDDO
   ENDDO
   IF (DEBUG) PRINT '(A,I6,2(A,F15.5))',' checkperc> Total distance constraints=',NCONSTRAINT, &
  &                                     ' shortest=',MINCONDIST,' longest=',MAXCONDIST
ELSE
   DO J2=1,NATOMS
      DO J3=J2+1,NATOMS
         IF (J3-J2.GT.INTCONSEP) CYCLE ! forbid constraints corresponding to atoms distant in sequence
         DSMIN=1.0D100
         DSMAX=-1.0D100
         DSMEAN=0.0D0
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A)','checkperc> doing atoms 700 and 701'
         DO J4=1,NCONGEOM
            DS=SQRT((CONGEOM(J4,3*(J2-1)+1)-CONGEOM(J4,3*(J3-1)+1))**2 &
  &                +(CONGEOM(J4,3*(J2-1)+2)-CONGEOM(J4,3*(J3-1)+2))**2 &
  &                +(CONGEOM(J4,3*(J2-1)+3)-CONGEOM(J4,3*(J3-1)+3))**2) 
            IF (DS.GT.DSMAX) DSMAX=DS
            IF (DS.LT.DSMIN) DSMIN=DS
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A,I6,6F20.10)','checkperc> J4,DS,DSMAX,DSMIN,abs,tol=', &
  &                      J4,DS,DSMIN,DSMAX,ABS(DSMIN-DSMAX),LINTCONSTRAINTTOL
            IF ((J4.GT.1).AND.(ABS(DSMIN-DSMAX).GT.LINTCONSTRAINTTOL)) GOTO 753 ! unconstrained
            DSMEAN=DSMEAN+DS
         ENDDO
!
!  Add constraint for this distance to the list if we make it to here.
!
         NCONSTRAINT=NCONSTRAINT+1
!        PRINT '(A,2I6,A,I6)','checkperc> Adding constraint for atoms ',J2,J3,'  total=',NCONSTRAINT
         IF ((J3.EQ.701).AND.(J2.EQ.700)) PRINT '(A,2I6,A,I6)','checkperc> Adding constraint for atoms ', &
  &                                                      J2,J3,'  total=',NCONSTRAINT
         IF (NCONSTRAINT.GT.INTCONMAX) CALL CONDOUBLE
         CONI(NCONSTRAINT)=J2
         CONJ(NCONSTRAINT)=J3
         CONDISTREF(NCONSTRAINT)=(DSMAX+DSMIN)/2.0D0 
         CONCUT(NCONSTRAINT)=(DSMAX-DSMIN)/2.0D0
         IF (CONDISTREF(NCONSTRAINT).GT.MAXCONDIST) MAXCONDIST=CONDISTREF(NCONSTRAINT)
         IF (CONDISTREF(NCONSTRAINT).LT.MINCONDIST) MINCONDIST=CONDISTREF(NCONSTRAINT)
         IF (DEBUG) PRINT '(A,2I5,A,2F10.4,A,F12.4,A,I8)', &
  &                       ' checkperc> constrain atoms ',CONI(NCONSTRAINT), &
  &                       CONJ(NCONSTRAINT),' max, min ',DSMAX,DSMIN, &
  &                       ' cutoff=',CONCUT(NCONSTRAINT),' constraints=',NCONSTRAINT
753      CONTINUE
      ENDDO
   ENDDO
   CONIFIX(1:NCONSTRAINT)=CONI(1:NCONSTRAINT)
   CONJFIX(1:NCONSTRAINT)=CONJ(1:NCONSTRAINT)
   CONDISTREFFIX(1:NCONSTRAINT)=CONDISTREF(1:NCONSTRAINT)
   CONCUTFIX(1:NCONSTRAINT)=CONCUT(1:NCONSTRAINT)
   NCONSTRAINTFIX=NCONSTRAINT
ENDIF
!
! Check that we have a percolating constraint network. If not, increase the tolerance and try again!
! Calculate minimum number of steps of each atom from number 1 or any frozen atom.
!
NDIST1(1:NATOMS)=1000000
IF (NQCIFREEZE.EQ.0) THEN
   NDIST1(1)=0
ELSE
   DO J1=1,NATOMS
      IF (INTFROZEN(J1)) NDIST1(J1)=0
   ENDDO
ENDIF
NCYCLE=0
5    CHANGED=.FALSE.
NCYCLE=NCYCLE+1
DMIN1=100000
DMAX1=0
NUNCON1=0
DO J1=1,NATOMS
   IF (NDIST1(J1).EQ.0) CYCLE ! minimum 1
   DO J2=1,NCONSTRAINT
      IF (CONI(J2).EQ.J1) THEN
         IF (NDIST1(CONJ(J2))+1.LT.NDIST1(J1)) THEN
            CHANGED=.TRUE.
            NDIST1(J1)=NDIST1(CONJ(J2))+1
         ENDIF
      ELSE IF (CONJ(J2).EQ.J1) THEN
         IF (NDIST1(CONI(J2))+1.LT.NDIST1(J1)) THEN
            CHANGED=.TRUE.
            NDIST1(J1)=NDIST1(CONI(J2))+1
         ENDIF
      ENDIF
   ENDDO
   IF ((NDIST1(J1).GT.DMAX1).AND.(NDIST1(J1).NE.1000000)) DMAX1=NDIST1(J1)
   IF (NDIST1(J1).LT.DMIN1) DMIN1=NDIST1(J1)
   IF (NDIST1(J1).EQ.1000000) NUNCON1=NUNCON1+1
ENDDO
IF (CHANGED) GOTO 5
  IF (DEBUG) PRINT '(3(A,I8))',' checkperc> steps to atom 1 converged in ',NCYCLE-1, &
    &               ' cycles; maximum=',DMAX1,' disconnected=',NUNCON1
IF (NUNCON1.GT.0) THEN
   LINTCONSTRAINTTOL=LINTCONSTRAINTTOL*1.1D0
   IF (DEBUG) PRINT '(A,F15.5)',' checkperc> increasing the local constraint tolerance parameter to ',LINTCONSTRAINTTOL
   IF (LINTCONSTRAINTTOL.GT.100.0D0) THEN
      PRINT '(A,G20.10)','checkperc> likely ERROR *** LINTCONSTRAINTTOL=',LINTCONSTRAINTTOL
      STOP
   ENDIF
   GOTO 51
ENDIF
! IF (DEBUG) PRINT '(A,F15.5)',' checkperc> Final constraint tolerance parameter ',LINTCONSTRAINTTOL

! PRINT '(A,I6,3(A,F15.5))',' checkperc> Total distance constraints=',NCONSTRAINT, &
!   &                    ' shortest=',MINCONDIST,' longest=',MAXCONDIST,' tolerance=',LINTCONSTRAINTTOL

CALLED=.TRUE.

END SUBROUTINE CHECKPERC

SUBROUTINE MAKESTEP(NITERDONE,POINT,DIAG,INTIMAGE,SEARCHSTEP,G,GTMP,STP,GDIF,NPT,D,RHO1,ALPHA)
USE KEY, ONLY : INTMUPDATE, INTDGUESS
USE COMMONS, ONLY: NATOMS, NOPT
IMPLICIT NONE
INTEGER NITERDONE, POINT, BOUND, NPT, D, CP, INTIMAGE, I
DOUBLE PRECISION DIAG(3*NATOMS*INTIMAGE),SEARCHSTEP(0:INTMUPDATE,NOPT*INTIMAGE),G(NOPT*INTIMAGE), &
  &  GTMP(3*NATOMS*INTIMAGE), GNORM, STP(3*NATOMS*INTIMAGE), YS, GDIF(0:INTMUPDATE,NOPT*INTIMAGE), YY, &
  &  SQ, YR, BETA
DOUBLE PRECISION, DIMENSION(INTMUPDATE)     :: RHO1,ALPHA
SAVE

MAIN: IF (NITERDONE==1) THEN
     POINT = 0
     DIAG(1:D)=INTDGUESS
     SEARCHSTEP(0,1:D)= -G(1:D)*INTDGUESS            ! NR STEP FOR DIAGONAL INVERSE HESSIAN
     GTMP(1:D)        = SEARCHSTEP(0,1:D)
     GNORM            = MAX(SQRT(DOT_PRODUCT(G(1:D),G(1:D))),1.0D-100)
     STP(1:D)         = MIN(1.0D0/GNORM, GNORM) ! MAKE THE FIRST GUESS FOR THE STEP LENGTH CAUTIOUS
ELSE MAIN
     BOUND=NITERDONE-1
     IF (NITERDONE.GT.INTMUPDATE) BOUND=INTMUPDATE
     YS=DOT_PRODUCT( GDIF(NPT/D,:), SEARCHSTEP(NPT/D,:)  )
     IF (YS==0.0D0) YS=1.0D0
    
! Update estimate of diagonal inverse Hessian elements.
! We divide by both YS and YY at different points, so they had better not be zero!

     YY=DOT_PRODUCT( GDIF(NPT/D,:) , GDIF(NPT/D,:) )
     IF (YY==0.0D0) YY=1.0D0
!    DIAG = ABS(YS/YY)
     DIAG(1) = YS/YY
      
! COMPUTE -H*G USING THE FORMULA GIVEN IN: Nocedal, J. 1980, 
! "Updating quasi-Newton matrices with limited storage",
! Mathematics of Computation, Vol.35, No.151, pp. 773-782

     CP= POINT; IF (POINT==0) CP = INTMUPDATE
     RHO1(CP)=1.0D0/YS
     GTMP(1:D) = -G(1:D)
     CP= POINT 
                   
     DO I= 1,BOUND 
          CP = CP - 1; IF (CP == -1) CP = INTMUPDATE - 1
          SQ= DOT_PRODUCT( SEARCHSTEP(CP,1:D),GTMP(1:D) )
          ALPHA(CP+1) = RHO1(CP+1) * SQ
          GTMP(1:D)        = -ALPHA(CP+1)*GDIF(CP,1:D) + GTMP(1:D)
     ENDDO
              
     GTMP(1:D)=DIAG(1)*GTMP(1:D)

     DO I=1,BOUND
          YR= DOT_PRODUCT( GDIF(CP,1:D) , GTMP )
          BETA= RHO1(CP+1)*YR
          BETA= ALPHA(CP+1)-BETA
          GTMP(1:D) = BETA*SEARCHSTEP(CP,1:D) + GTMP(1:D)
          CP=CP+1
!         IF (CP==M) CP=0
          IF (CP==INTMUPDATE) CP=0
     ENDDO
              
     STP(1:D) = 1.0D0
ENDIF MAIN

!  Store the new search direction
IF (NITERDONE.GT.1) SEARCHSTEP(POINT,1:D)=GTMP(1:D)

END SUBROUTINE MAKESTEP


SUBROUTINE MAKEINTNEBIMAGES(NIMAGE,INTIMAGE,DINCREMENT,QCIDIST1,QCIDIST4,XYZ)
USE COMMONS, ONLY: NATOMS, NOPT, DEBUG
USE KEY, ONLY : INTNEBIMAGES
IMPLICIT NONE
INTEGER NDONE, J2, NIMAGE, INTIMAGE, J5
DOUBLE PRECISION LDTOTAL, LDIST, LDUMMY, DINCREMENT, QCIDIST1, QCIDIST4, XYZ(NOPT*(INTIMAGE+2))

ALLOCATE(INTNEBIMAGES(NIMAGE*NOPT))
!
! Initialise DNEB images at QCIDIST1+1*(QCIDIST4-QCIDIST1)/(NIMAGE+1),
!                           QCIDIST1+2*(QCIDIST4-QCIDIST1)/(NIMAGE+1),
!                              .     .     .    .    .    .    .
!                           QCIDIST1+NIMAGE*(QCIDIST4-QCIDIST1)/(NIMAGE+1)
!
LDTOTAL=0.0D0
NDONE=1
imageloop1: DO J2=1,INTIMAGE+1
   LDUMMY=0.0D0
   DO J5=1,3*NATOMS
      LDUMMY=LDUMMY+( XYZ((J2-1)*3*NATOMS+J5) - XYZ(J2*3*NATOMS+J5) )**2
   ENDDO
   LDUMMY=SQRT(LDUMMY)
   LDIST=0.0D0
   DO WHILE (LDIST.LE.LDUMMY)
      LDIST=LDIST+DINCREMENT
      IF (LDIST+LDTOTAL.GE.QCIDIST1+NDONE*(QCIDIST4-QCIDIST1)/(NIMAGE+1)) THEN
         INTNEBIMAGES(NOPT*(NDONE-1)+1:NOPT*NDONE)=((LDUMMY-LDIST)*XYZ((J2-1)*3*NATOMS+1:J2*3*NATOMS)+ &
  &                                                          LDIST*XYZ(J2*3*NATOMS+1:(J2+1)*3*NATOMS))/LDUMMY
         IF (DEBUG) PRINT '(A,F20.10,A,I6)',' intlbfgs> image made for distance LDIST+LDTOTAL=',LDIST+LDTOTAL,' NDONE=',NDONE
         NDONE=NDONE+1
         IF (NDONE.GT.NIMAGE) EXIT imageloop1
      ENDIF
   ENDDO
   LDTOTAL=LDTOTAL+LDUMMY
ENDDO imageloop1

END SUBROUTINE MAKEINTNEBIMAGES

SUBROUTINE MAKEINTNEBIMAGES2(NIMAGE,INTIMAGE,DINCREMENT,QCIDIST1,QCIDIST4,XYZ)
USE COMMONS, ONLY: NATOMS, NOPT, DEBUG
USE KEY, ONLY : INTNEBIMAGES
IMPLICIT NONE
INTEGER NDONE, J2, NIMAGE, INTIMAGE, J5, LUNIT, GETUNIT
DOUBLE PRECISION LDTOTAL, LDIST, LDUMMY, DINCREMENT, QCIDIST1, QCIDIST4, XYZ(NOPT*(INTIMAGE+2))
DOUBLE PRECISION EREAL, VNEW(3*NATOMS), RMS

NIMAGE=2*INTIMAGE+1
ALLOCATE(INTNEBIMAGES(NIMAGE*NOPT))
!
! Initialise DNEB images at all the interpolation images plus 
! bisectors.
!
NDONE=1
imageloop1: DO J2=1,INTIMAGE
   INTNEBIMAGES(NOPT*(NDONE-1)+1:NOPT*NDONE)=(XYZ((J2-1)*3*NATOMS+1:J2*3*NATOMS) &
  &                                          +XYZ(J2*3*NATOMS+1:(J2+1)*3*NATOMS))/2.0D0
   NDONE=NDONE+1
   INTNEBIMAGES(NOPT*(NDONE-1)+1:NOPT*NDONE)=XYZ(J2*3*NATOMS+1:(J2+1)*3*NATOMS)
   NDONE=NDONE+1
ENDDO imageloop1

INTNEBIMAGES(NOPT*(NDONE-1)+1:NOPT*NDONE)=(XYZ(INTIMAGE*3*NATOMS+1:(INTIMAGE+1)*3*NATOMS) &
  &                                       +XYZ((INTIMAGE+1)*3*NATOMS+1:(INTIMAGE+2)*3*NATOMS))/2.0D0

CLOSE(LUNIT)

END SUBROUTINE MAKEINTNEBIMAGES2
