MODULE GENRIGID

      INTEGER :: NRIGIDBODY, DEGFREEDOMS, MAXSITE, NRELAXRIGIDR, NRELAXRIGIDA
      INTEGER :: XNATOMS
      INTEGER, ALLOCATABLE :: NSITEPERBODY(:), REFVECTOR(:), RIGIDSINGLES(:)
      INTEGER, ALLOCATABLE, DIMENSION (:,:) :: RIGIDGROUPS
      DOUBLE PRECISION, ALLOCATABLE :: RIGIDCOORDS(:)
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:,:) :: SITESRIGIDBODY
      DOUBLE PRECISION, ALLOCATABLE :: GR_WEIGHTS(:) ! weights for com calculation, e.g. masses
      LOGICAL :: RIGIDINIT, ATOMRIGIDCOORDT, RELAXRIGIDT
      LOGICAL :: GENRIGIDT

      LOGICAL :: RIGIDOPTIMROTAT, FREEZERIGIDBODYT
      DOUBLE PRECISION :: OPTIMROTAVALUES(3)

      INTEGER, ALLOCATABLE :: LRBNPERMGROUP(:), LRBNPERMSIZE(:,:), LRBPERMGROUP(:,:), LRBNSETS(:,:), LRBSETS(:,:,:)

!   vr274:  added lattice coordinates
!           if HAS_LATTICE_COORDS is true, the last two atoms are treated
!           as lattice coordintes and rigidcoords is in reduced lattice units
      LOGICAL HAS_LATTICE_COORDS

!-----------------------------------------------------------------------------------!
! NRIGIDBODY  = number of rigid bodies
! DEGFREEDOMS = number of degrees of freedom = 6 * NRIGIDBODY + 3 * ADDITIONAL ATOMS
! MAXSITE     = maximum number of sites in a rigid body
! NRELAXRIGIDR = rigid body minimisation for this number of steps
! NRELAXRIGIDA = atom minimisation for this number of steps
! NSITEPERBODY= number of rigid body sites, no need to be the same for all bodies
! REFVECTOR   = reference vector for the atomistic to rigic coordinate transformation
! RIGIDSINGLES= list of atoms not in rigid bodies
! RIGIDGROUPS = list of atoms in rigid bodies, need a file called rbodyconfig
! RIGIDCOORDS = 6 * NRIGIDBODY + 3 * ADDITIONAL ATOMS coordinates
! SITESRIGIDBODY = coordinates of the rigid body sites
! RIGIDINIT   = logical variable for generalised rigid body
! ATOMRIGIDCOORDT, .TRUE. = atom coords active, .FALSE. = rigid coords active, used in mylbfgs & potential
! GENRIGIDT = generalised rigid body takestep taken if .TRUE.
!-----------------------------------------------------------------------------------!


CONTAINS
! vr274> TODO: better initialization of SITESRIDIGBODY, why use maxsite?

!-------------------------------------------
! vr274> Initializes basic structures
! hast to be the first call to GENRIGID function in order to setup basic structures.
! After that, the array which defines the sites can be filled. Then GENRIGID_INITIALIZE
! completes the initialization of rigid bodies.
!-------------------------------------------
SUBROUTINE GENRIGID_ALLOCATE(NEW_NRIGIDBODY,NEW_MAXSITE)
  USE COMMONS, only: NATOMS
! hk286
  USE MODAMBER9, ONLY : ATMASS1

  IMPLICIT NONE
  INTEGER, intent(in) :: NEW_NRIGIDBODY, NEW_MAXSITE
  
  NRIGIDBODY = NEW_NRIGIDBODY
  MAXSITE = NEW_MAXSITE

  ! hk286 > Allocate NSITEPERBODY
  ALLOCATE (NSITEPERBODY(NRIGIDBODY))
  ALLOCATE (SITESRIGIDBODY(MAXSITE,3,NRIGIDBODY))
  ALLOCATE (RIGIDGROUPS(MAXSITE,NRIGIDBODY))
  ALLOCATE (REFVECTOR(NRIGIDBODY))
  ALLOCATE (GR_WEIGHTS(NATOMS))

  ! by default use center of geometry - check if ok for AMBER 9/8/12
  IF ( ALLOCATED(ATMASS1) ) THEN
     GR_WEIGHTS=ATMASS1
  ELSE
     GR_WEIGHTS=1.0D0
  ENDIF

END SUBROUTINE

!-------------------------------------------
! vr274> Setup rigid body stuff after site definitions are done
!-------------------------------------------
SUBROUTINE GENRIGID_INITIALISE(INICOORDS)
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE
  INTEGER :: J1, J2, J3, DUMMY
  DOUBLE PRECISION :: XMASS, YMASS, ZMASS, PNORM, MASS
  LOGICAL :: SATOMT, RTEST
  DOUBLE PRECISION :: P(3), RMI(3,3), DRMI1(3,3), DRMI2(3,3), DRMI3(3,3)
  DOUBLE PRECISION INICOORDS(3*NATOMS)
  
! vr275> initialize coordinates for rigid bodies
  DO J1 = 1, NRIGIDBODY
     DO J2 = 1, NSITEPERBODY(J1)
        DUMMY=RIGIDGROUPS(J2,J1)
        SITESRIGIDBODY(J2,:,J1) = INICOORDS(3*DUMMY-2:3*DUMMY)
     ENDDO
  ENDDO

  ! hk286 > determine number of degrees of freedom
  DEGFREEDOMS = 0
  DO J1 = 1, NRIGIDBODY
     DEGFREEDOMS = DEGFREEDOMS + NSITEPERBODY(J1)
  ENDDO
  DEGFREEDOMS = 6 * NRIGIDBODY + 3 * (NATOMS - DEGFREEDOMS)

! hk286 > Allocate further data 
  ALLOCATE (RIGIDSINGLES((DEGFREEDOMS/3 - 2 * NRIGIDBODY)))
  ALLOCATE (RIGIDCOORDS(DEGFREEDOMS))

  DUMMY = 0
  DO J1 = 1, NATOMS
     SATOMT = .TRUE.
     DO J2 = 1, NRIGIDBODY
        DO J3 = 1, NSITEPERBODY(J2)
           IF (J1 == RIGIDGROUPS(J3,J2)) SATOMT = .FALSE.
        ENDDO
     ENDDO
     IF (SATOMT) THEN
        DUMMY = DUMMY + 1
        RIGIDSINGLES(DUMMY) = J1
     ENDIF
  ENDDO
  
  DO J1 = 1, NRIGIDBODY
     XMASS = 0.0D0
     YMASS = 0.0D0
     ZMASS = 0.0D0
     MASS = 0.0d0
     DO J2 = 1, NSITEPERBODY(J1)
        XMASS = XMASS + SITESRIGIDBODY(J2,1,J1)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        YMASS = YMASS + SITESRIGIDBODY(J2,2,J1)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        ZMASS = ZMASS + SITESRIGIDBODY(J2,3,J1)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        MASS  = MASS + GR_WEIGHTS(RIGIDGROUPS(J2,J1))
     ENDDO
     XMASS = XMASS / MASS
     YMASS = YMASS / MASS
     ZMASS = ZMASS / MASS
     DO J2 = 1, NSITEPERBODY(J1)
        SITESRIGIDBODY(J2,1,J1) = SITESRIGIDBODY(J2,1,J1) - XMASS
        SITESRIGIDBODY(J2,2,J1) = SITESRIGIDBODY(J2,2,J1) - YMASS
        SITESRIGIDBODY(J2,3,J1) = SITESRIGIDBODY(J2,3,J1) - ZMASS
     ENDDO

  ENDDO

!  PRINT *, SITESRIGIDBODY
  
! hk286 > make sure the two atoms used as reference for rigid bodies are suitable
! Checks: (1) Atoms 1 and 2 do not sit on COM, and (2) Vector 1 and 2 are not parallel
  
  DO J1 = 1, NRIGIDBODY
     REFVECTOR(J1) = 1
     RTEST = .TRUE.
     DO WHILE (RTEST)
        RTEST = .FALSE.
        DO J2 = REFVECTOR(J1), REFVECTOR(J1) + 1 
           PNORM = SQRT(DOT_PRODUCT(SITESRIGIDBODY(J2,:,J1),SITESRIGIDBODY(J2,:,J1)))
           IF ( (PNORM  < 0.001) .AND. (PNORM > -0.001)) THEN
              RTEST = .TRUE.
           ENDIF
        ENDDO
        PNORM = DOT_PRODUCT(SITESRIGIDBODY(REFVECTOR(J1),:,J1),SITESRIGIDBODY(REFVECTOR(J1)+1,:,J1)) 
        PNORM = PNORM / SQRT(DOT_PRODUCT(SITESRIGIDBODY(REFVECTOR(J1),:,J1),SITESRIGIDBODY(REFVECTOR(J1),:,J1))) 
        PNORM = PNORM / SQRT(DOT_PRODUCT(SITESRIGIDBODY(REFVECTOR(J1)+1,:,J1),SITESRIGIDBODY(REFVECTOR(J1)+1,:,J1)))
        IF (PNORM < 0.0) PNORM = -1.0D0 * PNORM
        IF ( (PNORM < 1.0 + 0.001) .AND. (PNORM > 1.0 - 0.001) ) THEN
           RTEST = .TRUE.
        ENDIF
        IF (RTEST) THEN
           REFVECTOR(J1) = REFVECTOR(J1) + 1               
        ENDIF
     ENDDO
  ENDDO


! hk286 - new 7/1/12
  IF (RIGIDOPTIMROTAT .EQV. .TRUE.) THEN
     CALL ROTATEINITIALREF ()
  ENDIF

END SUBROUTINE

!-----------------------------------------------------------
SUBROUTINE GENRIGID_READ_FROM_FILE ()
      
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE

  CHARACTER(LEN=10) CHECK1
  INTEGER :: J1, J2, DUMMY, iostatus
  DOUBLE PRECISION :: INICOORDS(3*NATOMS)

! hk286 > read atomistic coordinates
! hk286 > in future, no need for separate coordsinirigid
! hk286 > currently the input coords files vary for CHARMM, AMBER, and RIGID BODIES
  IF (NATOMS == 0) THEN
     PRINT *, "ERROR STOP NOW > During generalised rigid body initialisation NATOMS = 0"
     STOP
  ENDIF

! vr274 > by standard don't do lattice coordinates
  HAS_LATTICE_COORDS = .FALSE.

  OPEN(UNIT = 28, FILE = 'coordsinirigid', STATUS = 'OLD')
  DO J1 = 1, NATOMS
     READ(28, *) INICOORDS(3*J1-2), INICOORDS(3*J1-1), INICOORDS(3*J1)
  ENDDO
  CLOSE(UNIT = 28)

! hk286 > determine no of rigid bodies
  NRIGIDBODY=0
  OPEN(UNIT=222,FILE='rbodyconfig',status='old')
  DO
     READ(222,*,IOSTAT=iostatus) CHECK1
     IF (iostatus<0) THEN
        CLOSE(222)
        EXIT
     ELSE IF (TRIM(ADJUSTL(CHECK1)).EQ.'GROUP') then
        NRIGIDBODY=NRIGIDBODY+1
     ENDIF
  END DO
  CLOSE(222)
  
! hk286 > determine maximum no of rigid body sites
  MAXSITE = 0
  OPEN(UNIT=222,FILE='rbodyconfig',status='old')
  DO J1 = 1, NRIGIDBODY
     READ(222,*) CHECK1,DUMMY
     IF (MAXSITE < DUMMY) MAXSITE = DUMMY
     DO J2 = 1, DUMMY
        READ(222,*) CHECK1
     ENDDO
  ENDDO
  CLOSE(222)

!  vr274> Calling function for allocation to make more general (setup rigid bodies from code)
  CALL GENRIGID_ALLOCATE(NRIGIDBODY,MAXSITE)

! hk286 > initialise SITESRIGIDBODY, RIGIDGROUPS, RIGIDSINGLES 
  OPEN(UNIT=222,FILE='rbodyconfig',status='unknown')
  DO J1 = 1, NRIGIDBODY
     READ(222,*) CHECK1, NSITEPERBODY(J1)
     DO J2 = 1, NSITEPERBODY(J1)
        READ(222,*) RIGIDGROUPS(J2,J1)
! vr274> Moved initialization of coordinates to GENRIGID_INITIALISE, here only read the setup
!        SITESRIGIDBODY(J2,:,J1) = COORDS(3*DUMMY-2:3*DUMMY,1)
     ENDDO
  ENDDO
  CLOSE(222)

  CALL GENRIGID_INITIALISE(INICOORDS)
END SUBROUTINE GENRIGID_READ_FROM_FILE

!-----------------------------------------------------------

!-----------------------------------------------------------

SUBROUTINE TRANSFORMRIGIDTOC (CMIN, CMAX, XCOORDS, XRIGIDCOORDS)
      
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE
  
  INTEGER :: J1, J2, J5, J7, J9, NP        !NP = No of processors
  INTEGER :: CMIN, CMAX
  DOUBLE PRECISION :: P(3), RMI(3,3), DRMI1(3,3), DRMI2(3,3), DRMI3(3,3)
  DOUBLE PRECISION :: XRIGIDCOORDS(DEGFREEDOMS), XCOORDS(3*NATOMS)
  DOUBLE PRECISION :: COM(3) ! center of mass
  LOGICAL          :: GTEST !, ATOMTEST
  DOUBLE PRECISION :: MLATTICE(3,3)
  
  GTEST = .FALSE.
  NP = 1

! vr274 > are there additional lattice coordinates? If yes, setup transformation matrix
  IF(HAS_LATTICE_COORDS) THEN
    CALL GET_LATTICE_MATRIX(XRIGIDCOORDS(DEGFREEDOMS-5:DEGFREEDOMS), MLATTICE)
  ELSE ! vr274 > otherwise identity matrix
    MLATTICE = 0D0
    MLATTICE(1,1)=1d0
    MLATTICE(2,2)=1D0
    MLATTICE(3,3)=1D0
  ENDIF


  ! hk286 > coord transformations for rigid bodies CMIN to CMAX
  DO J1 = CMIN, CMAX
     J5   = 3*J1
     J7   = 3*NRIGIDBODY + J5
     P(:) = XRIGIDCOORDS(J7-2:J7)
     CALL RMDRVT(P, RMI, DRMI1, DRMI2, DRMI3, GTEST)

! vr274 > MLATTICE can have lattice transformation or be identity matrix
     COM = matmul(MLATTICE, XRIGIDCOORDS(J5-2:J5))
     DO J2 = 1,  NSITEPERBODY(J1)
        J9 = RIGIDGROUPS(J2, J1)
        XCOORDS(3*J9-2:3*J9) = COM + MATMUL(RMI(:,:),SITESRIGIDBODY(J2,:,J1))
     ENDDO
     
  ENDDO
  
! hk286 > now the single atoms
! vr274 > this copies lattice coordinates as well which is stored in last 2 atoms
  IF (DEGFREEDOMS > 6 * NRIGIDBODY) THEN
     DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
        J9 = RIGIDSINGLES(J1)
        XCOORDS(3*J9-2:3*J9) = XRIGIDCOORDS(6*NRIGIDBODY + 3*J1-2:6*NRIGIDBODY + 3*J1)
     ENDDO
  ENDIF
      
END SUBROUTINE TRANSFORMRIGIDTOC

!----------------------------------------------------------

SUBROUTINE ROTATEINITIALREF ()
IMPLICIT NONE
DOUBLE PRECISION :: P(3)
INTEGER J1

! hk286 - rotate the system - new
  P(:) = OPTIMROTAVALUES(:)
!  P(1) = -1.0D0 * 8.0D0 * ATAN(1.0D0) 
!  P(2) = 0.0D0 !4.0D0 * ATAN(1.0D0) !-(8*ATAN(1.0D0) - 5.0D0)/DSQRT(2.0D0)
!  P(3) = 0.0D0 !4.0D0 * ATAN(1.0D0)
  DO J1 = 1, NRIGIDBODY
     CALL REDEFINERIGIDREF (J1,P)
  ENDDO

END SUBROUTINE ROTATEINITIALREF

!----------------------------------------------------------

SUBROUTINE REDEFINERIGIDREF (J1,P)

  IMPLICIT NONE
  
  INTEGER :: J1, J2     !No of processor
  DOUBLE PRECISION :: P(3), RMI(3,3), DRMI1(3,3), DRMI2(3,3), DRMI3(3,3)

!  PRINT *, "REDEFINE ", J1
  CALL RMDRVT(P, RMI, DRMI1, DRMI2, DRMI3, .FALSE.)  
  DO J2 = 1, NSITEPERBODY(J1)
     SITESRIGIDBODY(J2,:,J1) = MATMUL(RMI(:,:),SITESRIGIDBODY(J2,:,J1))
  ENDDO

END SUBROUTINE REDEFINERIGIDREF

!----------------------------------------------------------

SUBROUTINE TRANSFORMCTORIGID (XCOORDS, XRIGIDCOORDS)
  USE COMMONS, ONLY: NATOMS, PARAM1,PARAM2,PARAM3 ! hk286
  USE KEY, ONLY : PERMDIST, NPERMGROUP, NPERMSIZE, PERMGROUP, NSETS, SETS
  USE VEC3
  USE ROTATIONS
  IMPLICIT NONE
  
  INTEGER :: J1, J2, J9     !No of processor
  DOUBLE PRECISION :: P(3)
  DOUBLE PRECISION :: COM(3), MASS
  DOUBLE PRECISION :: XRIGIDCOORDS (DEGFREEDOMS), XCOORDS(3*NATOMS)

! vr274 > lattice matrix and inverse
  DOUBLE PRECISION MLATTICE(3,3), MLATTICEINV(3,3)
  INTEGER NLATTICECOORDS

! hk286 - extra variables for minpermdist
  DOUBLE PRECISION :: D, DIST2, RMAT(3,3), RMATINV(3,3)
  DOUBLE PRECISION :: PP1(3*NATOMS), PP2(3*NATOMS)
  LOGICAL :: TEMPPERMDIST
  INTEGER :: TEMPNPERMGROUP, TEMPNPERMSIZE(3*NATOMS), TEMPPERMGROUP(3*NATOMS), TEMPNSETS(3*NATOMS), TEMPSETS(NATOMS,3)

! vr274 > if has lattice coordinates, setup matrices
  IF(HAS_LATTICE_COORDS) THEN
    NLATTICECOORDS=6
    CALL GET_LATTICE_MATRIX(XCOORDS(3*NATOMS-5:3*NATOMS),MLATTICE)
  ELSE
    NLATTICECOORDS=0
    MLATTICE=0
    MLATTICE(1,1)=1
    MLATTICE(2,2)=1
    MLATTICE(3,3)=1
  ENDIF
  CALL INVERT3X3(MLATTICE, MLATTICEINV)

  IF (PERMDIST) THEN
     TEMPNPERMGROUP = NPERMGROUP
     TEMPNPERMSIZE(:) = NPERMSIZE(:)
     TEMPPERMGROUP(:) = PERMGROUP(:)
     TEMPNSETS(:) = NSETS(:)
     TEMPSETS(:,:) = SETS(:,:)
  ENDIF

! loop over all rigid bodies
  DO J1 = 1, NRIGIDBODY
     COM = 0.0D0
     MASS = 0.0D0
     ! calculate center of mass
     DO J2 = 1, NSITEPERBODY(J1)
        J9 = RIGIDGROUPS(J2, J1)
        COM = COM + XCOORDS(3*J9-2:3*J9)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        MASS = MASS + GR_WEIGHTS(RIGIDGROUPS(J2,J1))
     ENDDO
     COM = COM / MASS
     XRIGIDCOORDS(3*J1-2:3*J1) = COM

     DO J2 = 1, NSITEPERBODY(J1)
        J9 = RIGIDGROUPS(J2, J1)
        PP1(3*J2-2:3*J2) = XCOORDS(3*J9-2:3*J9) - COM
        PP2(3*J2-2:3*J2) = SITESRIGIDBODY(J2,:,J1)
     ENDDO

     IF (PERMDIST) THEN
        NPERMGROUP = LRBNPERMGROUP(J1)
        NPERMSIZE(:) = LRBNPERMSIZE(J1,:)
        PERMGROUP(:) = LRBPERMGROUP(J1,:)
        NSETS(:) = LRBNSETS(J1,:)
        SETS(:,:) = LRBSETS(J1,:,:)
     ENDIF

     CALL MINPERMDIST(PP2(1:3*NSITEPERBODY(J1)),PP1(1:3*NSITEPERBODY(J1)),NSITEPERBODY(J1),.FALSE., &
          PARAM1,PARAM2,PARAM3,.FALSE.,.FALSE.,D,DIST2,.FALSE.,RMAT)
     RMATINV(1,1:3) = RMAT(1:3,1)
     RMATINV(2,1:3) = RMAT(1:3,2)
     RMATINV(3,1:3) = RMAT(1:3,3)
     XRIGIDCOORDS(3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1) = rot_mx2aa(RMATINV)

     IF ( D/NSITEPERBODY(J1) > 0.1D0 ) THEN
        PRINT *,  'Warning: Genrigid > mapping looks bad for RB no ', J1 
        PRINT *,  'Warning: Genrigid > average deviation per particle is', D/NSITEPERBODY(J1)
        PRINT *,  'Warning: Genrigid >  Often it is the permutation of the RB members, e.g. Hs in NH3'
        PRINT *,  'Warning: Genrigid >  Use perm.allow'
     ENDIF

  ENDDO

  IF (PERMDIST) THEN
     NPERMGROUP = TEMPNPERMGROUP
     NPERMSIZE(:) = TEMPNPERMSIZE(:)
     PERMGROUP(:) = TEMPPERMGROUP(:)
     NSETS(:) = TEMPNSETS(:)
     SETS(:,:) = TEMPSETS(:,:)
  ENDIF

! vr274> now translate everything to reduced units
  DO J1 = 1, NRIGIDBODY
    XRIGIDCOORDS(3*J1-2:3*J1) = MATMUL(MLATTICEINV, XRIGIDCOORDS(3*J1-2:3*J1))
  END DO

! hk286 > now the single atoms
  IF (DEGFREEDOMS > 6 * NRIGIDBODY) THEN
     DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY - NLATTICECOORDS)/3
        J9 = RIGIDSINGLES(J1)
        ! vr274 > added lattice stuff
        XRIGIDCOORDS(6*NRIGIDBODY + 3*J1-2:6*NRIGIDBODY + 3*J1) = MATMUL(MLATTICEINV, XCOORDS(3*J9-2:3*J9))
     ENDDO
  ENDIF

! vr274 > copy lattice coords
  IF(HAS_LATTICE_COORDS) THEN
    XRIGIDCOORDS(DEGFREEDOMS - 5:DEGFREEDOMS) =  XCOORDS(3*NATOMS-5:3*NATOMS)
  ENDIF

END SUBROUTINE TRANSFORMCTORIGID

!-----------------------------------------------------------

SUBROUTINE TRANSFORMGRAD (G, XR, GR)
  
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE
  
  INTEGER          :: J1, J2, J9
  DOUBLE PRECISION :: G(3*NATOMS), XR(DEGFREEDOMS), GR(DEGFREEDOMS)
  DOUBLE PRECISION :: PI(3)
  DOUBLE PRECISION :: DR1(3),DR2(3),DR3(3) 
  DOUBLE PRECISION :: RMI(3,3), DRMI1(3,3), DRMI2(3,3), DRMI3(3,3)
  LOGICAL :: GTEST
  INTEGER :: NLATTICECOORDS
  DOUBLE PRECISION :: MLATTICE(3,3)
  
  NLATTICECOORDS=0
  IF(HAS_LATTICE_COORDS) THEN
      NLATTICECOORDS=6
  ENDIF

  GTEST = .TRUE.
  GR(:) = 0.0D0
  
  DO J1 = 1, NRIGIDBODY
     
     PI = XR(3*NRIGIDBODY+3*J1-2 : 3*NRIGIDBODY+3*J1)
     CALL RMDRVT(PI, RMI, DRMI1, DRMI2, DRMI3, GTEST)
     
     DO J2 = 1, NSITEPERBODY(J1)
        J9 = RIGIDGROUPS(J2, J1)

! hk286 > translation
        GR(3*J1-2:3*J1) = GR(3*J1-2:3*J1) + G(3*J9-2:3*J9)
        
! hk286 > rotation
        DR1(:) = MATMUL(DRMI1,SITESRIGIDBODY(J2,:,J1))
        DR2(:) = MATMUL(DRMI2,SITESRIGIDBODY(J2,:,J1))
        DR3(:) = MATMUL(DRMI3,SITESRIGIDBODY(J2,:,J1))
        GR(3*NRIGIDBODY+3*J1-2) = GR(3*NRIGIDBODY+3*J1-2) + DOT_PRODUCT(G(3*J9-2:3*J9),DR1(:))
        GR(3*NRIGIDBODY+3*J1-1) = GR(3*NRIGIDBODY+3*J1-1) + DOT_PRODUCT(G(3*J9-2:3*J9),DR2(:))
        GR(3*NRIGIDBODY+3*J1)   = GR(3*NRIGIDBODY+3*J1)   + DOT_PRODUCT(G(3*J9-2:3*J9),DR3(:))
     ENDDO
  ENDDO

! hk286 - testing 6/6/12
  IF (FREEZERIGIDBODYT .EQV. .TRUE.) THEN
     GR(3*NRIGIDBODY-2:3*NRIGIDBODY) = 0.0D0
     GR(6*NRIGIDBODY-2:6*NRIGIDBODY) = 0.0D0
  ENDIF

! hk286 > single atoms
! vr274 > and lattice
  IF (DEGFREEDOMS > 6 * NRIGIDBODY - NLATTICECOORDS) THEN
     DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY - NLATTICECOORDS)/3
        J9 = RIGIDSINGLES(J1)
        GR(6*NRIGIDBODY + 3*J1-2:6*NRIGIDBODY + 3*J1) = G(3*J9-2:3*J9)
     ENDDO
  ENDIF

  IF(HAS_LATTICE_COORDS) THEN
      CALL GET_LATTICE_MATRIX(XR(DEGFREEDOMS-5:DEGFREEDOMS),MLATTICE)

      ! vr274> for lattice, go to reduced coordinates
      DO J1 = 1, NRIGIDBODY
          GR(3*J1-2:3*J1) =  matmul(transpose(mlattice), GR(3*J1-2:3*J1))
      ENDDO
      ! vr274> and single atoms
      IF (DEGFREEDOMS > 6 * NRIGIDBODY + NLATTICECOORDS) THEN
          DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY - NLATTICECOORDS)/3
              J2 = 6*NRIGIDBODY + 3*J1
              GR(J2-2:J2) = matmul(transpose(mlattice), GR(J2-2:J2))
          ENDDO
      ENDIF
      ! copy lattice gradient
      GR(DEGFREEDOMS-5:DEGFREEDOMS) = G(3*NATOMS-5:3*NATOMS)
  ENDIF

END SUBROUTINE TRANSFORMGRAD

!--------------------------------------------------------------

! hk286 > Often we want to check if the atoms grouped in a rigid body has moved or not
! hk286 > They should not if everything is done correctly
! hk286 > REDEFINESITEST = .FALSE. then it prints to standard output
! hk286 > REDEFINESITEST = .TRUE. then regroup atoms, SITESRIGIDBODY rewritten

SUBROUTINE CHECKSITES (REDEFINESITEST, COORDS)
      
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE

  INTEGER :: J1, J2, J3, DUMMY
  DOUBLE PRECISION :: XMASS, YMASS, ZMASS, PNORM, MASS
  DOUBLE PRECISION :: XSITESRIGIDBODY(MAXSITE,3,NRIGIDBODY)
  DOUBLE PRECISION :: COORDS(3*NATOMS)
  LOGICAL :: RTEST, REDEFINESITEST
  

  DO J1 = 1, NRIGIDBODY
     DO J2 = 1, NSITEPERBODY(J1)
        DUMMY = RIGIDGROUPS(J2,J1)
        XSITESRIGIDBODY(J2,:,J1) = COORDS(3*DUMMY-2:3*DUMMY)
     ENDDO
  ENDDO

  DO J1 = 1, NRIGIDBODY
     XMASS = 0.0D0
     YMASS = 0.0D0
     ZMASS = 0.0D0
     MASS = 0.0D0
     DO J2 = 1, NSITEPERBODY(J1)
        XMASS = XMASS + XSITESRIGIDBODY(J2,1,J1)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        YMASS = YMASS + XSITESRIGIDBODY(J2,2,J1)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        ZMASS = ZMASS + XSITESRIGIDBODY(J2,3,J1)*GR_WEIGHTS(RIGIDGROUPS(J2,J1))
        MASS = MASS + GR_WEIGHTS(RIGIDGROUPS(J2,J1))
     ENDDO
     XMASS = XMASS / MASS
     YMASS = YMASS / MASS
     ZMASS = ZMASS / MASS
     DO J2 = 1, NSITEPERBODY(J1)
        XSITESRIGIDBODY(J2,1,J1) = XSITESRIGIDBODY(J2,1,J1) - XMASS
        XSITESRIGIDBODY(J2,2,J1) = XSITESRIGIDBODY(J2,2,J1) - YMASS
        XSITESRIGIDBODY(J2,3,J1) = XSITESRIGIDBODY(J2,3,J1) - ZMASS
     ENDDO
  ENDDO
  

  IF (REDEFINESITEST) THEN
!     PRINT *, " SITES REDEFINED "
     SITESRIGIDBODY(:,:,:) = XSITESRIGIDBODY(:,:,:)

!Checks: (1) Atoms 1 and 2 do not sit on COM, and (2) Vector 1 and 2 are not parallel
  
     DO J1 = 1, NRIGIDBODY
        REFVECTOR(J1) = 1
        RTEST = .TRUE.
        DO WHILE (RTEST)
           RTEST = .FALSE.
           DO J2 = REFVECTOR(J1), REFVECTOR(J1) + 1 
              PNORM = SQRT(DOT_PRODUCT(SITESRIGIDBODY(J2,:,J1),SITESRIGIDBODY(J2,:,J1)))
              IF ( (PNORM  < 0.001) .AND. (PNORM > -0.001)) THEN
                 RTEST = .TRUE.
              ENDIF
           ENDDO
           PNORM = DOT_PRODUCT(SITESRIGIDBODY(REFVECTOR(J1),:,J1),SITESRIGIDBODY(REFVECTOR(J1)+1,:,J1)) 
           PNORM = PNORM / SQRT(DOT_PRODUCT(SITESRIGIDBODY(REFVECTOR(J1),:,J1),SITESRIGIDBODY(REFVECTOR(J1),:,J1))) 
           PNORM = PNORM / SQRT(DOT_PRODUCT(SITESRIGIDBODY(REFVECTOR(J1)+1,:,J1),SITESRIGIDBODY(REFVECTOR(J1)+1,:,J1)))
           IF (PNORM < 0.0) PNORM = -1.0D0 * PNORM
           IF ( (PNORM < 1.0 + 0.001) .AND. (PNORM > 1.0 - 0.001) ) THEN
              RTEST = .TRUE.
           ENDIF
           IF (RTEST) THEN
              REFVECTOR(J1) = REFVECTOR(J1) + 1               
           ENDIF
        ENDDO
     ENDDO
  ELSE
!     PRINT *, XSITESRIGIDBODY
  ENDIF

END SUBROUTINE CHECKSITES

!--------------------------------------------------------------

! vr274 > build the lattice matrix.
!         The matrix is an triangular matrix,  c vector is always perpendicular to z
SUBROUTINE GET_LATTICE_MATRIX(LATTICE_COORDS, M)
    IMPLICIT NONE
    DOUBLE PRECISION, INTENT(IN) :: LATTICE_COORDS(6)
    DOUBLE PRECISION, INTENT(OUT) :: M(3,3)
    M=0
    M(1,1) = LATTICE_COORDS(1)
    M(2,1) = LATTICE_COORDS(2)
    M(3,1) = LATTICE_COORDS(3)
    M(2,2) = LATTICE_COORDS(4)
    M(3,2) = LATTICE_COORDS(5)
    M(3,3) = LATTICE_COORDS(6)
END SUBROUTINE

! vr274 > set lattice coordinates from lattice matrix.
!         The matrix is an triangular matrix,  c vector is always perpendicular to z
SUBROUTINE SET_LATTICE_MATRIX(LATTICE_COORDS, M)
    IMPLICIT NONE
    DOUBLE PRECISION, INTENT(OUT) :: LATTICE_COORDS(6)
    DOUBLE PRECISION, INTENT(IN) :: M(3,3)

    LATTICE_COORDS(1) = M(1,1)
    LATTICE_COORDS(2) = M(2,1)
    LATTICE_COORDS(3) = M(3,1)
    LATTICE_COORDS(4) = M(2,2)
    LATTICE_COORDS(5) = M(3,2)
    LATTICE_COORDS(6) = M(3,3)
END SUBROUTINE

!--------------------------------------------------------------

SUBROUTINE GENRIGID_IMAGE_CTORIGID(NIMAGE, XYZ)

  USE COMMONS, only: NATOMS
  IMPLICIT NONE
  
  INTEGER :: I, NIMAGE, NOPT 
  DOUBLE PRECISION :: XCOORDS(3*NATOMS), XRIGIDCOORDS (DEGFREEDOMS)
  DOUBLE PRECISION :: XYZ(3*NATOMS*(NIMAGE+2))

  NOPT = 3*NATOMS
  DO I=1,NIMAGE+2
     XCOORDS(1:NOPT)=XYZ(NOPT*(I-1)+1:NOPT*I)
     CALL TRANSFORMCTORIGID (XCOORDS, XRIGIDCOORDS)
     XYZ(NOPT*(I-1)+1:NOPT*(I-1)+DEGFREEDOMS) = XRIGIDCOORDS(1:DEGFREEDOMS)
     XYZ(NOPT*(I-1)+DEGFREEDOMS+1:NOPT*(I-1)+NOPT) = 0.0D0
  ENDDO

END SUBROUTINE

SUBROUTINE GENRIGID_IMAGE_RIGIDTOC(NIMAGE, XYZ)

  USE COMMONS, only: NATOMS
  IMPLICIT NONE
  
  INTEGER :: I, NIMAGE, NOPT
  DOUBLE PRECISION :: XCOORDS(3*NATOMS), XRIGIDCOORDS (DEGFREEDOMS)
  DOUBLE PRECISION :: XYZ(3*NATOMS*(NIMAGE+2))

  NOPT = 3*NATOMS
  DO I=1,NIMAGE+2
     XRIGIDCOORDS(1:DEGFREEDOMS) = XYZ( NOPT*(I-1)+1:NOPT*(I-1)+DEGFREEDOMS )
     CALL TRANSFORMRIGIDTOC (1, NRIGIDBODY, XCOORDS, XRIGIDCOORDS)
     XYZ(NOPT*(I-1)+1:NOPT*I) = XCOORDS(1:NOPT)
  ENDDO

END SUBROUTINE

!-----------------------------------------------------------

SUBROUTINE TRANSFORMHESSIAN (H, G, XR, HR, RBAANORMALMODET)
  
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE
  
  INTEGER          :: J1, J2, J3, J4, J8, J9, K, L
  DOUBLE PRECISION :: G(3*NATOMS), H(3*NATOMS,3*NATOMS)
  DOUBLE PRECISION :: XR(DEGFREEDOMS), HR(DEGFREEDOMS,DEGFREEDOMS)
  DOUBLE PRECISION :: PI(3)
  DOUBLE PRECISION :: AD2R11(3),AD2R22(3),AD2R33(3),AD2R12(3),AD2R23(3),AD2R31(3) 
  DOUBLE PRECISION :: ADR1(3),ADR2(3),ADR3(3) 
  DOUBLE PRECISION :: ARMI(3,3), ADRMI1(3,3), ADRMI2(3,3), ADRMI3(3,3)
  DOUBLE PRECISION :: AD2RMI11(3,3), AD2RMI22(3,3), AD2RMI33(3,3)
  DOUBLE PRECISION :: AD2RMI12(3,3), AD2RMI23(3,3), AD2RMI31(3,3)
  DOUBLE PRECISION :: BDR1(3),BDR2(3),BDR3(3) 
  DOUBLE PRECISION :: BRMI(3,3), BDRMI1(3,3), BDRMI2(3,3), BDRMI3(3,3)
  DOUBLE PRECISION :: BD2RMI11(3,3), BD2RMI22(3,3), BD2RMI33(3,3)
  DOUBLE PRECISION :: BD2RMI12(3,3), BD2RMI23(3,3), BD2RMI31(3,3)
  LOGICAL :: GTEST, STEST, RBAANORMALMODET
  DOUBLE PRECISION :: RMI0(3,3), DRMI10(3,3), DRMI20(3,3), DRMI30(3,3)
  DOUBLE PRECISION :: D2RMI10(3,3), D2RMI20(3,3), D2RMI30(3,3), D2RMI120(3,3), D2RMI230(3,3), D2RMI310(3,3)
  
  GTEST = .TRUE.
  STEST = .TRUE.
  HR(:,:) = 0.0D0

  IF ( RBAANORMALMODET ) THEN
     PI = (/0.0D0, 0.0D0, 0.0D0/)
     CALL RMDFAS(PI, RMI0, DRMI10, DRMI20, DRMI30, D2RMI10, D2RMI20, D2RMI30, D2RMI120, D2RMI230, D2RMI310, GTEST, STEST)
  ENDIF

  DO J1 = 1, NRIGIDBODY

     PI = XR(3*NRIGIDBODY+3*J1-2 : 3*NRIGIDBODY+3*J1)
     CALL RMDFAS(PI, ARMI, ADRMI1, ADRMI2, ADRMI3, AD2RMI11, AD2RMI22, AD2RMI33, AD2RMI12, AD2RMI23, AD2RMI31, GTEST, STEST)
    
     DO J2 = J1, NRIGIDBODY
        
        PI = XR(3*NRIGIDBODY+3*J2-2 : 3*NRIGIDBODY+3*J2)
        CALL RMDFAS(PI, BRMI, BDRMI1, BDRMI2, BDRMI3, BD2RMI11, BD2RMI22, BD2RMI33, BD2RMI12, BD2RMI23, BD2RMI31, GTEST, STEST)
        
        DO J3 = 1, NSITEPERBODY(J1)
           J8 = RIGIDGROUPS(J3, J1)

           DO J4 = 1, NSITEPERBODY(J2)
              J9 = RIGIDGROUPS(J4, J2)
                            
! hk286 > translation
              HR(3*J1-2:3*J1, 3*J2-2:3*J2) = HR(3*J1-2:3*J1, 3*J2-2:3*J2) + H(3*J8-2:3*J8, 3*J9-2:3*J9)

! hk286 > rotations
              IF ( RBAANORMALMODET ) THEN
                 ADR1(:) = MATMUL(DRMI10,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 ADR2(:) = MATMUL(DRMI20,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 ADR3(:) = MATMUL(DRMI30,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 BDR1(:) = MATMUL(DRMI10,MATMUL(BRMI,SITESRIGIDBODY(J4,:,J2)))
                 BDR2(:) = MATMUL(DRMI20,MATMUL(BRMI,SITESRIGIDBODY(J4,:,J2)))
                 BDR3(:) = MATMUL(DRMI30,MATMUL(BRMI,SITESRIGIDBODY(J4,:,J2)))
              ELSE
                 ADR1(:) = MATMUL(ADRMI1,SITESRIGIDBODY(J3,:,J1))
                 ADR2(:) = MATMUL(ADRMI2,SITESRIGIDBODY(J3,:,J1))
                 ADR3(:) = MATMUL(ADRMI3,SITESRIGIDBODY(J3,:,J1))
                 BDR1(:) = MATMUL(BDRMI1,SITESRIGIDBODY(J4,:,J2))
                 BDR2(:) = MATMUL(BDRMI2,SITESRIGIDBODY(J4,:,J2))
                 BDR3(:) = MATMUL(BDRMI3,SITESRIGIDBODY(J4,:,J2))
              ENDIF

! hk286 - mixed translation rotation
              HR(3*J1-2, 3*NRIGIDBODY+3*J2-2)=HR(3*J1-2, 3*NRIGIDBODY+3*J2-2)+DOT_PRODUCT(H(3*J8-2, 3*J9-2:3*J9),BDR1(:))
              HR(3*J1-1, 3*NRIGIDBODY+3*J2-2)=HR(3*J1-1, 3*NRIGIDBODY+3*J2-2)+DOT_PRODUCT(H(3*J8-1, 3*J9-2:3*J9),BDR1(:))
              HR(3*J1  , 3*NRIGIDBODY+3*J2-2)=HR(3*J1  , 3*NRIGIDBODY+3*J2-2)+DOT_PRODUCT(H(3*J8  , 3*J9-2:3*J9),BDR1(:))
              HR(3*J1-2, 3*NRIGIDBODY+3*J2-1)=HR(3*J1-2, 3*NRIGIDBODY+3*J2-1)+DOT_PRODUCT(H(3*J8-2, 3*J9-2:3*J9),BDR2(:))
              HR(3*J1-1, 3*NRIGIDBODY+3*J2-1)=HR(3*J1-1, 3*NRIGIDBODY+3*J2-1)+DOT_PRODUCT(H(3*J8-1, 3*J9-2:3*J9),BDR2(:))
              HR(3*J1  , 3*NRIGIDBODY+3*J2-1)=HR(3*J1  , 3*NRIGIDBODY+3*J2-1)+DOT_PRODUCT(H(3*J8  , 3*J9-2:3*J9),BDR2(:))
              HR(3*J1-2, 3*NRIGIDBODY+3*J2  )=HR(3*J1-2, 3*NRIGIDBODY+3*J2  )+DOT_PRODUCT(H(3*J8-2, 3*J9-2:3*J9),BDR3(:))
              HR(3*J1-1, 3*NRIGIDBODY+3*J2  )=HR(3*J1-1, 3*NRIGIDBODY+3*J2  )+DOT_PRODUCT(H(3*J8-1, 3*J9-2:3*J9),BDR3(:))
              HR(3*J1  , 3*NRIGIDBODY+3*J2  )=HR(3*J1  , 3*NRIGIDBODY+3*J2  )+DOT_PRODUCT(H(3*J8  , 3*J9-2:3*J9),BDR3(:))        
              
              IF (J2 > J1) THEN
                 HR(3*J2-2, 3*NRIGIDBODY+3*J1-2) = HR(3*J2-2, 3*NRIGIDBODY+3*J1-2) &
                      + DOT_PRODUCT(H(3*J9-2, 3*J8-2:3*J8),ADR1(:))
                 HR(3*J2-1, 3*NRIGIDBODY+3*J1-2) = HR(3*J2-1, 3*NRIGIDBODY+3*J1-2) &
                      + DOT_PRODUCT(H(3*J9-1, 3*J8-2:3*J8),ADR1(:))
                 HR(3*J2  , 3*NRIGIDBODY+3*J1-2) = HR(3*J2  , 3*NRIGIDBODY+3*J1-2) &
                      + DOT_PRODUCT(H(3*J9  , 3*J8-2:3*J8),ADR1(:))
                 HR(3*J2-2, 3*NRIGIDBODY+3*J1-1) = HR(3*J2-2, 3*NRIGIDBODY+3*J1-1) &
                      + DOT_PRODUCT(H(3*J9-2, 3*J8-2:3*J8),ADR2(:))
                 HR(3*J2-1, 3*NRIGIDBODY+3*J1-1) = HR(3*J2-1, 3*NRIGIDBODY+3*J1-1) &
                      + DOT_PRODUCT(H(3*J9-1, 3*J8-2:3*J8),ADR2(:))
                 HR(3*J2  , 3*NRIGIDBODY+3*J1-1) = HR(3*J2  , 3*NRIGIDBODY+3*J1-1) &
                      + DOT_PRODUCT(H(3*J9  , 3*J8-2:3*J8),ADR2(:))
                 HR(3*J2-2, 3*NRIGIDBODY+3*J1  ) = HR(3*J2-2, 3*NRIGIDBODY+3*J1  ) &
                      + DOT_PRODUCT(H(3*J9-2, 3*J8-2:3*J8),ADR3(:))
                 HR(3*J2-1, 3*NRIGIDBODY+3*J1  ) = HR(3*J2-1, 3*NRIGIDBODY+3*J1  ) &
                      + DOT_PRODUCT(H(3*J9-1, 3*J8-2:3*J8),ADR3(:))
                 HR(3*J2  , 3*NRIGIDBODY+3*J1  ) = HR(3*J2  , 3*NRIGIDBODY+3*J1  ) &
                      + DOT_PRODUCT(H(3*J9  , 3*J8-2:3*J8),ADR3(:))        
              ENDIF
! hk286 - double rotation
              DO K = 1, 3
                 DO L = 1, 3
                    HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-2)=HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-2)+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR1(K) * BDR1(L)
                    HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2-2)=HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2-2)+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR2(K) * BDR1(L)
                    HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2-2)=HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2-2)+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR3(K) * BDR1(L)
                    HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-1)=HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-1)+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR1(K) * BDR2(L)
                    HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2-1)=HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2-1)+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR2(K) * BDR2(L)
                    HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2-1)=HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2-1)+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR3(K) * BDR2(L)
                    HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2  )=HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2  )+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR1(K) * BDR3(L)
                    HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2  )=HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2  )+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR2(K) * BDR3(L)
                    HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2  )=HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2  )+&
                    & H(3*J8-3+K, 3*J9-3+L) * ADR3(K) * BDR3(L)   
                 ENDDO
              ENDDO
           ENDDO
           IF (J1 .EQ. J2) THEN
              IF ( RBAANORMALMODET ) THEN
                 AD2R11(:) = MATMUL(D2RMI10, MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 AD2R22(:) = MATMUL(D2RMI20, MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 AD2R33(:) = MATMUL(D2RMI30, MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 AD2R12(:) = MATMUL(D2RMI120,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 AD2R23(:) = MATMUL(D2RMI230,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
                 AD2R31(:) = MATMUL(D2RMI310,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
              ELSE
                 AD2R11(:) = MATMUL(AD2RMI11,SITESRIGIDBODY(J3,:,J1))
                 AD2R22(:) = MATMUL(AD2RMI22,SITESRIGIDBODY(J3,:,J1))
                 AD2R33(:) = MATMUL(AD2RMI33,SITESRIGIDBODY(J3,:,J1))
                 AD2R12(:) = MATMUL(AD2RMI12,SITESRIGIDBODY(J3,:,J1))
                 AD2R23(:) = MATMUL(AD2RMI23,SITESRIGIDBODY(J3,:,J1))
                 AD2R31(:) = MATMUL(AD2RMI31,SITESRIGIDBODY(J3,:,J1))
              ENDIF
              HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-2) = HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-2) &
                   + DOT_PRODUCT(G(3*J8-2:3*J8),AD2R11(:))
              HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2-1) = HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2-1) &
                   + DOT_PRODUCT(G(3*J8-2:3*J8),AD2R22(:))
              HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2  ) = HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2  ) &
                   + DOT_PRODUCT(G(3*J8-2:3*J8),AD2R33(:))
              HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-1) = HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J2-1) &
                   + DOT_PRODUCT(G(3*J8-2:3*J8),AD2R12(:))
              HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2  ) = HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J2  ) &
                   + DOT_PRODUCT(G(3*J8-2:3*J8),AD2R23(:))
              HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2-2) = HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J2-2) &
                   + DOT_PRODUCT(G(3*J8-2:3*J8),AD2R31(:))
           ENDIF
        ENDDO

        IF (J1 .EQ. J2) THEN
           HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J1-2) = HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J1-1) 
           HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J1-1) = HR(3*NRIGIDBODY+3*J1-1, 3*NRIGIDBODY+3*J1  )
           HR(3*NRIGIDBODY+3*J1-2, 3*NRIGIDBODY+3*J1  ) = HR(3*NRIGIDBODY+3*J1  , 3*NRIGIDBODY+3*J1-2)
           HR(3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1, 3*J1-2:3*J1) = &
                TRANSPOSE(HR(3*J1-2:3*J1, 3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1))
        ELSE
           HR(3*J2-2:3*J2, 3*J1-2:3*J1) = TRANSPOSE(HR(3*J1-2:3*J1, 3*J2-2:3*J2))
           HR(3*NRIGIDBODY+3*J2-2:3*NRIGIDBODY+3*J2, 3*J1-2:3*J1) = &
                TRANSPOSE(HR(3*J1-2:3*J1, 3*NRIGIDBODY+3*J2-2:3*NRIGIDBODY+3*J2))
           HR(3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1, 3*J2-2:3*J2) = &
                TRANSPOSE(HR(3*J2-2:3*J2, 3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1))
           HR(3*NRIGIDBODY+3*J2-2:3*NRIGIDBODY+3*J2, 3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1) = &
                TRANSPOSE(HR(3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1, 3*NRIGIDBODY+3*J2-2:3*NRIGIDBODY+3*J2))
        ENDIF

     ENDDO
  ENDDO

  DO J1 = 1, NRIGIDBODY

     DO J2 = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
            
        J9 = RIGIDSINGLES(J2)
        PI = XR(3*NRIGIDBODY+3*J1-2 : 3*NRIGIDBODY+3*J1)
        CALL RMDFAS(PI, ARMI, ADRMI1, ADRMI2, ADRMI3, AD2RMI11, AD2RMI22, AD2RMI33, AD2RMI12, AD2RMI23, AD2RMI31, GTEST, STEST)
        
        DO J3 = 1, NSITEPERBODY(J1)
           J8 = RIGIDGROUPS(J3, J1)
                     
! hk286 > translation
           HR(3*J1-2:3*J1, 6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2) = HR(3*J1-2:3*J1, 6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2) &
                + H(3*J8-2:3*J8, 3*J9-2:3*J9)

! hk286 > rotations
           IF ( RBAANORMALMODET ) THEN
              ADR1(:) = MATMUL(DRMI10,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
              ADR2(:) = MATMUL(DRMI20,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
              ADR3(:) = MATMUL(DRMI30,MATMUL(ARMI,SITESRIGIDBODY(J3,:,J1)))
           ELSE
              ADR1(:) = MATMUL(ADRMI1,SITESRIGIDBODY(J3,:,J1))
              ADR2(:) = MATMUL(ADRMI2,SITESRIGIDBODY(J3,:,J1))
              ADR3(:) = MATMUL(ADRMI3,SITESRIGIDBODY(J3,:,J1))
           ENDIF
           HR(3*NRIGIDBODY+3*J1-2, 6*NRIGIDBODY+3*J2-2) = HR(3*NRIGIDBODY+3*J1-2, 6*NRIGIDBODY+3*J2-2) &
                + DOT_PRODUCT(H(3*J9-2, 3*J8-2:3*J8),ADR1(:))
           HR(3*NRIGIDBODY+3*J1-2, 6*NRIGIDBODY+3*J2-1) = HR(3*NRIGIDBODY+3*J1-2, 6*NRIGIDBODY+3*J2-1) &
                + DOT_PRODUCT(H(3*J9-1, 3*J8-2:3*J8),ADR1(:))
           HR(3*NRIGIDBODY+3*J1-2, 6*NRIGIDBODY+3*J2  ) = HR(3*NRIGIDBODY+3*J1-2, 6*NRIGIDBODY+3*J2  ) &
                + DOT_PRODUCT(H(3*J9  , 3*J8-2:3*J8),ADR1(:))
           HR(3*NRIGIDBODY+3*J1-1, 6*NRIGIDBODY+3*J2-2) = HR(3*NRIGIDBODY+3*J1-1, 6*NRIGIDBODY+3*J2-2) &
                + DOT_PRODUCT(H(3*J9-2, 3*J8-2:3*J8),ADR2(:))
           HR(3*NRIGIDBODY+3*J1-1, 6*NRIGIDBODY+3*J2-1) = HR(3*NRIGIDBODY+3*J1-1, 6*NRIGIDBODY+3*J2-1) &
                + DOT_PRODUCT(H(3*J9-1, 3*J8-2:3*J8),ADR2(:))
           HR(3*NRIGIDBODY+3*J1-1, 6*NRIGIDBODY+3*J2  ) = HR(3*NRIGIDBODY+3*J1-1, 6*NRIGIDBODY+3*J2  ) &
                + DOT_PRODUCT(H(3*J9  , 3*J8-2:3*J8),ADR2(:))
           HR(3*NRIGIDBODY+3*J1  , 6*NRIGIDBODY+3*J2-2) = HR(3*NRIGIDBODY+3*J1  , 6*NRIGIDBODY+3*J2-2) &
                + DOT_PRODUCT(H(3*J9-2, 3*J8-2:3*J8),ADR3(:))
           HR(3*NRIGIDBODY+3*J1  , 6*NRIGIDBODY+3*J2-1) = HR(3*NRIGIDBODY+3*J1  , 6*NRIGIDBODY+3*J2-1) &
                + DOT_PRODUCT(H(3*J9-1, 3*J8-2:3*J8),ADR3(:))
           HR(3*NRIGIDBODY+3*J1  , 6*NRIGIDBODY+3*J2  ) = HR(3*NRIGIDBODY+3*J1  , 6*NRIGIDBODY+3*J2  ) &
                + DOT_PRODUCT(H(3*J9  , 3*J8-2:3*J8),ADR3(:))        
        ENDDO
        
        HR(6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2, 3*J1-2:3*J1) = &
             TRANSPOSE(HR(3*J1-2:3*J1, 6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2))
        HR(6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2, 3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1) = &
             TRANSPOSE(HR(3*NRIGIDBODY+3*J1-2:3*NRIGIDBODY+3*J1, 6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2))
     ENDDO
  ENDDO

  DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
     J8 = RIGIDSINGLES(J1)
     DO J2 = J1, (DEGFREEDOMS - 6*NRIGIDBODY)/3            
        J9 = RIGIDSINGLES(J2)                     
        HR(6*NRIGIDBODY+3*J1-2:6*NRIGIDBODY+3*J1, 6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2) = H(3*J8-2:3*J8, 3*J9-2:3*J9)
        HR(6*NRIGIDBODY+3*J2-2:6*NRIGIDBODY+3*J2, 6*NRIGIDBODY+3*J1-2:6*NRIGIDBODY+3*J1) = H(3*J9-2:3*J9, 3*J8-2:3*J8)
     ENDDO
  ENDDO

END SUBROUTINE TRANSFORMHESSIAN


!SUBROUTINE NABSECDER(OLDX,STEST)
!use modhess
!USE COMMONS, ONLY: NATOMS

!implicit none

!DOUBLE PRECISION :: V(3*NATOMS),ENERGY,XDUMMY(3*NATOMS),OLDX(3*NATOMS),VTEMP(2,3*NATOMS),ksi
!DOUBLE PRECISION :: XRIGIDCOORDS(DEGFREEDOMS), XCOORDS(3*NATOMS), XRIGIDGRAD(DEGFREEDOMS)
!INTEGER    :: i,j,k
!LOGICAL    :: GTEST,STEST

!ksi=0.00001D0
!XDUMMY(:)=OLDX(:)

!IF (.NOT.ALLOCATED(HESS)) ALLOCATE(HESS(3*NATOMS,3*NATOMS))
!DO i=1,DEGFREEDOMS

!   XDUMMY(i)=XDUMMY(i)-ksi 
!   XRIGIDCOORDS(1:DEGFREEDOMS) = XDUMMY(1:DEGFREEDOMS)
!   CALL TRANSFORMRIGIDTOC(1, NRIGIDBODY, XCOORDS, XRIGIDCOORDS)               
!   CALL MME(ENERGY,XCOORDS,V,1)
!   CALL TRANSFORMGRAD(V, XRIGIDCOORDS, XRIGIDGRAD)
!   VTEMP(1,1:DEGFREEDOMS)=XRIGIDGRAD(1:DEGFREEDOMS)
!!   CALL POTENTIAL (XDUMMY,ENERGY,V,.TRUE.,.FALSE.,1.0D-6,.FALSE.,.FALSE.)
!!   VTEMP(1,:)=V(:)
   
!   XDUMMY(i)=XDUMMY(i)+2.0D0*ksi   
!   XRIGIDCOORDS(1:DEGFREEDOMS) = XDUMMY(1:DEGFREEDOMS)
!   CALL TRANSFORMRIGIDTOC(1, NRIGIDBODY, XCOORDS, XRIGIDCOORDS)               
!   CALL MME(ENERGY,XCOORDS,V,1)
!   CALL TRANSFORMGRAD(V, XRIGIDCOORDS, XRIGIDGRAD)
!   VTEMP(2,1:DEGFREEDOMS)=XRIGIDGRAD(1:DEGFREEDOMS)
!!   CALL POTENTIAL (XDUMMY,ENERGY,V,.TRUE.,.FALSE.,1.0D-6,.FALSE.,.FALSE.)
!!   VTEMP(2,:)=V(:)

!   XDUMMY(i)=XDUMMY(i)-ksi 
   
!   DO j=i,DEGFREEDOMS
!      HESS(i,j)=(VTEMP(2,j)-VTEMP(1,j))/(2.0D0*ksi)
!      HESS(j,i)=HESS(i,j)
!!      PRINT *, i, j, HESS(i,j)
!!      PRINT *, VTEMP(2,j), VTEMP(1,j)
!   END DO

!END DO

!END SUBROUTINE NABSECDER


!SUBROUTINE ATOMNABSECDER(OLDX,V,STEST)
!use modhess
!USE COMMONS, ONLY: NATOMS

!implicit none

!DOUBLE PRECISION :: V(3*NATOMS),ENERGY,XDUMMY(3*NATOMS),OLDX(3*NATOMS),VTEMP(2,3*NATOMS),ksi
!INTEGER    :: i,j,k
!LOGICAL    :: GTEST,STEST

!ksi=0.0000001D0
!XDUMMY(:)=OLDX(:)

!IF (.NOT.ALLOCATED(HESS)) ALLOCATE(HESS(3*NATOMS,3*NATOMS))
!DO i=1,3*NATOMS

!   XDUMMY(i)=XDUMMY(i)-ksi 
!   CALL MME(ENERGY,XDUMMY,V,1)
!   VTEMP(1,:)=V(:)
   
!   XDUMMY(i)=XDUMMY(i)+2.0D0*ksi   
!   CALL MME(ENERGY,XDUMMY,V,1)
!   VTEMP(2,:)=V(:)

!   XDUMMY(i)=XDUMMY(i)-ksi 
   
!   DO j=i,3*NATOMS
!      HESS(i,j)=(VTEMP(2,j)-VTEMP(1,j))/(2.0D0*ksi)
!      HESS(j,i)=HESS(i,j)
!!      PRINT *, i, j, HESS(i,j)
!!      PRINT *, VTEMP(2,j), VTEMP(1,j)
!   END DO

!END DO

!XDUMMY(:)=OLDX(:)
!CALL MME(ENERGY,XDUMMY,V,1)

!END SUBROUTINE ATOMNABSECDER

!----------------------------------------------------------------------------------------------

SUBROUTINE GENRIGID_EIGENVALUES(X, ATOMMASS, DIAG, INFO)
  
  USE COMMONS
  USE MODHESS
  USE MODCHARMM
  USE KEY
  IMPLICIT NONE

  INTEGER          :: IR, IC, OFFSET, NDIM
  INTEGER          :: I, J, J1, J2, J3, J5, J8, K1, K2, ISTART, IFINISH, JSTART, JFINISH 
  DOUBLE PRECISION :: U(DEGFREEDOMS,DEGFREEDOMS), KBLOCK(3,3), KBEGNV(3), TMASS, ENERGY
  DOUBLE PRECISION :: XRIGIDCOORDS(DEGFREEDOMS), XCOORDS(3*NATOMS), G(3*NATOMS)
  DOUBLE PRECISION :: X(3*NATOMS), FRQN(DEGFREEDOMS), ATOMMASS(3*NATOMS), DIAG(3*NATOMS)
  DOUBLE PRECISION :: P(3), RMI(3,3), DRMI(3,3), DR(3)
  DOUBLE PRECISION :: KD(DEGFREEDOMS), AP(DEGFREEDOMS,DEGFREEDOMS), RMS
! the following required to call the LAPACK routine DSYEV
  INTEGER          :: INFO
  INTEGER, PARAMETER :: LWORK = 1000000 ! the dimension is set arbitrarily
  DOUBLE PRECISION :: WORK(LWORK)
  LOGICAL          :: ART

! Initialize
! hk286
  OFFSET = 3*NRIGIDBODY
  U(:,:) = 0.D0
  IR     = 0
  IC     = 0
  ART = ATOMRIGIDCOORDT

! Transform coordinates
  IF ( ATOMRIGIDCOORDT .EQV. .TRUE. ) THEN
     CALL TRANSFORMCTORIGID (X, XRIGIDCOORDS)
  ELSE
     XRIGIDCOORDS(1:DEGFREEDOMS) = X(1:DEGFREEDOMS)
  ENDIF

  DO J1 = 1, NRIGIDBODY
     
     J3 = 3*J1
     J5 = OFFSET + J3
     P  = XRIGIDCOORDS(J5-2:J5)
     KBLOCK(:,:) = 0.D0     
     CALL RMDFAS(P, RMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, .FALSE., .FALSE.)

     TMASS = 0.0D0
     DO J2 = 1, NSITEPERBODY(J1)
        J8 = RIGIDGROUPS(J2, J1)        
        DR(:)  = MATMUL(RMI(:,:),SITESRIGIDBODY(J2,:,J1))
        TMASS = TMASS + ATOMMASS(J8)
        DO I = 1, 3
           KBLOCK(I,I) = KBLOCK(I,I) + ATOMMASS(J8)*(DR(1)*DR(1) + DR(2)*DR(2) + DR(3)*DR(3))
           DO J = 1, 3    ! could have been J = 1, I; KBLOCK is a symmetric matrix
              KBLOCK(I,J) = KBLOCK(I,J) - ATOMMASS(J8)*DR(I)*DR(J)
           ENDDO
        ENDDO
     ENDDO

     CALL DSYEV('V','L',3,KBLOCK,3,KBEGNV,WORK,LWORK,INFO)
     IF (INFO /= 0) THEN
        WRITE(*,*) 'NRMLMD > Error in DSYEV with KBLOCK, INFO =', INFO
        STOP
     ENDIF

!     Construction of the matrix U
!     First: translation coordinates
     U(IR+1,IC+1) = 1.D0; U(IR+2,IC+2) = 1.D0; U(IR+3,IC+3) = 1.D0
     KD(IC+1:IC+3) = 1.D0/SQRT(TMASS)
!     Now rotational coordinates
     U(OFFSET+IR+1:OFFSET+IR+3,OFFSET+IC+1:OFFSET+IC+3) = KBLOCK(:,:) 
     KD(OFFSET+IC+1:OFFSET+IC+3) = 1.D0/SQRT(KBEGNV(:))

     IR = IR + 3
     IC = IC + 3 

  ENDDO

  DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
     J8 = RIGIDSINGLES(J1)
     U(6*NRIGIDBODY+3*J1-2,6*NRIGIDBODY+3*J1-2) = 1.D0
     U(6*NRIGIDBODY+3*J1-1,6*NRIGIDBODY+3*J1-1) = 1.D0
     U(6*NRIGIDBODY+3*J1  ,6*NRIGIDBODY+3*J1  ) = 1.D0
     KD(6*NRIGIDBODY+3*J1-2:6*NRIGIDBODY+3*J1 ) = 1.D0/SQRT(ATOMMASS(J8))     
  ENDDO

  RBAANORMALMODET = .TRUE.
  ATOMRIGIDCOORDT = .FALSE.
  XCOORDS(1:DEGFREEDOMS) = XRIGIDCOORDS(1:DEGFREEDOMS)
  XCOORDS(DEGFREEDOMS+1:3*NATOMS) = 0.0D0
  IF (ENDNUMHESS .OR. AMBERT) THEN
     CALL GENRIGID_MAKENUMHESS(XCOORDS,NATOMS,DEGFREEDOMS)
  ELSE
     CALL POTENTIAL(XCOORDS,ENERGY,G,.TRUE.,.TRUE.,RMS,.FALSE.,.FALSE.)     
  ENDIF
  RBAANORMALMODET = .FALSE.
!  ATOMRIGIDCOORDT = .TRUE.

  NDIM = DEGFREEDOMS  
  AP(:,:) = 0.D0
  DO I = 1, NDIM
     DO J = 1, I

        IF (I .LE. 2) THEN
           ISTART = 1
        ELSE
           ISTART = I-2
        ENDIF
        IF (I .GE. NDIM -2) THEN
           IFINISH = NDIM
        ELSE
           IFINISH = I+2
        ENDIF
        IF (J .LE. 2) THEN
           JSTART = 1
        ELSE
           JSTART = J-2
        ENDIF
        IF (J .GE. NDIM-2) THEN
           JFINISH = NDIM
        ELSE
           JFINISH = J+2
        ENDIF

        DO K1 = ISTART, IFINISH
           DO K2 = JSTART, JFINISH
              AP(I,J) = AP(I,J) + U(K1,I)*HESS(K1,K2)*U(K2,J)
           ENDDO
        ENDDO
        AP(I,J) = KD(I)*AP(I,J)*KD(J)
     ENDDO
  ENDDO

  IF (DUMPV) THEN
     CALL DSYEV('V','L',NDIM,AP(1:NDIM,1:NDIM),NDIM,FRQN,WORK,LWORK,INFO)
  ELSE
     CALL DSYEV('N','L',NDIM,AP(1:NDIM,1:NDIM),NDIM,FRQN,WORK,LWORK,INFO)
  ENDIF

!  call eigensort_val_asc(FRQN,AP,NDIM,NDIM)
  IF (MWVECTORS) THEN
     DO I = 1, NDIM
        IF (FRQN(I) > 0.0D0) THEN
           FRQN(I) = SQRT((FRQN(I)))*108.52
        ELSE
           FRQN(I) = -SQRT((-FRQN(I)))*108.52
        ENDIF
     ENDDO
  ENDIF

  DIAG(1:DEGFREEDOMS) = FRQN
  DIAG(DEGFREEDOMS+1:3*NATOMS) = 1.0D10

! hk286 - set the Hessian matrix to its eigenvector matrix
  HESS(1:DEGFREEDOMS,1:DEGFREEDOMS) = AP
  ATOMRIGIDCOORDT = ART

!  OPEN(UNIT = 28, FILE = 'LRBNORMALMODES')
!  WRITE(28, *) ENERGY, 3*NATOMS, DEGFREEDOMS
!  DO J1 = 3, DEGFREEDOMS/3
!     WRITE(28, *) FRQN(3*J1-2), FRQN(3*J1-1), FRQN(3*J1)
!  ENDDO
!  CLOSE(UNIT = 28)

  ! hk286
  IF (DUMPV) THEN      
     CALL GENRIGID_EIGENVECTORS(AP, XRIGIDCOORDS, ATOMMASS)
  ENDIF
  
END SUBROUTINE GENRIGID_EIGENVALUES

!----------------------------------------------------------------------------------------------

SUBROUTINE GENRIGID_EIGENVECTORS(AP, XRIGIDCOORDS, ATOMMASS)

  USE COMMONS
  USE MODHESS
  IMPLICIT NONE
        
  INTEGER :: OFFSET, SMODE, I, J, J1, J2, J3, J5, J8, J9
  DOUBLE PRECISION :: XTEMP(DEGFREEDOMS), XXTEMP(DEGFREEDOMS), AP(DEGFREEDOMS,DEGFREEDOMS)
  DOUBLE PRECISION :: X(3*NATOMS), XCOORDS(3*NATOMS), XRIGIDCOORDS(3*NATOMS)
  DOUBLE PRECISION :: P(3), KBLOCK(3,3), KBEGNV(3), RMI(3,3), RRMI(3,3), DRMI(3,3), DR(3)
  DOUBLE PRECISION :: TMASS, ATOMMASS(3*NATOMS)
  INTEGER, PARAMETER :: LWORK = 10000 ! the dimension is set arbitrarily
  DOUBLE PRECISION :: WORK(LWORK)
  INTEGER          :: INFO, TFRAME

  OFFSET = 3*NRIGIDBODY
  CALL TRANSFORMRIGIDTOC (1, NRIGIDBODY, X, XRIGIDCOORDS)

! Here are the normal modes you want to be computed - the first six are zero
  DO SMODE = 1, DEGFREEDOMS
     DO I = 1, DEGFREEDOMS
! This gives you DX where DX is taken along the direction of an eigenvector
        XTEMP(I) = AP(I,SMODE) * 0.05
     ENDDO
     DO J1 = 1, NRIGIDBODY
        J3 = 3*J1
! The rotational part - undiagonalized it
        J5 = OFFSET + J3
        P  = XRIGIDCOORDS(J5-2:J5)
        KBLOCK(:,:) = 0.D0                 
! Computes the rotation matrix which brings the reference geometry in stationary frame 
! to the atom positions in current minimum geometry
        CALL RMDFAS(P, RMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, .FALSE., .FALSE.)
                 
! Computing inertia matrix in the moving frame, i.e. current minimum geometry
        TMASS = 0.0D0
        DO J2 = 1, NSITEPERBODY(J1)
           J8 = RIGIDGROUPS(J2, J1)        
           DR(:)  = MATMUL(RMI(:,:),SITESRIGIDBODY(J2,:,J1))
           TMASS = TMASS + ATOMMASS(J8)
           DO I = 1, 3
              KBLOCK(I,I) = KBLOCK(I,I) + ATOMMASS(J8)*(DR(1)*DR(1) + DR(2)*DR(2) + DR(3)*DR(3))
              DO J = 1, 3    ! could have been J = 1, I; KBLOCK is a symmetric matrix
                 KBLOCK(I,J) = KBLOCK(I,J) - ATOMMASS(J8)*DR(I)*DR(J)
              ENDDO
           ENDDO
        ENDDO
! Diagonalise inertia matrix
        CALL DSYEV('V','L',3,KBLOCK,3,KBEGNV,WORK,LWORK,INFO)

        XTEMP(J5-2) = XTEMP(J5-2)/SQRT(KBEGNV(1)) 
        XTEMP(J5-1) = XTEMP(J5-1)/SQRT(KBEGNV(2)) 
        XTEMP(J5  ) = XTEMP(J5  )/SQRT(KBEGNV(3)) 
                 
! Going from the diagonalised rotation coordinates to per rigid body angle-axis coordinates in the moving frame
        XXTEMP(J5-2) = KBLOCK(1,1)*XTEMP(J5-2) + KBLOCK(1,2)*XTEMP(J5-1) + KBLOCK(1,3)*XTEMP(J5  )
        XXTEMP(J5-1) = KBLOCK(2,1)*XTEMP(J5-2) + KBLOCK(2,2)*XTEMP(J5-1) + KBLOCK(2,3)*XTEMP(J5  )
        XXTEMP(J5  ) = KBLOCK(3,1)*XTEMP(J5-2) + KBLOCK(3,2)*XTEMP(J5-1) + KBLOCK(3,3)*XTEMP(J5  )
                 
! Computing the rotation matrix which rotates the current minimum geometry due to its normal mode displacements
        P = XXTEMP(J5-2:J5)
        CALL RMDFAS(P, RRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, DRMI, .FALSE., .FALSE.)

! Compute the displaced positions of the atoms
        DO J2 = 1, NSITEPERBODY(J1)
           J8 = RIGIDGROUPS(J2, J1)        
           XCOORDS(3*J8-2:3*J8) = XRIGIDCOORDS(J3-2:J3) + XTEMP(J3-2:J3)/SQRT(TMASS) &
                + MATMUL(RRMI(:,:),MATMUL(RMI(:,:),SITESRIGIDBODY(J2,:,J1)))
        ENDDO
     ENDDO

     DO J1 = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
        J8 = RIGIDSINGLES(J1)
        J5 = 2*OFFSET + 3*J1
        XCOORDS(3*J8-2:3*J8) = XRIGIDCOORDS(J5-2:J5) + XTEMP(J5-2:J5)/SQRT(ATOMMASS(J8))
     ENDDO

! Computes the atoms eigenvectors
     DO I = 1, 3*NATOMS
        HESS(I,SMODE) = (XCOORDS(I)-X(I)) / 0.05
     ENDDO

  ENDDO

END SUBROUTINE GENRIGID_EIGENVECTORS

!----------------------------------------------------------------------------------------------

SUBROUTINE GENRIGID_VDUMP(DIAG,ZT,N,M)
  USE KEY
  USE MODHESS
  USE PORFUNCS
  IMPLICIT NONE
  INTEGER M, N, J1, J2, ISTAT, MCOUNT
  DOUBLE PRECISION DIAG(M)
  LOGICAL ZT(M)

!
!  dump the eigenvectors which correspond to non-zero eigenvalues
!  in file vectors.dump
!
  IF (.NOT.ALLSTEPS) REWIND(44)
  IF (ALLVECTORS) THEN
     MCOUNT=0
     DO J1=1,M
        IF (ZT(J1)) MCOUNT=MCOUNT+1
     ENDDO
     OPEN(UNIT=499,FILE='nmodes.dat',STATUS='UNKNOWN')
     WRITE(499,'(I6)') MCOUNT
     CLOSE(499)
     DO J1=1,M
        IF (ZT(J1)) THEN
! If printing the mass weighted vectors (normal modes), convert omega^2
! into the vibrational frequency in wavenumbers (cm^(-1)). 108.52 is the
! conversion factor from (kcal mol-1 kg-1 A-2)^2 to cm-1.
           IF (MWVECTORS) THEN
              WRITE(44,'(F20.10)') DSQRT(DIAG(J1))*108.52
           ELSE
              WRITE(44,'(F20.10)') DIAG(J1)
           ENDIF
           WRITE(44,'(3F20.10)') (HESS(J2,J1),J2=1,N)
        ENDIF
     ENDDO
  ELSE
     DO J1=M,1,-1
        IF (ZT(J1)) THEN
! As above
           IF (MWVECTORS) THEN
              WRITE(44,'(F20.10)') DSQRT(DIAG(J1))*108.52
           ELSE
              WRITE(44,'(F20.10)') DIAG(J1)
           ENDIF
           WRITE(44,'(3F20.10)') (HESS(J2,J1),J2=1,N)
           CALL FLUSH(44,ISTAT)
           RETURN
        ENDIF
     ENDDO
  ENDIF
  CALL FLUSH(44,ISTAT)
  RETURN

END SUBROUTINE GENRIGID_VDUMP

!----------------------------------------------------------------------------------------------

SUBROUTINE GENRIGID_MAKENUMHESS(X,NATOMS,DEGFREEDOMS)
  
  USE MODHESS
  USE MODCHARMM
  USE COMMONS,ONLY : DEBUG
  use porfuncs
  IMPLICIT NONE
  LOGICAL KNOWE, KNOWG, KNOWH
  COMMON /KNOWN/ KNOWE, KNOWG, KNOWH
  
  INTEGER I1,J1,NATOMS,DEGFREEDOMS,ISTAT
  DOUBLE PRECISION X(3*NATOMS)
  DOUBLE PRECISION DUM(3*NATOMS),GRAD1(3*NATOMS),GRAD2(3*NATOMS),DELTA,RMS,ENERGY
  
  IF (DEBUG) WRITE(*,'(A)') ' makenumhess> Making numerical hessian for local rigid body'
  DO I1=1,DEGFREEDOMS
     DUM(I1)=X(I1)
  ENDDO
  
  DELTA=1.0D-6
  IF(CHRMMT.AND.ACESOLV) NCHENCALLS=ACEUPSTEP-1
  
  IF (.NOT.ALLOCATED(HESS)) ALLOCATE(HESS(3*NATOMS,3*NATOMS))
  DO I1=1,DEGFREEDOMS
     DUM(I1)=X(I1)-DELTA
     CALL POTENTIAL(DUM,ENERGY,GRAD1,.TRUE.,.FALSE.,RMS,.FALSE.,.FALSE.)
     DUM(I1)=X(I1)+DELTA
     CALL POTENTIAL(DUM,ENERGY,GRAD2,.TRUE.,.FALSE.,RMS,.FALSE.,.FALSE.)
     DUM(I1)=X(I1)
     DO J1=I1,DEGFREEDOMS
        HESS(I1,J1)=(GRAD2(J1)-GRAD1(J1))/(2.0D0*DELTA)
        HESS(J1,I1)=HESS(I1,J1)
     ENDDO
     
  ENDDO
  
  HESS(DEGFREEDOMS+1:3*NATOMS,:) = 0.0D0
  HESS(:,DEGFREEDOMS+1:3*NATOMS) = 0.0D0

  IF (DEBUG) WRITE(*,'(A)') ' makenumhess> Hessian made for local rigid body'
  KNOWH=.TRUE.

  RETURN
END SUBROUTINE GENRIGID_MAKENUMHESS

!----------------------------------------------------------------------------------------------
! hk286 - this is still not working
SUBROUTINE SHIFTLOCALRIGID (Q, NATOMS)

!     THIS SUBROUTINE SHIFTS THE 'ZERO' EIGENVALUES CORRESPONDING TO OVERALL TRANSLATION AND
!     ROTATION OF A SYSTEM OF (IDENTICAL) RIGID BODIES WITH C-O-M & ANGLE-AXIS COORDINATES.

  USE KEY
  USE MODHESS

  IMPLICIT NONE
  
  INTEGER            :: NATOMS, I, J, J1, J2
  DOUBLE PRECISION   :: Q(3*NATOMS), EV(3*NATOMS,6), NRMFCT(6)
  DOUBLE PRECISION   :: CMX, CMY, CMZ, THETA, THETA2, THETAH, DUMMY
  
!     INITIALIZE

  EV(:,:)   = 0.D0
  NRMFCT(:) = 0.D0
  CMX       = 0.D0
  CMY       = 0.D0
  CMZ       = 0.D0
  
  SHIFTED = .TRUE.
  NZERO = 6

  DO I = 1, NRIGIDBODY
     J = 3*I     
     CMX = CMX + Q(J-2) !* NSITEPERBODY(I)
     CMY = CMY + Q(J-1) !* NSITEPERBODY(I)
     CMZ = CMZ + Q(J)   !* NSITEPERBODY(I)     
  ENDDO
  DO I = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
     J = 6*NRIGIDBODY + 3*I
     CMX = CMX + Q(J-2)
     CMY = CMY + Q(J-1)
     CMZ = CMZ + Q(J)
  ENDDO
  CMX = CMX / FLOAT(NATOMS)
  CMY = CMY / FLOAT(NATOMS)
  CMZ = CMZ / FLOAT(NATOMS)

  CMX = 0.0D0
  CMY = 0.0D0
  CMZ = 0.0D0

  DO I = 1, NRIGIDBODY
     J  = 3*I
     J1 = 3*NRIGIDBODY + J

     THETA2 = DOT_PRODUCT(Q(J1-2:J1), Q(J1-2:J1))
     THETA  = DSQRT(THETA2)
     THETAH = 0.5D0*THETA

!     TRANSLATION ALONG X
     EV(J-2,1) = 1.D0
     NRMFCT(1) = NRMFCT(1) + 1.D0

!     TRANSLATION ALONG Y
     EV(J-1,2) = 1.D0
     NRMFCT(2) = NRMFCT(2) + 1.D0

!     TRANSLATION ALONG Z
     EV(J,3) = 1.D0
     NRMFCT(3) = NRMFCT(3) + 1.D0

     IF (THETA == 0.D0) THEN

!     ROTATION ABOUT Z
        EV(J-2,4)  = - Q(J-1) + CMY
        EV(J-1,4)  = Q(J-2) - CMX
        EV(J1,4)   = 1.D0
        NRMFCT(4)  = NRMFCT(4) + EV(J-2,4)**2 + EV(J-1,4)**2 + EV(J1-2,4)**2 + EV(J1-1,4)**2 + EV(J1,4)**2
        
!     ROTATION ABOUT X
        EV(J-1,5)  = - Q(J) + CMZ
        EV(J,5)    = Q(J-1) - CMY
        EV(J1-2,5) = 1.D0
        NRMFCT(5)  = NRMFCT(5) + EV(J-1,5)**2 + EV(J,5)**2 + EV(J1-2,5)**2 + EV(J1-1,5)**2 + EV(J1,5)**2
            
!     ROTATION ABOUT Y
        EV(J-2,6)  = Q(J) - CMZ
        EV(J,6)    = - Q(J-2) + CMX
        EV(J1-1,6) = 1.D0
        NRMFCT(6)  = NRMFCT(6) + EV(J-2,6)**2 + EV(J,6)**2 + EV(J1-2,6)**2 + EV(J1-1,6)**2 + EV(J1,6)**2
        
     ELSE

!     ROTATION ABOUT Z
        EV(J-2,4)  = - Q(J-1) + CMY
        EV(J-1,4)  = Q(J-2) - CMX
        EV(J1-2,4) = - 0.5D0*Q(J1-1) + Q(J1)*Q(J1-2)/THETA2 - 0.5D0*Q(J1)*Q(J1-2)/(THETA*TAN(THETAH))
        EV(J1-1,4) = 0.5D0*Q(J1-2) + Q(J1)*Q(J1-1)/THETA2 - 0.5D0*Q(J1)*Q(J1-1)/(THETA*TAN(THETAH))
        EV(J1,4)   = THETAH/TAN(THETAH) + Q(J1)**2/THETA2 - 0.5D0*Q(J1)**2/(THETA*TAN(THETAH))
        NRMFCT(4)  = NRMFCT(4) + EV(J-2,4)**2 + EV(J-1,4)**2 + EV(J1-2,4)**2 + EV(J1-1,4)**2 + EV(J1,4)**2
             
!     ROTATION ABOUT X
        EV(J-1,5)  = - Q(J) + CMZ
        EV(J,5)    = Q(J-1) - CMY
        EV(J1-2,5) = THETAH/TAN(THETAH) + Q(J1-2)**2/THETA2 - 0.5D0*Q(J1-2)**2/(THETA*TAN(THETAH))
        EV(J1-1,5) = - 0.5D0*Q(J1) + Q(J1-2)*Q(J1-1)/THETA2 - 0.5D0*Q(J1-2)*Q(J1-1)/(THETA*TAN(THETAH))
        EV(J1,5)   = 0.5D0*Q(J1-1) + Q(J1-2)*Q(J1)/THETA2 - 0.5D0*Q(J1-2)*Q(J1)/(THETA*TAN(THETAH))
        NRMFCT(5)  = NRMFCT(5) + EV(J-1,5)**2 + EV(J,5)**2 + EV(J1-2,5)**2 + EV(J1-1,5)**2 + EV(J1,5)**2
     
!     ROTATION ABOUT Y
        EV(J-2,6)  = Q(J) - CMZ
        EV(J,6)    = - Q(J-2) + CMX
        EV(J1-2,6) = 0.5D0*Q(J1) + Q(J1-1)*Q(J1-2)/THETA2 - 0.5D0*Q(J1-1)*Q(J1-2)/(THETA*TAN(THETAH))
        EV(J1-1,6) = THETAH/TAN(THETAH) + Q(J1-1)**2/THETA2 - 0.5D0*Q(J1-1)**2/(THETA*TAN(THETAH))
        EV(J1,6)   = - 0.5D0*Q(J1-2) + Q(J1-1)*Q(J1)/THETA2 - 0.5D0*Q(J1-1)*Q(J1)/(THETA*TAN(THETAH))
        NRMFCT(6)  = NRMFCT(6) + EV(J-2,6)**2 + EV(J,6)**2 + EV(J1-2,6)**2 + EV(J1-1,6)**2 + EV(J1,6)**2
     
     ENDIF     

  ENDDO

  DO I = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
     J = 6*NRIGIDBODY + 3*I
!     TRANSLATION ALONG X
     EV(J-2,1) = 1.D0
     NRMFCT(1) = NRMFCT(1) + 1.D0
!     TRANSLATION ALONG Y
     EV(J-1,2) = 1.D0
     NRMFCT(2) = NRMFCT(2) + 1.D0
!     TRANSLATION ALONG Z
     EV(J,3) = 1.D0
     NRMFCT(3) = NRMFCT(3) + 1.D0
!     ROTATION ABOUT Z
     EV(J-2,4)  = - Q(J-1) + CMY
     EV(J-1,4)  = Q(J-2) - CMX
     NRMFCT(4)  = NRMFCT(4) + EV(J-2,4)**2 + EV(J-1,4)**2        
!     ROTATION ABOUT X
     EV(J-1,5)  = - Q(J) + CMZ
     EV(J,5)    = Q(J-1) - CMY
     NRMFCT(5)  = NRMFCT(5) + EV(J-1,5)**2 + EV(J,5)**2            
!     ROTATION ABOUT Y
     EV(J-2,6)  = Q(J) - CMZ
     EV(J,6)    = - Q(J-2) + CMX
     NRMFCT(6)  = NRMFCT(6) + EV(J-2,6)**2 + EV(J,6)**2        
  ENDDO

  DO J = 1, NZERO

     NRMFCT(J) = DSQRT(NRMFCT(J))
     EV(:,J)   = EV(:,J)/NRMFCT(J)
   
  ENDDO

!     GRAM-SCHMIDT ORTHOGONALISATION TO OBTAIN ORTHONORMAL ROTATIONAL EIGENVECTORS

  DO J = 4, NZERO
     
     DO J1 = 4, J-1
        
        EV(:,J) = EV(:,J) - DOT_PRODUCT(EV(:,J),EV(:,J1))*EV(:,J1)
        
     ENDDO
     
     EV(:,J) = EV(:,J) / DSQRT(DOT_PRODUCT(EV(:,J),EV(:,J)))
     
  ENDDO

  DO J1 = 1, DEGFREEDOMS
     
     DO J2 = 1, DEGFREEDOMS
        
        DO J = 1, NZERO 
           
           HESS(J2,J1) = HESS(J2,J1) + SHIFTV*EV(J2,J)*EV(J1,J)
           
        ENDDO
        
     ENDDO
     
  ENDDO

END SUBROUTINE SHIFTLOCALRIGID

!----------------------------------------------------------------------------------------------

SUBROUTINE ORTHOGLOCALRIGID (VEC1, Q, OTEST)

!     THIS SUBROUTINE ORTHOGONALISES VEC1 TO THE EIGENVECTORS CORRESPONDING TO OVERALL TRANSLATION
!     AND ROTATION OF A SYSTEM OF (IDENTICAL) RIGID BODIES WITH C-O-M & ANGLE-AXIS COORDINATES.

  USE COMMONS
  USE KEY
  
  IMPLICIT NONE
  
! hk286 - use 3*NATOMS or DEGFREEDOMS
  INTEGER            :: I, J, J1
  DOUBLE PRECISION   :: Q(3*NATOMS), EV(3*NATOMS,6), NRMFCT(6), VEC1(3*NATOMS)
  DOUBLE PRECISION   :: CMX, CMY, CMZ, THETA, THETA2, THETAH, DUMMY
  LOGICAL            :: OTEST

  !     INITIALIZE

  EV(:,:)   = 0.D0
  NRMFCT(:) = 0.D0
  CMX       = 0.D0
  CMY       = 0.D0
  CMZ       = 0.D0
  
  NZERO = 6

  CMX = 0.0D0
  CMY = 0.0D0
  CMZ = 0.0D0

  DO I = 1, NRIGIDBODY
     J  = 3*I
     J1 = 3*NRIGIDBODY + J

     THETA2 = DOT_PRODUCT(Q(J1-2:J1), Q(J1-2:J1))
     THETA  = DSQRT(THETA2)
     THETAH = 0.5D0*THETA

!     TRANSLATION ALONG X
     EV(J-2,1) = 1.D0
     NRMFCT(1) = NRMFCT(1) + 1.D0

!     TRANSLATION ALONG Y
     EV(J-1,2) = 1.D0
     NRMFCT(2) = NRMFCT(2) + 1.D0

!     TRANSLATION ALONG Z
     EV(J,3) = 1.D0
     NRMFCT(3) = NRMFCT(3) + 1.D0

     IF (THETA == 0.D0) THEN

!     ROTATION ABOUT Z
        EV(J-2,4)  = - Q(J-1) + CMY
        EV(J-1,4)  = Q(J-2) - CMX
        EV(J1,4)   = 1.D0
        NRMFCT(4)  = NRMFCT(4) + EV(J-2,4)**2 + EV(J-1,4)**2 + EV(J1-2,4)**2 + EV(J1-1,4)**2 + EV(J1,4)**2
        
!     ROTATION ABOUT X
        EV(J-1,5)  = - Q(J) + CMZ
        EV(J,5)    = Q(J-1) - CMY
        EV(J1-2,5) = 1.D0
        NRMFCT(5)  = NRMFCT(5) + EV(J-1,5)**2 + EV(J,5)**2 + EV(J1-2,5)**2 + EV(J1-1,5)**2 + EV(J1,5)**2
            
!     ROTATION ABOUT Y
        EV(J-2,6)  = Q(J) - CMZ
        EV(J,6)    = - Q(J-2) + CMX
        EV(J1-1,6) = 1.D0
        NRMFCT(6)  = NRMFCT(6) + EV(J-2,6)**2 + EV(J,6)**2 + EV(J1-2,6)**2 + EV(J1-1,6)**2 + EV(J1,6)**2
        
     ELSE

!     ROTATION ABOUT Z
        EV(J-2,4)  = - Q(J-1) + CMY
        EV(J-1,4)  = Q(J-2) - CMX
        EV(J1-2,4) = - 0.5D0*Q(J1-1) + Q(J1)*Q(J1-2)/THETA2 - 0.5D0*Q(J1)*Q(J1-2)/(THETA*TAN(THETAH))
        EV(J1-1,4) = 0.5D0*Q(J1-2) + Q(J1)*Q(J1-1)/THETA2 - 0.5D0*Q(J1)*Q(J1-1)/(THETA*TAN(THETAH))
        EV(J1,4)   = THETAH/TAN(THETAH) + Q(J1)**2/THETA2 - 0.5D0*Q(J1)**2/(THETA*TAN(THETAH))
        NRMFCT(4)  = NRMFCT(4) + EV(J-2,4)**2 + EV(J-1,4)**2 + EV(J1-2,4)**2 + EV(J1-1,4)**2 + EV(J1,4)**2
             
!     ROTATION ABOUT X
        EV(J-1,5)  = - Q(J) + CMZ
        EV(J,5)    = Q(J-1) - CMY
        EV(J1-2,5) = THETAH/TAN(THETAH) + Q(J1-2)**2/THETA2 - 0.5D0*Q(J1-2)**2/(THETA*TAN(THETAH))
        EV(J1-1,5) = - 0.5D0*Q(J1) + Q(J1-2)*Q(J1-1)/THETA2 - 0.5D0*Q(J1-2)*Q(J1-1)/(THETA*TAN(THETAH))
        EV(J1,5)   = 0.5D0*Q(J1-1) + Q(J1-2)*Q(J1)/THETA2 - 0.5D0*Q(J1-2)*Q(J1)/(THETA*TAN(THETAH))
        NRMFCT(5)  = NRMFCT(5) + EV(J-1,5)**2 + EV(J,5)**2 + EV(J1-2,5)**2 + EV(J1-1,5)**2 + EV(J1,5)**2
     
!     ROTATION ABOUT Y
        EV(J-2,6)  = Q(J) - CMZ
        EV(J,6)    = - Q(J-2) + CMX
        EV(J1-2,6) = 0.5D0*Q(J1) + Q(J1-1)*Q(J1-2)/THETA2 - 0.5D0*Q(J1-1)*Q(J1-2)/(THETA*TAN(THETAH))
        EV(J1-1,6) = THETAH/TAN(THETAH) + Q(J1-1)**2/THETA2 - 0.5D0*Q(J1-1)**2/(THETA*TAN(THETAH))
        EV(J1,6)   = - 0.5D0*Q(J1-2) + Q(J1-1)*Q(J1)/THETA2 - 0.5D0*Q(J1-1)*Q(J1)/(THETA*TAN(THETAH))
        NRMFCT(6)  = NRMFCT(6) + EV(J-2,6)**2 + EV(J,6)**2 + EV(J1-2,6)**2 + EV(J1-1,6)**2 + EV(J1,6)**2
     
     ENDIF     

  ENDDO
  
  DO I = 1, (DEGFREEDOMS - 6*NRIGIDBODY)/3
     J = 6*NRIGIDBODY + 3*I
!     TRANSLATION ALONG X
     EV(J-2,1) = 1.D0
     NRMFCT(1) = NRMFCT(1) + 1.D0
!     TRANSLATION ALONG Y
     EV(J-1,2) = 1.D0
     NRMFCT(2) = NRMFCT(2) + 1.D0
!     TRANSLATION ALONG Z
     EV(J,3) = 1.D0
     NRMFCT(3) = NRMFCT(3) + 1.D0
!     ROTATION ABOUT Z
     EV(J-2,4)  = - Q(J-1) + CMY
     EV(J-1,4)  = Q(J-2) - CMX
     NRMFCT(4)  = NRMFCT(4) + EV(J-2,4)**2 + EV(J-1,4)**2        
!     ROTATION ABOUT X
     EV(J-1,5)  = - Q(J) + CMZ
     EV(J,5)    = Q(J-1) - CMY
     NRMFCT(5)  = NRMFCT(5) + EV(J-1,5)**2 + EV(J,5)**2            
!     ROTATION ABOUT Y
     EV(J-2,6)  = Q(J) - CMZ
     EV(J,6)    = - Q(J-2) + CMX
     NRMFCT(6)  = NRMFCT(6) + EV(J-2,6)**2 + EV(J,6)**2        
  ENDDO

  DO J = 1, NZERO

     NRMFCT(J) = DSQRT(NRMFCT(J))
     EV(:,J)   = EV(:,J)/NRMFCT(J)
   
  ENDDO


!     GRAM-SCHMIDT ORTHOGONALISATION TO OBTAIN ORTHONORMAL ROTATIONAL EIGENVECTORS

  DO J = 4, NZERO
     
     DO J1 = 4, J-1
        
        EV(:,J) = EV(:,J) - DOT_PRODUCT(EV(:,J),EV(:,J1))*EV(:,J1)
        
     ENDDO
     
     EV(:,J) = EV(:,J) / DSQRT(DOT_PRODUCT(EV(:,J),EV(:,J)))
     
  ENDDO

!     PROJECT TRANS/ROT SET OUT OF VEC1

  DO J = 1, NZERO 

     DUMMY   = DOT_PRODUCT(VEC1(:),EV(:,J))
     VEC1(:) = VEC1(:) - DUMMY*EV(:,J)

  ENDDO

  IF (OTEST) CALL VECNORM(VEC1,DEGFREEDOMS) ! NORMALIZE VEC1

END SUBROUTINE ORTHOGLOCALRIGID


SUBROUTINE BEIGLOCALRIGID(ITER,COORDS,ENERGY,VECS,EVALMIN,NS,SOVER,PTEST,CONVERGED)

  USE COMMONS
  USE KEY
  USE MODNEB
  USE MODTWOEND
  use porfuncs
  IMPLICIT NONE

  INTEGER J1, ISEED, NS, NITS
  DOUBLE PRECISION ENERGY,COORDS(3*NATOMS),VEC(3*NATOMS),VECS(3*NATOMS),DPRAND,SOVER,EVALMIN,EPS,FRET
  DOUBLE PRECISION DIAG(3*NATOMS),WORK(3*NATOMS*(2*XMUPDATE+1)+2*XMUPDATE)
  PARAMETER (EPS=1.D-6)
  LOGICAL PTEST, CONVERGED
  INTEGER ITER
  COMMON /IS/ ISEED
  SAVE
  
  IF ((ITER.EQ.1).AND.(.NOT.READV).AND.(.NOT.TWOENDS).AND.(.NOT.TTDONE).AND.(.NOT.(NEWCONNECTT.OR.NEWNEBT))) THEN
     DO J1=1,DEGFREEDOMS
        VEC(J1)=2*(DPRAND()-0.5D0)
     ENDDO
     DO J1=DEGFREEDOMS+1,NOPT
        VEC(J1)=0.0D0
     ENDDO
  ELSE
     DO J1=1,NOPT
        VEC(J1)=VECS(J1)
     ENDDO
  ENDIF

  CALL XMYLBFGS(NOPT,XMUPDATE,VEC,.FALSE.,DIAG,CEIG,WORK,ENERGY,COORDS,NITS,NEVS,FRET,PTEST,CONVERGED)
  CALL VECNORM(VEC,NOPT) 

  EVALMIN=FRET
  NS=NITS
  SOVER=0.0D0
  DO J1=1,NOPT
     SOVER=SOVER+VECS(J1)*VEC(J1)
     VECS(J1)=VEC(J1)
  ENDDO
  IF (PTEST) WRITE(*,'(A,F15.7)') 'beig> Overlap with previous vector=',SOVER

  FIXIMAGE=.FALSE.
  
  RETURN
END SUBROUTINE BEIGLOCALRIGID




SUBROUTINE GENRIGID_POTENTIAL(COORDS,ENERGY,VNEW,GTEST,STEST,RMS,PTEST,BOXTEST)

  USE COMMONS, only: NATOMS
  IMPLICIT NONE

  DOUBLE PRECISION, DIMENSION(3*NATOMS) :: COORDS, XRIGIDCOORDS
  DOUBLE PRECISION ENERGY
  DOUBLE PRECISION, DIMENSION(3*NATOMS) :: VNEW 
  LOGICAL GTEST, STEST
  DOUBLE PRECISION RMS
  LOGICAL PTEST, BOXTEST, TEMPATOMRIGIDCOORDT

  XRIGIDCOORDS(:) = 0.0D0
  CALL TRANSFORMCTORIGID(COORDS, XRIGIDCOORDS(1:DEGFREEDOMS))
  TEMPATOMRIGIDCOORDT = ATOMRIGIDCOORDT
  ATOMRIGIDCOORDT = .FALSE.
  CALL POTENTIAL(XRIGIDCOORDS,ENERGY,VNEW,GTEST,STEST,RMS,PTEST,BOXTEST)
  ATOMRIGIDCOORDT = TEMPATOMRIGIDCOORDT

END SUBROUTINE GENRIGID_POTENTIAL


SUBROUTINE GENRIGID_PERMDIST()
  USE KEY,ONLY : NPERMGROUP, NPERMSIZE, PERMGROUP, NSETS, SETS
  USE COMMONS, ONLY: NATOMS
  IMPLICIT NONE

  INTEGER J1, J2, J3, J4, J5, J6,  NDUMMY, NDUMMY2
  INTEGER, ALLOCATABLE :: LRBNDUMMY(:)
  LOGICAL :: INTRAGROUPPERM

  ALLOCATE (LRBNPERMGROUP(NRIGIDBODY))
  ALLOCATE (LRBNPERMSIZE(NRIGIDBODY,3*NATOMS))
  ALLOCATE (LRBPERMGROUP(NRIGIDBODY,3*NATOMS))
  ALLOCATE (LRBNSETS(NRIGIDBODY,3*NATOMS))
  ALLOCATE (LRBSETS(NRIGIDBODY,NATOMS,3))
  ALLOCATE (LRBNDUMMY(NRIGIDBODY))
  
  LRBNPERMGROUP(:) = 0
  LRBPERMGROUP(:,:)=0
  NDUMMY = 1
  LRBNDUMMY(:) = 1

  DO J1 = 1, NPERMGROUP

     DO J2 = 1, NRIGIDBODY

        DO J3 = 1, NSITEPERBODY(J2)
           
           IF ( PERMGROUP(NDUMMY) .EQ. RIGIDGROUPS(J3,J2) ) THEN
              NDUMMY2 = NDUMMY
!jdf43> check that permutations are restricted to a single RB
              INTRAGROUPPERM=.TRUE.
              DO J4 = 1, NPERMSIZE(J1)
!                 IF (.NOT.ANY(RIGIDGROUPS(:,J2)==PERMGROUP(NDUMMY2+J4-1))) INTRAGROUPPERM=.FALSE.
                 INTRAGROUPPERM = INTRAGROUPPERM .AND. (.NOT.ANY(RIGIDGROUPS(:,J2)==PERMGROUP(NDUMMY2+J4-1)))
              ENDDO
              IF (INTRAGROUPPERM) THEN
!jdf43>
                 LRBNPERMGROUP(J2) = LRBNPERMGROUP(J2) + 1
                 LRBNPERMSIZE(J2,LRBNPERMGROUP(J2)) = NPERMSIZE(J1)
                 LRBNSETS(J2,LRBNPERMGROUP(J2)) = NSETS(J1)
                 DO J4 = 1, NPERMSIZE(J1)
                    DO J5 = 1, NSITEPERBODY(J2)
                       IF (PERMGROUP(NDUMMY2+J4-1) .EQ. RIGIDGROUPS(J5,J2)) THEN
                          LRBPERMGROUP(J2,LRBNDUMMY(J2)+J4-1) = J5
                       ENDIF
                    ENDDO
                       
                    DO J6 = 1, NSETS(J1)
                       DO J5 = 1, NSITEPERBODY(J2)
                          IF (SETS(PERMGROUP(NDUMMY2+J4-1),J6) .EQ. RIGIDGROUPS(J5,J2)) THEN
                             LRBSETS(J2,LRBPERMGROUP(J2,LRBNDUMMY(J2)+J4-1),J6) = J5
!                             PRINT *, J2,LRBPERMGROUP(J2,LRBNDUMMY(J2)+J4-1), LRBNPERMGROUP(J2)
                          ENDIF
                       ENDDO
                    ENDDO
                 ENDDO
                 LRBNDUMMY(J2) = LRBNDUMMY(J2) + NPERMSIZE(J1)
!jdf43>
              ENDIF
!jdf43>
           ENDIF
           
        ENDDO
        
     ENDDO

     NDUMMY = NDUMMY + NPERMSIZE(J1)
  ENDDO

END SUBROUTINE GENRIGID_PERMDIST




      
END MODULE GENRIGID
