!   OPTIM: A program for optimizing geometries and calculating reaction pathways
!   Copyright (C) 1999-2006 David J. Wales
!   This file is part of OPTIM.
!
!   OPTIM is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   OPTIM is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
SUBROUTINE BULKMINDIST(DUMMYB,DUMMYA,XBEST, NATOMS,DISTANCE,TWOD,DEBUG,BOXLX,BOXLY,BOXLZ,PITEST,RESETA, TNMATCH, BMTEST)
USE KEY,ONLY : NPERMGROUP, NPERMSIZE, PERMGROUP, GEOMDIFFTOL, ATOMMATCHFULL

IMPLICIT NONE
INTEGER J1, NATOMS, NPMIN, NGMIN, J2, PERM(NATOMS), PBEST(NATOMS), NDUMMY, NMATCHED, PATOMS, J3, J4, NMBEST, ND1
INTEGER NMATCHSV, J5, J6, LPERM(NATOMS), NREP, NREP2
DOUBLE PRECISION DUMMYB(3*NATOMS),DUMMYA(3*NATOMS),DISTANCE,BOXLX,BOXLY,BOXLZ,XSHIFT,YSHIFT,ZSHIFT,XTEMP(3*NATOMS)
DOUBLE PRECISION XBEST(3*NATOMS), DMIN, DTOTAL, DIST, GDSQ
DOUBLE PRECISION DIST2, LDISTANCE, WORSTRAD 
LOGICAL TWOD,DEBUG,PITEST,SAMEMIN,RESETA, TNMATCH, BMTEST, BMTESTLOCAL 
COMMON /BULKSHIFT/ XSHIFT,YSHIFT,ZSHIFT
SAVE NMATCHSV

IF (.NOT.TNMATCH) NMATCHSV=0 
!
! Find smallest group of permutable atoms.
! Translate first atom of group to all positions and then find nearest atom within
! the same group for every other atom.
! Keep the best translation/permutation, which corresponds to the smallest
! minimum image distance.
!
!PRINT*, NMATCHSV
TNMATCH=.TRUE.
DISTANCE=1.0D100
PITEST=.FALSE.
SAMEMIN=.TRUE.
BMTESTLOCAL=BMTEST
GDSQ=GEOMDIFFTOL**2/NATOMS ! because GEOMDIFFTOL is used for the total distance elsewhere in the program
NPMIN=HUGE(1)
! PRINT *,'DUMMYA in bulkmindist:'
! PRINT '(3G20.10)',DUMMYA(1:3*NATOMS)
! PRINT *,'DUMMYB in bulkmindist:'
! PRINT '(3G20.10)',DUMMYB(1:3*NATOMS)
DO J1=1,NPERMGROUP
   IF (NPERMSIZE(J1).LT.NPMIN) THEN
      NPMIN=NPERMSIZE(J1)
      NGMIN=J1
   ENDIF
ENDDO
ND1=0
DO J1=1,NGMIN-1
   ND1=ND1+NPERMSIZE(J1)
ENDDO
! IF (DEBUG) PRINT '(3(A,I6))',' bulkmindist> Smallest group of permutable atoms is number ',NGMIN,' with ',NPMIN,' members'
NREP=0
NREP2=0
outer: DO J1=ND1+1,ND1+NPMIN
   J2=PERMGROUP(J1)
   XSHIFT=DUMMYA(3*(J2-1)+1)-DUMMYB(3*(ND1)+1)-BOXLX*NINT((DUMMYA(3*(J2-1)+1)-DUMMYB(3*(ND1)+1))/BOXLX)
   YSHIFT=DUMMYA(3*(J2-1)+2)-DUMMYB(3*(ND1)+2)-BOXLY*NINT((DUMMYA(3*(J2-1)+2)-DUMMYB(3*(ND1)+2))/BOXLY)
   IF (.NOT.TWOD) ZSHIFT=DUMMYA(3*(J2-1)+3)-DUMMYB(3*(ND1)+3)-BOXLZ*NINT((DUMMYA(3*(J2-1)+3)-DUMMYB(3*(ND1)+3))/BOXLZ)
   DO J2=1,NATOMS
      XTEMP(3*(J2-1)+1)=DUMMYA(3*(J2-1)+1)-XSHIFT
      XTEMP(3*(J2-1)+2)=DUMMYA(3*(J2-1)+2)-YSHIFT
      IF (.NOT.TWOD) XTEMP(3*(J2-1)+3)=DUMMYA(3*(J2-1)+3)-ZSHIFT
   ENDDO
   NDUMMY=1
   PERM(1:NATOMS)=-1
   NMATCHED=0
   DTOTAL=0.0D0
   DO J2=1,NPERMGROUP
      PATOMS=NPERMSIZE(J2)
      loop1: DO J3=1,PATOMS    ! for each atom in fixed structure B in group J2
         DMIN=1.0D100
         loop2: DO J4=1,PATOMS ! which is the closest atom in the same group for the structure in XTEMP (shifted A)?
            DIST=(XTEMP(3*(PERMGROUP(NDUMMY+J4-1)-1)+1)-DUMMYB(3*(PERMGROUP(NDUMMY+J3-1)-1)+1) &
 &  - BOXLX*NINT((XTEMP(3*(PERMGROUP(NDUMMY+J4-1)-1)+1)-DUMMYB(3*(PERMGROUP(NDUMMY+J3-1)-1)+1))/BOXLX))**2 &
            &  + (XTEMP(3*(PERMGROUP(NDUMMY+J4-1)-1)+2)-DUMMYB(3*(PERMGROUP(NDUMMY+J3-1)-1)+2) &
 &  - BOXLY*NINT((XTEMP(3*(PERMGROUP(NDUMMY+J4-1)-1)+2)-DUMMYB(3*(PERMGROUP(NDUMMY+J3-1)-1)+2))/BOXLY))**2 
            IF (.NOT.TWOD) DIST=DIST+(XTEMP(3*(PERMGROUP(NDUMMY+J4-1)-1)+3)-DUMMYB(3*(PERMGROUP(NDUMMY+J3-1)-1)+3) &
 &  - BOXLZ*NINT((XTEMP(3*(PERMGROUP(NDUMMY+J4-1)-1)+3)-DUMMYB(3*(PERMGROUP(NDUMMY+J3-1)-1)+3))/BOXLZ))**2
            IF (DIST.LT.DMIN) THEN
               DMIN=DIST
               PERM(PERMGROUP(NDUMMY+J3-1))=PERMGROUP(NDUMMY+J4-1)
               IF (DIST.LT.GDSQ) THEN
!                 PRINT '(A,I6,A,I6,A,G20.10)',' match found between atom ',PERMGROUP(NDUMMY+J3-1), &
! &                                            ' and ',PERMGROUP(NDUMMY+J4-1),' DIST=',DIST
                  NMATCHED=NMATCHED+1
                  DTOTAL=DTOTAL+DMIN
                  IF (PERM(PERMGROUP(NDUMMY+J3-1)).NE.PERMGROUP(NDUMMY+J3-1)) SAMEMIN=.FALSE.
                  CYCLE loop1
               ENDIF
            ENDIF
         ENDDO loop2
!       DTOTAL=DTOTAL+DMIN
!       PRINT '(A,I6,A,G20.10,A,I6)',' match failed for atom ',PERMGROUP(NDUMMY+J3-1),' DMIN=',DMIN,' J1=',J1
      IF (.NOT.BMTESTLOCAL) CYCLE outer ! If we reached here then we don't have a permutational isomer because
                      ! the atom specified in the J3 loop does not have a partner.
      IF ((J3-NMATCHED).GT.(NATOMS-NMATCHSV)) CYCLE outer ! Match cannot be better than the previous best
      IF ((.NOT.ATOMMATCHFULL).AND.NMATCHSV.GT.0.AND.(J3-NMATCHED).GT.INT(NATOMS/2.0D0)) THEN
          NREP2=NREP2+1
          IF (NREP2.GE.5) THEN  
            BMTESTLOCAL=.FALSE.
            CYCLE outer ! Match is not good enough - give up
          ENDIF 
      ELSE
          NREP2=0
      ENDIF
      ENDDO loop1 
      IF (DEBUG) PRINT '(A, I6, A, I6)',' bulkmindist> number of matching atoms=', NMATCHED, ' in permgroup ', J2   
      IF (BMTESTLOCAL.AND.((NATOMS-NMATCHED).GT.0)) THEN
       IF (J2.EQ.NPERMGROUP.AND.NMATCHED.GE.NMATCHSV) THEN ! We have cycled over all atoms. Record best match. 
        CALL MINPERM(NATOMS, DUMMYB, XTEMP, BOXLX, BOXLY, BOXLZ, .TRUE., LPERM, LDISTANCE, DIST2, WORSTRAD)
        IF (LDISTANCE.LT.DISTANCE) THEN
          NREP=0
          PRINT*, 'From minperm', LDISTANCE, DIST2
          DISTANCE=LDISTANCE
          NMATCHSV=NMATCHED
          IF (RESETA) THEN
           DO J6=1,NATOMS
            XBEST(3*(J6-1)+1)=XTEMP(3*(LPERM(J6)-1)+1)-BOXLX*NINT(XTEMP(3*(LPERM(J6)-1)+1)/BOXLX)
            XBEST(3*(J6-1)+2)=XTEMP(3*(LPERM(J6)-1)+2)-BOXLY*NINT(XTEMP(3*(LPERM(J6)-1)+2)/BOXLY)
            IF (.NOT.TWOD) XBEST(3*(J6-1)+3)=XTEMP(3*(LPERM(J6)-1)+3)-BOXLZ*NINT(XTEMP(3*(LPERM(J6)-1)+3)/BOXLZ)
           ENDDO
          ENDIF
        ELSE IF (NMATCHED.EQ.NMATCHSV) THEN
          NREP=NREP+1
          IF (NREP.GT.10) THEN
            IF (.NOT.ATOMMATCHFULL) BMTESTLOCAL=.FALSE. 
            CYCLE outer ! Match is always the same - give up, still do the PI test
          ENDIF
        ENDIF
       ELSE IF (J2.EQ.NPERMGROUP) THEN
        NREP=0 
       ENDIF  
      IF (J2.EQ.NPERMGROUP.AND.NMATCHED.NE.NATOMS) CYCLE outer 
      NDUMMY=NDUMMY+NPERMSIZE(J2)
      ENDIF  
   ENDDO
   IF (SAMEMIN) THEN
      IF (DEBUG) PRINT '(A,G20.10)',' bulkmindist> identical isomers identified for distance ',SQRT(DTOTAL)
   ELSE
      IF (DEBUG) PRINT '(A,G20.10)',' bulkmindist> permutational isomers identified for distance ',SQRT(DTOTAL)
   ENDIF
   PITEST=.TRUE.
   DISTANCE=DTOTAL
   IF (RESETA) THEN
      DO J2=1,NATOMS
         DUMMYA(3*(J2-1)+1)=XTEMP(3*(PERM(J2)-1)+1)-BOXLX*NINT(XTEMP(3*(PERM(J2)-1)+1)/BOXLX)
         DUMMYA(3*(J2-1)+2)=XTEMP(3*(PERM(J2)-1)+2)-BOXLY*NINT(XTEMP(3*(PERM(J2)-1)+2)/BOXLY)
         IF (.NOT.TWOD) DUMMYA(3*(J2-1)+3)=XTEMP(3*(PERM(J2)-1)+3)-BOXLZ*NINT(XTEMP(3*(PERM(J2)-1)+3)/BOXLZ)
      ENDDO
   ENDIF

   RETURN
ENDDO outer

IF (DEBUG) PRINT '(A, G20.10)',' bulkmindist> distance=', DISTANCE
IF (DEBUG) PRINT '(A)',' bulkmindist> structures are not permutational isomers'

RETURN

END SUBROUTINE BULKMINDIST
!
! Apply Oh point group operation number OPNUM to coordinates in
! vector X of dimension 3*NLOCAL, returning the result in 
! vector Y.
!
SUBROUTINE OHOPS(X,Y,OPNUM,NLOCAL)
IMPLICIT NONE
INTEGER OPNUM, J2, J3, NLOCAL
DOUBLE PRECISION RMAT(3,3,48), X(3*NLOCAL), Y(3*NLOCAL)
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000 /

IF (OPNUM.EQ.0) THEN 
   Y(1:3*NLOCAL)=X(1:3*NLOCAL)
   RETURN
ENDIF

DO J2=1,NLOCAL
   J3=3*(J2-1)
   Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
   Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
   Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
ENDDO

END SUBROUTINE OHOPS
