subroutine aadistance( v1, v2 )
!js850>
!minimize the "distance" between two angle axis vectors
!
!perform symmetry operations on angle axis vectors v1 and v2 such that 
!the cartesian distance norm(v1(:) - v2(:)) between them is minimized.
! 
!the possible symmetry operations are
! v1 -> v1 * ( 1 + n * 2*pi / norm(v1) ) where n is an integer
implicit none

double precision, intent(inout) :: v1(3), v2(3)
double precision d, v1n, v2n
double precision, parameter :: PID = 3.14159265358973D0
double precision, parameter :: PID2 = 2.D0*PID
double precision dold, dnew, dnewnew



!dold = sqrt(sum( (v2 - v1)**2 )) !for debugging

!make the magnitude of v1 as close to zero as possible
v1n = sqrt( sum(v1(:)**2) )
do while ( v1n .ge. PID )
   v1(:) = v1(:)/v1n*(v1n-piD2)
   v1n = sqrt( sum(v1(:)**2) )
enddo

!make the magnitude of v2 as close to zero as possible
v2n = sqrt( sum(v2(:)**2) )
do while ( v2n .ge. PID )
   v2(:) = v2(:)/v2n*(v2n-piD2)
   v2n = sqrt( sum(v2(:)**2) )
enddo

! js850>
! We still need to check the two possibilities
! v1 -> v1 * (v1n - 2*pi)/v1n   
! v2 -> v2
!
! and
!
! v1 -> v1
! v2 -> v2 * (v2n - 2*pi)/v2n
!
! Other symmetry operations can be ruled out as options to give to closer vectors.
! We can simplify the calculation by noticing that the smaller of v1 and v2
! will always remain unchanged.  Finally, we can check if the larger vector
! needs to change by checking the condition (asuming v1 is the larger)
!
!   norm(v1) - dot_product(v1, v2) / norm(v1)  > Pi

!dnew = sqrt(sum( (v2 - v1)**2 )) ! for debugging

v1n = sqrt(sum( v1**2 ))
v2n = sqrt(sum( v2**2 ))
if ( v1n > v2n ) then
   d = v1n - dot_product(v1, v2) / v1n
   if (d > PID) then
      v1 = v1 * (1.D0 - PID2/v1n)
   endif
else
   d = v2n - dot_product(v1, v2) / v2n
   if (d > PID) then
      v2 = v2 * (1.D0 - PID2/v2n)
   endif
endif
!dnewnew = sqrt(sum( (v2 - v1)**2 )) !js850>
!if (dold > 2) write(*,*) "js850>", dold, dnew, dnewnew !js850>
!if (dnewnew > 3) write(*,*) "js850> something may have gone wrotg"
return
end subroutine aadistance
