      SUBROUTINE SBM(qo,NATOMS,grad,energy,GTEST,STEST)
      USE KEY
      implicit NONE
      INTEGER NATOMS,i,j
      DOUBLE PRECISION qo(3*NATOMS), grad(3*NATOMS)
      DOUBLE PRECISION ENERGY,STT

      LOGICAL :: CALLED=.FALSE.
      LOGICAL GTEST, STEST
        integer NSBMMAX
        parameter(NSBMMAX=5000)
      DOUBLE PRECISION  Rb(NSBMMAX), bK(NSBMMAX), ANTC(NSBMMAX),
     Q Tk(NSBMMAX), PK(NSBMMAX), PHISBM(NSBMMAX), Sigma(NSBMMAX*5),
     Q EpsC(NSBMMAX*5),NNCsigma(NSBMMAX,NSBMMAX),NCswitch,NCcut
      INTEGER  Ib1(NSBMMAX), Ib2(NSBMMAX), IT(NSBMMAX), JT(NSBMMAX),
     Q KT(NSBMMAX),IP(NSBMMAX), JP(NSBMMAX), KP(NSBMMAX),
     Q LP(NSBMMAX), IC(NSBMMAX*5), JC(NSBMMAX*5),
     Q  PHITYPE(NSBMMAX),NBA, NTA, NPA, NC
        integer CONTACTTYPE
        logical used(NSBMMAX,NSBMMAX)
        common /double precision/ Rb, bK, ANTC, Tk,PK, PHISBM,
     Q sigma, epsC, NNCsigma,NCswitch,NCcut,STT
        common /int/ PHITYPE, Ib1, Ib2, IT, JT, KT, IP,
     Q JP, KP, LP,IC, JC, NBA, NTA, NPA, NC,
     Q  CONTACTTYPE
        common /logical/ used

        if(NATOMS.gt. NSBMMAX)then
        write(*,*) 'TOO MANY ATOMS FOR SBM, change NSBMMAX'
        STOP
        endif

       if(.NOT.CALLED)then

        write(*,*)  'Using a Structure-based SMOG model, described in:'
        write(*,*)  'Whitford, et al. Prot. Struct. Func. Bioinfo. 75, 430-441, 2009.'

          do i=1,NATOMS-1
          do j=i+1,NATOMS
                used(i,j) =.FALSE.
                used(j,i) =.FALSE.
          enddo
          enddo




       call SBMinit(NATOMS,Ib1, Ib2,Rb, bK, IT, JT, KT, ANTC, Tk, IP, 
     Q JP, KP, LP, PK, PHITYPE,PHISBM,IC, JC, Sigma, 
     Q EpsC, NNCsigma,NBA, NTA, NPA, NC, NCswitch,NCcut,STT,
     Q NSBMMAX,CONTACTTYPE)

        if(NBA .gt. NSBMMAX .or. NTA .gt. NSBMMAX .or.
     Q  NPA .gt. NSBMMAX .or. NC .gt. 5*NSBMMAX)then
        write(*,*) 'increase array size'
        stop
        endif 

        CALLED=.TRUE.
        endIF
! call the energy routine

      call calc_energy_SBM(qo,natoms, GRAD, energy, Ib1, Ib2,
     Q Rb, bK, IT, JT, KT, ANTC, Tk, IP, JP, KP, LP, PK,
     Q PHITYPE,PHISBM,IC, JC, Sigma, EpsC, 
     Q  NNCsigma,NBA, NTA, NPA, NC, NCswitch,STT,NCcut,CONTACTTYPE,used)


      IF (STEST) THEN
         PRINT '(A)','ERROR - second derivatives not available'
         STOP
      ENDIF
      return
      end





!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
!* SBMinit() reads the atom positions from file.  If 1 is selected for *
!* startt then the velocities are assigned, otherwise, they are read   *
!* by selecting 2, or generated by selecting 3                         *
!***********************************************************************

      subroutine SBMinit(NATOMS,Ib1, Ib2,Rb, bK, IT, JT, KT, ANTC, Tk,
     Q  IP, JP, KP, LP, PK,PHITYPE,PHISBM,IC, JC, Sigma, 
     Q EpsC, NNCsigma, NBA, 
     Q NTA, NPA, NC,NCswitch,NCcut,STT,NSBMMAX,CONTACTTYPE)
      USE KEY
      implicit NONE

        integer i,j,MaxCon,NNCmax,NATOMS,storage, dummy,  ANr, IB11,
     Q IB12, Ib22, Ib21,IT1, JT1, KT1, IT2, JT2, KT2, IP1, JP1,
     Q KP1, LP1, IP2, JP2, KP2,
     Q LP2, nBA1, nTA1, nPA1, nBA2, nTA2, nPA2,  ind1, ind2, ANt,
     Q  MDT1, MDT2, cl1, cl2,tempi,NSBMMAX

      DOUBLE PRECISION  Rb(NSBMMAX), bK(NSBMMAX), ANTC(NSBMMAX), 
     Q Tk(NSBMMAX), PK(NSBMMAX), PHISBM(NSBMMAX),
     Q Sigma(NSBMMAX*5), EpsC(NSBMMAX*5),  
     Q NNCsigma(NATOMS,NATOMS),NCswitch,NCcut,STT
      INTEGER  Ib1(NSBMMAX), Ib2(NSBMMAX), IT(NSBMMAX), JT(NSBMMAX), 
     Q KT(NSBMMAX),IP(NSBMMAX), JP(NSBMMAX), KP(NSBMMAX),
     Q LP(NSBMMAX), IC(NSBMMAX*5), JC(NSBMMAX*5), 
     Q  NBA, NTA, NPA, NC
      INTEGER PHITYPE(NSBMMAX)
       DOUBLE PRECISION  pinitmax, TK1, TK2,  APTtemp, msT,
     Q SigmaT1, SigmaT2, epstemp
        character(LEN=20) FMTB, FMTT, FMTP, CA, RP
      integer AA,BB,ANTEMP
      DOUBLE PRECISION dx,dy,dz
       double precision PI
        DOUBLE PRECISION RSig, Reps
        logical TEMPARRAY
        dimension TEMPARRAY(NATOMS,NATOMS)
        integer CONTACTTYPE
      pi = 3.14159265358979323846264338327950288419716939937510

        NNCmax = NATOMS*NATOMS
        MaxCon=NATOMS*5
! old formatting
        FMTB="(3I5,2F8.3)"
        FMTT="(4I5,2F8.3)"
        FMTP="(5I5,2F8.3)"
        CA="(3I5,F10.3, F9.6)"
        RP="(I5,2I5, 2F8.3)"

        do i=1,NATOMS
                do j=1,NATOMS
                TEMPARRAY(i,j)=.TRUE.
                enddo
        enddo



! These lines read in the parameters.
        open(30, file='SBM.INP', status='old', access='sequential')

        read(30,*)
        read(30,*)
        read(30,*) RSig, Reps,NCswitch,NCcut
        write(*,*) RSig, Reps,NCswitch,NCcut
        
        read(30,*) ANtemp
        write(*,*) ANtemp
        do i=1, ANtemp
          read(30,*) 
        end do

        read(30,*) 
        read(30,*) NC
        write(*,*) NC, 'contacts'        
        read(30,*) CONTACTTYPE

          if(NC .gt. MaxCon)then
             write(*,*) 'too many contacts'
             STOP
          endif

        do i=1, NC
          read(30, *) IC(i), JC(i), Sigma(i), EpsC(i)
        end do

          read(30,*)
          read(30,*) nBA

        do i=1, nBA
          read(30,*) Ib1(i), Ib2(i),Rb(i), bK(i)
          TEMPARRAY(Ib1(i), Ib2(i))=.FALSE.
          TEMPARRAY(Ib2(i), Ib1(i))=.FALSE.
        end do

! read non-native interactions
!        read(30,*)
!        read(30,*) NNC

!        do i=1,NATOMS
!                do j=1,NATOMS
!                TEMPARRAY(i,j)=.TRUE.
!                enddo
!        enddo

!        if(NNC .gt. NNCmax)then
!        write(*,*) 'too many non contacts'
!        STOP
!        endif        
!        do i=1, NNC
!           read(30,*) AA,BB
!           TEMPARRAY(AA,BB)=.FALSE.
!           TEMPARRAY(BB,AA)=.FALSE.
!        enddo

!        tempi=0

!        do i=1,NATOMS-1
!                do j=i+1,NATOMS
!                if(TEMPARRAY(i,j) .eqv. .TRUE.)then
!                  tempi=tempi+1
!                  INC(tempi)=i
!                  JNC(tempi)=j
!                  NCsigma(tempi)=rsig**2
!                  NNCeps(tempi)=reps
! this simplifies calculations later
!         NNCsigma(tempi) = NNCEps(tempi)*NCsigma(tempi)**6
!                endif
!                enddo
!        end do

!        NNC=tempi
!        write(*,*) NNC, 'noc'

          read(30,*)
          read(30,*) nTA
        do i=1, nTA
          read(30,*) IT(i), JT(i), KT(i), ANTC(i), Tk(i)
          TEMPARRAY(IT(i), JT(i))=.FALSE.
          TEMPARRAY(JT(i), IT(i))=.FALSE.
          TEMPARRAY(IT(i), KT(i))=.FALSE.
          TEMPARRAY(KT(i), IT(i))=.FALSE.
          TEMPARRAY(JT(i), KT(i))=.FALSE.
          TEMPARRAY(KT(i), JT(i))=.FALSE.
        enddo

          read(30,*) 
          read(30,*) nPA

! this reads in the dihedral angles and calculates the cosines and sines
! in order to make the force and energy calculations easier, later.
        do i=1, npA
           read(30,*) IP(i),JP(i),KP(i),LP(i),
     Q  PHITYPE(i),PHISBM(i),PK(i)
          TEMPARRAY(IP(i), JP(i))=.FALSE.
          TEMPARRAY(JP(i), IP(i))=.FALSE.
          TEMPARRAY(IP(i), KP(i))=.FALSE.
          TEMPARRAY(KP(i), IP(i))=.FALSE.
          TEMPARRAY(IP(i), LP(i))=.FALSE.
          TEMPARRAY(LP(i), IP(i))=.FALSE.
          TEMPARRAY(JP(i), KP(i))=.FALSE.
          TEMPARRAY(KP(i), JP(i))=.FALSE.
          TEMPARRAY(JP(i), LP(i))=.FALSE.
          TEMPARRAY(LP(i), JP(i))=.FALSE.
          TEMPARRAY(KP(i), LP(i))=.FALSE.
          TEMPARRAY(LP(i), KP(i))=.FALSE.
        
        END DO


        do i=1,NATOMS-1
                do j=i+1,NATOMS
                if(TEMPARRAY(i,j) .eqv. .TRUE.)then
! this simplifies calculations later
         NNCsigma(i,j) = reps*rsig**12
         NNCsigma(j,i) = reps*rsig**12
                else
         NNCsigma(i,j) = 0
         NNCsigma(j,i) = 0

		endif
                enddo
        end do

		STT=reps*rsig**12
!        read(30,*) AN
       close(30)
       end

!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^end of SBMinit^^^^^^^^^^^^^^^^^^^^^^^^^^^^^


C
C Calculate the Forces and energies
C
      subroutine calc_energy_SBM(qo,natoms,GRAD, energy,Ib1, Ib2,
     Q Rb, bK, IT, JT, KT, ANTC, Tk, IP, JP, KP, LP, PK,
     Q PHITYPE,PHISBM,IC, JC, Sigma, EpsC, 
     Q NNCsigma,NBA, NTA, NPA, NC,NCswitch,STT,NCcut,CONTACTTYPE,used)

      INTEGER I, J, NATOMS,NBA, NTA, NPA, NC

      DOUBLE PRECISION qo(3*NATOMS), grad(3*NATOMS), ENERGY
      DOUBLE PRECISION x(NATOMS), y(NATOMS), z(NATOMS)

        DOUBLE PRECISION Rb(NBA), bK(NBA), ANTC(NTA), Tk(NTA), PK(NPA), 
     Q PHISBM(NPA), Sigma(NC),NCswitch,NCcut,STT, 
     Q EpsC(NC),  NNCsigma(NATOMS,NATOMS)
        INTEGER Ib1(NBA), Ib2(NBA), IT(NTA), JT(NTA), KT(NTA),IP(NPA), 
     Q JP(NPA), KP(NPA), LP(NPA), IC(NC), JC(NC),
     Q PHITYPE(NPA),CONTACTTYPE
      DOUBLE PRECISION dx,dy,dz
        logical used(NATOMS,NATOMS)
      do i = 1, natoms
         j = (i-1)*3
         x(i) = qo(j+1)
         y(i) = qo(j+2)
         z(i) = qo(j+3)
         grad(j+1) = 0.0
        grad(j+2) = 0.0
        grad(j+3) = 0.0
      enddo

      energy = 0.0
      call SBMbonds(x,y,z,grad, energy, natoms,Ib1, Ib2,Rb, bK,NBA)
      call SBMangl(x,y,z,grad, energy, natoms,IT,JT,KT,ANTC,Tk,NTA)
        call SBMDihedral(x,y,z,grad, energy, natoms,IP,JP,KP,LP,PK,
     Q PHITYPE,PHISBM,NPA)
        call SBMContacts(x,y,z,grad, energy, natoms, IC, JC, 
     Q Sigma, EpsC, NC,CONTACTTYPE)
        call SBMNonContacts(x,y,z,grad, energy, natoms, 
     Q NNCsigma,NCswitch,NCcut,STT,used)

      end


!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
!* SBMBonds  computes the hookean force and energy between chosen atoms *
!***********************************************************************

      subroutine SBMBonds(x,y,z,grad,energy, natoms,Ib1, Ib2,Rb, bK,NBA)
      USE KEY
      implicit NONE
      integer I2, J2,  outE,I, N, J, NATOMS, NBA
      DOUBLE PRECISION x(NATOMS), y(NATOMS), z(NATOMS), grad(3*NATOMS),
     Q energy
      DOUBLE PRECISION r2, f, r1
      DOUBLE PRECISION dx,dy,dz

        DOUBLE PRECISION Rb(NBA), bK(NBA)
        INTEGER Ib1(NBA), Ib2(NBA)


        do 1 i=1, nBA
           I2 = Ib1(i)
           J2 = Ib2(i)
        dx = X(I2) - X(J2)
        dy = Y(I2) - Y(J2)
        dz = Z(I2) - Z(J2)

          r2 = dx**2 + dy**2 + dz**2
          r1 = sqrt(r2)

! energy calculation
             Energy = Energy + bk(i)*(r1-Rb(i))**2/2.0

! End energy calculation

! f_over_r is the force over the magnitude of r so there is no need to resolve
! the dx, dy and dz into unit vectors

! the index i indicates the interaction between particle i and i+1

             f = -bk(i)*(r1-Rb(i))/r1
!            f = Rb(i)*bK(i)/r1 - bK(i)
        !write(*,*) i, f
            ! now add the force
              grad(I2*3-2) = grad(I2*3-2) - f * dx
              grad(I2*3-1) = grad(I2*3-1) - f * dy
              grad(I2*3)   = grad(I2*3)   - f * dz
! the negative sign is due to the computation of dx, dy and dz
              grad(J2*3-2) = grad(J2*3-2) + f * dx
              grad(J2*3-1) = grad(J2*3-1) + f * dy
              grad(J2*3)   = grad(J2*3)   + f * dz

1         continue
      !STOP
      END

!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^END OF SBMBONDS^^^^^^^^^^^^^^^^^^^^^^^^^^^^^


!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
!* SBMANGL  computes the Force due to the bond angles                   *
!* This code is modeled after how AMBER performs angle forces           *
!***********************************************************************

      SUBROUTINE SBMANGL(x,y,z,grad, energy, NATOMS,IT, JT, KT, 
     Q ANTC, Tk,NTA)
      USE KEY
      implicit NONE
      integer NATOMS
      DOUBLE PRECISION x(NATOMS), y(NATOMS), z(NATOMS), grad(3*NATOMS),
     Q energy
      integer I, N, J, NTA
      LOGICAL SKIP,NOCRST

      DOUBLE PRECISION CST,EAW,RIJ,RKJ,RIK,DFW,ANT,XIJ,YIJ,
     + ZIJ,XKJ,YKJ,
     + ZKJ, DF
      dimension  XIJ(NTA),YIJ(NTA),ZIJ(NTA),XKJ(NTA),YKJ(NTA),
     + ZKJ(NTA),CST(NTA),EAW(NTA),RIJ(NTA),RKJ(NTA),RIK(NTA),
     + DFW(NTA),ANT(NTA)
      DOUBLE PRECISION CT0, CT1, CT2, RIJ0, RKJ0, RIK0, ANT0, DA, ST, 
     + CIK, CII, CKK, DT1, DT2, DT3, DT4, DT5, DT6, DT7, DT8, DT9, pt999
     Q , ebal,STH


        DOUBLE PRECISION ANTC(NTA), Tk(NTA)
        INTEGER JN, IT(NTA), JT(NTA), KT(NTA)
        INTEGER I3, J3, K3

      data pt999 /1.0d0/
      ebal= 0.0d0


          DO JN = 1, nTA
            I3 = IT(JN)
            J3 = JT(JN)
            K3 = KT(JN)

            XIJ(JN) = X(I3)-X(J3)
            YIJ(JN) = Y(I3)-Y(J3)
            ZIJ(JN) = Z(I3)-Z(J3)
            XKJ(JN) = X(K3)-X(J3)
            YKJ(JN) = Y(K3)-Y(J3)
            ZKJ(JN) = Z(K3)-Z(J3)
          END DO
          DO JN = 1,nTA
            RIJ0 = XIJ(JN)*XIJ(JN)+YIJ(JN)*YIJ(JN)+ZIJ(JN)*ZIJ(JN)
            RKJ0 = XKJ(JN)*XKJ(JN)+YKJ(JN)*YKJ(JN)+ZKJ(JN)*ZKJ(JN)
            RIK0 = SQRT(RIJ0*RKJ0)
            CT0 = (XIJ(JN)*XKJ(JN)+YIJ(JN)*YKJ(JN)+ZIJ(JN)*ZKJ(JN))/RIK0
            CT1 = MAX(-pt999,CT0)
            CT2 = MIN(pt999,CT1)
            CST(JN) = CT2
            ANT(JN) = ACOS(CT2)
            RIJ(JN) = RIJ0
            RKJ(JN) = RKJ0
            RIK(JN) = RIK0
          END DO

! end of insertion


          DO JN = 1,nTA
            ANT0 = ANT(JN)
            DA = ANT0 - ANTC(JN)
            DF = TK(JN)*DA


            DFW(JN) = -(DF)/SIN(ANT0)

          END DO
          DO JN = 1,nTA
            I3 = IT(JN)
            J3 = JT(JN)
            K3 = KT(JN)
            ST = DFW(JN)
            STH = ST*CST(JN)
            CIK = ST/RIK(JN)
            CII = STH/RIJ(JN)
            CKK = STH/RKJ(JN)
            DT1 = CIK*XKJ(JN)-CII*XIJ(JN)
            DT2 = CIK*YKJ(JN)-CII*YIJ(JN)
            DT3 = CIK*ZKJ(JN)-CII*ZIJ(JN)
            DT7 = CIK*XIJ(JN)-CKK*XKJ(JN)
            DT8 = CIK*YIJ(JN)-CKK*YKJ(JN)
            DT9 = CIK*ZIJ(JN)-CKK*ZKJ(JN)
            DT4 = -DT1-DT7
            DT5 = -DT2-DT8
            DT6 = -DT3-DT9
C

            grad(I3*3-2) = grad(I3*3-2)+ DT1
            grad(I3*3-1) = grad(I3*3-1)+ DT2
            grad(I3*3)   = grad(I3*3)  + DT3
            grad(J3*3-2) = grad(J3*3-2)+ DT4
            grad(J3*3-1) = grad(J3*3-1)+ DT5
            grad(J3*3)   = grad(J3*3)  + DT6
            grad(K3*3-2) = grad(K3*3-2)+ DT7
            grad(K3*3-1) = grad(K3*3-1)+ DT8
            grad(K3*3)   = grad(K3*3)  + DT9

          END DO
! Energy Calculations


          do i=1, nTA
             energy = energy + TK(i)*(ANTC(i)- ANT(i))**2/2.0
          end do

       RETURN
       END

!^^^^^^^^^^^^^^^^^^^^^^^^End of SBMANGL^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
!* SBMdihedral computes the dihedral angles and the forces due to them *
!**********************************************************************

      SUBROUTINE SBMdihedral(x,y,z,grad, energy, NATOMS,IP,JP,KP,LP,PK,
     Q PHITYPE,PHISBM,NPA)
      USE KEY
      implicit NONE
      integer I, N, J, NATOMS, NPA, JN
      DOUBLE PRECISION x(NATOMS),y(NATOMS),z(NATOMS),
     Q grad(3*NATOMS),energy


      DOUBLE PRECISION PK(NPA),PHISBM(NPA)
      INTEGER IP(NPA), JP(NPA), KP(NPA), LP(NPA) 
      INTEGER PHITYPE(NPA)

      double precision lfac
      integer I3, J3, K3, L3
      double precision  XIJ,YIJ,ZIJ,XKJ,YKJ,
     + ZKJ,XKL,YKL,ZKL,RIJ, RKJ,RKL,DX,DY,
     + DZ, GX,GY,GZ,CT,CPHI,
     + SPHI,Z1, Z2,FXI,FYI,FZI,
     + FXJ,FYJ,FZJ, FXK,FYK,FZK,
     + FXL,FYL,FZL,DF,Z10,Z20,Z12,Z11,Z22,ftem,CT0,CT1,AP0,AP1,
     + Dums,DFLIM, DF1, DF0, DR1, DR2,DR3,DR4,DR5,DR6,DRX,DRY,DRZ,
     +  DC1, DC2, DC3, DC4, DC5, DC6,S,HGoverG,FGoverG,A1,A3

      DIMENSION XIJ(NPA),YIJ(NPA),ZIJ(NPA),RIJ(NPA),XKJ(NPA),
     + YKJ(NPA),
     + ZKJ(NPA),RKJ(NPA),XKL(NPA),YKL(NPA),ZKL(NPA),RKL(NPA),DX(NPA),
     + DY(NPA),
     + DZ(NPA), GX(NPA),GY(NPA),GZ(NPA),CT(NPA),CPHI(NPA),
     + SPHI(NPA),Z1(NPA), Z2(NPA),FXI(NPA),FYI(NPA),FZI(NPA),
     + FXJ(NPA),FYJ(NPA),FZJ(NPA), FXK(NPA),FYK(NPA),FZK(NPA),
     + FXL(NPA),FYL(NPA),FZL(NPA),DF(NPA),FGoverG(NPA),HGoverG(NPA)
C
      double precision  TM24,TM06,tenm3,zero,one,two,four,six,twelve

      DOUBLE PRECISION TT1, TT2, TT3, TT4, TT1X,TT1Y,TT1Z,TT2X,TT2Y,
     + TT2Z, TT3X, TT3Y, TT3Z, TT4X, TT4Y, TT4Z

      DATA TM24,TM06,tenm3/1.0d-24,1.0d-06,1.0d-03/
      data zero,one,two,four,six,twelve/0.d0,1.d0,2.d0,4.d0,6.d0,12.d0/

      double precision pi
      pi = 3.14159265358979323846264338327950288419716939937510

          DO JN = 1,nPA

            I3 = IP(JN)
            J3 = JP(JN)
            K3 = KP(JN)
            L3 = LP(JN)

 

            XIJ(JN) = X(I3)-X(J3)
            YIJ(JN) = Y(I3)-Y(J3)
            ZIJ(JN) = Z(I3)-Z(J3)
            XKJ(JN) = X(K3)-X(J3)
            YKJ(JN) = Y(K3)-Y(J3)
            ZKJ(JN) = Z(K3)-Z(J3)
            RKJ(JN) = sqrt(XKJ(JN)**2+YKJ(JN)**2+ZKJ(JN)**2)
            XKL(JN) = X(K3)-X(L3)
            YKL(JN) = Y(K3)-Y(L3)
            ZKL(JN) = Z(K3)-Z(L3)                                  


            FGoverG(JN)=-(XIJ(JN)*XKJ(JN)+YIJ(JN)*YKJ(JN)+
     Q   ZIJ(JN)*ZKJ(JN))/RKJ(JN)
            HGoverG(JN)=(XKL(JN)*XKJ(JN)+YKL(JN)*YKJ(JN)+
     Q   ZKL(JN)*ZKJ(JN))/RKJ(JN)
          END DO
C DX is the M vector and G is the N vector
          DO JN = 1,nPA
            DX(JN) = YIJ(JN)*ZKJ(JN)-ZIJ(JN)*YKJ(JN)
            DY(JN) = ZIJ(JN)*XKJ(JN)-XIJ(JN)*ZKJ(JN)
            DZ(JN) = XIJ(JN)*YKJ(JN)-YIJ(JN)*XKJ(JN)
            GX(JN) = ZKJ(JN)*YKL(JN)-YKJ(JN)*ZKL(JN)
            GY(JN) = XKJ(JN)*ZKL(JN)-ZKJ(JN)*XKL(JN)
            GZ(JN) = YKJ(JN)*XKL(JN)-XKJ(JN)*YKL(JN)
          END DO
C


! so far so good


          DO JN = 1,nPA
            FXI(JN) = SQRT(DX(JN)*DX(JN)
     Q                    +DY(JN)*DY(JN)
     Q                    +DZ(JN)*DZ(JN))
            FYI(JN) = SQRT(GX(JN)*GX(JN)
     Q                    +GY(JN)*GY(JN)
     Q                    +GZ(JN)*GZ(JN))
            CT(JN) = DX(JN)*GX(JN)+DY(JN)*GY(JN)+DZ(JN)*GZ(JN)
          END DO

         DO JN = 1,nPA
            z10 = 1.0/FXI(jn)
            z20 = 1.0/FYI(jn)
            Z12 = Z10*Z20
            Z1(JN) = Z10
            Z2(JN) = Z20
            ftem = zero
            CT0 = MIN(one,CT(JN)*Z12)
            CT1 = MAX(-one,CT0)
            S = XKJ(JN)*(DZ(JN)*GY(JN)-DY(JN)*GZ(JN))+
     Q          YKJ(JN)*(DX(JN)*GZ(JN)-DZ(JN)*GX(JN))+
     Q          ZKJ(JN)*(DY(JN)*GX(JN)-DX(JN)*GY(JN))
            AP0 = ACOS(CT1)
            AP1 = PI-SIGN(AP0,S)

            CT(JN) = AP1
            CPHI(JN) = COS(AP1)
            SPHI(JN) = SIN(AP1)
         END DO


        DO JN = 1,nPA
!            CT0 = CT(JN)
! Here is the energy part
          A1=CT(JN)-PHISBM(JN)
          A3=A1*3

        if(PHITYPE(JN) .eq. 1)then
          Energy =  Energy + PK(JN)*(3.0/2.0-cos(A1)-0.5*cos(A3))
! dE/dPHI
            DF(JN)=PK(JN)*(sin(A1)+1.5*sin(A3))
        elseif(PHITYPE(JN) .eq. 2)then
          if(A1 .gt. PI)then
                A1=A1-2*PI
          elseif(A1 .lt. -PI)then
                A1=A1+2*PI
          endif

          Energy =  Energy + PK(JN)*A1**2
! dE/dPHI
            DF(JN)=2*PK(JN)*A1

        else

        write(*,*) 'unrecognized dihedral type', PHITYPE(JN)
        STOP
        endif
        END DO



! insert the new 

       ! now, do dPhi/dX

         DO JN = 1,nPA

! |G|/|A|**2 
            TT1 = Z1(JN)*Z1(JN)*RKJ(JN)*DF(JN)
! FG/(A**2*|G|)
            TT2 = FGoverG(JN)*Z1(JN)*Z1(JN)*DF(JN)
! HG/(B**2*|G|)
            TT3 = HGoverG(JN)*Z2(JN)*Z2(JN)*DF(JN)
! |G|/|B|**2 
            TT4 = Z2(JN)*Z2(JN)*RKJ(JN)*DF(JN)


! note: negatives are flipped from paper because A=-DX
        TT1X=TT1*DX(JN)
        TT1Y=TT1*DY(JN)
        TT1Z=TT1*DZ(JN)

        TT2X=TT2*DX(JN)
        TT2Y=TT2*DY(JN)
        TT2Z=TT2*DZ(JN)


        TT3X=TT3*GX(JN)
        TT3Y=TT3*GY(JN)
        TT3Z=TT3*GZ(JN)


        TT4X=TT4*GX(JN)
        TT4Y=TT4*GY(JN)
        TT4Z=TT4*GZ(JN)

            I3 = IP(JN)
            J3 = JP(JN)
            K3 = KP(JN)
            L3 = LP(JN)


            grad(I3*3-2) =  grad(I3*3-2)  + TT1X  
            grad(I3*3-1) =  grad(I3*3-1)  + TT1Y
            grad(I3*3)   =  grad(I3*3)    + TT1Z
            grad(J3*3-2) =  grad(J3*3-2)  - TT1X - TT2X - TT3X
            grad(J3*3-1) =  grad(J3*3-1)  - TT1Y - TT2Y - TT3Y
            grad(J3*3)   =  grad(J3*3)    - TT1Z - TT2Z - TT3Z
            grad(K3*3-2) =  grad(K3*3-2)  + TT2X + TT3X - TT4X
            grad(K3*3-1) =  grad(K3*3-1)  + TT2Y + TT3Y - TT4Y
            grad(K3*3)   =  grad(K3*3)    + TT2Z + TT3Z - TT4Z
            grad(L3*3-2) =  grad(L3*3-2)  + TT4X
            grad(L3*3-1) =  grad(L3*3-1)  + TT4Y
            grad(L3*3)   =  grad(L3*3)    + TT4Z

          END DO

          END


!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^END of SBMDihedral^^^^^^^^^^^^^^^^^^^^^^^^^^^


!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
!* SBMCONTACTS: computes the force on all atoms due to contacts via a   *
!* 10-12 or 6-12 potential                                              *
!***********************************************************************

      subroutine SBMcontacts(x,y,z,grad,energy,
     Q NATOMS,IC,JC,Sigma,EpsC,NC,CONTACTTYPE)
      USE KEY
      implicit NONE
      integer I, N, J,NATOMS,NC

      DOUBLE PRECISION x(NATOMS), y(NATOMS), z(NATOMS) 
     Q , grad(3*NATOMS), energy
      DOUBLE PRECISION dx,dy,dz

      integer C1, C2, ConfID, Q, SC1, SC2, Cf1, cf2
      DOUBLE PRECISION  r2, rm2, rm10, rm6,f_over_r, dsig, deps, 
     Q s1, s2, ep1, ep2, r1, rc,r, summm

        DOUBLE PRECISION Sigma(NC), EpsC(NC)
        INTEGER IC(NC), JC(NC),CONTACTTYPE


! type 1 is 6-12 interaction
        if(CONTACTTYPE .eq. 1)then

       do i=1, NC
       
        C1 = IC(i)
        C2 = JC(i)
        dx = X(C1) - X(C2)
        dy = Y(C1) - Y(C2)
        dz = Z(C1) - Z(C2)

          r2 = dx**2 + dy**2 + dz**2

              rm2 = 1.0/r2
              rm2 = rm2*sigma(i)
              rm6 = rm2**3

        energy = energy + epsC(i)*rm6*(rm6-2.0)

        f_over_r = -epsC(i)*12.0*rm6*(rm6-1.0)/r2

              grad(3*C1-2) = grad(3*C1-2) + f_over_r * dx
              grad(3*C1-1) = grad(3*C1-1) + f_over_r * dy
              grad(3*C1)   = grad(3*C1)   + f_over_r * dz

              grad(3*C2-2) =  grad(3*C2-2) - f_over_r * dx
              grad(3*C2-1) =  grad(3*C2-1) - f_over_r * dy
              grad(3*C2)   =  grad(3*C2)   - f_over_r * dz
              enddo

! type 2 is 10-12 interaction
        elseif(CONTACTTYPE .eq. 2)then
       do i=1, NC
       
        C1 = IC(i)
        C2 = JC(i)
        dx = X(C1) - X(C2)
        dy = Y(C1) - Y(C2)
        dz = Z(C1) - Z(C2)

          r2 = dx**2 + dy**2 + dz**2

              rm2 = 1.0/r2
              rm2 = rm2*sigma(i)
              rm10 = rm2**5

        energy = energy + epsC(i)*rm10*(5*rm2-6.0)
        f_over_r = -epsc(i)*60.0*rm10*(rm2-1.0)/r2

              grad(3*C1-2) = grad(3*C1-2) + f_over_r * dx
              grad(3*C1-1) = grad(3*C1-1) + f_over_r * dy
              grad(3*C1)   = grad(3*C1)   + f_over_r * dz

              grad(3*C2-2) =  grad(3*C2-2) - f_over_r * dx
              grad(3*C2-1) =  grad(3*C2-1) - f_over_r * dy
              grad(3*C2)   =  grad(3*C2)   - f_over_r * dz
              enddo

        else
        write(*,*) CONTACTTYPE, 'is not a valid contact selection'
        stop
        endif


      end

!^^^^^^^^^^^^^^^^^^^^^^^^^^^^end of SBMContacts^^^^^^^^^^^^^^^^^^^^^^^^^^^


!<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
!* SBMNonContacts computes the forces due to non native contacts       *
!**********************************************************************

      subroutine SBMnoncontacts(x,y,z,grad, energy, 
     Q NATOMS,NNCsigma,NCswitch,NCcut,STT,used)
      USE KEY
      implicit NONE
      integer I, N, J, AN, NATOMS


      DOUBLE PRECISION x(NATOMS), y(NATOMS), z(NATOMS), 
     Q grad(3*NATOMS), energy,STT,SA,SB,SC

      integer C1, C2, ii,jj,kk,k,l,iii,jjj
      DOUBLE PRECISION  r2, rm2, rm14, f_over_r, NCswitch,NCcut 


        DOUBLE PRECISION NNCsigma(NATOMS,NATOMS)
      DOUBLE PRECISION dx,dy,dz
	integer tempN, temparray,alpha
        logical used
        dimension used(NATOMS,NATOMS)
	double precision Rdiff,Vfunc,Ffunc
	double precision Rcut2,Rswitch2
	! Ngrid is the number of atoms in that grid point
	! grid is the array of atoms in each grid
	integer Ngrid,grid,maxgrid,maxpergrid
	! number of atoms per grid, max
	parameter (maxpergrid=2000)
	dimension temparray(NATOMS*NATOMS,2)
	! dimensions of grid
	parameter (maxgrid=15)
	dimension Ngrid(maxgrid,maxgrid,maxpergrid),
     Q  grid(maxgrid,maxgrid,maxgrid,maxpergrid)
	integer MaxGridX,MaxGridY,MaxGridZ
	double precision gridsize,RD1
	double precision minX,minY,minZ,maxX,maxY,maxZ
	integer Xgrid,Ygrid,Zgrid
	double precision Etemp
	Rdiff=NCcut-NCswitch
	alpha=12


	GRIDSIZE=NCcut*1.01
	Rcut2=NCcut**2
	Rswitch2=NCswitch**2

	SB=-1.0/Rdiff**3*( 2*alpha*STT/NCcut**(alpha+1)  + 
     Q    (alpha)*(alpha+1)*STT*Rdiff/NCcut**(alpha+2)   )

	SA=-(alpha*(alpha+1)*STT/NCcut**(alpha+2)+3*SB*Rdiff**2)/(2*Rdiff)

	SC=-(STT/NCcut**alpha+SA/3.0*Rdiff**3+SB/4.0*Rdiff**4)




!! make a neighbor list

	minX=10000000
	minY=10000000
	minZ=10000000
	
	maxX=-10000000
	maxY=-10000000
	maxZ=-10000000

	do i=1,NATOMS
	   if(X(i) .gt. maxX)then
		maxX=X(i)
	   endif

	   if(Y(i) .gt. maxY)then
		maxY=Y(i)
	   endif

	   if(Z(i) .gt. maxZ)then
		maxZ=Z(i)
	   endif

	   if(X(i) .lt. minX)then
		minX=X(i)
	   endif

	   if(Y(i) .lt. minY)then
		minY=Y(i)
	   endif

	   if(Z(i) .lt. minZ)then
		minZ=Z(i)
	   endif
	enddo

	maxgridX=int((maxX-minX)/gridsize)+1
	maxgridY=int((maxY-minY)/gridsize)+1
	maxgridZ=int((maxZ-minZ)/gridsize)+1
!	write(*,*) gridsize, maxgrid
!	write(*,*) maxgridX,maxgridY,maxgridZ
!	write(*,*) minX,maxX
!	write(*,*) minY,maxY
!	write(*,*) minZ,maxZ

	if(maxgridX .ge. maxgrid .or. 
     Q  maxgridY .ge. maxgrid .or.
     Q  maxgridZ .ge. maxgrid )then
	write(*,*) 'system got too big for grid searching...'
!call abort
	endif

	do i=1,maxgrid
	 do j=1,maxgrid
	  do k=1,maxgrid
		Ngrid(i,j,k)=0
	  enddo
	 enddo
	enddo
	do i=1,NATOMS

		Xgrid=int((X(i)-minX)/gridsize)+1
		Ygrid=int((Y(i)-minY)/gridsize)+1
		Zgrid=int((Z(i)-minZ)/gridsize)+1
	!	write(*,*) Xgrid,Ygrid,Zgrid
		Ngrid(Xgrid,Ygrid,Zgrid)=Ngrid(Xgrid,Ygrid,Zgrid)+1
!		write(*,*) Ngrid(Xgrid,Ygrid,Zgrid),Xgrid,Ygrid,Zgrid
		if(Ngrid(Xgrid,Ygrid,Zgrid) .gt. maxpergrid)then
			write(*,*) 'too many atoms in a grid'
			write(*,*) Ngrid(Xgrid,Ygrid,Zgrid),Xgrid,Ygrid,Zgrid
!		call abort
	        endif
		grid(Xgrid,Ygrid,Zgrid,Ngrid(Xgrid,Ygrid,Zgrid))=i
	enddo



!!        do i=1,NATOMS-1
!!                do j=i+1,NATOMS

	   tempN=0
	do i=1,maxgridX
	 do j=1,maxgridY
	  do k=1,maxgridZ

	   do ii=i-1,i+1
	    do jj=j-1,j+1
	     do kk=k-1,k+1
           if(i .ge. 1 .and. j .ge. 1 .and. k .ge. 1)then
	   if(i .eq. ii .and. j .eq. jj .and. k .eq. kk)then


          do iii=1,Ngrid(i,j,k)-1
           do jjj=iii+1,Ngrid(i,j,k)

	   C1=grid(i,j,k,iii)
	   C2=grid(i,j,k,jjj)
  	   if(NNCsigma(C1,C2) .gt. 0 .or. NNCsigma(C2,C1) .gt. 0)then
! only count each once
                 tempN=tempN+1
                 temparray(tempN,1)=C1
                 temparray(tempN,2)=C2
	   endif
           enddo
          enddo
 
	else

	  do iii=1,Ngrid(i,j,k)
	   do jjj=1,Ngrid(ii,jj,kk)
	   C1=grid(i,j,k,iii)
	   C2=grid(ii,jj,kk,jjj)

  	   if(NNCsigma(C1,C2) .gt. 0 .or. NNCsigma(C2,C1) .gt. 0)then
		 tempN=tempN+1
		 temparray(tempN,1)=C1
		 temparray(tempN,2)=C2
	   endif

	   enddo
	  enddo

	  endif

        endif
	    enddo
	   enddo
	  enddo

	  enddo
	  enddo
	  enddo
!	write(*,*) 'list prepared'
	!write(*,*) tempN, 'pairs'

!end of making list
	   do i=1,tempN
           
           C1 = temparray(i,1)
           C2 = temparray(i,2)
	   !ST=NNCsigma(C1,C2)

	if(used(C1,C2) .neqv. .TRUE.)then
        used(C1,C2) = .TRUE.
        used(C2,C1) = .TRUE.

        dx = X(C1) - X(C2)

         dy = Y(C1) - Y(C2)

        dz = Z(C1) - Z(C2)

          r2 = dx**2 + dy**2 + dz**2
        etemp=0

	  if(r2 .le. Rcut2)then
             rm2 = 1/r2
             rm14 = rm2**7

		etemp=STT*rm2**6+SC
		f_over_r=-STT*12.0*rm14

!NCsigma(i), NNCeps(i)
		RD1=sqrt(r2)-NCswitch
		if(r2 .gt. Rswitch2)then

			f_over_r=f_over_r+(SA*RD1**2+SB*RD1**3)*sqrt(rm2)
			etemp=etemp+SA/3.0*RD1**3+SB/4.0*RD1**4

		elseif(r2 .lt. Rswitch2)then

		! normal repulsive term

		else
		! things should have fallen in one of the previous two...
		write(*,*) 'something went wrong with switching function'
!	call abort
		endif

                energy = energy  + etemp


!		if(r2 .gt. Rswitch2*0.999 .and. r2 .lt. Rswitch2*1.001)then
		!write(*,*) 'etemp',sqrt(r2),f_over_r,etemp
!		endif


! f_over_r is the force over the magnitude of r so there is no need to resolve
! the dx, dy and dz into unit vectors

! now add the acceleration 
              grad(C1*3-2) = grad(C1*3-2) + f_over_r * dx
              grad(C1*3-1) = grad(C1*3-1) + f_over_r * dy
              grad(C1*3)   = grad(C1*3)   + f_over_r * dz

               grad(C2*3-2) =  grad(C2*3-2) - f_over_r * dx
              grad(C2*3-1) =  grad(C2*3-1) - f_over_r * dy
              grad(C2*3)   =  grad(C2*3)  -  f_over_r * dz
 	   endif

	    endif

	    enddo

           do i=1,tempN
           
           C1 = temparray(i,1)
           C2 = temparray(i,2)
	   !ST=NNCsigma(C1,C2)

                used(C1,C2) = .FALSE.
                used(C2,C1) = .FALSE.
           enddo


!!           end do
!!	enddo

      END

!^^^^^^^^^^^^^^^^^^^^^^^^^^^End of SBMNonContacts^^^^^^^^^^^^^^^^^^^^^^^^^


