      SUBROUTINE GTHOMSON(X,V,ETHOMSON,GTEST,STEST)
      USE commons
      USE key
      USE MODHESS
      IMPLICIT NONE
      LOGICAL GTEST, STEST
      INTEGER J1, J2, J3, J4
      INTEGER LNATOMS
      DOUBLE PRECISION X(*), DIST, V(*), ETHOMSON
      DOUBLE PRECISION :: TMPCOORDS(9*NATOMS/2), DR(3), Gradient11(3), Gradient12(3), Gradient21(3), Gradient22(3) 

      LNATOMS=(NATOMS/2)*3
      CALL GTHOMSONANGTOC(TMPCOORDS(1:3*LNATOMS),X(1:2*LNATOMS),LNATOMS)      

      ETHOMSON=0.0D0
      V(1:2*LNATOMS)=0.0D0
      IF (STEST) THEN
         HESS(1:2*LNATOMS,1:2*LNATOMS) = 0.0D0
      ENDIF

      DO J1=1,LNATOMS-1
         J3=3*J1

         IF (GTEST) THEN
            IF ( GTHOMMET .EQ. 1) THEN
               CALL GRADMETRICCYLINDER (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( GTHOMMET .EQ. 2) THEN
               CALL GRADMETRICCATENOID (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
               CALL GRADMETRICUNDULOID (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( GTHOMMET .EQ. 5 ) THEN
               CALL GRADMETRICSPHERE (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ENDIF
         ENDIF

         DO J2=J1+1,LNATOMS
            J4=3*J2
            DR(1) = TMPCOORDS(J3-2)-TMPCOORDS(J4-2)
            DR(2) = TMPCOORDS(J3-1)-TMPCOORDS(J4-1)
            DR(3) = TMPCOORDS(J3  )-TMPCOORDS(J4  )
            DIST  = SQRT(DOT_PRODUCT(DR, DR))

            IF (GTHOMPOT .EQ. 1) THEN
               ETHOMSON = ETHOMSON + 1/DIST ! Coulomb
            ELSEIF (GTHOMPOT .EQ. 2) THEN 
               ETHOMSON = ETHOMSON + 1/DIST**3 ! 1/R^3
            ELSEIF (GTHOMPOT .EQ. 3) THEN
               ETHOMSON = ETHOMSON + 1/DIST*EXP(-1.0D0*DIST/GThomsonSigma)                !Yukawa
            ELSEIF (GTHOMPOT .EQ. 4) THEN
               ETHOMSON = ETHOMSON + (GThomsonSigma/DIST)**12 - (GThomsonSigma/DIST)**6  ! LJ
            ELSEIF (GTHOMPOT .EQ. 5) THEN
               ETHOMSON = ETHOMSON + (GThomsonSigma/DIST)**12                            !Repulsive LJ 
            ELSEIF (GTHOMPOT .EQ. 6) THEN
               ETHOMSON = ETHOMSON + (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST)))**2 -1.0D0 ! Morse
            ENDIF

            IF (GTEST) THEN

               IF (GTHOMPOT .EQ. 1) THEN
                  V(2*J1-1) = V(2*J1-1) - 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient12)               
               ELSEIF (GTHOMPOT .EQ. 2) THEN 
                  V(2*J1-1) = V(2*J1-1) - 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient12)               
               ELSEIF (GTHOMPOT .EQ. 3) THEN
                  V(2*J1-1) = V(2*J1-1) - (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient12)               
               ELSEIF (GTHOMPOT .EQ. 4) THEN
                  V(2*J1-1) = V(2*J1-1) - ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8)) &
                       * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8)) & 
                       * DOT_PRODUCT(DR,Gradient12)
               ELSEIF (GTHOMPOT .EQ. 5) THEN
                  V(2*J1-1) = V(2*J1-1) - (12.0D0*GThomsonSigma**12/DIST**14)* DOT_PRODUCT(DR,Gradient11) ! Repulsive LJ
                  V(2*J1  ) = V(2*J1  ) - (12.0D0*GThomsonSigma**12/DIST**14)* DOT_PRODUCT(DR,Gradient12) ! Replusive LJ
               ELSEIF (GTHOMPOT .EQ. 6) THEN
                  V(2*J1-1) = V(2*J1-1) + 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) &
                        * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                        * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient11) ! Morse
                  V(2*J1  ) = V(2*J1  ) + 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) &
                        * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                        * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient12) ! Morse
               ENDIF
               
               IF ( GTHOMMET .EQ. 1) THEN
                  CALL GRADMETRICCYLINDER (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( GTHOMMET .EQ. 2) THEN
                  CALL GRADMETRICCATENOID (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
                  CALL GRADMETRICUNDULOID (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( GTHOMMET .EQ. 5 ) THEN
                  CALL GRADMETRICSPHERE (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ENDIF


               IF (GTHOMPOT .EQ. 1) THEN
                  V(2*J2-1) = V(2*J2-1) + 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient21)               
                  V(2*J2  ) = V(2*J2  ) + 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 2) THEN 
                  V(2*J2-1) = V(2*J2-1) + 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient21)               
                  V(2*J2  ) = V(2*J2  ) + 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 3) THEN
                  V(2*J2-1) = V(2*J2-1) + (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient21)               
                  V(2*J2  ) = V(2*J2  ) + (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 4) THEN
                  V(2*J2-1) = V(2*J2-1) + ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8))&
                       * DOT_PRODUCT(DR,Gradient21)
                  V(2*J2  ) = V(2*J2  ) + ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8))&
                       * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 5) THEN
                  V(2*J2-1) = V(2*J2-1) + (12.0D0*GThomsonSigma**12/DIST**14)* &
                                DOT_PRODUCT(DR,Gradient21) ! Repulsive LJ
                  V(2*J2  ) = V(2*J2  ) + (12.0D0*GThomsonSigma**12/DIST**14)* &
                                DOT_PRODUCT(DR,Gradient22) ! Repulsive LJ
               ELSEIF (GTHOMPOT .EQ. 6) THEN
                  V(2*J2-1) = V(2*J2-1) - 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) &
                                * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                                * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient21)
                  V(2*J2  ) = V(2*J2  ) - 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) &
                                * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                                * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient22) 
               ENDIF
               !PRINT *, 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient2), (1/DIST2 - 1/DIST)/0.00001
            ENDIF

         ENDDO
       
      ENDDO

      IF (STEST) THEN
         CALL GTHOMSONHESSIAN(X,HESS)
      ENDIF

      RETURN
    END SUBROUTINE GTHOMSON


!  Subroutine to convert Cartesians to theta, phi.

      SUBROUTINE GTHOMSONCTOANG(COORDS,P,NATOMS,MYUNIT)
      USE key, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET, GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      INTEGER NATOMS, J1, MYUNIT
      DOUBLE PRECISION COORDS(3*NATOMS), P(2*NATOMS), DIST
      DOUBLE PRECISION :: pi, phi, u
      DOUBLE PRECISION, PARAMETER :: HALFPI=1.570796327D0
      DOUBLE PRECISION RADIUS

      IF (GTHOMMET .EQ. 5) THEN
         RADIUS = GTHOMSONZ
      ENDIF

      pi = 4.0D0*ATAN(1.0D0)

      DO J1=1,NATOMS

         IF ( (COORDS(3*J1-2) .GE. 0.0D0) .AND. (COORDS(3*J1-1) .GE. 0.0D0) ) THEN
            IF ( ABS(COORDS(3*J1-2)) < 1.0D-5) THEN
               P(2*J1-1) = HALFPI
            ELSE IF ( ABS(COORDS(3*J1-1)) < 1.0D-5) THEN
               P(2*J1-1) = 0.0D0
            ELSE
               P(2*J1-1) = ATAN(COORDS(3*J1-1)/COORDS(3*J1-2))
            ENDIF
         ELSEIF ( (COORDS(3*J1-2) < 0.0D0) .AND. (COORDS(3*J1-1) .GE. 0.0D0) ) THEN
            IF ( ABS(COORDS(3*J1-1)) < 1.0D-5) THEN
               P(2*J1-1) = 2*HALFPI
            ELSE
               P(2*J1-1) = 2*HALFPI - ATAN(COORDS(3*J1-1)/(-COORDS(3*J1-2)))
            ENDIF
         ELSEIF ( (COORDS(3*J1-2) < 0.0D0) .AND. (COORDS(3*J1-1) < 0.0D0) ) THEN
               P(2*J1-1) = 2*HALFPI + ATAN(COORDS(3*J1-1)/COORDS(3*J1-2))
         ELSEIF ( (COORDS(3*J1-2) .GE. 0.0D0) .AND. (COORDS(3*J1-1) < 0.0D0) ) THEN
            IF ( ABS(COORDS(3*J1-2)) < 1.0D-5) THEN
               P(2*J1-1) = 3*HALFPI
            ELSE
               P(2*J1-1) = 4*HALFPI - ATAN(-COORDS(3*J1-1)/COORDS(3*J1-2))
            ENDIF
         ENDIF

         IF ( (GTHOMMET .EQ. 1) .OR. (GTHOMMET .EQ. 2) ) THEN

            IF (COORDS(3*J1) > GThomsonZ) COORDS(3*J1) = GThomsonZ
            IF (COORDS(3*J1) <-GThomsonZ) COORDS(3*J1) = -GThomsonZ
            P(2*J1) = ACOS(COORDS(3*J1)/GThomsonZ)

         ELSE IF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) )  THEN

            IF ( ABS(COS(P(2*J1-1))) < 1.0D-5 ) THEN
               u = ASIN( (COORDS(3*J1-1)**2- GTn)/GTm )/GTmu
            ELSE
               u = ASIN( (COORDS(3*J1-2)/COS(P(2*J1-1)))**2/GTm - GTn/GTm )/GTmu
            ENDIF

            IF ( GTHOMMET .EQ. 3 ) THEN
               IF (COORDS(3*J1) .GE. 0.0D0) u = u+2*pi/GTmu
               IF (COORDS(3*J1) <    0.0D0) u = pi/GTmu-u
            ELSEIF ( GTHOMMET .EQ. 4 ) THEN
               IF (COORDS(3*J1) .GE. 0.0D0) u = pi/GTmu-u
            ENDIF

            phi = (u - GTrefU/GTmu)*GTmu/pi/GThomsonZ
            if (phi > 1.0D0) phi = 1.0D0
            if (phi <-1.0D0) phi =-1.0D0
            P(2*J1) = ACOS(phi)

         ELSE IF ( GTHOMMET .EQ. 5 )  THEN
            
            IF ( COORDS(3*J1) < 0.0D0 ) THEN               
               P(2*J1) = 2*HALFPI - ACOS(-COORDS(3*J1)/RADIUS)
            ELSE
               IF ( COORDS(3*J1)/RADIUS .GE. 1.0D0 ) THEN
                  P(2*J1) = 0.0D0
               ELSE IF ( COORDS(3*J1)/RADIUS .LE. -1.0D0 ) THEN
                  P(2*J1) = 2*HALFPI
               ELSE
                  P(2*J1) = ACOS(COORDS(3*J1)/RADIUS)
               ENDIF
            ENDIF

         ENDIF
         
         IF ( P(2*J1-1) > 4*HALFPI ) P(2*J1-1) = P(2*J1-1) - 4*HALFPI 
         IF ( P(2*J1-1) < 0.0D0    ) P(2*J1-1) = P(2*J1-1) + 4*HALFPI 
         IF ( P(2*J1  ) > 4*HALFPI ) P(2*J1  ) = P(2*J1  ) - 4*HALFPI 
         IF ( P(2*J1  ) < 0.0D0    ) P(2*J1  ) = P(2*J1  ) + 4*HALFPI 

      ENDDO

!      P(2*NATOMS+1:3*NATOMS) = 0.0D0

      RETURN
      
    END SUBROUTINE GTHOMSONCTOANG

!----------------------------------------------------------------
!  Subroutine to convert theta, phi to Cartesians.

      SUBROUTINE GTHOMSONANGTOC(COORDS,P,NATOMS)
      USE key, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET, GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      INTEGER NATOMS, J1
      DOUBLE PRECISION COORDS(3*NATOMS), P(2*NATOMS)
      DOUBLE PRECISION :: pi, Felint, Selint, u
      DOUBLE PRECISION :: ARG1, COSHARG
      DOUBLE PRECISION :: RADIUS

      IF (GTHOMMET .EQ. 5) THEN
         RADIUS = GTHOMSONZ
      ENDIF

      pi = 4.0D0*ATAN(1.0D0)

!      TMPCOORDS(1:3*NATOMS) = P(1:3*NATOMS)
      DO J1=1,NATOMS
         IF ( GTHOMMET .EQ. 1) THEN
            COORDS(3*(J1-1)+1)= GThomsonC * COS(P(2*J1-1))
            COORDS(3*(J1-1)+2)= GThomsonC * SIN(P(2*J1-1))
            COORDS(3*(J1-1)+3)= GThomsonZ * COS(P(2*J1))

         ELSE IF ( GTHOMMET .EQ. 2) THEN
            COSHARG = GThomsonC * COSH(GThomsonZ/GThomsonC*COS(P(2*J1)))
            COORDS(3*(J1-1)+1)= COSHARG * COS(P(2*J1-1))
            COORDS(3*(J1-1)+2)= COSHARG * SIN(P(2*J1-1))
            COORDS(3*(J1-1)+3)= GThomsonZ * COS(P(2*J1))

         ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN

            u = GTrefU/GTmu + GThomsonZ*pi/GTmu * COS(P(2*J1))
            CALL EllipIntegral(Felint, Selint, (GTmu*u/2.0D0-pi/4.0D0), GTk)
            ARG1 = SQRT(GTm*SIN(GTmu*u)+GTn)
            COORDS(3*(J1-1)+1) = ARG1 * COS(P(2*J1-1))
            COORDS(3*(J1-1)+2) = ARG1 * SIN(P(2*J1-1))
            COORDS(3*(J1-1)+3) = GTa*Felint + GTc*Selint

            IF (GTHOMMET .EQ. 3) THEN
               COORDS(3*(J1-1)+3) = COORDS(3*(J1-1)+3) - GTrefZ
            ENDIF

         ELSE IF ( GTHOMMET .EQ. 5) THEN

            ARG1 = RADIUS * SIN(P(2*J1))
            COORDS(3*J1-2)= ARG1 * COS(P(2*J1-1))
            COORDS(3*J1-1)= ARG1 * SIN(P(2*J1-1))
            COORDS(3*J1  )= RADIUS * COS(P(2*J1))

         ENDIF
      ENDDO
      RETURN
    END SUBROUTINE GTHOMSONANGTOC

!----------------------------------------------------------------
! Initialization of random coordinates
      SUBROUTINE INIGTHOMSON ()

      USE key, ONLY : GTHOMMET, GTHOMSONZ, GTHOMSONC2, GTHOMSONC, GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      DOUBLE PRECISION pi, c, a, Felint, Selint
      INTEGER NP, J1

      NP = 1

      IF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN

         pi = 4.0D0*ATAN(1.0D0)
         IF (GTHOMMET .EQ. 3) THEN
            GTrefU = 1.50D0*pi
         ELSEIF (GTHOMMET .EQ. 4) THEN
            GTrefU = 0.50D0*pi
         ENDIF
         IF (GThomsonC > GThomsonC2) THEN
            c = GThomsonC
            a = GThomsonC2
         ELSE
            c = GThomsonC2
            a = GThomsonC
         ENDIF
         GTa = a
         GTc = c
         GTmu = 2.0D0/(a+c)
         GTk = SQRT(1-(a/c)**2)
         GTm = (c**2-a**2)/2.0D0
         GTn = (c**2+a**2)/2.0D0      
      ENDIF
      IF (GTHOMMET .EQ. 3) THEN
         CALL EllipIntegral(Felint, Selint, (GTrefU/2.0D0-pi/4.0D0), GTk)
         GTrefZ = GTa*Felint + GTc*Selint
      ENDIF

    END SUBROUTINE INIGTHOMSON

!----------------------------------------------------------------
! unduloid     
      SUBROUTINE GRADMETRICCYLINDER (X, Gradient1, Gradient2)

      USE key, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)

      Gradient1(1) = -GThomsonC * SIN(X(1))
      Gradient1(2) =  GThomsonC * COS(X(1))
      Gradient1(3) =  0.0D0

      Gradient2(1) = 0.0D0
      Gradient2(2) = 0.0D0
      Gradient2(3) = -GThomsonZ * SIN(X(2))

      END SUBROUTINE GRADMETRICCYLINDER

!----------------------------------------------------------------
! catenoid      
      SUBROUTINE GRADMETRICCATENOID (X, Gradient1, Gradient2)

      USE key, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2), ARGHY, COSHA, SINHA, SINX2, SINX1, COSX1
      
      ARGHY = GThomsonZ/GThomsonC*COS(X(2))
      COSHA = COSH(ARGHY)
      SINHA = SINH(ARGHY)
      SINX2 = SIN(X(2))
      SINX1 = SIN(X(1))
      COSX1 = COS(X(1))
      Gradient1(1) = -GThomsonC * COSHA * SINX1
      Gradient1(2) =  GThomsonC * COSHA * COSX1
      Gradient1(3) =  0.0D0

      Gradient2(1) = -GThomsonZ * SINHA * COSX1 * SINX2
      Gradient2(2) = -GThomsonZ * SINHA * SINX1 * SINX2
      Gradient2(3) = -GThomsonZ * SINX2

    END SUBROUTINE GRADMETRICCATENOID

!----------------------------------------------------------------
! unduloid      
      SUBROUTINE GRADMETRICUNDULOID (X, Gradient1, Gradient2)

      USE key, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET,   GTrefU, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)
      DOUBLE PRECISION :: pi, u
      DOUBLE PRECISION :: ARG1, ARG2, SINMU, CSINX2

      pi = 4.0D0*ATAN(1.0D0)

      u = GTrefU/GTmu + GThomsonZ*pi/GTmu * COS(X(2))
      
      ARG1 = SQRT(GTm*SIN(GTmu*u)+GTn)
      ARG2 = 0.5D0 / ARG1 * GTm * GTmu * COS(GTmu*u)
      SINMU = SIN(GTmu*u/2.0D0-pi/4.0D0)
      Gradient2(1) = ARG2* COS(X(1))
      Gradient2(2) = ARG2* SIN(X(1))
      Gradient2(3) = 1.0D0*(GTmu/2.0D0)*(GTa/SQRT(1-GTk**2*(SINMU)**2) + GTc*SQRT(1-GTk**2*(SINMU)**2))

      CSINX2 = GThomsonZ*pi/GTmu * SIN(X(2))
      Gradient2(1) = -Gradient2(1) *  CSINX2
      Gradient2(2) = -Gradient2(2) *  CSINX2
      Gradient2(3) = -Gradient2(3) *  CSINX2

      Gradient1(1) =-ARG1 * SIN(X(1))
      Gradient1(2) = ARG1 * COS(X(1))
      Gradient1(3) = 0.0D0


    END SUBROUTINE GRADMETRICUNDULOID

!----------------------------------------------------------------
! SPHERE
      SUBROUTINE GRADMETRICSPHERE (X, Gradient1, Gradient2)
        
        USE key, ONLY : GThomsonZ, GTHOMMET
        IMPLICIT NONE
        DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)
        DOUBLE PRECISION ARG1, ARG2, ARG3, ARG4
        DOUBLE PRECISION RADIUS
        
        IF ( GTHOMMET .EQ. 5 ) THEN
           RADIUS = GTHOMSONZ
        ENDIF
        
        ARG1 = SIN(X(1))
        ARG2 = COS(X(1))
        ARG3 = SIN(X(2))
        ARG4 = COS(X(2))
        
        Gradient1(1) = -ARG3 * ARG1 * RADIUS
        Gradient1(2) =  ARG3 * ARG2 * RADIUS
        Gradient1(3) =  0.0D0
        
        Gradient2(1) = ARG4 * ARG2 * RADIUS
        Gradient2(2) = ARG4 * ARG1 * RADIUS
        Gradient2(3) = - ARG3 * RADIUS
        
      END SUBROUTINE GRADMETRICSPHERE

!----------------------------------------------------------------
! Check limits of the unduloids      
      SUBROUTINE FINDNGZ()

      USE key, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET
      IMPLICIT NONE
      DOUBLE PRECISION :: c, a, pi, mu, k, m, n, Felint, Selint, u
      DOUBLE PRECISION :: refZ, refU, TEMPZ, GZMIN, GZMAX, ZPOS
      LOGICAL :: TEST

      TEMPZ = GThomsonZ
      GZMAX = 1.0D0
      GZMIN = 0.0D0
      TEST = .FALSE.

      pi = 4.0D0*ATAN(1.0D0)
      IF (GTHOMMET .EQ. 3) THEN
         refU = 1.50D0*pi
      ELSEIF (GTHOMMET .EQ. 4) THEN
         refU = 0.50D0*pi
      ENDIF

      IF (GThomsonC > GThomsonC2) THEN
         c = GThomsonC
         a = GThomsonC2
      ELSE
         c = GThomsonC2
         a = GThomsonC
      ENDIF
      mu = 2.0D0/(a+c)
      k = SQRT(1-(a/c)**2)
      m = (c**2-a**2)/2.0D0
      n = (c**2+a**2)/2.0D0      

      u = refU/mu + GZMAX*pi/mu
      CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)
      ZPOS = a*Felint + c*Selint
      IF (GTHOMMET .EQ. 3) THEN
         CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
         refZ = a*Felint + c*Selint
         ZPOS = ZPOS -refZ
      ENDIF

      IF ( (ZPOS < TEMPZ) .OR. (ZPOS < 0) ) THEN
         PRINT *, "ERROR in the definition of unduloids"
         STOP
      ENDIF

      DO WHILE ( (.NOT. TEST) )
         GThomsonZ = (GZMAX + GZMIN)/2.0D0
         u    = refU/mu + GThomsonZ*pi/mu
         CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)
         ZPOS = a*Felint + c*Selint
         IF (GTHOMMET .EQ. 3) THEN
            CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
            refZ = a*Felint + c*Selint
            ZPOS = ZPOS -refZ
         ENDIF

         IF (TEMPZ > ZPOS) GZMIN = GThomsonZ
         IF (TEMPZ < ZPOS) GZMAX = GThomsonZ

         IF ( (TEMPZ - ZPOS < 0.00001) .AND. (TEMPZ - ZPOS > -0.00001) ) THEN
            TEST = .TRUE.
            !PRINT *, GThomsonZ
         ENDIF
      ENDDO
      
    END SUBROUTINE FINDNGZ


!----------------------------------------------------------------
! Check limits of the unduloids      
      SUBROUTINE CONVERTUNDULOIDPARAMETERS(V)

      USE key, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET
      IMPLICIT NONE
      DOUBLE PRECISION :: c, a, pi, mu, k, m, n, Felint, Selint, u
      DOUBLE PRECISION :: refZ, refU, TEMPZ, GZMIN, GZMAX, ZPOS
      DOUBLE PRECISION :: amax, amin, cmax, cmin
      DOUBLE PRECISION :: V, Volume
      LOGICAL :: TEST, TEST2


      TEMPZ = GThomsonZ
      TEST2 = .FALSE.

      pi = 4.0D0*ATAN(1.0D0)
      IF (GTHOMMET .EQ. 3) THEN
         refU = 1.50D0*pi
      ELSEIF (GTHOMMET .EQ. 4) THEN
         refU = 0.50D0*pi
      ENDIF

      IF (GThomsonC > GThomsonC2) THEN
         c = GThomsonC
         a = GThomsonC2
      ELSE
         c = GThomsonC2
         a = GThomsonC
      ENDIF
      cmax = c
      cmin = a
      amax = c
      amin = a
 
      DO WHILE ( (.NOT. TEST2) )
         
         IF (GTHOMMET .EQ. 3) THEN
            c = (cmax + cmin)/2.0D0
         ELSE IF (GTHOMMET .EQ. 4) THEN
            a = (amax + amin)/2.0D0
         ENDIF

         GZMAX = 1.0D0
         GZMIN = 0.0D0
         TEST = .FALSE.
         mu = 2.0D0/(a+c)
         k = SQRT(1-(a/c)**2)
         m = (c**2-a**2)/2.0D0
         n = (c**2+a**2)/2.0D0      
                  
         DO WHILE ( (.NOT. TEST) )
            GThomsonZ = (GZMAX + GZMIN)/2.0D0
            u    = refU/mu + GThomsonZ*pi/mu
            CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)
            ZPOS = a*Felint + c*Selint
            IF (GTHOMMET .EQ. 3) THEN
               CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
               refZ = a*Felint + c*Selint
               ZPOS = ZPOS -refZ
            ENDIF
            
            IF (TEMPZ > ZPOS) GZMIN = GThomsonZ
            IF (TEMPZ < ZPOS) GZMAX = GThomsonZ
            
            IF ( (TEMPZ - ZPOS < 0.00001) .AND. (TEMPZ - ZPOS > -0.00001) ) THEN
               TEST = .TRUE.
            ENDIF
         ENDDO

         IF (GTHOMMET .EQ. 3) THEN

            CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)            
            Volume = pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(mu*u)+n)*COS(mu*u)
            CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
            Volume = Volume - ( pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(refU)+n)*COS(refU) )            
            IF (Volume > V) THEN 
               cmax = c
            ELSEIF (Volume < V) THEN
               cmin = c
            ENDIF

         ELSEIF (GTHOMMET .EQ. 4) THEN

            CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)            
            Volume = pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(mu*u)+n)*COS(mu*u)
            CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
            Volume = Volume - ( pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(refU)+n)*COS(refU) )            

            IF (Volume > V) THEN 
               amax = a
            ELSEIF (Volume < V) THEN
               amin = a
            ENDIF

         ENDIF

         IF ( (Volume - V < 0.00001) .AND. (Volume - V > -0.00001) ) THEN
            TEST2 = .TRUE.
         ENDIF

      ENDDO

      PRINT *, "GTHOMSONC ", c
      PRINT *, "GTHOMSONA ", a
      PRINT *, "umax ", GTHOMSONZ

      GThomsonC = c
      GThomsonC2 = a
      GThomsonZ = TEMPZ
         
      PRINT *, "zmax ", GTHOMSONZ

    END SUBROUTINE CONVERTUNDULOIDPARAMETERS


!----------------------------------------------------------------

    SUBROUTINE GTHOMSONHESSIAN(X,HESS)

      USE commons
      USE key
      IMPLICIT NONE
      LOGICAL GTEST
      INTEGER J1, J2, J3, J4, LNATOMS
      DOUBLE PRECISION X(*), DIST, D2VDR2, DVDR
      DOUBLE PRECISION :: TMPCOORDS(9*NATOMS/2), DR(3), Gradient11(3), Gradient12(3), Gradient21(3), Gradient22(3) 
      DOUBLE PRECISION :: HESS111(3), HESS112(3), HESS122(3)
      DOUBLE PRECISION :: HESS211(3), HESS212(3), HESS222(3)
      DOUBLE PRECISION :: HESS(3*NATOMS, 3*NATOMS)
      
      LNATOMS=(NATOMS/2)*3
      CALL GTHOMSONANGTOC(TMPCOORDS(1:3*LNATOMS),X(1:2*LNATOMS),LNATOMS)      
      HESS(1:2*LNATOMS,1:2*LNATOMS) = 0.0D0

      DO J1=1,LNATOMS
         J3=3*J1

         IF ( GTHOMMET .EQ. 1) THEN
            PRINT *, "METRIC NOT IMPLEMENTED IN HESSIAN"
            STOP
         ELSEIF ( GTHOMMET .EQ. 2) THEN
            CALL GRADMETRICCATENOID (X(2*J1-1:2*J1), Gradient11, Gradient12)
            CALL HESSMETRICCATENOID (X(2*J1-1:2*J1), HESS111, HESS112, HESS122)
         ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
            PRINT *, "METRIC NOT IMPLEMENTED IN HESSIAN"
            STOP
         ELSEIF ( GTHOMMET .EQ. 5 ) THEN
            CALL GRADMETRICSPHERE (X(2*J1-1:2*J1), Gradient11, Gradient12)
            CALL HESSMETRICSPHERE (X(2*J1-1:2*J1), HESS111, HESS112, HESS122)
         ENDIF
              
         DO J2=J1+1,LNATOMS
            J4=3*J2
            DR(1) = TMPCOORDS(J3-2)-TMPCOORDS(J4-2)
            DR(2) = TMPCOORDS(J3-1)-TMPCOORDS(J4-1)
            DR(3) = TMPCOORDS(J3  )-TMPCOORDS(J4  )
            DIST  = SQRT(DOT_PRODUCT(DR, DR))

            IF (GTHOMPOT .EQ. 1) THEN
               D2VDR2 =   3/DIST**5 
               DVDR   = - 1/DIST**3
            ELSEIF (GTHOMPOT .EQ. 2) THEN 
               PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
               STOP
            ELSEIF (GTHOMPOT .EQ. 3) THEN
               D2VDR2 =  ( 3/DIST**5 + 3/GThomsonSigma/DIST**4 + 1/GThomsonSigma**2/DIST**3 ) * EXP(-1.0D0*DIST/GThomsonSigma)
               DVDR   = -( 1/DIST**3 + 1/GThomsonSigma/DIST**2 ) * EXP(-1.0D0*DIST/GThomsonSigma)
            ELSEIF (GTHOMPOT .EQ. 4) THEN
               PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
               STOP
            ELSEIF (GTHOMPOT .EQ. 5) THEN
               PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
               STOP
            ELSEIF (GTHOMPOT .EQ. 6) THEN
               D2VDR2 =  (-2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                    * GThomsonRho / DIST**3) + (2.0D0 * (-1.0D0 + 2.0D0* EXP(GThomsonRho*(GThomsonSigma-DIST))) &
                    * EXP(GThomsonRho*(GThomsonSigma-DIST)) * GThomsonRho**2 / DIST**2)
               DVDR   =  2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                    * GThomsonRho / DIST
            ENDIF
        
            HESS(2*J1-1,2*J1-1) = HESS(2*J1-1,2*J1-1) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient11))**2 &
                 + DVDR * (DOT_PRODUCT(Gradient11,Gradient11)+ DOT_PRODUCT(DR,HESS111)) 
            HESS(2*J1  ,2*J1  ) = HESS(2*J1  ,2*J1  ) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient12))**2 &
                 + DVDR * (DOT_PRODUCT(Gradient12,Gradient12)+ DOT_PRODUCT(DR,HESS122)) 
            HESS(2*J1-1,2*J1  ) = HESS(2*J1-1,2*J1  ) +  D2VDR2 * DOT_PRODUCT(DR,Gradient11) * DOT_PRODUCT(DR,Gradient12) &
                 + DVDR * (DOT_PRODUCT(Gradient11,Gradient12) + DOT_PRODUCT(DR,HESS112)) 

            IF ( GTHOMMET .EQ. 1) THEN
            ELSEIF ( GTHOMMET .EQ. 2) THEN
               CALL GRADMETRICCATENOID (X(2*J2-1:2*J2), Gradient21, Gradient22)
               CALL HESSMETRICCATENOID (X(2*J2-1:2*J2), HESS211, HESS212, HESS222)
            ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
            ELSEIF ( GTHOMMET .EQ. 5 ) THEN
               CALL GRADMETRICSPHERE (X(2*J2-1:2*J2), Gradient21, Gradient22)
               CALL HESSMETRICSPHERE (X(2*J2-1:2*J2), HESS211, HESS212, HESS222)
            ENDIF

            HESS(2*J2-1,2*J2-1) = HESS(2*J2-1,2*J2-1) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient21))**2 &
                 + DVDR * (DOT_PRODUCT(Gradient21,Gradient21) - DOT_PRODUCT(DR,HESS211)) 
            HESS(2*J2  ,2*J2  ) = HESS(2*J2  ,2*J2  ) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient22))**2 &
                 + DVDR * (DOT_PRODUCT(Gradient22,Gradient22) - DOT_PRODUCT(DR,HESS222)) 
            HESS(2*J2-1,2*J2  ) = HESS(2*J2-1,2*J2  ) +  D2VDR2 * DOT_PRODUCT(DR,Gradient21) * DOT_PRODUCT(DR,Gradient22) &
                 + DVDR * (DOT_PRODUCT(Gradient11,Gradient12) - DOT_PRODUCT(DR,HESS212)) 
                    
            HESS(2*J1-1,2*J2-1) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient11) * DOT_PRODUCT(DR,Gradient21) &
                 - DVDR * DOT_PRODUCT(Gradient11,Gradient21)          
            HESS(2*J1-1,2*J2  ) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient11) * DOT_PRODUCT(DR,Gradient22) &
                 - DVDR * DOT_PRODUCT(Gradient11,Gradient22)
            HESS(2*J1  ,2*J2-1) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient12) * DOT_PRODUCT(DR,Gradient21) &
                 - DVDR * DOT_PRODUCT(Gradient12,Gradient21)
            HESS(2*J1  ,2*J2  ) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient12) * DOT_PRODUCT(DR,Gradient22) &
                 - DVDR * DOT_PRODUCT(Gradient12,Gradient22)

         ENDDO
      ENDDO

      DO J1=1,2*LNATOMS
         DO J2 = J1+1,2*LNATOMS
            HESS(J2,J1) = HESS(J1,J2)
         ENDDO
      ENDDO

      RETURN

    END SUBROUTINE GTHOMSONHESSIAN

!----------------------------------------------------------------

    SUBROUTINE GTHOMSONNUMHESSIAN(X,HESS)

      USE commons
      USE key
      IMPLICIT NONE
      INTEGER J1, J2, LNATOMS
      DOUBLE PRECISION :: X(3*NATOMS), X1(3*NATOMS), X2(3*NATOMS), DX, ETHOMSON
      DOUBLE PRECISION :: V1(3*NATOMS), V2(3*NATOMS)
      DOUBLE PRECISION :: HESS(3*NATOMS,3*NATOMS)
  
      DX = 0.00001
      LNATOMS = NATOMS/2*3

      DO J1=1,2*LNATOMS
         X1(:) = X(:)
         X1(J1) = X1(J1) - DX
         CALL GTHOMSON(X1,V1,ETHOMSON,.TRUE.,.FALSE.)
         X2(:) = X(:)
         X2(J1) = X2(J1) + DX
         CALL GTHOMSON(X2,V2,ETHOMSON,.TRUE.,.FALSE.)
     
         DO J2=J1,2*LNATOMS
            HESS(J1,J2) = (V2(J2)-V1(J2))/(2.0D0*DX)
            HESS(J2,J1) = HESS(J1,J2)
         END DO
      END DO
  
      RETURN
  
    END SUBROUTINE GTHOMSONNUMHESSIAN

!----------------------------------------------------------------
! catenoid      
      SUBROUTINE HESSMETRICCATENOID (X, HESS11, HESS12, HESS22)

      USE key, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION HESS11(3), HESS12(3), HESS22(3), X(2)
      DOUBLE PRECISION ARGHY, COSHA, SINHA, SINX2, SINX1, COSX2, COSX1

      COSX2 = COS(X(2))
      ARGHY = GThomsonZ/GThomsonC*COSX2
      COSHA = COSH(ARGHY)
      SINHA = SINH(ARGHY)
      SINX2 = SIN(X(2))
      SINX1 = SIN(X(1))
      COSX1 = COS(X(1))
      
      HESS11(1) = -GThomsonC * COSHA * COSX1
      HESS11(2) = -GThomsonC * COSHA * SINX1
      HESS11(3) =  0.0D0

      HESS12(1) =  GThomsonZ * SINHA * SINX1 * SINX2
      HESS12(2) = -GThomsonZ * SINHA * COSX1 * SINX2
      HESS12(3) =  0.0D0

      HESS22(1) = -GThomsonZ * COSX1 * (COSX2 * SINHA - GThomsonZ/GThomsonC *SINX2**2 *COSHA)
      HESS22(2) = -GThomsonZ * SINX1 * (COSX2 * SINHA - GThomsonZ/GThomsonC *SINX2**2 *COSHA)
      HESS22(3) = -GThomsonC * ARGHY

    END SUBROUTINE HESSMETRICCATENOID


!----------------------------------------------------------------
! sphere
      SUBROUTINE HESSMETRICSPHERE (X, HESS11, HESS12, HESS22)
        
        USE key, ONLY : GThomsonZ, GTHOMMET
        IMPLICIT NONE
        DOUBLE PRECISION HESS11(3), HESS12(3), HESS22(3), X(2)
        DOUBLE PRECISION ARG1, ARG2, ARG3, ARG4
        DOUBLE PRECISION RADIUS
        
        IF ( GTHOMMET .EQ. 5 ) THEN
           RADIUS = GTHOMSONZ
        ENDIF

        ARG1 = SIN(X(1))
        ARG2 = COS(X(1))
        ARG3 = SIN(X(2))
        ARG4 = COS(X(2))

        HESS11(1) = -ARG3 * ARG2 * RADIUS
        HESS11(2) = -ARG3 * ARG1 * RADIUS
        HESS11(3) = 0.0

        HESS12(1) = -ARG4 * ARG1 * RADIUS
        HESS12(2) =  ARG4 * ARG2 * RADIUS
        HESS12(3) = 0.0
        
        HESS22(1) = -ARG3 * ARG2 * RADIUS
        HESS22(2) = -ARG3 * ARG1 * RADIUS
        HESS22(3) = -ARG4 * RADIUS
        
      END SUBROUTINE HESSMETRICSPHERE

!
!  Orthogonalise VEC1 to overall rotations about the z axes.
!
    SUBROUTINE ORTHOGGTH(VEC1,Q,OTEST)
      USE KEY
      USE COMMONS
      IMPLICIT NONE
      INTEGER J1, J2, J3
      DOUBLE PRECISION Q(*), VEC1(*), DUMMY1, VECX(3*NATOMS), VECY(3*NATOMS), VECZ(3*NATOMS)
      LOGICAL OTEST

      VECX(1:3*NATOMS)=0.0D0; VECY(1:3*NATOMS)=0.0D0; VECZ(1:3*NATOMS)=0.0D0

      IF (GTHOMMET < 5) THEN
      
         DO J1=1,3*NATOMS,2
            VECZ(J1)=1.0D0
         ENDDO
         CALL VECNORM(VECZ,3*NATOMS)
         
         DUMMY1=0.0D0
         DO J2=1,3*NATOMS
            DUMMY1=DUMMY1+VEC1(J2)*VECZ(J2)
         ENDDO
         DO J2=1,3*NATOMS
            VEC1(J2)=VEC1(J2)-DUMMY1*VECZ(J2)
         ENDDO
         IF (OTEST) CALL VECNORM(VEC1,3*NATOMS)
         
         RETURN

      ELSE

         DO J1=1,3*NATOMS,2
            VECX(J1+1)=SIN(Q(J1))
            VECY(J1+1)=COS(Q(J1))
         ENDDO
         DO J1=2,3*NATOMS,2
            IF (SIN(Q(J1-1)).NE.0.0D0) THEN
               VECX(J1-1)= COS(Q(J1))*COS(Q(J1-1))/SIN(Q(J1))
               VECY(J1-1)=-COS(Q(J1))*SIN(Q(J1-1))/SIN(Q(J1))
            ENDIF
            VECZ(J1-1)=1.0D0
         ENDDO
         CALL VECNORM(VECX,3*NATOMS)
         CALL VECNORM(VECY,3*NATOMS)
         CALL VECNORM(VECZ,3*NATOMS)
         
         DUMMY1=0.0D0
         DO J2=1,3*NATOMS
            DUMMY1=DUMMY1+VEC1(J2)*VECX(J2)
         ENDDO
         DO J2=1,3*NATOMS
            VEC1(J2)=VEC1(J2)-DUMMY1*VECX(J2)
         ENDDO
         IF (OTEST) CALL VECNORM(VEC1,3*NATOMS)
         
         DUMMY1=0.0D0
         DO J2=1,3*NATOMS
            DUMMY1=DUMMY1+VEC1(J2)*VECY(J2)
         ENDDO
         DO J2=1,3*NATOMS
            VEC1(J2)=VEC1(J2)-DUMMY1*VECY(J2)
         ENDDO
         IF (OTEST) CALL VECNORM(VEC1,3*NATOMS)
         
         DUMMY1=0.0D0
         DO J2=1,3*NATOMS
            DUMMY1=DUMMY1+VEC1(J2)*VECZ(J2)
         ENDDO
         DO J2=1,3*NATOMS
            VEC1(J2)=VEC1(J2)-DUMMY1*VECZ(J2)
         ENDDO
         IF (OTEST) CALL VECNORM(VEC1,3*NATOMS)
         
         RETURN
      ENDIF

    END SUBROUTINE ORTHOGGTH
!
!  Eigenvalue shifting for the GThomson problem
!
    SUBROUTINE SHIFTHGTH(Q,NATOMS)
      USE KEY
      USE MODHESS
      IMPLICIT NONE
      INTEGER J1, J2, NATOMS
      DOUBLE PRECISION DUMMY, Q(3*NATOMS), VECX(3*NATOMS), VECY(3*NATOMS), VECZ(3*NATOMS)
      
      SHIFTED=.TRUE.
      
      VECX(1:3*NATOMS)=0.0D0; VECY(1:3*NATOMS)=0.0D0; VECZ(1:3*NATOMS)=0.0D0
      
      IF (GTHOMMET < 5) THEN
         DO J1=1,3*NATOMS,2
            VECZ(J1)=1.0D0
         ENDDO
         CALL VECNORM(VECZ,3*NATOMS)
         
         DO J1=1,3*NATOMS
            DO J2=1,3*NATOMS
               ! HESS(J2,J1)=HESS(J2,J1)+SHIFTL(1)*VECX(J2)*VECX(J1)+SHIFTL(2)*VECY(J2)*VECY(J1)+SHIFTL(3)*VECZ(J2)*VECZ(J1)
               HESS(J2,J1)=HESS(J2,J1)+SHIFTL(3)*VECZ(J2)*VECZ(J1)
            ENDDO
         ENDDO
         
         RETURN

      ELSE

         DO J1=1,3*NATOMS,2
            VECX(J1+1)=SIN(Q(J1))
            VECY(J1+1)=COS(Q(J1))
         ENDDO
         DO J1=2,3*NATOMS,2
            IF (SIN(Q(J1-1)).NE.0.0D0) THEN
               VECX(J1-1)= COS(Q(J1))*COS(Q(J1-1))/SIN(Q(J1))
               VECY(J1-1)=-COS(Q(J1))*SIN(Q(J1-1))/SIN(Q(J1))
            ENDIF
            VECZ(J1-1)=1.0D0
         ENDDO
         CALL VECNORM(VECX,3*NATOMS)
         CALL VECNORM(VECY,3*NATOMS)
         CALL VECNORM(VECZ,3*NATOMS)

         DO J1=1,3*NATOMS
            DO J2=1,3*NATOMS
               HESS(J2,J1)=HESS(J2,J1)+SHIFTL(1)*VECX(J2)*VECX(J1)+SHIFTL(2)*VECY(J2)*VECY(J1)+SHIFTL(3)*VECZ(J2)*VECZ(J1)
            ENDDO
         ENDDO
      
         RETURN

      END IF

    END SUBROUTINE SHIFTHGTH

! -------------------------------------------------

SUBROUTINE HKMINPERMDIST(COORDSB,COORDSA,NATOMS,DEBUG,BOXLX,BOXLY,BOXLZ,BULKT,TWOD,DISTANCE,DIST2,RIGID,RMATBEST)
USE KEY,ONLY : NPERMGROUP, NPERMSIZE, PERMGROUP, NSETS, SETS, STOCKT, GEOMDIFFTOL, AMBERT, &
  &            NFREEZE, NABT, RBAAT, ANGLEAXIS2, BESTPERM, LOCALPERMDIST, PULLT, EFIELDT, NTSITES, &
  &            RIGIDBODY, PERMDIST, OHCELLT, LPERMDIST, EYTRAPT, LOCALPERMCUT, LOCALPERMCUT2, &
  &            LOCALPERMCUTINC, NOINVERSION, &
  &            EDIFFTOL, GMAX, CONVR, ATOMMATCHDIST, NRANROT, GTHOMSONT, GTHOMMET ! hk286
USE MODCHARMM,ONLY : CHRMMT
USE MODAMBER9, ONLY: NOPERMPROCHIRAL, PROCHIRALH
USE INTCOMMONS, ONLY : INTMINPERMT, INTINTERPT, DESMINT, OLDINTMINPERMT, INTDISTANCET
USE INTCUTILS, ONLY : INTMINPERM, OLD_INTMINPERM, INTMINPERM_CHIRAL, INTDISTANCE
USE GENRIGID
IMPLICIT NONE

INTEGER :: MAXIMUMTRIES=10
INTEGER NATOMS, NPERM, PATOMS, NTRIES, NRB, OPNUM, BESTINVERT, I
INTEGER JTEMP, J3, INVERT, NORBIT1, NORBIT2, NCHOOSE2, NDUMMY, LPERM(NATOMS), J1, J2, NCHOOSE1, NROTDONE, NORBITB1, NORBITB2, &
  &     NCHOOSEB1, NCHOOSEB2
DOUBLE PRECISION DIST2, COORDSA(3*NATOMS), COORDSB(3*NATOMS), DISTANCE, DUMMYA(3*NATOMS), &
  &              DUMMYB(3*NATOMS), DUMMY(3*NATOMS), DX, DY, DZ
DOUBLE PRECISION BOXLX,BOXLY,BOXLZ,WORSTRAD,RMAT(3,3),ENERGY, VNEW(3*NATOMS), RMS, DBEST, XBEST(3*NATOMS)
DOUBLE PRECISION MAXE1, MAXE2, DISTANCE1, SAVECUT, DIST, AINIT, BINIT
DOUBLE PRECISION QBEST(4), SITESA(3*NTSITES), SITESB(3*NTSITES)
DOUBLE PRECISION ROTA(3,3), ROTINVA(3,3), ROTB(3,3), ROTINVB(3,3), ROTINVBBEST(3,3), ROTABEST(3,3), RMATBEST(3,3), TMAT(3,3)
DOUBLE PRECISION RMATCUMUL(3,3)
DOUBLE PRECISION REFXZ(3,3)
LOGICAL DEBUG, TWOD, RIGID, BULKT, PITEST, TNMATCH, BMTEST
DOUBLE PRECISION PDUMMYA(3*NATOMS), PDUMMYB(3*NATOMS), LDISTANCE, DUMMYC(3*NATOMS), XDUMMY
DOUBLE PRECISION BMDIST, BMCOORDS(3*NATOMS), BMCOORDSSV(3*NATOMS)
INTEGER NEWPERM(NATOMS), ALLPERM(NATOMS), SAVEPERM(NATOMS)
CHARACTER(LEN=5) ZSYMSAVE
COMMON /SYS/ ZSYMSAVE

NROTDONE=-1
MAXIMUMTRIES=MAX(MAXIMUMTRIES,NRANROT+1)

!
REFXZ(1:3,1:3)=0.0D0
REFXZ(1,1)=1.0D0; REFXZ(2,2)=-1.0D0; REFXZ(3,3)=1.0D0
!
! It is possible for the standard orientation to result in a distance that is worse than
! the starting distance. Hence we need to set XBEST here.
!
DUMMYA(1:3*NATOMS)=COORDSA(1:3*NATOMS)
DUMMYB(1:3*NATOMS)=COORDSB(1:3*NATOMS)
DBEST=1.0D100
CALL NEWMINDIST(DUMMYB,DUMMYA,NATOMS,DISTANCE,BULKT,TWOD,'AX    ',.FALSE.,RIGID,DEBUG,RMAT)
DBEST=DISTANCE**2
XBEST(1:3*NATOMS)=DUMMYA(1:3*NATOMS)
BESTINVERT=1
DO J1=1,NATOMS
   BESTPERM(1:NATOMS)=J1
ENDDO
RMATBEST(1:3,1:3)=RMAT(1:3,1:3)
ROTINVBBEST(1:3,1:3)=0.0D0
ROTINVBBEST(1,1)=1.0D0;ROTINVBBEST(2,2)=1.0D0;ROTINVBBEST(3,3)=1.0D0;
ROTABEST(1:3,1:3)=0.0D0
ROTABEST(1,1)=1.0D0;ROTABEST(2,2)=1.0D0;ROTABEST(3,3)=1.0D0;

!
! End of XBEST associated initialisation.
!
NROTDONE=-1
11 CONTINUE
NROTDONE=NROTDONE+1

INVERT=1
60 CONTINUE ! jump back here if INVERT changes sign.
   NCHOOSEB1=0
66 NCHOOSEB1=NCHOOSEB1+1
   NCHOOSEB2=0
31 NCHOOSEB2=NCHOOSEB2+1
   NCHOOSE1=0
65 NCHOOSE1=NCHOOSE1+1
   NCHOOSE2=0
30 NCHOOSE2=NCHOOSE2+1
DUMMYB(1:3*NATOMS)=COORDSB(1:3*NATOMS)
DUMMYA(1:3*NATOMS)=COORDSA(1:3*NATOMS)

DO J1=1,NATOMS
   ALLPERM(J1)=J1
ENDDO

! The optimal alignment returned by minpermdist is a local minimum, but may not
! be the global minimum. Calling MYORIENT first should put permutational isomers
! into a standard alignment and spot the global minimum zedro distance in one
! go. However, we also need to cycle over equivalent atoms in orbits using NCHOOSE2.
!
! Problems can occur if we don't use all the atoms specified by NORBIT1 and NORBIT2
! because of the numerical cutoffs employed in MYORIENT. We could miss the
! right orientation! 
!
! If we use MYORIENT to produce particular orientations then we end up aligning 
! COORDSA not with COORDSB but with the standard orientation of COORDSB in DUMMYB.
! We now deal with this by tracking the complete transformation, including the
! contribution of MYORIENT using ROTB and ROTINVB.
!

DISTANCE=0.0D0
IF (NFREEZE.LE.0) THEN
      IF ((PULLT.OR.EFIELDT.OR.TWOD.OR.(GTHOMSONT .AND. (GTHOMMET < 5)) ).AND.(INVERT.EQ.-1)) THEN ! reflect in xz plane
         DO J1=1,NATOMS
            DUMMYC(3*(J1-1)+1)=DUMMYA(3*(J1-1)+1)
            DUMMYC(3*(J1-1)+2)=-DUMMYA(3*(J1-1)+2)
            DUMMYC(3*(J1-1)+3)=DUMMYA(3*(J1-1)+3)
         ENDDO
      ELSE
         DUMMYC(1:3*NATOMS)=INVERT*DUMMYA(1:3*NATOMS)
      ENDIF 
      IF ((NRANROT.GT.0).AND.(NROTDONE.LE.NRANROT).AND.(NROTDONE.GT.0)) THEN
         IF (DEBUG) PRINT '(A,I6,A,G20.10)',' minpermdist> Trying random starting orientation number ',NROTDONE, &
  &                                         ' minimum distance=',SQRT(DBEST)
         NORBIT1=1; NORBIT2=1; NORBITB1=1; NORBITB2=1;
         ROTB(1:3,1:3)=0.0D0
         ROTB(1,1)=1.0D0; ROTB(2,2)=1.0D0; ROTB(3,3)=1.0D0
         ROTINVB(1:3,1:3)=0.0D0
         ROTINVB(1,1)=1.0D0; ROTINVB(2,2)=1.0D0; ROTINVB(3,3)=1.0D0
         ROTA(1:3,1:3)=0.0D0
         ROTA(1,1)=1.0D0; ROTA(2,2)=1.0D0; ROTA(3,3)=1.0D0
         ROTINVA(1:3,1:3)=0.0D0
         ROTINVA(1,1)=1.0D0; ROTINVA(2,2)=1.0D0; ROTINVA(3,3)=1.0D0
         RMAT(1:3,1:3)=0.0D0
         RMAT(1,1)=1.0D0; RMAT(2,2)=1.0D0; RMAT(3,3)=1.0D0
         CALL RANROT(DUMMYC,ROTA,ROTINVA,NATOMS)
         DUMMYA(1:3*NATOMS)=DUMMYC(1:3*NATOMS)  
      ELSE
         CALL MYORIENT(DUMMYC,DUMMY,NORBIT1,NCHOOSE1,NORBIT2,NCHOOSE2,NATOMS,DEBUG,ROTA,ROTINVA,STOCKT)
         DUMMYA(1:3*NATOMS)=DUMMY(1:3*NATOMS)
         CALL MYORIENT(DUMMYB,DUMMY,NORBITB1,NCHOOSEB1,NORBITB2,NCHOOSEB2,NATOMS,DEBUG,ROTB,ROTINVB,STOCKT)
         DUMMYB(1:3*NATOMS)=DUMMY(1:3*NATOMS)
      ENDIF
      DISTANCE=0.0D0
      DO J1=1,3*NATOMS
         DISTANCE=DISTANCE+(DUMMYA(J1)-DUMMYB(J1))**2
      ENDDO
!  IF (DEBUG) PRINT '(A,G20.10,A,I6,A)', &
! &       ' minpermdist> after initial call to MYORIENT distance=',SQRT(DISTANCE), ' for ',NATOMS,' atoms'
!  IF (DEBUG) PRINT '(A,6I8)',' minpermdist> size of orbits, selected atoms, random rotations, invert: ', &
! &       NORBIT1,NORBIT2,NCHOOSE1,NCHOOSE2,NROTDONE,INVERT
ELSE
   NORBIT1=1; NORBIT2=1; NORBITB1=1; NORBITB2=1
   CALL NEWMINDIST(DUMMYB,DUMMYA,NATOMS,DISTANCE,BULKT,TWOD,'AX    ',.FALSE.,RIGID,DEBUG,RMAT)
   IF (DEBUG) PRINT '(A,G20.10)',' minpermdist> after initial call to NEWMINDIST distance=',DISTANCE
   DISTANCE=DISTANCE**2
ENDIF

!
!  Bipartite matching routine for permutations. Coordinates in DUMMYB do not change
!  but the coordinates in DUMMYA do. DISTANCE is the distance^2 in this case.
!  We return to label 10 after every round of permutational/orientational alignment
!  unless we have converged to the identity permutation.
!
!  Atoms are not allowed to appear in more than one group.
!  The maximum number of pair exchanges associated with a group is two.
!
NTRIES=0
!
!  RMATCUMUL contains the accumulated rotation matrix that relates the original 
!  DUMMYA obtained from COORDSA to the final one.
!
RMATCUMUL(1:3,1:3)=0.0D0
RMATCUMUL(1,1)=1.0D0; RMATCUMUL(2,2)=1.0D0; RMATCUMUL(3,3)=1.0D0
10 CONTINUE

NTRIES=NTRIES+1

NDUMMY=1
DO J1=1,NATOMS
   NEWPERM(J1)=J1
ENDDO
!
! ALLPERM saves the permutation from the previous cycle.
! NEWPERM contains the permutation for this cycle, relative to the identity.
! SAVEPERM is temporary storage for NEWPERM.
! NEWPERM must be applied to ALLPERM after the loop over NPERMGROUP and
! corresponding swaps.
!
! New version allows for overlapping atoms in NPERMGROUP, so that atoms
! can appear in more than one group. This was needed for flexible water potentials.
!
DO J1=1,NPERMGROUP
   PATOMS=NPERMSIZE(J1)
   DO J2=1,PATOMS
      PDUMMYA(3*(J2-1)+1)=DUMMYA(3*(NEWPERM(PERMGROUP(NDUMMY+J2-1))-1)+1)
      PDUMMYA(3*(J2-1)+2)=DUMMYA(3*(NEWPERM(PERMGROUP(NDUMMY+J2-1))-1)+2)
      PDUMMYA(3*(J2-1)+3)=DUMMYA(3*(NEWPERM(PERMGROUP(NDUMMY+J2-1))-1)+3)
      PDUMMYB(3*(J2-1)+1)=DUMMYB(3*(NEWPERM(PERMGROUP(NDUMMY+J2-1))-1)+1)
      PDUMMYB(3*(J2-1)+2)=DUMMYB(3*(NEWPERM(PERMGROUP(NDUMMY+J2-1))-1)+2)
      PDUMMYB(3*(J2-1)+3)=DUMMYB(3*(NEWPERM(PERMGROUP(NDUMMY+J2-1))-1)+3)
   ENDDO
!
! All permutations within this group of size NPERMSIZE(J1) are now tried.
!
   CALL MINPERM(PATOMS, PDUMMYB, PDUMMYA, BOXLX, BOXLY, BOXLZ, BULKT, LPERM, LDISTANCE, DIST2, WORSTRAD)
   SAVEPERM(1:NATOMS)=NEWPERM(1:NATOMS)
   DO J2=1,PATOMS
      SAVEPERM(PERMGROUP(NDUMMY+J2-1))=NEWPERM(PERMGROUP(NDUMMY+LPERM(J2)-1))
   ENDDO
!
! Update permutation of associated atoms, if any. 
! We must do this as we go along, because these atoms could move in more than
! one permutational group now.
!
   IF (NSETS(J1).GT.0) THEN
      DO J2=1,PATOMS
         DO J3=1,NSETS(J1)
            SAVEPERM(SETS(PERMGROUP(NDUMMY+J2-1),J3))=SETS(NEWPERM(PERMGROUP(NDUMMY+LPERM(J2)-1)),J3)
         ENDDO
      ENDDO
   ENDIF
   NDUMMY=NDUMMY+NPERMSIZE(J1)
   NEWPERM(1:NATOMS)=SAVEPERM(1:NATOMS)
! PRINT '(A)',' minpermdist> NEWPERM:'
! PRINT '(20I6)',NEWPERM(1:NATOMS)

ENDDO
!
! Update the overall permutation here.
! The latest NEWPERM(J1) tells us which position moves to J1 in the latest
! permutation, relative to the identity.
! ALLPERM(J2) tells us which atom has moved to position J2.
! So, the new overall permutation, i.e. the atoms that moves to position J1
! After ALLPERM followed by NEWPERM is ALLPERM(NEWPERM(J1))
!
DO J1=1,NATOMS
!  SAVEPERM(ALLPERM(J1))=ALLPERM(NEWPERM(J1)) !!! BUG 12/9/11 DJW
   SAVEPERM(J1)=ALLPERM(NEWPERM(J1))
ENDDO
ALLPERM(1:NATOMS)=SAVEPERM(1:NATOMS)
! PRINT '(A)',' minpermdist> ALLPERM:'
! PRINT '(20I6)',ALLPERM(1:NATOMS)

DUMMY(1:3*NATOMS)=DUMMYA(1:3*NATOMS)
NPERM=0
DISTANCE=0.0D0
!
! Update coordinates in DUMMYA to overall permutation using NEWPERM.
!
DO J3=1,NATOMS
   DUMMYA(3*(J3-1)+1)=DUMMY(3*(NEWPERM(J3)-1)+1)
   DUMMYA(3*(J3-1)+2)=DUMMY(3*(NEWPERM(J3)-1)+2)
   DUMMYA(3*(J3-1)+3)=DUMMY(3*(NEWPERM(J3)-1)+3)

   IF (J3.NE.NEWPERM(J3)) THEN
!     IF (DEBUG) WRITE(*,'(A,I5,A,I5)') ' minpermdist> move position ',NEWPERM(J3),' to ',J3
      NPERM=NPERM+1
   ENDIF
   DISTANCE=DISTANCE+(DUMMYA(3*(J3-1)+1)-DUMMYB(3*(J3-1)+1))**2 &
  &                    +(DUMMYA(3*(J3-1)+2)-DUMMYB(3*(J3-1)+2))**2 &
  &                    +(DUMMYA(3*(J3-1)+3)-DUMMYB(3*(J3-1)+3))**2
ENDDO
!
!  Optimal alignment. Coordinates in DUMMYA are reset by NEWMINDIST (second argument).
!  Must allow at least one call to NEWMINDIST in case the MYORIENT result is terrible
!  but gives zero permutations!
!  
 
! PRINT '(A,I6,2G20.10)','NPERM,DBEST,DISTANCE=',NPERM,DBEST,DISTANCE
IF ((NPERM.NE.0).OR.(NTRIES.EQ.1)) THEN 
   CALL NEWMINDIST(DUMMYB,DUMMYA,NATOMS,DISTANCE,BULKT,TWOD,'AX    ',.FALSE.,RIGID,DEBUG,RMAT)
   RMATCUMUL=MATMUL(RMAT,RMATCUMUL)
   DISTANCE=DISTANCE**2 ! we are using DISTANCE^2 further down
!  IF (DEBUG) WRITE(*,'(A,G20.10)') ' minpermdist> distance after NEWMINDIST=                     ', &
! &                                    SQRT(DISTANCE) 
   IF (NTRIES.LT.MAXIMUMTRIES) THEN
      GOTO 10
   ELSE ! prevent infinite loop
      PRINT '(A)',' minpermdistGTHOMSON> WARNING - number of tries exceeded, giving up'
   ENDIF
ENDIF

! PRINT '(A,2G20.10)',' minpermdist> DISTANCE,DBEST=',DISTANCE,DBEST
IF (DISTANCE.LT.DBEST) THEN
   DBEST=DISTANCE
   XBEST(1:3*NATOMS)=DUMMYA(1:3*NATOMS)
   BESTPERM(1:NATOMS)=ALLPERM(1:NATOMS)
   BESTINVERT=INVERT
   RMATBEST(1:3,1:3)=RMATCUMUL(1:3,1:3)
   ROTINVBBEST(1:3,1:3)=ROTINVB(1:3,1:3) 
   ROTABEST(1:3,1:3)=ROTA(1:3,1:3)      
   RMATBEST=MATMUL(RMATBEST,ROTABEST)
   IF (INVERT.EQ.-1) THEN
      IF (PULLT.OR.EFIELDT.OR.TWOD.OR.((GTHOMSONT .AND. (GTHOMMET < 5)))) THEN ! reflect in xz plane rather than invert!
         RMATBEST(1:3,1:3)=MATMUL(RMATBEST,REFXZ)
      ELSE
         RMATBEST(1:3,1:3)=-RMATBEST(1:3,1:3)
      ENDIF
   ENDIF

ENDIF

IF (DISTANCE .LT. GEOMDIFFTOL ) THEN
   GOTO 50 ! hk286
ENDIF

IF (NCHOOSE2.LT.NORBIT2) GOTO 30
IF (NCHOOSE1.LT.NORBIT1) GOTO 65
IF (NCHOOSEB2.LT.NORBITB2) GOTO 31
IF (NCHOOSEB1.LT.NORBITB1) GOTO 66
!
!  Now try the enantiomer (or xz reflected structure for PULLT.OR.EFIELDT.OR.TWOD).
!
!  GO TO 50
IF ((NCHOOSE2.EQ.NORBIT2).AND.(NCHOOSE1.EQ.NORBIT1).AND.(INVERT.EQ.1)) THEN
!
! don't try inversion for bulk or charmm or amber or frozen atoms
!
   INVERT=-1
   GOTO 60
ENDIF

IF (NROTDONE.LT.NRANROT) GOTO 11

50 DISTANCE=DBEST
!
!  XBEST contains the best alignment of A coordinates for the orientation of B coordinates in DUMMYB.
!  Rotate XBEST by ROTINVBBEST to put in best correspondence with COORDSB, 
!  undoing the reorientation to DUMMYB from MYORIENT. 
!  We should get the same result for ROTINVBBEST * RMATBEST * (COORDSA-CMA) 
!  where RMATBEST = +/- RMATCUMUL * ROTA for the best alignment 
!  (aside from a possible permutation of the atom ordering)
!
   XDUMMY=0.0D0
   DO J1=1,NATOMS
      XBEST(3*(J1-1)+1:3*(J1-1)+3)=MATMUL(ROTINVBBEST,XBEST(3*(J1-1)+1:3*(J1-1)+3))
      XBEST(3*(J1-1)+1)=XBEST(3*(J1-1)+1)
      XBEST(3*(J1-1)+2)=XBEST(3*(J1-1)+2)
      XBEST(3*(J1-1)+3)=XBEST(3*(J1-1)+3)
      XDUMMY=XDUMMY+(COORDSB(3*(J1-1)+1)-XBEST(3*(J1-1)+1))**2+ &
  &                    (COORDSB(3*(J1-1)+2)-XBEST(3*(J1-1)+2))**2+ &
  &                    (COORDSB(3*(J1-1)+3)-XBEST(3*(J1-1)+3))**2
   ENDDO
   IF (ABS(SQRT(XDUMMY)-SQRT(DISTANCE)).GT.GEOMDIFFTOL) THEN
      PRINT '(2(A,F20.10))',' minpermdistGTHOMSON> ERROR *** distance between transformed XBEST and COORDSB=',SQRT(XDUMMY), &
  &                         ' should be ',SQRT(DISTANCE)
      STOP
   ENDIF

   RMATBEST=MATMUL(ROTINVBBEST,RMATBEST)
   COORDSA(1:3*NATOMS)=XBEST(1:3*NATOMS) ! finally, best COORDSA should include permutations for DNEB input!
   DISTANCE=SQRT(DISTANCE) ! now changed to return distance, not distance^2 22/11/10 DJW
   
RETURN
END SUBROUTINE HKMINPERMDIST



! -----------------------------------------------------------

SUBROUTINE HKMINDIST(RA,RB,NATOMS,DIST,BULKT,TWOD,ZUSE,PRESERVET)
! hk286 - add GTHOMSONT,  NGTHORI
  USE KEY,ONLY : GTHOMSONT, GTHOMMET
  IMPLICIT NONE
  INTEGER J1, IG, I, ITER, J2, NCOUNT
  DOUBLE PRECISION DPRAND
  DOUBLE PRECISION P(3), DIST, DIST0, RG, RG0, DISTFUNC, & 
       &                 MYROTMAT(3,3), &
       &                 OVEC(3), H1VEC(3), H2VEC(3), DSAVE, OMEGATOT(3,3), RA(*), RB(*)
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: R, R0, R1, R1SAVE
  DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: RBSAVE
  INTEGER NSIZE, NATOMS
  LOGICAL BULKT, MFLAG, TWOD, AGAIN, PRESERVET
  COMMON /GEOM/ NSIZE
  COMMON /MINDOM/ MYROTMAT, OMEGATOT
  CHARACTER(LEN=5) ZUSE
  
  ALLOCATE(RBSAVE(3*NATOMS))
  RBSAVE(1:3*NATOMS)=RB(1:3*NATOMS)
  !
  !  Initialise accumulated rotation matrix to the identity.
  !
  DO J1=1,3
     DO J2=1,3
        OMEGATOT(J2,J1)=0.0D0
     ENDDO
     OMEGATOT(J1,J1)=1.0D0
  ENDDO
  
  AGAIN=.FALSE.
  DSAVE=0.0D0
  ALLOCATE(R(3,NATOMS),R0(3,NATOMS),R1(3,NATOMS),R1SAVE(3,NATOMS))
  NSIZE=NATOMS
  DO J1=1,NSIZE
     R(1,J1)=RA(3*(J1-1)+1)
     R(2,J1)=RA(3*(J1-1)+2)
     R(3,J1)=RA(3*(J1-1)+3)
     R0(1,J1)=RB(3*(J1-1)+1)
     R0(2,J1)=RB(3*(J1-1)+2)
     R0(3,J1)=RB(3*(J1-1)+3)
  ENDDO
  !
  !     initial angles
  !
  P(1)=0.0D0
  P(2)=0.0D0
  P(3)=0.0D0
  !     IF (TWOD) P(1)=0.0D0
  !     IF (TWOD) P(2)=0.0D0
  !
  !     calculate initial distance
  !
  NCOUNT=0
10 DIST0=DISTFUNC(P,R,R0,R1)
  DIST0=SQRT(DIST0)
  IF (BULKT) THEN
     DIST=DIST0
     IF (PRESERVET) RB(1:3*NATOMS)=RBSAVE(1:3*NATOMS)
     DEALLOCATE(R, R0, R1, R1SAVE, RBSAVE)
     RETURN
  ENDIF
  
  CALL MMYLBFGS(P,1.0D-7,MFLAG,DIST,500,ITER,R,R0,R1)
  DIST=DISTFUNC(P,R,R0,R1)
  DIST=SQRT(DIST)
  IF (MFLAG) THEN
     !        WRITE(*,'(A,2F15.5,A,I6)') 'Initial and final distances:',DIST0,DIST,' iterations=',ITER
     !        PRINT*
  ELSE
     NCOUNT=NCOUNT+1
     IF (NCOUNT.GT.0) THEN 
        PRINT*,'convergence failure in mind'
        !           STOP
     ELSE
        !           WRITE(*,'(A,2F15.5,A,I6,A,I6)') 'Initial and final distances:',DIST0,DIST,' iterations=',ITER,' NCOUNT=',NCOUNT
        DO J1=1,NSIZE
           R0(1,J1)=R1(1,J1)
           R0(2,J1)=R1(2,J1)
           R0(3,J1)=R1(3,J1)
        ENDDO
        ! hk286
        IF (.NOT. (GTHOMSONT .AND. (GTHOMMET < 5))) P(1)=2*(DPRAND()-0.5D0)/10.0D0
        IF (.NOT. (GTHOMSONT .AND. (GTHOMMET < 5))) P(2)=2*(DPRAND()-0.5D0)/10.0D0
        P(3)=2*(DPRAND()-0.5D0)/10.0D0
        GOTO 10
     ENDIF
  ENDIF
  DO J1=1,NSIZE
     RB(3*(J1-1)+1)=R1(1,J1)
     RB(3*(J1-1)+2)=R1(2,J1)
     RB(3*(J1-1)+3)=R1(3,J1)
     RA(3*(J1-1)+1)=R(1,J1)
     RA(3*(J1-1)+2)=R(2,J1)
     RA(3*(J1-1)+3)=R(3,J1)
  ENDDO
  
  DO J1=1,3
     DO J2=1,3
        MYROTMAT(J2,J1)=OMEGATOT(J2,J1)
     ENDDO
  ENDDO
  
  DEALLOCATE(R, R0, R1, R1SAVE, RBSAVE)
  
  RETURN
END SUBROUTINE HKMINDIST

! -------------------------------------------------------------

SUBROUTINE HKNEWMINDIST(RA,RB,NATOMS,DIST,BULKT,TWOD,ZUSE,PRESERVET,RIGIDBODY,DEBUG,RMAT)
  USE KEY,ONLY : GTHOMSONT, GTHOMMET
  
  IMPLICIT NONE
  INTEGER J1, NATOMS, NSIZE, INFO, JINFO, JMIN
  DOUBLE PRECISION RA(3*NATOMS), RB(3*NATOMS), DIST, QMAT(4,4), XM, YM, ZM, XP, YP, ZP, OVEC(3), H1VEC(3), H2VEC(3), &
       &              DIAG(4), TEMPA(9*NATOMS), RMAT(3,3), MINV, Q1, Q2, Q3, Q4, CMXA, CMYA, CMZA, CMXB, CMYB, CMZB, &
       &              MYROTMAT(3,3), OMEGATOT(3,3)
  DOUBLE PRECISION, ALLOCATABLE :: XA(:), XB(:)
  LOGICAL BULKT, TWOD, RIGIDBODY, PRESERVET, DEBUG, UPRETURN
  CHARACTER(LEN=5) ZUSE
  COMMON /MINDOM/ MYROTMAT, OMEGATOT
  DOUBLE PRECISION ENERGY, VNEW(3*NATOMS), RMS


  IF (GTHOMSONT .AND. (GTHOMMET < 5)) THEN
  !  ALLOCATE(XA(3*(NATOMS/2)*number of sites,XB(3*(NATOMS/2)*number of sites))
  !  NSIZE=(NATOMS/2)*number of sites
  !  PRINT '(A)',' newmindist> New quaternion procedure not yet coded for flatland'
  ! There is one unknown angle, so this should be trivial!'
     CALL HKMINDIST(RA,RB,NATOMS,DIST,BULKT,TWOD,ZUSE,PRESERVET)
     RMAT(1:3,1:3)=OMEGATOT(1:3,1:3)
     RETURN
     !  STOP
  ELSE
     ALLOCATE(XA(3*NATOMS),XB(3*NATOMS))
     NSIZE=NATOMS
     XA(1:3*NATOMS)=RA(1:3*NATOMS)
     XB(1:3*NATOMS)=RB(1:3*NATOMS)
  ENDIF  
  !
  ! Move centre of coordinates of XA and XB to the origin.
  !
  CMXA=0.0D0; CMYA=0.0D0; CMZA=0.0D0
  
  !
  !  The formula below is not invariant to overall translation because XP, YP, ZP
  !  involve a sum of coordinates! We need to have XA and XB coordinate centres both 
  !  at the origin!!
  !
  QMAT(1:4,1:4)=0.0D0
  DO J1=1,NSIZE
     XM=XA(3*(J1-1)+1)-XB(3*(J1-1)+1)
     YM=XA(3*(J1-1)+2)-XB(3*(J1-1)+2)
     ZM=XA(3*(J1-1)+3)-XB(3*(J1-1)+3)
     XP=XA(3*(J1-1)+1)+XB(3*(J1-1)+1)
     YP=XA(3*(J1-1)+2)+XB(3*(J1-1)+2)
     ZP=XA(3*(J1-1)+3)+XB(3*(J1-1)+3)
     QMAT(1,1)=QMAT(1,1)+XM**2+YM**2+ZM**2
     QMAT(1,2)=QMAT(1,2)+YP*ZM-YM*ZP
     QMAT(1,3)=QMAT(1,3)+XM*ZP-XP*ZM
     QMAT(1,4)=QMAT(1,4)+XP*YM-XM*YP
     QMAT(2,2)=QMAT(2,2)+YP**2+ZP**2+XM**2
     QMAT(2,3)=QMAT(2,3)+XM*YM-XP*YP
     QMAT(2,4)=QMAT(2,4)+XM*ZM-XP*ZP
     QMAT(3,3)=QMAT(3,3)+XP**2+ZP**2+YM**2
     QMAT(3,4)=QMAT(3,4)+YM*ZM-YP*ZP
     QMAT(4,4)=QMAT(4,4)+XP**2+YP**2+ZM**2
  ENDDO
  QMAT(2,1)=QMAT(1,2); QMAT(3,1)=QMAT(1,3); QMAT(3,2)=QMAT(2,3); QMAT(4,1)=QMAT(1,4); QMAT(4,2)=QMAT(2,4); QMAT(4,3)=QMAT(3,4)
  
  CALL DSYEV('V','U',4,QMAT,4,DIAG,TEMPA,9*NATOMS,INFO)
  IF (INFO.NE.0) PRINT '(A,I6,A)',' newmindist> WARNING - INFO=',INFO,' in DSYEV'
  
  MINV=1.0D100
  DO J1=1,4
     !     PRINT '(A,I8,G20.10)','newmindist> J1,DIAG=',J1,DIAG(J1)
     IF (DIAG(J1).LT.MINV) THEN
        JMIN=J1
        MINV=DIAG(J1)
     ENDIF
  ENDDO
  IF (MINV.LT.0.0D0) THEN
     IF (ABS(MINV).LT.1.0D-6) THEN
        MINV=0.0D0
     ELSE
        PRINT '(A,G20.10,A)',' newmindist> WARNING MINV is ',MINV,' change to absolute value'
        MINV=-MINV
     ENDIF
  ENDIF
  DIST=SQRT(MINV)
  
  !  IF (DEBUG) PRINT '(A,G20.10,A,I6)',' newmindist> minimum residual is ',DIAG(JMIN),' for eigenvector ',JMIN
  Q1=QMAT(1,JMIN); Q2=QMAT(2,JMIN); Q3=QMAT(3,JMIN); Q4=QMAT(4,JMIN)
  !
  ! RMAT will contain the matrix that maps XB onto the best correspondence with XA
  !
  RMAT(1,1)=Q1**2+Q2**2-Q3**2-Q4**2
  RMAT(1,2)=2*(Q2*Q3+Q1*Q4)
  RMAT(1,3)=2*(Q2*Q4-Q1*Q3)
  RMAT(2,1)=2*(Q2*Q3-Q1*Q4)
  RMAT(2,2)=Q1**2+Q3**2-Q2**2-Q4**2
  RMAT(2,3)=2*(Q3*Q4+Q1*Q2)
  RMAT(3,1)=2*(Q2*Q4+Q1*Q3)
  RMAT(3,2)=2*(Q3*Q4-Q1*Q2)
  RMAT(3,3)=Q1**2+Q4**2-Q2**2-Q3**2

IF (.NOT.PRESERVET) THEN
   CALL NEWROTGEOM(NSIZE,RB,RMAT,CMXA,CMYA,CMZA)
ENDIF
  
  DEALLOCATE(XA,XB)
  
  RETURN

END SUBROUTINE HKNEWMINDIST


SUBROUTINE GTHOMSONNEWMINDIST(RA,RB,NATOMS,DIST,BULKT,TWOD,ZUSE,PRESERVET,RIGIDBODY,DEBUG,RMAT)
  
  USE KEY,ONLY : GTHOMSONT, NGTHORI
  IMPLICIT NONE
  INTEGER NATOMS
  DOUBLE PRECISION RA(3*NATOMS), RB(3*NATOMS), DIST, RMAT(3,3)
  LOGICAL BULKT, TWOD, RIGIDBODY, PRESERVET, DEBUG
  CHARACTER(LEN=5) ZUSE
  DOUBLE PRECISION XCOORDSA (3*NGTHORI), XCOORDSB(3*NGTHORI)

  IF (NATOMS < NGTHORI) THEN
     CALL GTHOMSONANGTOC(XCOORDSA,RA,NGTHORI)
     CALL GTHOMSONANGTOC(XCOORDSB,RB,NGTHORI)
     CALL HKNEWMINDIST(XCOORDSA,XCOORDSB,NGTHORI,DIST,BULKT,TWOD,ZUSE,PRESERVET,RIGIDBODY,DEBUG,RMAT)
     RETURN
  ELSE
     CALL HKNEWMINDIST(RA,RB,NATOMS,DIST,BULKT,TWOD,ZUSE,PRESERVET,RIGIDBODY,DEBUG,RMAT)
  ENDIF

END SUBROUTINE GTHOMSONNEWMINDIST


SUBROUTINE GTHOMSONMINPERMDIST(COORDSB,COORDSA,NATOMS,DEBUG,BOXLX,BOXLY,BOXLZ,BULKT,TWOD,DISTANCE,DIST2,RIGID,RMATBEST)
  
  USE KEY,ONLY : GTHOMSONT, NGTHORI, GTHOMMET
  USE KEYUTILS
  IMPLICIT NONE
  DOUBLE PRECISION XCOORDSA (3*NGTHORI), XCOORDSB(3*NGTHORI), DD, DD2
  INTEGER NATOMS, JJ
  DOUBLE PRECISION DIST2, COORDSA(3*NATOMS), COORDSB(3*NATOMS), DISTANCE
  DOUBLE PRECISION BOXLX,BOXLY,BOXLZ,RMATBEST(3,3),RMATBEST2(3,3),REFXY(3,3)
  LOGICAL DEBUG, TWOD, RIGID, BULKT
  
! hk286
  DOUBLE PRECISION XENERGY, G(3*NATOMS)

  REFXY(:,:) = 0.0D0
  REFXY(1,1) = 1.0D0; REFXY(2,2) = 1.0D0; REFXY(3,3) = -1.0D0
  IF (NATOMS < NGTHORI) THEN
     CALL GTHOMSONANGTOC(XCOORDSA,COORDSA,NGTHORI)
     CALL GTHOMSONANGTOC(XCOORDSB,COORDSB,NGTHORI)
  ELSE
     XCOORDSA = COORDSA
     XCOORDSB = COORDSB
  ENDIF

  DISTANCE = 1.0D10
     
  CALL HKMINPERMDIST(XCOORDSB,XCOORDSA,NGTHORI,DEBUG,BOXLX,BOXLY,BOXLZ,BULKT,TWOD,DD,DD2,RIGID,RMATBEST)

!  IF (DD < DISTANCE .AND. DD < GEOMDIFFTOL) THEN
  IF (DD < DISTANCE) THEN
     DISTANCE = DD
     DIST2 = DD2
     IF (NATOMS < NGTHORI) THEN
        CALL GTHOMSONCTOANG(XCOORDSA,COORDSA,NGTHORI,1)
        CALL GTHOMSONCTOANG(XCOORDSB,COORDSB,NGTHORI,1)
     ELSE
        COORDSA = XCOORDSA
        COORDSB = XCOORDSB
     ENDIF
  ENDIF

  IF (GTHOMMET < 5) THEN
     DO JJ = 1, NGTHORI
        XCOORDSA(3*JJ) = -XCOORDSA(3*JJ)
     ENDDO
     CALL HKMINPERMDIST(XCOORDSB,XCOORDSA,NGTHORI,DEBUG,BOXLX,BOXLY,BOXLZ,BULKT,TWOD,DD,DD2,RIGID,RMATBEST2)
     !  IF (DD < DISTANCE .AND. DD < GEOMDIFFTOL) THEN
     IF (DD < DISTANCE) THEN
        DISTANCE = DD
        DIST2 = DD2
        IF (NATOMS < NGTHORI) THEN
           CALL GTHOMSONCTOANG(XCOORDSA,COORDSA,NGTHORI,1)
           CALL GTHOMSONCTOANG(XCOORDSB,COORDSB,NGTHORI,1)
        ELSE
           COORDSA = XCOORDSA
           COORDSB = XCOORDSB
        ENDIF
        RMATBEST(:,:)=MATMUL(REFXY,RMATBEST)
        RMATBEST(:,:)=MATMUL(RMATBEST2,RMATBEST)     
     ENDIF
  ENDIF

  RETURN

END SUBROUTINE GTHOMSONMINPERMDIST
