!  GMIN: A program for finding global minima
!  Copyright (C) 1999-2006 David J. Wales
!  This file is part of GMIN.
!
!  GMIN is free software; you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation; either version 2 of the License, or
!  (at your option) any later version.
!
!  GMIN is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with this program; if not, write to the Free Software
!  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
! Objective - to symmetrise a set of input coordinates.
!
SUBROUTINE SYMMETRY3(JP,SCREENC,QDONE,BRUN,ITERATIONS,TIME,CHANGEDE,NSYMCALL)
USE COMMONS
USE porfuncs
IMPLICIT NONE
DOUBLE PRECISION :: LCOORDS(3*NATOMS), CMDIST(NATOMS), ORBDIST(NATOMS), T0, DPRAND
DOUBLE PRECISION :: EBEST, QBEST(3*NATOMS), NEWQ(3*NATOMS), VATBEST(NATOMS)
DOUBLE PRECISION :: CMX(2), CMY(2), CMZ(2), CM(3), CMSAVE(3), COREVT(NATOMS), OTHERVT(NATOMS)
DOUBLE PRECISION :: DUMMY, XMASS, YMASS, ZMASS
DOUBLE PRECISION :: ORIGIN(3), MINDIST, VMIN, VMAX
DOUBLE PRECISION :: TIME, TRANSCOORDS(3*NATOMS), LTOLD
INTEGER :: J1, J2, NDUMMY, I, NORBIT, J, ISTART, LARGESIZE, NEWORB, J4, ISTAT, MYUNIT2, MYUNIT3, NCORESAVE
INTEGER :: J3, JP, NATOMSCORE, NORBITSCORE, NTOTAL, NMOVE, MOVEINDEX(NATOMS)
INTEGER :: NFLOAT, NLOST, LASTORBIT, NCOREREAL
INTEGER :: NINDEX(NATOMS), ORBSIZE(NATOMS), NEWORBSIZE(NATOMS), NSYMOP
DOUBLE PRECISION :: SCOORDS(3*NATOMS), CLOSEOP(3,3)
! DOUBLE PRECISION :: ORBSORT(3*NATOMS), LCOORDSSORTED(3*NATOMS), RCOORDSSORTED(3*NATOMS)
DOUBLE PRECISION :: CORECOORDS(3*NATOMS), OTHERCOORDS(3*NATOMS), TMPCOORDS(3), NEWORBCOORDS(NATOMS,3*120)
DOUBLE PRECISION :: ORBCOORDS(3*NATOMS), DENOM, WORSTRAD
LOGICAL :: SYMLOST(120), CHANGE, NEW, MOVEDTOCORE(NATOMS), MATCHED, CHANGEDE, WEAKESTONLY, NEWOP
LOGICAL :: RESTRICT, LDUMMY, MOVETOCORE, USECLOSESUBGROUP, CHANGECLOSE, DOMISSING, LDEBUG
DOUBLE PRECISION :: POTEL, SCREENC(3*NATOMS), GENMAT(100,3,3), GENMATSAVE(100,3,3), SYMOP(120,3,3), LOSTOP(120,3,3)
DOUBLE PRECISION :: NEWMAT(3,3), SYMOP1(3,3), SYMOP2(3,3), DIST2, SUBOP(120,3,3)
INTEGER :: GENPERM(100,NATOMS), OPPERM(120,NATOMS)
INTEGER :: NQTOT, QDONE, BRUN, ITERATIONS, NCHOICE(NATOMS), NQTOTSAVE, IGEN, IGENSAVE, ORBSYM, NORDER, NCHOOSE
INTEGER :: ICOMP, IPRNT, LASTLOST, PERM(NATOMS), NTOPSUM, NTOP, NTRIES, NSUB, NCORENEW, NEWCOREINDEX(NATOMS), NCORETMP, NMISS
INTEGER :: NMISSING(NATOMS), NSYMCALL, NMINREM, NPOSS, HPTGRPSAVE
INTEGER, ALLOCATABLE :: OCCS(:,:)
DOUBLE PRECISION :: QMISSING(NATOMS,3*120) ! number of orbits <= number of atoms
CHARACTER(LEN=4) FPGRP, POINTGROUP
CHARACTER(LEN=6) JPSTRING
DOUBLE PRECISION LHESS(3,3), SERROR, WORK(3), AMAT(3,3), SERROR2
INTEGER IPIVOT(3), INFO, PERM2(NATOMS)
DOUBLE PRECISION, PARAMETER :: EPS=1.0D-10
COMMON /MYPOT/ POTEL
COMMON /TOT/ NQTOT
SAVE NORBIT, LASTORBIT, NORDER

NCORESAVE=NCORE(JP)
MYUNIT2=NPAR+MYUNIT
MYUNIT3=2*NPAR+MYUNIT+1
IPRNT=0
LDEBUG=DEBUG
! LDEBUG=.TRUE.
NSYMCALL=NSYMCALL+1   ! NSYMCALL should be the number of consecutive calls to symmetry with this minimum
! PRINT '(A,5I)','NSYMCALL,NORDER,NORBIT,LASTORBIT,NORBIT-LASTORBIT+1=',NSYMCALL,NORDER,NORBIT,LASTORBIT,NORBIT-LASTORBIT+1
IF (NSYMCALL.GT.1) THEN
!  IF (NSYMCALL.GT.NORBIT-LASTORBIT+1) THEN
   IF (NSYMCALL.GT.1) THEN
!     IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A)') 'maximum calls to symmetry ',NORBIT-LASTORBIT,' exceeded for this minimum'
      IF (LDEBUG) WRITE(MYUNIT, '(A)') 'maximum consecutive calls to symmetry reached for this minimum'
      RETURN 
   ENDIF
!  IF (NSYMCALL.GT.NORDER) THEN
!     PRINT '(A,I5,A)','maximum calls to symmetry ',NORDER,' exceeded for this minimum - quit'
!     RETURN
!  ENDIF
ENDIF
NSYMREM=0
MOVETOCORE=.TRUE. 	! move complete orbits to core
IF (.NOT.MOVETOCORE) PRINT '(A)','WARNING - MOVETOCORE is FALSE'
WEAKESTONLY=.TRUE. 	! move weakest atom only to floaters (otherwise use ASTEP criterion)
RESTRICT=.FALSE.   	! move weakest atoms to floater list only if they are invariant to CLOSEOP
USECLOSESUBGROUP=.FALSE.	! randomly use the subgroup generated by CLOSEOP 
CHANGECLOSE=.FALSE.  	! randomly change the closest lost operation to that of a different orbit
DOMISSING=.TRUE.     	! identify missing positions from complete orbits when symmetry elements are lost
IF (NSYMCALL.GT.1) DOMISSING=.FALSE. ! no point in repeating!
IF (DOMISSING) CALL SORT3(NATOMS,NATOMS,VAT,COORDS,JP,NPAR) ! sort the atoms
CHANGEDE=.FALSE.
IF (LDEBUG) IPRNT=11
CALL MYCPU_TIME(T0)
EBEST=EPREV(JP)
QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
NQTOTSAVE=NQTOT
LCOORDS(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)

LTOLD=SYMTOL2
ORIGIN(1:3)=1.0D0
cmloop: DO J1=1,200
   XMASS=0.0D0; YMASS=0.0D0; ZMASS=0.0D0
   DENOM=0.0D0
   DO I=1,NATOMS
      IF (J1.GT.1) THEN
         DUMMY=EXP(-DISTFAC*CMDIST(I))
      ELSE
         DUMMY=1.0D0
      ENDIF
      XMASS=XMASS+LCOORDS(3*(I-1)+1)*DUMMY
      YMASS=YMASS+LCOORDS(3*(I-1)+2)*DUMMY
      ZMASS=ZMASS+LCOORDS(3*(I-1)+3)*DUMMY
      DENOM=DENOM+DUMMY
   ENDDO
   DUMMY=SQRT( (ORIGIN(1)-XMASS/DENOM)**2+(ORIGIN(2)-YMASS/DENOM)**2+(ORIGIN(3)-ZMASS/DENOM)**2)
   ORIGIN(1)=XMASS/DENOM;  ORIGIN(2)=YMASS/DENOM; ORIGIN(3)=ZMASS/DENOM
   DO J=1,NATOMS
      CMDIST(J)=SQRT((LCOORDS(3*(J-1)+1)-ORIGIN(1))**2+ &
                     (LCOORDS(3*(J-1)+2)-ORIGIN(2))**2+ &
                     (LCOORDS(3*(J-1)+3)-ORIGIN(3))**2)
   ENDDO
   IF (LDEBUG) WRITE(MYUNIT, '(A,I5,3G20.10)') 'cycle, origin:',J1,ORIGIN(1:3)
   IF ((J1.GT.1).AND.(DUMMY.LT.1.0D-4)) EXIT cmloop 
ENDDO cmloop

DO J=1,NATOMS
   NINDEX(J)=J
ENDDO

IF (LDEBUG) WRITE(MYUNIT, '(A,3F15.5)') 'initial centre of mass: ',ORIGIN(1:3)
SCOORDS(1:3*NATOMS)=LCOORDS(1:3*NATOMS)
CALL PIKSR2(NATOMS,CMDIST,NINDEX) ! sorts CMDIST and NINDEX
! CALL GETORBITS(NORBIT,ORBDIST,CMDIST,NATOMS,ORBSIZE,SYMTOL1,LARGESIZE,NINDEX,LCOORDS,LDEBUG)
! Find the largest gap between CM distances and use the centre-of-mass of all the atoms up to that point
CMX(1)=0.0D0; CMY(1)=0.0D0; CMZ(1)=0.0D0
CMX(2)=LCOORDS(3*(NINDEX(1)-1)+1); CMY(2)=LCOORDS(3*(NINDEX(1)-1)+2); CMZ(2)=LCOORDS(3*(NINDEX(1)-1)+3)
! Store sum of centres of mass from previous largest gap to current in CMx(2).
GMAX=-1.0D0
DO J=2,NATOMS
   IF (ABS(CMDIST(J)-CMDIST(J-1)).GT.GMAX) THEN
      GMAX=ABS(CMDIST(J)-CMDIST(J-1))
      NDUMMY=J-1
      CMX(1)=CMX(1)+CMX(2); CMY(1)=CMY(1)+CMY(2); CMZ(1)=CMZ(1)+CMZ(2)
      CMX(2)=LCOORDS(3*(NINDEX(J)-1)+1); CMY(2)=LCOORDS(3*(NINDEX(J)-1)+2); CMZ(2)=LCOORDS(3*(NINDEX(J)-1)+3)
   ELSE
      CMX(2)=CMX(2)+LCOORDS(3*(NINDEX(J)-1)+1); CMY(2)=CMY(2)+LCOORDS(3*(NINDEX(J)-1)+2); CMZ(2)=CMZ(2)+LCOORDS(3*(NINDEX(J)-1)+3)
   ENDIF
!  PRINT '(A,I5,2G20.10)','J,diff,GMAX=',J,ABS(CMDIST(J)-CMDIST(J-1)),GMAX
ENDDO
CMX(1)=CMX(1)/NDUMMY; CMY(1)=CMY(1)/NDUMMY; CMZ(1)=CMZ(1)/NDUMMY


! IF (LDEBUG) PRINT '(A,3F15.5)','origin will be moved to centre of mass for first orbit: ',CMX(1),CMY(1),CMZ(1)
! IF (LDEBUG) PRINT '(A,I6,A,F15.5,A)','orbit size: ',ORBSIZE(1),' distance ',ORBDIST(1),' members:'
IF (LDEBUG) WRITE(MYUNIT, '(A,3F15.5)') 'origin will be moved to centre of mass for atoms up to biggest gap: ',CMX(1),CMY(1),CMZ(1)
IF (LDEBUG) WRITE(MYUNIT, '(A,I6,A,F15.5,A)') 'number of atoms=',NDUMMY
ORBSIZE(1)=NDUMMY
IF (LDEBUG) WRITE(MYUNIT, '(12I5)')  (NINDEX(J1),J1=1,ORBSIZE(1))
ORIGIN(1)=CMX(1)
ORIGIN(2)=CMY(1)
ORIGIN(3)=CMZ(1)
DO J=1,NATOMS
   NINDEX(J)=J
   LCOORDS(3*(J-1)+1)=LCOORDS(3*(J-1)+1)-ORIGIN(1)
   LCOORDS(3*(J-1)+2)=LCOORDS(3*(J-1)+2)-ORIGIN(2)
   LCOORDS(3*(J-1)+3)=LCOORDS(3*(J-1)+3)-ORIGIN(3)
   CMDIST(J)=SQRT(LCOORDS(3*(J-1)+1)**2+LCOORDS(3*(J-1)+2)**2+LCOORDS(3*(J-1)+3)**2)
ENDDO
CALL PIKSR2(NATOMS,CMDIST,NINDEX) ! sorts CMDIST and NINDEX again
CALL GETORBITS(NORBIT,ORBDIST,CMDIST,NATOMS,ORBSIZE,SYMTOL1,LARGESIZE,NINDEX,LCOORDS,LDEBUG)
IF (LDEBUG) THEN
   ISTART=1
   OPEN(UNIT=MYUNIT2,FILE='orbits.'//TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NORBIT
      WRITE(MYUNIT2,'(I5)') SUM(ORBSIZE(1:J1))
      WRITE(MYUNIT2,'(A)') ' '
      DO J2=ISTART,ISTART+ORBSIZE(J1)-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LA',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      DO J2=1,ISTART-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LB',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      ISTART=ISTART+ORBSIZE(J1)
   ENDDO
   CLOSE(MYUNIT2)
ENDIF

IF (LARGESIZE.EQ.1) THEN
   IF (LDEBUG) THEN
      CALL MYCPU_TIME(TIME)
      WRITE(MYUNIT, '(A,F15.2)') 'No nontrivial orbits - return from symmetry, time taken=',TIME-T0
   ENDIF
   RETURN
ENDIF

! Examine how the point group changes as we include more orbits.
 
ISTART=1
NATOMSCORE=0
NORBITSCORE=0
IGENSAVE=0
HPTGRPSAVE=0
symcore: DO J1=1,NORBIT
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      CORECOORDS(3*(J2-1)+1:3*(J2-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
   ENDDO
   ISTART=ISTART+ORBSIZE(J1)
   NATOMSCORE=NATOMSCORE+ORBSIZE(J1)
   SCOORDS(1:3*NATOMSCORE)=CORECOORDS(1:3*NATOMSCORE) 
   IF (NATOMSCORE.GT.3) THEN
      DUMMY=MATDIFF
      CALL PTGRP(SCOORDS,NATOMSCORE,LDEBUG,SYMTOL1,SYMTOL2,SYMTOL3,GENMAT,IGEN,FPGRP,CM,DUMMY) ! SCOORDS is changed!
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,I5,A,I4,A,A4,A,I6)') 'number of orbits=',J1,' number of atoms=',NATOMSCORE, &
                          ' number of generators=',IGEN,' point group= ',FPGRP,' order=',HPTGRP
      IF (HPTGRP.GE.HPTGRPSAVE) THEN
         HPTGRPSAVE=HPTGRP
         ORBSYM=J1
         CMSAVE(1:3)=CM(1:3)
         NCORE(JP)=NATOMSCORE
         NORBITSCORE=J1
         IGENSAVE=IGEN
         POINTGROUP=FPGRP
         GENMATSAVE(1:IGEN,1:3,1:3)=GENMAT(1:IGEN,1:3,1:3)
         IF ((HPTGRP.EQ.1).AND.(NCORE(JP).GE.20)) THEN
            NCORE(JP)=0
            EXIT symcore ! looks like there is no symmetry
         ENDIF
      ELSEIF (HPTGRP.GE.1) THEN ! symmetry has decreased
         IF (NPAR.GT.1) THEN
            WRITE(MYUNIT,'(A,I1,3A,I6,A,I6,A)') '[',JP,']symmetry2> highest symmetry ',POINTGROUP,' for ',NORBITSCORE, &
  &                        ' orbits and ',NCORE(JP),' atoms'
         ELSE
            WRITE(MYUNIT,'(3A,I6,A,I6,A)') 'symmetry2> highest symmetry ',POINTGROUP,' for ',NORBITSCORE, &
  &                        ' orbits and ',NCORE(JP),' atoms'
         ENDIF
         EXIT symcore
      ENDIF
   ELSE
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,I5)') 'number of orbits=',NORBITSCORE,' number of atoms=',NATOMSCORE
   ENDIF
ENDDO symcore

IF (HPTGRPSAVE.EQ.1) THEN
   IF (LDEBUG) WRITE(MYUNIT, '(A)') 'no symmetry detected'
   NCORE(JP)=NCORESAVE
   RETURN
ELSE
   IF (NCORE(JP).EQ.NATOMS) THEN
      NCORE(JP)=NCORESAVE
      RETURN
   ENDIF
!  WRITE(MYUNIT, '(A,A,A,I4)') 'symmetry analysis for point group ',TRIM(ADJUSTL(POINTGROUP)),' number of generators=',IGENSAVE
!  PRINT '(A,I5,A,I5,A)','this group was detected for the first ',ORBSYM,' orbits containing ',NCORE(JP),' atoms'
ENDIF
NCOREREAL=NCORE(JP)

! Move the CORECOORDS centre of mass to the origin.

DO J1=1,NATOMS
   LCOORDS(3*(J1-1)+1)=LCOORDS(3*(J1-1)+1)-CMSAVE(1)
   LCOORDS(3*(J1-1)+2)=LCOORDS(3*(J1-1)+2)-CMSAVE(2)
   LCOORDS(3*(J1-1)+3)=LCOORDS(3*(J1-1)+3)-CMSAVE(3)
ENDDO
DO J1=1,NCORE(JP)
   CORECOORDS(3*(J1-1)+1)=CORECOORDS(3*(J1-1)+1)-CMSAVE(1)
   CORECOORDS(3*(J1-1)+2)=CORECOORDS(3*(J1-1)+2)-CMSAVE(2)
   CORECOORDS(3*(J1-1)+3)=CORECOORDS(3*(J1-1)+3)-CMSAVE(3)
ENDDO

! Generate all the point group operations.

SYMOP(1,1,1)=1.0D0; SYMOP(1,1,2)=0.0D0; SYMOP(1,1,3)=0.0D0 ! identity
SYMOP(1,2,1)=0.0D0; SYMOP(1,2,2)=1.0D0; SYMOP(1,2,3)=0.0D0
SYMOP(1,3,1)=0.0D0; SYMOP(1,3,2)=0.0D0; SYMOP(1,3,3)=1.0D0
NORDER=1
DO J1=1,NATOMS
   GENPERM(1,J1)=J1
   OPPERM(1,J1)=J1
ENDDO
! 
! Refine the IGENSAVE symmetry operations for the NCORE(JP) atoms in
! CORECOORDS using a Newton-Raphson step. This really increases
! the accuracy of the point group operations. We could also refine
! the further operations produced from the generators, but it does
! not seem necessary.
!
LHESS(1:3,1:3)=0.0D0
DO J1=1,NCORE(JP)
   LHESS(1,1)=LHESS(1,1)+CORECOORDS(3*(J1-1)+1)**2+EPS ! EPS is designed to avoid singularities
   LHESS(1,2)=LHESS(1,2)+CORECOORDS(3*(J1-1)+1)*CORECOORDS(3*(J1-1)+2)+EPS
   LHESS(1,3)=LHESS(1,3)+CORECOORDS(3*(J1-1)+1)*CORECOORDS(3*(J1-1)+3)+EPS
   LHESS(2,2)=LHESS(2,2)+CORECOORDS(3*(J1-1)+2)**2+EPS
   LHESS(2,3)=LHESS(2,3)+CORECOORDS(3*(J1-1)+2)*CORECOORDS(3*(J1-1)+3)+EPS
   LHESS(3,3)=LHESS(3,3)+CORECOORDS(3*(J1-1)+3)**2+EPS
ENDDO
LHESS(2,1)=LHESS(1,2); LHESS(3,1)=LHESS(1,3); LHESS(3,2)=LHESS(2,3) ! symmetrise hessian
! invert LHESS
CALL DGETRF(3,3,LHESS,3,IPIVOT,INFO) ! LHESS is modified!
CALL DGETRI(3,LHESS,3,IPIVOT,WORK,3,INFO)
IF (INFO.NE.0) THEN
   WRITE(MYUNIT,'(A,I6)') 'ERROR - INFO after DGETRI in symmetry=',INFO
   WRITE(MYUNIT,'(A)') 'CORECOORDS:'
   WRITE(MYUNIT,'(3F20.10)') CORECOORDS(1:3*NCORE(JP))
   WRITE(MYUNIT,'(A)') 'LHESS'
   WRITE(MYUNIT,'(3F20.10)') LHESS
   STOP
ENDIF 

genloop: DO J1=1,IGENSAVE
!  SYMOP(1+J1,1:3,1:3)=GENMATSAVE(J1,1:3,1:3)
   SYMOP1(1:3,1:3)=GENMATSAVE(J1,1:3,1:3)
   IF (LDEBUG) WRITE(MYUNIT, '(A,I5,9F10.4)') 'NORDER,initial MAT: ',NORDER,GENMATSAVE(J1,1:3,1:3)
   CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,NCORE(JP),3,3)
!  CALL MINPERM(NCORE(JP),NEWQ,CORECOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
   CALL TESTSYMOP(NCORE(JP),NEWQ,CORECOORDS,PERM,LTOLD,DIST2,WORSTRAD)
   IF (DIST2.GT.LTOLD) THEN
      WRITE(MYUNIT, '(A,2G20.10)') 'ERROR - genloop in symmetry, DIST2,LTOLD=',DIST2,LTOLD
      cycle genloop
   ENDIF
!  CALL BIPARTITE(NCORE(JP),NEWQ,CORECOORDS,PERM,DUMMY,DIST2,WORSTRAD)
!  PRINT '(A,6F15.5)','dists: ',DUMMY,DIST2,WORSTRAD,BDUMMY,BDIST2,BWORSTRAD
   IF (LDEBUG) THEN
      SERROR=0.0D0
      DO J2=1,NCORE(JP)
         SERROR=SERROR+(CORECOORDS(3*(PERM(J2)-1)+1)-NEWQ(3*(J2-1)+1))**2+ &
 &                     (CORECOORDS(3*(PERM(J2)-1)+2)-NEWQ(3*(J2-1)+2))**2+ &
 &                     (CORECOORDS(3*(PERM(J2)-1)+3)-NEWQ(3*(J2-1)+3))**2
      ENDDO
      WRITE(MYUNIT, '(A,I5,G20.10)') 'operation,     error=',J1,SERROR
      IF (SERROR.GT.0.5D0) STOP
   ENDIF
!
!  Check for independent generators by comparing the integers in GENPERM
!
   DO J2=1,NORDER
      NEWOP=.FALSE.
      newoploop: DO J3=1,NCORE(JP)
         IF (PERM(J3).NE.GENPERM(J2,J3)) THEN
            NEWOP=.TRUE.
            EXIT newoploop
         ENDIF
      ENDDO newoploop
      IF (.NOT.NEWOP) THEN
         IF (LDEBUG) WRITE(MYUNIT, '(2(A,I6))') 'generator ',J1,' appears to be the same as ',J2
         CYCLE genloop
      ENDIF
   ENDDO
!
!  Generator purification seems to be helpful.
!
   AMAT(1:3,1:3)=0.0D0
   DO J2=1,NCORE(JP)
      AMAT(1,1)=AMAT(1,1)+CORECOORDS(3*(PERM(J2)-1)+1)*CORECOORDS(3*(J2-1)+1)
      AMAT(1,2)=AMAT(1,2)+CORECOORDS(3*(PERM(J2)-1)+1)*CORECOORDS(3*(J2-1)+2)
      AMAT(1,3)=AMAT(1,3)+CORECOORDS(3*(PERM(J2)-1)+1)*CORECOORDS(3*(J2-1)+3)
      AMAT(2,1)=AMAT(2,1)+CORECOORDS(3*(PERM(J2)-1)+2)*CORECOORDS(3*(J2-1)+1)
      AMAT(2,2)=AMAT(2,2)+CORECOORDS(3*(PERM(J2)-1)+2)*CORECOORDS(3*(J2-1)+2)
      AMAT(2,3)=AMAT(2,3)+CORECOORDS(3*(PERM(J2)-1)+2)*CORECOORDS(3*(J2-1)+3)
      AMAT(3,1)=AMAT(3,1)+CORECOORDS(3*(PERM(J2)-1)+3)*CORECOORDS(3*(J2-1)+1)
      AMAT(3,2)=AMAT(3,2)+CORECOORDS(3*(PERM(J2)-1)+3)*CORECOORDS(3*(J2-1)+2)
      AMAT(3,3)=AMAT(3,3)+CORECOORDS(3*(PERM(J2)-1)+3)*CORECOORDS(3*(J2-1)+3)
   ENDDO
   SYMOP1(1,1)=AMAT(1,1)*LHESS(1,1)+AMAT(1,2)*LHESS(2,1)+AMAT(1,3)*LHESS(3,1)
   SYMOP1(2,1)=AMAT(1,1)*LHESS(1,2)+AMAT(1,2)*LHESS(2,2)+AMAT(1,3)*LHESS(3,2)
   SYMOP1(3,1)=AMAT(1,1)*LHESS(1,3)+AMAT(1,2)*LHESS(2,3)+AMAT(1,3)*LHESS(3,3)
   SYMOP1(1,2)=AMAT(2,1)*LHESS(1,1)+AMAT(2,2)*LHESS(2,1)+AMAT(2,3)*LHESS(3,1)
   SYMOP1(2,2)=AMAT(2,1)*LHESS(1,2)+AMAT(2,2)*LHESS(2,2)+AMAT(2,3)*LHESS(3,2)
   SYMOP1(3,2)=AMAT(2,1)*LHESS(1,3)+AMAT(2,2)*LHESS(2,3)+AMAT(2,3)*LHESS(3,3)
   SYMOP1(1,3)=AMAT(3,1)*LHESS(1,1)+AMAT(3,2)*LHESS(2,1)+AMAT(3,3)*LHESS(3,1)
   SYMOP1(2,3)=AMAT(3,1)*LHESS(1,2)+AMAT(3,2)*LHESS(2,2)+AMAT(3,3)*LHESS(3,2)
   SYMOP1(3,3)=AMAT(3,1)*LHESS(1,3)+AMAT(3,2)*LHESS(2,3)+AMAT(3,3)*LHESS(3,3)
   IF (LDEBUG) THEN
!
!  Just assume it is the same permutation.
!
       CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,NCORE(JP),3,3)
!!     CALL MINPERM(NCORE(JP),NEWQ,CORECOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM2,DUMMY,DIST2,WORSTRAD)
!      CALL TESTSYMOP(NCORE(JP),NEWQ,CORECOORDS,PERM2,LTOLD,DIST2,WORSTRAD)
!!     CALL BIPARTITE(NCORE(JP),NEWQ,CORECOORDS,PERM2,DUMMY,DIST2,WORSTRAD)
!      IF (DIST2.GT.1.0D2) THEN
!         SERROR2=1.0D3
!         WRITE(MYUNIT,'(A,2G20.10)') 'testsymop> ERROR - SERROR,SERROR2=',SERROR,SERROR2
!         STOP
!      ELSE
         SERROR2=0.0D0
         WRITE(MYUNIT,*) 'NCORE(JP)=',NCORE(JP)
         PERM2(1:NCORE(JP))=PERM(1:NCORE(JP))
         DO J2=1,NCORE(JP)
!           WRITE(MYUNIT,*) 'J2,PERM2=',J2,PERM2(J2)
!           IF (PERM2(J2).LT.1) THEN
!              WRITE(MYUNIT,*) 'ERROR, PERM2 < 1'
!              STOP
!           ENDIF
            SERROR2=SERROR2+(CORECOORDS(3*(PERM2(J2)-1)+1)-NEWQ(3*(J2-1)+1))**2+ &
 &                          (CORECOORDS(3*(PERM2(J2)-1)+2)-NEWQ(3*(J2-1)+2))**2+ &
 &                          (CORECOORDS(3*(PERM2(J2)-1)+3)-NEWQ(3*(J2-1)+3))**2
         ENDDO
         WRITE(MYUNIT, '(A,I5,G20.10)') 'operation, new error=',J1,SERROR2
         IF (SERROR2.GT.SERROR) WRITE(MYUNIT, '(A)') ' WARNING - error has increased - this should never happen'
!      ENDIF
   ENDIF
   NORDER=NORDER+1
   SYMOP(NORDER,1:3,1:3)=SYMOP1(1:3,1:3)
   GENPERM(NORDER,1:NCORE(JP))=PERM(1:NCORE(JP))
   OPPERM(NORDER,1:NCORE(JP))=PERM(1:NCORE(JP))
   IF (LDEBUG) WRITE(MYUNIT, '(A,I5,9F10.4)') 'NORDER,MAT: ',NORDER,SYMOP(NORDER,1:3,1:3)
   IF (LDEBUG) WRITE(MYUNIT, '(20I6)') PERM(1:NCORE(JP))
ENDDO genloop
!
! End refinement of generators.
! We could "purify" the combination operations generated in the next loop,
! but it does not seem necessary.
!
makegroup: DO 
   op1: DO J1=2,NORDER
      SYMOP1(1:3,1:3)=SYMOP(J1,1:3,1:3)
      op2: DO J2=2,NORDER
         SYMOP2(1:3,1:3)=SYMOP(J2,1:3,1:3)
         CALL MATMUL(NEWMAT,SYMOP1,SYMOP2,3,3,3,3,3,3)
         DO J3=1,NORDER
            CALL CMPMAT(SYMOP,120,J3,NEWMAT,NEW,MATDIFF)
            IF (.NOT.NEW) CYCLE op2
         ENDDO
!!
!!  Check for independent generators by comparing the integers in GENPERM
!!
!         DO J3=1,NCORE(JP)
!            PERM(J3)=OPPERM(J2,OPPERM(J1,J3))
!         ENDDO
!         DO J3=1,NORDER
!            NEWOP=.FALSE.
!            newoploop2: DO J4=1,NCORE(JP)
!               IF (PERM(J4).NE.OPPERM(J3,J4)) THEN
!                  NEWOP=.TRUE.
!                  EXIT newoploop2
!               ENDIF
!            ENDDO newoploop2
!            IF (.NOT.NEWOP) THEN
!!              IF (LDEBUG) PRINT '(A,I6)','operation appears to be the same as ',J3
!               CYCLE op2
!            ENDIF
!         ENDDO

         NORDER=NORDER+1
         IF (NORDER.GT.120) THEN
            WRITE(MYUNIT, '(A)') 'WARNING more than 120 operations case A!'
!           STOP
            NORDER=120
            EXIT makegroup
         ELSE
            SYMOP(NORDER,1:3,1:3)=NEWMAT(1:3,1:3)
            OPPERM(NORDER,1:NCORE(JP))=PERM(1:NCORE(JP))
            CYCLE makegroup
         ENDIF
      ENDDO op2
   ENDDO op1
   EXIT makegroup
ENDDO makegroup

CALL MYCPU_TIME(TIME)
IF (NPAR.GT.1) THEN
   WRITE(MYUNIT, '(A,I1,A,I5,A,F15.2)') '[',JP,']symmetry3> using point group of order ',NORDER, &
  &                                ' constructed from generators, time taken=',TIME-T0
ELSE
   WRITE(MYUNIT, '(A,I5,A,F15.2)') 'symmetry3> using point group of order ',NORDER, &
  &                                ' constructed from generators, time taken=',TIME-T0
ENDIF
IF (LDEBUG) THEN
   DO J1=1,NORDER
      WRITE(MYUNIT, '(A,I5,9F10.4)') 'J1,SYMOP: ',J1,SYMOP(J1,1:3,1:3)
   ENDDO
ENDIF
! test to check that we really have symmetry operations!
IF (LDEBUG) THEN
   OPEN(UNIT=MYUNIT2,FILE='testsym2.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NORDER
      SYMOP1(1:3,1:3)=SYMOP(J1,1:3,1:3)
      CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,NCORE(JP),3,3)
!     CALL MINPERM(NCORE(JP),NEWQ,CORECOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
      CALL TESTSYMOP(NCORE(JP),NEWQ,CORECOORDS,PERM,LTOLD,DIST2,WORSTRAD)
!     CALL BIPARTITE(NCORE(JP),NEWQ,CORECOORDS,PERM,DUMMY,DIST2,WORSTRAD)
      WRITE(MYUNIT2,'(I5)') NCORE(JP)
!     CALL MATMULV(NEWQ,LCOORDS,SYMOP1,NATOMS,3,3)
!     CALL MINPERM(NATOMS,NEWQ,LCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
!     CALL BIPARTITE(NATOMS,NEWQ,LCOORDS,PERM,DUMMY,DIST2,WORSTRAD)
!     WRITE(MYUNIT2,'(I5)') NATOMS
      WRITE(MYUNIT2,'(A,I5,2(A,F15.5))') 'operation ',J1,' dist=',DUMMY,' dist2=',DIST2
      WRITE(MYUNIT2,'(A2,2X,3G20.10)') ('LA',NEWQ(3*(J2-1)+1),NEWQ(3*(J2-1)+2),NEWQ(3*(J2-1)+3),J2=1,NCORE(JP))
   ENDDO
   CLOSE(MYUNIT2)
ENDIF

! Test for preservation of symmetry operations when more orbits are added.
! CORECOORDS and LCOORDS were both rotated above to the principal axis orientation.

SYMLOST(1:NORDER)=.FALSE.
ISTART=NCORE(JP)+1
NTOTAL=NCORE(JP)
NSYMOP=NORDER
LASTLOST=0
MINDIST=1.0D100
NMISSING(1:NORBIT)=0
symother: DO J1=NORBITSCORE+1,NORBIT
   NLOST=0
   CHANGE=.FALSE.
   NTOTAL=NTOTAL+ORBSIZE(J1)
   IF (LDEBUG) WRITE(MYUNIT, '(4(A,I5))') 'symmetry3> testing symmetry for orbit ',J1,' of ',ORBSIZE(J1), &
  &                                   ' atoms, running total=',NTOTAL,' symmetry elements remaining=',NSYMOP
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      ORBCOORDS(3*(J2-ISTART)+1:3*(J2-ISTART)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
   ENDDO
   IF (LDEBUG)  OPEN(UNIT=MYUNIT2,FILE='temp.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   IF (LDEBUG)  WRITE(MYUNIT2,'(I5)') NCORE(JP)+ORBSIZE(J1)
   IF (LDEBUG)  WRITE(MYUNIT2,*) ' '
   IF (LDEBUG)  WRITE(MYUNIT2,'(A2,2X,3G20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,NCORE(JP))
   IF (LDEBUG)  WRITE(MYUNIT2,'(A2,2X,3G20.10)') ('LB',ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,ORBSIZE(J1))
   IF (LDEBUG)  CLOSE(MYUNIT2)
   ISTART=ISTART+ORBSIZE(J1)
   IF (LDEBUG)  OPEN(UNIT=MYUNIT3,FILE='temp2.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J3=2,NORDER ! cycle over point group operations
      IF (.NOT.SYMLOST(J3)) THEN
         DO J2=1,ORBSIZE(J1)
            TRANSCOORDS(3*(J2-1)+1)=SUM(SYMOP(J3,1,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+2)=SUM(SYMOP(J3,2,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+3)=SUM(SYMOP(J3,3,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
         ENDDO
!        CALL MINPERM(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
         CALL TESTSYMOP(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,PERM,LTOLD,DIST2,WORSTRAD)
!        CALL BIPARTITE(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,PERM,DUMMY,DIST2,WORSTRAD)

!        CALL SORTXYZ(ORBCOORDS,ORBSORT,NORD,SYMTOL4,ORBSIZE(J1))
!        CALL COMPARE2(TRANSCOORDS,ORBSORT,NORD,ICOMP,SYMTOL4,ORBSIZE(J1),IPRNT)
!        IF (ICOMP.NE.0) THEN

         IF (DIST2/WORSTRAD.GT.SYMTOL4) THEN
!        IF (DIST2.GT.SYMTOL4) THEN
            SYMLOST(J3)=.TRUE.
            LASTORBIT=J1-1
            IF (LDEBUG.AND.(.NOT.DOMISSING)) WRITE(MYUNIT, '(A,I5,A,2F15.5)') 'symmetry element ',J3,' lost, DUMMY,DIST2=', &
  &                              DUMMY,DIST2
            NSYMOP=NSYMOP-1
            NLOST=NLOST+1
            LOSTOP(NLOST,1:3,1:3)=SYMOP(J3,1:3,1:3)
!
!  Only call the more expensive MINPERM to calculate the distance DUMMY if the operation
!  is known to be lost from calling the cheaper TESTSYMOP.
!
            CALL MINPERM(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
            IF (DUMMY.LT.MINDIST) THEN
               MINDIST=DUMMY
               CLOSEOP(1:3,1:3)=SYMOP(J3,1:3,1:3)
            ENDIF
            CHANGE=.TRUE.
            IF (LDEBUG) THEN
               WRITE(MYUNIT3,'(I5)') 2*ORBSIZE(J1)+SUM(ORBSIZE(1:J1-1))
               WRITE(MYUNIT3,'(A,I5,2F15.5)') 'operation,DUMMY,dist2=',J3,DUMMY,DIST2
               WRITE(MYUNIT3,'(A2,2X,3G20.10)') ('LA',TRANSCOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,ORBSIZE(J1))
               WRITE(MYUNIT3,'(A2,2X,3G20.10)') ('LB',ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,ORBSIZE(J1))
               DO J2=1,ISTART-ORBSIZE(J1)-1
                  WRITE(MYUNIT3,'(A2,2X,3G20.10)') 'LB',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
               ENDDO
            ENDIF
            IF (DOMISSING) THEN
               transloop: DO J2=1,ORBSIZE(J1) ! cycle over transformed coordinates
                  DO J4=1,ORBSIZE(J1) ! cycle over untransformed coordinates
                     DUMMY=SQRT((ORBCOORDS(3*(J4-1)+1)-TRANSCOORDS(3*(J2-1)+1))**2+ &
                                (ORBCOORDS(3*(J4-1)+2)-TRANSCOORDS(3*(J2-1)+2))**2+ &
                                (ORBCOORDS(3*(J4-1)+3)-TRANSCOORDS(3*(J2-1)+3))**2)
                     IF (DUMMY.LT.SYMTOL5) CYCLE transloop
                  ENDDO
                  DO J4=1,NMISSING(J1) ! cycle over known missing sites to avoid duplicates
                     DUMMY=SQRT((QMISSING(J1,3*(J4-1)+1)-TRANSCOORDS(3*(J2-1)+1))**2+ &
                                (QMISSING(J1,3*(J4-1)+2)-TRANSCOORDS(3*(J2-1)+2))**2+ &
                                (QMISSING(J1,3*(J4-1)+3)-TRANSCOORDS(3*(J2-1)+3))**2)
                     IF (DUMMY.LT.SYMTOL5) CYCLE transloop
                  ENDDO
                  IF (NMISSING(J1).EQ.120) THEN
                     WRITE(MYUNIT, '(A)') 'warning - too many missing sites'
                     EXIT transloop
                  ENDIF
                  NMISSING(J1)=NMISSING(J1)+1
                  QMISSING(J1,3*(NMISSING(J1)-1)+1:3*(NMISSING(J1)-1)+3)=TRANSCOORDS(3*(J2-1)+1:3*(J2-1)+3)
                  IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,I5,A,3F15.5)') 'orbit ',J1,' missing site ',NMISSING(J1), &
                              ' coords: ',TRANSCOORDS(3*(J2-1)+1:3*(J2-1)+3)
               ENDDO transloop
               IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,2F15.5,A,I5)') 'symmetry element ',J3,' lost, dists=',DUMMY,DIST2, &
                                                       ' missing sites=',NMISSING(J1)
            ENDIF
         ELSE
            IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A)') 'symmetry element ',J3,' retained'
         ENDIF
      ENDIF
   ENDDO
   IF (LDEBUG)  CLOSE(MYUNIT3)
   IF (CHANGE) LASTLOST=NLOST
   IF (NSYMOP.EQ.1) THEN
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5)') 'only the identity element remains for orbit ',J1
      EXIT symother
   ENDIF
ENDDO symother

IF (NSYMOP.GT.1) THEN ! the full structure still has some symmetry
   DO J3=2,NORDER     ! cycle over remaining point group operations - the identity is not counted
      IF (.NOT.SYMLOST(J3)) THEN
         NSYMREM=NSYMREM+1
         SYMREM(NSYMREM,1:3,1:3)=SYMOP(J3,1:3,1:3)
      ENDIF
   ENDDO
ENDIF

IF (LASTLOST.EQ.0) THEN
   WRITE(MYUNIT, '(2(A,I5))') 'symmetry3> symmetry of core is consistent with the overall symmetry'
   RETURN
ELSE
   WRITE(MYUNIT, '(2(A,I5))') 'symmetry3> number of symmetry elements lost in last change for orbit ',LASTORBIT+1,' was ',LASTLOST
ENDIF

IF (LDEBUG) THEN
   ISTART=1
   OPEN(UNIT=MYUNIT2,FILE='orbits2.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NORBIT
      WRITE(MYUNIT2,'(I5)') SUM(ORBSIZE(1:J1))+NMISSING(J1)
      WRITE(MYUNIT2,'(A)') ' '
      DO J2=ISTART,ISTART+ORBSIZE(J1)-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LA',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      DO J2=1,ISTART-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LB',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      DO J2=1,NMISSING(J1)
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LC',QMISSING(J1,3*(J2-1)+1:3*(J2-1)+3)
      ENDDO
      ISTART=ISTART+ORBSIZE(J1)
   ENDDO
   CLOSE(MYUNIT2)
ENDIF

IF (DOMISSING) THEN
   missopt: DO J1=1,NORBIT
      IF (NMISSING(J1).EQ.0) CYCLE missopt ! DO NOT DELETE!!
      IF (NMISSING(J1).GT.2) CYCLE missopt 
      COORDS(1:3*NATOMS,JP)=LCOORDS(1:3*NATOMS) ! sorted from weakest to strongest bound
      NMISS=0
!     DO J2=1,J1
      DO J2=J1,J1
         missloop: DO J3=1,NMISSING(J2)
            DO J4=NMISS+1,NATOMS
               DUMMY=SQRT((COORDS(3*(J4-1)+1,JP)-QMISSING(J2,3*(J3-1)+1))**2+ &
                          (COORDS(3*(J4-1)+2,JP)-QMISSING(J2,3*(J3-1)+2))**2+ &
                          (COORDS(3*(J4-1)+3,JP)-QMISSING(J2,3*(J3-1)+3))**2)
               IF (DUMMY.LT.SYMTOL5) THEN
                  WRITE(MYUNIT, '(3(A,I5))') 'missing site ',J3,' from orbit ',J2,' is too close to atom ',J4
                  CYCLE missloop
               ENDIF
            ENDDO
            NMISS=NMISS+1
            COORDS(3*(NMISS-1)+1:3*(NMISS-1)+3,JP)=QMISSING(J2,3*(J3-1)+1:3*(J3-1)+3)
         ENDDO missloop
      ENDDO
!     IF (NMISS.GT.12) EXIT missopt
      IF (NMISS.EQ.0) CYCLE missopt
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A)') 'filling ',NMISS,' missing sites'
      
      NQTOT=NQTOT+1
      NQ(JP)=NQ(JP)+1
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      WRITE(MYUNIT,'(A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') 'Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
! Save the best structure
      IF (HIT) THEN
         EPREV(JP)=EBEST
         POTEL=EBEST
         VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
         COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS)
         IF (EPREV(JP)-EBEST.GT.ECONV) CHANGEDE=.TRUE.
         RETURN
      ENDIF
      IF (EBEST-POTEL.GT.ECONV) THEN
         EBEST=POTEL
         QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
         VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
         NSYMREM=0
         EXIT missopt
      ENDIF
      IF (NQTOT-NQTOTSAVE.GE.NSYMQMAX) EXIT missopt
   ENDDO missopt
ENDIF

! IF (CHANGECLOSE.AND.NSYMCALL.GT.1) ! this version for a limited number of calls to symmetry with
                                     ! systematic changes in CLOSEOP
IF (CHANGECLOSE.AND.(DPRAND().GT.0.5D0)) THEN ! change CLOSEOP to the closest lost operation for orbit NCHOOSE
!  NCHOOSE=NORBIT-NSYMCALL+2 
   MINDIST=1.0D100
   DUMMY=DPRAND()
   NCHOOSE=INT(DUMMY*(NORBIT-LASTORBIT+1))+LASTORBIT
   WRITE(MYUNIT, '(A,I5)') 'changing CLOSEOP to the closest lost operation for orbit ',NCHOOSE
   NDUMMY=SUM(ORBSIZE(1:NCHOOSE-1))
   DO J2=NDUMMY+1,NDUMMY+ORBSIZE(NCHOOSE)
      ORBCOORDS(3*(J2-NDUMMY-1)+1:3*(J2-NDUMMY-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
   ENDDO
   DO J3=2,NORDER ! cycle over point group operations
      IF (SYMLOST(J3)) THEN
         DO J2=1,ORBSIZE(NCHOOSE)
            TRANSCOORDS(3*(J2-1)+1)=SUM(SYMOP(J3,1,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+2)=SUM(SYMOP(J3,2,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+3)=SUM(SYMOP(J3,3,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
         ENDDO
!
!  Must use MINPERM here because TESTSYMOP doesn't calculate DUMMY
!
         CALL MINPERM(ORBSIZE(NCHOOSE),ORBCOORDS,TRANSCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
!        CALL TESTSYMOP(ORBSIZE(NCHOOSE),ORBCOORDS,TRANSCOORDS,PERM,LTOLD,DIST2,WORSTRAD)
!        CALL BIPARTITE(ORBSIZE(NCHOOSE),ORBCOORDS,TRANSCOORDS,PERM,DUMMY,DIST2,WORSTRAD)
         IF (DUMMY.LT.MINDIST) THEN
            MINDIST=DUMMY
            CLOSEOP(1:3,1:3)=SYMOP(J3,1:3,1:3)
         ENDIF
      ENDIF
   ENDDO
ENDIF

IF (NSYMOP.GT.1) THEN ! the full structure still has some symmetry
!  DO J3=2,NORDER ! cycle over remaining point group operations - the identity is not counted
!     IF (.NOT.SYMLOST(J3)) THEN
!        NSYMREM=NSYMREM+1
!        SYMREM(NSYMREM,1:3,1:3)=SYMOP(J3,1:3,1:3)
!     ENDIF
!  ENDDO
   IF (DPRAND().GT.0.0D0) THEN ! add remaining symmetry elements to the LASTLOST set to complete that subgroup
      DO J3=2,NORDER ! cycle over remaining point group operations - the identity is not needed
         IF (.NOT.SYMLOST(J3)) THEN
            LASTLOST=LASTLOST+1
            LOSTOP(LASTLOST,1:3,1:3)=SYMOP(J3,1:3,1:3)
         ENDIF
      ENDDO
      WRITE(MYUNIT, '(3(A,I5))') 'after adding the remaining ',NSYMOP-1,' non-identity elements there are ',LASTLOST,' in total'
   ELSE ! or, with 0% probability, just use the full symmetry. In this case we will only permute single weakly bound atoms.
      LASTLOST=0
      DO J3=2,NORDER ! cycle over remaining point group operations - the identity is not needed
         IF (.NOT.SYMLOST(J3)) THEN
            LASTLOST=LASTLOST+1
            LOSTOP(LASTLOST,1:3,1:3)=SYMOP(J3,1:3,1:3)
         ENDIF
      ENDDO
      WRITE(MYUNIT, '(3(A,I5))') 'using the remaining ',NSYMOP-1,' non-identity elements'
   ENDIF
!
! Need this line in case COORDS are not changed so that KEEPSYM works in TAKESTEP
! QBEST may already have been changed in the DOMISSING block, in which case
! NSYMREM will have been set to zero.
!
   IF (NSYMREM.GT.0) QBEST(1:3*NATOMS)=LCOORDS(1:3*NATOMS) 
ENDIF

! Move coordinates into CORE and OTHER vectors. Define NCORE(JP), the number of core atoms.
! CORECOORDS and NCORE(JP) are expanded to include all the atoms in orbits that are invariant
! under all the operations of the previously defined core.

ISTART=1
DO J1=1,LASTORBIT
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      CORECOORDS(3*(J2-1)+1:3*(J2-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      COREVT(J2)=VT(NINDEX(J2))
   ENDDO
   ISTART=ISTART+ORBSIZE(J1)
ENDDO
NCORE(JP)=ISTART-1
DO J1=LASTORBIT+1,NORBIT
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      OTHERCOORDS(3*(J2-NCORE(JP)-1)+1:3*(J2-NCORE(JP)-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      OTHERVT(J2-NCORE(JP))=VT(NINDEX(J2))
   ENDDO
   ISTART=ISTART+ORBSIZE(J1)
ENDDO

IF (LASTLOST.GT.50) THEN 

! Instead of using all the symmetry operations in LASTLOST to define orbits, try using the subgroup
! generated by CLOSEOP. This should be smaller.

   NSUB=2
   SUBOP(1,1:3,1:3)=SYMOP(1,1:3,1:3)
   SUBOP(2,1:3,1:3)=CLOSEOP(1:3,1:3)
   makesub: DO
      subop1: DO J1=2,NSUB
         SYMOP1(1:3,1:3)=SUBOP(J1,1:3,1:3)
         subop2: DO J2=2,NSUB
            SYMOP2(1:3,1:3)=SUBOP(J2,1:3,1:3)            
            CALL MATMUL(NEWMAT,SYMOP1,SYMOP2,3,3,3,3,3,3)
!           IF (LDEBUG) PRINT '(A,2I5,9F10.4)','J1,J2,NEWMAT: ',J1,J2,NEWMAT
! Identify symmetry element from original group and use this instead.
! The idea is to avoid propagation of numerical errors.
            replaceop: DO J3=1,NORDER
               CALL CMPMAT(SYMOP,120,J3,NEWMAT,NEW,MATDIFF)
               IF (.NOT.NEW) THEN
                  NEWMAT(1:3,1:3)=SYMOP(J3,1:3,1:3)
                  EXIT replaceop
               ENDIF
            ENDDO replaceop
            DO J3=1,NSUB
               CALL CMPMAT(SUBOP,120,J3,NEWMAT,NEW,MATDIFF)
               IF (.NOT.NEW) CYCLE subop2
            ENDDO
            NSUB=NSUB+1
            IF (NSUB.GT.120) THEN
               WRITE(MYUNIT, '(A)') 'WARNING more than 120 operations case B!'
               NSUB=120
!              STOP
               EXIT makesub
            ELSE
               SUBOP(NSUB,1:3,1:3)=NEWMAT(1:3,1:3)
               CYCLE makesub
            ENDIF
         ENDDO subop2
      ENDDO subop1
      EXIT makesub
   ENDDO makesub

   WRITE(MYUNIT, '(A,I5,A)') 'using subgroup of order ',NSUB,' constructed from lost operation'
   IF (LDEBUG) THEN
      DO J1=1,NSUB
         WRITE(MYUNIT, '(A,I5,9F10.4)') 'J1,SUBOP: ',J1,SUBOP(J1,1:3,1:3)
      ENDDO
   ENDIF

   LASTLOST=NSUB
   DO J1=1,NSUB
      LOSTOP(J1,1:3,1:3)=SUBOP(J1,1:3,1:3)
   ENDDO
ENDIF

! Core atoms are added to the float list if their pair energy is high enough.
VMIN=1.0D100
VMAX=-1.0D100
DO J1=1,NATOMS
   IF (VAT(J1,JP).LT.VMIN) VMIN=VAT(J1,JP)
   IF (VAT(J1,JP).GT.VMAX) VMAX=VAT(J1,JP)
ENDDO

! We can either use just the most weakly bound atom, or all those satisfying the ASTEP condition.
! We can also require these atoms to be invariant under CLOSEOP, or not.

NFLOAT=NATOMS-NCORE(JP)
IF (RESTRICT) THEN
   SYMOP1(1:3,1:3)=CLOSEOP(1:3,1:3)
   CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,NCORE(JP),3,3)
ENDIF
NMOVE=0
weak: DO J1=1,NCORE(JP)
!  PRINT '(A,I5,3G20.10)','J1,COREVT,VMIN,ASTEP(JP)*VMIN=',J1,COREVT(J1),VMIN,ASTEP(JP)*VMIN
   IF (WEAKESTONLY) THEN
      LDUMMY=COREVT(J1).GE.VMAX
   ELSE
      LDUMMY=COREVT(J1).GT.ASTEP(JP)*VMIN
   ENDIF
   IF (LDUMMY) THEN
      IF (RESTRICT) THEN
         DIST2=SQRT((CORECOORDS(3*(J1-1)+1)-NEWQ(3*(J1-1)+1))**2+ &
                    (CORECOORDS(3*(J1-1)+2)-NEWQ(3*(J1-1)+2))**2+ &
                    (CORECOORDS(3*(J1-1)+3)-NEWQ(3*(J1-1)+3))**2)
      ELSE
         DIST2=0.0D0
      ENDIF
      IF (DIST2.LE.SYMTOL4) THEN ! atom lies on the symmetry element 
         NFLOAT=NFLOAT+1
         OTHERCOORDS(3*(NFLOAT-1)+1:3*(NFLOAT-1)+3)=CORECOORDS(3*(J1-1)+1:3*(J1-1)+3)
         OTHERVT(NFLOAT)=COREVT(J1)
         NMOVE=NMOVE+1
         MOVEINDEX(NMOVE)=J1
         IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,2I5,A,F15.5)') 'weakly bound invariant atom ',J1, &
                          ' added to floater list, NCORE(JP),NFLOAT=',NCORE(JP)-NMOVE,NFLOAT, &
                          ' pair energy=',COREVT(J1)
!        PRINT '(A,I5,3F15.5)','moved atom coords: ',J1,CORECOORDS(3*(J1-1)+1:3*(J1-1)+3)
!        PRINT '(A,I5,3F15.5)','other atom coords: ',NFLOAT,OTHERCOORDS(3*(NFLOAT-1)+1:3*(NFLOAT-1)+3)
         IF (WEAKESTONLY) EXIT weak ! we know there is only one atom to do
      ENDIF
   ENDIF
ENDDO weak

DO J1=NMOVE,1,-1
   DO J2=MOVEINDEX(J1),NCORE(JP)-1
      CORECOORDS(3*(J2-1)+1:3*(J2-1)+3)=CORECOORDS(3*J2+1:3*J2+3)
      COREVT(J2)=COREVT(J2+1)
   ENDDO
   NCORE(JP)=NCORE(JP)-1
ENDDO

! Apply all the non-identity operators in LASTLOST to each non-core atom to generate
! the corresponding orbit. Remove duplicates as we go along.
! If an atom lies in a previous orbit, skip it.
! New orbits should be guaranteed because we check that atom
! J1 does not lie in any previous NEWORB;s and we know it does not lie in
! any of the SYMORB sites.

NEWORB=0
NCORENEW=0
MOVEDTOCORE(1:NATOMS-NCORE(JP))=.FALSE.
otherloop: DO J1=1,NATOMS-NCORE(JP)
   IF (MOVEDTOCORE(J1)) CYCLE otherloop
! compare with members of previous orbits
   DO J2=1,NEWORB
      DO J3=1,NEWORBSIZE(J2)
         DUMMY=SQRT((NEWORBCOORDS(J2,3*(J3-1)+1)-OTHERCOORDS(3*(J1-1)+1))**2+ &
                    (NEWORBCOORDS(J2,3*(J3-1)+2)-OTHERCOORDS(3*(J1-1)+2))**2+ &
                    (NEWORBCOORDS(J2,3*(J3-1)+3)-OTHERCOORDS(3*(J1-1)+3))**2)
         IF (DUMMY.LT.SYMTOL5) CYCLE otherloop
      ENDDO
   ENDDO
   NDUMMY=1
   TMPCOORDS(1:3)=OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3)
   NEWORBCOORDS(NEWORB+1,1:3)=TMPCOORDS(1:3)
   applyops: DO J2=1,LASTLOST
      TMPCOORDS(1)=SUM(LOSTOP(J2,1,1:3)*OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3))
      TMPCOORDS(2)=SUM(LOSTOP(J2,2,1:3)*OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3))
      TMPCOORDS(3)=SUM(LOSTOP(J2,3,1:3)*OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3))
      DO J3=1,NDUMMY ! check overlaps with current orbit
         DUMMY=SQRT((TMPCOORDS(1)-NEWORBCOORDS(NEWORB+1,3*(J3-1)+1))**2+ &
                    (TMPCOORDS(2)-NEWORBCOORDS(NEWORB+1,3*(J3-1)+2))**2+ &
                    (TMPCOORDS(3)-NEWORBCOORDS(NEWORB+1,3*(J3-1)+3))**2)
         IF (DUMMY.LT.SYMTOL5) CYCLE applyops
      ENDDO 
      DO J3=1,NCORE(JP)+NCORENEW ! check overlaps with core atoms
         DUMMY=SQRT((TMPCOORDS(1)-CORECOORDS(3*(J3-1)+1))**2+ &
                    (TMPCOORDS(2)-CORECOORDS(3*(J3-1)+2))**2+ &
                    (TMPCOORDS(3)-CORECOORDS(3*(J3-1)+3))**2)
         IF (DUMMY.LT.SYMTOL5) CYCLE applyops
      ENDDO
      DO J4=1,NEWORB ! check overlaps with previous orbits
         DO J3=1,NEWORBSIZE(J4)
            DUMMY=SQRT((NEWORBCOORDS(J4,3*(J3-1)+1)-TMPCOORDS(1))**2+ &
                       (NEWORBCOORDS(J4,3*(J3-1)+2)-TMPCOORDS(2))**2+ &
                       (NEWORBCOORDS(J4,3*(J3-1)+3)-TMPCOORDS(3))**2)
!           IF (DUMMY.LT.SYMTOL5) CYCLE applyops ! works best to give up on this orbit completely
            IF (DUMMY.LT.SYMTOL5) CYCLE otherloop
         ENDDO
      ENDDO
      NDUMMY=NDUMMY+1
      NEWORBCOORDS(NEWORB+1,3*(NDUMMY-1)+1:3*(NDUMMY-1)+3)=TMPCOORDS(1:3)
!     PRINT '(A,I5,A,I5,A,3G20.10)','new orbit ',NEWORB+1,' new site ',NDUMMY,' coords: ',TMPCOORDS(1:3)
   ENDDO applyops
! Test whether this orbit is contained completely within OTHERCOORDS. If it is,
! move these coordinates to the core.
   NCORETMP=0
   IF (MOVETOCORE) THEN
      MATCHED=.TRUE.
      neworbcoord: DO J2=1,NDUMMY
         DO J3=1,NATOMS-NCORE(JP)
            IF (.NOT.MOVEDTOCORE(J3)) THEN
               DUMMY=SQRT((OTHERCOORDS(3*(J3-1)+1)-NEWORBCOORDS(NEWORB+1,3*(J2-1)+1))**2+ &
                          (OTHERCOORDS(3*(J3-1)+2)-NEWORBCOORDS(NEWORB+1,3*(J2-1)+2))**2+ &
                          (OTHERCOORDS(3*(J3-1)+3)-NEWORBCOORDS(NEWORB+1,3*(J2-1)+3))**2)
               IF (DUMMY.LT.SYMTOL4) THEN

!  It can happen that two images in NEWORBCOORDS match the same core atom. Don;t move
!  this atom to the core more than once! 

                  DO J4=1,NCORETMP
                     IF (NEWCOREINDEX(J4).EQ.J3) THEN
!                       PRINT '(A,I5,A,I5,A,G20.10)','new orbit atom ',J2,' also matches floater ',J3, &
!                                                    ' DUMMY=',DUMMY
                        CYCLE neworbcoord
                     ENDIF
                  ENDDO

                  NCORETMP=NCORETMP+1
                  CORECOORDS(3*(NCORE(JP)+NCORENEW+NCORETMP-1)+1:3*(NCORE(JP)+NCORENEW+NCORETMP-1)+3)= &
                                OTHERCOORDS(3*(J3-1)+1:3*(J3-1)+3)
                  COREVT(NCORE(JP)+NCORENEW+NCORETMP)=OTHERVT(J3)
                  NEWCOREINDEX(NCORETMP)=J3
!                 PRINT '(A,I5,A,I5,A,G20.10)','new orbit atom ',J2,' matches floater ',J3,' DUMMY=',DUMMY
                  CYCLE neworbcoord
               ENDIF
            ENDIF
         ENDDO
         MATCHED=.FALSE.
         EXIT neworbcoord
      ENDDO neworbcoord
   ENDIF
   IF (MATCHED.AND.(NCORETMP.GT.1)) THEN ! leave single atoms as floaters, otherwise move to core
      NCORENEW=NCORENEW+NCORETMP
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,120I5)') 'moving ',NCORETMP,' atoms to the core: ',NEWCOREINDEX(1:NCORETMP)
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5)') 'number of core atoms=',NCORE(JP)+NCORENEW
      DO J2=1,NCORETMP
         MOVEDTOCORE(NEWCOREINDEX(J2))=.TRUE.
      ENDDO
      CYCLE otherloop
   ENDIF

! Otherwise, store the new orbit.

   NEWORB=NEWORB+1
   NEWORBSIZE(NEWORB)=NDUMMY
   IF (LDEBUG) WRITE(MYUNIT, '(3(A,I6))') 'new orbit ',NEWORB,' of dimension ',NEWORBSIZE(NEWORB), &
                ' generated from floater ',J1
!  IF (NEWORB.GT.10) THEN
!     PRINT '(A)','number of new orbits is too large - quitting symmetry'
!     RETURN
!  ENDIF
ENDDO otherloop

NCORE(JP)=NCORE(JP)+NCORENEW

IF (LDEBUG) THEN
   OPEN(MYUNIT2,FILE='coreplusother.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   WRITE(MYUNIT2,*) NATOMS
   WRITE(MYUNIT2,*) ' '
   WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,NCORE(JP))
   NDUMMY=0
   DO J1=1,NATOMS
      IF (.NOT.MOVEDTOCORE(J1)) THEN
         WRITE(MYUNIT2,'(A2,3X,3F20.10)') 'LB',OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3)
         NDUMMY=NDUMMY+1
         IF (NDUMMY.EQ.NATOMS-NCORE(JP)) EXIT
      ENDIF
   ENDDO
   CLOSE(MYUNIT2)

   OPEN(UNIT=MYUNIT2,FILE='neworbits.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NEWORB
      WRITE(MYUNIT2,'(I6)') SUM(NEWORBSIZE(1:J1))+NCORE(JP)
!     WRITE(MYUNIT2,'(I6)') NEWORBSIZE(J1)
      WRITE(MYUNIT2,'(A)') ' '
      WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,NCORE(JP))
      DO J3=1,J1-1
         WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LC',NEWORBCOORDS(J3,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J3))
      ENDDO
!     WRITE(MYUNIT2,'(A2,3X,3F20.10)') (('LB',NEWORBCOORDS(J1,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J1)),J1=1,1)
      WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LB',NEWORBCOORDS(J1,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J1))
   ENDDO
   CLOSE(MYUNIT2)

   OPEN(UNIT=MYUNIT2,FILE='newpluscore.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   WRITE(MYUNIT2,'(I6)') SUM(NEWORBSIZE(1:NEWORB))+NCORE(JP)
   WRITE(MYUNIT2,'(A)') ' '
   WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,NCORE(JP))
   WRITE(MYUNIT2,'(A2,3X,3F20.10)') (('LB',NEWORBCOORDS(J1,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J1)),J1=1,NEWORB)
   CLOSE(MYUNIT2)
ENDIF
IF (NCORE(JP).EQ.NATOMS) RETURN

! We want to try to make complete orbits and fill them up. Try all possibilities 
! for precisely filled orbits as starting points for quenches. Each orbit is either
! occupied completely or not, and we need to enumerate the possibilities.
!
! Now fill in the NEWORB orbits with the NATOMS-NCORE(JP)=NFLOAT candidates. 
! Only quench candidate geometries where orbits are completely filled.
! Each orbit can either be filled or empty, giving 2^NEWORB possibilities,
! but most will probably be disallowed because the occupation won;t match NFLOAT.

NFLOAT=NATOMS-NCORE(JP)
ALLOCATE(OCCS(NSYMQMAX,NEWORB))
CALL ENUMERATE(NFLOAT,NEWORB,NEWORBSIZE,NSYMQMAX,OCCS,NPOSS,LDEBUG)

IF (.TRUE.) THEN

   perms2: DO NTRIES=1,MIN(NSYMQMAX,NPOSS) ! NPOSS is the number of permutations saved
      NCHOICE(1:NEWORB)=OCCS(NTRIES,1:NEWORB)
      NDUMMY=0
      DO J1=1,NEWORB
         NDUMMY=NDUMMY+NCHOICE(J1)*NEWORBSIZE(J1)
      ENDDO
      IF (NDUMMY.NE.NFLOAT) THEN
         WRITE(MYUNIT, '(A,2I5,A)') 'ERROR - NDUMMY,NFLOAT=',NDUMMY,NFLOAT,' in symmetry'
         STOP
      ENDIF
      IF (LDEBUG) WRITE(MYUNIT, '(A)') 'NCHOICE:'
      IF (LDEBUG) WRITE(MYUNIT, '(60I2)') NCHOICE(1:NEWORB)
      IF (LDEBUG) WRITE(MYUNIT, '(A,2I5)') 'NDUMMY,NFLOAT=',NDUMMY,NFLOAT
      COORDS(1:3*NCORE(JP),JP)=CORECOORDS(1:3*NCORE(JP))
      NDUMMY=NCORE(JP)
      DO J1=1,NEWORB
         IF (NCHOICE(J1).EQ.1) THEN
            COORDS(3*NDUMMY+1:3*(NDUMMY+NEWORBSIZE(J1)),JP)=NEWORBCOORDS(J1,1:3*NEWORBSIZE(J1))
            NDUMMY=NDUMMY+NEWORBSIZE(J1)
         ENDIF
      ENDDO
      NQTOT=NQTOT+1
      NQ(JP)=NQ(JP)+1
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      WRITE(MYUNIT,'(A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') 'Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
   ! Save the best structure
      IF (EBEST-POTEL.GT.ECONV) THEN
         EBEST=POTEL
         QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
         VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
         NSYMREM=0
!        EXIT perms2 ! seems to be OK - perhaps not for LJ185?
      ENDIF
      IF (NQTOT-NQTOTSAVE.GE.NSYMQMAX) EXIT perms2
      IF (HIT) EXIT perms2
   ENDDO perms2

ELSE ! old enumeration

   NCHOICE(1:NEWORB)=0
   NTOPSUM=0
   IF (NEWORB.LE.10) THEN ! with 10 new orbits or fewer, try all possibilities.
      NTOP=0
   ELSE                   ! otherwise, try filling up the first new orbits at the start
      neworbinit: DO J1=1,NEWORB
         NMINREM=MINVAL(NEWORBSIZE(J1+1:NEWORB))
         IF (NTOPSUM+NMINREM+NEWORBSIZE(J1).LE.NFLOAT) THEN
   !     IF (NTOPSUM+NEWORBSIZE(J1).LT.NFLOAT) THEN
            NCHOICE(J1)=1
            NTOPSUM=NTOPSUM+NEWORBSIZE(J1)
         ELSE
            NTOP=J1-1
            EXIT neworbinit
         ENDIF
      ENDDO neworbinit
   ENDIF
   NTRIES=0
   perms: DO
      NTRIES=NTRIES+1
      IF (NTRIES.GE.NSYMQMAX*100) EXIT perms ! another escape route if there are too many choices
      NCHOICE(NEWORB)=NCHOICE(NEWORB)+1
      NDUMMY=0
      DO J1=NEWORB,2,-1
         IF (NCHOICE(J1).EQ.2) THEN
            NCHOICE(J1)=0
            NCHOICE(J1-1)=NCHOICE(J1-1)+1
         ENDIF
         IF (NCHOICE(J1).EQ.1) NDUMMY=NDUMMY+NEWORBSIZE(J1)
      ENDDO
   !  PRINT*,'NTOP,NCHOICE(NTOP+1)=',NTOP,NCHOICE(NTOP+1)
      IF (NCHOICE(NTOP+1).EQ.1) THEN
         NTOP=NTOP+1
         NTOPSUM=NTOPSUM+NEWORBSIZE(NTOP)
   !     PRINT*,'NTOP,NTOPSUM,NFLOAT=',NTOP,NTOPSUM,NFLOAT
         IF (NTOPSUM.GT.NFLOAT) EXIT perms ! all subsequent attempts would have too many atoms.
      ENDIF
      IF (NCHOICE(1).EQ.1) NDUMMY=NDUMMY+NEWORBSIZE(1)
      IF (NCHOICE(1).GT.1) EXIT perms
      IF (LDEBUG) WRITE(MYUNIT, '(A)') 'NCHOICE:'
      IF (LDEBUG) WRITE(MYUNIT, '(60I2)') NCHOICE(1:NEWORB)
      IF (LDEBUG) WRITE(MYUNIT, '(A,2I5)') 'NDUMMY,NFLOAT=',NDUMMY,NFLOAT
      IF (NDUMMY.NE.NFLOAT) CYCLE perms
      IF (NCHOICE(1).GT.1) EXIT perms
      COORDS(1:3*NCORE(JP),JP)=CORECOORDS(1:3*NCORE(JP))
      NDUMMY=NCORE(JP)
      DO J1=1,NEWORB
         IF (NCHOICE(J1).EQ.1) THEN
            COORDS(3*NDUMMY+1:3*(NDUMMY+NEWORBSIZE(J1)),JP)=NEWORBCOORDS(J1,1:3*NEWORBSIZE(J1))
            NDUMMY=NDUMMY+NEWORBSIZE(J1)
         ENDIF
      ENDDO
      IF (NDUMMY.NE.NATOMS) THEN
         WRITE(MYUNIT, '(A,2I5)') 'ERROR - NDUMMY,NATOMS=',NDUMMY,NATOMS
         STOP
      ENDIF
      NQTOT=NQTOT+1
      NQ(JP)=NQ(JP)+1
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      WRITE(MYUNIT,'(A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') 'Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
   ! Save the best structure
      IF (EBEST-POTEL.GT.ECONV) THEN
         EBEST=POTEL
         QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
         VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
         NSYMREM=0
         EXIT perms
      ENDIF
      IF (NQTOT-NQTOTSAVE.GE.NSYMQMAX) EXIT perms
      IF (HIT) EXIT perms
   ENDDO perms
ENDIF

IF (EPREV(JP)-EBEST.GT.ECONV) CHANGEDE=.TRUE. 
EPREV(JP)=EBEST
POTEL=EBEST
VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS)
! PRINT '(A,3F15.5,L10)','in symmetry 2 EPREV(JP),POTEL,EBEST,CHANGEDE=',EPREV(JP),POTEL,EBEST,CHANGEDE
IF (.NOT.MOVESHELLT) RETURN
IF (NCOREREAL.LE.NCORESAVE) THEN
   NCORE(JP)=NCORESAVE
   RETURN
ENDIF
IF (NCORE(JP).LT.NCOREREAL) WRITE(MYUNIT,'()') 'symmetry3> WARNING - NCOREREAL, NCORE(JP)=',NCOREREAL, NCORE(JP)
NCORE(JP)=NCOREREAL

DO J1=1,NPAR
   IF (J1.EQ.JP) CYCLE
!  WRITE(MYUNIT,*) 'symmetry2> J1,SHELLMOVES,PTGROUP,POINTGROUP=',J1,SHELLMOVES(J1),PTGROUP(J1),POINTGROUP
   IF (.NOT.SHELLMOVES(J1)) CYCLE
   IF (POINTGROUP.EQ.PTGROUP(J1)) THEN
      IF (NPAR.GT.1) THEN
         WRITE(MYUNIT,'(A,I1,3A,I6)') '[',JP,']symmetry2> point group ',POINTGROUP,' coincides with run ',J1
      ELSE
         WRITE(MYUNIT,'(3A,I6)') 'symmetry3> point group ',POINTGROUP,' coincides with run ',J1
      ENDIF
      NCORE(JP)=0
      NSURFMOVES(JP)=0
      SHELLMOVES(JP)=.FALSE. ! in case this was true and the symmetry has just increased to that of another run
      RETURN
   ENDIF
ENDDO
NSURFMOVES(JP)=0
SHELLMOVES(JP)=.TRUE.
PTGROUP(JP)=POINTGROUP

IF (NPAR.GT.1) THEN
   WRITE(MYUNIT,'(A,I1,A,I8,A,I8,2A)') '[',JP,']symmetry2> starting a block of ',SHELLMOVEMAX,' moves with ', &
  &      NCORE(JP),' atoms unperturbed, core symmetry ',POINTGROUP
ELSE     
   WRITE(MYUNIT,'(A,I8,A,I8,2A)') 'symmetry2> starting a block of ',SHELLMOVEMAX,' moves with ', &
  &      NCORE(JP),' atoms unperturbed, core symmetry ',POINTGROUP
ENDIF    

RETURN

END SUBROUTINE SYMMETRY3

!        LIMITED MEMORY BFGS METHOD FOR LARGE SCALE OPTIMIZATION
!                          JORGE NOCEDAL
!                        *** July 1990 ***
!
!        Line search removed plus small modifications, DJW 2001
!
SUBROUTINE SMYLBFGS(X,EPS,MFLAG,ENERGY,ITMAX,ITDONE,COORDS,NATOMS,APARAM)
USE porfuncs
USE commons, only: myunit
IMPLICIT NONE
INTEGER N,M,J1,ITMAX,ITDONE,NFAIL,NATOMS
PARAMETER (N=3,M=5)  !  MMUPDATE is actually ignored
DOUBLE PRECISION X(N),G(3),DIAG(N),W(N*(2*M+1)+2*M),SLENGTH,DDOT,OVERLAP,COORDS(*)
DOUBLE PRECISION EPS,DUMMY1,ENERGY,ENEW,RMS,ALPHA,GSAVE(3),GDUM(3),DOT1,DOT2
DOUBLE PRECISION GNORM,STP,YS,YY,SQ,YR,BETA,MAXMBFGS,APARAM
INTEGER ITER,POINT,ISPT,IYPT,BOUND,NPT,CP,I,INMC,IYCN,ISCN,NDECREASE
LOGICAL MFLAG, PTEST
INTEGER ISTAT

MAXMBFGS=0.05D0
PTEST=.TRUE.
PTEST=.FALSE.
ALPHA=1.0D0
NFAIL=0
ITER=0
ITDONE=0
CALL SFUNC(X,ENERGY,GSAVE,.TRUE.,COORDS,NATOMS,APARAM)
RMS=SQRT((GSAVE(1)**2+GSAVE(2)**2+GSAVE(3)**2)/3)
DO J1=1,N
   G(J1)=GSAVE(J1)
ENDDO

IF (PTEST) WRITE(MYUNIT,'(A,2F20.10,A,I6,A)') ' func and RMS force=',ENERGY,RMS,' after ',ITDONE,' LBFGS steps'
16    FORMAT(A,27X,F20.10,A)

10    CALL FLUSH(MYUNIT,ISTAT)
MFLAG=.FALSE.
IF (RMS.LE.EPS) THEN
   MFLAG=.TRUE.
   IF (MFLAG) THEN
!           WRITE(*,'(A,F20.10)') ' Diagonal inverse Hessian elements are now ',DIAG(1)
      RETURN
   ENDIF
ENDIF

IF (ITDONE.EQ.ITMAX) THEN
!        WRITE(*,'(A,F20.10)') ' Diagonal inverse Hessian elements are now ',DIAG(1)
   RETURN
ENDIF

IF (ITER.EQ.0) THEN
   IF (N.LE.0.OR.M.LE.0) THEN
      WRITE(MYUNIT,240)
 240        FORMAT(' IMPROPER INPUT PARAMETERS (N OR M ARE NOT POSITIVE)')
      STOP
   ENDIF
   POINT=0
   MFLAG=.FALSE.
   DO I=1,N
      DIAG(I)=1.0D0
   ENDDO
   ISPT= N+2*M
   IYPT= ISPT+N*M
   DO I=1,N
      W(ISPT+I)= -G(I)*DIAG(I)
      W(I)= -G(I)*DIAG(I)
   ENDDO
   GNORM= DSQRT(DDOT(N,G,1,G,1))
!  Make the first guess for the step length cautious.
   STP=MIN(1.0D0/GNORM,GNORM)
ELSE 
   BOUND=ITER
   IF (ITER.GT.M) BOUND=M
   YS= DDOT(N,W(IYPT+NPT+1),1,W(ISPT+NPT+1),1)
   IF (YS.EQ.0.0D0) YS=1.0D0
!  Update estimate of diagonal inverse Hessian elements
!  We divide by both YS and YY at different points, so
!  they had better not be zero!
   YY= DDOT(N,W(IYPT+NPT+1),1,W(IYPT+NPT+1),1)
   IF (YY.EQ.0.0D0) YY=1.0D0
!  DUMMY1=ABS(YS/YY)
   DUMMY1=YS/YY
   DO I=1,N
      DIAG(I)= DUMMY1
   ENDDO
!     COMPUTE -H*G USING THE FORMULA GIVEN IN: Nocedal, J. 1980,
!     "Updating quasi-Newton matrices with limited storage",
!     Mathematics of Computation, Vol.24, No.151, pp. 773-782.
!     ---------------------------------------------------------
   CP= POINT
   IF (POINT.EQ.0) CP=M
   W(N+CP)= 1.0D0/YS
   DO I=1,N
      W(I)= -G(I)
   ENDDO
   CP= POINT
   DO I= 1,BOUND
      CP=CP-1
      IF (CP.EQ. -1)CP=M-1
      SQ= DDOT(N,W(ISPT+CP*N+1),1,W,1)
      INMC=N+M+CP+1
      IYCN=IYPT+CP*N
      W(INMC)= W(N+CP+1)*SQ
      CALL DAXPY(N,-W(INMC),W(IYCN+1),1,W,1)
   ENDDO
  
   DO I=1,N
      W(I)=DIAG(I)*W(I)
   ENDDO

   DO I=1,BOUND
      YR= DDOT(N,W(IYPT+CP*N+1),1,W,1)
      BETA= W(N+CP+1)*YR
      INMC=N+M+CP+1
      BETA= W(INMC)-BETA
      ISCN=ISPT+CP*N
      CALL DAXPY(N,BETA,W(ISCN+1),1,W,1)
      CP=CP+1
      IF (CP.EQ.M) CP=0
   ENDDO
   STP=1.0D0
ENDIF
!  Store the new search direction
IF (ITER.GT.0) THEN
   DO I=1,N
      W(ISPT+POINT*N+I)= W(I)
   ENDDO
ENDIF

!     OVERLAP=DDOT(N,G,1,W,1)/SQRT(DDOT(N,G,1,G,1)*DDOT(N,W,1,W,1))
DOT1=SQRT(DDOT(N,G,1,G,1))
DOT2=SQRT(DDOT(N,W,1,W,1))
OVERLAP=0.0D0
IF (DOT1*DOT2.NE.0.0D0) OVERLAP=DDOT(N,G,1,W,1)/(DOT1*DOT2)

!     PRINT*,'OVERLAP,DIAG(1)=',OVERLAP,DIAG(1)
!     PRINT*,'G . G=',DDOT(N,G,1,G,1)
!     PRINT*,'W . W=',DDOT(N,W,1,W,1)
IF (OVERLAP.GT.0.0D0) THEN
   IF (PTEST) WRITE(MYUNIT,'(A)') 'Search direction has positive projection onto gradient - reversing step'
!        IF (PTEST)  WRITE(MYUNIT,'(A)') 'Search direction has positive projection onto gradient - reset'
   DO I=1,N
      W(ISPT+POINT*N+I)= -W(I)
   ENDDO
!        ITER=0
!        GOTO 10
ENDIF

DO I=1,N
   W(I)=G(I)
ENDDO
SLENGTH=0.0D0
DO J1=1,N
   SLENGTH=SLENGTH+W(ISPT+POINT*N+J1)**2
ENDDO
SLENGTH=SQRT(SLENGTH)
IF (STP*SLENGTH.GT.MAXMBFGS) STP=MAXMBFGS/SLENGTH
!  We now have the proposed step.
DO J1=1,N
   X(J1)=X(J1)+STP*W(ISPT+POINT*N+J1)
ENDDO 
NDECREASE=0
20 CALL SFUNC(X,ENEW,GDUM,.FALSE.,COORDS,NATOMS,APARAM)

IF (ENEW-ENERGY.LE.1.0D-5) THEN
   ITER=ITER+1
   ITDONE=ITDONE+1
   ENERGY=ENEW
ELSE 
!  Energy increased - try again with a smaller step size
!        IF (STP*SLENGTH.LT.1.0D-10) THEN
   IF (NDECREASE.GT.5) THEN
      NFAIL=NFAIL+1
      WRITE(MYUNIT,'(A, G20.10)') ' in smylbfgs LBFGS step cannot find a lower distance, NFAIL=',NFAIL
      ITER=0  !  try resetting
      IF (NFAIL.GT.20) THEN
         WRITE(MYUNIT,'(A)') ' Too many failures - give up'
         RETURN
      ENDIF
      DO J1=1,N
         X(J1)=X(J1)-STP*W(ISPT+POINT*N+J1)
      ENDDO 
      GOTO 30
   ENDIF
   DO J1=1,N
      X(J1)=X(J1)-0.9*STP*W(ISPT+POINT*N+J1)
   ENDDO 
   NDECREASE=NDECREASE+1
   STP=STP/10.0D0
   IF (PTEST) &
     &    WRITE(MYUNIT,'(A,F19.10,A,F16.10,A,F15.8)') ' func increased from ',ENERGY,' to ',ENEW, &
     &      ' decreasing step to ',STP*SLENGTH
   GOTO 20
ENDIF

CALL SFUNC(X,ENERGY,GSAVE,.TRUE.,COORDS,NATOMS,APARAM)
RMS=SQRT((GSAVE(1)**2+GSAVE(2)**2+GSAVE(3)**2)/3)
DO J1=1,N
   G(J1)=GSAVE(J1)
ENDDO
IF (PTEST) WRITE(MYUNIT,'(A,2F20.10,A,I6,A,G15.5)') ' func and RMS force=',ENERGY,RMS,' after ',ITDONE, &
     &        ' LBFGS steps, step:',STP*SLENGTH
!     Compute the new step and gradient change
30    NPT=POINT*N
DO I=1,N
   W(ISPT+NPT+I)= STP*W(ISPT+NPT+I)
   W(IYPT+NPT+I)= G(I)-W(I)
ENDDO
POINT=POINT+1
IF (POINT.EQ.M) POINT=0
GOTO 10

RETURN
END SUBROUTINE SMYLBFGS

SUBROUTINE SFUNC(X,ENERGY,GRAD,GFLAG,COORDS,NATOMS,APARAM)
IMPLICIT NONE
INTEGER :: NATOMS, J1, J2
LOGICAL :: GFLAG
DOUBLE PRECISION :: X(3), GRAD(3), COORDS(*), ENERGY, R2(NATOMS), MU2(NATOMS), DENOM, NUMER
DOUBLE PRECISION :: APARAM, DUM1(3), DUM2(3), DUMMY

DO J1=1,NATOMS
   R2(J1)=(COORDS(3*(J1-1)+1)-X(1))**2+(COORDS(3*(J1-1)+2)-X(2))**2+(COORDS(3*(J1-1)+3)-X(3))**2
ENDDO

ENERGY=0.0D0
GRAD(1:3)=0.0D0
DO J1=1,NATOMS
   IF (GFLAG) THEN
      DUM1(1:3)=0.0D0
      DUM2(1:3)=0.0D0
   ENDIF
   NUMER=0.0D0
   DENOM=0.0D0
   DO J2=1,NATOMS
      DUMMY=EXP(-APARAM*(R2(J1)-R2(J2))**2)
      NUMER=NUMER+R2(J2)*DUMMY
      DENOM=DENOM+DUMMY
      IF (GFLAG) THEN
         DUM1(1:3)=DUM1(1:3)+DUMMY*(2*(COORDS(3*(J2-1)+1:3*(J2-1)+3)-X(1:3)) &
 &                         -4*APARAM*R2(J2)*(R2(J1)-R2(J2))*  &
 &                        (COORDS(3*(J1-1)+1:3*(J1-1)+3)-COORDS(3*(J2-1)+1:3*(J2-1)+3)))
         DUM2(1:3)=DUM2(1:3)+DUMMY*(R2(J1)-R2(J2))* &
 &                (COORDS(3*(J1-1)+1:3*(J1-1)+3)-COORDS(3*(J2-1)+1:3*(J2-1)+3))
      ENDIF
   ENDDO
   MU2(J1)=NUMER/DENOM
   ENERGY=ENERGY+(R2(J1)-MU2(J1))**2
   IF (GFLAG) GRAD(1:3)=GRAD(1:3)+2*(R2(J1)-MU2(J1))*(-2*(COORDS(3*(J1-1)+1:3*(J1-1)+3)-X(1:3)) &
             +DUM1(1:3)/DENOM +4*APARAM*NUMER*DUM2(1:3)/DENOM**2 )/NATOMS
!  PRINT'(A,I6,6F12.4)','J1,O,R2,MU2=',J1,X(1:3),R2(J1),MU2(J1)
ENDDO
ENERGY=ENERGY/NATOMS

RETURN
END SUBROUTINE SFUNC

!
! Reflect points in a plane. 
! Reverse the component along the normal vector VEC
! Assumes the plane goes through the origin.
!
SUBROUTINE NEWREFLECT(XIN,XOUT,NATOMS,EV,IPLANE)
IMPLICIT NONE
INTEGER NATOMS, IPLANE, J1
DOUBLE PRECISION XIN(3*NATOMS), XOUT(3*NATOMS), EV(3,3), DOTPROD

DO J1=1,NATOMS
   DOTPROD=XIN(3*(J1-1)+1)*EV(1,IPLANE)+XIN(3*(J1-1)+2)*EV(2,IPLANE)+XIN(3*(J1-1)+3)*EV(3,IPLANE)
   XOUT(3*(J1-1)+1)=XIN(3*(J1-1)+1)-2.0D0*DOTPROD*EV(1,IPLANE)
   XOUT(3*(J1-1)+2)=XIN(3*(J1-1)+2)-2.0D0*DOTPROD*EV(2,IPLANE)
   XOUT(3*(J1-1)+3)=XIN(3*(J1-1)+3)-2.0D0*DOTPROD*EV(3,IPLANE)
ENDDO

END SUBROUTINE NEWREFLECT

! permutations for holes/floaters for mirror plane
RECURSIVE SUBROUTINE CHOOSE(NCHOICE,NATOMS,NFLOAT,NFLOATER,NHOLE,DONEPERM)
IMPLICIT NONE
INTEGER NATOMS
INTEGER NCHOICE(NATOMS), NHOLE, NFLOATER, NFLOAT
LOGICAL DONEPERM

NCHOICE(NFLOATER)=NCHOICE(NFLOATER)+1
IF (NCHOICE(NFLOATER).GT.NHOLE-(NFLOAT/2-NFLOATER)) THEN
   IF (NFLOATER.EQ.1) THEN
      DONEPERM=.TRUE.
   ELSE
      CALL CHOOSE(NCHOICE,NATOMS,NFLOAT,NFLOATER-1,NHOLE,DONEPERM)
      NCHOICE(NFLOATER)=NCHOICE(NFLOATER-1)+1
   ENDIF
ENDIF

END SUBROUTINE CHOOSE

! permutations for holes/floaters for symmetry axis
RECURSIVE SUBROUTINE CHOOSE2(NCHOICE,NATOMS,NFLOAT,NTHISHOLE,NHOLE,DONEPERM)
IMPLICIT NONE
INTEGER NATOMS
INTEGER NCHOICE(NATOMS), NHOLE, NTHISHOLE, NFLOAT
LOGICAL DONEPERM

NCHOICE(NTHISHOLE)=NCHOICE(NTHISHOLE)+1
IF (NCHOICE(NTHISHOLE).GT.ABS(NFLOAT-NHOLE)+NTHISHOLE) THEN
   IF (NTHISHOLE.EQ.1) THEN
      DONEPERM=.TRUE.
   ELSE
      CALL CHOOSE2(NCHOICE,NATOMS,NFLOAT,NTHISHOLE-1,NHOLE,DONEPERM)
      NCHOICE(NTHISHOLE)=NCHOICE(NTHISHOLE-1)+1
   ENDIF
ENDIF

END SUBROUTINE CHOOSE2
!
!  Sorts vector of nuclear coordinates 
!
SUBROUTINE NEWSORTXYZ(XIN,XSORT,NATOMS,TOL)
IMPLICIT NONE
INTEGER, INTENT(IN) :: NATOMS
DOUBLE PRECISION, INTENT(IN) ::  XIN(3*NATOMS)
DOUBLE PRECISION :: XTEMP(3*NATOMS), TOL
DOUBLE PRECISION, INTENT(OUT) :: XSORT(3*NATOMS)
INTEGER I, J, JK
!
!  Sort on the X - if two X's are equivalent, sort on Y and so on.
!  If the coordinate < the tolerance we should ignore it! However,
!  if the tolerance is sloppy that can lead to the sorting ignoring
!  genuine small differences between coordinates. Sigh. 
!
XTEMP(1:3*NATOMS)=XIN(1:3*NATOMS)
JK=1
40    J=1
DO I=1,3*NATOMS-2,3
   IF (XTEMP(I)-XTEMP(J).GT.TOL) J=I
   IF (DABS(XTEMP(I)-XTEMP(J)).LT.TOL) THEN
      IF (XTEMP(I+1)-XTEMP(J+1).GT.TOL) J=I
      IF (DABS(XTEMP(I+1)-XTEMP(J+1)).LT.TOL) THEN
         IF (XTEMP(I+2)-XTEMP(J+2).GT.TOL) J=I
      ENDIF
   ENDIF
ENDDO
DO I=0,2
   XSORT(3*JK-2+I)=XTEMP(J+I)
   XTEMP(J)=-99999.D0
ENDDO
JK=JK+1
IF (JK.EQ.NATOMS+1) GOTO 70
GOTO 40
70    CONTINUE

RETURN
END SUBROUTINE NEWSORTXYZ

