!  GMIN: A program for finding global minima
!  Copyright (C) 1999-2006 David J. Wales
!  This file is part of GMIN.
!
!  GMIN is free software; you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation; either version 2 of the License, or
!  (at your option) any later version.
!
!  GMIN is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with this program; if not, write to the Free Software
!  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
! Objective - to symmetrise a set of input coordinates.
!
SUBROUTINE SYMMETRY(JP,SCREENC,QDONE,BRUN,ITERATIONS,TIME,CHANGEDE,NSYMCALL, &
  &         LNQUENCH,NSUCCESS,NFAIL,EBEST,BESTCOORDS,JBEST,EPPREV)

USE COMMONS
USE porfuncs
IMPLICIT NONE
DOUBLE PRECISION :: LCOORDS(3*NATOMS), CMDIST(NATOMS), ORBDIST(NATOMS), T0, DPRAND, SR3, RANDOM
DOUBLE PRECISION :: LEBEST, QBEST(3*NATOMS), NEWQ(3*NATOMS), VATBEST(NATOMS)
DOUBLE PRECISION :: CMX(2), CMY(2), CMZ(2), CM(3), CMSAVE(3), COREVT(NATOMS), OTHERVT(NATOMS), VATTMP(NATOMS,NPAR)
DOUBLE PRECISION :: DUMMY, XMASS, YMASS, ZMASS, VATORIG(NATOMS), QBSAVE(3*NATOMS), VBSAVE(NATOMS)
DOUBLE PRECISION :: ORIGIN(3), MINDIST, VMIN, VMAX, TEMPVT(NATOMS)
DOUBLE PRECISION :: TIME, TRANSCOORDS(3*NATOMS), LTOLD, EBEST(NPAR), BESTCOORDS(3*NATOMS,NPAR), EPPREV(NPAR)
INTEGER :: J1, J2, NDUMMY, I, NORBIT, J, ISTART, LARGESIZE, NEWORB, J4, ISTAT, MYUNIT2, MYUNIT3, LNQUENCH
INTEGER :: J3, JP, NATOMSCORE, NORBITSCORE, NTOTAL, NMOVE, MOVEINDEX(NATOMS), LOOPLIMIT, QBCORE
INTEGER :: NFLOAT, NLOST, LASTORBIT, FIRSTLOST, NCOREREAL, NSUCCESS(NPAR), NFAIL(NPAR), JBEST(NPAR)
INTEGER :: NINDEX(NATOMS), ORBSIZE(NATOMS), NEWORBSIZE(NATOMS), NSYMOP
DOUBLE PRECISION :: SCOORDS(3*NATOMS), CLOSEOP(3,3)
! DOUBLE PRECISION :: ORBSORT(3*NATOMS), LCOORDSSORTED(3*NATOMS), RCOORDSSORTED(3*NATOMS)
DOUBLE PRECISION :: CORECOORDS(3*NATOMS), OTHERCOORDS(3*NATOMS), TMPCOORDS(3), NEWORBCOORDS(NATOMS,3*120)
DOUBLE PRECISION :: ORBCOORDS(3*NATOMS), DENOM, WORSTRAD
LOGICAL :: SYMLOST(120), CHANGE, NEW, MOVEDTOCORE(NATOMS), MATCHED, CHANGEDE, WEAKESTONLY, NEWOP, FAILED, QBORDERED, QBCHANGED
LOGICAL :: RESTRICT, LDUMMY, MOVETOCORE, USECLOSESUBGROUP, CHANGECLOSE, DOMISSING, LDEBUG, LOSTORBIT
DOUBLE PRECISION :: POTEL, SCREENC(3*NATOMS), GENMAT(100,3,3), GENMATSAVE(100,3,3), SYMOP(120,3,3), LOSTOP(120,3,3)
DOUBLE PRECISION :: NEWMAT(3,3), SYMOP1(3,3), SYMOP2(3,3), DIST2, SUBOP(120,3,3), DUMMYE, DUMMYGRAD(3*NATOMS), X(3*NATOMS)
INTEGER :: GENPERM(100,NATOMS), OPPERM(120,NATOMS)
INTEGER :: NQTOT, QDONE, BRUN, ITERATIONS, NCHOICE(NATOMS), NQTOTSAVE, IGEN, IGENSAVE, ORBSYM, NORDER, NCHOOSE
INTEGER :: ICOMP, IPRNT, LASTLOST, PERM(NATOMS), NTOPSUM, NTOP, NTRIES, NSUB, NCORENEW, NEWCOREINDEX(NATOMS), NCORETMP, NMISS
INTEGER :: NMISSING(NATOMS), NSYMCALL, NMINREM, NPOSS, LNCORE
INTEGER, ALLOCATABLE :: OCCS(:,:)
DOUBLE PRECISION :: QMISSING(NATOMS,3*120) ! number of orbits <= number of atoms
CHARACTER(LEN=4) FPGRP, POINTGROUP
CHARACTER(LEN=6) JPSTRING
DOUBLE PRECISION LHESS(3,3), SERROR, WORK(3), AMAT(3,3), SERROR2
INTEGER IPIVOT(3), INFO, PERM2(NATOMS)
DOUBLE PRECISION, PARAMETER :: EPS=1.0D-10
COMMON /MYPOT/ POTEL
COMMON /TOT/ NQTOT
LOGICAL EVAP, EVAPREJECT
COMMON /EV/ EVAP, EVAPREJECT

SAVE NORBIT, LASTORBIT, NORDER

MYUNIT2=NPAR+MYUNIT
MYUNIT3=2*NPAR+MYUNIT+1
WRITE(JPSTRING,'(I6)') JP
IPRNT=0
LDEBUG=DEBUG
! LDEBUG=.TRUE.
NSYMCALL=NSYMCALL+1   ! NSYMCALL should be the number of consecutive calls to symmetry with this minimum
! PRINT '(A,5I)','NSYMCALL,NORDER,NORBIT,LASTORBIT,NORBIT-LASTORBIT+1=',NSYMCALL,NORDER,NORBIT,LASTORBIT,NORBIT-LASTORBIT+1
IF (NSYMCALL.GT.1) THEN
!  IF (NSYMCALL.GT.NORBIT-LASTORBIT+1) THEN
   IF (NSYMCALL.GT.1) THEN
!     IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A)') 'maximum calls to symmetry ',NORBIT-LASTORBIT,' exceeded for this minimum'
      IF (LDEBUG) WRITE(MYUNIT, '(A)') 'maximum consecutive calls to symmetry reached for this minimum'
      RETURN 
   ENDIF
ENDIF
NSYMREM=0
MOVETOCORE=.TRUE. 	! move complete orbits to core
IF (.NOT.MOVETOCORE) PRINT '(A)','WARNING - MOVETOCORE is FALSE'
WEAKESTONLY=.TRUE. 	! move weakest atom only to floaters (otherwise use ASTEP criterion)
RESTRICT=.FALSE.   	! move weakest atoms to floater list only if they are invariant to CLOSEOP
USECLOSESUBGROUP=.FALSE.	! randomly use the subgroup generated by CLOSEOP 
CHANGECLOSE=.FALSE.  	! randomly change the closest lost operation to that of a different orbit
DOMISSING=.TRUE.     	! identify missing positions from complete orbits when symmetry elements are lost
IF (NSYMCALL.GT.1) DOMISSING=.FALSE. ! no point in repeating!
CHANGEDE=.FALSE.
IF (LDEBUG) IPRNT=11
CALL MYCPU_TIME(T0)
LEBEST=EPREV(JP)
QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
NQTOTSAVE=NQTOT
LCOORDS(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
VATORIG(1:NATOMS)=VAT(1:NATOMS,JP)
QBORDERED=.FALSE.
QBCHANGED=.FALSE.
QBCORE=0

LTOLD=SYMTOL2
IF (DEBUG) WRITE(MYUNIT,'(A)') 'symmetry> atomic masses:'
IF (DEBUG) WRITE(MYUNIT,'(6G20.10)') (ATMASS(J),J=1,NATOMS)

ORIGIN(1:3)=0.0D0
LOOPLIMIT=NATOMS
IF (NCORE(JP).GT.10) THEN
   IF (NPAR.GT.1) THEN
      WRITE(MYUNIT,'(A,I1,A,I6,A)') '[',JP,']symmetry> initialising origin for ',NCORE(JP),' atoms'
   ELSE
      WRITE(MYUNIT,'(A,I6,A)') 'symmetry> initialising origin for ',NCORE(JP),' atoms'
   ENDIF
   LOOPLIMIT=NCORE(JP)
   DO I=NATOMS-NCORE(JP)+1,NATOMS
      ORIGIN(1)=ORIGIN(1)+LCOORDS(3*(I-1)+1)*ATMASS(I)
      ORIGIN(2)=ORIGIN(2)+LCOORDS(3*(I-1)+2)*ATMASS(I)
      ORIGIN(3)=ORIGIN(3)+LCOORDS(3*(I-1)+3)*ATMASS(I)
   ENDDO
   ORIGIN(1:3)=ORIGIN(1:3)/LOOPLIMIT
ENDIF
NCORE(JP)=0 ! will be reset later - this is the default

cmloop: DO J1=1,200
   XMASS=0.0D0; YMASS=0.0D0; ZMASS=0.0D0
   DENOM=0.0D0
   DO I=NATOMS-LOOPLIMIT+1,NATOMS
      IF (J1.GT.1) THEN
!
! LOOPLIMIT is usually NATOMS, so I runs from 1 to NATOMS.
! DISTFAC is the last parameter on the SYMMETRISE line. Default is zero.
!
         DUMMY=EXP(-DISTFAC*CMDIST(I))
      ELSE
         DUMMY=1.0D0
      ENDIF
      XMASS=XMASS+LCOORDS(3*(I-1)+1)*DUMMY*ATMASS(I)
      YMASS=YMASS+LCOORDS(3*(I-1)+2)*DUMMY*ATMASS(I)
      ZMASS=ZMASS+LCOORDS(3*(I-1)+3)*DUMMY*ATMASS(I)
      DENOM=DENOM+DUMMY*ATMASS(I)
   ENDDO
   DUMMY=SQRT( (ORIGIN(1)-XMASS/DENOM)**2+(ORIGIN(2)-YMASS/DENOM)**2+(ORIGIN(3)-ZMASS/DENOM)**2)
   ORIGIN(1)=XMASS/DENOM;  ORIGIN(2)=YMASS/DENOM; ORIGIN(3)=ZMASS/DENOM
!
! The whole CMDIST vector is needed below
! We are now mass-weighting CMDIST
!
   DO J=1,NATOMS 
      CMDIST(J)=SQRT((LCOORDS(3*(J-1)+1)-ORIGIN(1))**2+ &
                     (LCOORDS(3*(J-1)+2)-ORIGIN(2))**2+ &
                     (LCOORDS(3*(J-1)+3)-ORIGIN(3))**2)*ATMASS(J)
   ENDDO
   IF (LDEBUG) WRITE(MYUNIT, '(A,I5,3G20.10)') 'cycle, origin:',J1,ORIGIN(1:3)
   IF ((J1.GT.1).AND.(DUMMY.LT.1.0D-4)) EXIT cmloop 
ENDDO cmloop

DO J=1,NATOMS
   NINDEX(J)=J
ENDDO

IF (LDEBUG) WRITE(MYUNIT, '(A,3F15.5)') 'initial centre of mass: ',ORIGIN(1:3)
SCOORDS(1:3*NATOMS)=LCOORDS(1:3*NATOMS)
CALL PIKSR2(NATOMS,CMDIST,NINDEX) ! sorts CMDIST and NINDEX
! WRITE(MYUNIT,'(A)') 'symmetry> CMDIST and NINDEX:'
! WRITE(MYUNIT,'(F15.5,I8)') (CMDIST(J1),NINDEX(J1),J1=1,NATOMS)
! CALL GETORBITS(NORBIT,ORBDIST,CMDIST,NATOMS,ORBSIZE,SYMTOL1,LARGESIZE,NINDEX,LCOORDS,LDEBUG)
! Find the largest gap between CM distances and use the centre-of-mass of all the atoms up to that point
CMX(1)=0.0D0; CMY(1)=0.0D0; CMZ(1)=0.0D0
CMX(2)=LCOORDS(3*(NINDEX(1)-1)+1)*ATMASS(NINDEX(1))
CMY(2)=LCOORDS(3*(NINDEX(1)-1)+2)*ATMASS(NINDEX(1))
CMZ(2)=LCOORDS(3*(NINDEX(1)-1)+3)*ATMASS(NINDEX(1)) 
! Store sum of centres of mass from previous largest gap to current in CMX(2).
GMAX=-1.0D0
DO J=2,NATOMS
   IF (ABS(CMDIST(J)-CMDIST(J-1)).GT.GMAX) THEN
      GMAX=ABS(CMDIST(J)-CMDIST(J-1))
      NDUMMY=J-1
      CMX(1)=CMX(1)+CMX(2); CMY(1)=CMY(1)+CMY(2); CMZ(1)=CMZ(1)+CMZ(2)
      CMX(2)=LCOORDS(3*(NINDEX(J)-1)+1)*ATMASS(NINDEX(J)) 
      CMY(2)=LCOORDS(3*(NINDEX(J)-1)+2)*ATMASS(NINDEX(J))
      CMZ(2)=LCOORDS(3*(NINDEX(J)-1)+3)*ATMASS(NINDEX(J))
   ELSE
      CMX(2)=CMX(2)+LCOORDS(3*(NINDEX(J)-1)+1)*ATMASS(NINDEX(J)) 
      CMY(2)=CMY(2)+LCOORDS(3*(NINDEX(J)-1)+2)*ATMASS(NINDEX(J)) 
      CMZ(2)=CMZ(2)+LCOORDS(3*(NINDEX(J)-1)+3)*ATMASS(NINDEX(J))
   ENDIF
!  PRINT '(A,I5,2G20.10)','J,diff,GMAX=',J,ABS(CMDIST(J)-CMDIST(J-1)),GMAX
ENDDO
CMX(1)=CMX(1)/(ATMASS(NINDEX(NDUMMY+1))*NDUMMY)
CMY(1)=CMY(1)/(ATMASS(NINDEX(NDUMMY+1))*NDUMMY)
CMZ(1)=CMZ(1)/(ATMASS(NINDEX(NDUMMY+1))*NDUMMY)


! IF (LDEBUG) PRINT '(A,3F15.5)','origin will be moved to centre of mass for first orbit: ',CMX(1),CMY(1),CMZ(1)
! IF (LDEBUG) PRINT '(A,I6,A,F15.5,A)','orbit size: ',ORBSIZE(1),' distance ',ORBDIST(1),' members:'
IF (LDEBUG) WRITE(MYUNIT, '(A,3F15.5)') 'origin will be moved to centre of mass for atoms up to biggest gap: ',CMX(1),CMY(1),CMZ(1)
IF (LDEBUG) WRITE(MYUNIT, '(A,F20.10)') 'biggest gap: ',GMAX
IF (LDEBUG) WRITE(MYUNIT, '(A,I6,A,F15.5,A)') 'number of atoms=',NDUMMY
ORBSIZE(1)=NDUMMY
  IF (LDEBUG) WRITE(MYUNIT,'(A,I6)') 'orbit size: ',ORBSIZE(1)
IF (LDEBUG) WRITE(MYUNIT, '(12I5)')  (NINDEX(J1),J1=1,ORBSIZE(1))
ORIGIN(1)=CMX(1)
ORIGIN(2)=CMY(1)
ORIGIN(3)=CMZ(1)
DO J=1,NATOMS
   NINDEX(J)=J
   LCOORDS(3*(J-1)+1)=LCOORDS(3*(J-1)+1)-ORIGIN(1)
   LCOORDS(3*(J-1)+2)=LCOORDS(3*(J-1)+2)-ORIGIN(2)
   LCOORDS(3*(J-1)+3)=LCOORDS(3*(J-1)+3)-ORIGIN(3)
   CMDIST(J)=SQRT(LCOORDS(3*(J-1)+1)**2+LCOORDS(3*(J-1)+2)**2+LCOORDS(3*(J-1)+3)**2)*ATMASS(J)
ENDDO
CALL PIKSR2(NATOMS,CMDIST,NINDEX) ! sorts CMDIST and NINDEX again
! WRITE(MYUNIT,'(A)') 'symmetry> CMDIST and NINDEX again:'
! WRITE(MYUNIT,'(F15.5,I8)') (CMDIST(J1),NINDEX(J1),J1=1,NATOMS)
CALL GETORBITS(NORBIT,ORBDIST,CMDIST,NATOMS,ORBSIZE,SYMTOL1,LARGESIZE,NINDEX,LCOORDS,LDEBUG)
IF (LDEBUG) THEN
   ISTART=1
   OPEN(UNIT=MYUNIT2,FILE='orbits.'//TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NORBIT
      WRITE(MYUNIT2,'(I5)') SUM(ORBSIZE(1:J1))
      WRITE(MYUNIT2,'(A)') ' '
      DO J2=ISTART,ISTART+ORBSIZE(J1)-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LA',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      DO J2=1,ISTART-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LB',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      ISTART=ISTART+ORBSIZE(J1)
   ENDDO
   CLOSE(MYUNIT2)
ENDIF

IF (LARGESIZE.EQ.1) THEN
   IF (LDEBUG) THEN
      CALL MYCPU_TIME(TIME)
      WRITE(MYUNIT, '(A,F15.2)') 'symmetry> No nontrivial orbits - return from symmetry, time taken=',TIME-T0
   ENDIF
   VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
   COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS) 
   RETURN
ENDIF

! Examine how the point group changes as we include more orbits.
 
ISTART=1
NATOMSCORE=0
NORBITSCORE=0
IGENSAVE=0
LNCORE=0
symcore: DO J1=1,NORBIT
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      CORECOORDS(3*(J2-1)+1:3*(J2-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
   ENDDO
   ISTART=ISTART+ORBSIZE(J1)
   NATOMSCORE=NATOMSCORE+ORBSIZE(J1)
   NORBITSCORE=NORBITSCORE+1
   SCOORDS(1:3*NATOMSCORE)=CORECOORDS(1:3*NATOMSCORE) 
   IF (NATOMSCORE.GT.3) THEN
      DUMMY=MATDIFF
      CALL PTGRP(SCOORDS,NATOMSCORE,LDEBUG,SYMTOL1,SYMTOL2,SYMTOL3,GENMAT,IGEN,FPGRP,CM,DUMMY) ! SCOORDS is changed!
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,I5,A,I4,A,A4)') 'number of orbits=',NORBITSCORE,' number of atoms=',NATOMSCORE, &
                          ' number of generators=',IGEN,' point group= ',FPGRP
      IF (IGEN.GT.0) THEN ! save last set of generators for which IGEN>1.
         ORBSYM=J1
         CMSAVE(1:3)=CM(1:3)
         LNCORE=NATOMSCORE
         IGENSAVE=IGEN
         POINTGROUP=FPGRP
         GENMATSAVE(1:IGEN,1:3,1:3)=GENMAT(1:IGEN,1:3,1:3)
         EXIT symcore
      ENDIF
   ELSE
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,I5)') 'number of orbits=',NORBITSCORE,' number of atoms=',NATOMSCORE
   ENDIF
   IF (NATOMSCORE.GT.20) EXIT symcore ! looks like there is simply no symmetry
ENDDO symcore

IF (IGENSAVE.LE.0) THEN
   IF (LDEBUG) WRITE(MYUNIT, '(A)') 'no symmetry detected'
   VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
   COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS) 
   RETURN
ELSE
   IF (LNCORE.EQ.NATOMS) THEN
      VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
      COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS) 
      RETURN
   ENDIF
   IF (NPAR.GT.1) THEN
      WRITE(MYUNIT, '(A,I1,3A,I4)') '[',JP,']symmetry> symmetry analysis for point group ',TRIM(ADJUSTL(POINTGROUP)), &
     &          ' number of generators=',IGENSAVE
   ELSE
      WRITE(MYUNIT, '(3A,I4)') 'symmetry> symmetry analysis for point group ',TRIM(ADJUSTL(POINTGROUP)), &
     &          ' number of generators=',IGENSAVE
   ENDIF
!  PRINT '(A,I5,A,I5,A)','this group was detected for the first ',ORBSYM,' orbits containing ',LNCORE,' atoms'
ENDIF

! Move the CORECOORDS centre of mass to the origin.

DO J1=1,NATOMS
   LCOORDS(3*(J1-1)+1)=LCOORDS(3*(J1-1)+1)-CMSAVE(1)
   LCOORDS(3*(J1-1)+2)=LCOORDS(3*(J1-1)+2)-CMSAVE(2)
   LCOORDS(3*(J1-1)+3)=LCOORDS(3*(J1-1)+3)-CMSAVE(3)
ENDDO
DO J1=1,LNCORE
   CORECOORDS(3*(J1-1)+1)=CORECOORDS(3*(J1-1)+1)-CMSAVE(1)
   CORECOORDS(3*(J1-1)+2)=CORECOORDS(3*(J1-1)+2)-CMSAVE(2)
   CORECOORDS(3*(J1-1)+3)=CORECOORDS(3*(J1-1)+3)-CMSAVE(3)
ENDDO

! Generate all the point group operations.

SYMOP(1,1,1)=1.0D0; SYMOP(1,1,2)=0.0D0; SYMOP(1,1,3)=0.0D0 ! identity
SYMOP(1,2,1)=0.0D0; SYMOP(1,2,2)=1.0D0; SYMOP(1,2,3)=0.0D0
SYMOP(1,3,1)=0.0D0; SYMOP(1,3,2)=0.0D0; SYMOP(1,3,3)=1.0D0
NORDER=1
DO J1=1,NATOMS
   GENPERM(1,J1)=J1
   OPPERM(1,J1)=J1
ENDDO
! 
! Refine the IGENSAVE symmetry operations for the LNCORE atoms in
! CORECOORDS using a Newton-Raphson step. This really increases
! the accuracy of the point group operations. We could also refine
! the further operations produced from the generators, but it does
! not seem necessary.
!
LHESS(1:3,1:3)=0.0D0
DO J1=1,LNCORE
   LHESS(1,1)=LHESS(1,1)+CORECOORDS(3*(J1-1)+1)**2+EPS ! EPS is designed to avoid singularities
   LHESS(1,2)=LHESS(1,2)+CORECOORDS(3*(J1-1)+1)*CORECOORDS(3*(J1-1)+2)+EPS
   LHESS(1,3)=LHESS(1,3)+CORECOORDS(3*(J1-1)+1)*CORECOORDS(3*(J1-1)+3)+EPS
   LHESS(2,2)=LHESS(2,2)+CORECOORDS(3*(J1-1)+2)**2+EPS
   LHESS(2,3)=LHESS(2,3)+CORECOORDS(3*(J1-1)+2)*CORECOORDS(3*(J1-1)+3)+EPS
   LHESS(3,3)=LHESS(3,3)+CORECOORDS(3*(J1-1)+3)**2+EPS
ENDDO
LHESS(2,1)=LHESS(1,2); LHESS(3,1)=LHESS(1,3); LHESS(3,2)=LHESS(2,3) ! symmetrise hessian
! invert LHESS
CALL DGETRF(3,3,LHESS,3,IPIVOT,INFO) ! LHESS is modified!
CALL DGETRI(3,LHESS,3,IPIVOT,WORK,3,INFO)
IF (INFO.NE.0) THEN
   WRITE(MYUNIT,'(A,I6)') 'ERROR - INFO after DGETRI in symmetry=',INFO
   WRITE(MYUNIT,'(A)') 'CORECOORDS:'
   WRITE(MYUNIT,'(3F20.10)') CORECOORDS(1:3*LNCORE)
   WRITE(MYUNIT,'(A)') 'LHESS'
   WRITE(MYUNIT,'(3F20.10)') LHESS
   STOP
ENDIF 

genloop: DO J1=1,IGENSAVE
!  SYMOP(1+J1,1:3,1:3)=GENMATSAVE(J1,1:3,1:3)
   SYMOP1(1:3,1:3)=GENMATSAVE(J1,1:3,1:3)
   IF (LDEBUG) WRITE(MYUNIT, '(A,I5,9F10.4)') 'NORDER,initial MAT: ',NORDER,GENMATSAVE(J1,1:3,1:3)
   CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,LNCORE,3,3)
!  CALL MINPERM(LNCORE,NEWQ,CORECOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
   CALL TESTSYMOP(LNCORE,NEWQ,CORECOORDS,PERM,LTOLD,DIST2,WORSTRAD)
   IF (DIST2.GT.LTOLD) THEN
      WRITE(MYUNIT, '(A,2G20.10)') 'ERROR - genloop in symmetry, DIST2,LTOLD=',DIST2,LTOLD
      cycle genloop
   ENDIF
!  CALL BIPARTITE(LNCORE,NEWQ,CORECOORDS,PERM,DUMMY,DIST2,WORSTRAD)
!  PRINT '(A,6F15.5)','dists: ',DUMMY,DIST2,WORSTRAD,BDUMMY,BDIST2,BWORSTRAD
   IF (LDEBUG) THEN
      SERROR=0.0D0
      DO J2=1,LNCORE
         SERROR=SERROR+(CORECOORDS(3*(PERM(J2)-1)+1)-NEWQ(3*(J2-1)+1))**2+ &
 &                     (CORECOORDS(3*(PERM(J2)-1)+2)-NEWQ(3*(J2-1)+2))**2+ &
 &                     (CORECOORDS(3*(PERM(J2)-1)+3)-NEWQ(3*(J2-1)+3))**2
      ENDDO
      WRITE(MYUNIT, '(A,I5,G20.10)') 'operation,     error=',J1,SERROR
      IF (SERROR.GT.0.5D0) STOP
   ENDIF
!
!  Check for independent generators by comparing the integers in GENPERM
!
   DO J2=1,NORDER
      NEWOP=.FALSE.
      newoploop: DO J3=1,LNCORE
         IF (PERM(J3).NE.GENPERM(J2,J3)) THEN
            NEWOP=.TRUE.
            EXIT newoploop
         ENDIF
      ENDDO newoploop
      IF (.NOT.NEWOP) THEN
         IF (LDEBUG) WRITE(MYUNIT, '(2(A,I6))') 'generator ',J1,' appears to be the same as ',J2
         CYCLE genloop
      ENDIF
   ENDDO
!
!  Generator purification seems to be helpful.
!
   AMAT(1:3,1:3)=0.0D0
   DO J2=1,LNCORE
      AMAT(1,1)=AMAT(1,1)+CORECOORDS(3*(PERM(J2)-1)+1)*CORECOORDS(3*(J2-1)+1)
      AMAT(1,2)=AMAT(1,2)+CORECOORDS(3*(PERM(J2)-1)+1)*CORECOORDS(3*(J2-1)+2)
      AMAT(1,3)=AMAT(1,3)+CORECOORDS(3*(PERM(J2)-1)+1)*CORECOORDS(3*(J2-1)+3)
      AMAT(2,1)=AMAT(2,1)+CORECOORDS(3*(PERM(J2)-1)+2)*CORECOORDS(3*(J2-1)+1)
      AMAT(2,2)=AMAT(2,2)+CORECOORDS(3*(PERM(J2)-1)+2)*CORECOORDS(3*(J2-1)+2)
      AMAT(2,3)=AMAT(2,3)+CORECOORDS(3*(PERM(J2)-1)+2)*CORECOORDS(3*(J2-1)+3)
      AMAT(3,1)=AMAT(3,1)+CORECOORDS(3*(PERM(J2)-1)+3)*CORECOORDS(3*(J2-1)+1)
      AMAT(3,2)=AMAT(3,2)+CORECOORDS(3*(PERM(J2)-1)+3)*CORECOORDS(3*(J2-1)+2)
      AMAT(3,3)=AMAT(3,3)+CORECOORDS(3*(PERM(J2)-1)+3)*CORECOORDS(3*(J2-1)+3)
   ENDDO
   SYMOP1(1,1)=AMAT(1,1)*LHESS(1,1)+AMAT(1,2)*LHESS(2,1)+AMAT(1,3)*LHESS(3,1)
   SYMOP1(2,1)=AMAT(1,1)*LHESS(1,2)+AMAT(1,2)*LHESS(2,2)+AMAT(1,3)*LHESS(3,2)
   SYMOP1(3,1)=AMAT(1,1)*LHESS(1,3)+AMAT(1,2)*LHESS(2,3)+AMAT(1,3)*LHESS(3,3)
   SYMOP1(1,2)=AMAT(2,1)*LHESS(1,1)+AMAT(2,2)*LHESS(2,1)+AMAT(2,3)*LHESS(3,1)
   SYMOP1(2,2)=AMAT(2,1)*LHESS(1,2)+AMAT(2,2)*LHESS(2,2)+AMAT(2,3)*LHESS(3,2)
   SYMOP1(3,2)=AMAT(2,1)*LHESS(1,3)+AMAT(2,2)*LHESS(2,3)+AMAT(2,3)*LHESS(3,3)
   SYMOP1(1,3)=AMAT(3,1)*LHESS(1,1)+AMAT(3,2)*LHESS(2,1)+AMAT(3,3)*LHESS(3,1)
   SYMOP1(2,3)=AMAT(3,1)*LHESS(1,2)+AMAT(3,2)*LHESS(2,2)+AMAT(3,3)*LHESS(3,2)
   SYMOP1(3,3)=AMAT(3,1)*LHESS(1,3)+AMAT(3,2)*LHESS(2,3)+AMAT(3,3)*LHESS(3,3)
   IF (LDEBUG) THEN
!
!  Just assume it is the same permutation.
!
       CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,LNCORE,3,3)
!!     CALL MINPERM(LNCORE,NEWQ,CORECOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM2,DUMMY,DIST2,WORSTRAD)
!      CALL TESTSYMOP(LNCORE,NEWQ,CORECOORDS,PERM2,LTOLD,DIST2,WORSTRAD)
!!     CALL BIPARTITE(LNCORE,NEWQ,CORECOORDS,PERM2,DUMMY,DIST2,WORSTRAD)
!      IF (DIST2.GT.1.0D2) THEN
!         SERROR2=1.0D3
!         WRITE(MYUNIT,'(A,2G20.10)') 'testsymop> ERROR - SERROR,SERROR2=',SERROR,SERROR2
!         STOP
!      ELSE
         SERROR2=0.0D0
         PERM2(1:LNCORE)=PERM(1:LNCORE)
         DO J2=1,LNCORE
!           WRITE(MYUNIT,*) 'J2,PERM2=',J2,PERM2(J2)
!           IF (PERM2(J2).LT.1) THEN
!              WRITE(MYUNIT,*) 'ERROR, PERM2 < 1'
!              STOP
!           ENDIF
            SERROR2=SERROR2+(CORECOORDS(3*(PERM2(J2)-1)+1)-NEWQ(3*(J2-1)+1))**2+ &
 &                          (CORECOORDS(3*(PERM2(J2)-1)+2)-NEWQ(3*(J2-1)+2))**2+ &
 &                          (CORECOORDS(3*(PERM2(J2)-1)+3)-NEWQ(3*(J2-1)+3))**2
         ENDDO
         WRITE(MYUNIT, '(A,I5,G20.10)') 'operation, new error=',J1,SERROR2
         IF (SERROR2.GT.SERROR) WRITE(MYUNIT, '(A)') ' WARNING - error has increased - this should never happen'
!      ENDIF
   ENDIF
   NORDER=NORDER+1
   SYMOP(NORDER,1:3,1:3)=SYMOP1(1:3,1:3)
   GENPERM(NORDER,1:LNCORE)=PERM(1:LNCORE)
   OPPERM(NORDER,1:LNCORE)=PERM(1:LNCORE)
   IF (LDEBUG) WRITE(MYUNIT, '(A,I5,9F10.4)') 'NORDER,MAT: ',NORDER,SYMOP(NORDER,1:3,1:3)
   IF (LDEBUG) WRITE(MYUNIT, '(20I6)') PERM(1:LNCORE)
ENDDO genloop
!
! End refinement of generators.
! We could "purify" the combination operations generated in the next loop,
! but it does not seem necessary.
!
makegroup: DO 
   op1: DO J1=2,NORDER
      SYMOP1(1:3,1:3)=SYMOP(J1,1:3,1:3)
      op2: DO J2=2,NORDER
         SYMOP2(1:3,1:3)=SYMOP(J2,1:3,1:3)
         CALL MATMUL(NEWMAT,SYMOP1,SYMOP2,3,3,3,3,3,3)
         DO J3=1,NORDER
            CALL CMPMAT(SYMOP,120,J3,NEWMAT,NEW,MATDIFF)
            IF (.NOT.NEW) CYCLE op2
         ENDDO
!!
!!  Check for independent generators by comparing the integers in GENPERM
!!
!         DO J3=1,LNCORE
!            PERM(J3)=OPPERM(J2,OPPERM(J1,J3))
!         ENDDO
!         DO J3=1,NORDER
!            NEWOP=.FALSE.
!            newoploop2: DO J4=1,LNCORE
!               IF (PERM(J4).NE.OPPERM(J3,J4)) THEN
!                  NEWOP=.TRUE.
!                  EXIT newoploop2
!               ENDIF
!            ENDDO newoploop2
!            IF (.NOT.NEWOP) THEN
!!              IF (LDEBUG) PRINT '(A,I6)','operation appears to be the same as ',J3
!               CYCLE op2
!            ENDIF
!         ENDDO

         NORDER=NORDER+1
         IF (NORDER.GT.120) THEN
            WRITE(MYUNIT, '(A)') 'WARNING more than 120 operations case A!'
!           STOP
            NORDER=120
            EXIT makegroup
         ELSE
            SYMOP(NORDER,1:3,1:3)=NEWMAT(1:3,1:3)
            OPPERM(NORDER,1:LNCORE)=PERM(1:LNCORE)
            CYCLE makegroup
         ENDIF
      ENDDO op2
   ENDDO op1
   EXIT makegroup
ENDDO makegroup

CALL MYCPU_TIME(TIME)
IF (NPAR.GT.1) THEN
   WRITE(MYUNIT, '(A,I1,A,I5,A,F15.2)') '[',JP,']symmetry> using point group of order ', &
  &                   NORDER,' constructed from generators, time taken=',TIME-T0
ELSE
   WRITE(MYUNIT, '(A,I5,A,F15.2)') 'symmetry> using point group of order ', &
  &                   NORDER,' constructed from generators, time taken=',TIME-T0
ENDIF
IF (LDEBUG) THEN
   DO J1=1,NORDER
      WRITE(MYUNIT, '(A,I5,9F10.4)') 'J1,SYMOP: ',J1,SYMOP(J1,1:3,1:3)
   ENDDO
ENDIF
! test to check that we really have symmetry operations!
IF (LDEBUG) THEN
   OPEN(UNIT=MYUNIT2,FILE='testsym2.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NORDER
      SYMOP1(1:3,1:3)=SYMOP(J1,1:3,1:3)
      CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,LNCORE,3,3)
!     CALL MINPERM(LNCORE,NEWQ,CORECOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
      CALL TESTSYMOP(LNCORE,NEWQ,CORECOORDS,PERM,LTOLD,DIST2,WORSTRAD)
!     CALL BIPARTITE(LNCORE,NEWQ,CORECOORDS,PERM,DUMMY,DIST2,WORSTRAD)
      WRITE(MYUNIT2,'(I5)') LNCORE
!     CALL MATMULV(NEWQ,LCOORDS,SYMOP1,NATOMS,3,3)
!     CALL MINPERM(NATOMS,NEWQ,LCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
!     CALL BIPARTITE(NATOMS,NEWQ,LCOORDS,PERM,DUMMY,DIST2,WORSTRAD)
!     WRITE(MYUNIT2,'(I5)') NATOMS
      WRITE(MYUNIT2,'(A,I5,2(A,F15.5))') 'operation ',J1,' dist=',DUMMY,' dist2=',DIST2
      WRITE(MYUNIT2,'(A2,2X,3G20.10)') ('LA',NEWQ(3*(J2-1)+1),NEWQ(3*(J2-1)+2),NEWQ(3*(J2-1)+3),J2=1,LNCORE)
   ENDDO
   CLOSE(MYUNIT2)
ENDIF

! Test for preservation of symmetry operations when more orbits are added.
! CORECOORDS and LCOORDS were both rotated above to the principal axis orientation.

SYMLOST(1:NORDER)=.FALSE.
ISTART=LNCORE+1
NTOTAL=LNCORE
NSYMOP=NORDER
LASTLOST=0
FIRSTLOST=NORBIT
LOSTORBIT=.FALSE.
MINDIST=1.0D100
NMISSING(1:NORBIT)=0
symother: DO J1=NORBITSCORE+1,NORBIT
   NLOST=0
   CHANGE=.FALSE.
   NTOTAL=NTOTAL+ORBSIZE(J1)
   IF (LDEBUG) WRITE(MYUNIT, '(4(A,I5))') 'testing symmetry for orbit ',J1,' of ',ORBSIZE(J1),' atoms, running total=',NTOTAL, &
                            ' symmetry elements remaining=',NSYMOP

   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      ORBCOORDS(3*(J2-ISTART)+1:3*(J2-ISTART)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
   ENDDO
   IF (LDEBUG)  OPEN(UNIT=MYUNIT2,FILE='temp.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   IF (LDEBUG)  WRITE(MYUNIT2,'(I5)') LNCORE+ORBSIZE(J1)
   IF (LDEBUG)  WRITE(MYUNIT2,*) ' '
   IF (LDEBUG)  WRITE(MYUNIT2,'(A2,2X,3G20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,LNCORE)
   IF (LDEBUG)  WRITE(MYUNIT2,'(A2,2X,3G20.10)') ('LB',ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,ORBSIZE(J1))
   IF (LDEBUG)  CLOSE(MYUNIT2)
   ISTART=ISTART+ORBSIZE(J1)
   IF (LDEBUG)  OPEN(UNIT=MYUNIT3,FILE='temp2.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J3=2,NORDER ! cycle over point group operations
      IF (.NOT.SYMLOST(J3)) THEN
         DO J2=1,ORBSIZE(J1)
            TRANSCOORDS(3*(J2-1)+1)=SUM(SYMOP(J3,1,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+2)=SUM(SYMOP(J3,2,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+3)=SUM(SYMOP(J3,3,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
         ENDDO
!        CALL MINPERM(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
         CALL TESTSYMOP(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,PERM,LTOLD,DIST2,WORSTRAD)
!        CALL BIPARTITE(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,PERM,DUMMY,DIST2,WORSTRAD)

!        CALL SORTXYZ(ORBCOORDS,ORBSORT,NORD,SYMTOL4,ORBSIZE(J1))
!        CALL COMPARE2(TRANSCOORDS,ORBSORT,NORD,ICOMP,SYMTOL4,ORBSIZE(J1),IPRNT)
!        IF (ICOMP.NE.0) THEN

         IF (DIST2/WORSTRAD.GT.SYMTOL4) THEN
!        IF (DIST2.GT.SYMTOL4) THEN
            SYMLOST(J3)=.TRUE.
            IF (FIRSTLOST.EQ.NORBIT) FIRSTLOST=J1
            LASTORBIT=J1-1
            IF (LDEBUG.AND.(.NOT.DOMISSING)) WRITE(MYUNIT, '(A,I5,A,2F15.5)') 'symmetry element ',J3,' lost, DUMMY,DIST2=', &
  &                              DUMMY,DIST2
            NSYMOP=NSYMOP-1
            NLOST=NLOST+1
            LOSTOP(NLOST,1:3,1:3)=SYMOP(J3,1:3,1:3)
!
!  Only call the more expensive MINPERM to calculate the distance DUMMY if the operation
!  is known to be lost from calling the cheaper TESTSYMOP.
!
            CALL MINPERM(ORBSIZE(J1),ORBCOORDS,TRANSCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
            IF (DUMMY.LT.MINDIST) THEN
               MINDIST=DUMMY
               CLOSEOP(1:3,1:3)=SYMOP(J3,1:3,1:3)
            ENDIF
            CHANGE=.TRUE.
            IF (LDEBUG) THEN
               WRITE(MYUNIT3,'(I5)') 2*ORBSIZE(J1)+SUM(ORBSIZE(1:J1-1))
               WRITE(MYUNIT3,'(A,I5,2F15.5)') 'operation,DUMMY,dist2=',J3,DUMMY,DIST2
               WRITE(MYUNIT3,'(A2,2X,3G20.10)') ('LA',TRANSCOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,ORBSIZE(J1))
               WRITE(MYUNIT3,'(A2,2X,3G20.10)') ('LB',ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,ORBSIZE(J1))
               DO J2=1,ISTART-ORBSIZE(J1)-1
                  WRITE(MYUNIT3,'(A2,2X,3G20.10)') 'LB',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
               ENDDO
            ENDIF
            IF (DOMISSING) THEN
               transloop: DO J2=1,ORBSIZE(J1) ! cycle over transformed coordinates
                  DO J4=1,ORBSIZE(J1) ! cycle over untransformed coordinates
                     DUMMY=SQRT((ORBCOORDS(3*(J4-1)+1)-TRANSCOORDS(3*(J2-1)+1))**2+ &
                                (ORBCOORDS(3*(J4-1)+2)-TRANSCOORDS(3*(J2-1)+2))**2+ &
                                (ORBCOORDS(3*(J4-1)+3)-TRANSCOORDS(3*(J2-1)+3))**2)
                     IF (DUMMY.LT.SYMTOL5) CYCLE transloop
                  ENDDO
                  DO J4=1,NMISSING(J1) ! cycle over known missing sites to avoid duplicates
                     DUMMY=SQRT((QMISSING(J1,3*(J4-1)+1)-TRANSCOORDS(3*(J2-1)+1))**2+ &
                                (QMISSING(J1,3*(J4-1)+2)-TRANSCOORDS(3*(J2-1)+2))**2+ &
                                (QMISSING(J1,3*(J4-1)+3)-TRANSCOORDS(3*(J2-1)+3))**2)
                     IF (DUMMY.LT.SYMTOL5) CYCLE transloop
                  ENDDO
                  IF (NMISSING(J1).EQ.120) THEN
                     WRITE(MYUNIT, '(A)') 'warning - too many missing sites'
                     EXIT transloop
                  ENDIF
                  NMISSING(J1)=NMISSING(J1)+1
                  QMISSING(J1,3*(NMISSING(J1)-1)+1:3*(NMISSING(J1)-1)+3)=TRANSCOORDS(3*(J2-1)+1:3*(J2-1)+3)
                  IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,I5,A,3F15.5)') 'orbit ',J1,' missing site ',NMISSING(J1), &
                              ' coords: ',TRANSCOORDS(3*(J2-1)+1:3*(J2-1)+3)
               ENDDO transloop
               IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,2F15.5,A,I5)') 'symmetry element ',J3,' lost, dists=',DUMMY,DIST2, &
                                                       ' missing sites=',NMISSING(J1)
               IF ((.NOT.LOSTORBIT).AND.(NMISSING(J1).EQ.0)) THEN
                  SYMLOST(J3)=.FALSE.
                  CHANGE=.FALSE.
                  NSYMOP=NSYMOP+1
                  NLOST=NLOST-1
                  LASTLOST=0
                  FIRSTLOST=NORBIT
                  IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,2F15.5,A,I5)') 'symmetry element ',J3,' NOT lost in terms of missing sites'
               ELSE 
                  LOSTORBIT=.TRUE.
               ENDIF
            ELSE
               LOSTORBIT=.TRUE.
            ENDIF
         ELSE
            IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A)') 'symmetry element ',J3,' retained'
         ENDIF
      ENDIF
   ENDDO
   IF (LDEBUG)  CLOSE(MYUNIT3)
   IF (CHANGE) LASTLOST=NLOST
   IF (NSYMOP.EQ.1) THEN
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5)') 'only the identity element remains for orbit ',J1
      EXIT symother
   ENDIF
ENDDO symother

IF (NSYMOP.GT.1) THEN ! the full structure still has some symmetry
   DO J3=2,NORDER ! cycle over remaining point group operations - the identity is not counted
      IF (.NOT.SYMLOST(J3)) THEN
         NSYMREM=NSYMREM+1
         SYMREM(NSYMREM,1:3,1:3)=SYMOP(J3,1:3,1:3)
      ENDIF
   ENDDO
ENDIF

NCOREREAL=0
DO J1=1,FIRSTLOST-1
   NCOREREAL=NCOREREAL+ORBSIZE(J1)
ENDDO

!
! If core symmetry is consistent with the whole system then
! NCORE is set to zero. NSYMREM contains all the symmetry operations
! (except the identity) and the KEEPSYM subroutine will be called 
! in TAKESTEP.
!
IF (LASTLOST.EQ.0) THEN
   WRITE(MYUNIT, '(2(A,I5))') 'symmetry> symmetry of core is consistent with the overall symmetry'
   VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
   COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS)
   RETURN
ELSE
   IF (LDEBUG) WRITE(MYUNIT, '(A,I8,A,I8,A)') 'symmetry> first orbit to break core symmetry is number ',FIRSTLOST, &
  &          ' real core contains ',NCOREREAL,' atoms'
   IF (NPAR.GT.1) THEN
      WRITE(MYUNIT, '(A,I1,2(A,I5))') '[',JP,']symmetry> number of symmetry elements lost in last change for orbit ', &
  &                    LASTORBIT+1,' was ',LASTLOST
   ELSE
      WRITE(MYUNIT, '(2(A,I5))') 'symmetry> number of symmetry elements lost in last change for orbit ', &
  &                    LASTORBIT+1,' was ',LASTLOST
   ENDIF
ENDIF

IF (LDEBUG) THEN
   ISTART=1
   OPEN(UNIT=MYUNIT2,FILE='orbits2.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NORBIT
      WRITE(MYUNIT2,'(I5)') SUM(ORBSIZE(1:J1))+NMISSING(J1)
      WRITE(MYUNIT2,'(A)') ' '
      DO J2=ISTART,ISTART+ORBSIZE(J1)-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LA',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      DO J2=1,ISTART-1
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LB',LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      ENDDO
      DO J2=1,NMISSING(J1)
         WRITE(MYUNIT2,'(A2,2X,3G20.10)') 'LC',QMISSING(J1,3*(J2-1)+1:3*(J2-1)+3)
      ENDDO
      ISTART=ISTART+ORBSIZE(J1)
   ENDDO
   CLOSE(MYUNIT2)
ENDIF

! Move coordinates into CORE and OTHER vectors. Define LNCORE, the number of core atoms.
! CORECOORDS and LNCORE are expanded to include all the atoms in orbits that are invariant
! under all the operations of the previously defined core.
! LASTORBIT is the last orbit to conserve all the symmetry operations of the core.

ISTART=1
DO J1=1,LASTORBIT
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      CORECOORDS(3*(J2-1)+1:3*(J2-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      COREVT(J2)=VATORIG(NINDEX(J2)) ! must use VATORIG because VAT changes if quench is called in DOMISSING
   ENDDO
   ISTART=ISTART+ORBSIZE(J1)
ENDDO
LNCORE=ISTART-1
DO J1=LASTORBIT+1,NORBIT
   DO J2=ISTART,ISTART+ORBSIZE(J1)-1
      OTHERCOORDS(3*(J2-LNCORE-1)+1:3*(J2-LNCORE-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
      OTHERVT(J2-LNCORE)=VATORIG(NINDEX(J2)) ! must use VATORIG because VAT changes if quench is called in DOMISSING
   ENDDO
   ISTART=ISTART+ORBSIZE(J1)
ENDDO

!
! Orbits with one or two missing sites (as identified above) are filled in using
! the most weakly bound atoms from the set outside the core. This proposed structure
! is quenched.
!
IF (DOMISSING) THEN
   missopt: DO J1=1,NORBIT
      IF (NMISSING(J1).EQ.0) CYCLE missopt ! DO NOT DELETE!!
      IF (NMISSING(J1).GT.2) CYCLE missopt 

      NDUMMY=0
      DO J2=1,NATOMS-LNCORE
         NDUMMY=NDUMMY+1
         COORDS(3*(NDUMMY-1)+1:3*(NDUMMY-1)+3,JP)=OTHERCOORDS(3*(J2-1)+1:3*(J2-1)+3)
         VATTMP(NDUMMY,JP)=OTHERVT(J2)
      ENDDO
      IF (NDUMMY.NE.NATOMS-LNCORE) THEN
         WRITE(MYUNIT,'(A,2I8)') 'symmetry> ERROR - NDUMMY,LNCORE=',NDUMMY,LNCORE
         STOP
      ENDIF
      COORDS(3*(NATOMS-NCOREREAL)+1:3*NATOMS,JP)=CORECOORDS(1:3*NCOREREAL)
      COORDS(3*(NATOMS-LNCORE)+1:3*(NATOMS-NCOREREAL),JP)=CORECOORDS(3*NCOREREAL+1:3*LNCORE)
      VATTMP(NATOMS-NCOREREAL+1:NATOMS,JP)=-1.0D100 ! put core atoms at the end so they aren't changed
      VATTMP(NATOMS-LNCORE+1:NATOMS-NCOREREAL,JP)=COREVT(NCOREREAL+1:LNCORE)

!  OPEN(MYUNIT2,FILE='junk.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
!  WRITE(MYUNIT2,*) NATOMS
!  WRITE(MYUNIT2,'(A,I8)') 'coords should be core+other,NCOREREAL=',NCOREREAL
!  WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',COORDS(3*(J2-1)+1:3*(J2-1)+3,JP),J2=NATOMS-NCOREREAL+1,NATOMS)
!  WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LB',COORDS(3*(J2-1)+1:3*(J2-1)+3,JP),J2=1,NATOMS-NCOREREAL)
!  CLOSE(MYUNIT2)

      CALL SORT3(NATOMS,NATOMS,VATTMP(1:NATOMS,JP),COORDS(1:3*NATOMS,JP)) ! sort the atoms

      NMISS=0
!     DO J2=1,J1
      DO J2=J1,J1
         missloop: DO J3=1,NMISSING(J2)
            DO J4=NMISS+1,NATOMS
               DUMMY=SQRT((COORDS(3*(J4-1)+1,JP)-QMISSING(J2,3*(J3-1)+1))**2+ &
                          (COORDS(3*(J4-1)+2,JP)-QMISSING(J2,3*(J3-1)+2))**2+ &
                          (COORDS(3*(J4-1)+3,JP)-QMISSING(J2,3*(J3-1)+3))**2)
               IF (DUMMY.LT.SYMTOL5) THEN
                  IF (LDEBUG) WRITE(MYUNIT, '(3(A,I5))') 'symmetry> missing site ',J3,' from orbit ',J2,' is too close to atom ',J4
                  CYCLE missloop
               ENDIF
            ENDDO
            NMISS=NMISS+1
            COORDS(3*(NMISS-1)+1:3*(NMISS-1)+3,JP)=QMISSING(J2,3*(J3-1)+1:3*(J3-1)+3)
         ENDDO missloop
      ENDDO
!     IF (NMISS.GT.12) EXIT missopt
      IF (NMISS.EQ.0) CYCLE missopt
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A)') 'symmetry> filling ',NMISS,' missing sites'
      
      NQTOT=NQTOT+1
      NQ(JP)=NQ(JP)+1
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      IF (NPAR.GT.1) THEN
         WRITE(MYUNIT,'(A,I1,A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') &
  &                     '[',JP,']Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
      ELSE
         WRITE(MYUNIT,'(A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') &
  &                     'Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
      ENDIF
! Save the best structure
      IF (HIT) THEN
         EPREV(JP)=POTEL
         RETURN
      ENDIF
      IF (LEBEST-POTEL.GT.ECONV) THEN
         LEBEST=POTEL
         QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
         VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
         QBORDERED=.TRUE.
         QBCHANGED=.TRUE.
         QBCORE=NCOREREAL
!        WRITE(MYUNIT,'(A,2L5,I6)') 'symmetry> Z QBORDERED,QBCHANGED,QBCORE=',QBORDERED,QBCHANGED,QBCORE
         NSYMREM=0
         EXIT missopt
      ENDIF
      IF (NQTOT-NQTOTSAVE.GE.NSYMQMAX) EXIT missopt
   ENDDO missopt
ENDIF

! IF (CHANGECLOSE.AND.NSYMCALL.GT.1) ! this version for a limited number of calls to symmetry with
                                     ! systematic changes in CLOSEOP
IF (CHANGECLOSE.AND.(DPRAND().GT.0.5D0)) THEN ! change CLOSEOP to the closest lost operation for orbit NCHOOSE
!  NCHOOSE=NORBIT-NSYMCALL+2 
   MINDIST=1.0D100
   DUMMY=DPRAND()
   NCHOOSE=INT(DUMMY*(NORBIT-LASTORBIT+1))+LASTORBIT
   WRITE(MYUNIT, '(A,I5)') 'changing CLOSEOP to the closest lost operation for orbit ',NCHOOSE
   NDUMMY=SUM(ORBSIZE(1:NCHOOSE-1))
   DO J2=NDUMMY+1,NDUMMY+ORBSIZE(NCHOOSE)
      ORBCOORDS(3*(J2-NDUMMY-1)+1:3*(J2-NDUMMY-1)+3)=LCOORDS(3*(NINDEX(J2)-1)+1:3*(NINDEX(J2)-1)+3)
   ENDDO
   DO J3=2,NORDER ! cycle over point group operations
      IF (SYMLOST(J3)) THEN
         DO J2=1,ORBSIZE(NCHOOSE)
            TRANSCOORDS(3*(J2-1)+1)=SUM(SYMOP(J3,1,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+2)=SUM(SYMOP(J3,2,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
            TRANSCOORDS(3*(J2-1)+3)=SUM(SYMOP(J3,3,1:3)*ORBCOORDS(3*(J2-1)+1:3*(J2-1)+3))
         ENDDO
!
!  Must use MINPERM here because TESTSYMOP doesn't calculate DUMMY
!
         CALL MINPERM(ORBSIZE(NCHOOSE),ORBCOORDS,TRANSCOORDS,BOXLX,BOXLY,BOXLZ,PERIODIC,PERM,DUMMY,DIST2,WORSTRAD)
!        CALL TESTSYMOP(ORBSIZE(NCHOOSE),ORBCOORDS,TRANSCOORDS,PERM,LTOLD,DIST2,WORSTRAD)
!        CALL BIPARTITE(ORBSIZE(NCHOOSE),ORBCOORDS,TRANSCOORDS,PERM,DUMMY,DIST2,WORSTRAD)
         IF (DUMMY.LT.MINDIST) THEN
            MINDIST=DUMMY
            CLOSEOP(1:3,1:3)=SYMOP(J3,1:3,1:3)
         ENDIF
      ENDIF
   ENDDO
ENDIF

! IF (CHANGECLOSE.AND.NSYMCALL.GT.1) THEN ! change CLOSEOP to SYMOP NSYMCALL
!    CLOSEOP(1:3,1:3)=SYMOP(NSYMCALL,1:3,1:3)
! ENDIF

IF (NSYMOP.GT.1) THEN ! the full structure still has some symmetry
   IF (DPRAND().GT.0.0D0) THEN ! add remaining symmetry elements to the LASTLOST set to complete that subgroup
      DO J3=2,NORDER ! cycle over remaining point group operations - the identity is not needed
         IF (.NOT.SYMLOST(J3)) THEN
            LASTLOST=LASTLOST+1
            LOSTOP(LASTLOST,1:3,1:3)=SYMOP(J3,1:3,1:3)
         ENDIF
      ENDDO
      WRITE(MYUNIT, '(3(A,I5))') 'symmetry> after adding the remaining ',NSYMOP-1,' non-identity elements there are ', &
  &                              LASTLOST,' in total'
   ELSE ! or, with 0% probability, just use the full symmetry. In this case we will only permute single weakly bound atoms.
      LASTLOST=0
      DO J3=2,NORDER ! cycle over remaining point group operations - the identity is not needed
         IF (.NOT.SYMLOST(J3)) THEN
            LASTLOST=LASTLOST+1
            LOSTOP(LASTLOST,1:3,1:3)=SYMOP(J3,1:3,1:3)
         ENDIF
      ENDDO
      WRITE(MYUNIT, '(3(A,I5))') 'using the remaining ',NSYMOP-1,' non-identity elements'
   ENDIF
!
! Need this line in case COORDS are not changed so that KEEPSYM works in TAKESTEP
! QBEST may already have been changed in the DOMISSING block, in which case
! NSYMREM will have been set to zero. ?????????????  no idea what this was doing DJW
!
!  IF (NSYMREM.GT.0) THEN
!     QBEST(1:3*NATOMS)=LCOORDS(1:3*NATOMS) 
!     VATBEST(1:NATOMS)=VATORIG(1:NATOMS) 
!     QBORDERED=.FALSE.
!     QBCHANGED=.TRUE.
!     QBCORE=NCORERERAL
!        WRITE(MYUNIT,'(A,2L5)') 'symmetry> B QBORDERED,QBCHANGED=',QBORDERED,QBCHANGED
!     NSURFMOVES(JP)=0
!     SHELLMOVES(JP)=.TRUE.
!     NCORE(JP)=0
!     WRITE(MYUNIT,'(A)') 'symmetry> turning off shell moves'
!  ENDIF
ENDIF


! IF (USECLOSESUBGROUP.AND.((LASTLOST.GT.50).OR.(DPRAND().GT.1.0D0))) THEN ! BAD for LJ38
IF (LASTLOST.GT.50) THEN 
! IF (USECLOSESUBGROUP.AND.(NSYMCALL.GT.1)) THEN ! use for systematic changes to CLOSEOP

! Instead of using all the symmetry operations in LASTLOST to define orbits, try using the subgroup
! generated by CLOSEOP. This should be smaller.

   NSUB=2
   SUBOP(1,1:3,1:3)=SYMOP(1,1:3,1:3)
   SUBOP(2,1:3,1:3)=CLOSEOP(1:3,1:3)
   makesub: DO
      subop1: DO J1=2,NSUB
         SYMOP1(1:3,1:3)=SUBOP(J1,1:3,1:3)
         subop2: DO J2=2,NSUB
            SYMOP2(1:3,1:3)=SUBOP(J2,1:3,1:3)            
            CALL MATMUL(NEWMAT,SYMOP1,SYMOP2,3,3,3,3,3,3)
!           IF (LDEBUG) PRINT '(A,2I5,9F10.4)','J1,J2,NEWMAT: ',J1,J2,NEWMAT
! Identify symmetry element from original group and use this instead.
! The idea is to avoid propagation of numerical errors.
            replaceop: DO J3=1,NORDER
               CALL CMPMAT(SYMOP,120,J3,NEWMAT,NEW,MATDIFF)
               IF (.NOT.NEW) THEN
                  NEWMAT(1:3,1:3)=SYMOP(J3,1:3,1:3)
                  EXIT replaceop
               ENDIF
            ENDDO replaceop
            DO J3=1,NSUB
               CALL CMPMAT(SUBOP,120,J3,NEWMAT,NEW,MATDIFF)
               IF (.NOT.NEW) CYCLE subop2
            ENDDO
            NSUB=NSUB+1
            IF (NSUB.GT.120) THEN
               WRITE(MYUNIT, '(A)') 'WARNING more than 120 operations case B!'
               NSUB=120
!              STOP
               EXIT makesub
            ELSE
               SUBOP(NSUB,1:3,1:3)=NEWMAT(1:3,1:3)
               CYCLE makesub
            ENDIF
         ENDDO subop2
      ENDDO subop1
      EXIT makesub
   ENDDO makesub

   WRITE(MYUNIT, '(A,I5,A)') 'symmetry> using subgroup of order ',NSUB,' constructed from lost operation'
   IF (LDEBUG) THEN
      DO J1=1,NSUB
         WRITE(MYUNIT, '(A,I5,9F10.4)') 'J1,SUBOP: ',J1,SUBOP(J1,1:3,1:3)
      ENDDO
   ENDIF

   LASTLOST=NSUB
   DO J1=1,NSUB
      LOSTOP(J1,1:3,1:3)=SUBOP(J1,1:3,1:3)
   ENDDO
ENDIF

! Core atoms are added to the float list if their pair energy is high enough.
VMIN=1.0D100
VMAX=-1.0D100
DO J1=1,NATOMS
   IF (VAT(J1,JP).LT.VMIN) VMIN=VATORIG(J1)
   IF (VAT(J1,JP).GT.VMAX) VMAX=VATORIG(J1)
ENDDO

! We can either use just the most weakly bound atom, or all those satisfying the ASTEP condition.
! We can also require these atoms to be invariant under CLOSEOP, or not.

NFLOAT=NATOMS-LNCORE

!   DO J2=1,3*NFLOAT
!      X(J2)=OTHERCOORDS(J2)
!   ENDDO
!   DO J2=3*NFLOAT+1,3*(NFLOAT+LNCORE)
!      X(J2)=CORECOORDS(J2-3*NFLOAT)
!   ENDDO
!   CALL POTENTIAL(X,DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)
!   DO J2=1,NFLOAT
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-OTHERVT(J2))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> E J2,OTHERVT,VT(J2)=',J2,OTHERVT(J2),VT(J2)
!            STOP
!         ENDIF
!      ENDIF
!   ENDDO
!   DO J2=NFLOAT+1,NFLOAT+LNCORE
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-COREVT(J2-NFLOAT))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> F J2,COREVT,VT(J2)=',J2,COREVT(J2-NFLOAT),VT(J2)
!            STOP
!         ENDIF
!      ENDIF
!   ENDDO

NMOVE=0
IF (RESTRICT) THEN
   SYMOP1(1:3,1:3)=CLOSEOP(1:3,1:3)
   CALL MATMULV(NEWQ,CORECOORDS,SYMOP1,LNCORE,3,3)
   weak: DO J1=1,LNCORE
!     PRINT '(A,I5,3G20.10)','J1,COREVT,VMIN,ASTEP(JP)*VMIN=',J1,COREVT(J1),VMIN,ASTEP(JP)*VMIN
      IF (WEAKESTONLY) THEN
         LDUMMY=COREVT(J1).GE.VMAX
      ELSE
         LDUMMY=COREVT(J1).GT.ASTEP(JP)*VMIN
      ENDIF
      IF (LDUMMY) THEN
         IF (DEBUG) WRITE(MYUNIT,'(A,I8,2G20.10)') 'symmetry> J1,COREVT,VMAX=',J1,COREVT(J1),VMAX
         IF (RESTRICT) THEN
            DIST2=SQRT((CORECOORDS(3*(J1-1)+1)-NEWQ(3*(J1-1)+1))**2+ &
                       (CORECOORDS(3*(J1-1)+2)-NEWQ(3*(J1-1)+2))**2+ &
                       (CORECOORDS(3*(J1-1)+3)-NEWQ(3*(J1-1)+3))**2)
         ELSE
            DIST2=0.0D0
         ENDIF
!
! Change this to SYMTOL5? DJW 28/9/12. SYMTOL4 is dimensionless!
!
!        IF (DIST2.LE.SYMTOL4) THEN ! atom lies on the symmetry element 
         IF (DIST2.LE.SYMTOL5) THEN ! atom lies on the symmetry element 
            NFLOAT=NFLOAT+1
            OTHERCOORDS(3*(NFLOAT-1)+1:3*(NFLOAT-1)+3)=CORECOORDS(3*(J1-1)+1:3*(J1-1)+3)
            OTHERVT(NFLOAT)=COREVT(J1)
            NMOVE=NMOVE+1
            MOVEINDEX(NMOVE)=J1
            IF (J1.LE.NCOREREAL) NCOREREAL=NCOREREAL-1
            IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,2I5,A,F15.5)') 'weakly bound invariant atom ',J1, &
                             ' added to floater list, LNCORE,NFLOAT=',LNCORE-NMOVE,NFLOAT, &
                             ' pair energy=',COREVT(J1)
            WRITE(MYUNIT,'(A,I5,3F15.5)') 'moved atom coords: ',J1,CORECOORDS(3*(J1-1)+1:3*(J1-1)+3)
            WRITE(MYUNIT,'(A,I5,3F15.5)') 'other atom coords: ',NFLOAT,OTHERCOORDS(3*(NFLOAT-1)+1:3*(NFLOAT-1)+3)
            IF (WEAKESTONLY) EXIT weak ! we know there is only one atom to do
         ENDIF
      ENDIF
   ENDDO weak
ENDIF

DO J1=NMOVE,1,-1
   DO J2=MOVEINDEX(J1),LNCORE-1
      CORECOORDS(3*(J2-1)+1:3*(J2-1)+3)=CORECOORDS(3*J2+1:3*J2+3)
      COREVT(J2)=COREVT(J2+1)
   ENDDO
   LNCORE=LNCORE-1
ENDDO

!   DO J2=1,3*NFLOAT
!      X(J2)=OTHERCOORDS(J2)
!   ENDDO
!   DO J2=3*NFLOAT+1,3*(NFLOAT+LNCORE)
!      X(J2)=CORECOORDS(J2-3*NFLOAT)
!   ENDDO
!   CALL POTENTIAL(X,DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)
!   DO J2=1,NFLOAT
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-OTHERVT(J2))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> C J2,OTHERVT,VT(J2)=',J2,OTHERVT(J2),VT(J2)
!            STOP
!         ENDIF
!      ENDIF
!   ENDDO
!   DO J2=NFLOAT+1,NFLOAT+LNCORE
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-COREVT(J2-NFLOAT))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> D J2,COREVT,VT(J2)=',J2,COREVT(J2-NFLOAT),VT(J2)
!            STOP
!         ENDIF
!      ENDIF
!   ENDDO
!   WRITE(MYUNIT,'(A,I8)') 'symmetry> core coordinates after moving atom to floater list, LNCORE=',LNCORE
!   CALL FLUSH(MYUNIT,ISTAT)
!   WRITE(MYUNIT,'(3F20.10)') CORECOORDS(1:3*LNCORE)


! Apply all the non-identity operators in LASTLOST to each non-core atom to generate
! the corresponding orbit. Remove duplicates as we go along.
! If an atom lies in a previous orbit, skip it.
! New orbits should be guaranteed because we check that atom
! J1 does not lie in any previous NEWORB;s and we know it does not lie in
! any of the SYMORB sites.

NEWORB=0
NCORENEW=0
MOVEDTOCORE(1:NATOMS-LNCORE)=.FALSE.
otherloop: DO J1=1,NATOMS-LNCORE
   IF (MOVEDTOCORE(J1)) CYCLE otherloop
! compare with members of previous orbits
   DO J2=1,NEWORB
      DO J3=1,NEWORBSIZE(J2)
         DUMMY=SQRT((NEWORBCOORDS(J2,3*(J3-1)+1)-OTHERCOORDS(3*(J1-1)+1))**2+ &
                    (NEWORBCOORDS(J2,3*(J3-1)+2)-OTHERCOORDS(3*(J1-1)+2))**2+ &
                    (NEWORBCOORDS(J2,3*(J3-1)+3)-OTHERCOORDS(3*(J1-1)+3))**2)
         IF (DUMMY.LT.SYMTOL5) CYCLE otherloop
      ENDDO
   ENDDO
   NDUMMY=1
   TMPCOORDS(1:3)=OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3)
   NEWORBCOORDS(NEWORB+1,1:3)=TMPCOORDS(1:3)
   applyops: DO J2=1,LASTLOST
      TMPCOORDS(1)=SUM(LOSTOP(J2,1,1:3)*OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3))
      TMPCOORDS(2)=SUM(LOSTOP(J2,2,1:3)*OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3))
      TMPCOORDS(3)=SUM(LOSTOP(J2,3,1:3)*OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3))
      DO J3=1,NDUMMY ! check overlaps with current orbit
         DUMMY=SQRT((TMPCOORDS(1)-NEWORBCOORDS(NEWORB+1,3*(J3-1)+1))**2+ &
                    (TMPCOORDS(2)-NEWORBCOORDS(NEWORB+1,3*(J3-1)+2))**2+ &
                    (TMPCOORDS(3)-NEWORBCOORDS(NEWORB+1,3*(J3-1)+3))**2)
         IF (DUMMY.LT.SYMTOL5) CYCLE applyops
      ENDDO 
      DO J3=1,LNCORE+NCORENEW ! check overlaps with core atoms
         DUMMY=SQRT((TMPCOORDS(1)-CORECOORDS(3*(J3-1)+1))**2+ &
                    (TMPCOORDS(2)-CORECOORDS(3*(J3-1)+2))**2+ &
                    (TMPCOORDS(3)-CORECOORDS(3*(J3-1)+3))**2)
         IF (DUMMY.LT.SYMTOL5) CYCLE applyops
      ENDDO
      DO J4=1,NEWORB ! check overlaps with previous orbits
         DO J3=1,NEWORBSIZE(J4)
            DUMMY=SQRT((NEWORBCOORDS(J4,3*(J3-1)+1)-TMPCOORDS(1))**2+ &
                       (NEWORBCOORDS(J4,3*(J3-1)+2)-TMPCOORDS(2))**2+ &
                       (NEWORBCOORDS(J4,3*(J3-1)+3)-TMPCOORDS(3))**2)
!           IF (DUMMY.LT.SYMTOL5) CYCLE applyops ! works best to give up on this orbit completely
            IF (DUMMY.LT.SYMTOL5) CYCLE otherloop
         ENDDO
      ENDDO
      NDUMMY=NDUMMY+1
      NEWORBCOORDS(NEWORB+1,3*(NDUMMY-1)+1:3*(NDUMMY-1)+3)=TMPCOORDS(1:3)
!     PRINT '(A,I5,A,I5,A,3G20.10)','new orbit ',NEWORB+1,' new site ',NDUMMY,' coords: ',TMPCOORDS(1:3)
   ENDDO applyops
! Test whether this orbit is contained completely within OTHERCOORDS. If it is,
! move these coordinates to the core, but put the atoms before the real core defined
! by the orbit where the symmetry first drops.
   NCORETMP=0
   IF (MOVETOCORE) THEN
      MATCHED=.TRUE.
      neworbcoord: DO J2=1,NDUMMY
         DO J3=1,NATOMS-LNCORE
            IF (.NOT.MOVEDTOCORE(J3)) THEN
               DUMMY=SQRT((OTHERCOORDS(3*(J3-1)+1)-NEWORBCOORDS(NEWORB+1,3*(J2-1)+1))**2+ &
                          (OTHERCOORDS(3*(J3-1)+2)-NEWORBCOORDS(NEWORB+1,3*(J2-1)+2))**2+ &
                          (OTHERCOORDS(3*(J3-1)+3)-NEWORBCOORDS(NEWORB+1,3*(J2-1)+3))**2)
!
! Change this to SYMTOL5? DJW 28/9/12. SYMTOL4 is dimensionless!
!
!              IF (DUMMY.LT.SYMTOL4) THEN
               IF (DUMMY.LT.SYMTOL5) THEN

!  It can happen that two images in NEWORBCOORDS match the same core atom. Don;t move
!  this atom to the core more than once! 

                  DO J4=1,NCORETMP
                     IF (NEWCOREINDEX(J4).EQ.J3) THEN
!                       PRINT '(A,I5,A,I5,A,G20.10)','new orbit atom ',J2,' also matches floater ',J3, &
!                                                    ' DUMMY=',DUMMY
                        CYCLE neworbcoord
                     ENDIF
                  ENDDO

                  NCORETMP=NCORETMP+1
                  CORECOORDS(3*(LNCORE+NCORENEW+NCORETMP-1)+1:3*(LNCORE+NCORENEW+NCORETMP-1)+3)= &
                                OTHERCOORDS(3*(J3-1)+1:3*(J3-1)+3)
                  COREVT(LNCORE+NCORENEW+NCORETMP)=OTHERVT(J3)
                  NEWCOREINDEX(NCORETMP)=J3
!                 PRINT '(A,I5,A,I5,A,G20.10)','new orbit atom ',J2,' matches floater ',J3,' DUMMY=',DUMMY
                  CYCLE neworbcoord
               ENDIF
            ENDIF
         ENDDO
         MATCHED=.FALSE.
         EXIT neworbcoord
      ENDDO neworbcoord
   ENDIF
   IF (MATCHED.AND.(NCORETMP.GT.1)) THEN ! leave single atoms as floaters, otherwise move to core
      NCORENEW=NCORENEW+NCORETMP
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5,A,120I5)') 'moving ',NCORETMP,' atoms to the core: ',NEWCOREINDEX(1:NCORETMP)
      IF (LDEBUG) WRITE(MYUNIT, '(A,I5)') 'number of core atoms=',LNCORE+NCORENEW
      DO J2=1,NCORETMP
         MOVEDTOCORE(NEWCOREINDEX(J2))=.TRUE.
      ENDDO
      CYCLE otherloop
   ENDIF

! Otherwise, store the new orbit.

   NEWORB=NEWORB+1
   NEWORBSIZE(NEWORB)=NDUMMY
   IF (LDEBUG) WRITE(MYUNIT, '(3(A,I6))') 'new orbit ',NEWORB,' of dimension ',NEWORBSIZE(NEWORB), &
                ' generated from floater ',J1
ENDDO otherloop
!
! Now we want to reorder the coordinates in CORE so that the original first NCOREREAL atoms come last
! and then the complete orbits defined for lower symmetry
! come first. Moves are not taken for the last NCOREREAL atoms in takestep.
!
IF (LDEBUG) WRITE(MYUNIT,'(A,3I8)') 'symmetry> reordering core atoms, LNCORE,NCORENEW,NCOREREAL=',LNCORE,NCORENEW,NCOREREAL
IF (LNCORE.LT.NCOREREAL) THEN
   WRITE(MYUNIT,'(A)') 'symmetry> ERROR - LNCORE must be >= NCOREREAL'
   STOP
ENDIF
!OPEN(UNIT=77,FILE='stuff.xyz',STATUS='UNKNOWN')
! WRITE(77,'(I8)') LNCORE+NCORENEW
! WRITE(77,'(A)') 'corecoords before reordering'
! WRITE(77,'(A3,3F20.10)') ('LA ',CORECOORDS(3*(J1-1)+1:3*(J1-1)+3),J1=1,NCOREREAL)
! WRITE(77,'(A3,3F20.10)') ('LB ',CORECOORDS(3*(J1-1)+1:3*(J1-1)+3),J1=NCOREREAL+1,LNCORE)
! WRITE(77,'(A3,3F20.10)') ('LC ',CORECOORDS(3*(J1-1)+1:3*(J1-1)+3),J1=LNCORE+1,LNCORE+NCORENEW)
LNCORE=LNCORE+NCORENEW
SCOORDS(3*(LNCORE-NCOREREAL)+1:3*LNCORE)=CORECOORDS(1:3*NCOREREAL)
TEMPVT(LNCORE-NCOREREAL+1:LNCORE)=COREVT(1:NCOREREAL)
SCOORDS(1:3*(LNCORE-NCOREREAL))=CORECOORDS(3*NCOREREAL+1:3*LNCORE)
TEMPVT(1:LNCORE-NCOREREAL)=COREVT(NCOREREAL+1:LNCORE)
CORECOORDS(1:3*LNCORE)=SCOORDS(1:3*LNCORE)
COREVT(1:LNCORE)=TEMPVT(1:LNCORE)
! WRITE(77,'(I8)') LNCORE
! WRITE(77,'(A)') 'corecoords after reordering'
! WRITE(77,'(A3,3F20.10)') ('LA ',CORECOORDS(3*(J1-1)+1:3*(J1-1)+3),J1=1,LNCORE-NCOREREAL)
! WRITE(77,'(A3,3F20.10)') ('LB ',CORECOORDS(3*(J1-1)+1:3*(J1-1)+3),J1=LNCORE-NCOREREAL+1,LNCORE)
! CLOSE(77)

! If QBEST was already changed above then we should not overwrite it here.
! If QBEST is changed subsequently it will be reconstructed from CORECOORDS and OTHERCOORDS,
! which are ordered correctly.

!        WRITE(MYUNIT,'(A,2L5,I6)') 'symmetry> C QBORDERED,QBCHANGED,QBCORE=',QBORDERED,QBCHANGED,QBCORE
IF (.NOT.QBCHANGED) THEN
   IF (BGUPTAT.OR.GLJT.OR.MLJT) THEN ! check whether the reordering changes the energy!
      QBSAVE(1:3*NATOMS)=QBEST(1:3*NATOMS)
      VBSAVE(1:NATOMS)=VATBEST(1:NATOMS)
   ENDIF
   NDUMMY=0
   DO J1=1,NATOMS-(LNCORE-NCORENEW) ! non-core atoms put in place in QBEST
      IF (.NOT.MOVEDTOCORE(J1)) THEN
         NDUMMY=NDUMMY+1
         QBEST(3*(NDUMMY-1)+1:3*(NDUMMY-1)+3)=OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3)
         VATBEST(NDUMMY)=OTHERVT(J1)
!        IF (NDUMMY.EQ.NATOMS-LNCORE) EXIT
      ENDIF
   ENDDO
   IF (NDUMMY.NE.NATOMS-LNCORE) THEN
      WRITE(MYUNIT,'(A,2I8)') 'symmetry> ERROR - NDUMMY,LNCORE=',NDUMMY,LNCORE
      STOP
   ENDIF
   QBEST(3*(NATOMS-LNCORE)+1:3*NATOMS)=CORECOORDS(1:3*LNCORE) ! core atoms added to QBEST
   VATBEST(NATOMS-LNCORE+1:NATOMS)=COREVT(1:LNCORE)
   QBORDERED=.TRUE.
   QBCHANGED=.FALSE.
   QBCORE=NCOREREAL
   IF (BGUPTAT.OR.GLJT.OR.MLJT) THEN 
      CALL POTENTIAL(QBEST(:),DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)
      IF (ABS(DUMMYE-LEBEST).GT.ECONV) THEN
!        QBORDERED=.FALSE.
!        QBEST(1:3*NATOMS)=QBSAVE(1:3*NATOMS)
!        VATBEST(1:NATOMS)=VBSAVE(1:NATOMS)
         WRITE(MYUNIT,'(A)') 'symmetry> WARNING *** reordering atoms changes the energy'
!
! For inhomogeneous systems, where the ordering of the atoms determines their
! type, we will probably want to run the KL refinement with HOMOREF anyway.
! So allow the reordering, and let HOMOREF then sort out the best homotop below.
!
!        WRITE(MYUNIT,'(A)') 'symmetry> reordering atoms changes the energy - reverting'
!        STOP
      ENDIF
   ENDIF
!  CALL POTENTIAL(QBEST(:),DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)

!   DO J2=1,3*NATOMS
!      X(J2)=QBEST(J2)
!   ENDDO
!   CALL POTENTIAL(X,DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)
!   FAILED=.FALSE.
!   DO J2=1,NATOMS
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-VATBEST(J2))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> A2 J2,VATBEST,VT(J2)=',J2,VATBEST(J2),VT(J2)
!            FAILED=.TRUE.
!         ENDIF
!      ENDIF
!   ENDDO
!   IF (FAILED) THEN
!      WRITE(MYUNIT,'(A,I8)') 'symmetry> core coordinates after reordering, LNCORE=',LNCORE
!      CALL FLUSH(MYUNIT,ISTAT)
!      WRITE(MYUNIT,'(3F20.10)') CORECOORDS(1:3*LNCORE)
!      STOP
!   ENDIF
ENDIF

IF (LDEBUG) THEN
   OPEN(MYUNIT2,FILE='coreplusother.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   WRITE(MYUNIT2,*) NATOMS
   WRITE(MYUNIT2,*) ' '
   WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,LNCORE)
   NDUMMY=0
   DO J1=1,NATOMS
      IF (.NOT.MOVEDTOCORE(J1)) THEN
         WRITE(MYUNIT2,'(A2,3X,3F20.10)') 'LB',OTHERCOORDS(3*(J1-1)+1:3*(J1-1)+3)
         NDUMMY=NDUMMY+1
         IF (NDUMMY.EQ.NATOMS-LNCORE) EXIT
      ENDIF
   ENDDO
   CLOSE(MYUNIT2)

   OPEN(UNIT=MYUNIT2,FILE='neworbits.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   DO J1=1,NEWORB
      WRITE(MYUNIT2,'(I6)') SUM(NEWORBSIZE(1:J1))+LNCORE
!     WRITE(MYUNIT2,'(I6)') NEWORBSIZE(J1)
      WRITE(MYUNIT2,'(A)') ' '
      WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,LNCORE)
      DO J3=1,J1-1
         WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LC',NEWORBCOORDS(J3,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J3))
      ENDDO
!     WRITE(MYUNIT2,'(A2,3X,3F20.10)') (('LB',NEWORBCOORDS(J1,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J1)),J1=1,1)
      WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LB',NEWORBCOORDS(J1,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J1))
   ENDDO
   CLOSE(MYUNIT2)

   OPEN(UNIT=MYUNIT2,FILE='newpluscore.' // TRIM(ADJUSTL(JPSTRING)) // '.xyz',STATUS='UNKNOWN')
   WRITE(MYUNIT2,'(I6)') SUM(NEWORBSIZE(1:NEWORB))+LNCORE
   WRITE(MYUNIT2,'(A)') ' '
   WRITE(MYUNIT2,'(A2,3X,3F20.10)') ('LA',CORECOORDS(3*(J2-1)+1:3*(J2-1)+3),J2=1,LNCORE)
   WRITE(MYUNIT2,'(A2,3X,3F20.10)') (('LB',NEWORBCOORDS(J1,3*(J2-1)+1:3*(J2-1)+3),J2=1,NEWORBSIZE(J1)),J1=1,NEWORB)
   CLOSE(MYUNIT2)
ENDIF
IF (LNCORE.EQ.NATOMS) THEN
   VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
   COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS)
   IF (QBORDERED) NCORE(JP)=QBCORE
   RETURN
ENDIF

! We want to try to make complete orbits and fill them up. Try all possibilities 
! for precisely filled orbits as starting points for quenches. Each orbit is either
! occupied completely or not, and we need to enumerate the possibilities.
!
! Now fill in the NEWORB orbits with the NATOMS-LNCORE=NFLOAT candidates. 
! Only quench candidate geometries where orbits are completely filled.
! Each orbit can either be filled or empty, giving 2^NEWORB possibilities,
! but most will probably be disallowed because the occupation won;t match NFLOAT.

NFLOAT=NATOMS-LNCORE
ALLOCATE(OCCS(NSYMQMAX,NEWORB))
IF (NSYMQMAX.GT.0) CALL ENUMERATE(NFLOAT,NEWORB,NEWORBSIZE,NSYMQMAX,OCCS,NPOSS,LDEBUG)

IF (NPOSS.EQ.0) WRITE(MYUNIT,'(A,I8)') 'symmetry> no possibilities with complete orbits filled, number in core=',LNCORE

IF (.TRUE.) THEN

   perms2: DO NTRIES=1,MIN(NSYMQMAX,NPOSS) ! NPOSS is the number of permutations saved
      NCHOICE(1:NEWORB)=OCCS(NTRIES,1:NEWORB)
      NDUMMY=0
      DO J1=1,NEWORB
         NDUMMY=NDUMMY+NCHOICE(J1)*NEWORBSIZE(J1)
      ENDDO
      IF (NDUMMY.NE.NFLOAT) THEN
         WRITE(MYUNIT, '(A,2I5,A)') 'ERROR - NDUMMY,NFLOAT=',NDUMMY,NFLOAT,' in symmetry'
         STOP
      ENDIF
      IF (LDEBUG) WRITE(MYUNIT, '(A)') 'NCHOICE:'
      IF (LDEBUG) WRITE(MYUNIT, '(60I2)') NCHOICE(1:NEWORB)
      IF (LDEBUG) WRITE(MYUNIT, '(A,2I5)') 'NDUMMY,NFLOAT=',NDUMMY,NFLOAT
!     COORDS(1:3*LNCORE,JP)=CORECOORDS(1:3*LNCORE)
      COORDS(3*(NATOMS-LNCORE)+1:3*NATOMS,JP)=CORECOORDS(1:3*LNCORE)
!     NDUMMY=LNCORE
      NDUMMY=0
      DO J1=1,NEWORB
         IF (NCHOICE(J1).EQ.1) THEN
            COORDS(3*NDUMMY+1:3*(NDUMMY+NEWORBSIZE(J1)),JP)=NEWORBCOORDS(J1,1:3*NEWORBSIZE(J1))
            NDUMMY=NDUMMY+NEWORBSIZE(J1)
         ENDIF
      ENDDO
      NQTOT=NQTOT+1
      NQ(JP)=NQ(JP)+1
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      IF (NPAR.GT.1) THEN
         WRITE(MYUNIT,'(A,I1,A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') &
   &                '[',JP,']Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
      ELSE
         WRITE(MYUNIT,'(A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') &
   &                'Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
      ENDIF
      IF (HOMOREFT) THEN
         CALL HOMOREF(JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      ENDIF
   ! Save the best structure
      IF (LEBEST-POTEL.GT.ECONV) THEN
         LEBEST=POTEL
         QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
         VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
         QBCHANGED=.TRUE.
         QBORDERED=.TRUE.
         QBCORE=NCOREREAL
!        WRITE(MYUNIT,'(A,2L5,I6)') 'symmetry> D QBORDERED,QBCHANGED,QBCORE=',QBORDERED,QBCHANGED,QBCORE

!   DO J2=1,3*NATOMS
!      X(J2)=QBEST(J2)
!   ENDDO
!   CALL POTENTIAL(X,DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)
!   DO J2=1,NATOMS
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-VATBEST(J2))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> E J2,VATBEST,VT(J2)=',J2,VATBEST(J2),VT(J2)
!            STOP
!         ENDIF
!      ENDIF
!   ENDDO

         NSYMREM=0
!        NSURFMOVES(JP)=0
!        SHELLMOVES(JP)=.TRUE.
!        NCORE(JP)=0
!        WRITE(MYUNIT,'(A)') 'symmetry> turning off shell moves'
!        EXIT perms2 ! seems to be OK - perhaps not for LJ185?
      ENDIF
      IF (NQTOT-NQTOTSAVE.GE.NSYMQMAX) EXIT perms2
      IF (HIT) EXIT perms2
   ENDDO perms2
! WRITE(DUMPXYZUNIT(JP),'(I4)') NATOMS
! WRITE(DUMPXYZUNIT(JP),*) 'QBEST 1:'
! IF (NCORE(JP).GT.0) WRITE(DUMPXYZUNIT(JP),'(A2,3F20.10)')  &
  ! &     ('LA ',QBEST(3*(I-1)+1),QBEST(3*(I-1)+2),QBEST(3*(I-1)+3),I=NATOMS,NATOMS-NCORE(JP)+1,-1)
! WRITE(DUMPXYZUNIT(JP),'(A2,3F20.10)') ('LB',QBEST(3*(I-1)+1),QBEST(3*(I-1)+2),QBEST(3*(I-1)+3),I=1,NATOMS-NCORE(JP))

ELSE ! old enumeration

   NCHOICE(1:NEWORB)=0
   NTOPSUM=0
   IF (NEWORB.LE.10) THEN ! with 10 new orbits or fewer, try all possibilities.
      NTOP=0
   ELSE                   ! otherwise, try filling up the first new orbits at the start
      neworbinit: DO J1=1,NEWORB
         NMINREM=MINVAL(NEWORBSIZE(J1+1:NEWORB))
         IF (NTOPSUM+NMINREM+NEWORBSIZE(J1).LE.NFLOAT) THEN
   !     IF (NTOPSUM+NEWORBSIZE(J1).LT.NFLOAT) THEN
            NCHOICE(J1)=1
            NTOPSUM=NTOPSUM+NEWORBSIZE(J1)
         ELSE
            NTOP=J1-1
            EXIT neworbinit
         ENDIF
      ENDDO neworbinit
   ENDIF
   NTRIES=0
   perms: DO
      NTRIES=NTRIES+1
      IF (NTRIES.GE.NSYMQMAX*100) EXIT perms ! another escape route if there are too many choices
      NCHOICE(NEWORB)=NCHOICE(NEWORB)+1
      NDUMMY=0
      DO J1=NEWORB,2,-1
         IF (NCHOICE(J1).EQ.2) THEN
            NCHOICE(J1)=0
            NCHOICE(J1-1)=NCHOICE(J1-1)+1
         ENDIF
         IF (NCHOICE(J1).EQ.1) NDUMMY=NDUMMY+NEWORBSIZE(J1)
      ENDDO
   !  PRINT*,'NTOP,NCHOICE(NTOP+1)=',NTOP,NCHOICE(NTOP+1)
      IF (NCHOICE(NTOP+1).EQ.1) THEN
         NTOP=NTOP+1
         NTOPSUM=NTOPSUM+NEWORBSIZE(NTOP)
   !     PRINT*,'NTOP,NTOPSUM,NFLOAT=',NTOP,NTOPSUM,NFLOAT
         IF (NTOPSUM.GT.NFLOAT) EXIT perms ! all subsequent attempts would have too many atoms.
      ENDIF
      IF (NCHOICE(1).EQ.1) NDUMMY=NDUMMY+NEWORBSIZE(1)
      IF (NCHOICE(1).GT.1) EXIT perms
      IF (LDEBUG) WRITE(MYUNIT, '(A)') 'NCHOICE:'
      IF (LDEBUG) WRITE(MYUNIT, '(60I2)') NCHOICE(1:NEWORB)
      IF (LDEBUG) WRITE(MYUNIT, '(A,2I5)') 'NDUMMY,NFLOAT=',NDUMMY,NFLOAT
      IF (NDUMMY.NE.NFLOAT) CYCLE perms
      IF (NCHOICE(1).GT.1) EXIT perms
      COORDS(1:3*LNCORE,JP)=CORECOORDS(1:3*LNCORE)
      NDUMMY=LNCORE
      DO J1=1,NEWORB
         IF (NCHOICE(J1).EQ.1) THEN
            COORDS(3*NDUMMY+1:3*(NDUMMY+NEWORBSIZE(J1)),JP)=NEWORBCOORDS(J1,1:3*NEWORBSIZE(J1))
            NDUMMY=NDUMMY+NEWORBSIZE(J1)
         ENDIF
      ENDDO
      IF (NDUMMY.NE.NATOMS) THEN
         WRITE(MYUNIT, '(A,2I5)') 'ERROR - NDUMMY,NATOMS=',NDUMMY,NATOMS
         STOP
      ENDIF
      NQTOT=NQTOT+1
      NQ(JP)=NQ(JP)+1
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      WRITE(MYUNIT,'(A,I10,A,F20.10,A,I5,A,G12.5,30X,A,F11.1)') 'Qu ',NQ(JP),' E=',POTEL,' steps=',ITERATIONS,' RMS=',RMS,' t=',TIME
   ! Save the best structure
      IF (LEBEST-POTEL.GT.ECONV) THEN
         LEBEST=POTEL
         QBEST(1:3*NATOMS)=COORDS(1:3*NATOMS,JP)
         VATBEST(1:NATOMS)=VAT(1:NATOMS,JP)
         QBCHANGED=.TRUE.
         QBORDERED=.TRUE.
         QBCORE=NCOREREAL
!        WRITE(MYUNIT,'(A,2L5,I6)') 'symmetry> E QBORDERED,QBCHANGED,QBCORE=',QBORDERED,QBCHANGED,QBCORE

!   DO J2=1,3*NATOMS
!      X(J2)=QBEST(J2)
!   ENDDO
!   CALL POTENTIAL(X,DUMMYGRAD,DUMMYE,.FALSE.,.FALSE.)
!   DO J2=1,NATOMS
!      IF (VT(J2).NE.0.0D0) THEN
!         IF (ABS((VT(J2)-VATBEST(J2))/VT(J2)).GT.0.01D0) THEN
!            WRITE(MYUNIT,'(A,I8,2F15.5)') 'symmetry> F J2,VATBEST,VT(J2)=',J2,VATBEST(J2),VT(J2)
!            STOP
!         ENDIF
!      ENDIF
!   ENDDO

         NSYMREM=0
!        NSURFMOVES(JP)=0
!        SHELLMOVES(JP)=.TRUE.
!        NCORE(JP)=0
!        WRITE(MYUNIT,'(A)') 'symmetry> turning off shell moves'
         EXIT perms
      ENDIF
      IF (NQTOT-NQTOTSAVE.GE.NSYMQMAX) EXIT perms
      IF (HIT) EXIT perms
   ENDDO perms
ENDIF

IF (EPREV(JP)-LEBEST.GT.ECONV) CHANGEDE=.TRUE. 
EPREV(JP)=LEBEST
POTEL=LEBEST
VAT(1:NATOMS,JP)=VATBEST(1:NATOMS)
COORDS(1:3*NATOMS,JP)=QBEST(1:3*NATOMS)
!
! Even if the energy hasn't changed the coordinates in COORDS may have
! been permuted. We need COORDSO to be exactly the same so that the
! routine KEEPSYM can work. COORDSO is used to define the step in this
! routine.
!
! IF (CHANGEDE) THEN
   IF (CENT.AND.(.NOT.SEEDT)) THEN 
     IF (ELLIPSOIDT) THEN
          CALL CENTRE2(COORDS(1:3*NATOMS/2,JP))
     ELSE
          CALL CENTRE2(COORDS(1:3*NATOMS,JP))
     END IF
   END IF
   COORDSO(1:3*(NATOMS-NSEED),JP)=COORDS(1:3*(NATOMS-NSEED),JP)
!  WRITE(MYUNIT,'(A,2G20.10)'),'symmetry> coordso changed: ',COORDSO(1,JP),COORDS(1,JP)
   VATO(1:NATOMS,JP)=VAT(1:NATOMS,JP)
! ENDIF

DO J1=1,NPAR
   IF (J1.EQ.JP) CYCLE
   WRITE(MYUNIT,*) 'symmetry> J1,NCORE,PTGROUP,POINTGROUP=',J1,NCORE(J1),PTGROUP(J1),POINTGROUP
!  IF (NCORE(J1).EQ.0) CYCLE 
!  IF ((POINTGROUP(1:2).EQ.PTGROUP(J1)(1:2)).OR.((POINTGROUP(1:1).EQ.'T').AND.(PTGROUP(J1)(1:1).EQ.'O'))) THEN
   IF (POINTGROUP(1:2).EQ.PTGROUP(J1)(1:2)) THEN
      SR3=DSQRT(3.0D0)
      WRITE(MYUNIT,'(A,I1,3A,I6,A)') '[',JP,']symmetry> point group ',POINTGROUP,' coincides with run ',J1,' reseeding'
      DO J2=1,3*NATOMS
         RANDOM=(DPRAND()-0.5D0)*2.0D0
         COORDS(J2,JP)=RANDOM*DSQRT(RADIUS)/SR3
      ENDDO
      NCORE(JP)=0
      CALL QUENCH(.FALSE.,JP,ITERATIONS,TIME,BRUN,QDONE,SCREENC)
      NSUCCESS(JP)=0
      NFAIL(JP)=0
      EBEST(JP)=POTEL ! this is communicated via common block MYPOT
      BESTCOORDS(1:3*NATOMS,JP)=COORDS(1:3*NATOMS,JP)
      JBEST(JP)=LNQUENCH
      EPREV(JP)=POTEL 
      EPPREV(JP)=0.0D0
      NSYMREM=0
      PTGROUP(JP)='    '
      NCORE(JP)=0
      DEALLOCATE(OCCS)
      RETURN
   ENDIF
ENDDO
PTGROUP(JP)=POINTGROUP

IF (QBORDERED) THEN
   NCORE(JP)=QBCORE
ELSE
   PTGROUP(JP)='    '
   POINTGROUP='    '
   NSYMREM=0
   IF (NCORE(JP).NE.0) THEN
      WRITE(MYUNIT,'(A,I8,3A,I8,A)') 'symmetry> *** ERROR QBORDERED is false number of core atoms should be 0'
      STOP
   ENDIF
ENDIF

IF (NPAR.GT.1) THEN
   WRITE(MYUNIT,'(A,I1,A,I8,3A,I8,A)') '[',JP,']symmetry> number of core atoms=', &
  &      NCORE(JP),' core symmetry ',POINTGROUP,' after ',NQ(JP),' quenches'
ELSE
   WRITE(MYUNIT,'(A,I8,3A,I8,A)') 'symmetry> number of core atoms=', &
  &      NCORE(JP),' core symmetry ',POINTGROUP,' after ',NQ(JP),' quenches'
ENDIF

DEALLOCATE(OCCS)

RETURN

END SUBROUTINE SYMMETRY

