SUBROUTINE NULLMOVE(NEWCOORDS,OLDCOORDS,ATEST,NULLMOVES,JP)
USE COMMONS, ONLY: NATOMS, DEBUG, BOXLX, BOXLY, BOXLZ, PERIODIC, GEOMDIFFTOL, RIGID, TWOD, TEMP, MYUNIT, DEBUG, NPAR
IMPLICIT NONE
DOUBLE PRECISION  :: NEWCOORDS(3*NATOMS), OLDCOORDS(3*NATOMS)
DOUBLE PRECISION  :: RMAT(3,3), DISTANCE, DIST2, ENEW, EOLD, GRAD(3*NATOMS), DPRAND
INTEGER           :: NULLMOVES(NPAR), JP
LOGICAL           :: ATEST 

CALL MINPERMDIST(NEWCOORDS,OLDCOORDS,NATOMS,DEBUG,BOXLX,BOXLY,BOXLZ,PERIODIC,TWOD,DISTANCE,DIST2,RIGID,RMAT)
CALL POTENTIAL(OLDCOORDS,GRAD,EOLD,.FALSE.,.FALSE.)
CALL POTENTIAL(NEWCOORDS,GRAD,ENEW,.FALSE.,.FALSE.)

IF (DISTANCE<GEOMDIFFTOL) THEN
   ATEST=.FALSE.
   NULLMOVES(JP)=NULLMOVES(JP)+1
   IF (DEBUG) WRITE(MYUNIT,*)ATEST,"DISTFAIL, DISTANCE=",DISTANCE
ELSE IF ((EXP(-(ENEW-EOLD)/MAX(TEMP(JP),1.D-100))<DPRAND()).OR.(ENEW<-1.0D6)) THEN
   ATEST=.FALSE.
   IF (DEBUG) WRITE(MYUNIT,*)ATEST,"EFAIL, EDIFF=",ENEW-EOLD
ELSE
   ATEST=.TRUE.
   IF (DEBUG) WRITE(MYUNIT,*)ATEST,"SUCCESS, DISTANCE=",DISTANCE,", EDIFF=",ENEW-EOLD
ENDIF

END SUBROUTINE NULLMOVE

!----------------------------------------------------------------------------------------------------------------------------------!

SUBROUTINE FIXRATIO(NSTEPS,NULLMOVES,NSUCCESS,JP,NULLMOVEST,NSUCCESST)
USE COMMONS, ONLY: STEP,OSTEP,TEMP,NACCEPT,SRATIO,TRATIO,NPAR,MYUNIT,SUMTEMP,SUMSTEP,SUMOSTEP,SUPPRESST,TMOVE,OMOVE
IMPLICIT NONE
DOUBLE PRECISION  :: P0, P1, P0T, P1T
INTEGER           :: JP, NULLMOVES(NPAR), NSUCCESS(NPAR), NULLMOVEST(NPAR), NSUCCESST(NPAR), NSTEPS, LOCALSTEPS

LOCALSTEPS=MOD(NSTEPS,NACCEPT)
IF (LOCALSTEPS==0) LOCALSTEPS=NACCEPT

P0=1.D0-1.D0*NULLMOVES(JP)/(1.D0*LOCALSTEPS)
P1=1.D0*NSUCCESS(JP)/(1.D0*(LOCALSTEPS-NULLMOVES(JP)))

SUMSTEP=SUMSTEP+STEP(JP)*LOCALSTEPS/NACCEPT
SUMOSTEP=SUMOSTEP+OSTEP(JP)*LOCALSTEPS/NACCEPT
SUMTEMP=SUMTEMP+TEMP(JP)*LOCALSTEPS/NACCEPT

IF (SRATIO>0) THEN
   IF (P0>SRATIO) THEN
      IF (TMOVE(JP)) STEP(JP)=STEP(JP)/1.01
      IF (OMOVE(JP)) OSTEP(JP)=OSTEP(JP)/1.01
   ELSE
      IF (TMOVE(JP)) STEP(JP)=STEP(JP)*1.01
      IF (OMOVE(JP)) OSTEP(JP)=OSTEP(JP)*1.01
   ENDIF
ENDIF
IF (TRATIO>0) THEN
   IF (P1>TRATIO) THEN
      TEMP(JP)=TEMP(JP)/1.1
   ELSE
      TEMP(JP)=TEMP(JP)*1.1
   ENDIF
ENDIF

NULLMOVEST(JP)=NULLMOVEST(JP)+NULLMOVES(JP)
NULLMOVES(JP)=0
NSUCCESST(JP)=NSUCCESST(JP)+NSUCCESS(JP)
NSUCCESS(JP)=0

P0T=1.D0-1.D0*NULLMOVEST(JP)/(1.D0*NSTEPS)
P1T=1.D0*NSUCCESST(JP)/(1.D0*(NSTEPS-NULLMOVEST(JP)))

IF (.NOT.SUPPRESST) THEN
   WRITE(MYUNIT,'(4(A,F8.5),A)')'FIXRATIO>Step ratio (mean) = ',P0,' (',P0T,'); Temperature ratio (mean) = ',P1,' (',P1T,')'
   WRITE(MYUNIT,'(A,2F10.5,A,F10.5)')'FIXRATIO>Step is now ',STEP(JP),OSTEP(JP),'; Temperature is now ',TEMP(JP)
   IF (JP==NPAR) WRITE(MYUNIT,'(A,2F10.5,A,F10.5)')'FIXRATIO>Average step =',SUMSTEP/NPAR/NSTEPS*NACCEPT,&
                       SUMOSTEP/NPAR/NSTEPS*NACCEPT,'; Average temperature =',SUMTEMP/NPAR/NSTEPS*NACCEPT
ENDIF

END SUBROUTINE FIXRATIO

!----------------------------------------------------------------------------------------------------------------------------------!

SUBROUTINE FINALRATIO(NULLMOVEST,NSUCCESST,JP,NSTEPS)
USE COMMONS, ONLY: MYUNIT,NPAR,SUMTEMP,SUMSTEP,SUMOSTEP,NACCEPT,STEP,OSTEP,TEMP
IMPLICIT NONE
DOUBLE PRECISION  :: P0, P1
INTEGER           :: JP, NULLMOVEST(NPAR), NSUCCESST(NPAR), NSTEPS

IF (JP<NPAR) RETURN
 
P0=1.D0-1.D0*SUM(NULLMOVEST(:))/(1.D0*NSTEPS)
P1=1.D0*SUM(NSUCCESST(:))/(1.D0*(NSTEPS-SUM(NULLMOVEST(:))))
SUMSTEP=SUMSTEP/NSTEPS*NACCEPT
SUMOSTEP=SUMOSTEP/NSTEPS*NACCEPT
SUMTEMP=SUMTEMP/NSTEPS*NACCEPT
 
WRITE(MYUNIT,'(3(A,I0))')'FINALRATIO>Total:',NSTEPS,' Null:',SUM(NULLMOVEST(:)),' Success:',SUM(NSUCCESST(:))
WRITE(MYUNIT,'(2(A,F8.5))')'FINALRATIO>Step ratio = ',P0,'; Temperature ratio = ',P1
WRITE(MYUNIT,'(A,2F10.5,A,F10.5)')'FINALRATIO>Average step =',SUMSTEP,SUMOSTEP,&
                                  '; Average temperature =',SUMTEMP

END SUBROUTINE FINALRATIO

!----------------------------------------------------------------------------------------------------------------------------------!
