!   GMIN: A program for finding global minima
!   Copyright (C) 1999-2006 David J. Wales
!   This file is part of GMIN.
!
!   GMIN is free software; you can redistribute it and/or modify
!   it under the terms of the GNU General Public License as published by
!   the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   GMIN is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU General Public License for more details.
!
!   You should have received a copy of the GNU General Public License
!   along with this program; if not, write to the Free Software
!   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
!
!  Add energy and gradient correction terms for the container separately.
!
      SUBROUTINE RAD(X,V,ENERGY,GTEST)
      USE COMMONS
      IMPLICIT NONE
      LOGICAL GTEST
      INTEGER J1, J3
      DOUBLE PRECISION X(3*NATOMS), DIST, RESCALE_FACTOR, V(3*NATOMS), 
     1                 ENERGY, DUMMYX, DUMMYY, DUMMYZ
      LOGICAL EVAP, EVAPREJECT
      COMMON /EV/ EVAP, EVAPREJECT

      IF (BSPT) RETURN ! container is accounted for in bspt by recounting previous configuration
      IF (PERIODIC) RETURN
      IF (PERCOLATET) RETURN ! jwrm2> we don't do radius checks if PERCOLATE is used
      EVAP=.FALSE.
      EVAPREJECT=.FALSE.
      DO J1=1,NATOMS
         J3=3*J1
         DIST=X(J3-2)**2+X(J3-1)**2+X(J3)**2
         IF (DIST.GT.RADIUS) THEN
!           WRITE(MYUNIT,'(A,I5,5G20.10)') 'J1,DIST,RADIUS in rad = ',J1,DIST,RADIUS,X(J3-2),X(J3-1),X(J3)
            EVAP=.TRUE.
           ! IF (EVAP.AND.(BSWL.OR.BSPT)) then
           !     EVAPREJECT=.TRUE.
           !     IF (DEBUG) WRITE(MYUNIT,'(A,2G20.10)') 'EVAP: atom, radius=',J1,SQRT(DIST)
           !     RETURN
           ! ENDIF

            IF (DEBUG)  WRITE(MYUNIT,'(A,2G20.10,L10)') 'rad> EVAP: atom, radius, EVAP=',J1,SQRT(DIST),EVAP
!           PRINT*,'EVAP: atom, radius=',J1,SQRT(DIST)
!           ENERGY=ENERGY+1.0D5*(DIST-RADIUS)**2
!           IF (GTEST.AND.(.NOT.(SEEDT.AND.(J1.GT.NATOMS-NSEED).AND.FREEZECORE))) THEN
!              DUMMYX=1.0D5*4.0D0*(DIST-RADIUS)*X(J3-2)
!              DUMMYY=1.0D5*4.0D0*(DIST-RADIUS)*X(J3-1)
!              DUMMYZ=1.0D5*4.0D0*(DIST-RADIUS)*X(J3)
!              V(J3-2)=V(J3-2)+DUMMYX
!              V(J3-1)=V(J3-1)+DUMMYY
!              V(J3)=V(J3)+DUMMYZ
!           ENDIF

             RESCALE_FACTOR=(SQRT(RADIUS)-0.5D0)/SQRT(DIST)
! Move x, y and z coordinates
             X(J3-2)=X(J3-2)*RESCALE_FACTOR
             X(J3-1)=X(J3-1)*RESCALE_FACTOR
             IF (.NOT.TWOD) X(J3)=X(J3)*RESCALE_FACTOR
!            WRITE(MYUNIT,'(A,3G20.10)') 'rad> reset coords: ',X(J3-2),X(J3-1),X(J3)
!
!  Put it back in at the opposite end of a diameter
!
!           X(J3-2)=-X(J3-2)*0.8D0
!           X(J3-1)=-X(J3-1)*0.8D0
!           X(J3)=-X(J3)*0.8D0
         ENDIF
      ENDDO

      RETURN
      END SUBROUTINE RAD
!
!  For rigid-body angle-axis coordinates, just move the fixed site
!
      SUBROUTINE RADR(X,V,ENERGY,GTEST)
      USE COMMONS
      IMPLICIT NONE
      LOGICAL GTEST
      INTEGER J1, J3
      DOUBLE PRECISION X(3*NATOMS), DIST, RESCALE_FACTOR, V(3*NATOMS), 
     1                 ENERGY, DUMMYX, DUMMYY, DUMMYZ
      LOGICAL EVAP, EVAPREJECT
      COMMON /EV/ EVAP, EVAPREJECT

      IF (PERIODIC) RETURN
      EVAP=.FALSE.
      DO J1=1,NATOMS/2
         J3=3*J1
         DIST=X(J3-2)**2+X(J3-1)**2+X(J3)**2
!        WRITE(*,'(A,I6,5F15.5)') 'J1,DIST,coords,RADIUS in radr=',J1,DIST,X(J3-2),X(J3-1),X(J3),RADIUS
         IF (DIST.GT.RADIUS) THEN
            EVAP=.TRUE.
            WRITE(MYUNIT,'(A,I5,5G17.8)') 'EVAP: molecule, coords, dist, radius=',J1,X(J3-2),X(J3-1),X(J3),SQRT(DIST),SQRT(RADIUS)
!           IF (DEBUG) WRITE(*,'(A,I5,2G20.10)') 'EVAP: molecule, dist, radius=',J1,SQRT(DIST),SQRT(RADIUS)
            RESCALE_FACTOR=SQRT(RADIUS*0.9D0/DIST)
!           X(J3-2)=X(J3-2)*RESCALE_FACTOR
!           X(J3-1)=X(J3-1)*RESCALE_FACTOR
!           X(J3)=X(J3)*RESCALE_FACTOR
!
!  Put it back in at the opposite end of a diameter
!
            X(J3-2)=-X(J3-2)*0.8D0
            X(J3-1)=-X(J3-1)*0.8D0
            X(J3)=-X(J3)*0.8D0
         ENDIF
      ENDDO

      RETURN
      END SUBROUTINE RADR

      SUBROUTINE RADCOM(X, MOVET)
      USE COMMONS, ONLY : NATOMS, RADIUS, DEBUG, MYUNIT, BSPT, PERIODIC, PERCOLATET
      IMPLICIT NONE
      INTEGER J1, J3
      DOUBLE PRECISION X(3*NATOMS), DIST, XMASS, YMASS, ZMASS
      LOGICAL EVAP, EVAPREJECT, MOVET
      COMMON /EV/ EVAP, EVAPREJECT

      IF (BSPT) RETURN ! container is accounted for in bspt by recounting previous configuration
      IF (PERIODIC) RETURN
      IF (PERCOLATET) RETURN ! jwrm2> we don't do radius checks if PERCOLATE is used

      XMASS = 0.0
      YMASS = 0.0
      ZMASS = 0.0
      DO J1=1,NATOMS
         J3=3*J1
         XMASS=XMASS + X(J3-2)
         YMASS=YMASS + X(J3-1)
         ZMASS=ZMASS + X(J3)
      ENDDO
      XMASS = XMASS / NATOMS
      YMASS = YMASS / NATOMS
      ZMASS = ZMASS / NATOMS

      EVAP=.FALSE.
      DO J1=1,NATOMS
         J3=3*J1
         DIST=(X(J3-2)-XMASS)**2+(X(J3-1)-YMASS)**2+(X(J3)-ZMASS)**2
         IF (DIST.GT.RADIUS) THEN
            EVAP=.TRUE.
            IF (DEBUG) WRITE(MYUNIT,'(A,2G20.10,L10)') 'rad> EVAP: atom, radius, EVAP=',J1,SQRT(DIST),EVAP
            IF (MOVET) THEN
              DIST=(SQRT(RADIUS)-0.5D0)/SQRT(DIST)
              X(J3-2)=X(J3-2)*DIST
              X(J3-1)=X(J3-1)*DIST
              X(J3)=X(J3)*DIST
            END IF
         ENDIF
      ENDDO

      RETURN
      END SUBROUTINE RADCOM
