MODULE POLIRMOD
USE COMMONS, ONLY: NATOMS, MYUNIT

IMPLICIT NONE
SAVE
INTEGER                       :: IFLAG,IPDC,ILOOP,I_AND,NMOL
DOUBLE PRECISION              :: SUMDX,SUMDY,SUMDZ,KCAL_J,DEBFAC,PI,RCUT,C_16,C_14,C_12,C_6,C16,C14,C12,C6,EPSO,                   &
                                 ESCONVERT,CVEC(3,3),CIVEC(3,3),FMASS(3),FAC(4),DIPDIP(0:3),CHGCHG(0:3),CHGDIP(0:3),               &
                                 EFEXT(3),DPDR(128,3,3,3,3),AVSNO,COF(6),STP
DOUBLE PRECISION, PARAMETER   :: ECHARGE=1.60217733D-19,EWFAC=.4D0,SQPII=0.56418958354D0
DOUBLE PRECISION, ALLOCATABLE :: ACC1(:,:,:),ACC(:,:,:),POTCC(:,:),POTCD(:,:),FORCE(:),DIPOLE(:,:,:),                              &
                                 DIPOLE_P(:,:,:),DIPOLE_2PRINTC(:,:,:),DIPOLE_2PRINTP(:,:,:),DIPOLE_2PRINTI(:,:,:),                &
                                 RAT(:),RF(:,:,:),QAT(:,:),QATD(:,:),ALPH(:,:),EFDD(:,:,:),EFDC(:,:,:),                            &
                                 FQ(:,:,:,:),POT(:,:),FORCE1(:,:,:),FORCE2(:,:,:),DFORCE(:,:,:),DFORCE1(:,:,:),                    &
                                 DFORCE2(:,:,:),DIPORIG(:,:,:),DIPTENS1(:,:,:,:),FORCE_C(:,:,:),DIPTENS2(:,:,:,:),                 &
                                 DIPTENS3(:,:,:,:),DIPTENS4(:,:,:,:),DIPTENS5(:,:,:,:),DIPTENS6(:,:,:,:),                          &
                                 DIPOLE_T(:,:,:)
CHARACTER (LEN=30)            :: XYZFILE,VELFILE,CVECFILE,XYZOUT,VELOUT,TEMPOUT,DIPOUT,PEOUT,KEOUT,TOTOUT,MD_TRAJOUT,              &
                                 MD_VELOUT,MD_DIPOUT,GROOOUT,GROMOUT

PUBLIC :: POLIRINIT, POLIR
PRIVATE
CONTAINS

SUBROUTINE POLIRINIT

IMPLICIT NONE

NMOL=NATOMS/3
AVSNO=6.0221367D+23
PI=ACOS(-1.D0)
C16=7.61978E-09*1D+16
C14=-4.07504E-07*1D+14
C12=5.80846E-06*1D+12
C6=-0.00292171*1D+6
EPSO=8.854187817D-12
ESCONVERT=1.D0/(4.0D0*PI*EPSO)
COF=(/76.18009172947146D0,-86.50532032941677D0,24.01409824083091D0,-1.231739572450155D0,.1208650973866179D-2,-.5395239384953D-5/)
STP=2.5066282746310005D0


ALLOCATE(ACC1(NMOL,3,3),ACC(NMOL,3,3),POTCC(NMOL,3),POTCD(NMOL,3),FORCE(NMOL*3*3),DIPOLE(NMOL,3,3),DIPOLE_P(NMOL,3,3),             &
         DIPOLE_2PRINTC(NMOL,3,3),DIPOLE_2PRINTP(NMOL,3,3),DIPOLE_2PRINTI(NMOL,3,3),RAT(NMOL*3*3),RF(NMOL,3,3),                    &
         QAT(3,NMOL),QATD(3,NMOL),ALPH(NMOL,3),EFDD(NMOL,3,3),EFDC(NMOL,3,3),FQ(NMOL,3,3,3),POT(NMOL,3),                           &
         FORCE1(NMOL,3,3),FORCE2(NMOL,3,3),DFORCE(NMOL,3,3),DFORCE1(NMOL,3,3),DFORCE2(NMOL,3,3),DIPORIG(NMOL,3,3),                 &
         DIPTENS1(NMOL,NMOL,3,3),FORCE_C(NMOL,3,3),DIPTENS2(NMOL,NMOL,3,3),DIPTENS3(NMOL,NMOL,3,3),                                &
         DIPTENS4(NMOL,NMOL,3,3),DIPTENS5(NMOL,NMOL,3,3),DIPTENS6(NMOL,NMOL,3,3),DIPOLE_T(NMOL,3,3))

END SUBROUTINE POLIRINIT

!  ----- **** ---  !

SUBROUTINE POLIR(X,G,ENERGY,GTEST)

IMPLICIT NONE
DOUBLE PRECISION   :: UCC,UCD,UCX,UDD,UDX,UINTRA,UPAIR,USPRING,UTOT,ENERGY
DOUBLE PRECISION   :: FMASS1(3),VEL(NMOL,3,3)
DOUBLE PRECISION   :: X(NMOL*3*3),G(NMOL*3*3)
INTEGER            :: I,IA,I_DIM,ITON,I_A,J,K
LOGICAL            :: GTEST

IFLAG=0
IPDC=0
ILOOP=0
I_AND=0

SUMDX=0.D0
SUMDY=0.D0
SUMDZ=0.D0
KCAL_J=0.D0
DEBFAC=0.D0
RCUT=0.D0
C_16=0.D0
C_14=0.D0
C_12=0.D0
C_6=0.D0
CVEC(:,:)=0.D0
CIVEC(:,:)=0.D0
FMASS(:)=0.D0
FAC(:)=0.D0
DIPDIP(:)=0.D0
CHGCHG(:)=0.D0
CHGDIP(:)=0.D0
EFEXT(:)=0.D0
DPDR(:,:,:,:,:)=0.D0
ACC1(:,:,:)=0.D0
ACC(:,:,:)=0.D0
POTCC(:,:)=0.D0
POTCD(:,:)=0.D0
FORCE(:)=0.D0
DIPOLE(:,:,:)=0.D0
DIPOLE_P(:,:,:)=0.D0
DIPOLE_2PRINTC(:,:,:)=0.D0
DIPOLE_2PRINTP(:,:,:)=0.D0
DIPOLE_2PRINTI(:,:,:)=0.D0
RAT(:)=0.D0
RF(:,:,:)=0.D0
QAT(:,:)=0.D0
QATD(:,:)=0.D0
ALPH(:,:)=0.D0
EFDD(:,:,:)=0.D0
EFDC(:,:,:)=0.D0
FQ(:,:,:,:)=0.D0
POT(:,:)=0.D0
FORCE1(:,:,:)=0.D0
FORCE2(:,:,:)=0.D0
DFORCE(:,:,:)=0.D0
DFORCE1(:,:,:)=0.D0
DFORCE2(:,:,:)=0.D0
DIPORIG(:,:,:)=0.D0
DIPTENS1(:,:,:,:)=0.D0
FORCE_C(:,:,:)=0.D0
DIPTENS2(:,:,:,:)=0.D0
DIPTENS3(:,:,:,:)=0.D0
DIPTENS4(:,:,:,:)=0.D0
DIPTENS5(:,:,:,:)=0.D0
DIPTENS6(:,:,:,:)=0.D0
DIPOLE_T(:,:,:)=0.D0

RAT=X

DO I=1,NMOL
   DO IA=1,3
      DO I_DIM=1,3
         DIPOLE(I,IA,I_DIM)=0.D0
      ENDDO
   ENDDO
ENDDO

ITON=1

CALL SUBTRACT(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA,UCX,UDX,ITON)

ENERGY=UTOT
G(:)=-1.D0*FORCE(:)

END SUBROUTINE POLIR

!  ----- **** ---  !

SUBROUTINE REALSUB(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA,UCX,UDX)
USE MNASA_MOD2

IMPLICIT NONE
DOUBLE PRECISION   :: D2,DFACX,DFACY,DFACZ,DIS,ECC,ECD,EDD,ENG1,FAC1,FAC2,FIRSTTERM,GCFAC,GFAC,PERMHX,PERMHY,PERMHZ,PERMR,         &
                      PERMW,PERM_OZ,QH1,QH2,QO,QPE,R1CR2MAG,R1DOTR1,R1DOTR2,R1MAG,R1R2DIS,R1R2DIS3,R1X,R1Y,R1Z,R2MAG,R2X,          &
                      R2Y,R2Z,RCUT2,RR,RSQ,RSQI,SECTERM,SIGN1,SIGN2,THIRDTERM,UCC,UCD,UCX,UDD,UDX,UINTRA,UPAIR,USPRING,            &
                      UTOT,W1DOTX,W2DOTX,XDIF,XX,XX1,YDIF,YY,YY1,ZDIF,ZZ,ZZ1,AXES(3,3),RAXES(3,3),WAXES(3,3),GRADQ(3,3,3),         &
                      R1(3,3),BOND(NMOL,3,6),DR1(3,3)                  
INTEGER            :: I,IA,IAT,IATOM,I_DIM,IIA,ILTT,ILTT1,ILTT2,ILTT3,IMOL,INUC,IVEC,I_A,J,JATOM,JJ,JJA,JMOL,JVEC,J_A,K,KVEC

DEBFAC=ECHARGE*1D-10/3.33D-30
EFEXT(1)=0.D0
EFEXT(2)=0.D0
EFEXT(3)=0.D0
UINTRA=0.D0
UTOT=0.D0
UCC=0.D0
UCD=0.D0
UDD=0.D0
USPRING=0.D0
UPAIR=0.D0
UCX=0.D0
UDX=0.D0

RCUT2=1000.D0
ILTT=0                     
ILTT1=0                     
ILTT2=0                     
ILTT3=0                     

!     SUM OVER ALL INTRA INTERACTIONS WHICH DON'T INVOLVE M-SITES
IF(I_AND.EQ.1.AND.IFLAG.EQ.1)THEN            
DO I=1,NMOL
   DO IA=1,3
      DO  I_DIM=1,3
          R1(I_DIM,IA)=RAT(9*I+3*IA+I_DIM-12)-RAT(9*I+3*1+I_DIM-12)
       ENDDO
   ENDDO
   CALL POT_NASA(R1,DR1,ENG1)
!               ENG1=ENG1!*KCAL_J
    DO IA=1,3
       DO I_DIM=1,3
          FORCE(9*I+3*IA+I_DIM-12)=-DR1(I_DIM,IA)+FORCE(9*I+3*IA+I_DIM-12)
       ENDDO
    ENDDO
    UINTRA=UINTRA+ENG1
ENDDO
ENDIF

!     SUM OVER MOLECULES TO DETERMINE INTRAMOLECULAR POTENTIAL ENERGY
!     AND DETERMINE CHARGES FROM PARTRIDGE DIPOLE SURFACE
DO I=1,NMOL
   R1X=RAT(9*I+3*2+1-12)-RAT(9*I+3*1+1-12)
   R1Y=RAT(9*I+3*2+2-12)-RAT(9*I+3*1+2-12)
   R1Z=RAT(9*I+3*2+3-12)-RAT(9*I+3*1+3-12)

   R2X=RAT(9*I+3*3+1-12)-RAT(9*I+3*1+1-12)
   R2Y=RAT(9*I+3*3+2-12)-RAT(9*I+3*1+2-12)
   R2Z=RAT(9*I+3*3+3-12)-RAT(9*I+3*1+3-12)

   BOND(I,1,1)=R1X
   BOND(I,1,2)=R1Y
   BOND(I,1,3)=R1Z
   BOND(I,2,1)=R2X
   BOND(I,2,2)=R2Y
   BOND(I,2,3)=R2Z
   BOND(I,1,4)=R1X**2+R1Y**2+R1Z**2
   BOND(I,2,4)=R2X**2+R2Y**2+R2Z**2
   R1MAG=DSQRT(BOND(I,1,4))
   R2MAG=DSQRT(BOND(I,2,4))
   CALL DIP2_H2O(R1X,R1Y,R1Z,R2X,R2Y,R2Z,R1MAG,R2MAG,QH1,QH2,QO,GRADQ)
   IF(R1MAG.GT.1.2D0.OR.R1MAG.LT.0.8D0)THEN
      WRITE(*,*)'PROB',I,R1MAG,R2MAG
      XX1=RAT(9*I+3*1+1-12)-RAT(9*1+3*2+1-12)
      YY1=RAT(9*I+3*1+2-12)-RAT(9*1+3*2+2-12)
      ZZ1=RAT(9*I+3*1+3-12)-RAT(9*1+3*2+3-12)
      WRITE(*,*)DSQRT(XX1**2+YY1**2+ZZ1**2)
   ENDIF
   IF(R2MAG.GT.1.2D0.OR.R2MAG.LT.0.8D0)THEN
      WRITE(*,*)'PROB1',I,R1MAG,R2MAG
       XX1=RAT(9*I+3*1+1-12)-RAT(9*1+3*3+1-12)
       YY1=RAT(9*I+3*1+2-12)-RAT(9*1+3*3+2-12)
       ZZ1=RAT(9*I+3*1+3-12)-RAT(9*1+3*3+3-12)
       WRITE(*,*)DSQRT(XX1**2+YY1**2+ZZ1**2)
   ENDIF

   QAT(1,I)=QO         
   QAT(2,I)=QH1         
   QAT(3,I)=QH2        

!     STORE CHARGE GRADIENTS IN ARRAY
   DO IVEC=1,3
       DO INUC=1,3  
          FQ(I,INUC,1,IVEC)=GRADQ(INUC,1,IVEC)!*ECHARGE/1D-10
          FQ(I,INUC,2,IVEC)=GRADQ(INUC,2,IVEC)!*ECHARGE/1D-10
          FQ(I,INUC,3,IVEC)=-(FQ(I,INUC,1,IVEC)+FQ(I,INUC,2,IVEC))
       ENDDO     
   ENDDO     
   
ENDDO
            
PERMHZ=0.00000000D0
PERM_OZ=0.2962054D0
!     H PERMANENT DIPOLE IN E A
PERMHX=0.10672099D0
PERMHY=0.13501661D0
!     P_PARA = PX*COS(THETA) + PY*SIN(THETA)
!     P_PERP = -PX*SIN(THETA) + PY*COS(THETA)
PERMR=(PERMHX*0.61207927D0 + PERMHY*0.79079641D0)
PERMW=(-PERMHX*0.79079641D0 + PERMHY*0.61207927D0)
!     P_PERP = PX (W1 . X) + PY (W1 . Y)
!     SUM OVER MOLECULES
DIPOLE_P(1,1,1)=0.D0
DIPOLE_P(1,1,2)=0.D0
DIPOLE_P(1,1,3)=0.D0
DIPOLE_P(1,2,1)=0.D0
DIPOLE_P(1,2,2)=0.D0
DIPOLE_P(1,2,3)=0.D0
DIPOLE_P(1,3,1)=0.D0
DIPOLE_P(1,3,2)=0.D0
DIPOLE_P(1,3,3)=0.D0
DO I=1,NMOL
   IMOL=I
   R1DOTR2 = 0.D0
!     1ST H COORDINATES RELATIVE TO O SITE
   R1X=BOND(I,1,1)
   R1Y=BOND(I,1,2)
   R1Z=BOND(I,1,3)
   R1MAG=DSQRT(BOND(I,1,4))
   RAXES(1,1)=R1X
   RAXES(1,2)=R1Y
   RAXES(1,3)=R1Z
!     2ND H COORDINATES RELATIVE TO O SITE
   R2X=BOND(I,2,1)
   R2Y=BOND(I,2,2)  
   R2Z=BOND(I,2,3)
   R2MAG=DSQRT(BOND(I,2,4))
   
   RAXES(2,1)=R2X
   RAXES(2,2)=R2Y
   RAXES(2,3)=R2Z
              
!     DEFINE BISECTOR AXIS (BODY-CENTERED X-AXIS XB)
   XX=R1X+R2X
   YY=R1Y+R2Y
   ZZ=R1Z+R2Z
   DIS=DSQRT(XX*XX+YY*YY+ZZ*ZZ)

   XX=XX/DIS
   YY=YY/DIS
   ZZ=ZZ/DIS
     
   R1R2DIS=DIS
   R1R2DIS3=DIS**3
     
   AXES(1,1)=XX
   AXES(1,2)=YY
   AXES(1,3)=ZZ

!     DEFINE OUT OF PLANE AXIS FROM CROSS PRODUCT (BODY-CENTERED Y-AXIS YB = R1^R2)
   XX=R1Y*R2Z-R2Y*R1Z
   YY=R1Z*R2X-R2Z*R1X
   ZZ=R1X*R2Y-R2X*R1Y
   DIS=SQRT(XX*XX+YY*YY+ZZ*ZZ)
   R1CR2MAG=DIS

   XX=XX/DIS
   YY=YY/DIS
   ZZ=ZZ/DIS
   
!     AXES(2,I) IS THE CROSS PRODUCT VECTOR UNIT VECTOR
   
   AXES(2,1)=XX
   AXES(2,2)=YY
   AXES(2,3)=ZZ

!     DEFINE W1, W2 AXES
   WAXES(1,1) = (R1Y*ZZ - R1Z*YY)/R1MAG
   WAXES(1,2) = (R1Z*XX - R1X*ZZ)/R1MAG
   WAXES(1,3) = (R1X*YY - R1Y*XX)/R1MAG
   
   WAXES(2,1) = (R2Y*ZZ - R2Z*YY)/R2MAG
   WAXES(2,2) = (R2Z*XX - R2X*ZZ)/R2MAG
   WAXES(2,3) = (R2X*YY - R2Y*XX)/R2MAG
   
   W1DOTX=WAXES(1,1)*AXES(1,1)+WAXES(1,2)*AXES(1,2)+WAXES(1,3)*AXES(1,3)
   SIGN1=-W1DOTX/ABS(W1DOTX)
   W2DOTX=WAXES(2,1)*AXES(1,1)+WAXES(2,2)*AXES(1,2)+WAXES(2,3)*AXES(1,3)
   SIGN2=-W2DOTX/(ABS(W2DOTX))
   
   R1DOTR2 = 0.D0
   R1DOTR1 = 0.D0
   
   DO KVEC=1,3   
      R1DOTR2 = R1DOTR2 + RAXES(1,KVEC)*RAXES(2,KVEC)
      R1DOTR1 = R1DOTR1 + RAXES(1,KVEC)*RAXES(1,KVEC)
   ENDDO
   
   
!     O PERMANENT DIPOLE (POINTING IN DIRECTION OF FIRST AXIS)
!     O PERMANENT DIPOLE (POINTING IN DIRECTION OF XB AXIS)

   DIPOLE_P(I,1,1)=AXES(1,1)*PERM_OZ
   DIPOLE_P(I,1,2)=AXES(1,2)*PERM_OZ
   DIPOLE_P(I,1,3)=AXES(1,3)*PERM_OZ
   
   DIPOLE_P(I,2,1)=WAXES(1,1)*SIGN1*PERMW + PERMR*RAXES(1,1)/R1MAG
   DIPOLE_P(I,2,2)=WAXES(1,2)*SIGN1*PERMW + PERMR*RAXES(1,2)/R1MAG
   DIPOLE_P(I,2,3)=WAXES(1,3)*SIGN1*PERMW + PERMR*RAXES(1,3)/R1MAG
   
   DIPOLE_P(I,3,1)=WAXES(2,1)*SIGN2*PERMW + PERMR*RAXES(2,1)/R2MAG
   DIPOLE_P(I,3,2)=WAXES(2,2)*SIGN2*PERMW + PERMR*RAXES(2,2)/R2MAG
   DIPOLE_P(I,3,3)=WAXES(2,3)*SIGN2*PERMW + PERMR*RAXES(2,3)/R2MAG
!     CALCULATE DPDR TERMS 
 IF(IFLAG.EQ.1) THEN
   
!     ZERO DPDR TERMS
   DO IATOM=1,3
      DO JATOM=1,3
         DO IVEC=1,3
            DO JVEC=1,3
               DPDR(IMOL,IATOM,JATOM,IVEC,JVEC) = 0.D0
            ENDDO
         ENDDO
      ENDDO
   ENDDO
   
   DO IVEC=1,3
      DO JVEC=1,3 
         IF(IVEC.EQ.JVEC) THEN
!     GRADIENTS FOR O
            DPDR(IMOL,3,1,IVEC,JVEC) =  PERM_OZ/R1R2DIS
!     GRADIENTS FOR W1
            DPDR(IMOL,1,1,IVEC,JVEC) = DPDR(IMOL,1,1,IVEC,JVEC) + SIGN1*PERMW*R1DOTR2/(R1MAG*R1CR2MAG) + PERMR/R1MAG
            DPDR(IMOL,1,2,IVEC,JVEC) = DPDR(IMOL,1,2,IVEC,JVEC) - SIGN1*PERMW*R1MAG**2/(R1MAG*R1CR2MAG)
!     GRADIENTS FOR W2
            DPDR(IMOL,2,1,IVEC,JVEC) = DPDR(IMOL,2,1,IVEC,JVEC) + SIGN2*PERMW*R2MAG**2/(R2MAG*R1CR2MAG)
            DPDR(IMOL,2,2,IVEC,JVEC) = DPDR(IMOL,2,2,IVEC,JVEC) - SIGN2*PERMW*R1DOTR2/(R2MAG*R1CR2MAG) + PERMR/R2MAG
         ENDIF
!     GRADIENTS FOR O
        FAC1 = (BOND(IMOL,1,IVEC)+BOND(IMOL,2,IVEC))
        FAC2 = (BOND(IMOL,1,JVEC)+BOND(IMOL,2,JVEC))
        DPDR(IMOL,3,1,IVEC,JVEC) = DPDR(IMOL,3,1,IVEC,JVEC) - PERM_OZ*(FAC1*FAC2)/R1R2DIS3
        DPDR(IMOL,3,2,IVEC,JVEC) = DPDR(IMOL,3,1,IVEC,JVEC)
!     GRADIENTS FOR W1
        FIRSTTERM = (RAXES(1,IVEC)*RAXES(2,JVEC) - 2.D0*RAXES(2,IVEC)*RAXES(1,JVEC))/(R1MAG*R1CR2MAG)
        SECTERM = (WAXES(1,IVEC)/(R1MAG*R1CR2MAG))* ((RAXES(1,JVEC)*R1CR2MAG)/R1MAG + (R1MAG*R2MAG*WAXES(2,JVEC)))
        THIRDTERM = PERMR*RAXES(1,IVEC)*RAXES(1,JVEC)/R1MAG**3
        DPDR(IMOL,1,1,IVEC,JVEC) = DPDR(IMOL,1,1,IVEC,JVEC) + SIGN1*PERMW*(FIRSTTERM - SECTERM) - THIRDTERM
        FIRSTTERM = (RAXES(1,IVEC)*RAXES(1,JVEC))/(R1MAG*R1CR2MAG)   
        SECTERM = (WAXES(1,IVEC)*WAXES(1,JVEC)*R1MAG**2)/(R1MAG*R1CR2MAG)
        DPDR(IMOL,1,2,IVEC,JVEC) = DPDR(IMOL,1,2,IVEC,JVEC) + SIGN1*PERMW*(FIRSTTERM + SECTERM)
!     GRADIENTS FOR W2
        FIRSTTERM = (RAXES(2,IVEC)*RAXES(2,JVEC))/(R2MAG*R1CR2MAG)
        SECTERM = (WAXES(2,IVEC)*WAXES(2,JVEC)*R2MAG**2)/(R2MAG*R1CR2MAG)
        DPDR(IMOL,2,1,IVEC,JVEC) = DPDR(IMOL,2,1,IVEC,JVEC) + SIGN2*PERMW*(- FIRSTTERM - SECTERM)
      
        FIRSTTERM = (-RAXES(2,IVEC)*RAXES(1,JVEC) + 2.D0*RAXES(1,IVEC)*RAXES(2,JVEC))/(R2MAG*R1CR2MAG)
        SECTERM = (WAXES(2,IVEC)/(R2MAG*R1CR2MAG))*((RAXES(2,JVEC)*R1CR2MAG)/R2MAG-(R2MAG*R1MAG*WAXES(1,JVEC)))
        THIRDTERM = PERMR*RAXES(2,IVEC)*RAXES(2,JVEC)/R2MAG**3
        DPDR(IMOL,2,2,IVEC,JVEC) = DPDR(IMOL,2,2,IVEC,JVEC) + SIGN2*PERMW*(FIRSTTERM - SECTERM) - THIRDTERM
      ENDDO
   ENDDO
     
!     OBTAIN DPDR ON R=3 (OXYGEN) SITES FROM NEGATIVE OF DPDR ON OTHER
!     TWO SITES.
   DO IVEC=1,3
      DO JVEC=1,3
         DO JJ=1,3
            DPDR(IMOL,JJ,3,IVEC,JVEC) = DPDR(IMOL,JJ,3,IVEC,JVEC) - DPDR(IMOL,JJ,1,IVEC,JVEC) - DPDR(IMOL,JJ,2,IVEC,JVEC)
         ENDDO
      ENDDO
   ENDDO
 ENDIF
ENDDO
   
!     SUM OVER ALL INTRA INTERACTIONS
DO I=1,NMOL
   IMOL=I
   DO IIA=1,2
      J=I
      JMOL=J
   DO JJA=IIA+1,3
      QPE=0.0
      GCFAC=0.0
      GFAC=0.0
      DFACX=0.0
      DFACY=0.0
      DFACZ=0.0
      ECC=0
      ECD=0
      EDD=0

      XDIF=RAT(9*I+3*IIA+1-12)-RAT(9*J+3*JJA+1-12)
      YDIF=RAT(9*I+3*IIA+2-12)-RAT(9*J+3*JJA+2-12)
      ZDIF=RAT(9*I+3*IIA+3-12)-RAT(9*J+3*JJA+3-12)
      RSQ=XDIF*XDIF+YDIF*YDIF+ZDIF*ZDIF
!            IF(RSQ.LE.RCUT2) THEN    !2
        RSQI=1.D0/RSQ
        RR=DSQRT(RSQ)
        ILTT=ILTT+1 
        IA=0
!              IF(RR.LE.RCUTC)THEN          !3 
          CALL SMEAR(RR,RSQ,I,J,IIA,JJA,IA)
          CALL FIELD(I,J,IIA,JJA,IA,XDIF,YDIF,ZDIF,RR,GCFAC,DFACX,DFACY,DFACZ,ECC,ECD,EDD)
!              ENDIF   !33
     
        IF(IFLAG.EQ.1) THEN  !5
          UCC=UCC+ECC
          UCD=UCD+ECD
          UDD=UDD+EDD
            
          FORCE(9*I+3*IIA+1-12)=FORCE(9*I+3*IIA+1-12)+(GFAC+GCFAC)*XDIF+DFACX
          FORCE(9*I+3*IIA+2-12)=FORCE(9*I+3*IIA+2-12)+(GFAC+GCFAC)*YDIF+DFACY
          FORCE(9*I+3*IIA+3-12)=FORCE(9*I+3*IIA+3-12)+(GFAC+GCFAC)*ZDIF+DFACZ
          FORCE(9*J+3*JJA+1-12)=FORCE(9*J+3*JJA+1-12)-(GFAC+GCFAC)*XDIF-DFACX
          FORCE(9*J+3*JJA+2-12)=FORCE(9*J+3*JJA+2-12)-(GFAC+GCFAC)*YDIF-DFACY
          FORCE(9*J+3*JJA+3-12)=FORCE(9*J+3*JJA+3-12)-(GFAC+GCFAC)*ZDIF-DFACZ
        ENDIF  !55
!            ENDIF   !22
      ENDDO         
   ENDDO         
ENDDO         
   !STOP
IF(I_AND.EQ.1)THEN
DO I=1,NMOL-1
   IMOL=I
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IIA=1,I_A
      DO J=I+1,NMOL
!               IF(J.EQ.1)J_A=1
         IF(J.GE.1)J_A=3
         JMOL=J
         DO JJA=1,J_A
            QPE=0.0
            GCFAC=0.0
            GFAC=0.0
            DFACX=0.0
            DFACY=0.0
            DFACZ=0.0
            ECC=0
            ECD=0
            EDD=0
            
            XDIF=RAT(9*I+3*IIA+1-12)-RAT(9*J+3*JJA+1-12)
            YDIF=RAT(9*I+3*IIA+2-12)-RAT(9*J+3*JJA+2-12)
            ZDIF=RAT(9*I+3*IIA+3-12)-RAT(9*J+3*JJA+3-12)
            RSQ=XDIF*XDIF+YDIF*YDIF+ZDIF*ZDIF
!                  IF(RSQ.LE.RCUT2) THEN    !2
              RSQI=1.D0/RSQ
              RR=DSQRT(RSQ)
              ILTT=ILTT+1 
              IA=1
!                    IF(RR.LE.RCUTC)THEN          !3 
                ILTT3=ILTT3+1
                CALL SMEAR(RR,RSQ,I,J,IIA,JJA,IA)
                CALL FIELD(I,J,IIA,JJA,IA,XDIF,YDIF,ZDIF,RR,GCFAC,DFACX,DFACY,DFACZ,ECC,ECD,EDD)
!                    ENDIF   !33
     
              IF(IFLAG.EQ.1) THEN  !5
                UCC=UCC+ECC
                UCD=UCD+ECD
                UDD=UDD+EDD
                IF(IIA.EQ.1.AND.JJA.EQ.1)THEN !8
                  IF(I.GE.1)CALL LJ(RSQI,RR,QPE,GFAC)
!                        IF(I.EQ.1)CALL LJ1(RSQI,RR,QPE,GFAC)
                ENDIF       !88
                UPAIR=UPAIR+QPE   
            
                FORCE(9*I+3*IIA+1-12)=FORCE(9*I+3*IIA+1-12)+(GFAC+GCFAC)*XDIF+DFACX
                FORCE(9*I+3*IIA+2-12)=FORCE(9*I+3*IIA+2-12)+(GFAC+GCFAC)*YDIF+DFACY
                FORCE(9*I+3*IIA+3-12)=FORCE(9*I+3*IIA+3-12)+(GFAC+GCFAC)*ZDIF+DFACZ
                FORCE(9*J+3*JJA+1-12)=FORCE(9*J+3*JJA+1-12)-(GFAC+GCFAC)*XDIF-DFACX
                FORCE(9*J+3*JJA+2-12)=FORCE(9*J+3*JJA+2-12)-(GFAC+GCFAC)*YDIF-DFACY
                FORCE(9*J+3*JJA+3-12)=FORCE(9*J+3*JJA+3-12)-(GFAC+GCFAC)*ZDIF-DFACZ
              ENDIF  !55
!                  ENDIF   !22
         ENDDO         
      ENDDO         
   ENDDO         
ENDDO         
ENDIF

!     AND FIND THE DIPOLE FORCES DU/DD
IF(IFLAG.EQ.1) THEN
   DO I=1,NMOL
!            IF(I.EQ.1)I_A=1
      IF(I.GE.1)I_A=3
      DO IAT=1,I_A
         D2=DIPOLE(I,IAT,1)*DIPOLE(I,IAT,1)+DIPOLE(I,IAT,2)*DIPOLE(I,IAT,2)+DIPOLE(I,IAT,3)*DIPOLE(I,IAT,3)
         USPRING=USPRING+FAC(4)*D2/(2.D0*ALPH(I,IAT))
      ENDDO
   ENDDO
ENDIF
!       STOP
!     EVALUATE THE EXTERNAL FIELD CONTRIBUTION
!      CALL EXTERNAL(UCX,UDX)
!     DETERMINE THE EXTRA FORCES FROM THE VARIABLE CHARGES
!     ABOVE THOSE WHICH ARISE FROM STATIC CHARGES
END SUBROUTINE REALSUB

!  ----- **** ---  !

SUBROUTINE LOOPY(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA)

IMPLICIT NONE
DOUBLE PRECISION   :: UCC,UCD,UDD,UINTRA,UPAIR,USPRING,UTOT
INTEGER, PARAMETER :: NMAX=400

IFLAG=0
ILOOP=1
CALL CLEAR
CALL ITER

CALL ENERGY(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA)
 10   ILOOP=ILOOP+1
CALL CLEAR
CALL ITER
    !WRITE(*,*)IFLAG
IF(ILOOP.GE.NMAX) THEN
WRITE(*,*) 'ERROR.  MAXIMUM NUMBER OF DIPOLE ITERATIONS EXCEEDED.'
WRITE(*,*) 'YOU MAY BE USING UNREALISTIC GEOMETRIES.'
WRITE(*,*) 'IF NOT THEN CONVERGENCE MAY BE IMPROVED BY'
WRITE(*,*) 'DECREASING THE DIPOLE MIXING PARAMETER NEWFAC.'
WRITE(*,*)
WRITE(*,*) 'CURRENT STATUS FOLLOWS:'
WRITE(*,*) '(ENERGIES AND FORCES NOT CALCULATED YET)'
STOP
ENDIF
IF(IFLAG.EQ.0) GOTO 10
CALL CLEAR
CALL ENERGY(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA)
END SUBROUTINE LOOPY

!  ----- **** ---  !

SUBROUTINE ITER

IMPLICIT NONE
DOUBLE PRECISION   :: DELTADIP,DIPMAG,DNEWFAC,FAC4I,OLDFAC,OLDIPX,OLDIPY,OLDIPZ,TOLER
INTEGER            :: I,IA,I_A

! MG
!      TOLER=5.0D-8
TOLER=.10D-6
OLDFAC=0.5D0
FAC4I=1.D0/FAC(4)
DEBFAC=ECHARGE*1D-10/3.33D-30
!      IF(ILOOP.EQ.1) THEN
!         GOTO 9000
!      ENDIF
CALL DDFIELD
DELTADIP=0.D0

DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IA=1,I_A
      OLDIPX=DIPOLE(I,IA,1)
      OLDIPY=DIPOLE(I,IA,2)
      OLDIPZ=DIPOLE(I,IA,3)
!     MIXING RATIO
!     D(N+1)=NEWFAC*ALPHA(E+T.D(N))+OLDFAC*D(N-1)
      DNEWFAC=1.-OLDFAC
      DIPOLE(I,IA,1)=OLDFAC*OLDIPX+(DNEWFAC*ALPH(I,IA)*FAC4I*(EFDD(I,IA,1)+EFDC(I,IA,1)+EFEXT(1)))
      DIPOLE(I,IA,2)=OLDFAC*OLDIPY+(DNEWFAC*ALPH(I,IA)*FAC4I*(EFDD(I,IA,2)+EFDC(I,IA,2)+EFEXT(2)))
      DIPOLE(I,IA,3)=OLDFAC*OLDIPZ+(DNEWFAC*ALPH(I,IA)*FAC4I*(EFDD(I,IA,3)+EFDC(I,IA,3)+EFEXT(3)))
      DIPMAG=DSQRT(DIPOLE(I,IA,1)**2+DIPOLE(I,IA,2)**2+DIPOLE(I,IA,3)**2)
      DELTADIP=DELTADIP+((DIPOLE(I,IA,1)-OLDIPX)**2.D0+(DIPOLE(I,IA,2)-OLDIPY)**2.D0+(DIPOLE(I,IA,3)-OLDIPZ)**2.D0)
    ENDDO
ENDDO
DELTADIP=DSQRT(DELTADIP/DBLE(NMOL))*DEBFAC
!        STOP
IFLAG=0
IF(DELTADIP.GT.1.E+10) THEN
  WRITE(*,*)'TROUBLE CONVERING DIPOLES'
  STOP
ENDIF
IF(DELTADIP.LE.TOLER) THEN
  IFLAG=1
ENDIF

! 9000 CONTINUE
END SUBROUTINE ITER

!  ----- **** ---  !

SUBROUTINE CLEAR
IMPLICIT NONE
INTEGER            :: I,IA,ISP,IVEC,I_A
DPDR=0.0
ISP=0
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IA=1,I_A
      POTCC(I,IA)=0.D0
      POTCD(I,IA)=0.D0
      POT(I,IA)=0.D0
!     SET INITIAL VALUE OF CHARGES
      DO IVEC=1,3
         EFDD(I,IA,IVEC)=0.D0
         IF(ILOOP.EQ.1) THEN
           EFDC(I,IA,IVEC)=0.D0
           FORCE(9*I+3*IA+IVEC-12)=0.D0
         ENDIF
      ENDDO
   ENDDO
ENDDO
END SUBROUTINE CLEAR

!  ----- **** ---  !

SUBROUTINE SUBTRACT(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA,UCX,UDX,ITON)

IMPLICIT NONE
DOUBLE PRECISION   :: UCC,UCC1,UCC2,UCD,UCD1,UCD2,UCX,UCX1,UCX2,UDD,UDD1,UDD2,UDX,UDX1,UDX2,UINTRA,UINTRA1,UINTRA2,                &
                      UPAIR,UPAIR1,UPAIR2,USPRING,USPRING1,USPRING2,UTOT,UTOT1,UTOT2,XD
INTEGER            :: I,I1,I2,I3,I4,IA,IAT,I_DIM,ITON,ITON_ORIG,IVEC,J,JA

PI=ACOS(-1.D0)
EPSO=8.854187817D-12
ESCONVERT=1.D0/(4.0D0*PI*EPSO)
FAC(4)=ECHARGE**2*ESCONVERT
FAC(4)=FAC(4)*1D+10*1.439325215D+20
DEBFAC=ECHARGE*1D-10/3.33D-30

DO I=1,NMOL
   ALPH(I,1)=1.365D0
   ALPH(I,2)=0.471D0
   ALPH(I,3)=0.471D0
ENDDO

DO I=1,NMOL
   DO IA=1,3
      DO J=1,NMOL
         DO JA=1,3
            DIPTENS1(I,J,IA,JA)=0.D0
            DIPTENS2(I,J,IA,JA)=0.D0
            DIPTENS3(I,J,IA,JA)=0.D0
            DIPTENS4(I,J,IA,JA)=0.D0
            DIPTENS5(I,J,IA,JA)=0.D0
            DIPTENS6(I,J,IA,JA)=0.D0
         ENDDO
      ENDDO
   ENDDO
ENDDO
DO I=1,NMOL
   DO I1=1,3
      DO I2=1,3
         DO I3=1,3
            DO I4=1,3
                DPDR(I,I1,I2,I3,I4)=0.D0
            ENDDO
         ENDDO
      ENDDO
   ENDDO
ENDDO

I_AND=1!2
! MG
IPDC=0!2
!      IPDC=1!2
CALL LOOPY(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA)
SUMDX=DEBFAC*DIPOLE(1,1,1)
SUMDY=DEBFAC*DIPOLE(1,1,2)
SUMDZ=DEBFAC*DIPOLE(1,1,3)

DIPOLE_2PRINTC(1,1,1)=0.0
DIPOLE_2PRINTC(1,1,2)=0.0
DIPOLE_2PRINTC(1,1,3)=0.0
DIPOLE_2PRINTP(1,1,1)=0.0
DIPOLE_2PRINTP(1,1,2)=0.0
DIPOLE_2PRINTP(1,1,3)=0.0
DIPOLE_2PRINTI(1,1,1)=DEBFAC*DIPOLE(1,1,1)
DIPOLE_2PRINTI(1,1,2)=DEBFAC*DIPOLE(1,1,2)
DIPOLE_2PRINTI(1,1,3)=DEBFAC*DIPOLE(1,1,3)
DO I=1,NMOL
   DO IAT=1,3
      DO I_DIM=1,3
         XD=RAT(9*I+3*IAT+I_DIM-12)-RAT(9*I+3*1+I_DIM-12)
         DIPOLE_2PRINTC(I,IAT,I_DIM)=QAT(IAT,I)*XD*DEBFAC
         DIPOLE_2PRINTP(I,IAT,I_DIM)=DIPOLE_P(I,IAT,I_DIM)*DEBFAC
         DIPOLE_2PRINTI(I,IAT,I_DIM)=DIPOLE(I,IAT,I_DIM)*DEBFAC
         IF(I_DIM.EQ.1)SUMDX=SUMDX+QAT(IAT,I)*XD*DEBFAC+(DIPOLE_P(I,IAT,I_DIM)+DIPOLE(I,IAT,I_DIM))*DEBFAC
         IF(I_DIM.EQ.2)SUMDY=SUMDY+QAT(IAT,I)*XD*DEBFAC+(DIPOLE_P(I,IAT,I_DIM)+DIPOLE(I,IAT,I_DIM))*DEBFAC
         IF(I_DIM.EQ.3)SUMDZ=SUMDZ+QAT(IAT,I)*XD*DEBFAC+(DIPOLE_P(I,IAT,I_DIM)+DIPOLE(I,IAT,I_DIM))*DEBFAC
      ENDDO
   ENDDO
ENDDO

UTOT1=UTOT
UPAIR1=UPAIR
UCC1=UCC

UCD1=UCD
UDD1=UDD
USPRING1=USPRING
UINTRA1=UINTRA
UCX1=UCX
UDX1=UDX
DO I=1,NMOL
   DO IA=1,3
      DO IVEC=1,3
         FORCE1(I,IA,IVEC)=FORCE(9*I+3*IA+IVEC-12)
         DFORCE1(I,IA,IVEC)=DFORCE(I,IA,IVEC)
         DIPORIG(I,IA,IVEC)=DIPOLE(I,IA,IVEC)
      ENDDO
   ENDDO
ENDDO
DO I=1,NMOL
   DO IA=1,3
      DO J=1,NMOL
         DO JA=1,3
            DIPTENS1(I,J,IA,JA)=0.D0
            DIPTENS2(I,J,IA,JA)=0.D0
            DIPTENS3(I,J,IA,JA)=0.D0
            DIPTENS4(I,J,IA,JA)=0.D0
            DIPTENS5(I,J,IA,JA)=0.D0
            DIPTENS6(I,J,IA,JA)=0.D0
         ENDDO
      ENDDO
   ENDDO
ENDDO
DO I=1,NMOL
   DO I1=1,3
      DO I2=1,3
         DO I3=1,3
            DO I4=1,3
               DPDR(I,I1,I2,I3,I4)=0.D0
            ENDDO
         ENDDO
      ENDDO
   ENDDO
ENDDO

I_AND=2
ITON_ORIG=ITON
ITON=1
! MG
IPDC=0!2
!      IPDC=2
CALL LOOPY(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA)

ITON=ITON_ORIG
UTOT2=UTOT
UPAIR2=UPAIR
UCC2=UCC
UCD2=UCD
UDD2=UDD
USPRING2=USPRING
UINTRA2=UINTRA
UCX2=UCX
UDX2=UDX

DO I=1,NMOL
   DO IA=1,3
      DO IVEC=1,3
         FORCE2(I,IA,IVEC)=FORCE(9*I+3*IA+IVEC-12)
         DFORCE2(I,IA,IVEC)=DFORCE(I,IA,IVEC)
      ENDDO
   ENDDO
ENDDO

DO I=1,NMOL
   DO IA=1,3
      DO IVEC=1,3
         FORCE(9*I+3*IA+IVEC-12)=FORCE1(I,IA,IVEC)-FORCE2(I,IA,IVEC)
         DFORCE(I,IA,IVEC)=DFORCE1(I,IA,IVEC)-DFORCE2(I,IA,IVEC)
         DIPOLE(I,IA,IVEC)=DIPORIG(I,IA,IVEC)
      ENDDO
   ENDDO
ENDDO

UTOT=UTOT1-UTOT2
UPAIR=UPAIR1-UPAIR2
UCC=UCC1-UCC2
UCD=UCD1-UCD2
UDD=UDD1-UDD2
USPRING=USPRING1-USPRING2
UINTRA=UINTRA1-UINTRA2
UCX=UCX1-UCX2
UDX=UDX1-UDX2
END SUBROUTINE SUBTRACT

!  ----- **** ---  !

SUBROUTINE SELF

IMPLICIT NONE
DOUBLE PRECISION   :: SFAC
INTEGER            :: I,IA,ISP,I_A

!     THIS SUBROUTINE CALCULATES THE EWALD 'SELF CORRECTION' TERM.

SFAC=FAC(4)*SQPII*EWFAC
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
     DO IA=1,I_A
        ISP=ISP+1
        POTCC(I,IA)=POTCC(I,IA)-2.D0*QAT(IA,I)*SFAC
        EFDD(I,IA,1)=EFDD(I,IA,1)+4.D0*EWFAC*EWFAC*SFAC*(DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1))/3.D0
        EFDD(I,IA,2)=EFDD(I,IA,2)+4.D0*EWFAC*EWFAC*SFAC*(DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2))/3.D0
        EFDD(I,IA,3)=EFDD(I,IA,3)+4.D0*EWFAC*EWFAC*SFAC*(DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3))/3.D0
     ENDDO
ENDDO
END SUBROUTINE SELF

!  ----- **** ---  !

SUBROUTINE EWALD

IMPLICIT NONE
DOUBLE PRECISION   :: AAA,AK1MAG,AK2MAG,AK3MAG,AKCUT,AKDCKRS,AKDSKRS,AKK2,AKX,AKY,AKZ,CCKR,CCKRS,CSKR,CSKRS,DCKRSX,                &
                      DCKRSY,DCKRSZ,DDD,DJK,DSKRSX,DSKRSY,DSKRSZ,QPEC,R1MAG,R2MAG,R3MAG,RC,RCCKRSX,RCCKRSY,RCCKRSZ,                &
                      RCSKRSX,RCSKRSY,RCSKRSZ,RKDCKRSX,RKDCKRSY,RKDCKRSZ,RKDSKRSX,RKDSKRSY,RKDSKRSZ,SS,SUM1,SUM2,                  &
                      THET,TT,VOL,VOLI,VV,AXES(3,3),RAXES(3,3),WAXES(3,3),R1(3,3),CKR(NMOL,3),SKR(NMOL,3),XM(3)
INTEGER            :: I,IA,I_A,KDCKRS,KDSKRS,M1,M1MAX,M1MIN,M2,M2MAX,M2MIN,M3,M3MAX,M3MIN
  
!  EWFAC=4.0D0, SQPII/0.56418958354D0
CALL RECIP(VOL,VOLI,RC)
CALL FRACR(1)
!     THIS SUBROUTINE EVALUATES THE RECIPROCAL SPACE CONTRIBUTION TO
!     THE EWALD SUM
QPEC=0.0
!     MAGNITUDE OF REAL SPACE AND RECIPROCAL SPACE LATTICE VECTORS
      
AK1MAG=DSQRT(CIVEC(1,1)**2+CIVEC(1,2)**2+CIVEC(1,3)**2)
AK2MAG=DSQRT(CIVEC(2,1)**2+CIVEC(2,2)**2+CIVEC(2,3)**2)
AK3MAG=DSQRT(CIVEC(3,1)**2+CIVEC(3,2)**2+CIVEC(3,3)**2)
      
R1MAG=DSQRT(CVEC(1,1)**2+CVEC(1,2)**2+CVEC(1,3)**2)
R2MAG=DSQRT(CVEC(2,1)**2+CVEC(2,2)**2+CVEC(2,3)**2)
R3MAG=DSQRT(CVEC(3,1)**2+CVEC(3,2)**2+CVEC(3,3)**2)

!     THE FOLLOWING COMMENTS AND LOOPING SYSTEM
!     ARE ADAPTED FROM SMITH[]

!     M1 RANGES OVER THE VALUES 0 TO M1MAX ONLY.
!
!     M2 RANGES OVER 0 TO M2MAX WHEN M1=0 AND OVER
!     -M2MAX TO M2MAX OTHERWISE.
!     M3 RANGES OVER 1 TO M3MAX WHEN M1=M2=0 AND OVER
!     -M3MAX TO M3MAX OTHERWISE.
!     HENCE THE RESULT OF THE SUMMATION MUST BE DOUBLED AT THE END.
!
!     KCUT IS THE RECIPROCAL SPACE CUT-OFF IN ANG-1
AKCUT=2.5D0
M1MAX=INT(AKCUT*R1MAG/(2.D0*PI))+1
M2MAX=INT(AKCUT*R2MAG/(2.D0*PI))+1
M3MAX=INT(AKCUT*R3MAG/(2.D0*PI))+1
!     SUM OVER K VECTORS

M1MIN=0
DO M1=M1MIN,M1MAX
   IF(M1.EQ.0) THEN
      M2MIN=0
   ELSE
      M2MIN=-M2MAX
   ENDIF
     
   DO M2=M2MIN,M2MAX
      IF((M1.EQ.0).AND.(M2.EQ.0)) THEN
         M3MIN=1
      ELSE
         M3MIN=-M3MAX   
      ENDIF

      DO M3=M3MIN,M3MAX
         XM(1)=FLOAT(M1)
         XM(2)=FLOAT(M2)
         XM(3)=FLOAT(M3)
     
         AKX=XM(1)*CIVEC(1,1)+XM(2)*CIVEC(2,1)+XM(3)*CIVEC(3,1)
         AKY=XM(1)*CIVEC(1,2)+XM(2)*CIVEC(2,2)+XM(3)*CIVEC(3,2)
         AKZ=XM(1)*CIVEC(1,3)+XM(2)*CIVEC(2,3)+XM(3)*CIVEC(3,3)
         AKK2=AKX*AKX+AKY*AKY+AKZ*AKZ
         IF(AKK2.LE.AKCUT*AKCUT) THEN
!     CKR=COS(KR)
!     CSKRS=SUM OF OVER J OF COS(K.R[J])*CHG(J)
!     SUM OVER SITES
           CCKRS=0.D0
           DCKRSX=0.D0
           DCKRSY=0.D0
           DCKRSZ=0.D0
           CSKRS=0.D0
           DSKRSX=0.D0
           DSKRSY=0.D0
           DSKRSZ=0.D0
           KDCKRS=0.D0
           KDSKRS=0.D0
           RCCKRSX=0.D0
           RCCKRSY=0.D0
           RCCKRSZ=0.D0

           RKDCKRSX=0.D0
           RKDCKRSY=0.D0
           RKDCKRSZ=0.D0

           RCSKRSX=0.D0
           RCSKRSY=0.D0
           RCSKRSZ=0.D0

           RKDSKRSX=0.D0
           RKDSKRSY=0.D0
           RKDSKRSZ=0.D0
           DO I=1,NMOL
!                    IF(I.EQ.1)I_A=1
              IF(I.GE.1)I_A=3
              DO IA=1,I_A
                 THET=2.D0*PI*(XM(1)*RF(I,IA,1)+XM(2)*RF(I,IA,2)+XM(3)*RF(I,IA,3))
                 CKR(I,IA)=DCOS(THET)
                 SKR(I,IA)=DSIN(THET)
!     INCREMENT SUMS
                 CCKR=CKR(I,IA)*QAT(IA,I)
                 CSKR=SKR(I,IA)*QAT(IA,I)
                 CCKRS=CCKRS+CCKR
                 CSKRS=CSKRS+CSKR
      
                 DCKRSX=DCKRSX+CKR(I,IA)*(DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1))
                 DCKRSY=DCKRSY+CKR(I,IA)*(DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2))
                 DCKRSZ=DCKRSZ+CKR(I,IA)*(DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3))
      
                 DSKRSX=DSKRSX+SKR(I,IA)*(DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1))
                 DSKRSY=DSKRSY+SKR(I,IA)*(DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2))
                 DSKRSZ=DSKRSZ+SKR(I,IA)*(DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3))
               ENDDO            
            ENDDO            
      
!     TAKE DOT PRODUCT OF K WITH THE DIPOLE SUMS
            AKDCKRS=AKX*DCKRSX+AKY*DCKRSY+AKZ*DCKRSZ
            AKDSKRS=AKX*DSKRSX+AKY*DSKRSY+AKZ*DSKRSZ

            AAA=EXP(-AKK2/(4.D0*EWFAC*EWFAC))*(FAC(4)*4.D0*PI)/(VOL*AKK2)
            DDD=-2.D0*AAA*((1.D0/AKK2)+1.D0/(4.D0*EWFAC*EWFAC))
            SUM1=(CCKRS-AKDSKRS)
            SUM2=(CSKRS+AKDCKRS)
      
!     INCREMENT COULOMBIC ENERGY
            QPEC=QPEC+AAA*(SUM1*SUM1+SUM2*SUM2)
            DDD=DDD*(SUM1*SUM1+SUM2*SUM2)
      
!     SUM OVER SITES TO INCREMENT FORCES/FIELDS ETC.
            DO I=1,NMOL
!                     IF(I.EQ.1)I_A=1
               IF(I.GE.1)I_A=3
               DO IA=1,I_A            
                  DJK=(DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1))*AKX+(DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2))*AKY+(DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3))*AKZ
                  SS=SUM1*(-SKR(I,IA)*QAT(IA,I)-CKR(I,IA)*DJK)+SUM2*(-SKR(I,IA)*DJK+CKR(I,IA)*QAT(IA,I))
                  TT=-SKR(I,IA)*CCKRS+CKR(I,IA)*CSKRS
                  VV=SKR(I,IA)*AKDSKRS+CKR(I,IA)*AKDCKRS

!     INCREMENT EFDC
                  IF(ILOOP.EQ.1) THEN
                    EFDC(I,IA,1)=EFDC(I,IA,1)-2.D0*AKX*AAA*TT
                    EFDC(I,IA,2)=EFDC(I,IA,2)-2.D0*AKY*AAA*TT
                    EFDC(I,IA,3)=EFDC(I,IA,3)-2.D0*AKZ*AAA*TT
                  ENDIF

!     INCREMENT EFDD
                  EFDD(I,IA,1)=EFDD(I,IA,1)-2.D0*AKX*AAA*VV
                  EFDD(I,IA,2)=EFDD(I,IA,2)-2.D0*AKY*AAA*VV
                  EFDD(I,IA,3)=EFDD(I,IA,3)-2.D0*AKZ*AAA*VV

                  IF(IFLAG.EQ.1) THEN
!     INCREMENT POTCC
                    POTCC(I,IA)=POTCC(I,IA)+2.D0*AAA*(CKR(I,IA)*CCKRS+SKR(I,IA)*CSKRS)
!     INCREMENT POTCD
                    POTCD(I,IA)=POTCD(I,IA)+2.D0*AAA*(-CKR(I,IA)*AKDSKRS+SKR(I,IA)*AKDCKRS)
!     INCREMENT FORCES
                    FORCE(9*I+3*IA+1-12)=FORCE(9*I+3*IA+1-12)-2.D0*AKX*AAA*SS
                    FORCE(9*I+3*IA+2-12)=FORCE(9*I+3*IA+2-12)-2.D0*AKY*AAA*SS
                    FORCE(9*I+3*IA+3-12)=FORCE(9*I+3*IA+3-12)-2.D0*AKZ*AAA*SS
                  ENDIF      
               ENDDO            
            ENDDO            
!     RECIPROCAL SPACE CUT-OFF ENDIF
         ENDIF
      ENDDO          
   ENDDO          
ENDDO          
END SUBROUTINE EWALD

!  ----- **** ---  !

SUBROUTINE FRACR(IFRAC)

IMPLICIT NONE
DOUBLE PRECISION   :: VV
INTEGER            :: I,IA,I_A,IFRAC,J

!     IF(IFRAC.EQ.0) CONVERTS FRACTIONAL TO CARTESIAN COORDINATES
!     IF(IFRAC.EQ.1) CONVERTS CARTESIAN TO FRACTIONAL COORDINATES
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3

   DO IA=1,I_A
      DO J=1,3  
         IF(IFRAC.EQ.0) THEN
           RAT(9*I+3*IA+J-12)=CVEC(1,J)*RF(I,IA,1)+CVEC(2,J)*RF(I,IA,2)+CVEC(3,J)*RF(I,IA,3)
         ELSE
           RF(I,IA,J)=(CIVEC(J,1)*RAT(9*I+3*IA+1-12)+CIVEC(J,2)*RAT(9*I+3*IA+2-12)+CIVEC(J,3)*RAT(9*I+3*IA+3-12))/(2.*PI)
         ENDIF
      ENDDO
   ENDDO
ENDDO
END SUBROUTINE FRACR

!  ----- **** ---  !

SUBROUTINE RECIP(VOL,VOLI,RC)

IMPLICIT NONE
DOUBLE PRECISION   :: C12MAG,C12X,C12Y,C12Z,C23MAG,C23X,C23Y,C23Z,C31MAG,C31X,C31Y,C31Z,R12,R23,R31,RC,VOL,VOLI
INTEGER            :: J

!COMMON/CONSTANTS/DEBFAC,PI,RCUT
!     THIS SUBROUTINE EVALUATES THE RECIPROCAL VECTORS
!     TO CVEC AND ALSO FINDS THE REAL SPACE CUT-OFF.

!     EVALUATE CROSS PRODUCTS
C12X=CVEC(1,2)*CVEC(2,3)-CVEC(1,3)*CVEC(2,2)
C12Y=CVEC(1,3)*CVEC(2,1)-CVEC(1,1)*CVEC(2,3)
C12Z=CVEC(1,1)*CVEC(2,2)-CVEC(1,2)*CVEC(2,1)
      
C23X=CVEC(2,2)*CVEC(3,3)-CVEC(2,3)*CVEC(3,2)
C23Y=CVEC(2,3)*CVEC(3,1)-CVEC(2,1)*CVEC(3,3)
C23Z=CVEC(2,1)*CVEC(3,2)-CVEC(2,2)*CVEC(3,1)

C31X=CVEC(3,2)*CVEC(1,3)-CVEC(3,3)*CVEC(1,2)
C31Y=CVEC(3,3)*CVEC(1,1)-CVEC(3,1)*CVEC(1,3)
C31Z=CVEC(3,1)*CVEC(1,2)-CVEC(3,2)*CVEC(1,1)

C12MAG=SQRT(C12X*C12X+C12Y*C12Y+C12Z*C12Z)
C23MAG=SQRT(C23X*C23X+C23Y*C23Y+C23Z*C23Z)
C31MAG=SQRT(C31X*C31X+C31Y*C31Y+C31Z*C31Z)

VOL=CVEC(1,1)*C23X+CVEC(1,2)*C23Y+CVEC(1,3)*C23Z
VOLI=1./VOL
   
!     EVALUATE THE RECIPROCAL CELL VECTORS

CIVEC(1,1)=2.D0*PI*C23X*VOLI
CIVEC(1,2)=2.D0*PI*C23Y*VOLI
CIVEC(1,3)=2.D0*PI*C23Z*VOLI
CIVEC(2,1)=2.D0*PI*C31X*VOLI
CIVEC(2,2)=2.D0*PI*C31Y*VOLI
CIVEC(2,3)=2.D0*PI*C31Z*VOLI
      
CIVEC(3,1)=2.D0*PI*C12X*VOLI  
CIVEC(3,2)=2.D0*PI*C12Y*VOLI   
CIVEC(3,3)=2.D0*PI*C12Z*VOLI   
      
!     FIND 3 RADII FOR DETERMINATION OF REAL SPACE CUT-OFF
   
R12=0.5D0*VOL/C12MAG
R23=0.5D0*VOL/C23MAG   
R31=0.5D0*VOL/C31MAG
   
!     THE CUT-OFF IS THE SMALLEST OF THE 3 RADII

RCUT=R12
IF(R23.GE.R12) THEN
   IF(R31.LE.R12) RCUT=R31
ELSE
   RCUT=R23
   IF(R31.LE.R23) RCUT=R31
ENDIF   
END SUBROUTINE RECIP

!  ----- **** ---  !

SUBROUTINE ENERGY(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA)

IMPLICIT NONE
DOUBLE PRECISION   :: UCC,UCD,UCX,UDD,UDX,UINTRA,UPAIR,USPRING,UTOT

CALL REALSUB(UTOT,UPAIR,UCC,UCD,UDD,USPRING,UINTRA,UCX,UDX)
IF(IPDC.EQ.1) THEN
  IF(IFLAG.EQ.1) THEN
!          CALL EWALD
!          CALL SELF
  ENDIF
ENDIF

CALL DDFIELD
IF(IFLAG.EQ.1) CALL DIPFORCE

CALL COULOMB(UCC,UCD,UDD,USPRING)
UTOT=UPAIR+UCC+UCD+UDD+USPRING+UCX+UDX+UINTRA
END SUBROUTINE ENERGY

!  ----- **** ---  !

SUBROUTINE LJ1(RSQI,RR,QPE,GFAC)

IMPLICIT NONE
DOUBLE PRECISION   :: GFAC,QPE,RR,RR10,RR12,RR14,RR16,RR18,RR20,RR6,RR8,RSQI,UTOT

RR6=RSQI**3.D0
RR8=RSQI**4.D0
RR12=RR6*RR6
RR14=RR6*RR8
RR16=RR8*RR8
RR18=RR16*RSQI
RR10=RSQI**5.D0
RR20=RR10*RR10
GFAC=(16.D0*C_16*RR18+14.D0*C_14*RR16+12.D0*C_12*RR14+6.D0*C_6*RR8)
QPE=(C_16*RR16+C_14*RR14+C_12*RR12+C_6*RR6)
END SUBROUTINE LJ1

!  ----- **** ---  !

SUBROUTINE LJ(RSQI,RR,QPE,GFAC)

IMPLICIT NONE
DOUBLE PRECISION   :: GFAC,QPE,RR,RR10,RR12,RR14,RR16,RR18,RR20,RR6,RR8,RSQI

RR6=RSQI**3.0
RR8=RSQI**4.0
RR12=RR6*RR6  
RR14=RR6*RR8 
RR16=RR8*RR8  
RR18=RR16*RSQI
RR10=RSQI**5.0
RR20=RR10*RR10
    
GFAC=(16.D0*C16*RR18+14.D0*C14*RR16+12.D0*C12*RR14+6.D0*C6*RR8)
QPE=(C16*RR16+C14*RR14+C12*RR12+C6*RR6)
END SUBROUTINE LJ

!  ----- **** ---  !

SUBROUTINE DIP2_H2O(R1X,R1Y,R1Z,R2X,R2Y,R2Z,R1MAG,R2MAG,P1,P2,P3,GRADQ)

IMPLICIT NONE
DOUBLE PRECISION   :: C1,C2,C3,C3FACH1,C3FACH2,COSTH,DP1DR1,DP1DR2,DP2DR1,DP2DR2,F1Q1R13,F1Q1R23,F1Q2R13,F1Q2R23,                  &
                      F2Q1R13,F2Q1R23,F2Q2R13,F2Q2R23,FAC1,P1,P2,P3,R0,R1DOTR2,R1MAG,R1R2I,R1X,R1Y,R1Z,R2MAG,R2X,                  &
                      R2Y,R2Z,THETA,THETA0,X1FAC,X2FAC,Y1FAC,Y2FAC,Z1FAC,Z2FAC,X(1,3,3),D(1,3),GRADQ(3,3,3),                       &
                      GRADQT(3,3,3),GRADQR(3,3,3),GRADQCT(3,3,3)

!     GRADQ ARE THE CHARGE GRADIENTS IN CARTESIANS
!     GRADQ(I,J,K) IS THE GRADIENT WITH RESPECT TO THE
!     ITH NUCLEAR COORDINATE OF THE JTH CHARGE IN THE
!     KTH DIRECTION.
!     I=1,2,3=H1,H2,O
!     J=1,2,3=QH1,QH2,QO
!     K=1,2,3=X,Y,Z

R0=0.9572D0
C1= 0.12D0

DP1DR1=C1
DP1DR2=C1
DP2DR1=C1
DP2DR2=C1

!     DETERMINE GRADIENTS OF THE CHARGES

F1Q1R13=(DP1DR1)/R1MAG
F1Q1R23=0.0
F2Q1R23=(DP1DR2)/R2MAG
F2Q1R13=0.0
F1Q2R13=(DP2DR1)/R1MAG
F1Q2R23=0.0
F2Q2R23=(DP2DR2)/R2MAG
F2Q2R13=0.0

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF H1
GRADQR(1,1,1)=F1Q1R13*R1X+F1Q1R23*R2X
GRADQR(1,1,2)=F1Q1R13*R1Y+F1Q1R23*R2Y
GRADQR(1,1,3)=F1Q1R13*R1Z+F1Q1R23*R2Z

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF H2
GRADQR(2,1,1)=F2Q1R13*R1X+F2Q1R23*R2X
GRADQR(2,1,2)=F2Q1R13*R1Y+F2Q1R23*R2Y
GRADQR(2,1,3)=F2Q1R13*R1Z+F2Q1R23*R2Z
     
!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF O
GRADQR(3,1,1)=-(GRADQR(1,1,1)+GRADQR(2,1,1))
GRADQR(3,1,2)=-(GRADQR(1,1,2)+GRADQR(2,1,2))
GRADQR(3,1,3)=-(GRADQR(1,1,3)+GRADQR(2,1,3))
     
!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF H1
GRADQR(1,2,1)=F1Q2R13*R1X+F1Q2R23*R2X
GRADQR(1,2,2)=F1Q2R13*R1Y+F1Q2R23*R2Y
GRADQR(1,2,3)=F1Q2R13*R1Z+F1Q2R23*R2Z

!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF H2
GRADQR(2,2,1)=F2Q2R13*R1X+F2Q2R23*R2X
GRADQR(2,2,2)=F2Q2R13*R1Y+F2Q2R23*R2Y
GRADQR(2,2,3)=F2Q2R13*R1Z+F2Q2R23*R2Z

!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF O
GRADQR(3,2,1)=-(GRADQR(1,2,1)+GRADQR(2,2,1))
GRADQR(3,2,2)=-(GRADQR(1,2,2)+GRADQR(2,2,2))
GRADQR(3,2,3)=-(GRADQR(1,2,3)+GRADQR(2,2,3))
     
!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF H1
GRADQR(1,3,1)=-(GRADQR(1,1,1)+GRADQR(1,2,1))
GRADQR(1,3,2)=-(GRADQR(1,1,2)+GRADQR(1,2,2))
GRADQR(1,3,3)=-(GRADQR(1,1,3)+GRADQR(1,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF H2
GRADQR(2,3,1)=-(GRADQR(2,1,1)+GRADQR(2,2,1))
GRADQR(2,3,2)=-(GRADQR(2,1,2)+GRADQR(2,2,2))
GRADQR(2,3,3)=-(GRADQR(2,1,3)+GRADQR(2,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF O
GRADQR(3,3,1)=-(GRADQR(3,1,1)+GRADQR(3,2,1))
GRADQR(3,3,2)=-(GRADQR(3,1,2)+GRADQR(3,2,2))
GRADQR(3,3,3)=-(GRADQR(3,1,3)+GRADQR(3,2,3))

THETA0=104.52D0*PI/180.00
C2=(0.00473D0*180.D0/PI)*0.D0
R1R2I=(1.D0/(R1MAG*R2MAG))
R1DOTR2=(R1X*R2X+R1Y*R2Y+R1Z*R2Z)
COSTH=(R1DOTR2)*R1R2I
THETA=ACOS(COSTH)
!     WRITE(*,*)R1R2I,COSTH,THETA,PI
FAC1=(C2*R1R2I)/(-SIN(THETA))

X1FAC=(R2X)-(R1DOTR2*R1X/(R1MAG*R1MAG))
Y1FAC=(R2Y)-(R1DOTR2*R1Y/(R1MAG*R1MAG))
Z1FAC=(R2Z)-(R1DOTR2*R1Z/(R1MAG*R1MAG))

X2FAC=(R1X)-(R1DOTR2*R2X/(R2MAG*R2MAG))
Y2FAC=(R1Y)-(R1DOTR2*R2Y/(R2MAG*R2MAG))
Z2FAC=(R1Z)-(R1DOTR2*R2Z/(R2MAG*R2MAG))

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF H1
GRADQT(1,1,1)=FAC1*X1FAC
GRADQT(1,1,2)=FAC1*Y1FAC
GRADQT(1,1,3)=FAC1*Z1FAC

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF H2
GRADQT(2,1,1)=FAC1*X2FAC
GRADQT(2,1,2)=FAC1*Y2FAC
GRADQT(2,1,3)=FAC1*Z2FAC
     
!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF O
GRADQT(3,1,1)=-(GRADQT(1,1,1)+GRADQT(2,1,1))
GRADQT(3,1,2)=-(GRADQT(1,1,2)+GRADQT(2,1,2))
GRADQT(3,1,3)=-(GRADQT(1,1,3)+GRADQT(2,1,3))
     
!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF H1
GRADQT(1,2,1)=GRADQT(1,1,1)
GRADQT(1,2,2)=GRADQT(1,1,2)
GRADQT(1,2,3)=GRADQT(1,1,3)

!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF H2
GRADQT(2,2,1)=GRADQT(2,1,1)
GRADQT(2,2,2)=GRADQT(2,1,2)
GRADQT(2,2,3)=GRADQT(2,1,3)

!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF O
GRADQT(3,2,1)=-(GRADQT(1,2,1)+GRADQT(2,2,1))
GRADQT(3,2,2)=-(GRADQT(1,2,2)+GRADQT(2,2,2))
GRADQT(3,2,3)=-(GRADQT(1,2,3)+GRADQT(2,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF H1
GRADQT(1,3,1)=-(GRADQT(1,1,1)+GRADQT(1,2,1))
GRADQT(1,3,2)=-(GRADQT(1,1,2)+GRADQT(1,2,2))
GRADQT(1,3,3)=-(GRADQT(1,1,3)+GRADQT(1,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF H2
GRADQT(2,3,1)=-(GRADQT(2,1,1)+GRADQT(2,2,1))
GRADQT(2,3,2)=-(GRADQT(2,1,2)+GRADQT(2,2,2))
GRADQT(2,3,3)=-(GRADQT(2,1,3)+GRADQT(2,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF O
GRADQT(3,3,1)=-(GRADQT(3,1,1)+GRADQT(3,2,1))
GRADQT(3,3,2)=-(GRADQT(3,1,2)+GRADQT(3,2,2))
GRADQT(3,3,3)=-(GRADQT(3,1,3)+GRADQT(3,2,3))

C3=-.1360000000D0

DP1DR1 = C3
DP1DR2 = C3
DP2DR1 = C3
DP2DR2 = C3

F1Q1R13=(DP1DR1)/R1MAG
F1Q1R23=0.0
F2Q1R23=(DP1DR2)/R2MAG
F2Q1R13=0.0
F1Q2R13=(DP2DR1)/R1MAG
F1Q2R23=0.0
F2Q2R23=(DP2DR2)/R2MAG
F2Q2R13=0.0

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF H1
GRADQCT(1,1,1)=F1Q1R13*R1X-F1Q1R23*R2X 
GRADQCT(1,1,2)=F1Q1R13*R1Y-F1Q1R23*R2Y 
GRADQCT(1,1,3)=F1Q1R13*R1Z-F1Q1R23*R2Z 

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF H2
GRADQCT(2,1,1)=F2Q1R13*R1X-F2Q1R23*R2X
GRADQCT(2,1,2)=F2Q1R13*R1Y-F2Q1R23*R2Y
GRADQCT(2,1,3)=F2Q1R13*R1Z-F2Q1R23*R2Z

!     GRADIENT OF CHARGE H1 WRT DISPLACEMENT OF O 
GRADQCT(3,1,1)=-(GRADQCT(1,1,1)+GRADQCT(2,1,1))
GRADQCT(3,1,2)=-(GRADQCT(1,1,2)+GRADQCT(2,1,2))
GRADQCT(3,1,3)=-(GRADQCT(1,1,3)+GRADQCT(2,1,3))
     
!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF H1
GRADQCT(1,2,1)=-GRADQCT(1,1,1)
GRADQCT(1,2,2)=-GRADQCT(1,1,2)
GRADQCT(1,2,3)=-GRADQCT(1,1,3)
     
!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF H2
GRADQCT(2,2,1)=-GRADQCT(2,1,1)
GRADQCT(2,2,2)=-GRADQCT(2,1,2)
GRADQCT(2,2,3)=-GRADQCT(2,1,3)

!     GRADIENT OF CHARGE H2 WRT DISPLACEMENT OF O 
GRADQCT(3,2,1)=-GRADQCT(3,1,1)
GRADQCT(3,2,2)=-GRADQCT(3,1,2)
GRADQCT(3,2,3)=-GRADQCT(3,1,3)

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF H1
GRADQCT(1,3,1)=-(GRADQCT(1,1,1)+GRADQCT(1,2,1))
GRADQCT(1,3,2)=-(GRADQCT(1,1,2)+GRADQCT(1,2,2))
GRADQCT(1,3,3)=-(GRADQCT(1,1,3)+GRADQCT(1,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF H2
GRADQCT(2,3,1)=-(GRADQCT(2,1,1)+GRADQCT(2,2,1))
GRADQCT(2,3,2)=-(GRADQCT(2,1,2)+GRADQCT(2,2,2))
GRADQCT(2,3,3)=-(GRADQCT(2,1,3)+GRADQCT(2,2,3))

!     GRADIENT OF CHARGE O WRT DISPLACEMENT OF O 
GRADQCT(3,3,1)=-(GRADQCT(3,1,1)+GRADQCT(3,2,1))
GRADQCT(3,3,2)=-(GRADQCT(3,1,2)+GRADQCT(3,2,2))
GRADQCT(3,3,3)=-(GRADQCT(3,1,3)+GRADQCT(3,2,3))

GRADQ(1,1,1)= GRADQR(1,1,1)+ GRADQT(1,1,1)+ GRADQCT(1,1,1)
GRADQ(1,1,2)= GRADQR(1,1,2)+ GRADQT(1,1,2)+ GRADQCT(1,1,2)
GRADQ(1,1,3)= GRADQR(1,1,3)+ GRADQT(1,1,3)+ GRADQCT(1,1,3)

GRADQ(2,1,1)= GRADQR(2,1,1)+ GRADQT(2,1,1)+ GRADQCT(2,1,1)
GRADQ(2,1,2)= GRADQR(2,1,2)+ GRADQT(2,1,2)+ GRADQCT(2,1,2)
GRADQ(2,1,3)= GRADQR(2,1,3)+ GRADQT(2,1,3)+ GRADQCT(2,1,3)

GRADQ(3,1,1)= GRADQR(3,1,1)+ GRADQT(3,1,1)+ GRADQCT(3,1,1)
GRADQ(3,1,2)= GRADQR(3,1,2)+ GRADQT(3,1,2)+ GRADQCT(3,1,2)
GRADQ(3,1,3)= GRADQR(3,1,3)+ GRADQT(3,1,3)+ GRADQCT(3,1,3)

GRADQ(1,2,1)= GRADQR(1,2,1)+ GRADQT(1,2,1)+ GRADQCT(1,2,1)
GRADQ(1,2,2)= GRADQR(1,2,2)+ GRADQT(1,2,2)+ GRADQCT(1,2,2)
GRADQ(1,2,3)= GRADQR(1,2,3)+ GRADQT(1,2,3)+ GRADQCT(1,2,3)

GRADQ(2,2,1)= GRADQR(2,2,1)+ GRADQT(2,2,1)+ GRADQCT(2,2,1)
GRADQ(2,2,2)= GRADQR(2,2,2)+ GRADQT(2,2,2)+ GRADQCT(2,2,2)
GRADQ(2,2,3)= GRADQR(2,2,3)+ GRADQT(2,2,3)+ GRADQCT(2,2,3)

GRADQ(3,2,1)= GRADQR(3,2,1)+ GRADQT(3,2,1)+ GRADQCT(3,2,1)
GRADQ(3,2,2)= GRADQR(3,2,2)+ GRADQT(3,2,2)+ GRADQCT(3,2,2)
GRADQ(3,2,3)= GRADQR(3,2,3)+ GRADQT(3,2,3)+ GRADQCT(3,2,3)
     
GRADQ(1,3,1)= GRADQR(1,3,1)+ GRADQT(1,3,1)+ GRADQCT(1,3,1)
GRADQ(1,3,2)= GRADQR(1,3,2)+ GRADQT(1,3,2)+ GRADQCT(1,3,2)
GRADQ(1,3,3)= GRADQR(1,3,3)+ GRADQT(1,3,3)+ GRADQCT(1,3,3)

GRADQ(2,3,1)= GRADQR(2,3,1)+ GRADQT(2,3,1)+ GRADQCT(2,3,1)
GRADQ(2,3,2)= GRADQR(2,3,2)+ GRADQT(2,3,2)+ GRADQCT(2,3,2)
GRADQ(2,3,3)= GRADQR(2,3,3)+ GRADQT(2,3,3)+ GRADQCT(2,3,3)

GRADQ(3,3,1)= GRADQR(3,3,1)+ GRADQT(3,3,1)+ GRADQCT(3,3,1)
GRADQ(3,3,2)= GRADQR(3,3,2)+ GRADQT(3,3,2)+ GRADQCT(3,3,2)
GRADQ(3,3,3)= GRADQR(3,3,3)+ GRADQT(3,3,3)+ GRADQCT(3,3,3)
     
C3FACH1=C3*(R1MAG-R2MAG)
C3FACH2=-C3FACH1

P1=0.42D0+C1*(R1MAG+R2MAG-2.*R0)+C2*(THETA-THETA0)+C3FACH1
P2=0.42D0+C1*(R1MAG+R2MAG-2.*R0)+C2*(THETA-THETA0)+C3FACH2

P3=-(P1+P2)

!      WRITE(*,*)P1,P2,P3, (P1+P2+P3)
!      WRITE(*,*)R1MAG,R2MAG

END SUBROUTINE DIP2_H2O

!  ----- **** ---  !

SUBROUTINE DIPFORCE

IMPLICIT NONE
DOUBLE PRECISION   :: E,POTISP1,POTISP2,POTISP3
INTEGER            :: I,IVEC

DO I=1,NMOL
   IF(I_AND.EQ.1)THEN
     POTISP1=POTCC(I,2)+POTCD(I,2)
     POTISP2=POTCC(I,3)+POTCD(I,3)
     POTISP3=POTCC(I,1)+POTCD(I,1)
   ELSE  
     POTISP1=POTCD(I,2)
     POTISP2=POTCD(I,3)
     POTISP3=POTCD(I,1)
   ENDIF

   DO IVEC=1,3
      FORCE(9*I+3*2+IVEC-12)=FORCE(9*I+3*2+IVEC-12)-(FQ(I,1,1,IVEC)*POTISP1+FQ(I,1,2,IVEC)*POTISP2+FQ(I,1,3,IVEC)*POTISP3)
      FORCE(9*I+3*3+IVEC-12)=FORCE(9*I+3*3+IVEC-12)-(FQ(I,2,1,IVEC)*POTISP1+FQ(I,2,2,IVEC)*POTISP2+FQ(I,2,3,IVEC)*POTISP3)
      FORCE(9*I+3*1+IVEC-12)=FORCE(9*I+3*1+IVEC-12)-(FQ(I,3,1,IVEC)*POTISP1+FQ(I,3,2,IVEC)*POTISP2+FQ(I,3,3,IVEC)*POTISP3)
   ENDDO
ENDDO
END SUBROUTINE DIPFORCE

!  ----- **** ---  !

SUBROUTINE DDFIELD

IMPLICIT NONE
DOUBLE PRECISION   :: D,DI1,DI2,DI3,DJ1,DJ2,DJ3,DTENS1,DTENS2,DTENS3,DTENS4,DTENS5,DTENS6
INTEGER            :: I,IA,ISP,I_A,J,JA,JSP,J_A

IF(IPDC.EQ.1) THEN
   IF(IFLAG.NE.1) THEN
!            CALL EWALD
!            CALL SELF
   ENDIF
ENDIF
ISP=0
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IA=1,I_A
      ISP=ISP+1
      JSP=0
      DO J=1,NMOL
!               IF(J.EQ.1)J_A=1
         IF(J.GE.1)J_A=3
         DO JA=1,J_A
            JSP=JSP+1
            IF(JSP.GT.ISP) THEN
               DTENS1=DIPTENS1(I,J,IA,JA)
               DTENS2=DIPTENS2(I,J,IA,JA) 
               DTENS3=DIPTENS3(I,J,IA,JA)
               DTENS4=DIPTENS4(I,J,IA,JA)
               DTENS5=DIPTENS5(I,J,IA,JA)
               DTENS6=DIPTENS6(I,J,IA,JA)
               DI1=DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1)
               DI2=DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2)
               DI3=DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3)
               DJ1=DIPOLE(J,JA,1)+DIPOLE_P(J,JA,1)
               DJ2=DIPOLE(J,JA,2)+DIPOLE_P(J,JA,2)
               DJ3=DIPOLE(J,JA,3)+DIPOLE_P(J,JA,3)
               EFDD(I,IA,1)=EFDD(I,IA,1)+DTENS1*DJ1+DTENS2*DJ2+DTENS3*DJ3
               EFDD(I,IA,2)=EFDD(I,IA,2)+DTENS2*DJ1+DTENS4*DJ2+DTENS5*DJ3
               EFDD(I,IA,3)=EFDD(I,IA,3)+DTENS3*DJ1+DTENS5*DJ2+DTENS6*DJ3
               EFDD(J,JA,1)=EFDD(J,JA,1)+DTENS1*DI1+DTENS2*DI2+DTENS3*DI3
               EFDD(J,JA,2)=EFDD(J,JA,2)+DTENS2*DI1+DTENS4*DI2+DTENS5*DI3
               EFDD(J,JA,3)=EFDD(J,JA,3)+DTENS3*DI1+DTENS5*DI2+DTENS6*DI3
            ENDIF
         ENDDO      
      ENDDO      
   ENDDO      
ENDDO   

ISP=0
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IA=1,I_A
      ISP=ISP+1
      DFORCE(I,IA,1)=-(EFDC(I,IA,1)+EFDD(I,IA,1)+EFEXT(1))+FAC(4)*DIPOLE(I,IA,1)/ALPH(I,IA)
      DFORCE(I,IA,2)=-(EFDC(I,IA,2)+EFDD(I,IA,2)+EFEXT(2))+FAC(4)*DIPOLE(I,IA,2)/ALPH(I,IA)
      DFORCE(I,IA,3)=-(EFDC(I,IA,3)+EFDD(I,IA,3)+EFEXT(3))+FAC(4)*DIPOLE(I,IA,3)/ALPH(I,IA)
   ENDDO
ENDDO
END SUBROUTINE DDFIELD

!  ----- **** ---  !

SUBROUTINE COULOMB(UCC,UCD,UDD,USPRING)

IMPLICIT NONE
DOUBLE PRECISION   :: D2,UCC,UCD,UDC,UDD,USPRING
INTEGER            :: I,IA,I_DIM,I_DIM2,IIA,ISP,I_A,JA,JJA

UCC=0.D0
UCD=0.D0
UDC=0.D0
UDD=0.D0
USPRING=0.D0

ISP=0
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IA=1,I_A
      ISP=ISP+1
      UDC=UDC-0.5D0*((DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1))*EFDC(I,IA,1)+(DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2))*EFDC(I,IA,2)+(DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3))*EFDC(I,IA,3))
      UDD=UDD-0.5D0*((DIPOLE(I,IA,1)+DIPOLE_P(I,IA,1))*EFDD(I,IA,1)+(DIPOLE(I,IA,2)+DIPOLE_P(I,IA,2))*EFDD(I,IA,2)+(DIPOLE(I,IA,3)+DIPOLE_P(I,IA,3))*EFDD(I,IA,3))
      D2=DIPOLE(I,IA,1)*DIPOLE(I,IA,1)+DIPOLE(I,IA,2)*DIPOLE(I,IA,2)+DIPOLE(I,IA,3)*DIPOLE(I,IA,3)
      USPRING=USPRING+FAC(4)*D2/(2.D0*ALPH(I,IA))
      UCC=UCC+0.5D0*QAT(IA,I)*POTCC(I,IA)
      UCD=UCD+0.5D0*QAT(IA,I)*POTCD(I,IA)
   ENDDO
ENDDO

!     UCD AND UDC SHOULD BE EXACTLY THE SAME (WHICH CAN BE CHECKED).
!     THE FIRST IS THE ENERGY OF THE CHARGES IN THE FIELD OF THE DIPOLES
!     AND THE SECOND IS THE ENERGY OF THE DIPOLES IN THE FIELD OF THE
!     CHARGES.  THEY SUM TO GIVE THE TOTAL CHARGE-DIPOLE ENERGY.
UCD=UDC+UCD
DO I=1,NMOL
!         IF(I.EQ.1)I_A=1
   IF(I.GE.1)I_A=3
   DO IA=1,I_A
      IF(IA.EQ.1)IIA=3
      IF(IA.EQ.2)IIA=1
      IF(IA.EQ.3)IIA=2
      DO I_DIM=1,3
         DO JA=1,3
            IF(JA.EQ.1)JJA=3
            IF(JA.EQ.2)JJA=1
            IF(JA.EQ.3)JJA=2
            DO I_DIM2=1,3
               FORCE(9*I+3*IA+I_DIM-12)=FORCE(9*I+3*IA+I_DIM-12)+(EFDC(I,JA,I_DIM2)+EFDD(I,JA,I_DIM2))*(DPDR(I,JJA,IIA,I_DIM2,I_DIM))
            ENDDO
         ENDDO
      ENDDO
   ENDDO
ENDDO
END SUBROUTINE COULOMB

!  ----- **** ---  !

SUBROUTINE SMEAR(RR,RSQ,I,J,IIA,JJA,IA)

IMPLICIT NONE
DOUBLE PRECISION   :: A, AFAC,ALPHAI,ALPHAJ,EXP2A,FM,RR,RR3I,RR4,RR4I,RRI,RSQ,RSQI,PHI(0:3),BBB(0:3)
INTEGER            :: I,IA,II,IIA,J,JJA,M

!     TABULATION OF THE 'SMITH' MULTIPOLE FUNCTIONS
!     FOR SMEARED DIPOLE-DIPOLE, CHARGE-DIPOLE AND CHARGE-CHARGE
!     INTERACTIONS [7]
RSQI=1./RSQ
RR4=RSQ*RSQ
RR3I=RSQI/RR
RR4I=RSQI*RSQI
RRI=RSQI*RR

IF(IPDC.EQ.1) THEN
!     CALCULATE THE 'SMITH' B (ERROR) FUNCTIONS
!     FOR REAL SPACE EWALD SUM.  (I'VE MODIFIED
!     SMITH'S RECURSION TO GIVE -ERF, NOT ERFC FUNCTIONS.)
  A=EWFAC*RR
  BBB(0)=(ERFCC(A)-1.D0)*RRI
  EXP2A=EXP(-A*A)

  DO M=1,3
     FM=FLOAT(M)
     BBB(M)=RSQI*((2.D0*FM-1.D0)*BBB(M-1)+((2.0*EWFAC**2.0)**FM)*SQPII*EXP2A/EWFAC)
  ENDDO
ENDIF

ALPHAI=ALPH(I,IIA)
ALPHAJ=ALPH(J,JJA)

!     CALCULATE THE CHARGE-CHARGE INTERACTIONS
IF(IA.NE.0) THEN
!     I.E. IF THIS IS AN INTERMOLECULAR INTERACTION CALCULATE THE
!     CHARGE-CHARGE INTERACTIONS
  AFAC=0.5D0
  IF(I.EQ.1)AFAC=0.5D0
  CALL THOLESMEAR(PHI,AFAC,ALPHAI,ALPHAJ,RR,RRI,RSQI,RR3I,RR4I,4)

  CHGCHG(0)=PHI(0)
  CHGCHG(1)=-PHI(1)*RRI
  CHGCHG(2)=(PHI(2)-PHI(1)*RRI)*RSQI
  CHGCHG(3)=(3.0*(PHI(1)*RRI-PHI(2))+PHI(3)*RR)*(-RR4I)
ELSE
!     ZERO INTRAMOLECULAR CHARGE-CHARGE INTERACTIONS
  CHGCHG(0)=0.D0
  CHGCHG(1)=0.D0
  CHGCHG(2)=0.D0
  CHGCHG(3)=0.D0
ENDIF

!     CALCULATE THE CHARGE-DIPOLE INTERACTIONS
!     I.E. IF THIS IS AN INTERMOLECULAR INTERACTION OR IF THIS IS POLIR'S MODEL (INTER OR INTRA) CALCULATE THE
!     CHARGE-DIPOLE INTERACTIONS 
AFAC=0.15D0
IF(I.EQ.1)AFAC=0.15D0
!      IF(I.EQ.1)AFAC=0.01D0
IF(IA.EQ.0) THEN
  IF(IIA.EQ.1.AND.JJA.GT.1) AFAC=0.65D0000
    IF(IIA.GT.1.AND.JJA.EQ.1) AFAC=0.65D0000
      IF(IIA.GT.1.AND.JJA.GT.1) AFAC=0.05D0
ENDIF
CALL THOLESMEAR(PHI,AFAC,ALPHAI,ALPHAJ,RR,RRI,RSQI,RR3I,RR4I,4)

CHGDIP(0)=PHI(0)
CHGDIP(1)=-PHI(1)*RRI
CHGDIP(2)=(PHI(2)-PHI(1)*RRI)*RSQI
CHGDIP(3)=(3.0*(PHI(1)*RRI-PHI(2))+PHI(3)*RR)*(-RR4I)

!     CALCULATE THE DIPOLE-DIPOLE INTERACTIONS
AFAC=0.3D0
IF(I.EQ.1)AFAC=0.3D0
!      IF(I.EQ.1)AFAC=0.001D0
IF(IA.EQ.0) THEN
  IF(IIA.EQ.1.AND.JJA.GT.1) AFAC=0.69000D0
  IF(IIA.GT.1.AND.JJA.EQ.1) AFAC=0.69000D0
  IF(IIA.GT.1.AND.JJA.GT.1) AFAC=0.05D0
ENDIF
CALL THOLESMEAR(PHI,AFAC,ALPHAI,ALPHAJ,RR,RRI,RSQI,RR3I,RR4I,4)
DIPDIP(0)=PHI(0)
DIPDIP(1)=-PHI(1)*RRI
DIPDIP(2)=(PHI(2)-PHI(1)*RRI)*RSQI
DIPDIP(3)=(3.0*(PHI(1)*RRI-PHI(2))+PHI(3)*RR)*(-RR4I)

IF(IPDC.EQ.1) THEN
   DO II=0,3
      CHGCHG(II)=CHGCHG(II)+BBB(II)
      CHGDIP(II)=CHGDIP(II)+BBB(II)
      DIPDIP(II)=DIPDIP(II)+BBB(II)
   ENDDO
ENDIF
END SUBROUTINE SMEAR

!  ----- **** ---  !

SUBROUTINE THOLESMEAR(PHI,AFAC,ALPHAI,ALPHAJ,RR,RRI,RSQI,RR3I,RR4I,M)

IMPLICIT NONE
DOUBLE PRECISION   :: AFAC,AFRA4,AIAJ6,ALPHAI,ALPHAJ,CC,EFAC,G34,GAMMCF,GAMSER,GLN,RA,RA4,RR,RR3I,RR4I,               &
                      RRI,RSQI,SSS,X,XM,PHI(0:3)
INTEGER            :: M

!     EVALUATION OF DERIVATIVES OF THE THOLE DAMPING TERM

XM=FLOAT(M)
CC=FLOAT(M-1)/FLOAT(M)
G34=DEXP((GAMMLN(CC)))
AIAJ6=(ALPHAI*ALPHAJ)**(1.D0/6.D0)
SSS=AFAC*AIAJ6
RA=RR/AIAJ6
RA4=RA**XM
AFRA4=AFAC*(RA**XM)
EFAC=EXP(-AFRA4)

PHI(0)=(1.0-EFAC+(AFRA4**(1.0/XM))*GAMMQ(CC,AFRA4)*G34)*RRI
PHI(1)=-RSQI*(1.0-EFAC)
PHI(2)=(-XM*RA4*AFAC*EFAC+2.0*(1.0-EFAC))*RR3I
PHI(3)=(-6.0*(1.0-EFAC)+(5*XM-XM*XM)*AFAC*RA4*EFAC+XM*XM*AFAC*AFAC*RA4*RA4*EFAC)*RR4I
END SUBROUTINE THOLESMEAR

!  ----- **** ---  !

FUNCTION GAMMQ(A,X)

IMPLICIT NONE
DOUBLE PRECISION   :: A,AN,AP,C,D,DEL,GAMMCF,GAMMQ,GAMSER,GLN,H,SUM,X

IF(X.LT.0.D0.OR.A.LE.0.D0) WRITE(MYUNIT,'(A)') 'BAD ARGUMENTS IN GAMMQ'
IF(X.LT.A+1.)THEN
   CALL GSER(GAMSER,A,X,GLN)
   GAMMQ=1.-GAMSER
ELSE
   CALL GCF(GAMMCF,A,X,GLN)
   GAMMQ=GAMMCF
ENDIF
RETURN
END FUNCTION GAMMQ

!  ----- **** ---  !

SUBROUTINE GSER(GAMSER,A,X,GLN)
IMPLICIT NONE
INTEGER            :: ITMAX
REAL*8 A,GAMSER,GLN,X,EPS
PARAMETER (ITMAX=800,EPS=3.E-7)
INTEGER            :: N
REAL*8 AP,DEL,SUM
GLN=GAMMLN(A)
IF(X.LE.0.) THEN
   IF (X.LT.0.) WRITE(MYUNIT,'(A)') 'X < 0 IN GSER'
   GAMSER=0.
   RETURN
ENDIF
AP=A
SUM=1./A
DEL=SUM

N=1
DO WHILE ((ABS(DEL).GE.ABS(SUM)*EPS).AND.(N.LT.ITMAX))
   N=N+1
   AP=AP+1.
   DEL=DEL*X/AP
   SUM=SUM+DEL
ENDDO

IF (N.GE.ITMAX) WRITE(MYUNIT,'(A)')'A TOO LARGE, ITMAX TOO SMALL IN GSER'
GAMSER=SUM*EXP(-X+A*LOG(X)-GLN)

RETURN
END SUBROUTINE GSER

!  ----- **** ---  !

SUBROUTINE GCF(GAMMCF,A,X,GLN)

IMPLICIT NONE
!DOUBLE PRECISION   :: AN,C,D,DEL,GAMMCF,GAMMLN,GLN,H,SER,TMP,X,Y
INTEGER            :: ITMAX
REAL*8 A,GAMMCF,GLN,X,EPS,FPMIN
PARAMETER (ITMAX=100,EPS=3.E-7,FPMIN=1.E-30)
INTEGER            :: I
REAL*8 AN,B,C,D,DEL,H
GLN=GAMMLN(A)
B=X+1.-A
C=1.D0/FPMIN
D=1.D0/B
H=D

DO 11 I=1,ITMAX
   AN=-I*(I-A)
   B=B+2
   D=AN*D+B
   IF(ABS(D).LT.FPMIN)D=FPMIN
   C=B+AN/C
   IF(ABS(C).LT.FPMIN)C=FPMIN
   D=1./D
   DEL=D*C
   H=H*DEL
   IF(ABS(DEL-1.).LT.EPS)GOTO 1
 11   CONTINUE
PAUSE 'A TOO LARGE, ITMAX TOO SMALL IN GCF'
 1    GAMMCF=EXP(-X+A*LOG(X)-GLN)*H

!I=1
!DO WHILE ((ABS(DEL-1.).GE.EPS).AND.(I.LT.ITMAX))
!   I=I+1
!   AN=-I*(I-A)
!   B=B+2
!   D=AN*D+B
!   IF(ABS(D).LT.FPMIN)D=FPMIN
!   C=B+AN/C
!   IF(ABS(C).LT.FPMIN)C=FPMIN
!   D=1./D
!   DEL=D*C
!   H=H*DEL
!ENDDO
! 
!IF(I.GE.ITMAX) WRITE(*,'(A)')'A TOO LARGE, ITMAX TOO SMALL IN GCF'
!GAMMCF=EXP(-X+A*LOG(X)-GLN)*H

RETURN
END SUBROUTINE GCF

!  ----- **** ---  !

FUNCTION GAMMLN(XX)
IMPLICIT NONE
DOUBLE PRECISION   :: CICJ,CIDJR,CJDIR,DFACX,DFACY,DFACZ,DI1,DI2,DI3,DIDJ,DIR,DIRDJR,DJ1,DJ2,DJ3,DJR,ECC,ECD,EDD,                  &
                      FDCFACI,FDCFACJ,GAMMLN,GCFAC,RIRJ,SER,TMP,X,XX,Y
INTEGER            :: J

X=XX
Y=X
TMP=X+5.5D0
TMP=(X+0.5D0)*LOG(TMP)-TMP
SER=1.000000000190015D0
DO J=1,6
   Y=Y+1.D0
   SER=SER+COF(J)/Y
ENDDO
GAMMLN=TMP+LOG(STP*SER/X)
RETURN
END FUNCTION GAMMLN

!  ----- **** ---  !

SUBROUTINE FIELD(I,J,IIA,JJA,IA,XDIF,YDIF,ZDIF,RR,GCFAC,DFACX,DFACY,DFACZ,ECC,ECD,EDD)

IMPLICIT NONE
DOUBLE PRECISION   :: CICJ,CIDJR,CJDIR,DFACX,DFACY,DFACZ,DI1,DI2,DI3,DIDJ,DIR,DIRDJR,DJ1,DJ2,DJ3,DJR,ECC,ECD,EDD,ERF,              &
                      ERFCC,FDCFACI,FDCFACJ,GCFAC,RIRJ,RR,T,XDIF,YDIF,Z,ZDIF
INTEGER            :: I,IA,IIA,J,JJA

!     FOR PERIODIC BOUNDARY CONDITIONS, ALL INTERACTIONS ALL COUNTED
IF(IPDC.EQ.1) IA=1
DI1=DIPOLE(I,IIA,1)+DIPOLE_P(I,IIA,1)
DI2=DIPOLE(I,IIA,2)+DIPOLE_P(I,IIA,2)
DI3=DIPOLE(I,IIA,3)+DIPOLE_P(I,IIA,3)
DJ1=DIPOLE(J,JJA,1)+DIPOLE_P(J,JJA,1)
DJ2=DIPOLE(J,JJA,2)+DIPOLE_P(J,JJA,2)
DJ3=DIPOLE(J,JJA,3)+DIPOLE_P(J,JJA,3)
DIR=DI1*XDIF+DI2*YDIF+DI3*ZDIF
DJR=DJ1*XDIF+DJ2*YDIF+DJ3*ZDIF
DIDJ=DI1*DJ1+DI2*DJ2+DI3*DJ3
DIRDJR=DIR*DJR
CIDJR=QAT(IIA,I)*DJR
CJDIR=QAT(JJA,J)*DIR
CICJ=QAT(IIA,I)*QAT(JJA,J)

ECC=CHGCHG(0)*CICJ*FAC(4)
ECD=CHGDIP(1)*(CIDJR-CJDIR)*FAC(4)
EDD=(DIPDIP(1)*DIDJ-DIPDIP(2)*DIRDJR)*FAC(4)
GCFAC=(CHGCHG(1)*CICJ+DIPDIP(2)*DIDJ+CHGDIP(2)*(CIDJR-CJDIR)-DIPDIP(3)*DIRDJR)*FAC(4)
IF(ILOOP.EQ.1) THEN
!     FOR INTERMOLECULAR INTERACTIONS- OR FOR POLIR'S MODEL- EVALUATE DIPOLE-CHARGE FIELD
  FDCFACJ=CHGDIP(1)*QAT(IIA,I)*FAC(4)
  FDCFACI=CHGDIP(1)*QAT(JJA,J)*FAC(4)
  EFDC(J,JJA,1)=EFDC(J,JJA,1)-(FDCFACJ)*XDIF
  EFDC(J,JJA,2)=EFDC(J,JJA,2)-(FDCFACJ)*YDIF
  EFDC(J,JJA,3)=EFDC(J,JJA,3)-(FDCFACJ)*ZDIF
  EFDC(I,IIA,1)=EFDC(I,IIA,1)+(FDCFACI)*XDIF
  EFDC(I,IIA,2)=EFDC(I,IIA,2)+(FDCFACI)*YDIF
  EFDC(I,IIA,3)=EFDC(I,IIA,3)+(FDCFACI)*ZDIF
ENDIF

!     EVALUATE THE POTENTIAL OF THE CHARGE FROM THE OTHER
!     CHARGES AND DIPOLES
POT(I,IIA)=POT(I,IIA)+(QAT(JJA,J)*CHGCHG(0)+DJR*CHGDIP(1))*FAC(4)
POT(J,JJA)=POT(J,JJA)+(QAT(IIA,I)*CHGCHG(0)-DIR*CHGDIP(1))*FAC(4)
POTCC(I,IIA)=POTCC(I,IIA)+QAT(JJA,J)*CHGCHG(0)*FAC(4)
POTCC(J,JJA)=POTCC(J,JJA)+QAT(IIA,I)*CHGCHG(0)*FAC(4)
POTCD(I,IIA)=POTCD(I,IIA)+DJR*CHGDIP(1)*FAC(4)
POTCD(J,JJA)=POTCD(J,JJA)-DIR*CHGDIP(1)*FAC(4)

DFACX=((QAT(JJA,J)*DI1-QAT(IIA,I)*DJ1)*CHGDIP(1)+(DJR*DI1+DIR*DJ1)*DIPDIP(2))*FAC(4)
DFACY=((QAT(JJA,J)*DI2-QAT(IIA,I)*DJ2)*CHGDIP(1)+(DJR*DI2+DIR*DJ2)*DIPDIP(2))*FAC(4)
DFACZ=((QAT(JJA,J)*DI3-QAT(IIA,I)*DJ3)*CHGDIP(1)+(DJR*DI3+DIR*DJ3)*DIPDIP(2))*FAC(4)

RIRJ=XDIF*XDIF
DIPTENS1(I,J,IIA,JJA)=FAC(4)*(RIRJ*DIPDIP(2)-DIPDIP(1))
RIRJ=XDIF*YDIF
DIPTENS2(I,J,IIA,JJA)=FAC(4)*(RIRJ*DIPDIP(2))
RIRJ=XDIF*ZDIF
DIPTENS3(I,J,IIA,JJA)=FAC(4)*(RIRJ*DIPDIP(2))
RIRJ=YDIF*YDIF
DIPTENS4(I,J,IIA,JJA)=FAC(4)*(RIRJ*DIPDIP(2)-DIPDIP(1))
RIRJ=YDIF*ZDIF
DIPTENS5(I,J,IIA,JJA)=FAC(4)*(RIRJ*DIPDIP(2))
RIRJ=ZDIF*ZDIF
DIPTENS6(I,J,IIA,JJA)=FAC(4)*(RIRJ*DIPDIP(2)-DIPDIP(1))
END SUBROUTINE FIELD

!  ----- **** ---  !

FUNCTION ERFCC(X)

IMPLICIT NONE
DOUBLE PRECISION   :: ERFCC,T,X,Z

Z=DABS(X)
T=1.D0/(1.+0.5D0*Z)
ERFCC=T*EXP(-Z*Z-1.26551223D0+T*(1.00002368D0+T*(.37409196D0+T*(.09678418D0+T*(-.18628806D0+T*(.27886807D0+                        &
            T*(-1.13520398D0+T*(1.48851587D0+T*(-0.82215223D0+T*.17087277D0)))))))))
IF(X.LT.0.D0) ERFCC=2.D0-ERFCC
RETURN
END FUNCTION ERFCC

!  ----- **** ---  !

FUNCTION ERF(X)

IMPLICIT NONE
DOUBLE PRECISION   :: ERF,X

IF(X.LT.0.) THEN
   ERF=1.+GAMMQ(5.D-1,X**2)
ELSE
   ERF=1.-GAMMQ(5.D-1,X**2)
ENDIF
RETURN
END FUNCTION ERF

!  ----- **** ---  !

END MODULE POLIRMOD
