SUBROUTINE PERCSPHERE(P,NATOMS,PERCCUT,PERCT)

  USE COMMONS, ONLY : GThomsonSigma
  IMPLICIT NONE

  INTEGER NATOMS, NSITES, J1, J2, J3, JCLUST, JR1, JR2
  INTEGER, ALLOCATABLE :: NDIST1(:), JCENTRE(:)
  DOUBLE PRECISION, ALLOCATABLE :: COM(:,:)
  DOUBLE PRECISION P(3*NATOMS), PERCCUT, DUMMY, DMIN, THETA
  DOUBLE PRECISION ROTVEC(3), RMI(3,3), DRMI(3,3), TEMP(3)
  LOGICAL PERCT, CHANGED, NEWT, SINGLET
  LOGICAL, ALLOCATABLE :: CON(:,:)

  NSITES = NATOMS

  ALLOCATE(NDIST1(NSITES), JCENTRE(NSITES), CON(NSITES,NSITES))
  ALLOCATE(COM(NSITES,3))
  NDIST1(:) = 0
  JCENTRE(:) = 0
  COM(:,:) = 0.0D0

  CON(1:NSITES,1:NSITES)=.FALSE.
  DO J1=1,NSITES
    DO J2=J1+1,NSITES
      DUMMY=(P(3*(J2-1)+1)-P(3*(J1-1)+1))**2+(P(3*(J2-1)+2)-P(3*(J1-1)+2))**2+(P(3*(J2-1)+3)-P(3*(J1-1)+3))**2
      IF (DUMMY.LT.PERCCUT**2) THEN
        CON(J2,J1)=.TRUE.
        CON(J1,J2)=.TRUE.
      ENDIF
    ENDDO
  ENDDO

  J1 = 1
  JCLUST = 0

10 JCLUST = JCLUST + 1
5 CHANGED=.FALSE.
  DO J2=1, NSITES
     IF (CON(J1,J2)) THEN
        DO J3 = 1, NSITES
           IF (CON(J2,J3)) THEN
              IF (CON(J1,J3).EQV..FALSE.) THEN
                 CON(J1,J3) = .TRUE.
                 CON(J3,J1) = .TRUE.
                 CHANGED = .TRUE.
              ENDIF
           ENDIF
        ENDDO
     ENDIF
  ENDDO
  IF (CHANGED) GOTO 5

  NDIST1(JCLUST) = 0
  SINGLET = .TRUE.
  DO J2 = 1, NSITES
     IF(CON(J1,J2)) THEN
        NDIST1(JCLUST) = NDIST1(JCLUST) + 1
        SINGLET = .FALSE.
     ENDIF
  ENDDO
  IF (SINGLET) THEN
     NDIST1(JCLUST) = NDIST1(JCLUST) + 1
     CON(J1,J1) = .TRUE.
  ENDIF
  JCENTRE(JCLUST) = J1

  NEWT = .FALSE.
  DO J3 = 1, NSITES
     IF (CON(J1,J3) .EQV. .FALSE.) THEN
        NEWT = .TRUE.
        DO J2 = 1, JCLUST
           IF (CON(J3,JCENTRE(J2))) THEN
              NEWT = .FALSE.
           ENDIF
        ENDDO
        IF (NEWT) THEN
           J1 = J3
           IF (JCLUST < NSITES) THEN
              GOTO 10
           ENDIF
        ENDIF
     ENDIF
  ENDDO

  IF (JCLUST .EQ. 1) THEN
     PERCT = .TRUE.
  ELSE
     PERCT = .FALSE.
     DO J3 = 2, JCLUST
        DMIN = 1.0D10
        DO J1 = 1, NSITES
           DO J2 = 1, NSITES
              IF (CON(JCENTRE(1),J1) .AND. CON(JCENTRE(J3),J2) ) THEN
                 DUMMY=(P(3*(J2-1)+1)-P(3*(J1-1)+1))**2+(P(3*(J2-1)+2)-P(3*(J1-1)+2))**2+(P(3*(J2-1)+3)-P(3*(J1-1)+3))**2
                 IF (DUMMY < DMIN) THEN
                    JR1 = J1
                    JR2 = J2
                 ENDIF
              ENDIF
           ENDDO
        ENDDO

        THETA = DOT_PRODUCT(P(3*JR1-2:3*JR1),P(3*JR2-2:3*JR2))
        DUMMY = DOT_PRODUCT(P(3*JR1-2:3*JR1),P(3*JR1-2:3*JR1))
        THETA = THETA / DSQRT(DUMMY)
        DUMMY = DOT_PRODUCT(P(3*JR2-2:3*JR2),P(3*JR2-2:3*JR2))
        THETA = THETA / DSQRT(DUMMY)
        THETA = ACOS(THETA)

        ROTVEC(1) = P(3*JR1-1) * P(3*JR2)   - P(3*JR2-1) * P(3*JR1)
        ROTVEC(2) = P(3*JR1)   * P(3*JR2-2) - P(3*JR2)   * P(3*JR1-2)
        ROTVEC(3) = P(3*JR1-2) * P(3*JR2-1) - P(3*JR2-2) * P(3*JR1-1)
        DUMMY = DOT_PRODUCT(ROTVEC,ROTVEC)
        ROTVEC = THETA * ROTVEC / DSQRT(DUMMY)

        CALL RMDRVT(ROTVEC, RMI, DRMI, DRMI, DRMI, .FALSE.)
        TEMP = MATMUL(RMI,P(3*J2-2:3*J2))
        DUMMY=(TEMP(3*J2-2)-P(3*J1-2))**2+(TEMP(3*J2-1)-P(3*J1-1))**2+(TEMP(3*J2)-P(3*J1))**2
        IF (DUMMY > PERCCUT) THEN
           ROTVEC = -1.0D0 * ROTVEC
        ENDIF
        ROTVEC = ROTVEC * 0.975D0
        CALL RMDRVT(ROTVEC, RMI, DRMI, DRMI, DRMI, .FALSE.)

        DO J2 = 1, NSITES
           IF ( CON(JCENTRE(J3),J2) ) THEN
              P(3*J2-2:3*J2) = MATMUL(RMI,P(3*J2-2:3*J2))
           ENDIF
        ENDDO
     ENDDO
  ENDIF

  DEALLOCATE(NDIST1, JCENTRE, CON)
  DEALLOCATE(COM)

END SUBROUTINE PERCSPHERE
