! This subroutine is to select whether we are to minimise in rigid body/atom coordinates
! ATOMRIGIDCOORDT is the toggling logical variable
      SUBROUTINE MYLBFGS(N,M,XCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET, NP)

      USE COMMONS, ONLY : NATOMS, DMACRYST, EPSRIGID, HYBRIDMINT, DEBUG, MYUNIT, MAXBFGS, AMBER12T
      USE GENRIGID
      USE MODCUDALBFGS

      IMPLICIT NONE

      INTEGER :: N,M,ITMAX,ITDONE,NP
      DOUBLE PRECISION :: XCOORDS(3*NATOMS), EPS, ENERGY
      LOGICAL :: DIAGCO, RESET, MFLAG, EVAP
      
      INTEGER :: TEMPNATOMS, TEMPN
      DOUBLE PRECISION :: XRIGIDCOORDS(DEGFREEDOMS)
      COMMON /EV/ EVAP

      ! vr274> DMACRYS uses a different minimization potocol to avoid cold fusions
      IF(DMACRYST) THEN
        CALL DMACRYS_MINIMIZE(N,M,XCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET, NP)
        RETURN
      ENDIF

! hk286 > if generalised rigid body is used, then use rigid coords, otherwise proceed as usual
! hk286 > When passing rigid coords, pass zeroes from (DEGFREEDOMS+1:3*NATOMS)
! hk286 > mymylbfgs is the old mylbfgs

      IF (RIGIDINIT) THEN
         ATOMRIGIDCOORDT = .FALSE.
         CALL TRANSFORMCTORIGID(XCOORDS, XRIGIDCOORDS)
         XCOORDS(1:DEGFREEDOMS) = XRIGIDCOORDS(1:DEGFREEDOMS)
         XCOORDS(DEGFREEDOMS+1:3*NATOMS) = 0.0D0
! csw34> If HYBRIDMIN used, we want to minimise to EPSRIGID using rigid coords and then to EPS
!        using atomic coordinates
         IF (HYBRIDMINT) THEN
! CMake has some problems with '#elseif' statements in fortran 77 pre-processed files (*.F)
! #ifdef/#ifndef paired with #endif are safe to use
#ifdef CUDA
! Call to CUDA LBFGS for rigid minimisation to tolerance epsrigid before the atomistic minimisation
            IF (.NOT. (AMBER12T)) THEN
                CALL RADCOM(XCOORDS, .TRUE.) ! Evaporated atoms moved back in
            END IF
            CALL CUDA_WRAPPER(N,XCOORDS,EPSRIGID,MFLAG,ENERGY,ITMAX,ITDONE)
            IF (.NOT. (AMBER12T)) THEN
                EVAP=.FALSE.
                CALL RADCOM(XCOORDS, .FALSE.) ! Evaporated atoms NOT moved back in
                IF (EVAP) THEN
                   MFLAG=.FALSE.
                END IF
            END IF
#endif
#ifndef CUDA
            CALL MYMYLBFGS(N,M,XCOORDS,DIAGCO,EPSRIGID,MFLAG,ENERGY,ITMAX,ITDONE,RESET,NP)
#endif
            IF (DEBUG) WRITE(MYUNIT,'(A)') ' HYBRIDMIN> Rigid body minimisation converged, switching to all-atom'
         ELSE
#ifdef CUDA
! Call to CUDA LBFGS for rigid minimisation
            IF (.NOT. (AMBER12T)) THEN
                CALL RADCOM(XCOORDS, .TRUE.) ! Evaporated atoms moved back in
            END IF
            CALL CUDA_WRAPPER(N,XCOORDS,EPS,MFLAG,ENERGY,ITMAX,ITDONE)
            IF (.NOT. (AMBER12T)) THEN
                EVAP=.FALSE.
                CALL RADCOM(XCOORDS, .FALSE.) ! Evaporated atoms NOT moved back in
                IF (EVAP) THEN
                   MFLAG=.FALSE.
                END IF
            END IF
#endif
#ifndef CUDA
            CALL MYMYLBFGS(N,M,XCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET,NP)
#endif
         ENDIF
         XRIGIDCOORDS(1:DEGFREEDOMS) = XCOORDS(1:DEGFREEDOMS)
         CALL TRANSFORMRIGIDTOC(1,NRIGIDBODY, XCOORDS, XRIGIDCOORDS)
         ATOMRIGIDCOORDT = .TRUE.
! csw34> Now continue to minimise using atomic coordinates
         IF (HYBRIDMINT) THEN
#ifdef CUDA
! Call to CUDA LBFGS for atomistic minimisation after the rigid minimisation
            IF (.NOT. (AMBER12T)) THEN
                CALL RADCOM(XCOORDS, .TRUE.) ! Evaporated atoms moved back in
            END IF
            CALL CUDA_WRAPPER(N,XCOORDS,EPS,MFLAG,ENERGY,ITMAX,ITDONE)
            IF (.NOT. (AMBER12T)) THEN
                EVAP=.FALSE.
                CALL RADCOM(XCOORDS, .FALSE.) ! Evaporated atoms NOT moved back in
                IF (EVAP) THEN
                   MFLAG=.FALSE.
                END IF
            END IF
#endif
#ifndef CUDA
            CALL MYMYLBFGS(N,M,XCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET,NP)
#endif
         ENDIF
      ELSE
            ATOMRIGIDCOORDT = .TRUE.
#ifdef CUDA
! Call to CUDA LBFGS for atomistic minimisation
            IF (.NOT. (AMBER12T)) THEN
                CALL RADCOM(XCOORDS, .TRUE.) ! Evaporated atoms moved back in
            END IF
            CALL CUDA_WRAPPER(N,XCOORDS,EPS,MFLAG,ENERGY,ITMAX,ITDONE)
            IF (.NOT. (AMBER12T)) THEN
                EVAP=.FALSE.
                CALL RADCOM(XCOORDS, .FALSE.) ! Evaporated atoms NOT moved back in
                IF (EVAP) THEN
                   MFLAG=.FALSE.
                END IF
            END IF
#endif
#ifndef CUDA
            CALL MYMYLBFGS(N,M,XCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET,NP)
#endif
      ENDIF

! hk286 - alternative implementation, fool mymylbfgs the number of atoms rather than passing zeroes
!      IF (RIGIDINIT) THEN
!         ATOMRIGIDCOORDT = .FALSE.
!         CALL TRANSFORMCTORIGID(XCOORDS, XRIGIDCOORDS)
!         TEMPN = N
!         N = DEGFREEDOMS
!         TEMPNATOMS = NATOMS
!         NATOMS  = DEGFREEDOMS / 3
!         CALL MYMYLBFGS(N,M,XRIGIDCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET,NP,TEMPNATOMS)
!         NATOMS = TEMPNATOMS
!         N = TEMPN
!         CALL TRANSFORMRIGIDTOC(1,NRIGIDBODY, XCOORDS, XRIGIDCOORDS)
!         ATOMRIGIDCOORDT = .TRUE.      
!      ELSE
!         ATOMRIGIDCOORDT = .TRUE.
!        CALL MYMYLBFGS(N,M,XCOORDS,DIAGCO,EPS,MFLAG,ENERGY,ITMAX,ITDONE,RESET,NP)
!      ENDIF
! hk286
         
      END SUBROUTINE MYLBFGS
