MODULE MODCUDALBFGS

USE COMMONS, ONLY : RMS, DEBUG, CUDATIMET, MAXBFGS, MAXERISE, CUDAPOT, NPCALL, COLDFUSION, COLDFUSIONLIMIT, MYUNIT, DGUESS, MUPDATE
USE GENRIGID, ONLY : ATOMRIGIDCOORDT, DEGFREEDOMS, NRIGIDBODY, NSITEPERBODY, RIGIDGROUPS, MAXSITE, SITESRIGIDBODY, RIGIDSINGLES

USE, INTRINSIC :: ISO_C_BINDING, ONLY: C_PTR, C_INT, C_DOUBLE, C_BOOL, C_CHAR

IMPLICIT NONE

INTERFACE
    SUBROUTINE CUDALBFGS(N,C_XCOORDS,EPS,C_MFLAG,C_ENERGY,ITMAX,C_ITDONE,C_MAXBFGS,C_MAXERISE,C_RMS,C_CUDAPOT, & 
                         C_DEBUG,C_CUDATIMET, ECALLS, C_ATOMRIGIDCOORDT, C_DEGFREEDOMS, C_NRIGIDBODY, C_NSITEPERBODY, &
                         C_RIGIDGROUPS, C_MAXSITE, C_SITESRIGIDBODY, C_RIGIDSINGLES, C_COLDFUSION, C_COLDFUSIONLIMIT, &
                         C_DGUESS, C_MUPDATE) BIND(C,NAME="cuda_setup")
        IMPORT :: C_INT, C_DOUBLE, C_BOOL, C_CHAR
        INTEGER(KIND=C_INT), INTENT(IN) :: N, ITMAX, C_DEGFREEDOMS, C_NRIGIDBODY, C_MAXSITE, C_MUPDATE ! 3*natoms / ndim, max. no. iterations for quench, no. degrees of freedom for rigid body framework, max. no. of sites in a rigid body
        INTEGER(KIND=C_INT), INTENT(OUT) :: C_ITDONE, ECALLS ! Count of iterations of LBFGS for a particular minimisation
        INTEGER(KIND=C_INT), DIMENSION(C_NRIGIDBODY), INTENT(IN) :: C_NSITEPERBODY ! No. of rigid body sites
        INTEGER(KIND=C_INT), DIMENSION(C_MAXSITE * C_NRIGIDBODY), INTENT(IN) :: C_RIGIDGROUPS ! List of atoms in rigid bodies
        INTEGER(KIND=C_INT), DIMENSION(C_DEGFREEDOMS/3 - 2*C_NRIGIDBODY), INTENT(IN) :: C_RIGIDSINGLES ! List of atoms not in rigid bodies
        REAL(KIND=C_DOUBLE), INTENT(IN) :: EPS, C_MAXBFGS, C_MAXERISE, C_COLDFUSIONLIMIT, C_DGUESS ! Convergence tolerance for RMS force, max. step size for LBFGS, max. energy rise for LBFGS, limit below which cold fusion is diagnosed and minimisation terminated, initial guess for inverse Hessian diagonal elements
        REAL(KIND=C_DOUBLE), INTENT(OUT) :: C_ENERGY, C_RMS ! Energy, RMS force
        REAL(KIND=C_DOUBLE), DIMENSION(N), INTENT(INOUT) :: C_XCOORDS ! Coordinates
        REAL(KIND=C_DOUBLE), DIMENSION(C_MAXSITE * 3 * C_NRIGIDBODY), INTENT(IN) :: C_SITESRIGIDBODY ! Coordinates of the rigid body sites
        LOGICAL(KIND=C_BOOL), INTENT(IN) :: C_DEBUG, C_CUDATIMET, C_ATOMRIGIDCOORDT ! If true, print debug info.,  timing info. or minimise with atomistic (rather than rigid body) coordinates respectively
        LOGICAL(KIND=C_BOOL), INTENT(OUT) :: C_MFLAG ! Convergence test, false if quench did not converge
        LOGICAL(KIND=C_BOOL), INTENT(INOUT) :: C_COLDFUSION ! Set to true during minimisation if cold fusion diagnosed
        CHARACTER(LEN=1, KIND=C_CHAR), INTENT(IN) :: C_CUDAPOT ! Character specifying the CUDA potential to be used
    END SUBROUTINE CUDALBFGS
END INTERFACE

CONTAINS

    SUBROUTINE CUDA_WRAPPER(N,XCOORDS,EPS,MFLAG,ENERGY,ITMAX,ITDONE)
        ! Variables passed as *arguments through this wrapper* (not common) with intent in for CUDALBFGS are converted directly
        CHARACTER(LEN=1, KIND=C_CHAR) :: C_CUDAPOT
        INTEGER(KIND=C_INT) :: N, ITMAX, C_ITDONE, ECALLS, C_DEGFREEDOMS, C_NRIGIDBODY, C_MAXSITE, C_MUPDATE
        INTEGER(KIND=C_INT), DIMENSION(NRIGIDBODY) :: C_NSITEPERBODY
        INTEGER(KIND=C_INT), DIMENSION(MAXSITE * NRIGIDBODY) :: C_RIGIDGROUPS
        INTEGER(KIND=C_INT), DIMENSION(DEGFREEDOMS/3 - 2*NRIGIDBODY) :: C_RIGIDSINGLES
        REAL(KIND=C_DOUBLE), DIMENSION(N) :: C_XCOORDS
        REAL(KIND=C_DOUBLE) :: EPS, C_MAXBFGS, C_MAXERISE, C_ENERGY, C_RMS, C_COLDFUSIONLIMIT, C_DGUESS
        REAL(KIND=C_DOUBLE), DIMENSION(MAXSITE * 3 * NRIGIDBODY) :: C_SITESRIGIDBODY
        LOGICAL(KIND=C_BOOL) :: C_MFLAG, C_DEBUG, C_CUDATIMET, C_ATOMRIGIDCOORDT, C_COLDFUSION

        ! Variables passed as *arguments through this wrapper* (not common) with intent out for CUDALBFGS are not passed into it
        ! Therefore uninitialised C types are passed in and converted types are copied back after the call
        INTEGER :: I, J, K, ITDONE ! I, J and K are only used locally
        DOUBLE PRECISION :: ENERGY, POTEL
        DOUBLE PRECISION, DIMENSION(N) :: XCOORDS
        LOGICAL :: MFLAG

        COMMON /MYPOT/ POTEL

        DO I = 1,N
            C_XCOORDS(I) = XCOORDS(I)
        END DO

        ! Variables from *commons* with intent in or inout are copied into C types

        DO K = 1,NRIGIDBODY
            DO J = 1,3
                DO I = 1,MAXSITE
                     C_SITESRIGIDBODY((K - 1)*3*MAXSITE + (J - 1)*MAXSITE + I) = SITESRIGIDBODY(I,J,K)
                END DO
            END DO
        END DO

        DO J = 1,NRIGIDBODY
            DO I = 1,MAXSITE
                C_RIGIDGROUPS((J - 1)*MAXSITE + I) = RIGIDGROUPS(I,J)
            END DO
        END DO

        DO I = 1,NRIGIDBODY
            C_NSITEPERBODY(I) = NSITEPERBODY(I)
        END DO

        DO I = 1,(DEGFREEDOMS/3 - 2*NRIGIDBODY)
            C_RIGIDSINGLES(I) = RIGIDSINGLES(I)
        END DO

        C_CUDAPOT = CUDAPOT
        C_DEBUG = DEBUG
        C_CUDATIMET = CUDATIMET
        C_MAXBFGS = MAXBFGS
        C_MAXERISE = MAXERISE
        C_ATOMRIGIDCOORDT = ATOMRIGIDCOORDT
        C_DEGFREEDOMS = DEGFREEDOMS
        C_NRIGIDBODY = NRIGIDBODY
        C_MAXSITE = MAXSITE
        C_COLDFUSION = .FALSE. ! Set to false here rather than COLDFUSION as it should definitely be false at this point
        C_COLDFUSIONLIMIT = COLDFUSIONLIMIT
        C_DGUESS = DGUESS
        C_MUPDATE = MUPDATE

        ! 'C_' prefix denotes those variables which have intent out or inout or are copies of those from commons
        CALL CUDALBFGS(N,C_XCOORDS,EPS,C_MFLAG,C_ENERGY,ITMAX,C_ITDONE,C_MAXBFGS,C_MAXERISE,C_RMS,C_CUDAPOT, & 
                       C_DEBUG,C_CUDATIMET, ECALLS, C_ATOMRIGIDCOORDT, C_DEGFREEDOMS, C_NRIGIDBODY, &
                       C_NSITEPERBODY, C_RIGIDGROUPS, C_MAXSITE, C_SITESRIGIDBODY, C_RIGIDSINGLES, C_COLDFUSION, &
                       C_COLDFUSIONLIMIT, C_DGUESS, C_MUPDATE)

        ! Make sure C types with intent out or inout are coverted back to fortran ones
        ENERGY = DBLE(C_ENERGY)
        RMS = DBLE(C_RMS)
        MFLAG = LOGICAL(C_MFLAG)
        ITDONE = INT(C_ITDONE)
        COLDFUSION = LOGICAL(C_COLDFUSION)
        DO I = 1,N
            XCOORDS(I) = DBLE(C_XCOORDS(I))
        END DO

        IF (COLDFUSION) THEN
            WRITE(MYUNIT,'(A,G20.10)') 'ENERGY=',ENERGY
            WRITE(MYUNIT,'(A,2G20.10)') ' Cold fusion diagnosed - step discarded; energy and threshold=',ENERGY,COLDFUSIONLIMIT
            ENERGY=1.0D6
            POTEL=1.0D6
            RMS=1.0D0
        END IF

        NPCALL = NPCALL + INT(ECALLS)

    END SUBROUTINE CUDA_WRAPPER

END MODULE MODCUDALBFGS
