      SUBROUTINE MASSWT(HESS)

      USE COMMONS, ONLY: NATOMS, ATMASS

      IMPLICIT NONE

      INTEGER :: J1, J2, J3, J4
      DOUBLE PRECISION :: AMASS, BMASS, FMASS, HESS(3*NATOMS,3*NATOMS)

      DO J1 = 1, NATOMS
         J3 = 3*J1
         AMASS = 1.D0/SQRT(ATMASS(J1))
         DO J2 = J1, NATOMS
            J4 = 3*J2
            BMASS = 1.D0/SQRT(ATMASS(J2))
            FMASS = AMASS*BMASS
            IF (J1 == J2) THEN
               HESS(J3-2,J4-2) = FMASS*HESS(J3-2,J4-2)
               HESS(J3-2,J4-1) = FMASS*HESS(J3-2,J4-1)
               HESS(J3-2,J4)   = FMASS*HESS(J3-2,J4)
               HESS(J3-1,J4-2) = FMASS*HESS(J3-1,J4-2)
               HESS(J3-1,J4-1) = FMASS*HESS(J3-1,J4-1)
               HESS(J3-1,J4)   = FMASS*HESS(J3-1,J4)
               HESS(J3,  J4-2) = FMASS*HESS(J3,  J4-2)
               HESS(J3,  J4-1) = FMASS*HESS(J3,  J4-1)
               HESS(J3,  J4)   = FMASS*HESS(J3,  J4)
            ELSE
               HESS(J3-2,J4-2) = FMASS*HESS(J3-2,J4-2)
               HESS(J4-2,J3-2) = HESS(J3-2,J4-2)
               HESS(J3-2,J4-1) = FMASS*HESS(J3-2,J4-1)
               HESS(J4-1,J3-2) = HESS(J3-2,J4-1)
               HESS(J3-2,J4)   = FMASS*HESS(J3-2,J4)
               HESS(J4,J3-2)   = HESS(J3-2,J4)
               HESS(J3-1,J4-2) = FMASS*HESS(J3-1,J4-2)
               HESS(J4-2,J3-1) = HESS(J3-1,J4-2)
               HESS(J3-1,J4-1) = FMASS*HESS(J3-1,J4-1)
               HESS(J4-1,J3-1) = HESS(J3-1,J4-1)
               HESS(J3-1,J4)   = FMASS*HESS(J3-1,J4)
               HESS(J4,J3-1)   = HESS(J3-1,J4)
               HESS(J3,J4-2)   = FMASS*HESS(J3,J4-2)
               HESS(J4-2,J3)   = HESS(J3,  J4-2)
               HESS(J3,J4-1)   = FMASS*HESS(J3,J4-1)
               HESS(J4-1,J3)   = HESS(J3,  J4-1)
               HESS(J3,J4)     = FMASS*HESS(J3,J4)
               HESS(J4,J3)     = HESS(J3,J4)
            ENDIF
         ENDDO
      ENDDO

      END SUBROUTINE MASSWT
