C   GMIN: A program for finding global minima
C   Copyright (C) 1999- David J. Wales
C   This file is part of GMIN.
C
C   GMIN is free software; you can redistribute it and/or modify
C   it under the terms of the GNU General Public License as published by
C   the Free Software Foundation; either version 2 of the License, or
C   (at your option) any later version.
C
C   GMIN is distributed in the hope that it will be useful,
C   but WITHOUT ANY WARRANTY; without even the implied warranty of
C   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C   GNU General Public License for more details.
C
C   You should have received a copy of the GNU General Public License
C   along with this program; if not, write to the Free Software
C   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
      
      PROGRAM GMIN
      USE MODMXATMS
      USE NOA
      USE COMMONS
      USE QMODULE
      USE PERMU
      USE F1COM
      USE MODAMBER
      USE MODAMBER9, only : AMBFINALIO_NODE,MDCRD_UNIT,MDINFO_UNIT,AMBPDB_UNIT, ATMASS1
      USE MODCHARMM
      USE PORFUNCS
      USE HOMOREFMOD
      IMPLICIT NONE
      !EXTERNAL READ_CMD_ARGS
#ifdef MPI
      INCLUDE 'mpif.h'
#endif
      INTEGER J1,J2, JP, MPIERR, NDUMMY3,NPTOTAL,VERSIONTEMP,GETUNIT,LUNIT
      DOUBLE PRECISION, ALLOCATABLE :: SCREENC(:)
      DOUBLE PRECISION POTEL, DUMMY
      DOUBLE PRECISION, ALLOCATABLE :: TMPCOORDS(:)
      INTEGER, ALLOCATABLE :: NDUMMY(:), NDUMMY2(:,:)
      LOGICAL LOPEN, YESNO
      INTEGER J6

      CHARACTER(LEN=130) ISTR,JSTR
      CHARACTER(LEN=40) :: atom1,atom2,atompair
      CHARACTER(LEN=13) :: CUDAFILENAME

      COMMON /MYPOT/ POTEL

      CALL CPU_TIME(TSTART)
      CALL READ_CMD_ARGS
#ifdef MPI
      CALL MPI_INIT(MPIERR)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD,NPAR,MPIERR)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD,MYNODE,MPIERR)
      MYUNIT=22980+MYNODE
      MDCRD_UNIT=20000+MYNODE
      MDINFO_UNIT=21000+MYNODE
      AMBPDB_UNIT=18000+MYNODE
      AMBFINALIO_NODE=200+MYNODE
      WRITE (ISTR, '(I10)') MYNODE+1
      IF (TRIM(ADJUSTL(INFILE)).EQ.'') INFILE='output'
      IF (NPAR.GT.1) THEN 
         MYFILENAME=TRIM(ADJUSTL(INFILE))//"."//TRIM(ADJUSTL(ISTR))
      ELSE
         MYFILENAME=TRIM(ADJUSTL(INFILE))
      ENDIF
      OPEN(MYUNIT,FILE=MYFILENAME, STATUS="unknown", form="formatted")
      WRITE(MYUNIT, '(A,I10,A,I10)') "Starting parallel execution: Processor", mynode+1, " of ",NPAR
#else
      NPAR=1
      MYNODE=0
      MYUNIT=22979+1
      MDCRD_UNIT=20000
      MDINFO_UNIT=21000
      AMBPDB_UNIT=18000
      AMBFINALIO_NODE=1
      IF (TRIM(ADJUSTL(INFILE)).EQ.'') THEN
         MYFILENAME="output"
      ELSE
         MYFILENAME=TRIM(ADJUSTL(INFILE))
      ENDIF
      OPEN(MYUNIT,FILE=MYFILENAME, STATUS="unknown", form="formatted")
      WRITE(MYUNIT, '(A,I10,A,I10,A)') "Starting serial execution"
#endif
! Add the GMIN version to the output - helps bug hunting :)
      !WRITE(MYUNIT, '(A,I5)') 'GMIN version r',VERSIONTEMP
!     CALL DISPLAY_VERSION(MYUNIT)
      CALL COUNTATOMS(MYUNIT, NPAR)
      IF (CHRMMT) WRITE(MYUNIT,'(A,I8)') 'main> MAXAIM parameter for CHARMM MXATMS=',MXATMS
      CALL MODCOMMONINIT
 
      ALLOCATE(FIN(3*NATOMS))
      ALLOCATE(XICOM(3*NATOMS),PCOM(3*NATOMS))
      ALLOCATE(SCREENC(3*NATOMS))
      ALLOCATE(IATNUM(NATOMS), VT(NATOMS), ZSYM(NATOMS))
      VT(1:NATOMS)=0.0D0 ! TO PREVENT READING FROM UNINITIALISED MEMORY
      IF (CALCQT) CALL SHINIT

      INQUIRE(UNIT=1,OPENED=LOPEN)
      IF (LOPEN) THEN
         WRITE(*,'(A,I2,A)') 'main> A ERROR *** Unit ', 1, ' is not free '
         STOP
      ENDIF

      CALL KEYWORD

#ifdef CUDA
      IF (DEBUG) THEN
         CUDAFILENAME ="debug_out.txt"
         OPEN(UNIT=25, FILE=CUDAFILENAME, STATUS="REPLACE")
         CLOSE(25)
      END IF
#endif

      IF (GLJT.AND.SORTT) THEN
         WRITE(MYUNIT,'(A)') 'keyword> *** ERROR - you cannot specify SORT with GLJ'
         STOP
      ENDIF

!     related to FEBHT
      IF (FEBHT) THEN
         IF (.NOT. RIGID) THEN
            ALLOCATE(ATMASS(NATOMS)) 
         ELSE IF (NTIPT) THEN
            ALLOCATE(ATMASS(NATOMS/2*3))
         ELSE
            ALLOCATE(ATMASS(NATOMS/2*NRBSITES))
         ENDIF 
         ATMASS(:) = 1.D0
         IF (NTIPT) THEN
            DO J1 = 1, NATOMS/2
               ATMASS(3*J1-2) = 16.D0
               ATMASS(3*J1-1) = 1.D0
               ATMASS(3*J1)   = 1.D0
            ENDDO
         ENDIF
         IF (AMBERT) THEN
            ATMASS(:) = ATMASS1(:)
         ENDIF
         SYMFCTR = 2.D0
         IF (RIGID) THEN
            DO J1 = 1, NATOMS/2
               SYMFCTR = SYMFCTR*J1
            ENDDO
         ELSE
            DO J1 = 1, NATOMS
               SYMFCTR = SYMFCTR*J1
            ENDDO
         ENDIF
      ENDIF
      IF (READMASST) THEN
         INQUIRE(FILE='masses',EXIST=YESNO)
         IF (ALLOCATED(ATMASS)) DEALLOCATE(ATMASS)
         ALLOCATE(ATMASS(NATOMS)) 
         IF (YESNO) THEN
            LUNIT=GETUNIT()
            OPEN(UNIT=LUNIT,FILE='masses',STATUS='OLD')
            READ(LUNIT,*) (ATMASS(J1),J1=1,NATOMS)
            CLOSE(LUNIT)
            WRITE(MYUNIT,'(A)') ' fetchz> Masses replaced by values from masses file, Values are:'
            WRITE(MYUNIT,'(F20.10)') (ATMASS(J1),J1=1,NATOMS)
         ELSE
            WRITE(MYUNIT,'(A)') ' fetchz> ERROR *** keyword READMASS found, but no masses file'
            STOP
         ENDIF
      ENDIF
      IF (.NOT.ALLOCATED(ATMASS)) THEN
         IF (.NOT. RIGID) THEN
            ALLOCATE(ATMASS(NATOMS)) 
            ATMASS(1:NATOMS)=1.0D0
         ELSE IF (NTIPT) THEN
            ALLOCATE(ATMASS(NATOMS/2*3))
            ATMASS(1:NATOMS/2*3)=1.0D0
         ELSE
            ALLOCATE(ATMASS(NATOMS/2*NRBSITES))
            ATMASS(1:NATOMS/2*NRBSITES)=1.0D0
         ENDIF 
      ENDIF

      INQUIRE(UNIT=1,OPENED=LOPEN)
      IF (LOPEN) THEN
         WRITE(*,'(A,I2,A)') 'main> B ERROR *** Unit ', 1, ' is not free '
         STOP
      ENDIF

!fh301>{{{
      IF (CHEMSHIFT) CALL CAMSHIFTREAD(20)
!fh301>}}}

      IF (CHRMMT) THEN
         IF (CHRIGIDTRANST.OR.CHRIGIDROTT) CALL CHSETSEG
! set charmm moves to standard (Mortensen & Wales) if no Cartesian moves are invoked via CHNMAX=0 
         IF ((.NOT.CHMOVET) .AND. (.NOT.CHCARTMOVET)) THEN
            CHSTANDARDT=.TRUE.
            CHBBT=.TRUE.
            CHSCT=.TRUE.
         ENDIF
         IF (SECPREDT) CALL CHSECPRED
         CALL CHSETPROB
      ENDIF

      IF (RMST) THEN
         ALLOCATE(RMSBEST(RMSSAVE,2),RMSCOOR(RMSSAVE,3*NATOMS))
         RMSBEST(1:RMSSAVE,1)=RMSLIMIT+RMSTOL
         RMSBEST(1:RMSSAVE,2)=0.D0
         RMSCOOR(1:RMSSAVE,1:3*NATOMS)=0.D0
         ALLOCATE(COORCOMP(1:3*NATOMS))
!
!        csw34> Need to add the read in for other file formats
!        (crd,pdb). Still not sure how GMIN reads in the input.crd file
!        for CHARMM. It appears to be reading into unit 7 in io1.f
!        though - but only from xyz format! Is there a hidden
!        conversion?
!         
         OPEN(UNIT=1,FILE='compare',STATUS='OLD')
         READ(1,*) (COORCOMP(J1),J1=1,3*NATOMS)
         CLOSE(1)
      ENDIF

      ALLOCATE(FF(NSAVE),QMIN(MAX(NSAVE,1)))
      ALLOCATE(QMINP(NSAVE,3*NATOMS))
      ALLOCATE(NPCALL_QMIN(NSAVE))
      IF (MONITORT) THEN
         ALLOCATE(LOWESTC(3*NATOMS))
      ENDIF

!        csw34> ALLOCATE the interaction energy tracking arrays if A9INTE in data
      IF (A9INTET.AND.AMBERT) THEN 
         ALLOCATE(INTEFF(NSAVEINTE),INTEQMIN(NSAVEINTE))
         ALLOCATE(INTEQMINP(NSAVEINTE,3*NATOMS))
         INTEQMIN(:)=1.0D10 
         INTEQMINP(1:NSAVEINTE,1:3*NATOMS)=0.0D0 ! to prevent reading from uninitialised memory
         INTEFF(1:NSAVEINTE)=0 ! to prevent reading from uninitialised memory
      ENDIF  

      IF (GAUSST) THEN
         ALLOCATE(GAUSSKK(3*NATOMS,GMODES),GAUSSEE(GMODES),GKSMALL(3*NATOMS))
         CALL KEGEN ! INITIAL SETUP 
         DO J1=1,GMODES
             PRINT *,J1,GAUSSEE(J1)
         ENDDO
      ENDIF

      QMINP(1:NSAVE,1:3*NATOMS)=0.0D0 ! to prevent reading from uninitialised memory
      COORDSO(1:3*NATOMS,1:NPAR)=0.0D0 ! to prevent reading from uninitialised memory
      FF(1:NSAVE)=0 ! to prevent reading from uninitialised memorY
      VATO(1:NATOMS,1:NPAR)=0.0D0 ! to prevent reading from uninitialised memory
      ALLOCATE(ESAVE(NTAB,NPAR),XINSAVE(NTAB,NPAR))
      ALLOCATE(VEC(NVEC))

!     IF (SYMMETRIZE.AND.(.NOT.CENT)) THEN
!        PRINT '(A)','Probable input error - SYMMETRIZE true but CENT false'
!        STOP
!     ENDIF

      IF (DUMPT) THEN
         IF (CHRMMT) THEN
            OPEN(UNIT=719,FILE='dump.crd',STATUS='UNKNOWN')
            OPEN(UNIT=720,FILE='dump.pdb',STATUS='UNKNOWN')
         ENDIF
!
! dump.1.xyz is partly filled with control characters for no apparent reason.
! Suspect a compiler or mpi bug? DJW
! dump.1.xyz is fine with debug compilation, so it is a compiler bug!
!
         ALLOCATE(DUMPXYZUNIT(NPAR),DUMPVUNIT(NPAR))
         DO J1=1,NPAR
            WRITE (JSTR,'(I6)') J1

            ISTR='dump.' // TRIM(ADJUSTL(JSTR)) // '.V'
            DUMPVUNIT(J1)=GETUNIT()
            OPEN(UNIT=DUMPVUNIT(J1),FILE=TRIM(ADJUSTL(ISTR)),STATUS='UNKNOWN')

            ISTR='dump.' // TRIM(ADJUSTL(JSTR)) // '.xyz'
            DUMPXYZUNIT(J1)=GETUNIT()
            OPEN(UNIT=DUMPXYZUNIT(J1),FILE=TRIM(ADJUSTL(ISTR)),STATUS='UNKNOWN')
         ENDDO
      ENDIF

      IF (PAIRDISTT) THEN
         MYPUNIT=3000+MYNODE
         IF (NPAR.GT.1) THEN
            OPEN(MYPUNIT,FILE="pairdists."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
         ELSE
            OPEN(MYPUNIT,FILE="pairdists",STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
         ENDIF
         WRITE(MYPUNIT,'(A10)',ADVANCE="NO") "Quench  "
         DO J1=1,NPAIRS
            WRITE(atom1,*) PAIRDIST(J1,1)
            WRITE(atom2,*) PAIRDIST(J1,2)
            WRITE(atompair,*) TRIM(ADJUSTL(atom1))//"-"//TRIM(ADJUSTL(atom2))
            WRITE(MYPUNIT,'(A10)',ADVANCE="NO") TRIM(ADJUSTL(atompair))//"  " 
         ENDDO
         WRITE(MYUNIT,'(A)') ""
      ENDIF

!
!     csw34> TRACKDATA keyword prints the energy and markov energy 
!     to files for viewing during a run. If RMS is also specified it
!     prints the rmsd from the comparison structure into a file.
!
      IF (TRACKDATAT) THEN
         MYEUNIT=4000+MYNODE
         MYMUNIT=6000+MYNODE
         MYBUNIT=8000+MYNODE
         MYRUNIT=10000+MYNODE
         IF (NPAR.GT.1) THEN
            IF (RESTORET) THEN
               OPEN(MYEUNIT,FILE="energy."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
               OPEN(MYMUNIT,FILE="markov."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
               OPEN(MYBUNIT,FILE="best."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
               IF (RMST) OPEN(MYRUNIT,FILE="rmsd."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
            ELSE
               OPEN(MYEUNIT,FILE="energy."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED')
               OPEN(MYMUNIT,FILE="markov."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED')
               OPEN(MYBUNIT,FILE="best."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED')
               IF (RMST) OPEN(MYRUNIT,FILE="rmsd."//trim(adjustl(istr)),STATUS='UNKNOWN',FORM='FORMATTED')
            ENDIF
         ELSE
            IF (RESTORET) THEN
               OPEN(MYEUNIT,FILE='energy',STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
               OPEN(MYMUNIT,FILE='markov',STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
               OPEN(MYBUNIT,FILE='best',STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
               IF (RMST) OPEN(MYRUNIT,FILE='rmsd',STATUS='UNKNOWN',FORM='FORMATTED',POSITION='APPEND')
            ELSE
               OPEN(MYEUNIT,FILE='energy',STATUS='UNKNOWN',FORM='FORMATTED')
               OPEN(MYMUNIT,FILE='markov',STATUS='UNKNOWN',FORM='FORMATTED')
               OPEN(MYBUNIT,FILE='best',STATUS='UNKNOWN',FORM='FORMATTED')
               IF (RMST) OPEN(MYRUNIT,FILE='rmsd',STATUS='UNKNOWN',FORM='FORMATTED')
            ENDIF
            IF (A9INTET) THEN
               OPEN(UNIT=3998,FILE='intE.dat',STATUS='UNKNOWN',FORM='FORMATTED')
               OPEN(UNIT=3999,FILE='bestintE.dat',STATUS='UNKNOWN',FORM='FORMATTED')
            ENDIF
         ENDIF
      ENDIF
      CALL FLUSH(6)
      CALL IO1
!
! If this is a CSM optimisation we now have to multiply the number of atoms by the number of
! group operations and replicate some coordinates and allowed permutations.
!
      IF (CSMT) THEN
         CALL CSMINIT
         IF (SYMMETRIZECSM) THEN
            IF (CSMMAXIT.EQ.0) CSMMAXIT=MAXIT
         ELSE
            CSMMAXIT=MAXIT
         ENDIF
      ENDIF

      CALL FLUSH(6)

      IF (PROJIT) THEN
         ALLOCATE(TMPCOORDS(3*NATOMS))
         TMPCOORDS(1:3*NATOMS)=COORDS(1:3*NATOMS,1)
         CALL PROJIINIT(TMPCOORDS,NATOMS)
         DEALLOCATE(TMPCOORDS)
      ENDIF


      IF(VGW) THEN
        CALL INITIALIZE_VGWSP(NATOMS,LJSIGMA,LJEPSILON,TAUMAX,CPFACTORSG,CPS,VGWTOL)
        CALL INITIALIZE_VGW(NATOMS,LJSIGMA,LJEPSILON,TAUMAXFULL,CPFACTORFG,CPF)
      ENDIF

      IF (SEEDT) THEN
         CALL GSEED
      ELSE
         IF ((.NOT.FIELDT).AND.CENT) THEN
            DO J1=1,NPAR
               IF (.NOT.SEEDT) CALL CENTRE2(COORDS(1:3*NATOMS,J1))
            ENDDO
         ELSEIF ((.NOT.FIELDT).AND.FIXCOM) THEN
            DO J1=1,NPAR
               IF (.NOT.SEEDT) CALL CENTRECOM(COORDS(1:3*NATOMS,J1))
            ENDDO
         ENDIF
      ENDIF

      IF (SUPERSTEP) NSUPERSTEP=0
      
      DO JP=1,NPAR
         NQ(JP)=1
      ENDDO
      DO J1=1,NSAVE
         QMIN(J1)=1.0D10
         NPCALL_QMIN(J1)=0
      ENDDO

      CALL INITIALIZATIONS()

! vr274>  call test routines.
!         By default this routine does nothing. In the testsuite, it is replaced by
!         a customized function which can run checks whether everything runs fine.
      CALL RUN_TESTS_AFTER_INIT()

!mo361> Run GA
      IF (GENALT) THEN
         NRUNS=0
         CALL MYGA_RUN()
      ENDIF

      IF ((NRUNS.GT.0).OR.PTMC.OR.BSPT) CALL MCRUNS(SCREENC)
C     CALL SYSTEM('rm ssdump ssave >& /dev/null')

      IF (ALLOCATED(FIN)) DEALLOCATE(FIN)
      IF (ALLOCATED(XICOM)) DEALLOCATE(XICOM)
      IF (ALLOCATED(PCOM)) DEALLOCATE(PCOM)
      IF (ALLOCATED(GAUSSKK)) DEALLOCATE(GAUSSKK,GAUSSEE)
C     deallocate dynamic memory for AMBER
      IF (AMBERT) CALL AMBER_DEALLOCATE_STACKS
      CALL MODCOMMONDEINIT
      CALL FLUSH(MYUNIT)

      IF(VGW) THEN
        CALL CLEANUP_VGWSP
        CALL CLEANUP_VGW
      ENDIF

      CLOSE(MYUNIT)
    
! khs26> Close file storing free energies
      IF (FEBHT) THEN
         CLOSE(FE_FILE_UNIT)
      END IF
! csw34> close pairdists.* files
      IF (PAIRDISTT) CLOSE(MYPUNIT)
      IF (TRACKDATAT) THEN
         CLOSE(MYEUNIT)
         CLOSE(MYMUNIT)
         IF (RMST) CLOSE(MYRUNIT)
         CLOSE(MYBUNIT)
         IF (A9INTET) THEN
            CLOSE(3998)
            CLOSE(3999)
         ENDIF
      ENDIF
#ifdef MPI
      CALL MPI_FINALIZE(MPIERR)
#endif
      DEALLOCATE(SCREENC)
      DEALLOCATE(IATNUM, VT, ZSYM)
      DEALLOCATE(FF,QMIN)
      DEALLOCATE(QMINP)
      DEALLOCATE(ESAVE,XINSAVE)
      DEALLOCATE(VEC)
      DEALLOCATE(FIXSTEP,FIXTEMP,FIXBOTH,TEMP,ACCRAT,STEP,ASTEP,OSTEP,BLOCK,NT,NQ,EPREV,
     &           JUMPMOVE,JUMPINT,JDUMP,COORDS,COORDSO,VAT,VATO,
     &         JUMPTO,SHELLMOVES,PTGROUP,NSURFMOVES,NCORE)
      DEALLOCATE(FROZEN)
      DEALLOCATE(FROZENRES)
      DEALLOCATE(DONTMOVE)
      DEALLOCATE(DONTMOVERES)
      DEALLOCATE(HARMONICFLIST)
      DEALLOCATE(HARMONICR0)
      DEALLOCATE(BESTPERM)
      IF (ALLOCATED(MSBCOORDS)) DEALLOCATE(MSBCOORDS)
      IF (ALLOCATED(MSBE)) DEALLOCATE(MSBE)
      IF (ALLOCATED(BEADLETTER)) DEALLOCATE(BEADLETTER)
      IF (ALLOCATED(BLNSSTRUCT)) DEALLOCATE(BLNSSTRUCT)
      IF (ALLOCATED(NPERMSIZE)) DEALLOCATE(NPERMSIZE,PERMGROUP,NSETS,SETS)
      IF (ALLOCATED(HDIST)) DEALLOCATE(HDIST,HWEIGHT,HISTVALS,LHISTVALS,IGNOREBIN)
      IF (ALLOCATED(SITE)) DEALLOCATE(SITE)
      IF (ALLOCATED(MOVABLEATOMLIST)) DEALLOCATE(MOVABLEATOMLIST)
      IF (ALLOCATED(MOVABLEATOMLISTLOGICAL)) DEALLOCATE(MOVABLEATOMLISTLOGICAL)
      IF (ALLOCATED(ATOMSINBLOCK)) DEALLOCATE(ATOMSINBLOCK)
      IF (ALLOCATED(COORDS)) DEALLOCATE(COORDS)
      IF (ALLOCATED(DATOMGROUPNAMES)) DEALLOCATE(DATOMGROUPNAMES)
      IF (ALLOCATED(PYA1bin)) DEALLOCATE(PYA1bin)
      IF (ALLOCATED(PYA2bin)) DEALLOCATE(PYA2bin)
      IF (ALLOCATED(PYA1bin)) DEALLOCATE(PYA1bin)
      IF (ALLOCATED(PYA2bin)) DEALLOCATE(PYA2bin)
      IF (ALLOCATED(TARGETS)) DEALLOCATE(TARGETS)
      IF (ALLOCATED(TCOORDS)) DEALLOCATE(TCOORDS)
      IF (ALLOCATED(TBPBASINS)) DEALLOCATE(TBPBASINS)
      IF (ALLOCATED(ATOMLISTS)) DEALLOCATE(ATOMLISTS)
      IF (ALLOCATED(NBRLISTS)) DEALLOCATE(NBRLISTS)
      IF (ALLOCATED(NNBRS)) DEALLOCATE(NNBRS)
      IF (ALLOCATED(NNHIST)) DEALLOCATE(NNHIST)
      IF (ALLOCATED(ANNHIST)) DEALLOCATE(ANNHIST)
      IF (ALLOCATED(ANNHIST_MEAN)) DEALLOCATE(ANNHIST_MEAN)
      IF (ALLOCATED(ANNHIST_VAR)) DEALLOCATE(ANNHIST_VAR)
      IF (ALLOCATED(NNBOND_WEIGHTS)) DEALLOCATE(NNBOND_WEIGHTS)
      IF (ALLOCATED(IFLIPE)) DEALLOCATE(IFLIPE)

!
! Should also deallocate any of the arrays below, which may have been
! allocated in keywords. This is just to make nagfmcheck happy, though! DJW
!
!          ALLOCATE(DATOMGROUPAXIS(NDGROUPS,2))
!          ALLOCATE(DATOMGROUPPROBA(NDGROUPS))
!          ALLOCATE(DATOMGROUPSCALINGA(NDGROUPS))
!          ALLOCATE(DATOMGROUPPROBB(NDGROUPS))
!          ALLOCATE(DATOMGROUPSCALINGB(NDGROUPS))
!          ALLOCATE(DATOMGROUPPROBC(NDGROUPS))
!          ALLOCATE(DATOMGROUPSCALINGC(NDGROUPS))
!          ALLOCATE(DATOMGROUPPROBD(NDGROUPS))
!          ALLOCATE(DATOMGROUPSCALINGD(NDGROUPS))
!          ALLOCATE(DATOMGROUPS(NDGROUPS,NATOMS))
!          ALLOCATE(DATOMGROUPATT(NDGROUPS,NATOMS))
!          ALLOCATE(MASSES(NATOMS))
!          ALLOCATE(ATOMGROUPNAMES(NGROUPS))
!          ALLOCATE(ATOMGROUPAXIS(NGROUPS,2))
!          ALLOCATE(ATOMGROUPPSELECT(NGROUPS))
!          ALLOCATE(ATOMGROUPSCALING(NGROUPS))
!          ALLOCATE(ATOMGROUPS(NGROUPS,NATOMS))
!          ALLOCATE(REPATF(NREPEAT),REPATL(NREPEAT),REPPHIF(NREPEAT),REPPHIL(NREPEAT))
!          ALLOCATE(REPATF(NREPEAT),REPATL(NREPEAT),REPPHIF(NREPEAT),REPPHIL(NREPEAT))
!          ALLOCATE(SHELLMOVES(NPAR))
!          ALLOCATE(PTGROUP(NPAR))
!          ALLOCATE(NSURFMOVES(NPAR))
!          ALLOCATE(NCORE(NPAR))
!          ALLOCATE(PAIRDIST(NPAIRS,2))
!          ALLOCATE(RBOPS(4,NRBGROUP))
!          ALLOCATE(EMIN(NRESMIN),FVIBMIN(NRESMIN),PFMIN(NRESMIN),IXMIN(NRESMIN),IYMIN(NRESMIN),IZMIN(NRESMIN),HORDERMIN(NRESMIN))
!          ALLOCATE(RESPOINTS(3*NATOMS,NRESMIN))
!          ALLOCATE(RBUV(NRBSITES,3))
!          ALLOCATE(DPMU(NRBSITES))
!          ALLOCATE(RBUV(NRBSITES,3))
!          ALLOCATE(DPMU(NRBSITES))
!          ALLOCATE(RBUV(NRBSITES,3))
!          ALLOCATE(NCMP(TPAHA))
!          ALLOCATE(RBSTLA(NRBSITES,3))
!          ALLOCATE(STCHRG(NRBSITES))
!          ALLOCATE(RBSTLA(NRBSITES,3))
!          ALLOCATE(RBSTLA(NRBSITES,3))

      STOP

      END

