SUBROUTINE GMIN_QUIP_WRAPPER(COORDS,GRADIENT,ENRG,QATOMTYPE,QARGSTR)

USE COMMONS, ONLY : NATOMS, BOXLX, BOXLY, BOXLZ

IMPLICIT NONE

DOUBLE PRECISION, DIMENSION(3*NATOMS), INTENT(IN) :: COORDS
DOUBLE PRECISION, DIMENSION(3*NATOMS), INTENT(OUT) :: GRADIENT
DOUBLE PRECISION, INTENT(OUT) :: ENRG
CHARACTER(LEN=10240), INTENT(IN) :: QARGSTR
CHARACTER(LEN=3), INTENT(IN) :: QATOMTYPE

INTEGER :: I
DOUBLE PRECISION :: CUT, CUTOFF
DOUBLE PRECISION, DIMENSION(3,3) :: LATT, VIR
DOUBLE PRECISION, DIMENSION(3,NATOMS) :: NEW_COORDS, FORCES
CHARACTER(LEN=3), DIMENSION(NATOMS) :: SYMB

LATT = RESHAPE((/ BOXLX, 0.0D0, 0.0D0, 0.0D0, BOXLY, 0.0D0, 0.0D0, 0.0D0, BOXLZ /), SHAPE(LATT))

SYMB = QATOMTYPE 

NEW_COORDS = RESHAPE(COORDS, (/ 3, NATOMS /))

CALL QUIP_WRAPPER(NATOMS,LATT,SYMB,NEW_COORDS,QARGSTR,ENRG,FORCES,VIR)

!Virial is not passed back to GMIN

GRADIENT = RESHAPE(FORCES, SHAPE(GRADIENT))
DO I = 1, 3*NATOMS
   GRADIENT(I) = -1.0D0*GRADIENT(I)
END DO

END SUBROUTINE GMIN_QUIP_WRAPPER
