SUBROUTINE GETORBITS(NORBIT,ORBDIST,CMDIST,NATOMS,ORBSIZE,SYMTOL,LARGESIZE,NINDEX,LCOORDS,LDEBUG)
use commons,only: myunit
IMPLICIT NONE
INTEGER NATOMS, J, J1, ISTART
INTEGER NORBIT, IORBIT, ORBSIZE(NATOMS), LARGES, LARGESIZE, NINDEX(NATOMS)
DOUBLE PRECISION ORBDIST(NATOMS), CMDIST(NATOMS), SYMTOL, LARGEDIST, LCOORDS(3*NATOMS)
LOGICAL LDEBUG

NORBIT=1 ! number of orbits
IORBIT=1
ORBDIST(NORBIT)=CMDIST(1) ! save distance of first orbit
! the distances must be sorted for the next loop to work
DO J=2,NATOMS
!  PRINT '(A,3F15.5)','CMDIST(J),CMDIST(J-1),SYMTOL=',CMDIST(J),CMDIST(J-1),SYMTOL
!  WRITE(MYUNIT,'(A,2I6,4G20.10)') 'J-1,J,CMDIST(J-1),CMDIST(J),diff,SYMTOL=',J-1,J,CMDIST(J-1),CMDIST(J),ABS(CMDIST(J)-CMDIST(J-1)),SYMTOL
   IF (ABS(CMDIST(J)-CMDIST(J-1)).LT.SYMTOL) THEN 
      IORBIT=IORBIT+1 ! old orbit, increment number of atoms
      ORBDIST(NORBIT)=ORBDIST(NORBIT)+CMDIST(J)
   ELSE 
      ORBSIZE(NORBIT)=IORBIT ! save size of previous orbit
      ORBDIST(NORBIT)=ORBDIST(NORBIT)/IORBIT ! use average distance for all atoms
      NORBIT=NORBIT+1 ! increment number of orbits
      ORBDIST(NORBIT)=CMDIST(J) ! save distance of new orbit
      IORBIT=1        ! reset the counter for number of atoms in this orbit
   ENDIF
ENDDO
ORBSIZE(NORBIT)=IORBIT ! save size of last orbit
ORBDIST(NORBIT)=ORBDIST(NORBIT)/IORBIT ! use average distance for all atoms

! ISTART=1
! DO J=1,NORBIT
   ! CMX(J)=0.0D0
   ! CMY(J)=0.0D0
   ! CMZ(J)=0.0D0
   ! DO J1=ISTART,ISTART+ORBSIZE(J)-1
      ! CMX(J)=CMX(J)+LCOORDS(3*(NINDEX(J1)-1)+1)
      ! CMY(J)=CMY(J)+LCOORDS(3*(NINDEX(J1)-1)+2)
      ! CMZ(J)=CMZ(J)+LCOORDS(3*(NINDEX(J1)-1)+3)
   ! ENDDO 
   ! CMX(J)=CMX(J)/ORBSIZE(J)
   ! CMY(J)=CMY(J)/ORBSIZE(J)
   ! CMZ(J)=CMZ(J)/ORBSIZE(J)
   ! ISTART=ISTART+ORBSIZE(J)
! ENDDO

LARGES=1
LARGESIZE=ORBSIZE(1)
LARGEDIST=ORBDIST(1)
ISTART=1
DO J=1,NORBIT
   IF (LDEBUG) WRITE(MYUNIT, '(A,I6,A,I6,A,F15.5)') 'orbit ',J,' size ',ORBSIZE(J),' distance ',ORBDIST(J)
   IF (LDEBUG) WRITE(MYUNIT, '(A,I6)') 'members of orbit ',J
   IF (LDEBUG) WRITE(MYUNIT, '(12I5)') (NINDEX(J1),J1=ISTART,ISTART+ORBSIZE(J)-1)
   IF (LDEBUG) WRITE(MYUNIT, '(A)') 'distances:'
   IF (LDEBUG) WRITE(MYUNIT, '(6G20.10)') (CMDIST(J1),J1=ISTART,ISTART+ORBSIZE(J)-1)
   IF (ORBSIZE(J).GT.LARGESIZE) THEN
      LARGESIZE=ORBSIZE(J)
      LARGES=ISTART
      LARGEDIST=ORBDIST(J)
   ENDIF
   ISTART=ISTART+ORBSIZE(J)
ENDDO
IF (LDEBUG) WRITE(MYUNIT,'(A,I6,A,I6)')  'largest orbit has ',LARGESIZE,' members starting from sorted position ',LARGES

RETURN
END SUBROUTINE GETORBITS
