!Choose parents for mating in GA
!
!Select two parent structures for mating
!
SUBROUTINE MYGA_SELECT(I,J)
   USE MYGA_PARAMS
   IMPLICIT NONE
   DOUBLE PRECISION DPRAND
   INTEGER I,J
   IF (MYGA_L_ROUL) THEN
      CALL MYGA_SELECT_ROULETTE(I,J)
   ELSE !Default option: tournament selection
      CALL MYGA_SELECT_TOURNAMENT(I,J)
   ENDIF
   RETURN
END
!
!Tournament selection
!
SUBROUTINE MYGA_SELECT_TOURNAMENT(BEST,SECOND)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   IMPLICIT NONE
   INTEGER I,J
   INTEGER IRAN
   DOUBLE PRECISION DPRAND
   INTEGER, ALLOCATABLE :: MARK(:)
   INTEGER :: TOURN(MYGA_NSTRUC)
   INTEGER TEMP
   INTEGER :: BEST, SECOND
   INTEGER N ! Counter of tournament size
   IF (.NOT.ALLOCATED(MARK)) THEN
      ALLOCATE(MARK(MYGA_NSTRUC))
   ENDIF
   DO I=1,MYGA_NSTRUC
! FOR ALL CLUSTERS SET MARKS TO ZERO
      MARK(I) = 0
   END DO
!     SELECTS A PAIR OF STRINGS USING A TOURNAMENT SELECTION
!     PICK TOURN_SIZE STRINGS AT RANDOM
   N = 0
   DO WHILE(N .LT. MYGA_TOURN_SIZE)
! WHILST POPULATION NOT FILLED
      IRAN = DPRAND()*MYGA_NSTRUC+1 ! GET RANDOM NUMBER FOR CLUSTER POSITION
      IF (MARK(IRAN) .NE. 1) THEN
! IF NOT ALREADY SELECTED
         N = N+1  ! ADD ONE TO POPULATION
         TOURN(N) = IRAN ! COPY POSITION INTO TOURNAMENT
         IF (.NOT.MYGA_TWIN) THEN
            MARK(IRAN) = 1 ! SET MARKED POSITION
         ENDIF
      END IF
   END DO
! (ORIGINAL COMMENTS)
!     FIND TWO LOWEST ENERGY CLUSTERS
!     STRAIGHT INSERTION SORT FROM NUMERICAL RECIPES
   DO I=2,MYGA_TOURN_SIZE
! FOR ENTIRE TOURNAMENT
      TEMP = TOURN(I)
      DO J=I-1,1,-1
! COMPARE CURRENT ENERGY TO OTHERS AROUND
         IF (MYGA_POP_ENERGY(TOURN(J)) .LE. MYGA_POP_ENERGY(TEMP)) GOTO 10
         TOURN(J+1) = TOURN(J) ! MOVE VALUE BACKWARDS
      END DO
      J=0    ! RESET J
10    TOURN(J+1) = TEMP  ! MOVE ENERGY VALUE IN ARRAY
   END DO
   BEST = TOURN(1) ! BEST VALUE
   SECOND = TOURN(2) ! SECOND BEST VALUE
   RETURN
END
!
!Roulette wheel selection
!Fitness routine must be run before this to set up roulette probabilities.
!
SUBROUTINE MYGA_SELECT_ROULETTE(FIRST,SECOND)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   IMPLICIT NONE
   INTEGER I
   INTEGER FIRST,SECOND
   DOUBLE PRECISION DPRAND, RD
   INTEGER, ALLOCATABLE :: MARK(:)
   INTEGER ISEL,ISTRING
   IF (.NOT.ALLOCATED(MARK)) THEN
      ALLOCATE(MARK(MYGA_NSTRUC))
   ENDIF
   DO I=1,MYGA_NSTRUC
      MARK(I)=0
   ENDDO
   ISEL=0
   DO WHILE(ISEL .LT. 2)
      ISTRING = DPRAND()*MYGA_NSTRUC+1  ! PICK POSITION FOR RANDOM CLUSTERS
      RD = DPRAND()    ! RANDOM NUMBER
      IF (RD.LT.MYGA_POP_FITNESS(ISTRING) .AND. MARK(ISTRING).NE.1) THEN
! IF FITNESS IS GREATER THAN RANDOM NUMBER, AND NOT ALREADY SELECTED
         MARK(ISTRING) = 1  ! MARK VALUE AS 1
         ISEL = ISEL + 1    ! NUMBER SELECTED ++
         IF (ISEL.EQ.1) THEN
            FIRST = ISTRING
         ELSEIF (ISEL.EQ.2) THEN
            SECOND = ISTRING
         ENDIF
!         STR(ISEL) = ISTRING    ! TURN INTO STRING
      END IF
   ENDDO
   RETURN
END
!
!Sets up roulette wheel probabilities
!Tahh fitness function
!
SUBROUTINE MYGA_FIT_TANH()
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   IMPLICIT NONE
   DOUBLE PRECISION EBEST,ERANGE
   INTEGER I
   EBEST=MYGA_POP_ENERGY(1)
   ERANGE = MYGA_POP_ENERGY(MYGA_NSTRUC)-EBEST
   DO I=1,MYGA_NSTRUC
      MYGA_POP_FITNESS(I)=0.5D0*(1-DTANH(2.D0*((MYGA_POP_ENERGY(I)-EBEST)/ERANGE)-1.D0))
   ENDDO
   RETURN
END



