!Genetic algorithm routines for clusters (tested for LJ, Morse and binary LJ).
!
!Generate random cluster structure
!Place all atoms inside a sphere
!
SUBROUTINE MYGA_CLUSTER_RANDOM(I)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS, ONLY : NATOMS,BLJCLUSTER,BGUPTAT, NTYPEA
   IMPLICIT NONE
   INTEGER CURR_STRUC
   INTEGER I,J
   DOUBLE PRECISION DPRAND
   DOUBLE PRECISION BOXSIZE,BOX2,RADIUS
   LOGICAL INSIDE_SPHERE
   BOXSIZE=MYGA_SPHERE_RADIUS*2
   BOX2=MYGA_SPHERE_RADIUS**2
   DO J=1,NATOMS
      INSIDE_SPHERE=.FALSE.
      ! Keep trying to place atom until it is inside the sphere
      DO WHILE (INSIDE_SPHERE.EQV..FALSE.)
         MYGA_POP_COORDS(3*J-2,I)=(DPRAND()-0.5)*BOXSIZE
         MYGA_POP_COORDS(3*J-1,I)=(DPRAND()-0.5)*BOXSIZE
         MYGA_POP_COORDS(3*J  ,I)=(DPRAND()-0.5)*BOXSIZE
         RADIUS = MYGA_POP_COORDS(3*J-2,I)**2+MYGA_POP_COORDS(3*J-1,I)**2+MYGA_POP_COORDS(3*J  ,I)**2
         IF (RADIUS.LE.BOX2) THEN
            INSIDE_SPHERE=.TRUE.
         ENDIF
         !WRITE(*,*) I,J,RADIUS,INSIDE_SPHERE
      END DO
   END DO
   IF (BLJCLUSTER.OR.BGUPTAT) THEN !Assign atom types for binary clusters
      DO J=1,NTYPEA
         MYGA_POP_TYPE(J,I)=1
      ENDDO
      DO J=NTYPEA+1,NATOMS
         MYGA_POP_TYPE(J,I)=2
      ENDDO
   ENDIF
   RETURN
END
!
! Mate by Deaven and Ho cut and splice crossover
! Cut clusters at 1 or 2 points
!
SUBROUTINE MYGA_CLUSTER_MATE(ISTRUC,JSTRUC,OUT)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS, ONLY: NATOMS,BLJCLUSTER,BGUPTAT
   IMPLICIT NONE
   INTEGER I
   INTEGER POS1,POS2
   INTEGER ISTRUC,JSTRUC,OUT,ITMP
   ! Temporary structures
   DOUBLE PRECISION TMPCOOR1(3*NATOMS),TMPCOOR2(3*NATOMS),TMPCOOR3(3*NATOMS)
   INTEGER ::  TMPTYPE1(NATOMS),TMPTYPE2(NATOMS),TMPTYPE3(NATOMS)
   INTEGER :: ATOMCOUNT(2)
   DOUBLE PRECISION DPRAND
   ATOMCOUNT(1)=0
   ATOMCOUNT(2)=0
   ! Decide which structure to put first (matters for 2-point crossover).
   IF (DPRAND().LT.0.5) THEN
      ITMP=ISTRUC
      ISTRUC=JSTRUC
      JSTRUC=ITMP
   ENDIF
   !Copy coords to temporary arrays to avoid changes to already converged members of population
   DO I = 1,3*NATOMS
      TMPCOOR1(I)=MYGA_POP_COORDS(I,ISTRUC)
      TMPCOOR2(I)=MYGA_POP_COORDS(I,JSTRUC)
   ENDDO
   IF (BLJCLUSTER.OR.BGUPTAT) THEN ! For binary clusters, copy atom types
      DO I=1,NATOMS
         TMPTYPE1(I)=MYGA_POP_TYPE(I,ISTRUC)
         TMPTYPE2(I)=MYGA_POP_TYPE(I,JSTRUC)
      ENDDO
   ENDIF
!Rotate parent clusters
   CALL MYGA_CLUSTER_ROTATE_RANDOM(NATOMS,TMPCOOR1)
   CALL MYGA_CLUSTER_ROTATE_RANDOM(NATOMS,TMPCOOR2)
!Sort parent clusters
   CALL MYGA_CLUSTER_Z_SORT(NATOMS,TMPCOOR1,TMPTYPE1)
   CALL MYGA_CLUSTER_Z_SORT(NATOMS,TMPCOOR2,TMPTYPE2)
!Pick positions for crossover
   POS1 = DPRAND()*(NATOMS-2)+1  ! Random Position 1
   POS2 = DPRAND()*(NATOMS-(POS1+1)) + POS1 + 1 ! Random Position 2
   IF (MYGA_CROSS.EQ.0) THEN
      POS1 = NATOMS/2
   ENDIF
!Do crossover
!Cut and paste about positions
   DO I=1,POS1
      CALL MYGA_CLUSTER_COPYATOM(I,TMPCOOR1,TMPTYPE1,ATOMCOUNT,TMPCOOR3,TMPTYPE3)
   END DO
   IF (MYGA_CROSS.LT.2) THEN ! 1-point crossover
      DO I=POS1+1,NATOMS
         CALL MYGA_CLUSTER_COPYATOM(I,TMPCOOR2,TMPTYPE2,ATOMCOUNT,TMPCOOR3,TMPTYPE3)
      END DO
   ELSE ! 2-point crossover
      DO I=POS1+1,POS2
         CALL MYGA_CLUSTER_COPYATOM(I,TMPCOOR2,TMPTYPE2,ATOMCOUNT,TMPCOOR3,TMPTYPE3)
      END DO
      DO I=POS2+1,NATOMS
         CALL MYGA_CLUSTER_COPYATOM(I,TMPCOOR1,TMPTYPE1,ATOMCOUNT,TMPCOOR3,TMPTYPE3)
      END DO
   ENDIF
   IF (BLJCLUSTER.OR.BGUPTAT) THEN ! Re-order atoms
      CALL MYGA_CLUSTER_TYPE_SORT(NATOMS,TMPCOOR3,TMPTYPE3)
   ENDIF
! Crossover finished.
! Copy new structure to population.
   DO I = 1,3*NATOMS
      MYGA_POP_COORDS(I,OUT)=TMPCOOR3(I)
   ENDDO
   IF (BLJCLUSTER.OR.BGUPTAT) THEN ! For binary clusters, copy atom types
      DO I=1,NATOMS
         MYGA_POP_TYPE(I,OUT)=TMPTYPE3(I)
      ENDDO
   ENDIF
! Reset energy.
   MYGA_POP_ENERGY(OUT)=1d10
! Update list of attempted moves
   MYGA_POP_MOVE(1,OUT)=1
   MYGA_POP_MOVE(2,OUT)=POS1
   MYGA_POP_MOVE(3,OUT)=POS2
   MYGA_MOVE_HISTORY(1,POS1)=MYGA_MOVE_HISTORY(1,POS1)+1
   IF (MYGA_CROSS.EQ.2) THEN
      MYGA_MOVE_HISTORY(1,POS2)=MYGA_MOVE_HISTORY(1,POS2)+1
   ENDIF
   RETURN
END
!
! Mutate structure by displacing atoms
!
SUBROUTINE MYGA_CLUSTER_MUTATE_MOVE(IN,OUT)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS, ONLY: NATOMS,BLJCLUSTER,BGUPTAT,STEP
   IMPLICIT NONE
   INTEGER ATOM,I
   INTEGER IN,OUT
   DOUBLE PRECISION DPRAND
   DOUBLE PRECISION :: MUT_PROB=1.!Fraction of atoms to move (currently all)
   DOUBLE PRECISION MOVE(3) !Displacement vector for current atom
   LOGICAL OUTSIDE
   DO ATOM=1,NATOMS
      IF (DPRAND().LT.MUT_PROB) THEN
         OUTSIDE=.TRUE.
         DO WHILE(OUTSIDE)
            !Generate random move with size smaller than step
            MOVE(1)=2.*STEP(1)*(DPRAND()-0.5)
            MOVE(2)=2.*STEP(1)*(DPRAND()-0.5)
            MOVE(3)=2.*STEP(1)*(DPRAND()-0.5)
            IF (MOVE(1)**2+MOVE(2)**2+MOVE(3)**2.LE.STEP(1)**2) THEN
               OUTSIDE=.FALSE.
            ENDIF
            !WRITE(*,*) ATOM,MOVE,OUTSIDE
         ENDDO
      ELSE
         MOVE=0
      ENDIF
      MYGA_POP_COORDS(3*(ATOM-1)+1,OUT)=MYGA_POP_COORDS(3*(ATOM-1)+1,IN)+MOVE(1)
      MYGA_POP_COORDS(3*(ATOM-1)+2,OUT)=MYGA_POP_COORDS(3*(ATOM-1)+2,IN)+MOVE(2)
      MYGA_POP_COORDS(3*(ATOM-1)+3,OUT)=MYGA_POP_COORDS(3*(ATOM-1)+3,IN)+MOVE(3)
   ENDDO
   IF (BLJCLUSTER.OR.BGUPTAT) THEN ! For binary clusters, copy atom types
      DO I=1,NATOMS
         MYGA_POP_TYPE(I,OUT)=MYGA_POP_TYPE(I,IN)
      ENDDO
   ENDIF
   RETURN
END
!
! Copy an atom between two temporary structures
!
SUBROUTINE MYGA_CLUSTER_COPYATOM(ATOM,INCOOR,INTYPE,ATOMCOUNT,OUTCOOR,OUTTYPE)
   USE COMMONS, ONLY: NATOMS,BLJCLUSTER,BGUPTAT, NTYPEA
   IMPLICIT NONE
   INTEGER ATOM,OUT
   DOUBLE PRECISION INCOOR(3*NATOMS),OUTCOOR(3*NATOMS)
   INTEGER INTYPE(NATOMS),OUTTYPE(NATOMS)
   INTEGER ATOMCOUNT(2)
   INTEGER I
   ! Copy coordinates
   DO I=1,3
      OUTCOOR(3*(ATOM-1)+I)=INCOOR(3*(ATOM-1)+I)
   ENDDO
   IF (BLJCLUSTER.OR.BGUPTAT) THEN !Maintain correct cluster composition
      ATOMCOUNT(INTYPE(ATOM))=ATOMCOUNT(INTYPE(ATOM))+1
      IF (ATOMCOUNT(1).GT.NTYPEA) THEN
         OUTTYPE(ATOM)=2
      ELSE IF (ATOMCOUNT(2).GT.NATOMS-NTYPEA) THEN
         OUTTYPE(ATOM)=1
      ELSE
         OUTTYPE(ATOM)=INTYPE(ATOM)
      ENDIF
   ENDIF
   RETURN
END
!
! Sort atoms in order of z-coordinate
! This does not use the ga_params module to allow for operations
! on different sized sub-structures
!
SUBROUTINE MYGA_CLUSTER_Z_SORT(NATOMS,CLUSTER,ATTYPE)
! Original implementation was x1,...,xn,y1,...,yn,z1,...,zn
! New implementation x1,y1,z1,...,xn,yn,zn
   IMPLICIT NONE
   INTEGER NATOMS
   INTEGER IR,L,I,J
   DOUBLE PRECISION CLUSTER(3*NATOMS)
   INTEGER ATTYPE(NATOMS)
   DOUBLE PRECISION TZ,TX,TY
   INTEGER TA
!  Heap sort
   L=NATOMS/2+1
   IR=NATOMS
10 CONTINUE
   IF(L.GT.1)THEN
      L=L-1
      TZ=CLUSTER(3*L)
      TY=CLUSTER(3*L-1)
      TX=CLUSTER(3*L-2)
      TA = ATTYPE(L)
   ELSE
      TZ=CLUSTER(3*IR)
      TY=CLUSTER(3*IR-1)
      TX=CLUSTER(3*IR-2)
      TA=ATTYPE(IR)
      CLUSTER(3*IR)=CLUSTER(3)       !Z
      CLUSTER(3*IR-1)=CLUSTER(2)     !Y
      CLUSTER(3*IR-2)=CLUSTER(1)     !X
      ATTYPE(IR)=ATTYPE(1)
      IR=IR-1
      IF(IR.EQ.1)THEN
         CLUSTER(3)=TZ
         CLUSTER(2)=TY
         CLUSTER(1)=TX
         ATTYPE(1)=TA
         RETURN
      ENDIF
   ENDIF
   I=L
   J=L+L
20 IF(J.LE.IR)THEN
      IF(J.LT.IR)THEN
         IF(CLUSTER(3*J).GT.CLUSTER(3*(J+1)))J=J+1
      ENDIF
      IF(TZ.GT.CLUSTER(3*J))THEN
         CLUSTER(3*I)=CLUSTER(3*J)     !Z
         CLUSTER(3*I-1)=CLUSTER(3*J-1) !Y
         CLUSTER(3*I-2)=CLUSTER(3*J-2) !X
         ATTYPE(I)=ATTYPE(J)
         I=J
         J=J+J
      ELSE
         J=IR+1
      ENDIF
      GO TO 20
   ENDIF
   CLUSTER(3*I)=TZ
   CLUSTER(3*I-1)=TY
   CLUSTER(3*I-2)=TX
   ATTYPE(I)=TA
   GO TO 10
   RETURN
END
!
! Sort cluster so that all A atoms are before all B atoms
!
SUBROUTINE MYGA_CLUSTER_TYPE_SORT(NATOMS,CLUSTER,ATTYPE)
! Original implementation was x1,...,xn,y1,...,yn,z1,...,zn
! New implementation x1,y1,z1,...,xn,yn,zn
   IMPLICIT NONE
   INTEGER NATOMS
   INTEGER I,TAG
   DOUBLE PRECISION CLUSTER(3*NATOMS)
   INTEGER ATTYPE(NATOMS)
   DOUBLE PRECISION TZ,TX,TY
   INTEGER TA
!  Heap sort
   TAG=1
   DO I=1,NATOMS
      IF (ATTYPE(I).EQ.1) THEN
         TZ=CLUSTER(3*I)
         TY=CLUSTER(3*I-1)
         TX=CLUSTER(3*I-2)
         TA=ATTYPE(I)
         CLUSTER(3*I)=CLUSTER(3*TAG)
         CLUSTER(3*I-1)=CLUSTER(3*TAG-1)
         CLUSTER(3*I-2)=CLUSTER(3*TAG-2)
         ATTYPE(I)=ATTYPE(TAG)
         CLUSTER(3*TAG)=TZ
         CLUSTER(3*TAG-1)=TY
         CLUSTER(3*TAG-2)=TX
         ATTYPE(TAG)=TA
         TAG=TAG+1
      ENDIF
   ENDDO
   RETURN
END
!
! Rotate a structure by random values of theta and phi
! This does not use the ga_params module to allow for operations
! on different sized sub-structures
!
SUBROUTINE MYGA_CLUSTER_ROTATE_RANDOM(NATOMS,CLUSTER)
   IMPLICIT NONE
   INTEGER NATOMS
   INTEGER I
! NOTE: FORMAT=X1,Y1,Z1,...,XN,YN,ZN
   DOUBLE PRECISION CLUSTER(3*NATOMS)
   DOUBLE PRECISION ROT11
   DOUBLE PRECISION ROT12
   DOUBLE PRECISION ROT13
   DOUBLE PRECISION ROT21
   DOUBLE PRECISION ROT22
   DOUBLE PRECISION ROT23
   DOUBLE PRECISION ROT31
   DOUBLE PRECISION ROT32
   DOUBLE PRECISION ROT33
   DOUBLE PRECISION THETA
   DOUBLE PRECISION PHI
   DOUBLE PRECISION RATOMSX
   DOUBLE PRECISION RATOMSY
   DOUBLE PRECISION RATOMSZ
   DOUBLE PRECISION DPRAND ! RANDOM NUMBER GENERATOR
!  DOUBLE PRECISION, PARAMETER :: PI = 4.d0*ATAN(1.D0)
   DOUBLE PRECISION, PARAMETER :: PI = 3.141592654D0
!  Generate random plane
   THETA = DPRAND()*(PI/2.D0) ! RANDOM NUMBER IN RANGE 2PI
   PHI = DPRAND()*PI  ! RANDOM NUMBER IN RANGE PI
! Set up rotation matrix
  ROT11 = DBLE(COS(PHI))
  ROT12 = 0.D0
  ROT13 = DBLE(-SIN(PHI))
  ROT21 = DBLE(SIN(THETA)*SIN(PHI))
  ROT22 = DBLE(COS(THETA))
  ROT23 = DBLE(SIN(THETA)*COS(PHI))
  ROT31 = DBLE(COS(THETA)*SIN(PHI))
  ROT32 = DBLE(-SIN(THETA))
  ROT33 = DBLE(COS(THETA)*COS(PHI))
  RATOMSX = 0.D0  ! SET FOR TEMP VARIABLES X
  RATOMSY = 0.D0  ! SET FOR TEMP VARIABLES Y
  RATOMSZ = 0.D0  ! SET FOR TEMP VARIABLES Z
! Rotation
  DO I=1,NATOMS
      RATOMSX = ROT11*CLUSTER(3*I-2) + ROT12*CLUSTER(3*I-1)+ ROT13*CLUSTER(3*I)
      RATOMSY = ROT21*CLUSTER(3*I-2) + ROT22*CLUSTER(3*I-1)+ ROT23*CLUSTER(3*I)
      RATOMSZ = ROT31*CLUSTER(3*I-2) + ROT32*CLUSTER(3*I-1)+ ROT33*CLUSTER(3*I)
      CLUSTER(3*I-2) = RATOMSX
      CLUSTER(3*I-1) = RATOMSY
      CLUSTER(3*I)   = RATOMSZ
   END DO
   RETURN
END

