!mo361
! Genetic algorithm routines for BLN model proteins
!
! Generate a random BLN protein structure
SUBROUTINE MYGA_BLN_RANDOM(CURR_STRUC)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY : NATOMS
   IMPLICIT NONE
   INTEGER CURR_STRUC,J
!  DOUBLE PRECISION, PARAMETER :: PI = 4.d0*ATAN(1.D0)
   DOUBLE PRECISION, PARAMETER :: PI = 3.141592654D0
   DOUBLE PRECISION DPRAND
! Set up bond distances
   DO J=2,NATOMS
      MYGA_POP_GENOME(3*J-2,CURR_STRUC)=1D0
   ENDDO
! Set up bond angles
   DO J=3,NATOMS
      MYGA_POP_GENOME(3*J-1,CURR_STRUC)=1.8326
   ENDDO
! Set up torsion angles
   DO J=4,NATOMS
      MYGA_POP_GENOME(3*J  ,CURR_STRUC)=(DPRAND()-0.5)*2.*PI
   ENDDO
   CALL IC2CART(CURR_STRUC)
   RETURN
END
!
!Convert from internal coordinates to cartesian coordinates
!
SUBROUTINE IC2CART(STRUC)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY : NATOMS
   IMPLICIT NONE
   INTEGER I
   INTEGER STRUC
   DOUBLE PRECISION M(3,3),D2(3),D(3),N(3),AB(3),BC(3),Y(3)
   DOUBLE PRECISION R,THETA,PSI
   !PLACE 1ST ATOM
   MYGA_POP_COORDS(1,STRUC)=0D0
   MYGA_POP_COORDS(2,STRUC)=0D0
   MYGA_POP_COORDS(3,STRUC)=0D0
   !PLACE 2ND ATOM
   MYGA_POP_COORDS(4,STRUC)=0D0
   MYGA_POP_COORDS(5,STRUC)=0D0
   MYGA_POP_COORDS(6,STRUC)=MYGA_POP_GENOME(4,STRUC)
   ! PLACE 3RD ATOM
   MYGA_POP_COORDS(7,STRUC)=0D0
   MYGA_POP_COORDS(8,STRUC)=DSIN(MYGA_POP_GENOME(8,STRUC))*MYGA_POP_GENOME(7,STRUC)
   MYGA_POP_COORDS(9,STRUC)=MYGA_POP_COORDS(6,STRUC)-DCOS(MYGA_POP_GENOME(8,STRUC))*MYGA_POP_GENOME(7,STRUC)
   !PLACE OTHER ATOMS WITH NERF METHOD
   DO I=4,NATOMS
      R=MYGA_POP_GENOME(3*I-2,STRUC)
      THETA=MYGA_POP_GENOME(3*I-1,STRUC)
      PSI=MYGA_POP_GENOME(3*I,STRUC)
      D2(1)=-R*DCOS(THETA)
      D2(2)=R*DSIN(THETA)*DCOS(PSI)
      D2(3)=R*DSIN(THETA)*DSIN(PSI)
      AB(1)=(MYGA_POP_COORDS(3*I-8,STRUC)-MYGA_POP_COORDS(3*I-11,STRUC))/MYGA_POP_GENOME(3*I-8,STRUC)
      AB(2)=(MYGA_POP_COORDS(3*I-7,STRUC)-MYGA_POP_COORDS(3*I-10,STRUC))/MYGA_POP_GENOME(3*I-8,STRUC)
      AB(3)=(MYGA_POP_COORDS(3*I-6,STRUC)-MYGA_POP_COORDS(3*I-9,STRUC))/MYGA_POP_GENOME(3*I-8,STRUC)
      BC(1)=(MYGA_POP_COORDS(3*I-5,STRUC)-MYGA_POP_COORDS(3*I-8,STRUC))/MYGA_POP_GENOME(3*I-5,STRUC)
      BC(2)=(MYGA_POP_COORDS(3*I-4,STRUC)-MYGA_POP_COORDS(3*I-7,STRUC))/MYGA_POP_GENOME(3*I-5,STRUC)
      BC(3)=(MYGA_POP_COORDS(3*I-3,STRUC)-MYGA_POP_COORDS(3*I-6,STRUC))/MYGA_POP_GENOME(3*I-5,STRUC)
      CALL CROSSPROD3(N,AB,BC) ! GET NORMAL
      N=N/DSQRT(N(1)**2+N(2)**2+N(3)**2) !NORMALISE N
      CALL CROSSPROD3(Y,N,BC)
      ! GET M
      M(1,1)=BC(1)
      M(2,1)=BC(2)
      M(3,1)=BC(3)
      M(1,2)=Y(1)
      M(2,2)=Y(2)
      M(3,2)=Y(3)
      M(1,3)=N(1)
      M(2,3)=N(2)
      M(3,3)=N(3)
      D(1)=M(1,1)*D2(1)+M(1,2)*D2(2)+M(1,3)*D2(3)
      D(2)=M(2,1)*D2(1)+M(2,2)*D2(2)+M(2,3)*D2(3)
      D(3)=M(3,1)*D2(1)+M(3,2)*D2(2)+M(3,3)*D2(3)
      !WRITE(*,*)(AB(1)**2+AB(2)**2+AB(3)**2),(BC(1)**2+BC(2)**2+BC(3)**2),(N(1)**2+N(2)**2+N(3)**2)
      MYGA_POP_COORDS(3*I-2,STRUC)=MYGA_POP_COORDS(3*I-5,STRUC)+D(1)
      MYGA_POP_COORDS(3*I-1,STRUC)=MYGA_POP_COORDS(3*I-4,STRUC)+D(2)
      MYGA_POP_COORDS(3*I  ,STRUC)=MYGA_POP_COORDS(3*I-3,STRUC)+D(3)
   ENDDO
   RETURN
END
!
!Cross product
!a=bXc
!
SUBROUTINE CROSSPROD3(A,B,C)
   IMPLICIT NONE
   DOUBLE PRECISION, INTENT(OUT):: A(3)
   DOUBLE PRECISION, INTENT(IN)::B(3),C(3)
   A(1)=B(2)*C(3)-B(3)*C(2)
   A(2)=B(3)*C(1)-B(1)*C(3)
   A(3)=B(1)*C(2)-B(2)*C(1)
   RETURN
END
!
!Convert cartesian coordinates to internal coordinates
!
SUBROUTINE CART2IC(STRUC)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY : NATOMS
   IMPLICIT NONE
   INTEGER I
   INTEGER STRUC
   ! TEMPORARY STORES  OF COORDINATES, DISTANCES & ANGLES TAKEN FROM GMIN
   INTEGER N
   DOUBLE PRECISION QO(3*NATOMS)
   DOUBLE PRECISION X(NATOMS), Y(NATOMS), Z(NATOMS), XR(NATOMS,NATOMS), DFAC(NATOMS), &
        YR(NATOMS,NATOMS), ZR(NATOMS,NATOMS), DOT_PROD(NATOMS,3), COSTOR(NATOMS), D_BLN(NATOMS), &
        A_BLN(NATOMS), B_BLN(NATOMS), X_PROD(NATOMS), BOND_ANGLE(NATOMS), TOR_ANGLE(NATOMS), &
        RADII(NATOMS,NATOMS), SINBOND(NATOMS), C_BLN(NATOMS)
   !Take copy of coordinates
   DO I=1,3*NATOMS
      QO(I)=MYGA_POP_COORDS(I,STRUC)
   ENDDO
   N=NATOMS
   ! Call GMIN internal coordinates subroutine
   CALL CALC_INT_COORDSBLN(QO,N,X,Y,Z,XR,YR,ZR,DOT_PROD,X_PROD,BOND_ANGLE,TOR_ANGLE,RADII,NATOMS,&
                                    COSTOR,SINBOND,A_BLN,B_BLN,C_BLN,D_BLN,DFAC)
   ! Copy back distances
   DO I=2,NATOMS
      MYGA_POP_GENOME(3*I-2,STRUC)=RADII(I,I-1)
   ENDDO
   ! Copy back angles
   DO I=3,NATOMS
      MYGA_POP_GENOME(3*I-1,STRUC)=BOND_ANGLE(I-1)
   ENDDO
   ! Copy back torsions
   DO I=4,NATOMS
      MYGA_POP_GENOME(3*I,STRUC)=TOR_ANGLE(I-2)
   ENDDO
   RETURN
END
!
! Mate by 1- or 2-point crossover
!
SUBROUTINE MYGA_BLN_MATE(ISTRUC,JSTRUC,CURR_STRUC)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY: NATOMS
   IMPLICIT NONE
   INTEGER ISTRUC,JSTRUC,CURR_STRUC
   DOUBLE PRECISION DPRAND
   INTEGER POS1,SOURCE
   LOGICAL, ALLOCATABLE :: CROSSOVER(:)
   LOGICAL COPY
   INTEGER I,J
   ! Set up array for crossover points
   IF (.NOT. ALLOCATED(CROSSOVER)) THEN
      ALLOCATE(CROSSOVER(NATOMS))
   ENDIF
   CROSSOVER=.FALSE.
   ! Select crossover points
   DO I=1,MYGA_CROSS
      COPY=.TRUE.
      DO WHILE(COPY)
         ! Pick random point in genome
         POS1=4+INT(DPRAND()*(NATOMS-3))
         ! Have we picked this point already?
         IF (.NOT.CROSSOVER(POS1)) THEN
            COPY=.FALSE.
            CROSSOVER(POS1)=.TRUE.
         ENDIF
      ENDDO
   ENDDO
   ! Choose which parent provides first section of genome
   IF (DPRAND().LT.0.5) THEN
      SOURCE = 1
   ELSE
      SOURCE = -1
   ENDIF
   ! Do crossover
   POS1=1
   DO I=1,NATOMS
      IF (CROSSOVER(I)) THEN
         SOURCE=-SOURCE
         MYGA_POP_MOVE(POS1+1,CURR_STRUC)=I
         MYGA_MOVE_HISTORY(1,I)=MYGA_MOVE_HISTORY(1,I)+1
         POS1=POS1+1
      ENDIF
      DO J=1,3
         IF (SOURCE.EQ.1) THEN
            MYGA_POP_GENOME(3*(I-1)+J,CURR_STRUC)=MYGA_POP_GENOME(3*(I-1)+J,ISTRUC)
         ELSE
            MYGA_POP_GENOME(3*(I-1)+J,CURR_STRUC)=MYGA_POP_GENOME(3*(I-1)+J,JSTRUC)
         ENDIF
      ENDDO
   ENDDO
   ! Make structure for new genome
   CALL IC2CART(CURR_STRUC)
   MYGA_POP_ENERGY(CURR_STRUC)=1d10
   ! Update list of attempted moves
   MYGA_POP_MOVE(1,CURR_STRUC)=1
   RETURN
END
!
! Mate by uniform crossover
!
SUBROUTINE MYGA_BLN_MATE_UNIFORM(ISTRUC,JSTRUC,CURR_STRUC)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY: NATOMS
   IMPLICIT NONE
   INTEGER ISTRUC,JSTRUC,CURR_STRUC
   DOUBLE PRECISION DPRAND
   INTEGER I,J
   DO I=1,NATOMS
      IF (DPRAND().LT.0.5) THEN
         DO J=1,3
            MYGA_POP_GENOME(3*(I-1)+J,CURR_STRUC)=MYGA_POP_GENOME(3*(I-1)+J,ISTRUC)
         ENDDO
      ELSE
         DO J=1,3
            MYGA_POP_GENOME(3*(I-1)+J,CURR_STRUC)=MYGA_POP_GENOME(3*(I-1)+J,JSTRUC)
         ENDDO
      ENDIF
   ENDDO
   CALL IC2CART(CURR_STRUC)
   MYGA_POP_ENERGY(CURR_STRUC)=1d10
   ! Update list of attempted moves
   MYGA_POP_MOVE(1,CURR_STRUC)=1
   RETURN
END
!
! Mutate by replacing one torsion angle
!
SUBROUTINE MYGA_BLN_MUTATE_TOR(INSTRUC,OUTSTRUC)
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY: NATOMS
   IMPLICIT NONE
   INTEGER INSTRUC,OUTSTRUC
   DOUBLE PRECISION DPRAND
!  DOUBLE PRECISION, PARAMETER :: PI = 4.d0*ATAN(1.D0)
   DOUBLE PRECISION, PARAMETER :: PI = 3.141592654D0
   INTEGER POS,I
   POS=4+INT(DPRAND()*(NATOMS-3))
   DO I=1,3*NATOMS
      MYGA_POP_GENOME(I,OUTSTRUC)=MYGA_POP_GENOME(I,INSTRUC)
   ENDDO
   MYGA_POP_GENOME(3*POS,OUTSTRUC)=(DPRAND()-0.5)*2.*PI
   CALL IC2CART(OUTSTRUC)
   MYGA_POP_ENERGY(OUTSTRUC)=1D10
   ! Update list of attempted moves
   MYGA_POP_MOVE(1,OUTSTRUC)=2
   MYGA_POP_MOVE(2,OUTSTRUC)=POS
   MYGA_MOVE_HISTORY(3,POS)=MYGA_MOVE_HISTORY(3,POS)+1
   RETURN
END

SUBROUTINE MYGA_BLN_ANGULAR_STATS
   USE MYGA_PARAMS
   USE MYGA_POPULATION
   USE COMMONS , ONLY : NATOMS,MYUNIT
   IMPLICIT NONE
   DOUBLE PRECISION, PARAMETER :: PI = 3.141592654
   INTEGER I,J
   DOUBLE PRECISION SBAR,CBAR,THETA,VAR
   DO I=1,NATOMS
      SBAR=0
      CBAR=0
      DO J=1,MYGA_NSTRUC
         SBAR=SBAR+DSIN(MYGA_POP_GENOME(3*I,J))
         CBAR=CBAR+DCOS(MYGA_POP_GENOME(3*I,J))
      ENDDO
      SBAR=SBAR/DBLE(MYGA_NSTRUC)
      CBAR=CBAR/DBLE(MYGA_NSTRUC)
      THETA=DATAN2(SBAR,CBAR)
      IF (THETA.LT.0) THEN
         THETA=THETA+2*PI
      ENDIF
      VAR=1-DSQRT(SBAR**2+CBAR**2)
      WRITE(MYUNIT,'(A,I5,4(F8.3))')"GA> ANGLE",I,SBAR,CBAR,THETA,VAR
   ENDDO
   RETURN
END
