/**
 *   ___ _   _ ___   _     _       ___ ___ ___ ___
 *  / __| | | |   \ /_\   | |  ___| _ ) __/ __/ __|
 * | (__| |_| | |) / _ \  | |_|___| _ \ _| (_ \__ \
 *  \___|\___/|___/_/ \_\ |____|  |___/_| \___|___/
 *
 * File amber_cuda.cu: Implementation of class gpu_amber
 *
 **/

#include "CudaLBFGS/lbfgs.h"
#include "CudaLBFGS/cost_function.h"
#include "CudaLBFGS/potential.h"
#include "gpu.h"

void gpu_amber::f_gradf(const double *d_x, double *d_f, double *d_grad, _Bool *coldfusiont, double *coldfusionlim)
{
	double testenergy;

	gmin_copy_crd_(d_x);		// Copy coordinates to correct location in device memory 
	CudaCheckError();
	cudaDeviceSynchronize();

	gmin_gpu_gb_ene_(d_f);		// Energy calculation
	CudaCheckError();
	cudaDeviceSynchronize();

	gmin_copy_frc_(d_grad);		// Copy forces back
	CudaCheckError();
	cudaDeviceSynchronize();

	CudaSafeCall( cudaMemcpy(&testenergy, d_f, sizeof(double), cudaMemcpyDeviceToHost) );
	if (testenergy < *coldfusionlim){	// Test for cold fusion
		*coldfusiont = 1;
	}
}
