/**
 *   ___ _   _ ___   _     _       ___ ___ ___ ___
 *  / __| | | |   \ /_\   | |  ___| _ ) __/ __/ __|
 * | (__| |_| | |) / _ \  | |_|___| _ \ _| (_ \__ \
 *  \___|\___/|___/_/ \_\ |____|  |___/_| \___|___/
 *
 * File potential.h: Potential classes deriving from cost_function. 
 **/

#ifndef POTENTIAL_H
#define POTENTIAL_H

class gpu_lj : public cost_function
{
	public:
		gpu_lj(size_t ndim);
		~gpu_lj() {}
		void f_gradf(const double *d_x, double *d_f, double *d_grad, _Bool *coldfusiont, double *coldfusionlim);
	private:
		int shared_size;
		dim3 blockDim;
		dim3 gridDim;
};

class gpu_amber : public cost_function
{
	public:
		gpu_amber(size_t ndim) : cost_function(ndim) {}
		~gpu_amber() {}
		void f_gradf(const double *d_x, double *d_f, double *d_grad, _Bool *coldfusiont, double *coldfusionlim);
	private:
};

#endif /* end of include guard: POTENTIAL_H */
