/* This work is a modification of code written by Jens Wetzl and Oliver Taubamann in 2012. 
 * The original work can be found here: https://github.com/jwetzl/CudaLBFGS 
 * This work is not endorsed by the authors. */

/**
 *   ___ _   _ ___   _     _       ___ ___ ___ ___
 *  / __| | | |   \ /_\   | |  ___| _ ) __/ __/ __|
 * | (__| |_| | |) / _ \  | |_|___| _ \ _| (_ \__ \
 *  \___|\___/|___/_/ \_\ |____|  |___/_| \___|___/
 *
 * File cost_function.h: Cost function base classes.
 *                       Derive your own from one of them
 *                       and feed it to the minimizer.
 *
 **/

#ifndef COST_FUNCTION_H
#define COST_FUNCTION_H

#include <iostream>
#include <cstdlib>

// GPU based cost functions can directly inherit from this class
// and implement f_gradf(), the passed pointers are supposed
// to reside in device memory.
class cost_function
{
	public:
		cost_function(size_t numDimensions)
			: m_numDimensions(numDimensions)
		{}

		virtual ~cost_function() {}

		// Implement this method computing both function value d_f
		// and gradient d_gradf of your cost function at point d_x.
		virtual void f_gradf(const double *d_x, double *d_f, double *d_gradf, _Bool *coldfusiont, double *coldfusionlim) = 0;

		size_t getNumberOfUnknowns() const
		{
			return m_numDimensions;
		}

	protected:
		size_t m_numDimensions;
};

#endif /* end of include guard: COST_FUNCTION_H */
