!  GMIN: A program for finding global minima
!  Copyright (C) 1999-2006 David J. Wales
!  This file is part of GMIN.
!
!  GMIN is free software; you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation; either version 2 of the License, or
!  (at your option) any later version.
!
!  GMIN is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with this program; if not, write to the Free Software
!  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
      MODULE COMMONS
      USE NOA
      IMPLICIT NONE
      SAVE
      INTEGER :: NATOMS, NACCEPT, MAXIT, NTARGETS, NN, MM, NPAR, NPATCH, TIPID, PAHID, NSYMREM=0, NFREEZE, NSAVEINTE, &
     &        NINTV, NSEED, NVEC, NS, NSSTOP, MAXIT2, NSAVE, SHELLMOVEMAX, HPTGRP, NFIX, CURRENTIMP,&
     &        MCSTEPS(3), NRUNS, NVAR, MYPOWER, XMUL,  NTAB, NCARBON, NCOOP, NSYMINTERVAL, QDLIMIT, COULN, &
     &        NSUPER, NSACCEPT, NSUPERSTEP, GMODES, QUENCHFRQ, CHNRES, CHECKDID, &
     &        NEVL, NEVS, NVECTORS, MUPDATE, LSYS, NHSMOVE, NRENORM, NRELAX, NHSRESTART, NRENSTUCK,&
     &        HBINS, NRBSITES, NRBSITES1, NPS, GATOM, NMSBSAVE, MAXSAVE, NSYMQMAX, EQUIL, TPAHA, ISTEP, &
     &        NINTS, NumberOfTrajectories, &
     &        MCCycles, MCCyclesEquilibration, TargetWL, NTempPoints, SaveNth, DumpEveryNthQuench, NSpline, Hwindows, & 
     &        lhbins, sampledbins, MYNODE, NENRPER, DUMPINT, MYUNIT, PRTFRQ, BSPTDUMPFRQ, NPERMGROUP, NMOVABLEATOMS, &
     &        CPS, CPF, ACKLANDID, PATOM1, PATOM2, CSMGPINDEX, CSMGUIDEGPINDEX, CSMSTEPS, CSMQUENCHES, CSMMAXIT, &
     &        MYEUNIT, MYMUNIT, MYBUNIT, MYRUNIT, MYPUNIT, NFREEZETYPEA, &
     &        TBPSTEPS, TBPCI, TBPBASIN, NTSITES, NRBGROUP, NZERO, PTMCDS_FRQ, PTMCDUMPENERFRQ, MONITORINT, NBLOCKS, &
     &        BINARY_EXAB_FRQ, NRESMIN, USERES, EXEQ, NONEDAPBC, STRUC, CHEMSHIFTITER, GRIDSIZE, MFETRUNS, BESTINVERT
 
      DOUBLE PRECISION RHO, GAMMA, SIG, SCEPS, SCC, TOLB, T12FAC, XMOVERENORM, RESIZE, QTSALLIS, &
     &                 CQMAX, RADIUS, BQMAX,  MAXBFGS, DECAYPARAM, SYMTOL1, SYMTOL2, SYMTOL3, SYMTOL4, SYMTOL5, &
     &                 ECONV, TOLD, TOLE, SYMREM(120,3,3), GMAX, CUTOFF, PCUT, EXPFAC, EXPD, CENTX, CENTY, CENTZ, &
     &                 BOXLX, BOXLY, BOXLZ, BOX3D(3), PCUTOFF, SUPSTEP, SQUEEZER, SQUEEZED, COOPCUT, STOCKMU, STOCKLAMBDA, &
     &                 TFAC(3), RMS, TEMPS, SACCRAT, CEIG, PNEWJUMP, EAMP, DISTFAC, ODDCHARGE, COULQ, COULSWAP, &
     &                 COULTEMP, APP, AMM, APM, XQP, XQM, ALPHAP, ALPHAM, ZSTAR, K_COMP, DGUESS, GUIDECUT, EFAC,& 
     &                 TRENORM, HISTMIN, HISTMAX, HISTFAC, EPSSPHERE, FINALCUTOFF, SHELLPROB, RINGROTSCALE, &
     &                 HISTFACMUL, HPERCENT, AVOIDDIST, MAXERISE, MAXEFALL, TSTART, MATDIFF, STICKYSIG, SDTOL, &
     &                 MinimalTemperature, MaximalTemperature, SwapProb, hdistconstraint, COREFRAC, TSTAR, &
     &                 RK_R, RK_THETA,ARMA,ARMB, ExtrapolationPercent, lnHarmFreq, PTEMIN, PTEMAX, PTTMIN, PTTMAX, EXCHPROB, &
     &                 PTSTEPS, NEQUIL, NQUENCH, COLDFUSIONLIMIT, NEWRES_TEMP, MINOMEGA, LJSIGMA, LJEPSILON, TAUMAX, &
     &                 TAUMAXFULL, CPFACTORSG, CPFACTORFG, VGWTOL, ABTHRESH, ACTHRESH, CSMPMAT(3,3), &
     &                 RADIUS_CONTAINER, HYDROPHOBIC, RESTRICTREGIONX0, RESTRICTREGIONY0, RESTRICTREGIONZ0, &
     &                 RESTRICTREGIONRADIUS, HARMONICSTR, DUMPUNIQUEEPREV, DUMPUNIQUEEMARKOV, FREEZESAVEE, &
     &                 TBPMIN, TBPSTEP, TBPHF, TBPCF, TBPINCR, SHIFTV, GEOMDIFFTOL, LJATTOC, &
     &                 SRATIO, TRATIO, EXCHINT, DDMCUT, SUMTEMP, SUMSTEP, SUMOSTEP, EXPANDFACTOR, ROTATEFACTOR, EPSRIGID, &
     &                 CONTOURBOUNDS(3,2), KCOMP_RIGID, RIGIDCOMDIST, PALPHA, PBETA, PGAMMA, LAT(3,3), MFETPCTL, MFETTRGT, QUIPEQDIST, &
!
!   parameters for anisotropic potentials
!
!    DC430 >
     &                 CAPEPS2, CAPRAD, CAPRHO, CAPHEIGHT1, CAPHEIGHT2, &
     &                 EPSR, GBKAPPA, GBKAPPRM, GBMU,GBNU, GBSIGNOT, GBEPSNOT, GBCHI, GBCHIPRM, &
     &                 SIGNOT, EPSNOT, SIGMAF, INVKAP, ESA(3), LPRSQ, LSQDFR, GBDPMU, GBDPEPS, GBDPFCT, &
     &                 PYSIGNOT, PYEPSNOT, PYA1(3), PYA2(3), PYDPMU, PYDPEPS, PYDPFCT, &
     &                 LWRCUT, LWCNSTA, LWCNSTB, LWRCUTSQ, LWRCUT2SQ, DELRC, PAPALP, PAPS, PAPCD, PAPEPS, PAPANG1, PAPANG2, &    
     &                 DBEPSBB, DBEPSAB, DBSIGBB, DBSIGAB, DBPMU, EFIELD, YKAPPA, YEPS, GEMRC, MREQ, HSEFF, BEPS, &
     &                 EPS11, EPS22, EPS12, MRHO11, MRHO22, MRHO12, REQ11, REQ22, REQ12, &
     &                 RHOCC0, RHOCC10, RHOCC20,  RHOHH0, RHOHH10, RHOHH20, RHOCH0, RHOC10H, &
     &                 RHOCH10, RHOC20H, RHOCH20, ALPHACC, ALPHAHH, ALPHACH, DC6CC, DC6HH, DC6CH, KKJ, CCKJ, SYMFCTR, &
     &                 GBANISOTROPYR,GBWELLDEPTHR,PARAMa1,PARAMb1,PARAMc1,PARAMa2,PARAMB2,PARAMc2,PSIGMA0(2),PEPSILON0,&
     &                 PEPSILON1(3),PSCALEFAC1(2),PSCALEFAC2(2),PYA11(3),PYA21(3),PYA12(3),PYA22(3), &
     &                 PEPSILONATTR(2),PSIGMAATTR(2), PYOVERLAPTHRESH, PYCFTHRESH, LJSITECOORDS(3), &
     &                 MSTART,MFINISH,MBSTART1,MBFINISH1,MBSTART2,MBFINISH2,MBHEIGHT1,MBHEIGHT2,ME1,ME2,ME3, &
     &                 BSPTQMAX, BSPTQMIN, PFORCE, CSMNORM, CSMGUIDENORM, CSMEPS, PERCCUT, &
     &                 LOWESTE, PERTSTEP, ORBITTOL
!
      LOGICAL DEBUG, TARGET, MORSET, CUTT, SEEDT, CENT, TSALLIST, FREEZECORE, NEWJUMP, RENORM, CAPSID, FREEZE, &
     &        OTPT, LJMFT, STRANDT, PAHT, SWT, MSTRANST, STOCKT, STICKYT, BLNT, MYSDT, FREEZERES, CENTXY, &
     &        MSORIGT, SQUEEZET, PERIODIC, SCT, MSCT, RESIZET, TIP, RIGID, CALCQT, MPIT, JMT, LJCOULT, SETCENT, &
     &        SORTT, HIT, SAVEQ, PARALLELT, FIXD, RKMIN, BSMIN, PERMDIST, PERMOPT, BSWL, BSPT, BSPTRESTART, &
     &        SYMMETRIZE, SYMMETRIZECSM, PRINT_PTGRP, DUMPT, NEON, ARGON, P46, NORESET, TABOOT, EVSTEPT, PACHECO, DL_POLY, QUCENTRE, &
     &        STAR, PLUS, TWOPLUS, GROUND, DIPOLE, DFTBT, DFTBCT, SW, SUPERSTEP, EAMLJT, PBGLUET, TRACKDATAT, &
     &        EAMALT, ALGLUET, MGGLUET, GUPTAT, LJATT, FST, DECAY, COOP, FIXBIN, GAUSST, QUENCHDOS, FIXDIHEFLAG, &
     &        FRAUSIT, ANGST, SELFT, STEPOUT, WENZEL, THRESHOLDT, THOMSONT, MULLERBROWNT, CHARMMENERGIES, &
     &        PROJ, RGCL2, TOSI, WELCH, AXTELL, AMBER, FIXIMAGE, BINARY, SHIFTCUT, ARNO, TUNNELT, TWOD, & 
     &        BLJCLUSTER, BLJCLUSTER_NOCUT, COMPRESST, FIX, FIXT, BFGS, LBFGST, DBRENTT, DZTEST, FNI, FAL, CPMD, TNT, ZETT1, &
     &        ZETT2, RESTART, CONJG, NEWRESTART, AVOID, NATBT, DIFFRACTT, CHRMMT, INTMINT, LB2T, & 
     &        PTMC, BINSTRUCTURES, PROGRESS, MODEL1T, NEWRESTART_MD, CHANGE_TEMP, NOCISTRANS, CHECKCHIRALITY, &
     &        GBT, GBDT, GBDPT, GEMT, LINRODT, RADIFT, CAPBINT, DBPT, DBPTDT, DMBLMT, DMBLPYT, EFIELDT, PAHAT, STOCKAAT, MORSEDPT, &
     &        MSGBT, MSTBINT, MMRSDPT, MSSTOCKT, LWOTPT, NCAPT, NPAHT, NTIPT, PAHW99T, ELLIPSOIDT, GAYBERNET,& 
     &        MULTPAHAT, PAPT, PAPBINT, PAPJANT, PTSTSTT, SHIFTED, SILANET, TDHDT, DDMT, WATERDCT, WATERKZT, CHECKDT, CHECKMARKOVT,& 
     &        TETHER, HISTSMOOTH, VISITPROP, ARMT, FixedEndMoveT, FIXCOM, RESTORET, QUADT, AMHT, MOVESHELLT, QDT, QD2T, &
     &        PARAMONOVPBCX, PARAMONOVPBCY, PARAMONOVPBCZ, PARAMONOVCUTOFF, GAYBERNEDCT, UNFREEZERES, FREEZEALL, &
     &        PROJIT, PROJIHT, LEAPDIHE, DUMPQUT, DUMPBESTT, LJSITE, BLJSITE, LJSITEATTR, DUMPSTEPST, &
     &        AMBERT, RANDOMSEEDT, PYGPERIODICT, LJCAPSIDT, PYBINARYT, SWAPMOVEST, MOVABLEATOMST, LIGMOVET,DUMPSTRUCTURES, &
     &        LJSITECOORDST, VGW, ACKLANDT, G46, DF1T, PULLT, LOCALSAMPLET, CSMT, A9INTET, INTERESTORE, COLDFUSION, &
     &        CSMGUIDET, MULTISITEPYT, CHAPERONINT, AVOIDRESEEDT, OHCELLT, UNFREEZEFINALQ, PERCOLATET, PERCT, PERCACCEPTED,&
     &        GENALT, MINDENSITYT, RESTRICTREGION, RESTRICTREGIONTEST, RESTRICTCYL, ACK1, ACK2, HARMONICF,&
     &        HARMONICDONTMOVE, DUMPUNIQUE, FREEZESAVE, TBP, RBSYMT, PTMCDUMPSTRUCT, PTMCDUMPENERT, PYCOLDFUSION, MONITORT,&
     &        CHARMMDFTBT, PERMINVOPT, BLOCKMOVET, MAXERISE_SET, PYT, BINARY_EXAB, CHIROT, SANDBOXT, &
     &        RESERVOIRT, DISTOPT, ONEDAPBCT, ONEDPBCT, TWODAPBCT, TWODPBCT, THREEDAPBCT, THREEDPBCT, RATIOT, &
     &        PTRANDOM, PTINTERVAL, PTSINGLE, PTSETS, CHEMSHIFT, CHEMSHIFT2, CSH, DEBUGss2029, UNIFORMMOVE, RANSEEDT, &
     &        TTM3T, NOINVERSION, RIGIDCONTOURT, UPDATERIGIDREFT, HYBRIDMINT, COMPRESSRIGIDT, MWFILMT, &
     &        SUPPRESST, MFETT, POLIRT, QUIPT, SWPOTT, MWPOTT, REPMATCHT, GLJT, MLJT, READMASST, NEWTSALLIST, &
     &        PHI4MODELT, CUDAT, CUDATIMET, AMBER12T, ENERGY_DECOMPT, NEWMOVEST
!
      DOUBLE PRECISION, ALLOCATABLE:: ATMASS(:) 

! csw34> FREEZEGROUP variables
!
      INTEGER :: GROUPCENTRE
      DOUBLE PRECISION :: GROUPRADIUS
      CHARACTER (LEN=2) :: FREEZEGROUPTYPE
      LOGICAL :: FREEZEGROUPT
! END

!
! csw34> DONTMOVE variables
!
      INTEGER :: NDONTMOVE, DONTMOVECENTRE
      DOUBLE PRECISION :: DONTMOVERADIUS
      CHARACTER (LEN=2) :: DONTMOVEGROUPTYPE
      LOGICAL :: DONTMOVET, DONTMOVEGROUPT, DONTMOVEREST, DONTMOVEALL, DOMOVEREST
      LOGICAL, ALLOCATABLE :: DONTMOVE(:),DONTMOVERES(:)
      INTEGER, ALLOCATABLE :: DUMPXYZUNIT(:), DUMPVUNIT(:)
!
! csw34> PAIRDIST variables
!
      INTEGER :: NPAIRS
      INTEGER, ALLOCATABLE :: PAIRDIST(:,:)
      LOGICAL :: PAIRDISTT
!
! csw34> Reporter for chirality and cis/trans checks in quench.f
!
      LOGICAL :: GOODSTRUCTURE

! GROUP ROTATION MOVE PARAMETERS
      INTEGER :: GROUPROTFREQ, NGROUPS
      LOGICAL :: GROUPROTT, DOGROUPROT=.FALSE.
      CHARACTER(LEN=10), ALLOCATABLE :: ATOMGROUPNAMES(:)
      INTEGER, ALLOCATABLE :: ATOMGROUPAXIS(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ATOMGROUPSCALING(:),ATOMGROUPPSELECT(:)
      LOGICAL, ALLOCATABLE :: ATOMGROUPS(:,:)
      
! DIHEDRAL GROUP ROTATION MOVE PARAMETERS
      INTEGER :: DIHEDRALROTFREQ, NDIHEDRALGROUPS 
      LOGICAL :: DIHEDRALROTT, DODIHEDRALROT=.FALSE.
      CHARACTER(LEN=10), ALLOCATABLE :: DIHEDRALGROUPNAMES(:), ANGLETYPE(:)
      INTEGER, ALLOCATABLE :: DIHEDRALGROUPAXIS(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: DIHEDRALGROUPSCALING(:),DIHEDRALGROUPPSELECT(:)
      LOGICAL, ALLOCATABLE :: DIHEDRALGROUPS(:,:)
      
      ! parameters for helical sampling moves
      LOGICAL :: HELIXMOVE
      DOUBLE PRECISION :: PHI0,PSI0,PHIk,PSIk
      DOUBLE PRECISION :: bgsb1, bgsb2 ! parameters for biased gaussian sampling: 
      ! bgsb1 is spring constant associated with independent torsion sampling
      ! bgsb2 controls bias towards local deformations


! EXPANDRIGID variables
      INTEGER :: EXPANDRIGIDFREQ
      LOGICAL :: EXPANDRIGIDT, NORMALISEEXPANDT, DOEXPANDRIGID=.FALSE.

! ROTATERIGID variables
      INTEGER :: ROTATERIGIDFREQ
      LOGICAL :: ROTATERIGIDT, DOROTATERIGID=.FALSE.
! TRANSLATERIGID variables
      DOUBLE PRECISION :: TRANSLATEFACTOR = 1D0
      INTEGER :: TRANSLATERIGIDFREQ = 1
      LOGICAL :: TRANSLATERIGIDT = .FALSE.,DOTRANSLATERIGID=.FALSE.

! csw34> HBONDMATRIX VARIABLES
      LOGICAL :: HBONDMATRIX, HBONDMATCH, HBONDACCEPT, HBONDLIGAND
      CHARACTER(LEN=80) :: HBONDDONORSACCEPTORS, HBONDRESIDUES, NHBONDGROUPSCHAR, HBONDGROUPNAME
      CHARACTER(LEN=80) :: CHBONDDCUT, HBONDACUT, HBONDDCUT, HBONDACUTLOOSE, HBONDACUTTIGHT
      CHARACTER(LEN=80) :: HBONDDCUTLOOSE, HBONDDCUTTIGHT
      CHARACTER(LEN=6) :: HBONDTYPE
      INTEGER :: NHBONDGROUPS, HBONDLIGANDN
      INTEGER, ALLOCATABLE :: HBONDGROUPS(:,:,:), HBONDMAT(:,:), HBONDGROUPPOP(:),HBONDGROUPIDS(:)
      INTEGER, ALLOCATABLE :: HBONDSOFTMAT(:,:)
      DOUBLE PRECISION :: HBONDESAVE, HBONDQUZEROE
      DOUBLE PRECISION, ALLOCATABLE :: HBONDBESTCOORDS(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: HBONDMARKOV(:), HBONDBEST(:),HBONDQUE(:)
      DOUBLE PRECISION, ALLOCATABLE :: HBONDMAXE(:)
      INTEGER :: HBONDNRES, HBONDMATCHN, MAXHBONDGROUPS
! END OF HBONDMATRIX VARIABLES

      INTEGER  NGBSITE, NPYSITE, PYBINARYTYPE1, PYSWAP(3), MAXINTERACTIONS
   
      DOUBLE PRECISION :: DZP1, DZP2, DZP3, DZP4, DZP5, DZP6, DZP7
      LOGICAL :: FIELDT, OHT, IHT, TDT, D5HT
      DOUBLE PRECISION :: FOH, FIH, FTD, FD5H

      CHARACTER(LEN=80) :: SYS
      CHARACTER(LEN=80) :: INFILE=''
      CHARACTER(LEN=1), ALLOCATABLE :: BEADLETTER(:), BLNSSTRUCT(:)
      CHARACTER(LEN=130) DUMPFILE, MYFILENAME, INTEDUMPFILE

      INTEGER NUMPRO_AMH, NINT_AMH, SEED_AMH,HARM_AMH, I1_AMH
      CHARACTER AMINOA(21)*3
      DATA (AMINOA(I1_AMH),I1_AMH=1,21)/'ALA','ARG','ASN','ASP','CYS','GLN','GLU','GLY', &
           'HIS','ILE','LEU','LYS','MET','PHE','PRO','SER','THR','TRP','TYR','VAL','INI'/

!      DOUBLE PRECISION :: HESS(1,1)
!     DOUBLE PRECISION HESS(3*MXATMS,3*MXATMS)
      CHARACTER(LEN=3) :: CSMGP, CSMGUIDEGP


!|gd351> extra variables for patchy and asakura-oosawa models
       LOGICAL :: PATCHY, ASAOOS
       DOUBLE PRECISION :: SIGMASQ, RANGESQ, FACTOR, SIGMAP 
!<gd351|

!js850> variables for OVERLAP
      LOGICAL OVERLAPK, OVERLAP_IMPORT
      DOUBLE PRECISION OVERLAP_DR
      INTEGER OVERLAP_FRQ
!js850> variables for LJPSHIFT + FREEZE + RESTRICTREGION interactionlist
      INTEGER, ALLOCATABLE :: FREEZEIL(:,:) ! ALLOCATE(FREEZEIL(NATOMS*(NATOMS+1),2))
      INTEGER FREEZEIL_NAA, FREEZEIL_NAB, FREEZEIL_NBB
      LOGICAL FREEZEIL_USE
      DOUBLE PRECISION FREEZEIL_E
      INTEGER NTYPEA, NTYPEA_FIX
      DOUBLE PRECISION EPSAB, EPSBB, SIGAB, SIGBB
!js850> variables for potential SOFT_SPHERE
      LOGICAL SOFT_SPHERE
      DOUBLE PRECISION SOFT_SPHERE_RCUT
      INTEGER SOFT_SPHERE_NTYPEA
!js850> variables for ONE_ATOM_TAKESTEP
      !DOUBLE PRECISION, ALLOCATABLE :: ONE_ATOM_ENERGIES(:) 
      !DOUBLE PRECISION, ALLOCATABLE :: ONE_ATOM_ENERGY_MATRIX(:,:) 
      !INTEGER :: ONE_ATOMI
      !LOGICAL :: ONE_ATOM_TAKESTEP, ONE_ATOM_USE
      LOGICAL :: ONE_ATOM_TAKESTEP
      LOGICAL, ALLOCATABLE :: ONE_ATOM_USE(:) !ONE FOR EACH PROCESSOR
      INTEGER, ALLOCATABLE :: ONE_ATOMI(:) !ONE FOR EACH PROCESSOR
!js850> variables for setting parallel tempering temperatures
      LOGICAL PTREADTEMPS
!js850> variables for PTEX_INDEP
      LOGICAL PTEX_INDEP
      INTEGER PTEX_INDEP_NSTEPS
      INTEGER PTEX_INDEP_UNIT
!js850> 
      INTEGER NPCALL ! the number of potential calls
!js850> for keyword max_npcall
      LOGICAL MAX_NPCALLT
      INTEGER MAX_NPCALL

!ds656> Binary Gupta keywords, parameters, variables...
      LOGICAL :: BGUPTAT, BGUPTATAB, BGUPTATBB
!ds656> Binary swap keywords and parameters
      LOGICAL :: BASWAP, BASWAPTEST
      INTEGER :: BASWAP_NMAX, BASWAP_NWAIT
      DOUBLE PRECISION :: BASWAP_FRAC !, BASWAP_TEMP no longer used 
!ds656> Homotop refinement
      LOGICAL :: HOMOREFT, HOMOREFTEST, RANDPERMT, &
           HOMOREF_AUXT,HOMOREFCHECK, HOMOREF_BHT
      INTEGER :: HOMOREF_FGMODE, HOMOREF_LSMODE, HOMOREF_NCYCLES
      INTEGER :: HOMOREF_AUX_NSWAPS, HOMOREF_NFMAX, HOMOREF_NSMAX
      INTEGER :: HOMOREF_BH_NSWAPMAX, HOMOREF_BH_NDUDMAX
      INTEGER :: RANDPERM_STEP
      DOUBLE PRECISION :: HOMOREF_AUX_TEMP, HOMOREF_AUX_FACTOR
      DOUBLE PRECISION :: HOMOREF_AUX_NNCUT
      DOUBLE PRECISION :: HOMOREF_BH_TEMP, HOMOREF_BH_FACTOR
!ds656> Enumerate permutations
      LOGICAL :: ENPERMST
      DOUBLE PRECISION, ALLOCATABLE :: LEHMER_COORDS(:,:) ! NAT, NPAR
      CHARACTER(LEN=1), ALLOCATABLE :: LEHMER_LIST(:,:) ! NATOMS, NPAR
      CHARACTER(LEN=1), ALLOCATABLE :: LEHMER_LAST(:) ! NPAR
      INTEGER, ALLOCATABLE :: LEHMER_ILASTB(:) ! NPAR
!ds656> Generalized LJ + Yukawa potential
      LOGICAL :: GLJY

!ds656> Short integer arrays for book-keeping and cut-off definig 
!       the neighbourhood of an atom.
      INTEGER(KIND=2), ALLOCATABLE :: ATOMLISTS(:,:,:), NBRLISTS(:,:,:)
      LOGICAL :: KEEPLISTS
      DOUBLE PRECISION :: NBRCUT1,NBRCUT2

!   allocatables

      INTEGER,ALLOCATABLE,DIMENSION(:) :: MOVABLEATOMLIST         ! a list containing the movable atom indices
      LOGICAL,ALLOCATABLE,DIMENSION(:) :: MOVABLEATOMLISTLOGICAL  ! is atom i movable?
      INTEGER,ALLOCATABLE,DIMENSION(:) :: ATOMSINBLOCK            ! for BLOCKMOVE, to split movableatoms into separate blocks
      INTEGER,ALLOCATABLE,DIMENSION(:) :: NSPECIES(:)             ! for multicomponent systems

      INTEGER, ALLOCATABLE, DIMENSION(:) :: NT, NQ, BLOCK, JUMPINT, JUMPTO, NCORE, NSURFMOVES  ! dimension will be NPAR
      INTEGER, ALLOCATABLE, DIMENSION(:) :: HISTVALS, LHISTVALS  ! dimension declared HBINS in keyword
      INTEGER, ALLOCATABLE, DIMENSION(:,:) :: WATERDEGREE
      INTEGER, ALLOCATABLE :: NPERMSIZE(:), PERMGROUP(:)
      INTEGER, ALLOCATABLE :: NSETS(:)
      INTEGER, ALLOCATABLE :: SETS(:,:)
      INTEGER, ALLOCATABLE :: PERMUTE(:,:)
      INTEGER, ALLOCATABLE :: NCRBN(:), NCMP(:)
      INTEGER, ALLOCATABLE :: BESTPERM(:) !jdf43>
      INTEGER, ALLOCATABLE :: TBPBASINS(:),TBPBASINSO(:) !jdf43>

      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: TEMP, STEP, OSTEP, ASTEP, ACCRAT, EPREV ! dimension will be NPAR 
      DOUBLE PRECISION, ALLOCATABLE :: TARGETS(:) ! allocated NTARGETS in keyword.f
      DOUBLE PRECISION, ALLOCATABLE :: ESAVE(:,:) ! dimension will be NTAB,NPAR
      DOUBLE PRECISION, ALLOCATABLE :: XINSAVE(:,:) ! dimension will be NTAB,NPAR
      DOUBLE PRECISION, ALLOCATABLE :: HDIST(:), HWEIGHT(:) ! dimension declared HISTBINMAX in keyword
      DOUBLE PRECISION, ALLOCATABLE :: VEC(:) ! dimension would be NVEC - not used
      DOUBLE PRECISION, ALLOCATABLE :: MASSES(:)
      DOUBLE PRECISION, ALLOCATABLE :: RBOPS(:,:) !jdf43>
      DOUBLE PRECISION, ALLOCATABLE :: REPLOW(:)
      DOUBLE PRECISION, ALLOCATABLE :: GLJEPS(:,:), GLJSIG(:,:) ! GLJ parameters

      LOGICAL, ALLOCATABLE, DIMENSION(:) :: FIXBOTH, FIXTEMP, FIXSTEP, JUMPMOVE, JDUMP, TMOVE, OMOVE ! dimension will be NPAR
      LOGICAL, ALLOCATABLE, DIMENSION(:) :: SHELLMOVES ! dimension will be NPAR
      LOGICAL, ALLOCATABLE ::  IGNOREBIN(:) ! will be HBINS
      LOGICAL, ALLOCATABLE, DIMENSION(:) :: FROZENRES  ! NATOMS for safety 
      LOGICAL, ALLOCATABLE, DIMENSION(:) :: FROZEN  !  NATOMS
      LOGICAL, ALLOCATABLE, DIMENSION(:) :: HARMONICFLIST  !  NATOMS
      INTEGER, ALLOCATABLE, DIMENSION(:) :: FROZENLIST  !  NATOMS

      INTEGER, ALLOCATABLE, DIMENSION(:) ::  IATNUM     
      INTEGER,ALLOCATABLE :: ANV(:,:,:)
      DOUBLE PRECISION, ALLOCATABLE :: LJREP_BLN(:,:), LJATT_BLN(:,:), A_BLN(:), B_BLN(:), C_BLN(:), D_BLN(:), HYDRO_BLN(:)
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: TCOORDS
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: VT
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: VTVT
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) :: COORDS,COORDSO
      DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:,:) ::  VAT,  VATO    
      DOUBLE PRECISION, ALLOCATABLE :: SITE(:,:), RBUV(:,:), RBSTLA(:,:), STCHRG(:), DPMU(:)
      DOUBLE PRECISION, ALLOCATABLE :: MSBCOORDS(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: MSBE(:)
      DOUBLE PRECISION, ALLOCATABLE :: GAUSSKK(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: GAUSSEE(:), GKSMALL(:)
      DOUBLE PRECISION, ALLOCATABLE :: CSMIMAGES(:)
      DOUBLE PRECISION, ALLOCATABLE :: QMINPCSMAV(:,:), CSMAV(:), QMINAV(:), PTGP(:,:,:), PTGPGUIDE(:,:,:)
      DOUBLE PRECISION, ALLOCATABLE :: LOWESTC(:)
      CHARACTER(LEN=2), ALLOCATABLE, DIMENSION(:) :: ZSYM   
      CHARACTER(LEN=4), ALLOCATABLE, DIMENSION(:) :: PTGROUP ! dimension will be NPAR
      REAL, ALLOCATABLE :: xvEX(:)  !  single precision!!!!
      DOUBLE PRECISION, ALLOCATABLE :: HARMONICR0(:)

      DOUBLE PRECISION, ALLOCATABLE     :: PYA1bin(:,:), PYA2bin(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: TARGETCOORDS(:)

!fh301>{{{
      TYPE DIHEDRALPAR
        CHARACTER(LEN=4)  ATYPE
        CHARACTER*8       DIANGLE
        INTEGER           ATYPEID,DIANGLEID
        REAL*8            P1,P2,P3,P4,P5
      END TYPE DIHEDRALPAR
      TYPE RESIDUE
        CHARACTER(LEN=4)  RES
        INTEGER           RESID
        REAL*8            HA,CA,HN,N,CS,CB,NCORR,NCORR2
      END TYPE RESIDUE
      TYPE ONERES
        CHARACTER(LEN=4)  ATYPE
        CHARACTER(LEN=3)  POS
        INTEGER           ATYPEID,POSID
        REAL*8            HA,CA,HN,N,CS,CB
      END TYPE ONERES
      TYPE ONEATOM
        CHARACTER*8       ATYPE
        CHARACTER(LEN=4)  RES
        INTEGER           RESID,ATYPEID
        REAL*8            HA,CA,HN,N,CS,CB
      END TYPE ONEATOM
      TYPE ONEANGLE
        CHARACTER*8       ANGLE
        REAL*8            HA,CA,HN,N,CS,CB
      END TYPE ONEANGLE
      TYPE ONERESPAR
        CHARACTER(LEN=4)  ATYPE
        CHARACTER(LEN=3)  POS
        CHARACTER(LEN=10) PARAM
        REAL*8            HA,CA,HN,N,CS,CB
      END TYPE ONERESPAR
      TYPE TWORES
        CHARACTER(LEN=4)  ATYPE1,ATYPE2
        CHARACTER(LEN=3)  POS1,POS2
        INTEGER           ATID1,ATID2,POSID1,POSID2
        REAL*8            HA,CA,HN,N,CS,CB
      END TYPE TWORES
      TYPE TDERIVATIVE
        TYPE(TDERIVATIVE), POINTER :: NEXT
        TYPE(TDERIVATIVE), POINTER :: PREVIOUS
        REAL*8 :: D(3)
        INTEGER :: ATOM1,ATOM2
      END TYPE TDERIVATIVE
      TYPE TDERIVATIVEDIHEDRAL
        TYPE(TDERIVATIVEDIHEDRAL), POINTER :: NEXT
        TYPE(TDERIVATIVEDIHEDRAL), POINTER :: PREVIOUS
        REAL*8 :: D(3)
        INTEGER :: ATOM
      END TYPE TDERIVATIVEDIHEDRAL
      TYPE TPOINTERS
        TYPE(TDERIVATIVE), POINTER :: LIST=> NULL()
        TYPE(TDERIVATIVE), POINTER :: FIRST=> NULL()
        TYPE(TDERIVATIVE), POINTER :: LAST=> NULL()
      END TYPE TPOINTERS

      REAL*8 :: ENERGYCAMSHIFT, FULLENERGY, CSN, CSALPHA
      REAL*8, DIMENSION(6) :: RMSSHIFT
      REAL*8, DIMENSION(3,7)  :: HYDROPAR
      REAL*8, ALLOCATABLE :: OBSCHEMSHIFT(:,:),ENERGYCAM(:), SHIFTDIF(:)
      REAL*8, ALLOCATABLE :: FORCEX(:), FORCEY(:), FORCEZ(:)
      LOGICAL COUT
      CHARACTER(LEN=200) :: SVNROOT, CSPATH, SHIFTFILE
      CHARACTER(LEN=10) :: CSVERSION
      TYPE(DIHEDRALPAR) :: DIHED(18)
      TYPE(RESIDUE) :: RANCOIL(20)
      TYPE(ONERES) :: BACKBONEOTH(16),BACKBONEGLY(16),BACKBONEPRO(16)
      TYPE(ONEATOM) :: SIDECHAINOTH(195),SIDECHAINGLY(1),SIDECHAINPRO(9)
      TYPE(ONEATOM) :: HYBSP21(3),HYBSP22(3),HYBSP31(5),HYBSP32(5)
      TYPE(ONEATOM) :: HYBSP21OTH(3),HYBSP22OTH(3),HYBSP31OTH(5)
      TYPE(ONEATOM) :: HYBSP32OTH(5),HYBSP21GLY(3),HYBSP22GLY(3)
      TYPE(ONEATOM) :: HYBSP31GLY(5),HYBSP32GLY(5),HYBSP21PRO(3)
      TYPE(ONEATOM) :: HYBSP22PRO(3),HYBSP31PRO(5),HYBSP32PRO(5)
      TYPE(RESIDUE) :: RINGTYPEOTH(5),RINGTYPEGLY(5),RINGTYPEPRO(5)
      TYPE(ONEANGLE) :: DIHEANGOTH(3),DIHEANGGLY(3),DIHEANGPRO(3)
      TYPE(ONERESPAR) :: HYDROGENOTH(12),HYDROGENGLY(12),HYDROGENPRO(12)
      TYPE(TWORES) :: DISULFID,EXTDISOTH(26),EXTDISGLY(26)
      TYPE(TWORES) :: EXTDISPRO(26)
!fh301>}}}


      DOUBLE PRECISION, ALLOCATABLE     :: XYPHI(:)

      ! Variables for LJGSITE keyword:
      ! LJGSITET indicates if LJGSITE keyword is in data file
      LOGICAL :: LJGSITET  
      ! Parameters for LJ potential read from data file
      DOUBLE PRECISION :: LJGSITESIGMA, LJGSITEEPS
      !BLN/Go parameters
      LOGICAL :: GOTYPE=.FALSE.
      DOUBLE PRECISION :: GOFACTOR=0D0
!
! DJW variables associated with the RESERVOIR keyword - as in PATHSAMPLE
!
      DOUBLE PRECISION, ALLOCATABLE :: EMIN(:), FVIBMIN(:), PFMIN(:), IXMIN(:),  IYMIN(:), IZMIN(:), RESPOINTS(:,:)
      INTEGER, ALLOCATABLE :: HORDERMIN(:)

 !
 ! ab2111> RESERVOIR variables with Gaussing sampling 
 !
      DOUBLE PRECISION, ALLOCATABLE :: HESSEIGVC(:,:,:), HESSEIGVA(:,:), PW(:)
      DOUBLE PRECISION :: RES_PSWAP, BETA_RES
 

!----------------------------------------------!
! hk286 > Generalised rigid body new variables !
! RELAXFQ = during final quench use atom coords instead of rigid coords !
!----------------------------------------------!
      LOGICAL :: RELAXFQ

!----------------------------------------------!
! vr274 > DMACRYS variables                    !
!----------------------------------------------!
      LOGICAL :: DMACRYST
      LOGICAL :: DMACRYS_RANDOMSTART
      DOUBLE PRECISION :: DMACRYS_EXPAND
      DOUBLE PRECISION :: DMACRYS_LATTICE_STEP(6)

!----------------------------------------------!
! vr274 > USERPOT, a potential which is defined
!         within the generalized USERPOT interface
!         and therefore linakge dependant
!         All external potentials
!         (CHARMM, AMBER, DMACRYS) should switch
!         to this implementation at some point.
!----------------------------------------------!
      LOGICAL :: USERPOTT

! hk286 - DAMPED GROUP MOVES
      INTEGER :: DMOVEFREQ, NDGROUPS
      LOGICAL :: DAMPEDGMOVET, DODGROUPMOVET=.FALSE.
      CHARACTER(LEN=10), ALLOCATABLE :: DATOMGROUPNAMES(:)
      INTEGER, ALLOCATABLE :: DATOMGROUPAXIS(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: DATOMGROUPSCALINGA(:),DATOMGROUPSCALINGB(:),DATOMGROUPSCALINGC(:),DATOMGROUPSCALINGD(:)
      DOUBLE PRECISION, ALLOCATABLE :: DATOMGROUPPROBA(:),DATOMGROUPPROBB(:),DATOMGROUPPROBC(:),DATOMGROUPPROBD(:)
      DOUBLE PRECISION, ALLOCATABLE :: DATOMGROUPATT(:,:)
      LOGICAL, ALLOCATABLE :: DATOMGROUPS(:,:)
! hk286 - Yukawa Dumbbells
      LOGICAL :: DBYUKAWAT
      DOUBLE PRECISION :: LAMBDAYAA, LAMBDAYBB, LAMBDAYAB, YEPSFAC 
! hk286 - RESTRAIN LENGTH
      LOGICAL :: RESTRAINLT
      DOUBLE PRECISION :: RESTRAINLK
      DOUBLE PRECISION, ALLOCATABLE :: RESTRAINLDIST(:)
      INTEGER :: RESTRAINLNOPAIR
      INTEGER, ALLOCATABLE :: RESTRAINLPAIRS(:,:)
! hk286
      LOGICAL :: GTHOMSONT
      DOUBLE PRECISION :: GThomsonZ, GThomsonC, GThomsonC2, VUNDULOID
      DOUBLE PRECISION :: GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      INTEGER :: GTHOMMET, GTHOMPOT
      DOUBLE PRECISION :: GThomsonSigma, GThomsonRho

! dc550
      LOGICAL :: SELECTMOVET
      DOUBLE PRECISION, ALLOCATABLE :: SELTRANSSTEP(:), SELROTSCALE(:), SELMOVPROB(:)
      INTEGER, ALLOCATABLE :: SELMOVFREQ(:), SELBEGIN(:), SELEND(:), SELSIZE(:)
      INTEGER :: SELMOVNO
      
!QUIP variables
      CHARACTER(LEN=3) :: QUIPATOMTYPE
      CHARACTER(LEN=10240) :: QUIPARGSTR

!FEBH variables
      LOGICAL           :: FEBHT
      DOUBLE PRECISION  :: FEBH_POT_ENE, FETEMP
      INTEGER           :: FE_FILE_UNIT
! Variables for converging to a certain separation of zero and non-zero eigenvalues.
      DOUBLE PRECISION  :: MIN_ZERO_SEP
      INTEGER           :: MAX_ATTEMPTS

!Character string for CUDA potential
      CHARACTER(LEN=1) :: CUDAPOT

      contains

      SUBROUTINE MODCOMMONINIT
         implicit none
         
         natoms = Number_of_Atoms
         allocate( ANV(NATOMS,NATOMS,3))

! vr274> DMACRYS is used
         DMACRYST = .false.
         DMACRYS_RANDOMSTART=.false.
         DMACRYS_EXPAND = 1.0D0
         DMACRYS_LATTICE_STEP = 0.0D0
      END SUBROUTINE MODCOMMONINIT

      SUBROUTINE MODCOMMONDEINIT
         implicit none
         
         IF (ALLOCATED(ANV)) DEALLOCATE(ANV)
      END SUBROUTINE MODCOMMONDEINIT
END MODULE COMMONS
