SUBROUTINE BHPT_GET_DESTINATION(NSTEP,DEST)
USE COMMONS, ONLY: PTRANDOM, PTINTERVAL, PTSINGLE, PTSETS, NPAR, MYNODE, EXCHPROB, EXCHINT, MYUNIT
IMPLICIT NONE
DOUBLE PRECISION   :: DPRAND_UNIVERSAL
INTEGER            :: DEST, STEP, NSTEP
DEST=-1
IF (PTRANDOM) THEN
   IF (DPRAND_UNIVERSAL().GT.EXCHPROB) THEN
      DEST=-1

   ELSE IF (PTSINGLE) THEN
      DEST=INT(DPRAND_UNIVERSAL()*(NPAR-1))
      IF (MYNODE.EQ.DEST) THEN
         DEST=DEST+1
      ELSE IF (MYNODE.EQ.(DEST+1)) THEN
      ELSE
         DEST=-1
      ENDIF

   ELSE IF (PTSETS) THEN
      DEST=INT(DPRAND_UNIVERSAL()*2.D0)
      IF (MOD(MYNODE+DEST,2)==0) THEN
         DEST=MOD(MYNODE+1,NPAR)
         IF (DEST==0) DEST=-1
      ELSE IF (MOD(MYNODE+DEST,2)==1) THEN
         DEST=MOD(MYNODE-1,NPAR)
         IF (DEST==NPAR-1) DEST=-1
      ENDIF
   ENDIF

ELSE IF (PTINTERVAL) THEN
   IF (MOD(NSTEP,INT(EXCHINT))/=0) THEN
      DEST=-1
   ELSE IF (PTSINGLE) THEN
      DEST=INT(DPRAND_UNIVERSAL()*(NPAR-1))
      IF (MYNODE==DEST) THEN
         DEST=MYNODE+1
      ELSE IF (MYNODE==DEST+1) THEN
      ELSE
         DEST=-1
      ENDIF

   ELSE IF (PTSETS) THEN
      DEST=MOD(INT(NSTEP/EXCHINT+1.D0),2)
      IF (MOD(MYNODE+DEST,2)==0) THEN
         DEST=MOD(MYNODE+1,NPAR)
         IF (DEST==0) DEST=-1
      ELSE IF (MOD(MYNODE+DEST,2)==1) THEN
         DEST=MOD(MYNODE-1,NPAR)
         IF (DEST==NPAR-1) DEST=-1
      ENDIF
   ENDIF
ENDIF

END SUBROUTINE BHPT_GET_DESTINATION

!----------------------------------------------------------------------------------------------------------------------------------!

SUBROUTINE BHPT_EXCHANGE(BETA,NSTEP,NTOT,NEACCEPT)
USE COMMONS
IMPLICIT NONE
DOUBLE PRECISION   :: BETA(NPAR)
INTEGER            :: DEST, NSTEP, NTOT, NEACCEPT
LOGICAL            :: SUCCESS
#ifdef MPI
INCLUDE 'mpif.h'
DOUBLE PRECISION   :: DBETA, DELTA, DPRAND, DPRAND_UNIVERSAL, E
INTEGER            :: I, MPIERR
INTEGER            :: ATTEMPTSTATUS(MPI_STATUS_SIZE), EXCHSTATUS(MPI_STATUS_SIZE,6), REQ(6)

CALL BHPT_GET_DESTINATION(NSTEP,DEST)

IF (DEST==-1) RETURN

NTOT=NTOT+1

IF (MOD(DEST,2)==0) THEN
   CALL MPI_SEND(EPREV(MYNODE+1),1,MPI_DOUBLE_PRECISION,DEST,100,MPI_COMM_WORLD,MPIERR) 
   CALL MPI_RECV(SUCCESS,1,MPI_LOGICAL,DEST,101,MPI_COMM_WORLD,ATTEMPTSTATUS,MPIERR) 
ELSE
   CALL MPI_RECV(E,1,MPI_DOUBLE_PRECISION,DEST,100,MPI_COMM_WORLD,ATTEMPTSTATUS,MPIERR) 
   DELTA=EPREV(MYNODE+1)-E
   DBETA=BETA(MYNODE+1)-BETA(DEST+1)
   SUCCESS=DEXP(DELTA*DBETA)>=DPRAND()
   CALL MPI_SEND(SUCCESS,1,MPI_LOGICAL,DEST,101,MPI_COMM_WORLD,MPIERR) 
ENDIF

IF (SUCCESS) THEN
   E=EPREV(MYNODE+1)
   COORDSO(1:3*NATOMS,MYNODE+1)=COORDS(1:3*NATOMS,MYNODE+1)
   CALL MPI_IRECV(EPREV(MYNODE+1),1,MPI_DOUBLE_PRECISION,DEST,102,MPI_COMM_WORLD,REQ(3),MPIERR) 
   CALL MPI_IRECV(COORDS(1:3*NATOMS,MYNODE+1),3*NATOMS,MPI_DOUBLE_PRECISION,DEST,103,MPI_COMM_WORLD,REQ(4),MPIERR) 
   CALL MPI_ISEND(E,1,MPI_DOUBLE_PRECISION,DEST,102,MPI_COMM_WORLD,REQ(1),MPIERR) 
   CALL MPI_ISEND(COORDSO(1:3*NATOMS,MYNODE+1),3*NATOMS,MPI_DOUBLE_PRECISION,DEST,103,MPI_COMM_WORLD,REQ(2),MPIERR) 
   DO I=1,4
      CALL MPI_WAIT(REQ(I),EXCHSTATUS(1,I),MPIERR) 
   ENDDO
   IF (TBP) THEN 
      TBPBASINSO(:)=TBPBASINS(:)
      CALL MPI_IRECV(TBPBASINS,TBPSTEPS,MPI_INTEGER,DEST,104,MPI_COMM_WORLD,REQ(6),MPIERR)
      CALL MPI_ISEND(TBPBASINSO,TBPSTEPS,MPI_INTEGER,DEST,104,MPI_COMM_WORLD,REQ(5),MPIERR)
      DO I=5,6
         CALL MPI_WAIT(REQ(I),EXCHSTATUS(1,I),MPIERR) 
      ENDDO
   ENDIF
   WRITE(MYUNIT,'(A,I0.2,A,I0.2,A)')"[",MYNODE+1,"]BHPT>Exchange with [",DEST+1,"] successful."
ELSE
   WRITE(MYUNIT,'(A,I0.2,A,I0.2,A)')"[",MYNODE+1,"]BHPT>Exchange with [",DEST+1,"] rejected."
ENDIF

IF (SUCCESS) NEACCEPT=NEACCEPT+1

#else
#endif
END SUBROUTINE BHPT_EXCHANGE

!----------------------------------------------------------------------------------------------------------------------------------!

SUBROUTINE BHPT_TARGET(HITANY)
USE COMMONS, ONLY: HIT, MYNODE, EXCHPROB, NPAR
IMPLICIT NONE
LOGICAL            :: HITANY
#ifdef MPI
INCLUDE 'mpif.h'
INTEGER            :: I, MPIERR, REQ, HITSTATUS(MPI_STATUS_SIZE)

!jdf43>  if process zero hits the target, it tells the other processes. If a
!        different process hits the target, it tells process zero, which tells
!        the other processes.

IF (EXCHPROB>0.0D0) THEN
   IF (HIT) THEN
      IF (MYNODE/=0) THEN
         CALL MPI_SEND(HIT,1,MPI_LOGICAL,0,105,MPI_COMM_WORLD,MPIERR)
      ELSE
         HITANY=.TRUE.
      ENDIF
   ELSEIF (MYNODE==0) THEN
      CALL MPI_IPROBE(MPI_ANY_SOURCE,105,MPI_COMM_WORLD,HITANY,HITSTATUS,MPIERR)
      IF (HITANY) CALL MPI_RECV(HIT,1,MPI_LOGICAL,MPI_ANY_SOURCE,105,MPI_COMM_WORLD,HITSTATUS,MPIERR)
   ENDIF
   CALL MPI_BCAST(HITANY,1,MPI_LOGICAL,0,MPI_COMM_WORLD,MPIERR)
ELSE
   IF (HIT) THEN
      HITANY=.TRUE.
      DO I=0,NPAR-1
         IF (MYNODE/=I) CALL MPI_SEND(HITANY,1,MPI_LOGICAL,I,200,MPI_COMM_WORLD,MPIERR)
      ENDDO
   ELSE
      CALL MPI_IPROBE(MPI_ANY_SOURCE,200,MPI_COMM_WORLD,HITANY,HITSTATUS,MPIERR)
      IF (HITANY) CALL MPI_RECV(HITANY,1,MPI_LOGICAL,MPI_ANY_SOURCE,200,MPI_COMM_WORLD,HITSTATUS,MPIERR)
   ENDIF
ENDIF

#else
#endif
END SUBROUTINE BHPT_TARGET

!----------------------------------------------------------------------------------------------------------------------------------!

SUBROUTINE BHPT_IO(TIME,NQTOT,NPCALL1,NTOT,NEACCEPT)
USE COMMONS, ONLY: MYNODE, MYUNIT
IMPLICIT NONE
DOUBLE PRECISION   :: TIME
INTEGER            :: NQTOT, NPCALL1, NTOT, NEACCEPT
#ifdef MPI
INCLUDE 'mpif.h'
DOUBLE PRECISION   :: SENDARR(5), RECVARR(5)
INTEGER            :: MPIERR

!jdf43>  collates the statistics of all runs, and prints both local and global
!        stats.

SENDARR(1)=TIME
SENDARR(2)=NQTOT
SENDARR(3)=NPCALL1
SENDARR(4)=NTOT
SENDARR(5)=NEACCEPT

WRITE(MYUNIT,'(A,I0.2,A,2(I5,A))')'[',MYNODE+1,']BHPT_IO>',NEACCEPT,' out of ',NTOT,' exchanges accepted in this process.'
WRITE(MYUNIT,'(A,I0.2,A,2(I20),F20.2)')'[',MYNODE+1,']BHPT_IO>Local quenches / function calls / time:',NQTOT,NPCALL1,TIME

CALL MPI_BARRIER(MPI_COMM_WORLD,MPIERR)
CALL MPI_ALLREDUCE(SENDARR,RECVARR,5,MPI_DOUBLE_PRECISION,MPI_SUM,MPI_COMM_WORLD,MPIERR)

TIME=RECVARR(1)
NQTOT=RECVARR(2)
NPCALL1=RECVARR(3)
NTOT=RECVARR(4)/2
NEACCEPT=RECVARR(5)/2

WRITE(MYUNIT,'(2(A,I5),A)')'[--]BHPT_IO>',NEACCEPT,' out of ',NTOT,' exchanges accepted overall.'
WRITE(MYUNIT,'(A,2(I20),F20.2)')'[--]BHPT_IO>Total quenches / function calls / time:',NQTOT,NPCALL1,TIME

#else
#endif
END SUBROUTINE BHPT_IO

!----------------------------------------------------------------------------------------------------------------------------------!
