! This module is just a dummy module to stop GMIN complaining when compiled
! without AMBER12.

module amber12_interface_mod

  use iso_c_binding

  implicit none

  public

!******************************************************************************
! Types and parameters for representing AMBER12 atoms.
  type amber12_atom
    character (len = 4)    :: name
    double precision       :: charge
    double precision       :: mass
    integer                :: res_index
    character (len = 4)    :: res_name
    integer                :: type_index
!    character (len = 4)    :: atom_type
!    character (len = 4)    :: tree_class
    double precision       :: gb_radii
    double precision       :: gb_screen
    integer, dimension(4)  :: bonded_atoms
    integer                :: num_bonds
  end type amber12_atom

!  integer, parameter                   :: amber12_atom_size = 11
  integer, parameter                   :: amber12_atom_size = 10

!******************************************************************************

!******************************************************************************
! Types and parameters for representing AMBER12 residues.
  type amber12_residue
    character (len = 4)                :: name
    integer                            :: num_atoms
    type(amber12_atom), dimension(100) :: atoms
  end type amber12_residue

  integer, parameter                   :: amber12_residue_size = 3
!******************************************************************************

!******************************************************************************
! Subset of gb_pot_ene_rec and pme_pot_ene_rec to interoperate with C and GMIN.
  type, bind(c) :: pot_ene_rec_c
    real(c_double)    :: total
    real(c_double)    :: vdw_tot
    real(c_double)    :: elec_tot
    real(c_double)    :: gb       ! Only GB
    real(c_double)    :: surf     ! Only GB
    real(c_double)    :: hbond    ! Only PME
    real(c_double)    :: bond
    real(c_double)    :: angle
    real(c_double)    :: dihedral
    real(c_double)    :: vdw_14
    real(c_double)    :: elec_14
    real(c_double)    :: restraint
    real(c_double)    :: angle_ub !CHARMM Urey-Bradley Energy
    real(c_double)    :: imp      !CHARMM Improper Energy
    real(c_double)    :: cmap     !CHARMM CMAP
  end type pot_ene_rec_c

!******************************************************************************

contains

subroutine amber12_setup()
  print *, "I'm the amber12_setup dummy routine and should never be called!"
  print *, "Stopping, because something is definitely not right."
  stop
end subroutine amber12_setup

subroutine amber12_get_coords(natoms, coords)
  implicit none
! Arguments
  integer                        :: natoms
  double precision               :: coords(*)
  print *, "I'm the amber12_get_coords dummy routine and should never be called!"
  print *, "Stopping, because something is definitely not right."
  stop
end subroutine amber12_get_coords

subroutine amber12_energy_and_gradient(natoms, coords, energy, gradients, decomposed_energy)
  implicit none

! Arguments 
  integer                           :: natoms
  double precision                  :: coords(*)
  double precision                  :: energy
  double precision                  :: gradients(*)
  type(pot_ene_rec_c)               :: decomposed_energy
  print *, "I'm the amber12_energy_and_gradient dummy routine and should never be called!"
  print *, "Stopping, because something is definitely not right."
  stop
end subroutine amber12_energy_and_gradient

subroutine amber12_finish()
end subroutine amber12_finish

subroutine amber12_write_restart(coords, rst_name, rst_name_length)
  implicit none

! Arguments
  double precision               :: coords(*)
  character (len=1)              :: rst_name(*)
  integer                        :: rst_name_length
  print *, "I'm the amber12_write_restart dummy routine and should never be called!"
  print *, "Stopping, because something is definitely not right."
  stop
end subroutine amber12_write_restart

subroutine amber12_write_pdb(coords, pdb_name, pdb_name_length)
  implicit none
! Arguments
  double precision               :: coords(*)
  character (len=1)              :: pdb_name(*)
  integer                        :: pdb_name_length
  print *, "I'm the amber12_write_pdb dummy routine and should never be called!"
  print *, "Stopping, because something is definitely not right."
  stop
end subroutine amber12_write_pdb

subroutine amber12_write_xyz(coords, xyz_name, xyz_name_length, header)
  implicit none
  double precision               :: coords(*)
  character (len=1)              :: xyz_name(*)
  integer                        :: xyz_name_length
  logical(kind=1)                :: header
  print *, "I'm the amber12_write_xyz dummy routine and should never be called!"
  print *, "Stopping, because something is definitely not right."
  stop
end subroutine amber12_write_xyz

subroutine populate_atom_data(atoms, residues)
  implicit none
  type(amber12_atom), dimension(:), allocatable    :: atoms
  type(amber12_residue), dimension(:), allocatable :: residues
end subroutine populate_atom_data

end module amber12_interface_mod
