C   GMIN: A program for finding global minima
C   Copyright (C) 1999-2006 David J. Wales
C   This file is part of GMIN.
C
C   GMIN is free software; you can redistribute it and/or modify
C   it under the terms of the GNU General Public License as published by
C   the Free Software Foundation; either version 2 of the License, or
C   (at your option) any later version.
C
C   GMIN is distributed in the hope that it will be useful,
C   but WITHOUT ANY WARRANTY; without even the implied warranty of
C   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C   GNU General Public License for more details.
C
C   You should have received a copy of the GNU General Public License
C   along with this program; if not, write to the Free Software
C   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
C*************************************************************************
C
C  Here we calculate the Lead glue potential and gradient
C                                        
C*************************************************************************

      SUBROUTINE PBGLUE (X,V,EPB,GRADT)
      USE commons
      IMPLICIT NONE 
      INTEGER J1, J2
      DOUBLE PRECISION X(3*NATOMS), EPB, DIST, ETEMP, ETEMP2, 
     1                 V(3*NATOMS), rho1, RTEMP, dutemp(NATOMS),
     2                 drtemp, dvtemp, vtemp, vtemp1, vtemp2, vtemp3, 
     3                 rrc, rrcsq
      logical GRADT

      EPB=0.0D0
      RRC=5.503d0
      RRCSQ=RRC**2

      ETEMP=0.0d0
      DO 22 J1=1,NATOMS
         RTEMP=0.0d0
         DO 23 J2=1,NATOMS
           if (j1.ne.j2) then
             DIST=( X(3*(J2-1)+1)-X(3*(J1-1)+1) )**2 +
     1             ( X(3*(J2-1)+2)-X(3*(J1-1)+2) )**2 +
     2             ( X(3*(J2-1)+3)-X(3*(J1-1)+3) )**2
             if (dist.lt.rrcsq) then
               dist=dsqrt(dist)
               call rh(dist,rho1)
               RTEMP=RTEMP+rho1
               if (j1.lt.j2) then
                 call v2(dist,Etemp2)
                 ETEMP=ETEMP+Etemp2
               endif
             endif
           endif
23       CONTINUE
         call uu(RTEMP,Etemp2)
         EPB=EPB+ETEMP2
         call duu(RTEMP,dutemp(J1))
22    CONTINUE
      EPB=EPB+ETEMP

C
C Now calculate the gradient analytically.
C
      if (gradt) then 

      DO J1=1,NATOMS
         VTEMP1=0.0D0
         VTEMP2=0.0D0
         VTEMP3=0.0D0
         DO J2=1,NATOMS
           if (j1.ne.j2) then
             DIST=( X(3*(J2-1)+1)-X(3*(J1-1)+1) )**2 +
     1              ( X(3*(J2-1)+2)-X(3*(J1-1)+2) )**2 +
     2              ( X(3*(J2-1)+3)-X(3*(J1-1)+3) )**2
             if (dist.lt.rrcsq) then
               dist=dsqrt(dist)
               call dv2(dist,dvtemp)
               call drh (dist,drtemp)
               VTEMP=(dvtemp+(dutemp(j1)+dutemp(j2))*drtemp)/dist
               VTEMP1=VTEMP1+VTEMP*(X(3*(J1-1)+1)-X(3*(J2-1)+1))
               VTEMP2=VTEMP2+VTEMP*(X(3*(J1-1)+2)-X(3*(J2-1)+2))
               VTEMP3=VTEMP3+VTEMP*(X(3*(J1-1)+3)-X(3*(J2-1)+3))
             endif
           endif
         ENDDO
         V(3*(J1-1)+1)=VTEMP1
         V(3*(J1-1)+2)=VTEMP2
         V(3*(J1-1)+3)=VTEMP3
      ENDDO

      endif

      RETURN
      END

*     Ong-Ercolessi glue potential for Pb.
*     Ref.: H. S. Lim, C. K. Ong and F. Ercolessi, 
*           Surf. Sci. 269/270, 1109 (1992).
*     Potential home page: http://www.sissa.it/furio/potentials/Pb/

      BLOCK DATA PB
 
*     INITIALIZES COMMON BLOCKS CONTAINING
*     DENSITY FUNCTION, POTENTIAL, GLUE PARAMETERS.
*     THIS BLOCK DATA AUTOMATICALLY GENERATED BY YAPAG 3.0
*
*     SYSTEM : PB, C.K. ONG 1990 
*      - DENS.  5.5030  4.9095  0.3000 -0.3800  0.4900 -3.1000        
*      - POT.   4.2300      -1  0.0000  0.0300  0.0000  4.9000  2.4500
*      - GLUE    R   C  0.0305 15.7000 -0.1850                        
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/DENDAT/RRD,RRB,RRC,RHOD,RHOA,
     $              R1I,R2I,R3I,R1II,R2II,R3II,R2III,R3III
      COMMON/GLUDAT/DB,UB,DSW,
     $              B0I,B1I,B2I,B3I,B4I,B2II,B3II,B4II,
     $              B2III,B3III
      COMMON/POTDAT/D,A,RC,PHI1,PHI2,
     $              A0I,A1I,A2I,A3I,A4I,
     $              A0II,A1II,A2II,A3II,A4II,A5II,A6II,
     $              A3III,A4III,A5III
 
      DATA RRD,RRB,RRC,RHOD,RHOA,
     $     R1I,R2I,R3I,R1II,R2II,R3II,R2III,R3III /
     $    0.3471540742235355E+01,
     $    0.4909500000000000E+01,
     $    0.5503000000000000E+01,
     $    0.8500000000000000E+00,
     $    0.3000000000000000E+00,
     $   -0.3800000000000000E+00,
     $    0.2450000000000000E+00,
     $   -0.5166666666666667E+00,
     $   -0.3800000000000000E+00,
     $    0.2450000000000000E+00,
     $   -0.1715828759323021E+00,
     $    0.1308624193974091E+01,
     $    0.7699032959082642E+00 /
      DATA DB,UB,DSW /
     $    0.1200000000000000E+02,
     $   -0.1850000000000000E+01,
     $    0.9081433382788202E+01 /
      DATA B0I,B1I,B2I,B3I,B4I,B2II,B3II,B4II,B2III,B3III /
     $   -0.1536837858573856E+01,
     $   -0.1850000000000000E+00,
     $   -0.1515954156009047E-01,
     $   -0.1478056600250295E-02,
     $    0.0000000000000000E+00,
     $    0.1526631307568407E-01,
     $   -0.1820707358322264E-01,
     $   -0.3714503267605675E-02,
     $    0.1526631307568407E-01,
     $    0.3239697893498678E-01 /
      DATA D,A,RC,PHI1,PHI2 /
     $    0.3471540742235355E+01,
     $    0.4909500000000000E+01,
     $    0.4230000000000000E+01,
     $   -0.3000000000000000E-01,
     $    0.0000000000000000E+00 /
      DATA A0I,A1I,A2I,A3I,A4I,A0II,A1II,A2II,A3II,A4II,A5II,A6II,
     $     A3III,A4III,A5III /
     $   -0.3000000000000000E-01,
     $    0.0000000000000000E+00,
     $    0.1102661976296813E+00,
     $   -0.8166666666666667E+00,
     $    0.4072201316247714E-01,
     $   -0.3000000000000000E-01,
     $    0.0000000000000000E+00,
     $    0.1102661976296813E+00,
     $   -0.8166666666666667E+00,
     $    0.3439976422630956E+01,
     $   -0.5105760527431719E+01,
     $    0.2448028237231130E+01,
     $    0.0000000000000000E+00,
     $    0.0000000000000000E+00,
     $    0.0000000000000000E+00 /
      END

      SUBROUTINE rh (R,RHO)
     
*     RETURNS THE DENSITY FUNCTION RHO(R) AND ITS FIRST TWO DERIVATIVES
*     AT DISTANCE R.
     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/DENDAT/RRD,RRB,RRC,RHOD,RHOA,
     $              R1I,R2I,R3I,R1II,R2II,R3II,R2III,R3III
     
      IF (R.GE.RRC) THEN
*           AFTER CUT RADIUS IT IS ALL ZERO :
         RHO = 0.D0
      ELSE IF (R.GE.RRB) THEN
*           REGION III (RELEASE) WITH A SPLINE :
         X = R - RRC
         RHO = (X**2) * (R2III + X*R3III)
      ELSE IF (R.GE.RRD) THEN
*           REGION II (SUSTAIN) WITH A SPLINE :
         X = R - RRD
         RHO = RHOD + X*(R1II + X*(R2II + X*R3II))
      ELSE
*           REGION I (DECAY) WITH A SPLINE :
         X = R - RRD
         RHO = RHOD + X*(R1I + X*(R2I + X*R3I))
      ENDIF
     
      RETURN
      END
     
     
      SUBROUTINE drh (R,DRHO)
     
*     RETURNS THE DENSITY FUNCTION RHO(R) AND ITS FIRST TWO DERIVATIVES
*     AT DISTANCE R.
     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/DENDAT/RRD,RRB,RRC,RHOD,RHOA,
     $              R1I,R2I,R3I,R1II,R2II,R3II,R2III,R3III
     
      IF (R.GE.RRC) THEN
*           AFTER CUT RADIUS IT IS ALL ZERO :
         DRHO = 0.D0
      ELSE IF (R.GE.RRB) THEN
*           REGION III (RELEASE) WITH A SPLINE :
         X = R - RRC
         DRHO = X * (2.D0*R2III + X*3.D0*R3III)
      ELSE IF (R.GE.RRD) THEN
*           REGION II (SUSTAIN) WITH A SPLINE :
         X = R - RRD
         DRHO = R1II + X*(2.D0*R2II + X*3.D0*R3II)
      ELSE
*           REGION I (DECAY) WITH A SPLINE :
         X = R - RRD
         DRHO = R1I + X*(2.D0*R2I + X*3.D0*R3I)
      ENDIF
     
      RETURN
      END
     
     
      SUBROUTINE uu (DENS,U)
     
*     RETURNS THE FUNCTION U(N) AND ITS TWO FIRST DERIVATIVES AT N=DENS
     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/GLUDAT/DB,UB,DSW,
     $              B0I,B1I,B2I,B3I,B4I,B2II,B3II,B4II,
     $              B2III,B3III
      IF (DENS.GT.DB) THEN
*           REGION III
         X = DENS - DB
         U = UB + (X**2) * (B2III + X*B3III)
      ELSE IF (DENS.GT.DSW) THEN
*           REGION II
         X = DENS - DB
         U = UB + (X**2) * (B2II + X*(B3II + X*B4II))
      ELSE
*           REGION I
         X = DENS - DSW
         U = B0I + X*(B1I + X*(B2I + X*(B3I + X*B4I)))
      ENDIF
      RETURN
      END
     
      SUBROUTINE duu (DENS,U1)
     
*     RETURNS THE FUNCTION U(N) AND ITS TWO FIRST DERIVATIVES AT N=DENS
     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/GLUDAT/DB,UB,DSW,
     $              B0I,B1I,B2I,B3I,B4I,B2II,B3II,B4II,
     $              B2III,B3III
      IF (DENS.GT.DB) THEN
*           REGION III
         X = DENS - DB
         U1 = X*(2.D0*B2III + X*3.D0*B3III)
      ELSE IF (DENS.GT.DSW) THEN
*           REGION II
         X = DENS - DB
         U1 = X*(2.D0*B2II + X*(3.D0*B3II + X*4.D0*B4II))
      ELSE
*           REGION I
         X = DENS - DSW
         U1 = B1I + X*(2.D0*B2I + X*(3.D0*B3I + X*4.D0*B4I))
      ENDIF
      RETURN
      END
     
      SUBROUTINE v2 (R,PHI)
     
*     RETURNS THE POTENTIAL AND ITS FIRST TWO DERIVATIVES AT DISTANCE R
     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/POTDAT/D,A,RC,PHI1,PHI2,
     $              A0I,A1I,A2I,A3I,A4I,
     $              A0II,A1II,A2II,A3II,A4II,A5II,A6II,
     $              A3III,A4III,A5III
      IF (R.GE.RC) THEN
         PHI = 0.D0
      ELSE IF (R.GE.A) THEN
*           REGION III, AFTER SECOND NEIGHBOURS.
*           THIS WORKS ONLY IF RC.GT.A, I.E. WHEN THE POTENTIAL IS
*           A TRUE SECOND NEIGHBOURS POTENTIAL ; OTHERWISE CONTROL
*           PASSES TO REGION II.
         X = R - RC
         PHI = (X**3) * (A5III*X**2 + A4III*X + A3III)
      ELSE IF (R.GE.D) THEN
*           REGION II, BETWEEN FIRST AND SECOND NEIGHBOURS.
         X = R - D
         PHI = A0II + X*(A1II + X*(A2II +
     $                       X*(A3II + X*(A4II + X*(A5II + X*A6II)))))
      ELSE
*           REGION I, BEFORE FIRST NEIGHBOURS.
         X = R - D
         PHI = A0I + X*(A1I + X*(A2I + X*(A3I + X*A4I)))
      ENDIF
      RETURN
      END
     
      SUBROUTINE dv2 (R,DPHI)
     
*     RETURNS THE POTENTIAL AND ITS FIRST TWO DERIVATIVES AT DISTANCE R
     
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/POTDAT/D,A,RC,PHI1,PHI2,
     $              A0I,A1I,A2I,A3I,A4I,
     $              A0II,A1II,A2II,A3II,A4II,A5II,A6II,
     $              A3III,A4III,A5III
      IF (R.GE.RC) THEN
         DPHI = 0.D0
      ELSE IF (R.GE.A) THEN
*           REGION III, AFTER SECOND NEIGHBOURS.
*           THIS WORKS ONLY IF RC.GT.A, I.E. WHEN THE POTENTIAL IS
*           A TRUE SECOND NEIGHBOURS POTENTIAL ; OTHERWISE CONTROL
*           PASSES TO REGION II.
         X = R - RC
         DPHI = (X**2) * (5.D0*A5III*X**2 + 4.D0*A4III*X + 3.D0*A3III)
      ELSE IF (R.GE.D) THEN
*           REGION II, BETWEEN FIRST AND SECOND NEIGHBOURS.
         X = R - D
         DPHI = A1II + X*(2.D0*A2II + X*(3.D0*A3II +
     $              X*(4.D0*A4II + X*(5.D0*A5II + X*6.D0*A6II))))
      ELSE
*           REGION I, BEFORE FIRST NEIGHBOURS.
         X = R - D
         DPHI = A1I + X*(2.D0*A2I + X*(3.D0*A3I + X*4.D0*A4I))
      ENDIF
      RETURN
      END
     
