       module energies
      double precision evdw,elec,eph,epa,ethh,etha,ebonh,ebona,
     $   enbph,enbpa,eelph,eelpa,ehydro,
     $   Ehhb, Ehbr, Ecoop, Estak, Eplane, Econst
c     energy vector, for the optimization
      double precision Evec(35)
      end module energies

C-------------------------------------------------------
      subroutine RNA_RESTRAINTS(Nrests, RestLens, PI, PJ, X, F, Econ)
      
      implicit none

      integer Nrests, PI(*), PJ(*)
      double precision X(*), F(*), Econ, RestLens(*)
      double precision v
      double precision sk

      integer idx
      double precision diff(3), dlen, df(3)

      sk = 0.1
     
      Econ = 0 
      do idx = 1, Nrests
        diff = X(pi(idx)*3-2 : pi(idx)*3) - X(pj(idx)*3-2 : pj(idx)*3)

        dlen = sqrt(dot_product(diff, diff))
c        Econ = Econ + sk*(dlen - RestLens(idx))**2
c        df = 2*sk*(dlen - RestLens(idx))*diff/dlen

c       linear for d > 2
        v = dlen - RestLens(idx)
        if(abs(v) > 2) then
          Econ = Econ + sk*4*abs(v)-4
          df = sk*4*v/abs(v)*diff/dlen
        else
          Econ = Econ + sk*v**2
          df = 2*sk*v*diff/dlen
        endif
        
        F(pi(idx)*3-2 : pi(idx)*3) = F(pi(idx)*3-2 : pi(idx)*3) - df
        F(pj(idx)*3-2 : pj(idx)*3) = F(pj(idx)*3-2 : pj(idx)*3) + df
      enddo

      end


C-------------------------------------------------------
      subroutine RNA_EBOND(NBON,IB,JB,ICB,X,F,EBON,RK,REQ)
C
C     THE POTENTIAL IS EXPRESSED BY: RK * (RIJ-REQ)**2
C
      implicit none

      integer NBON,IB(*),JB(*),ICB(*)
      double precision X(*),F(*),EBON,RK(*),REQ(*)

      real*8 pbc_mic

      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM

      LOGICAL qbug
      COMMON/debug/qbug

      integer*8 jn, I3, J3, ic
      double precision xa(3), rij, da, df, enerb

      logical QDET

      QDET = .FALSE. .or. qbug
      if(QDET) then
         open(unit=7,file="beta32.ebond",status="unknown")
         write(7,*) '  i ','  j ','   rij  ','   req  ',
     &        '  enerb ','  force '
      endif

      EBON = 0.0d0

      DO JN = 1,NBON
      I3 = IB(JN)
      J3 = JB(JN)
      xa = X((I3+1):(I3+3))-X((J3+1):(J3+3))

        if(periodicBC)then
           xa = pbc_mic(xa)   !; print *, "xij", xij
        endif
        
      RIJ = dsqrt(dot_product(xa,xa))
      IC = ICB(JN)
      DA = RIJ-REQ(IC)
      DF = RK(IC)*DA*score_RNA(14)
      ENERB = DF*DA
      if(QDET) then
         if (enerb .ge. 0.5) then
            write(7,1200) I3/3+1,J3/3+1,RIJ,REQ(IC),ENERB,DF
 1200       format(i4,i4,f8.3,f8.3,f8.3,f8.3)
         endif
      endif
      DF = (DF+DF)/RIJ
      xa = DF*xa
      F((I3+1):(I3+3)) = F((I3+1):(I3+3)) - xa
      F((J3+1):(J3+3)) = F((J3+1):(J3+3)) + xa
      EBON = EBON + ENERB
      ENDDO

      if(QDET) then
         close(7)
      endif
      RETURN
      END
C-------------------------------------------------------
      subroutine RNA_ETHETA(MAXTT,NTHETH,IT,JT,KT,ICT,X,F,ETHH,TK,TEQ)
C
C     THE POTENTIAL IS EXPRESSED BY: TK * (ANG(I,J,K)-TEQ)**2
C
      implicit double precision (a-h,o-z)

      real*8 pbc_mic

      parameter (MAXPRE = 1500)    !! maximum number of residues
      parameter (MAXNAT = MAXPRE*6)  !! maximum number of atoms
      parameter (MAXTH = MAXNAT*3)  !! maximum number of bond angles

      LOGICAL qbug
      COMMON/debug/qbug

      common/scor/score(272),score_RNA(35)
      
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM
      
      DIMENSION IT(*),JT(*),KT(*),ICT(*),X(*),F(*),TK(*),TEQ(*)
      
      double precision rIJ(3), rKJ(3)
      double precision rDI(3), rDJ(3), rDK(3)
      double precision ANT, RKJ0, RIJ0, RIK0, EAW, DFW, DA, DF

      DATA pt999 /0.9990d0/
      logical QDET

      QDET = .FALSE. .or. qbug

      if(QDET) then
         open(unit=7,file="beta32.etheta",status="unknown")
         write(7,*) "   P1  ","   P2  ","   P3  ", "     t    ",
     $              "    teq   ","   diff   ","  energy  "
      endif
      ETHH = 0.0d0

      DO JN = 1,NTHETH
        IC = ICT(JN)
        if (TK(IC) .ge. 2.0d0) then
           I3 = IT(JN)
           J3 = JT(JN)
           K3 = KT(JN)
           rIJ = X(I3+1:I3+3)-X(J3+1:J3+3)
           rKJ = X(K3+1:K3+3)-X(J3+1:J3+3)

           if(periodicBC)then
              rIJ = pbc_mic(rIJ)
              rKJ = pbc_mic(rKJ)
           endif

           RIJ0 = dot_product(rIJ, rIJ)
           RKJ0 = dot_product(rKJ, rKJ)
           RIK0 = dsqrt(RIJ0*RKJ0)
           CT0 = dot_product(rIJ, rKJ)/RIK0
           CT1 = MAX(-pt999,CT0)
           CT2 = MIN(pt999,CT1)
           ANT = DACOS(CT2)


C     ENERGY
           DA = ANT-TEQ(IC)
           DF = TK(IC)*DA*score_RNA(15)
           EAW = DF*DA
           DFW = -(2*DF)/DSIN(ANT)
           if(QDET) then
               if (EAW .ge. 5.0d0) then
                  P1 = IT(JN)/3 +1
                  P2 = JT(JN)/3 +1
                  P3 = KT(JN)/3 +1
                  write(7,1200) P1,P2,P3, ANT*180/3.14,
     $                 TEQ(IC)*180/3.14,DA*180/3.14, EAW
 1200             format(f7.0,f7.0,f7.0, f10.3,f10.3,f10.3,f10.3)
               endif
            endif
            ETHH = ETHH + EAW
C     FORCE
            STH = DFW*CT2
            CIK = DFW/RIK0
            CII = STH/RIJ0
            CKK = STH/RKJ0

            rDI = CIK*rKJ-CII*rIJ
            rDK = CIK*rIJ-CKK*rKJ
            rDJ = -rDI-rDK
            F(I3+1:I3+3) = F(I3+1:I3+3)-rDI
            F(J3+1:J3+3) = F(J3+1:J3+3)-rDJ
            F(K3+1:K3+3) = F(K3+1:K3+3)-rDK
         endif
      ENDDO

      if(QDET) then
         close(7)
      endif
c      write(71,*)ETHH

      RETURN
      END

c-----------------------------------------------------------------------
      subroutine RNA_ETORS(lambda,NPHI,IP,JP,KP,LP,ICP,CG,IAC,
     +     X,F,EP,ENBP,EELP,ECN,CN1,CN2,PK,PN,GAMS,GAMC,IPN,FMN)

      use geometric_corrections
      implicit double precision (a-h,o-z)

      real*8 pbc_mic

      parameter (MAXPRE = 1500)  !! maximum number of residues
      parameter (MAXNAT = MAXPRE*6) !! maximum number of atoms
      parameter (MAXPHI = MAXNAT*4) !! maximum number of torsional angles
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2)!! max number of nonbonded-pairs

      logical QDET


      common/scor/score(272),score_RNA(35)
      COMMON/NBPARA/CUT,SCNB,SCEE,IDIEL,DIELC

      COMMON/ANGLES/ CTPHI(MAXPHI),CT1PHI(MAXPHI),NUPHI

      LOGICAL qbug
      COMMON/debug/qbug


      double precision rIJ(3), rKJ(3), rKL(3), rD(3), rG(3), rIL(3)
      double precision lenD, lenG, dotDG
      double precision vfmul, FMULN, vCPHI, vSPHI
      double precision vEPW, vDF
      double precision rFI(3), rFJ(3), rFK(3), rFL(3)
      double precision rDC(3), rDC2(3), rDR1(3), rDR2(3), rDR(3)
      double precision rA(3)

      DIMENSION GMUL(10)

      DIMENSION IP(*),JP(*),KP(*),LP(*),ICP(*),IPN(*)
      DIMENSION CG(*),IAC(*),X(*),F(*),CN1(*),CN2(*),PK(*),PN(*)
      DIMENSION GAMC(*),GAMS(*),FMN(*)

      common/PBC_R/periodicBC,CM
      logical periodicBC,CM

      double precision eqangle, curangle

      REAL*8 IDIEL
      DATA GMUL/0.0d+00,2.0d+00,0.0d+00,4.0d+00,0.0d+00,6.0d+00,
     +     0.0d+00,8.0d+00,0.0d+00,10.0d+00/
      DATA TM24,TM06,tenm3/1.0d-18,1.0d-06,1.0d-03/
      DATA PI/3.141592653589793d+00/

      real*8 lambda

      QDET = .FALSE. .or. qbug
      if(QDET) then
         open(unit=7,file="beta32.etors",status="unknown")
         write(7,*) "   P1  ", "   P2  ", "   P3  ", "   P4  ",
     $     "    PK   ","    PN   ","   AP1   ","   GAMC  ","   Etors "
      endif
      EP = 0
      ECN = 0
      EELP = 0
      SCNB0 = 1.0d0/SCNB
      SCEE0 = 1.0d0/SCEE

      DO JN = 1,NPHI
        I3 = IP(JN)
        J3 = JP(JN)
        K3T = KP(JN)
        L3T = LP(JN)
        K3 = IABS(K3T)
        L3 = IABS(L3T)
        rIJ = X(I3+1:I3+3) - X(J3+1:J3+3)
        rKJ = X(K3+1:K3+3) - X(J3+1:J3+3)
        rKL = X(K3+1:K3+3) - X(L3+1:L3+3)

        if(periodicBC)then
           rIJ = pbc_mic( rIJ )
           rKJ = pbc_mic( rKJ )
           rKL = pbc_mic( rKL )
        endif

        rD = crossproduct(rIJ, rKJ)
        rG = crossproduct(rKL, rKJ)

        lenD = dsqrt(dot_product(rD,rD)+TM24)
        lenG = dsqrt(dot_product(rG,rG)+TM24)
        dotDG = dot_product(rD,rG)

        z10 = 1.0d0/lenD
        z20 = 1.0d0/lenG
        if (tenm3 .gt. lenD) z10 = 0
        if (tenm3 .gt. lenG) z20 = 0
        Z12 = Z10*Z20
        vFMUL = 0
        if (z12 .ne. 0.0d0) vFMUL = 1.0d0

        CT0 = MIN(1.0d0,dotDG*Z12)
        CT1 = MAX(-1.0d0,CT0)

        S = dot_product(rKJ,crossproduct(rG,rD))
        AP0 = DACOS(CT1)
        AP1 = PI-DSIGN(AP0,S)
!        vCPHI = DCOS(AP1)
        vCPHI = -CT1
        vSPHI = DSIN(AP1)

C     ----- ENERGY AND THE DERIVATIVES WITH RESPECT TO
C           COSPHI -----

        IC = ICP(JN)
        INC = IPN(IC)
        CT0 = PN(IC)*AP1
        COSNP = DCOS(CT0)
        SINNP = DSIN(CT0)
        vEPW= (PK(IC)+COSNP*GAMC(IC)+SINNP*GAMS(IC))*vFMUL !! might be revised
        DF0 = PN(IC)*(GAMC(IC)*SINNP-GAMS(IC)*COSNP)
        DUMS = vSPHI+SIGN(TM24,vSPHI)
        DFLIM = GAMC(IC)*(PN(IC)-GMUL(INC)+GMUL(INC)*vCPHI)
        df1 = df0/dums
        if(tm06.gt.abs(dums)) df1 = dflim
        vDF = DF1*vFMUL

        vEPW = vEPW*score_RNA(17)
        vDF = vDF*score_RNA(17)

c       if(PK(IC)> 0.0d0) print *,'..',DFLIM,GAMC(IC)*PN(IC)

        if(QDET) then
           if(vEPW .ge. 5) then
             P1 = I3/3+1
             P2 = J3/3+1
             P3 = K3/3+1
             P4 = L3/3+1
             eqangle = atan2(gams(IC)/pk(IC), gamc(IC)/pk(IC))*180/PI
             curangle = atan2(sinnp, cosnp)*180/PI
             write(7,1200) P1, P2, P3, P4, PK(IC),PN(IC), curangle,
     $         eqangle, vEPW
 1200        format(f7.0, f7.0, f7.0, f7.0, f9.3,f9.3,f9.3,f9.3,f9.3)
           endif
        endif
C     END ENERGY WITH RESPECT TO COSPHI


C     ----- DC = FIRST DER. OF COSPHI W/RESPECT
C           TO THE CARTESIAN DIFFERENCES T -----
        rDC = -rG*Z12-vCPHI*rD*Z10**2
        rDC2 = rD*Z12+vCPHI*rG*Z20**2
C     ----- UPDATE THE FIRST DERIVATIVE ARRAY -----
        rDR1 = vDF*(crossproduct(rKJ,rDC))
        rDR2 = vDF*(crossproduct(rKJ,rDC2))
        rDR = vDF*(crossproduct(rIJ,rDC) + crossproduct(rDC2, rKL))
        rFI = - rDR1
        rFJ = - rDR + rDR1
        rFK = + rDR + rDR2
        rFL = - rDR2
C     ----- CALCULATE 1-4 NONBONDED CONTRIBUTIONS

        rIL = X(I3+1:I3+3)-X(L3+1:L3+3)

        if(periodicBC)then
           rIL = pbc_mic(rIL)
        endif

        IDUMI = SIGN(1,K3T)
        IDUML = SIGN(1,L3T)
        KDIV = (2+IDUMI+IDUML)/4
        FMULN = dble(kdiv)*FMN(ICP(JN))
        II = (I3+3)/3
        JJ = (L3+3)/3
        IA1 = IAC(II)
        IA2 = IAC(JJ)
        IBIG = MAX0(IA1,IA2)
        ISML = MIN0(IA1,IA2)
        IC = IBIG*(IBIG-1)/2+ISML
        R2 = FMULN/dot_product(rIL,rIL)
        R6 = R2**3
        rfac = R6*score_RNA(17)
        F1 = CN1(IC)*R6*rfac
        F2 = CN2(IC)*rfac
        ENW = F1-F2
        if (IDIEL.gt.0) then
          EEW = CG(II)*CG(JJ)*dsqrt(R2)*SCEE0
          DFN =((-12.0d0*F1+6.0d0*F2)*SCNB0-EEW)*R2
        else
          EEW = CG(II)*CG(JJ)*R2*SCEE0
          DFN =((-12.0d0*F1+6.0d0*F2)*SCNB0-(2*EEW))*R2
        endif
        rA = rIL*DFN
        rFI = rFI - rA
        rFL = rFL + rA

        enbp = enbp + enw  !! 1-4 nb
        eelp = eelp + eew  !! 1-4 elec
!      ----- THE TOTAL FORCE VECTOR -----
!
        F(I3+1:I3+3) = F(I3+1:I3+3) + (rFI)
        F(J3+1:J3+3) = F(J3+1:J3+3) + (rFJ)
        F(K3+1:K3+3) = F(K3+1:K3+3) + (rFK)
        F(L3+1:L3+3) = F(L3+1:L3+3) + (rFL)

        ep   = ep + vepw  !! torsions
      enddo
      ENBP = ENBP*SCNB0
      if(QDET) then
         close(7)
      endif
c      write(72,*)ep
      RETURN
      END

c-----------------------------------------------------------------------
      subroutine RNA_HYDROP(lambda,X,F)
C     
C     ----- ROUTINE TO CALCULATE THE HYDROPHOBIC/HYDROPHILIC FORCES -----
C     --  and THE H-BOND FORCES
C     -- the analytic form includes now the propensity of residues to
C     prefer alpha or beta states and the weights for all contributions
C     has been rescaled (to be published in 2006)
C

      use RNAnb
      use rnabase
      use energies

      implicit none

      real*8  lambda     !! lambda, for hamiltonian replica exchange it scales H-bond attraction
      double precision X(*),F(*)

      real*8 pbc_mic

      integer MAXPRE, MAXNAT, MAXXC, MAXPNB, MAXBO, MAXTTY, MAXPAI
      parameter (MAXPRE = 1500)    !! maximum number of residues
      parameter (MAXNAT = MAXPRE*6)  !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT)  !! maximum number of cart coord
      parameter (MAXPNB = 3*MAXPRE*MAXPRE)!! max number of SC-SC interactions
      parameter (MAXBO  = MAXNAT)  !! maximum number of bonds
      parameter (MAXTTY = 50000)       !! maximum number of residue name types 
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2)!! NEW 21 JANV05

      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)

      COMMON/MISC1/NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $     NPHIA,NNB,NTYPES,MBONA,MTHETA,MPHIA
      integer NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $             NPHIA,NNB,NTYPES,MBONA,MTHETA,MPHIA

!!      COMMON/HYDRO/ rncoe(maxpnb),vamax(maxpnb),
!!     1 ni(maxpnb),nj(maxpnb),nstep,nb,
!!     2 ivi(maxpnb),ivj(maxpnb),
!!     $ epshb_mcmc(maxpnb)
!!      double precision rncoe, vamax, epshb_mcmc
!!      integer ni, nj, nstep, nb, ivi, ivj

      common/alpm/alpam, alpbm, bcoef
      double precision alpam(4,4), alpbm(4,4)
      integer bcoef(4,4)

!!      double precision epshb

!!      common/propens/ialpha(MAXNAT),ibeta(MAXNAT),icoeff(MAXPAI),
!!     1 foal(20),walpha(20),fobe(20),wbeta(20)
!!      integer ialpha,ibeta,icoeff
      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)
      integer nfrag, lenfrag,ichain 
!!      real*8  foal,walpha,fobe,wbeta

      double precision ehhb1, ehbrp, e4b, estak_t, evdw_t

      logical QDET
      logical qbug
      common/debug/qbug

!!      double precision ct0lj, ct2lj
!!      common/cacascsc/ct0lj(maxpnb),ct2lj(maxpnb)

      COMMON/MISC2/AMASS(MAXNAT),IAC(MAXNAT),NNO(MAXTTY)
      double precision amass
      integer iac, nno

      double precision rad2deg
      parameter (rad2deg=180.0d0/3.141592653d0)

      double precision rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $               rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $               rcut2_4b_out, rcut2_4b_in,
     $               rcut2_lj_out, rcut2_lj_in
      common/cutoffs/rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $               rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $               rcut2_4b_out, rcut2_4b_in,
     $               rcut2_lj_out, rcut2_lj_in
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM
      
      integer ti, tj, tk, tl, i, j, k, l
      integer prev_res
      ! bpairs(6,i) stores the residues with which residue i
      ! forms h-bonds, with the condition that j > i
      integer bpairs(15,MAXPRE), nbpairs(MAXPRE), li, lj, lk, ll

      double precision df, da2, a(3),dx(3) 
 
      logical hbexist

      nbpairs = 0
      bpairs = 0
      evec = 0

      QDET = .false. .or. qbug

      if (QDET) then
      open(unit=37,file="beta32.hydrop",status="unknown")
      open(unit=77,file="beta32.lj",status="unknown")
      write(77,*) ' ni ',' nj ', '    ct0lj', '   vamax',
     $  '   distance','        evdw  ','        df    ',
     &  'icoeff'
      open(unit=78,file="beta32.hb",status="unknown")
      write(78,*) ' ni ',' nj ','    ti  ','    tj  ','  dho2  ',
     $  '  shb2  ','ebarrier','  ehhb  ','  Vangl ',
     &  '  ca0a  ','  ca0b  ',' alpa   ',' alpb   '
      open(unit=79,file="ehyd",status="unknown")
      write(79,*) '    Ecumul   ','   ', '     Ehyd    '
      open(unit=94,file="beta32.hbarrier",status="unknown")
      write(94,"(3a4, 6a8, a15)") 'I','J','K','dhoa','R1','dhob','R2',
     $     'gaussa', 'gaussb','EHBR'
      open(unit=90,file="beta32.coop",status="unknown")
      write(90,"(4a4, 11a12)")  'I','J','K','L','ECOOP','DH1','DH2',
     $   'R1','R2','DD1','DD2','VHB1','VHB2','CP','CM'
      endif


c--   set-up some parameters
      evdw = 0
      ESTAK = 0

      prev_res = 1
      do i = 1, NRES

!        ! Intra-base nb interactions
!        do j = blist(i), blist(i)-l, -1
!          tj = iac(j)
!          do k = j-3, prev_res, -1
!            tk = iac(k)
!            a = x(j*3-2:j*3) - x(k*3-2:k*3)
!            da2 = dot_product(a,a)
!            call RNA_ljcasc(da2,evdw_t,df,nbcoef(tj,tk),nbct2(tj,tk),
!     $           rcut2_caca_scsc_in,rcut2_caca_scsc_out,nbscore(tj,tk))
!            evdw = evdw + evdw_t*nbcoef(tj,tk)
!            dx = df*nbcoef(tj,tk)*a
!            F((j*3-2):j*3) = F((j*3-2):j*3) - dx
!            F((k*3-2):k*3) = F((k*3-2):k*3) + dx
!            evec(nbscore(tj,tk)) = evec(nbscore(tj,tk)) + evdw_t
!            
!            if(qdet .and. evdw_t >= 5) then
!                  write(77,1200) tj, tk, nbcoef(tj,tk), nbct2(tj,tk),
!     $              dsqrt(da2), evdw_t, df, nbscore(tj,tk)
1200             format(i4,i4,f10.3,f10.3,f10.3,f15.3,f15.3,i4)
!            endif
!          enddo
!        enddo

        ! Inter-base nb interactions
        j = i
        do 
          j = j + 1
          if (j .gt. NRES) then
            exit
          endif


          k = prev_res
          l = blist(j-1)+1
          a = x(k*3-2:k*3) - x(l*3-2:l*3)
          da2 = dot_product(a,a)
          ! check the P-P distance, if it's big enough,
          ! just skips the whole residue altogether

          if ( da2 > 6400) then
            j = j + 10
            cycle
          else if ( da2 > 4900) then
            j = j + 8
            cycle
          else if ( da2 > 3600) then
            j = j + 6
            cycle
          else if ( da2 > 2500) then
            j = j + 4
            cycle
          else if ( da2 > 1600) then
            j = j + 2
            cycle
          else if ( da2 > 900) then
            cycle
          endif

c--------------------- STACKING -------------------------------------------
          call RNA_Stackv(blist(i),blist(j),F,X,estak_t)
          ESTAK = ESTAK + estak_t

          do k = prev_res, blist(i)
            tk = iac(k)
            do l = blist(j-1)+1, blist(j)
              tl = iac(l)
              a = x(k*3-2:k*3) - x(l*3-2:l*3)
              da2 = dot_product(a,a)
 
              if (da2 > rcut2_caca_scsc_out) then
                cycle
              endif

              call RNA_ljcasc(da2,evdw_t,df,nbcoef(tk,tl),nbct2(tk,tl),
     $          rcut2_caca_scsc_in,rcut2_caca_scsc_out,nbscore(tk,tl))

              ! if it's the next base, scale down the interaction
              if( j .eq. i+1) then
                evdw_t = evdw_t / 10
                df = df / 10
              endif

              evdw = evdw + evdw_t*nbcoef(tk,tl)
              dx = df*nbcoef(tk,tl)*a
              F((k*3-2):k*3) = F((k*3-2):k*3) - dx
              F((l*3-2):l*3) = F((l*3-2):l*3) + dx
              evec(nbscore(tk,tl)) = evec(nbscore(tk,tl)) + evdw_t
              if(qdet .and. evdw_t >= 5) then
                write(77,1200) k, l, nbcoef(tk,tl), nbct2(tk,tl),
     $             dsqrt(da2), evdw_t, df, nbscore(tk,tl)
              endif
            enddo
          enddo
        enddo
        prev_res = blist(i)+1
      enddo


!      evdw = 0
!
!      prev_res = 1
!      do i = 1, NRES
!        if (btype(i) <= 2) then
!          k = 1
!        else
!          k = 0
!        endif
!        do j = prev_res, blist(i)
!          tj = iac(j)
!          do l = j+3, NATOM
!            ! we consider i-i backbone-base interactions
!            if (l < blist(i)-k) then
!              cycle
!            endif
!            tl = iac(l)
!            a = x(j*3-2:j*3) - x(l*3-2:l*3)
!            da2 = dot_product(a,a)
!
!            call RNA_ljcasc(da2,evdw_t,df,nbcoef(tj,tl),nbct2(tj,tl),
!     $           rcut2_caca_scsc_in,rcut2_caca_scsc_out,nbscore(tj,tl))
!            evdw = evdw + evdw_t*nbcoef(tj,tl)
!            dx = df*nbcoef(tj,tl)*a
!            F((j*3-2):j*3) = F((j*3-2):j*3) - dx
!            F((l*3-2):l*3) = F((l*3-2):l*3) + dx
!            evec(nbscore(tj,tl)) = evec(nbscore(tj,tl)) + evdw_t
!          enddo
!        enddo
!        prev_res = blist(i)+1
!      enddo


c-----------------------------------------
c -- Interaction between nucleobases
c-----------------------------------------
      EHHB = 0
      do i = 1, NRES-4
        li = blist(i)
        ti = btype(i)
        do j = i+4, NRES
          tj = btype(j)

          call RNA_BB(li,ti,blist(j)-1,tj,
     $       score_RNA(12),X,F,Ehhb1, hbexist)
 
          if (qdet) then
             evec(int(bcoef(ti,tj))) = evec(int(bcoef(ti,tj))) + 
     $                                    ehhb1

!             if (abs(EHHB1) .ge. 2) then
!               write(37,*) '  '
!               write(37,*) 'energy is counted'
!               write(37,*) i,j+1,dsqrt(DHO2),EHHB1,
!     $              DACOS(CA0a)*180/3.14,DACOS(CA0b)*180/3.14,
!     $              rncoe(i)
!               write(37,*) '  '
!             endif
          endif
          if (.not. hbexist) then
            cycle
          endif

c--------------------- TOTAL ENERGY HB -------------------------------------------
          EHHB = EHHB + EHHB1

          nbpairs(i) = nbpairs(i) + 1
          nbpairs(j) = nbpairs(j) + 1
          bpairs(nbpairs(i), i) = j
          bpairs(nbpairs(j), j) = i
       enddo
      enddo

!c--------------------- STACKING -------------------------------------------
!      ESTAK = 0
!      do i = 1, NRES - 1
!        do j = i+1, NRES
!          call RNA_Stackv(blist(i),blist(j),F,X,estak_t)
!          ESTAK = ESTAK + estak_t
!        enddo
!      enddo


!---------------------- BIFURCATION BARRIER --------------------------------------
      EHBR = 0
      do i = 1, NRES
        ! If we have more than two base pairs for this residue...

        if (nbpairs(i) .lt. 2) then
          cycle
        endif
        li = blist(i)
        ti = btype(i)
        ! call the barrier function for /I\
        !                              J   K
        do j = 1, nbpairs(i)-1
          lj = blist(bpairs(j,i))
          tj = btype(bpairs(j,i))
          do k = j+1, nbpairs(i)
            lk = blist(bpairs(k,i))
            tk = btype(bpairs(k,i))
c            if (abs(lj-lk) .ge. 24) then
c            print *,'*',lj,li,lk
              call RNA_HBarrier(lj,li,lk,X,F,EHBRp,tj,ti,tk)
              EHBR = EHBR + EHBRp
c            endif
          enddo
        enddo
      enddo

!---------------------------------   4 BODY HB ---------------------------------------
      Ecoop = 0
      do i = 1, NRES-1
        li = blist(i)
        ti = btype(i)
        do j= 1, nbpairs(i)
          lj = blist(bpairs(j,i))
          tj = btype(bpairs(j,i))
           if (lj .le. li) then
            cycle
          endif
!          do k = i+1, NRES-3
          do k = i+1, NRES
            lk = blist(k)
            tk = btype(k)
            ! this is to avoid trying 1 - 3 3 - 5
            if (lj .eq. lk) then
              cycle
            endif
            do l = 1, nbpairs(k)
              ll = blist(bpairs(l,k))
              tl = btype(bpairs(l,k))
              ! this is to avoid trying 1 - 5 3 - 5
              if (ll.le.lk .or. lj.eq.ll) then
                cycle
              endif
              ! i -> j or i -> j  ?
              ! k -> l    l <- k
              call RNA_Coop(li,lj,lk,ll,X,F,E4B,ti,tj,tk,tl)
              Ecoop = Ecoop + E4B
              call RNA_Coop(li,lj,ll,lk,X,F,E4B,ti,tj,tl,tk)
              Ecoop = Ecoop + E4B
            enddo
          enddo
        enddo
      enddo


      if(qbug) then
         evec(31) = Ehbr
         evec(9) = Estak
         evec(13) = Ecoop
      endif

      Ehydro = Ehhb + Ehbr + Estak + Ecoop

      RETURN
      END


c-----------------------------------------------------------------------
      subroutine RNA_switch_cutoff(r2,ene_switched,for_switched,ri2,ro2)

        implicit none

        double precision r2,ene_switched,for_switched,ri2,ro2
        double precision rd6
        double precision sw_func,d_sw_func

        rd6 = 1.0d0/(ro2-ri2)**3

        sw_func = (ro2-r2)**2*(ro2+2.0d0*r2-3.0d0*ri2)*rd6
        d_sw_func = 12.0d0*(ro2-r2)*(ri2-r2)*rd6 !*r1

cdx     for_switched = for_switched*r1
        for_switched = for_switched*sw_func - ene_switched*d_sw_func !/r1
cdx     for_switched = for_switched/r1

        ene_switched = ene_switched*sw_func

      return
      end


c-----------------------------------------------------------------------
      subroutine RNA_ljcasc(da2,eahyd,df,rncoe,ct2,r2in,r2out,ic) !!NEW - NO LONGER LJ
        implicit none

        double precision da2,eahyd,df,rncoe,ct2,r2in,r2out
        double precision r,GF6
        integer ic

         if (rncoe .gt. 0.0d0) then
            if (ic .eq. 25) then
               gf6 = (ct2**2/da2)**3
               Eahyd = (gf6 - 2)*gf6
               DF = 12.0*(1-gf6)*gf6/da2
            else
               r = dsqrt(da2)
               Eahyd = exp(2.0*(ct2-r))*(ct2/r)**6

               DF = -2*Eahyd*(3+r)/da2
            endif
         else
               Eahyd = -(ct2**2/da2)**3
               DF =  -6.0*Eahyd/DA2 !! orig sign +1
         endif

c ------- store energy in ehydro and forces
          if (da2>=r2in) then
            call RNA_switch_cutoff(DA2,eahyd,DF,r2in,r2out)
          endif

      return
      end

c-----------------------------------------------------------------------
      subroutine RNA_BB(I, TI, J, TJ, epshb, X, F, EHHB, hbexist)
c     This function takes care of the Base-Base interaction,
c     including hydrogen bonding, stacking and cooperativity
c     the 3 last atoms of each bases are used.
c
c     I is the last atom's index for the first base
c     (so B1 for A and G, CY for C and U)
c     J is the central atom's index for base 2
c     TI and TJ are the bases' types
c
c     X is the system's coordinates vector
c     F is the system's force vector
c
c     EHHB is the hydrogen bonding energy
c
c
c     I-2 == I-1 == I  - - -  J+1 == J == J-1
c
c F : FI3    Fi2   Fi1        Fj1   FJ2   Fj3
c
      implicit none

      integer, intent(in) :: I, J, TI, TJ
      double precision, intent(in) :: epshb, X(*)
      double precision, intent(inout) :: F(*)
      logical, intent(out) :: hbexist

      integer idx, id
      double precision Ehhb, Enp1, Enp2, Etemp
      double precision, dimension(3,3) :: Ftemp
      double precision, dimension(3,3) :: Fi, Fj,
     $   Fhb_i, Fhb_j, Fnp1_i, Fnp1_j, Fnp2_i, Fnp2_j
      double precision Ftemp_o(3)

      Fi = 0
      Fj = 0
      Fhb_i = 0
      Fhb_j = 0
 
      call RNA_hbnew(I,TI,J,TJ, epshb,X,EHHB, hbexist,
     $            Fhb_i(:,2),Fhb_i(:,1),Fhb_j(:,1),Fhb_j(:,2))

      if (.not. hbexist) then
        return
      endif

      Enp1 = 0
      Fnp1_i = 0
      Fnp1_j = 0
      Enp2 = 0
      Fnp2_i = 0
      Fnp2_j = 0

!!      do idx = 0,5
      do idx = 0,2
        Etemp = 0
        Ftemp = 0
        Ftemp_o = 0
        call RNA_NewPlanev(I-2,I-1,I,J-idx+1 ,X,Etemp,
     $     Ftemp(:,3),Ftemp(:,2),Ftemp(:,1),Ftemp_o)
        Fnp1_i = Fnp1_i + Ftemp
!        Fnp1_i(:,4:6) = Fnp1_i(:,4:6) + Ftemp
        Fnp1_j(:,idx+1) = Fnp1_j(:,idx+1) + Ftemp_o
        Enp1 = Enp1 + Etemp

        Etemp = 0
        Ftemp = 0
        Ftemp_o = 0
        call RNA_NewPlanev(J-1,J,J+1,I-idx ,X,Etemp,
     $     Ftemp(:,3),Ftemp(:,2),Ftemp(:,1),Ftemp_o)
        Fnp2_j = Fnp2_j + Ftemp
!        Fnp2_i(:,4:6) = Fnp2_i(:,4:6) + Ftemp
        Fnp2_i(:,idx+1) = Fnp2_i(:,idx+1) + Ftemp_o
        Enp2 = Enp2 + Etemp
      enddo


!      if (ehhb .le. -2) then
!!        print *, Ehhb, Enp1, Enp2
!      endif
!
!
!      Fi = Fhb_i*Enp1*Enp2 + Ehhb*Fnp1_i*Enp2 + Ehhb*Enp1*Fnp2_i
!      Fj = Fhb_j*Enp1*Enp2 + Ehhb*Fnp1_j*Enp2 + Ehhb*Enp1*Fnp2_j
!      Ehhb = Ehhb * Enp1 * Enp2

      Fi = Fhb_i*(Enp1+Enp2)+ Ehhb*(Fnp1_i+Fnp2_i)
      Fj = Fhb_j*(Enp1+Enp2)+ Ehhb*(Fnp1_j+Fnp2_j)
      Ehhb = Ehhb * (Enp1 + Enp2)

!      Fi = Fhb_i
!      Fj = Fhb_j

!      F(I*3-2:I*3  )=F(I*3-2:I*3  ) + Fi(:,1)
!      F(I*3-5:I*3-3)=F(I*3-5:I*3-3) + Fi(:,2)
!      F(I*3-8:I*3-6)=F(I*3-8:I*3-6) + Fi(:,3)
!
!      F(J*3+1:J*3+3)=F(J*3+1:J*3+3) + Fj(:,1)
!      F(J*3-2:J*3  )=F(J*3-2:J*3  ) + Fj(:,2)
!      F(J*3-5:J*3-3)=F(J*3-5:J*3-3) + Fj(:,3)

      do idx = 1,3
        id = I - idx + 1
        F(id*3-2:id*3  )=F(id*3-2:id*3  ) + Fi(:,idx)

        id = J - idx + 2
        F(id*3-2:id*3  )=F(id*3-2:id*3  ) + Fj(:,idx)
      enddo

      end

c-----------------------------------------------------------------------
      subroutine RNA_hbnew(I,TI,J,TJ, epshb,X,EHHB, hbexist, 
     &                   FI,FJ,FK,FL)
c
c  This routine calculates the h-bond energies and forces between two bases.
c  
c  hbexist is a boolean whose value will depend on the presence of an h-bond
c
c    Diagram:
c      
c         ang a    ang b
c    I <--- J <- - - K ---> L
c       rji     rkj    rkl
c
c      

      use geometric_corrections
      implicit none
      real*8 pbc_mic

      integer, intent(in) :: I, TI, J, TJ
      double precision, intent(in) :: epshb, X(*)
      logical, intent(out) :: hbexist
      double precision, intent(out) :: EHHB, fi(3), fj(3), fk(3), fl(3)

      logical qbug
      common/debug/qbug
      logical periodicBC,CM
      common/PBC_R/periodicBC,CM
c     double precision alpam(4,4), alpbm(4,4)
c     integer bcoef(4,4)
c     common/alpm/alpam, alpbm, bcoef
      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)
      common/cutoffs/rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $             rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $             rcut2_4b_out, rcut2_4b_in,
     $             rcut2_lj_out, rcut2_lj_in
      double precision rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $             rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $             rcut2_4b_out, rcut2_4b_in,
     $             rcut2_lj_out, rcut2_lj_in
 
      double precision sighb, d2, Ehha, dEhha(3), Vangl, y, p,
     $ dota, cosa, alpa, dotb, cosb, alpb,
     $ sina, sinb, anga, angb, danga, dangb,
     $ rji(3), rkj(3), rkl(3), dji, dkj, dkl
      double precision, target ::
     $ dREF_AA(3), alpa_AA(3), alpb_AA(3), s_AA(3),
     $ dREF_AC(2), alpa_AC(2), alpb_AC(2), s_AC(2),
     $ dREF_AG(4), alpa_AG(4), alpb_AG(4), s_AG(4),
     $ dREF_AU(2), alpa_AU(2), alpb_AU(2), s_AU(2),
     $ dREF_CC(1), alpa_CC(1), alpb_CC(1), s_CC(1),
     $ dREF_CG(2), alpa_CG(2), alpb_CG(2), s_CG(2),
     $ dREF_CU(2), alpa_CU(2), alpb_CU(2), s_CU(2),
     $ dREF_GG(2), alpa_GG(2), alpb_GG(2), s_GG(2),
     $ dREF_GU(2), alpa_GU(2), alpb_GU(2), s_GU(2),
     $ dREF_UU(2), alpa_UU(2), alpb_UU(2), s_UU(2)

      double precision, dimension(:), pointer :: dREF, alpam, alpbm, s
!     integer, allocatable, dimension(:) :: s
      integer Nparam, par
      double precision str

      p = score_RNA(28)
      y = score_RNA(29)

      EHHB = 0
      fi = 0
      fj = 0
      fk = 0
      fl = 0
      hbexist = .false.

      !! dREF: distance reference, alpa/alpb: angles reference,
      !! s: strength of interaction
      dREF_AA = (/ 5.43, 6.44, 6.86 /)
      alpa_AA = (/ 2.55, 1.01, 0.98 /)
      alpb_AA = (/ 2.55, 1.73, 0.98 /)
      s_AA = (/ 2, 1, 2 /)

      dREF_AC = (/ 5.60, 6.94 /)
      alpa_AC = (/ 2.40, 2.07 /)
      alpb_AC = (/ 1.82, 1.48 /)
      s_AC = (/ 1, 1 /)

      dREF_AG = (/ 5.07, 6.26, 7.02, 7.54 /)
      alpa_AG = (/ 2.95, 1.20, 2.06, 0.80 /)
      alpb_AG = (/ 2.67, 1.48, 1.93, 2.14 /)
      s_AG = (/ 2, 2, 1, 1 /)

      dREF_AU = (/ 4.96, 6.43 /)
      alpa_AU = (/ 2.92, 0.84 /)
      alpb_AU = (/ 2.23, 1.95 /)
      s_AU = (/ 2, 2 /)

      dREF_CC = (/ 4.91 /)
      alpa_CC = (/ 2.22 /)
      ALPB_cc = (/ 2.24 /)
      s_CC = (/ 2 /)

      dREF_CG = (/ 4.80, 7.40 /)
      alpa_CG = (/ 2.17, 2.89 /)
      alpb_CG = (/ 2.76, 1.28 /)
      s_CG = (/ 3, 1 /)


      dREF_CU = (/ 5.62, 7.48 /)
      alpa_CU = (/ 1.75, 2.88 /)
      alpb_CU = (/ 2.64, 2.71 /)
      s_CU = (/ 1, 1 /)

      dREF_GG = (/ 6.24, 7.33 /)
      alpa_GG = (/ 2.77, 2.93 /)
      alpb_GG = (/ 1.20, 1.27 /)
      s_GG = (/ 2, 1 /)

      dREF_GU = (/ 5.67, 7.05 /)
      alpa_GU = (/ 2.15, 2.85 /)
      alpb_GU = (/ 1.72, 1.43 /)
      s_GU = (/ 2, 1 /)

      dREF_UU = (/ 5.39, 6.18 /)
      alpa_UU = (/ 1.71, 2.56 /)
      alpb_UU = (/ 2.61, 2.39 /)
      s_UU = (/ 2, 1 /)

      !	 selection of parameter for each base pair
      if (ti .eq. 1 .and. tj .eq. 1) then
         Nparam = 2
         dREF => dREF_GG
         alpam => alpa_GG
         alpbm => alpb_GG
         s => s_GG
      endif

      if (ti .eq. 1 .and. tj .eq. 2) then
         Nparam = 4
         dREF => dREF_AG
         alpam => alpa_AG
         alpbm => alpb_AG
         s => s_AG
      endif

      if (ti .eq. 2 .and. tj .eq. 1) then 
         Nparam = 4
         dREF => dREF_AG
         alpam => alpb_AG
         alpbm => alpa_AG
         s => s_AG
      endif

      if (ti .eq. 1 .and. tj .eq. 3) then
         Nparam = 2
         dREF => dREF_CG
         alpam => alpa_CG
         alpbm => alpb_CG
         s => s_CG
      endif

      if (ti .eq. 3 .and. tj .eq. 1) then
         Nparam = 2
         dREF => dREF_CG
         alpam => alpb_CG
         alpbm => alpa_CG
         s => s_CG
      endif

      if (ti .eq. 1 .and. tj .eq. 4) then
         Nparam = 2
         dREF => dREF_GU
         alpam => alpa_GU
         alpbm => alpb_GU
         s => s_GU
      endif

      if (ti .eq. 4 .and. tj .eq. 1) then 
         Nparam = 2
         dREF => dREF_GU
         alpam => alpb_GU
         alpbm => alpa_GU
         s => s_GU
      endif

      if (ti .eq. 2 .and. tj .eq. 2) then
         Nparam = 3
         dREF => dREF_AA
         alpam => alpa_AA
         alpbm => alpb_AA
         s => s_AA
      endif

      if (ti .eq. 2 .and. tj .eq. 3) then
         Nparam = 2
         dREF => dREF_AC
         alpam => alpa_AC
         alpbm => alpb_AC
         s => s_AC
      endif 

      if (ti .eq. 3 .and. tj .eq. 2) then 
         Nparam = 2
         dREF => dREF_AC
         alpam => alpb_AC
         alpbm => alpa_AC
         s => s_AC
      endif

      if (ti .eq. 2 .and. tj .eq. 4) then 
         Nparam = 2
         dREF => dREF_AU
         alpam => alpa_AU
         alpbm => alpb_AU
         s => s_AU
      endif

      if (ti .eq. 4 .and. tj .eq. 2) then 
         Nparam = 2
         dREF => dREF_AU
         alpam => alpb_AU
         alpbm => alpa_AU
         s => s_AU
      endif

      if (ti .eq. 3 .and. tj .eq. 3) then 
         Nparam = 1
         dREF => dREF_CC
         alpam => alpa_CC
         alpbm => alpb_CC
         s => s_CC
      endif

      if (ti .eq. 3 .and. tj .eq. 4) then
         Nparam = 2
         dREF => dREF_CU
         alpam => alpa_CU
         alpbm => alpb_CU
         s => s_CU
      endif

      if (ti .eq. 4 .and. tj .eq. 3) then
         Nparam = 2
         dREF => dREF_CU
         alpam => alpb_CU
         alpbm => alpa_CU
         s => s_CU
      endif

      if (ti .eq. 4 .and. tj .eq. 4) then 
         Nparam = 2
         dREF => dREF_UU
         alpam => alpa_UU
         alpbm => alpb_UU
         s => s_UU
      endif
      

      do par = 1, Nparam
         SIGHB = dREF(par)
         alpa = alpam(par)
         alpb = alpbm(par)
         str = s(par)

c     SIGHB = 4.8D0     !! 1.80 optimal distance hydrogen bond RNA
c     if(ti+tj .eq. 5) then
c       SIGHB = 5.2
c     endif

         rji = x(i*3-5:i*3-2) - x(i*3-2:i*3)
         dji = euc_norm(rji)
         rkj = x(i*3-2:i*3) - x(j*3+1:j*3+3)
         dkj = euc_norm(rkj)
         rkl = x(j*3-2:j*3) - x(j*3+1:j*3+3)
         dkl = euc_norm(rkl)
         if (periodicBC) then
           rji = pbc_mic( rji )
           rkj = pbc_mic( rkj )
           rkl = pbc_mic( rkl )
         endif

         if(dkj**2 >= rcut2_hb_mcmc_out) then
           return
         endif
!      hbexist = .true.


c     d2 = ||rkj|| - sighb
         d2 = dkj - SIGHB
         Ehha = -epshb* str * dexp(-y*d2**2)
         dEhha = -y*2*d2*rkj/dkj*Ehha

c        if(ehha .ge. -1e-8) then
c          return
c        endif
 
c     -rkj = rjk
         dota = dot_product(rji, -rkj)
         dotb = dot_product(rkj, rkl)
         cosa = dota/(euc_norm(rji)*euc_norm(rkj))
         cosb = dotb/(euc_norm(rkj)*euc_norm(rkl))
         sina = dsqrt(1 - cosa**2)
         sinb = dsqrt(1 - cosb**2)
 
         anga = cosa*DCOS(alpa) + sina*DSIN(alpa)
         danga = DCOS(alpa) - DSIN(alpa)*cosa/sina
         angb = cosb*DCOS(alpb) + sinb*DSIN(alpb)
         dangb = DCOS(alpb) - DSIN(alpb)*cosb/sinb

!      if(anga < 0.0d0 .or. angb < 0.0d0) then
!        return
!      endif
!      hbexist = .true.

         Vangl = anga**p*angb**p

         Ehhb = Ehhb + (Ehha*Vangl)

         fi = fi -Ehha*(p*Vangl/anga)*danga*
     $     ((-rkj/dkj) - cosa*(rji/dji))/dji
         fj = fj -dEhha*Vangl - Ehha*(p*Vangl/anga)*danga*
     $     ((-rji+rkj)/(dji*dkj) - cosa*(-rji/dji**2 + rkj/dkj**2)) -
     $     Ehha*(p*Vangl/angb)*dangb*
     $     ((rkl/dkl) - cosb*(rkj/dkj))/dkj
         fk = fk + dEhha*Vangl - Ehha*(p*Vangl/anga)*danga*
     $     ((rji/dji) - cosa*(-rkj/dkj))/dkj -
     $     Ehha*(p*Vangl/angb)*dangb*
     $     ((-rkj-rkl)/(dkj*dkl) - cosb*(-rkj/dkj**2 - rkl/dkl**2))
         fl = fl -Ehha*(p*Vangl/angb)*dangb*
     $     ((rkj/dkj) - cosb*(rkl/dkl))/dkl

      enddo

c     if(ehhb .ge. -1e-7) then      !! TEST HB EXISTANCE 06-04-2012
c       return
c     endif
      hbexist = .true.

      
c  ---  DEBUG
        if (qbug) then
             if (abs(EHHB) .ge. 2) then
             write(78,"(4i4, 10f8.3)") i,j,ti,tj,dkj,
     $           sighb,0.0d0,EHHB,Vangl,
     $             DACOS(cosa)*180/3.14,DACOS(cosb)*180/3.14,
     $            alpa*180/3.14,alpb*180/3.14
           endif
        endif


      end


c-----------------------------------------------------------------------
      subroutine RNA_HBarrier(I,J,K,X,F,EHBR,ti,tj,tk)

      implicit none

      integer I, J, K, ti, tj, tk
      double precision X(*), F(*), EHBR, DRA,DRB

      double precision ra(3),rb(3),DHOA,DHOB,R1,R2
      double precision dfNI(3),dfNK(3)

      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)
      double precision eta, A
      logical qbug
      common/debug/qbug

      eta = score_RNA(30)
      A   = score_RNA(31)

      ra = x((i*3-2):i*3) - x((j*3-2):(j*3))
      DHOA = dsqrt(dot_product(ra,ra))
 
      rb = x((k*3-2):k*3) - x((j*3-2):(j*3))
      DHOB = dsqrt(dot_product(rb,rb))

      R1 = 4.8
      if(ti .eq. 4 .and. tj .eq. 1) then
         R1 = 5.2
      endif
      if(tj .eq. 4 .and. ti .eq. 1) then
         R1 = 5.2
      endif
      if(ti .eq. 4 .and. tj .eq. 2) then
         R1 = 5.0
      endif
      if(tj .eq. 4 .and. ti .eq. 2) then
         R1 = 5.0
      endif
      R2 = 4.8
      if(tk .eq. 4 .and. tj .eq. 1) then
         R2 = 5.2
      endif
      if(tj .eq. 4 .and. tk .eq. 1) then
         R2 = 5.2
      endif
      if(tk .eq. 4 .and. tj .eq. 2) then
         R2 = 5.0
      endif
      if(tj .eq. 4 .and. tk .eq. 2) then
         R2 = 5.0
      endif

!      EHBR = A*exp(-eta*((DHOA-R1)**2+(DHOB-R2)**2+(DHOA-DHOB)**2))
      EHBR = A*exp(-eta*((DHOA-DHOB - (R1-R2))**2))
!      DRA = -2*eta*EHBR*(2*DHOA-DHOB-R1)
      DRA = -2*eta*EHBR*(DHOA-DHOB - (R1-R2))
!      DRB = -2*eta*EHBR*(DHOB-DHOA-R2)
      DRB = -2*eta*EHBR*(DHOA-DHOB - (R1-R2))
      
      if(qbug .and. (ehbr .ge. A*0.1 .or. ehbr .lt. 0.0)) then
         write(94,"(3i4, 6f8.3, f15.3)") I,J,K,dhoa,R1,dhob,R2,
     $     exp(-eta*((DHOA-R1)**2)), exp(-eta*((DHOB-R2)**2)),EHBR
      endif


      dfNI = DRA*ra/DHOA

!      dfNK = DRB*rb/DHOB
      dfNK = -DRB*rb/DHOB

      F((I*3-2):I*3) = F((I*3-2):I*3) - dfNI
      F((J*3-2):J*3) = F((J*3-2):J*3) + dfNK + dfNI
      F((K*3-2):K*3) = F((K*3-2):K*3) - dfNK

      RETURN
      END


c-------------------------------------------------------------------------
      subroutine RNA_NewPlanev(I,J,K,L,X,Enewpl,FI,FJ,FK,FL)
      use geometric_corrections

c     Computes the distance between one point and the plane defined by 3 other points.
c     distance(l, plane(i,j,k))

      implicit none

      integer I,J,K,L
      double precision X(*),Enewpl
      double precision, dimension(3) :: FI,FJ,FK,FL

      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)

      logical qbug
      common/debug/qbug

      double precision, dimension(3) :: ri, rj, rk, rl,
     $ v1,v2, normal, t, dndq
      double precision dist, nnorm, dedd

      ri = X(i*3-2:i*3)
      rj = X(j*3-2:j*3)
      rk = X(k*3-2:k*3)
      rl = X(l*3-2:l*3)

      v1 = ri - rj
      v2 = rk - rj
      t = rl - rj

      normal = crossproduct(v1, v2)
      nnorm = dsqrt(dot_product(normal,normal))

      dist = dot_product(normal/nnorm,t)

      Enewpl = score_RNA(24)*exp(-score_RNA(23)*dist**2)/12.0d0     
      dedd = +score_RNA(23)*2*dist*Enewpl                           ! FORCE !!!

      FL = dedd*normal/nnorm

!     dn / d ri
      FI(1:3) = dedd*(crossproduct(v2, t) - dot_product(normal, t)*
     $ crossproduct(v2,normal)/nnorm**2)/nnorm

!     dn / d rk
      FK(1:3) = dedd*(crossproduct(t, v1) - dot_product(normal, t)*
     $ crossproduct(normal,v1)/nnorm**2)/nnorm

!     dn / d rj
      dndq = v2 - v1
      FJ(1:3) = dedd*(crossproduct(t, dndq)-normal -
     $ dot_product(normal, t)*crossproduct(normal,dndq)/nnorm**2)/nnorm

      end

c-----------------------------------------------------------------------------------
      subroutine RNA_Stackv(I,J,F,X,Estk)
      use geometric_corrections

c       i-2    i   j-2    j
c         \   /      \   /
c          \ /        \ /
c          i-1        j-1

      use rnabase
      implicit none

      integer, intent(in) :: I, J
      double precision, intent(in) :: X(*)
      double precision, intent(inout) :: F(*)
      double precision, intent(out) :: Estk

      double precision a(3), b(3), c(3), d(3), r(3)
      double precision axb(3), cxd(3)
      double precision Da(3)
      double precision r1,r2,DotP,Dvr(3),Ddot,SK
      double precision VA,VC

      integer b1, b2

      double precision eq, wid

      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)

      b1 = 0
      b2 = 0
      if (btype(i) <= 2) then
        b1 = 1
      endif
      if (btype(j) <= 2) then
        b2 = 1
      endif

      eq = 3.5
      wid = 3

      SK = score_RNA(9)

      a = X(i*3-8:i*3-6) - X(i*3-5:i*3-3)   !! vector a : I-1 -> I-2
      b = X(i*3-2:i*3  ) - X(i*3-5:i*3-3)    !! vector b : I-1 -> I

      c = X(j*3-8:j*3-6) - X(j*3-5:j*3-3)    !! vector c : J-1 -> J-2
      d = X(j*3-2:j*3  ) - X(j*3-5:j*3-3)    !! vector d : J-1 -> J

      axb = crossproduct(a, b)
      cxd = crossproduct(c, d)

      r = (X(i*3-2:i*3)+X(i*3-5:i*3-3)*b1
     $    -X(j*3-2:j*3)-X(j*3-5:j*3-3)*b2)/(2+b1+b2)
 
      VA = euc_norm(axb)
      VC = euc_norm(cxd)

c    (dipole moment)^2 for parallel=antiparallel conformation

c    CHANGE : NORMALIZATION FOR EACH BASE KIND!!  02/04/2012

      r1 = euc_norm(r)
      DotP = dot_product(axb, cxd)/(VA*VC)

      r2 = (r1-eq)/wid
      Estk = -SK * DotP**4 * dexp(-r2**2)
!      Dvr = + SK*DotP**2 * dexp(-r2**2) * 2/3 * r2 / wid
      Dvr = -Estk * 1/3 * 2*r2**1/(r1*wid) * r
!      Ddot = - SK*2*DotP*dexp(-r2**2)
      Ddot = 4*Estk/DotP

c------- Derivatives on the 6 particles   -- 

      Da =  (cxd/VC - DotP*axb/VA)*Ddot/VA
!      F(i*3-8:i*3-6) = F(i*3-8:i*3-6) - Dvr - crossproduct(b, Da)
      F(i*3-8:i*3-6) = F(i*3-8:i*3-6) - crossproduct(b, Da)
      F(i*3-5:i*3-3) = F(i*3-5:i*3-3) - Dvr*b1 - crossproduct(a-b, Da)
      F(i*3-2:i*3  ) = F(i*3-2:i*3  ) - Dvr - crossproduct(Da, a)


      Da =  (axb/VA - DotP*cxd/VC)*Ddot/VC
!      F(j*3-8:j*3-6) = F(j*3-8:j*3-6) + Dvr - crossproduct(d, Da)
      F(j*3-8:j*3-6) = F(j*3-8:j*3-6) - crossproduct(d, Da)
      F(j*3-5:j*3-3) = F(j*3-5:j*3-3) + Dvr*b2 - crossproduct(c-d, Da)
      F(j*3-2:j*3  ) = F(j*3-2:j*3  ) + Dvr - crossproduct(Da, c)


      RETURN
      END
c-----------------------------------------------------------------------
      subroutine RNA_Coop(I,J,K,L,X,F,ECOOP,ti,tj,tk,tl)

c             I ------ J
c             |        |
c             |        |
c             K ------ L

      implicit none

      double precision X(*), F(*), ecoop
      integer i, j, k, l
      integer ti, tj, tk, tl

      double precision R1, R2, R0
      double precision, dimension(3) :: H1,H2,D1,D2
      double precision DE, DH1,DH2,DD1,DD2
      double precision VHB1,VHB2,CP,CM
      double precision DHB1,DHB2,DCP,DCM
      double precision, dimension(3) :: drh1,drh2, drd1,drd2

      common/cutoffs/rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $             rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $             rcut2_4b_out, rcut2_4b_in,
     $             rcut2_lj_out, rcut2_lj_in
      double precision rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $             rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $             rcut2_4b_out, rcut2_4b_in,
     $             rcut2_lj_out, rcut2_lj_in

      logical qbug
      common/debug/qbug

      double precision score, score_RNA
      common/scor/score(272),score_RNA(35)
      double precision gam, delta, lambda, A

      gam = 4.0d0
      delta = 0.5d0
      lambda = 5.0d0  !! Delta/4
      A   = score_RNA(13)

      ECOOP = 0

      ! distance HB I---K
      D1 = x((i*3-2):i*3) - x((k*3-2):k*3)
      DD1 = dsqrt(dot_product(D1,D1))
      if (DD1**2 .gt. rcut2_4b_out) then
        return
      endif



      R0 = 5.0
      R1 = 4.8
      if((ti .eq. 4 .and. tj .eq. 1) .or.
     $     (tj .eq. 4 .and. ti .eq. 1) .or.
     $     (ti .eq. 3 .and. tj .eq. 2) .or.
     $     (tj .eq. 3 .and. ti .eq. 2)) then
         R1 = 5.2
      endif

      R2 = 4.8
      if((tk .eq. 4 .and. tl .eq. 1) .or.
     $     (tl .eq. 4 .and. tk .eq. 1) .or.
     $     (tk .eq. 3 .and. tl .eq. 2) .or.
     $     (tl .eq. 3 .and. tk .eq. 2)) then
         R2 = 5.2
      endif

      ! distance HB I---J
      H1 = x((i*3-2):i*3) - x((j*3-2):j*3)
      DH1 = dsqrt(dot_product(H1,H1))

      ! distance HB K---L
      H2 = x((k*3-2):k*3) - x((l*3-2):l*3)
      DH2 = dsqrt(dot_product(H2,H2))

      ! distance HB J---L
      D2 = x((j*3-2):j*3) - x((l*3-2):l*3)
      DD2 = dsqrt(dot_product(D2,D2))

c      CP = 1.0d0
c      DCP = 0.0d0

      VHB1 = dexp(-gam*(DH1-R1)**2)
      VHB2 = dexp(-gam*(DH2-R2)**2)
      CP = dexp(-delta*(DD1-DD2)**2)
c      CM = exp(-lambda*(DD1+DD2-2*R0)*(DD1+DD2-2*R0))
 
      if(DD1+DD2 .le. 2*R0) then
         CM = 1.0d0
         DCM = 0.0d0
      else
         CM = dexp(-lambda*(DD1+DD2-2*R0)**2)
         DCM = lambda*(DD1+DD2-2*R0)
      endif

      DE = 2*A*VHB1*VHB2*CP*CM

      DCM = DE*DCM
      DCP = DE*delta*(DD1-DD2)
      DHB1 = DE*gam*(DH1-R1)
      DHB2 = DE*gam*(DH2-R2)

      ECOOP = -DE/2

      if(qbug) then     
      if(DH1 .le. R1+1 .and. DH2 .le. R2+1)then
      if(ECOOP .le. -0.001) then
          write(90,*) I,J,K,L
         write(90,"(4i4, 11f12.3)") I,J,K,L,ECOOP,DH1,DH2,R1,R2,DD1,DD2,
     $       VHB1,VHB2,CP,CM
      endif
      endif
      endif

c      DCP = 2*delta*CP*(DD1-DD2)*A*VHB1*VHB2*CM
c      DCM = 2*lambda*CM*(DD1+DD2-2*R0)*A*VHB1*VHB2*CP
    
      drh1 = DHB1*H1/DH1
  
      drh2 = DHB2*H2/DH2

      drd1 = (DCM+DCP)*D1/DD1
 
      drd2 = (DCM-DCP)*D2/DD2    

      F(I*3-2:I*3) = F(I*3-2:I*3) - drh1 - drd1

      F(J*3-2:J*3) = F(J*3-2:J*3) + drh1 - drd2

      F(K*3-2:K*3) = F(K*3-2:K*3) - drh2 + drd1

      F(L*3-2:L*3) = F(L*3-2:L*3) + drh2 + drd2

      RETURN
      END



