      module calcforces
      contains
      subroutine calcforce_protein(scale,x,f,etot)
      use ion_pair
 
      parameter (MAXPRE = 1500)    !! maximum number of residus 
      parameter (MAXNAT = MAXPRE*6)  !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT)  !! maximum number of cart coord 
      parameter (MAXPNB = 3*MAXPRE*MAXPRE)!! max number of SC-SC interactions 
      parameter (MAXBO  = MAXNAT)  !! maximum number of bonds
      parameter (MAXTH = MAXNAT*3)  !! maximum number of bond angles 
      parameter (MAXPHI = MAXNAT*4)  !! maximum number of torsional angles
      parameter (MAXTTY = 50000)       !! maximum number of residue name types 
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2)!! max number of nonbonded-pairs 

      implicit double precision (a-h,o-z)

      COMMON/MISC1/NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $             NPHIA,NNB,NTYPES,
     $             MBONA,MTHETA,MPHIA
      integer NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $             NPHIA,NNB,NTYPES,MBONA,MTHETA,MPHIA
      COMMON/NBPARA/CUT,SCNB,SCEE,IDIEL,DIELC

      COMMON/ENER1/IB(MAXBO),JB(MAXBO),ICB(MAXBO),IBH(MAXBO),JBH(MAXBO),
     $             ICBH(MAXBO)
      COMMON/ENER2/IT(MAXTH),JT(MAXTH),KT(MAXTH),ICT(MAXTH),ITH(MAXTH),
     $             JTH(MAXTH),KTH(MAXTH),ICTH(MAXTH)
      COMMON/ENER3/IP(MAXPHI),JP(MAXPHI),KP(MAXPHI),LP(MAXPHI),
     1             ICP(MAXPHI)
      COMMON/ENER4/
     1 IPH(MAXPHI),JPH(MAXPHI),KPH(MAXPHI),LPH(MAXPHI),ICPH(MAXPHI)
      
      COMMON/PARM1/RK(MAXBO),REQ(MAXBO),TK(MAXTH),TEQ(MAXTH),
     $             PK(MAXPHI),PN(MAXPHI),
     $             PHASE(MAXPHI),CN1(MAXTTY),CN2(MAXTTY),SOLTY(60),
     $             GAMC(MAXPHI),GAMS(MAXPHI),IPN(MAXPHI),FMN(MAXPHI)
      COMMON/MISC2/AMASS(MAXNAT),IAC(MAXNAT),NNO(MAXTTY)
c      COMMON/MISC4/ETHS,ETOS
      double precision amass
      integer iac, nno

      common/charge/cg,k1
c      real*8    energy_ip(3)
c      dimension energy_ip(3)

      common/REWARD/ EHHB1
     
      COMMON/VP22/VPNE(MAXPRE)
      COMMON/INDHB/INDH(MAXPRE)
      COMMON/EHB/EHBT
      COMMON/TORS/QTOR

C      common/pos/x_natv(maxxc)
      common/nnumres/numres,Id_atom
      common/ncall/LTER
      real*8  x,f 
      real*8  scale     !! lambda for hamiltonian replica exchange it scales H-bond attraction
      REAL*8 IDIEL 
      DIMENSION X(MAXXC),F(MAXXC),CG(MAXNAT)
      DIMENSION FOHIG(MAXXC),FOLOW(MAXXC),fphi(maxxc)

      integer     numres(MAXNAT),Id_atom(MAXNAT)
      LOGICAL QTOR,QDAT,QBUG
      DATA ZERO/0.0d0/

      common/pbcBL/box_length, inv_box_length
      real*8 box_length, inv_box_length
      COMMON/DEBUG/QBUG
      
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM

      dimension FIP(MAXXC)   !! Added by YC for OPEPv5


C---  COMPUTE THE FORCES F(*) and the ENERGY
C     FOR THE BOND LENGHTS, BOND ANGLES, DIHEDRALS, HYDROPHOBE-HYDROPHILIC
C     FOR THE NONBONDED AND PENALTIES (PROPENSITY, ETC...) SUCCESSFULLY


c--- Interface data Ion Pair   !! Added by YC for OPEPv5

      integer index_ip(mxip,3)

c !--- timing variables ------------------------------

      real etime
      real elapsed(2)
      real tot_1,tot_2
      real sold,snew
      
      

c---  reset the forces to zero


      f(1:natom3) = zero
      fip(1:natom3) = zero   !! Added by YC for OPEPv5

      EBONH = ZERO 
      EBONA = ZERO 
      ETHH = ZERO 
      ETHA = ZERO 
      EPH = ZERO 
      ENBPH = ZERO 
      EELPH = ZERO 
      ECNH = ZERO 
      EPA = ZERO 
      ENBPA = ZERO 
      EELPA = ZERO 
      ECNA = ZERO 
      EVDW = ZERO 
      EHBT = ZERO       !not in etot
      ELEC = ZERO 
      EHYDRO = ZERO 
      ETOT = ZERO
      ETOTM = ZERO      !not in etot
      EHHB1 = ZERO
      ener_phi = zero    
      ener_psi = zero !! NEW SHANGHAI    
      eextra = zero 
      e_ip = zero     ! salt bridge contribution
       ETOT = EHYDRO+EVDW+ELEC+EPH+EPA+ETHH+ETHA
     1        +EBONH+EBONA+ENBPH+ENBPA+ EELPH+EELPA
     2        +ECNH+EHHB1+ECNA + ener_phi + eextra + ener_psi + e_ip 
      EHIGH = ZERO
      QDAT = .FALSE.
c      LTER = LTER + 1
c      LTER = 0

      if (QDAT) THEN
      LTER = LTER + 1
C--   save data for optimization
      OPEN(UNIT=56,FILE="proteinA-opt.dat",status="unknown")
      REWIND(56)     
      ENDIF

c Transform the coordinates by translation and rotation
C      call Rotation(x_natv,x,delr,rmsd_natv,npart)


C ---- BOND LENTHS
      IF (NBONH .gt. 0) then
      CALL EBOND(NBONH,IBH,JBH,ICBH,X,F,EBONH,RK,REQ)
      ENDIF
      IF (NBONA .gt. 0) then
      CALL EBOND(NBONA,IB,JB,ICB,X,F,EBONA,RK,REQ)
      ENDIF
c     write(37,*) ' EBONH + EBONA ',EBONH+EBONA
c     stop !! SHANGHAI

C ---- BOND ANGLES 
      IF (NTHETH .gt. 0) then
      CALL ETHETA(MAXTH,NTHETH,ITH,JTH,KTH,ICTH,X,F,ETHH,TK,TEQ)
      ENDIF
      IF (NTHETA .gt. 0) then
      CALL ETHETA(MAXTH,NTHETA,IT,JT,KT,ICT,X,F,ETHA,TK,TEQ)
      ENDIF

c      open(unit=64,file="beta32.edih",status="unknown")
 
C ---- TORSIONS
      IF (NPHIH .gt. 0) then
!       write(*,*) 'nphih', nphih
      QTOR = .FALSE. 
      CALL ETORS(scale,MAXPHI,NPHIH,IPH,JPH,KPH,LPH,ICPH,CG,IAC,X,
     +   F,EPH,ENBPH,EELPH,NPHIH,ECNH,CN1,CN2,PK,PN,GAMS,GAMC,IPN,FMN)
      ENDIF


      IF (NPHIA .gt. 0) then
      QTOR = .TRUE. 
      CALL ETORS(scale,MAXPHI,NPHIA,IP,JP,KP,LP,ICP,CG,IAC,X,F,EPA,
     +   ENBPA,EELPA,NPHIA,ECNA,CN1,CN2,PK,PN,GAMS,GAMC,IPN,FMN)
      ENDIF

!       write(*,*) 'ecnh', ECNH
C --- SEPARATION SLOW AND HIGH
      fohig(1:natom3) = f(1:natom3)
      f(1:natom3) = zero
      
      EHIGH = EBONH + EBONA + ETHH + ETHA + EPH + ENBPH + EELPH+ECNH
     1 + EPA + ENBPA + EELPA
c      IF (NPHIA .gt. 0) then
c      QTOR = .TRUE. 
c      CALL ETORS(MAXPHI,NPHIA,IP,JP,KP,LP,ICP,CG,IAC,X,F,EPA,ENBPA,
c     +   EELPA,NPHIA,ECNA,CN1,CN2,PK,PN,GAMS,GAMC,IPN,FMN)
c      ENDIF

c       close(64)
c       stop


C ---- Interface with module data


         call ip_interface(index_ip,n_ip)   !! Added by YC for OPEPv5


C ---- NONBONDED INTERACTIONS
       CALL ENBOND(scale,NATOM,CG,IAC,X,F,CN1,CN2,EVDW,ELEC,index_ip,
     $     n_ip,ion_pair_control)     !! Modified by YC for OPEPv5

     
c       CALL ENBOND(scale,NATOM,CG,IAC,X,F,CN1,CN2,EVDW,ELEC)     !! Modified by YC for OPEPv5

C----- HYDROPHOBIC-HYDROPHILIC INTERACTIONS
c       CALL HYDROP(scale,X,F)

       CALL HYDROP(scale,X,F,EHYDRO,index_ip,n_ip,ion_pair_control)       !! Modified by YC for OPEPv5
!        write(*,*) 'ehydro', eahyd

C --- SEPARATION SLOW AND HIGH
      folow(1:natom3) = f(1:natom3)
      f(1:natom3) = zero

      call ephipv(x,f,ener_phi,NATOM) 
      call epsipv(x,f,ener_psi,NATOM)
c     call ephipvha(x,f,ener_phi,NATOM) 
c     call epsipvha(x,f,ener_psi,NATOM)


      fphi(1:natom3) = f(1:natom3)
      f(1:natom3)=zero


c----- SALT-BRIDGES INTERACTIONS    !! Added by YC for OPEPv5


      IF(ion_pair_control) THEN
         call ion_pair_force(x,f,e_ip)
         fip(1:natom3)=f(1:natom3)
      ENDIF

      
      f(1:natom3) = fphi(1:natom3) + folow(1:natom3) + fohig(1:natom3)
     $     +fip(1:natom3)   !! Modified by YC for OPEPv5

C     Calculate the energy and force for the constrained energy
C     THE POTENTIAL IS EXPRESSED BY: RK_con * rmsd**2


C---  PRINT OUT THE ENERGY AND THE FORCE VECTOR
       ETOT = EHYDRO+EVDW+ELEC+EPH+EPA+ETHH+ETHA
     1        +EBONH+EBONA+ENBPH+ENBPA+ EELPH+EELPA
     2        +ECNH+EHHB1+ECNA + ener_phi + eextra + ener_psi + e_ip   !! Modified by YC for OPEPv5
     
     
c--- data to write out for test IP contribution ----  !! Added by YC for OPEPv5
       IF(ion_pair_control) THEN
          energy_ip(1)=ETOT
          energy_ip(2)=e_ip
       ENDIF
       
      if (QBUG) then
         print *, '========================'
         print *, 'Ehydro   ', EHYDRO
         print *, 'Evdw     ', EVDW
         print *, 'Eelec    ', ELEC
         print *, 'Eph      ', EPH
         print *, 'Epa      ', EPA
         print *, 'Ethh     ', ETHH
         print *, 'Etha     ', ETHA
         print *, 'Ebonh    ', EBONH
         print *, 'Ebona    ', EBONA
         print *, 'Enbph    ', ENBPH
         print *, 'Enbpa    ', ENBPA
         print *, 'Eelph    ', EELPH
         print *, 'Eelpa    ', EELPA
         print *, 'Ecnh     ', ECNH
         print *, 'Ehhb1    ', EHHB1
         print *, 'Ecna     ', ECNA
         print *, 'ener_phi ', ener_phi
         print *, 'eextra   ', eextra
         print *, 'ener_psi ', ener_psi
         print *, 'e_ion    ', e_ip    !! added by YC for OPEPv5
         print *, 'Etot     ', ETOT
         STOP
      endif

      return
      END SUBROUTINE calcforce_protein


c---------------------------------------------------------------------------
      subroutine calcforce_RNA(scale,x,f,etot,logenervar,simuPercent)
      
      use RNAnb
      use energies

      parameter (MAXPRE = 1500)    !! maximum number of residus 
      parameter (MAXNAT = MAXPRE*6)  !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT)  !! maximum number of cart coord 
      parameter (MAXPNB = 3*MAXPRE*MAXPRE)!! max number of SC-SC interactions 
      parameter (MAXBO  = MAXNAT)  !! maximum number of bonds
      parameter (MAXTH = MAXNAT*3)  !! maximum number of bond angles 
      parameter (MAXPHI = MAXNAT*4)  !! maximum number of torsional angles
      parameter (MAXTTY = 50000)       !! maximum number of residue name types 
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2)!! max number of nonbonded-pairs 

      implicit double precision (a-h,o-z)

      double precision simuPercent

c      ETOS = ZERO       !not in etot
      COMMON/MISC1/NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $             NPHIA,NNB,NTYPES,
     $             MBONA,MTHETA,MPHIA
      integer NATOM
      COMMON/NBPARA/CUT,SCNB,SCEE,IDIEL,DIELC

      COMMON/ENER1/IB(MAXBO),JB(MAXBO),ICB(MAXBO),IBH(MAXBO),JBH(MAXBO),
     $             ICBH(MAXBO)
      COMMON/ENER2/IT(MAXTH),JT(MAXTH),KT(MAXTH),ICT(MAXTH),ITH(MAXTH),
     $             JTH(MAXTH),KTH(MAXTH),ICTH(MAXTH)
      COMMON/ENER3/IP(MAXPHI),JP(MAXPHI),KP(MAXPHI),LP(MAXPHI),
     1             ICP(MAXPHI)
      COMMON/ENER4/
     1 IPH(MAXPHI),JPH(MAXPHI),KPH(MAXPHI),LPH(MAXPHI),ICPH(MAXPHI)
      
      COMMON/PARM1/RK(MAXBO),REQ(MAXBO),TK(MAXTH),TEQ(MAXTH),
     $             PK(MAXPHI),PN(MAXPHI),
     $             PHASE(MAXPHI),CN1(MAXTTY),CN2(MAXTTY),SOLTY(60),
     $             GAMC(MAXPHI),GAMS(MAXPHI),IPN(MAXPHI),FMN(MAXPHI)
      COMMON/MISC2/AMASS(MAXNAT),IAC(MAXNAT),NNO(MAXTTY)
      double precision amass
      integer iac, nno

      common/charge/cg,k1

      COMMON/VP22/VPNE(MAXPRE)
      COMMON/INDHB/INDH(MAXPRE)
      COMMON/EHB/EHBT
      COMMON/TORS/QTOR

      common/scalingfactor/scaling_factor

C      common/pos/x_natv(maxxc)
      common/nnumres/numres,Id_atom
      common/ncall/LTER
      real*8  x,f 
      real*8  scale     !! lambda for hamiltonian replica exchange it scales H-bond attraction
      REAL*8 IDIEL 
      DIMENSION X(MAXXC),F(MAXXC),CG(MAXNAT)

      integer     numres(MAXNAT),Id_atom(MAXNAT)
      LOGICAL QTOR,QDAT,QBUG

      common/pbcBL/box_length, inv_box_length
      real*8 box_length, inv_box_length
      COMMON/DEBUG/QBUG
      integer i
      
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM

      logical logenervar


C---  COMPUTE THE FORCES F(*) and the ENERGY
C     FOR THE BOND LENGHTS, BOND ANGLES, DIHEDRALS, HYDROPHOBE-HYDROPHILIC
C     FOR THE NONBONDED AND PENALTIES (PROPENSITY, ETC...) SUCCESSFULLY

c---  reset the forces to zero


      f(1:natom3) = 0.0d0

      EBONH = 0.0d0 
      EBONA = 0.0d0 
      ETHH = 0.0d0 
      ETHA = 0.0d0 
      EPH = 0.0d0 
      ENBPH = 0.0d0 
      EELPH = 0.0d0 
      ECNH = 0.0d0 
      EPA = 0.0d0 
      ENBPA = 0.0d0 
      EELPA = 0.0d0 
      ECNA = 0.0d0 
      EVDW = 0.0d0 
      EHBT = 0.0d0       !not in etot
      ELEC = 0.0d0 
      EHYDRO = 0.0d0 
      ETOT = 0.0d0
      ETOTM = 0.0d0      !not in etot
      EHHB = 0.0d0
      ener_phi = 0.0d0    
      ener_psi = 0.0d0 !! NEW SHANGHAI    
      eextra = 0.0d0 
       ETOT = EHYDRO+EVDW+ELEC+EPH+EPA+ETHH+ETHA
     1        +EBONH+EBONA+ENBPH+ENBPA+ EELPH+EELPA
     2        +ECNH+EHHB+ECNA + ener_phi + eextra + ener_psi 
      QDAT = .FALSE. .or. qbug
c      LTER = LTER + 1
c      LTER = 0

      if (QDAT) THEN
      LTER = LTER + 1
C--   save data for optimization
      OPEN(UNIT=56,FILE="proteinA-opt.dat",status="unknown")
      REWIND(56)     
      ENDIF

c Transform the coordinates by translation and rotation
C      call Rotation(x_natv,x,delr,rmsd_natv,npart)


C ---- BOND LENTHS
      IF (NBONH .gt. 0) then
      call RNA_EBOND(NBONH,IBH,JBH,ICBH,X,F,EBONH,RK,REQ)
      ENDIF
      IF (NBONA .gt. 0) then
      call RNA_EBOND(NBONA,IB,JB,ICB,X,F,EBONA,RK,REQ)
      ENDIF

C ---- BOND ANGLES 
      IF (NTHETH .gt. 0) then
      call RNA_ETHETA(MAXTH,NTHETH,ITH,JTH,KTH,ICTH,X,F,ETHH,TK,TEQ)
      ENDIF
      IF (NTHETA .gt. 0) then
      call RNA_ETHETA(MAXTH,NTHETA,IT,JT,KT,ICT,X,F,ETHA,TK,TEQ)
      ENDIF

 
C ---- TORSIONS
      IF (NPHIH .gt. 0) then
      QTOR = .FALSE. 
      call RNA_ETORS(scale,NPHIH,IPH,JPH,KPH,LPH,ICPH,CG,IAC,X,
     +   F,EPH,ENBPH,EELPH,ECNH,CN1,CN2,PK,PN,GAMS,GAMC,IPN,FMN)
      ENDIF

      IF (NPHIA .gt. 0) then
      QTOR = .TRUE. 
      call RNA_ETORS(scale,NPHIA,IP,JP,KP,LP,ICP,CG,IAC,X,F,EPA,
     +   ENBPA,EELPA,ECNA,CN1,CN2,PK,PN,GAMS,GAMC,IPN,FMN)
      ENDIF

      

C----- HYDROPHOBIC-HYDROPHILIC INTERACTIONS
       call RNA_HYDROP(scale,X,F)

C---  PRINT OUT THE ENERGY AND THE FORCE VECTOR
       ETOT = EHYDRO+EVDW+ELEC+EPH+EPA+ETHH+ETHA
     1        +EBONH+EBONA+ENBPH+ENBPA+ EELPH+EELPA
     2        +ECNH+ECNA + ener_phi + eextra + ener_psi

       call RNA_RESTRAINTS(Nrests, restlens, resti, restj, X, F, Econst)
       ETOT = ETOT + Econst



       if (QDAT) then
         do i=1, 13
           write(56,'(i4,4x,f8.3,4x,f15.10,A)') i, 1.0, evec(i)
         enddo
         write(56,'(i4,4x,f8.3,4x,f15.10,A)') 14, 1.0, ebona
         write(56,'(i4,4x,f8.3,4x,f15.10,A)') 15, 1.0, etha
         write(56,'(i4,4x,f8.3,4x,f15.10,A)') 16, 1.0, evdw
         write(56,'(i4,4x,f8.3,4x,f15.10,A)') 17, 1.0, epa
         do i=18, 31
           write(56,'(i4,4x,f8.3,4x,f15.10,A)') i, 1.0, evec(i)
         enddo
         write(56,'(A,f15.10)') 'Etot     ', ETOT
       endif
       if (QBUG) then
          print *, '========================'
          print *, 'bond     ', Ebona
          print *, 'angle    ', Etha
          print *, 'torsion  ', Epa
          print *, 'Evdw     ', Evdw
          print *, 'Ehhb     ', Ehhb
          print *, 'Ebarrier ', Ehbbr
          print *, 'Ecoop    ', Ecoop
          print *, 'Estak    ', Estak
          print *, 'Ehydrop  ', Ehydro
          print *, 'Econst   ', Econst
          print *, 'Etot     ', ETOT
          STOP
       endif

       if(logenervar) then 
         write(62,"(11(f10.3, 1x))") Ebona, etha, epa, 
     $     evdw, ehhb, ehbr, Ecoop, Estak, Econst, Etot,
     $     Etot*scaling_factor
       endif
 
       f(1:natom3) = f(1:natom3) * scaling_factor
       ETOT = ETOT * scaling_factor

      return
      END SUBROUTINE calcforce_RNA
c---------------------------------------------------------------------------
      subroutine ephipv(x,f,ener_phi,NATOM) 
      
C     Subroutine used to introduce Phi penalty energy outside regions.
C     term E=k*(phi-phi0)**2, and the corresponding force. 
C     if -160 < phi < -60, phi0 = phi, E=0; else, phi0=0, E=k*phi**2 
c     a smaller force constant k is used for Gly and Asp
c     no term for Pro (L) or Pro (D)
      
      implicit none
      
      real*8 pbc_mic
      
      integer MAXPRE,MAXNAT,MAXXC,NATOM,MAXPAI
      parameter (MAXPRE = 1500)  !! maximum number of residus
      parameter (MAXNAT = MAXPRE*6) !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT) !! maximum number of cart coord
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2) !! max number of nonbonded-pairs 
      
      real*8 force_k, forceg_k, radian, rad2, rad4
      real*8 scaling_factor
c     parameter (force_k = (5.0d0)) !! *0.76d0) !scale 10 from OPEP3.0 - for MD
c     parameter (forceg_k = (1.5d0)) !! 3.0for Gly and ASP from OPEP3.0 - for MD
      parameter (force_k = (1.1d0)) !! best-vecteur 24 July06
      parameter (forceg_k = (0.5d0)) !! 	   
c     parameter (force_k = 10.0d0) !! *0.76d0) !scale 10 from OPEP3.0
c     parameter (forceg_k = 3.0d0) !! 3.0 for GlY and ASP from OPEP3.0
      parameter (radian = 57.29577951308232088d0) 
      parameter (rad2 = radian*radian)
      parameter (rad4 = rad2*rad2)
      
      common/scalingfactor/scaling_factor
      common/textt/text2,text3,text4
      common/nnumres/numres,Id_atom
      
      
!!      common/propens/ialpha(MAXNAT),ibeta(MAXNAT),icoeff(MAXPAI),
!!     1     foal(20),walpha(20),fobe(20),wbeta(20)
      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)
      common/propens2/walpha_foal(20),wbeta_fobe(20)
      
      integer ialpha,ibeta,icoeff,nfrag, lenfrag,ichain 
      real*8  foal,walpha,fobe,wbeta, walpha_foal, wbeta_fobe
      
      integer i,i3 
      integer Id_atom(MAXNAT), numres(MAXNAT) !Id of atom and residue
      integer ixa,iya,iza,ixb,iyb,izb,ixc,iyc,izc,ixd,iyd,izd
      real*8  x,f,deg           ! deg: first derivative of phi>0 energy term 
      dimension x(MAXXC), f(MAXXC), deg(MAXXC) 
      real*8 xa,ya,za,xb,yb,zb,xc,yc,zc,xd,yd,zd
      real*8 xba,yba,zba,xcb,ycb,zcb,xdc,ydc,zdc
      real*8 xca,yca,zca,xdb,ydb,zdb
      real*8 xt,yt,zt,dot_prq,rcb,rprq
      real*8 xu,yu,zu,xtu,ytu,ztu,rt2,ru2,rtru
      real*8 phi_lower,phi_upper,phi,sin_phi,cos_phi,phi0  
      real*8 dt,dt2,e_phi,ener_phi,dedphi
      real*8 dedxt,dedyt,dedzt,dedxu,dedyu,dedzu
      real*8 dedxa,dedya,dedza,dedxb,dedyb,dedzb
      real*8 dedxc,dedyc,dedzc,dedxd,dedyd,dedzd 
      real*8 t1,t2
      real*8 dr,drtr,drur,fphi,fdphi
      
      character*7 text2(MAXNAT)
      character*5 text3(MAXNAT)
      character*7 text4(MAXNAT)
      
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM
      
      integer natom3
      natom3 = natom*3
c     open(unit=38,file="beta32.ephi",status="unknown")
      
C     zero out the restraint energy term and first derivatives
      ener_phi = 0.0d0
      f(1:natom3) = 0.0d0
      deg(1:natom3) = 0.0d0
      
      phi_lower = -160.0d0
      phi_upper = -60.0d0 
      
      
C     Calculating the phi>0 penalty energy and the first derivative of this term 
      do i = 5, NATOM-4
        
        if (text4(i).eq. ' PRO   ') then
           go to 5200
        endif 
        
        if ( text3(i).eq.'  CA ' .and. (text4(i).ne. ' DPR   ')) then
           
           if (ichain(i-4) .eq. ichain(i+2)) then 
              
              i3 = i*3
              
              ixa = i3 - 14
              iya = i3 - 13
              iza = i3 - 12
              xa = x(ixa)
              ya = x(iya)
              za = x(iza)
              
               
C     The x, y, and z coordinates for N2 
              ixb = i3 - 8
              iyb = i3 - 7 
              izb = i3 - 6 
              xb = x(ixb) 
              yb = x(iyb)
              zb = x(izb)
              
C     The x, y, and z coordinates for C_alpha
              ixc = i3 - 2
              iyc = i3 - 1 
              izc = i3 
              xc = x(ixc)
              yc = x(iyc)
              zc = x(izc)
C     The x, y, and z coordinates for C2
              if (text4(i).ne. ' GLY   ') then
                 ixd = i3 + 4
                 iyd = i3 + 5 
                 izd = i3 + 6
              else
                 ixd = i3 + 1
                 iyd = i3 + 2 
                 izd = i3 + 3
              endif
              xd = x(ixd)
              yd = x(iyd)
              zd = x(izd)
C     The x, y, z components of a vector from one atom to another atom are:
              xba = xb - xa     !vector p from C1 to N2
              yba = yb - ya
              zba = zb - za
              xcb = xc - xb     !vector r from N2 to C_alpha 
              ycb = yc - yb
              zcb = zc - zb
              xdc = xd - xc     !vector q from C_alpha to C2
              ydc = yd - yc
              zdc = zd - zc
              
C      If required we apply periodic boundary conditions
              if (periodicBC) then
                 xba = pbc_mic( xba )
                 yba = pbc_mic( yba )
                 zba = pbc_mic( zba )
                 xcb = pbc_mic( xcb )
                 ycb = pbc_mic( ycb )
                 zcb = pbc_mic( zcb )
                 xdc = pbc_mic( xdc )
                 ydc = pbc_mic( ydc )
                 zdc = pbc_mic( zdc )
              endif
               
C     cross product of p and r (pxr)
              xt = yba*zcb - ycb*zba
              yt = zba*xcb - zcb*xba
              zt = xba*ycb - xcb*yba
C     Vector product of r and q (rxq)
              xu = ycb*zdc - ydc*zcb
              yu = zcb*xdc - zdc*xcb
              zu = xcb*ydc - xdc*ycb
C     Vector product of (pxr)x(rxq)
              xtu = yt*zu - yu*zt
              ytu = zt*xu - zu*xt
              ztu = xt*yu - xu*yt
C     Calculating |pxr|**2
              rt2 = xt*xt + yt*yt + zt*zt
C     Calculating |rxq|**2
              ru2 = xu*xu + yu*yu + zu*zu
              rtru = sqrt(rt2 * ru2)
C     Calculating (pxr,rxq)
              dot_prq = xt*xu + yt*yu + zt*zu
              if (rtru .ne. 0.0d0) then 
               rcb = sqrt(xcb*xcb + ycb*ycb + zcb*zcb)
               cos_phi = dot_prq / rtru
               cos_phi = min(1.0d0,max(-1.0d0,cos_phi)) 
               rprq = xcb*xtu + ycb*ytu + zcb*ztu       
               sin_phi = rprq / (rcb*rtru)
               
               
C     calculating phi 
               phi = dacos(cos_phi) * radian 
               if (sin_phi .lt. 0.0d0) phi = -phi 
               if ((phi .gt. phi_lower) .and. (phi .lt. phi_upper)) then
                  phi0 = phi
               else if(phi.gt.phi_lower.and.phi_lower.gt.phi_upper) then
                  phi0 = phi
               else if(phi.lt.phi_upper.and.phi_lower.gt.phi_upper) then
                  phi0 = phi
               else
                  t1 = phi - phi_lower
                  t2 = phi - phi_upper
                  if (t1 .gt. 180.0d0) then
                     t1 = t1 - 360.0d0
                  else if (t1 .lt. -180.0d0) then
                     t1 = t1 + 360.0d0
                  end if
                  if (t2 .gt. 180.0d0) then
                     t2 = t2 - 360.0d0
                  else if (t2 .lt. -180.0d0) then
                     t2 = t2 + 360.0d0
                  end if
                  if (abs(t1) .lt. abs(t2)) then
                     phi0 = phi_lower
                  else
                     phi0 = phi_upper
                  end if
               endif 
               dt = phi - phi0
               if (dt .gt. 180.0d0) then
                  dt = dt - 360.0d0
               else if (dt .lt. -180.0d0) then
                  dt = dt + 360.0d0
               end if 
C     Using E(phi) = k * (phi-phi0)**2
               dt2 = dt * dt
c     e_phi = force_k * dt2 !in degrees
               if (text4(i).ne.' GLY   '.and.text4(i).ne. ' ASP   ')then
                  fphi = force_k * scaling_factor / (rad2)
                  fdphi = fphi * radian
                  e_phi = fphi * dt2 !in radian
                  dedphi = 2.0d0 * fdphi * dt
               else
                  fphi = forceg_k * scaling_factor / (rad2)
                  fdphi = fphi * radian
                  e_phi = fphi * dt2 !in radian
                  dedphi = 2.0d0 * fdphi * dt
               endif
               
C     chain rule terms for first derivative components
C     x,y,z component of vector from C1 to C_alpha  
               xca = xc - xa
               yca = yc - ya
               zca = zc - za
C     x,y,z component of vector from C2 to N2 
               xdb = xd - xb
               ydb = yd - yb
               zdb = zd - zb
               
C     If required we apply periodic boundary conditions                 
               if(periodicBC)then
                  
                  xca = pbc_mic( xca ) 
                  yca = pbc_mic( yca ) 
                  zca = pbc_mic( zca ) 
                  
                  xdb = pbc_mic( xdb ) 
                  ydb = pbc_mic( ydb ) 
                  zdb = pbc_mic( zdb ) 
               endif
               
               dr = dedphi/rcb
               drtr = dr/rt2
               drur = dr/ru2
               dedxt =  drtr * (yt*zcb - ycb*zt)
               dedyt =  drtr * (zt*xcb - zcb*xt)
               dedzt =  drtr * (xt*ycb - xcb*yt)
               dedxu = -drur * (yu*zcb - ycb*zu)
               dedyu = -drur * (zu*xcb - zcb*xu)
               dedzu = -drur * (xu*ycb - xcb*yu)      
               
C     compute derivative components for this interaction
               dedxa = zcb*dedyt - ycb*dedzt
               dedya = xcb*dedzt - zcb*dedxt
               dedza = ycb*dedxt - xcb*dedyt
               dedxb = yca*dedzt - zca*dedyt + zdc*dedyu - ydc*dedzu
               dedyb = zca*dedxt - xca*dedzt + xdc*dedzu - zdc*dedxu
               dedzb = xca*dedyt - yca*dedxt + ydc*dedxu - xdc*dedyu
               dedxc = zba*dedyt - yba*dedzt + ydb*dedzu - zdb*dedyu
               dedyc = xba*dedzt - zba*dedxt + zdb*dedxu - xdb*dedzu
               dedzc = yba*dedxt - xba*dedyt + xdb*dedyu - ydb*dedxu
               dedxd = zcb*dedyu - ycb*dedzu
               dedyd = xcb*dedzu - zcb*dedxu
               dedzd = ycb*dedxu - xcb*dedyu
               
C     increment the overall energy term and derivatives
               
               ener_phi = ener_phi + e_phi !total energy of phi>0 
               
               deg(ixa) = deg(ixa) + dedxa
               deg(iya) = deg(iya) + dedya
               deg(iza) = deg(iza) + dedza
               deg(ixb) = deg(ixb) + dedxb
               deg(iyb) = deg(iyb) + dedyb
               deg(izb) = deg(izb) + dedzb
               deg(ixc) = deg(ixc) + dedxc
               deg(iyc) = deg(iyc) + dedyc
               deg(izc) = deg(izc) + dedzc
               deg(ixd) = deg(ixd) + dedxd
               deg(iyd) = deg(iyd) + dedyd
               deg(izd) = deg(izd) + dedzd
               
             endif
           endif
c     enddo  !! loop j
        endif 
 5200   continue
      enddo
      
      f(1:natom3) = -deg(1:natom3)
      
      
      return
      end subroutine ephipv 
      
      
      subroutine epsipv(x,f,ener_psi,NATOM) 

C     This subroutine is used to restrict the Psi region 
C     term E=k*(psi-psi0)**2, and the corresponding force. 
C     if -60 < psi < 160, phi0 = phi, E=0; else, phi0=0, E=k*phi**2 
c     a smaller force constant k is used for Gly and Asp
c     no term for Pro (L) or Pro (D)
      
      implicit none
      
      real*8 pbc_mic
       
      integer MAXPRE,MAXNAT,MAXXC,NATOM,MAXPAI
      parameter (MAXPRE = 1500)  !! maximum number of residus
      parameter (MAXNAT = MAXPRE*6) !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT) !! maximum number of cart coord
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2) !! max number of nonbonded-pairs 
      
      real*8 force_k, forceg_k, radian, rad2, rad4
      real*8 scaling_factor
c     parameter (force_k = (5.0d0)) ! *0.76d0) ! scale 10 from OPEP3.0   for MD
c     parameter (forceg_k = (1.5d0)) ! 3.0 for Gly from OPEP3.0           for MD
      parameter (force_k = (1.1d0)) !! best-vecteur 24 July06
      parameter (forceg_k = (0.5d0)) !! 
c     parameter (force_k = 10.0d0) ! *0.76d0) ! scale 10 from OPEP3.0 
c     parameter (forceg_k = 3.0d0) ! 3.0 for Gly and Asp from OPEP3.0 
      parameter (radian = 57.29577951308232088d0) 
      parameter (rad2 = radian*radian)
      parameter (rad4 = rad2*rad2)
      
      common/scalingfactor/scaling_factor
      common/textt/text2,text3,text4
      common/nnumres/numres,Id_atom
      
!!      common/propens/ialpha(MAXNAT),ibeta(MAXNAT),icoeff(MAXPAI),
!!     1     foal(20),walpha(20),fobe(20),wbeta(20)
      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)
      
      integer ialpha,ibeta,icoeff,nfrag, lenfrag,ichain 
      real*8  foal,walpha,fobe,wbeta
      
      
      integer i,i3 
      integer Id_atom(MAXNAT), numres(MAXNAT) !Id of atom and residue
      integer ixa,iya,iza,ixb,iyb,izb,ixc,iyc,izc,ixd,iyd,izd
      real*8  x,f,deg           ! deg: first derivative of psi>0 energy term 
      dimension x(MAXXC), f(MAXXC), deg(MAXXC) 
      real*8 xa,ya,za,xb,yb,zb,xc,yc,zc,xd,yd,zd
      real*8 xba,yba,zba,xcb,ycb,zcb,xdc,ydc,zdc
      real*8 xca,yca,zca,xdb,ydb,zdb
      real*8 xt,yt,zt,dot_prq,rcb,rprq
      real*8 xu,yu,zu,xtu,ytu,ztu,rt2,ru2,rtru
      real*8 psi_lower,psi_upper,psi,sin_psi,cos_psi,psi0  
      real*8 dt,dt2,e_psi, ener_psi,dedpsi
      real*8 dedxt,dedyt,dedzt,dedxu,dedyu,dedzu
      real*8 dedxa,dedya,dedza,dedxb,dedyb,dedzb
      real*8 dedxc,dedyc,dedzc,dedxd,dedyd,dedzd 
      real*8 t1,t2, ftot
      real*8 dr,drtr,drur,fpsi,fdpsi
      
      character*7 text2(MAXNAT)
      character*5 text3(MAXNAT)
      character*7 text4(MAXNAT)
      
      common/PBC_R/periodicBC,CM
      logical periodicBC,CM
      
      integer natom3
      natom3 = natom*3
c     open(unit=38,file="beta32.epsi",status="unknown")
      
C zero out the restraint energy term and first derivatives
      ener_psi = 0.0d0
      
      deg(1:natom3) = 0.0d0
      
      psi_lower = -60.0D0
      psi_upper = 160.0d0 
      
      
C     Calculating the psi>0 penalty energy and the first derivative of this term 
      do i = 3, NATOM-4
        if (text4(i).eq. ' PRO   ') then
           go to 5200
        endif 
        
        if ( text3(i).eq.'  CA ' .and. text4(i).ne. ' DPR   ' ) then !!           
           
           if (ichain(i-2) .eq. ichain(i+4)) then 
              i3 = i*3

C     The x, y, and z coordinates for C1, N2, C_alpha, C2 are the following: 
C     The x, y, and z coordinates for C1
              ixa = i3-8
              iya = i3-7
              iza = i3-6
              xa = x(ixa)
              ya = x(iya)
              za = x(iza)
              
C     The x, y, and z coordinates for N2 
              ixb = i3-2
              iyb = i3-1 
              izb = i3 
              xb = x(ixb) 
              yb = x(iyb)
              zb = x(izb)
              
C     The x, y, and z coordinates for C_alpha
              if (text4(i).ne. ' GLY   ') then
                 ixc = i3+4
                 iyc = i3+5 
                 izc = i3+6
              else
                 ixc = i3+1
                 iyc = i3+2 
                 izc = i3+3 
              endif
              xc = x(ixc)
              yc = x(iyc)
              zc = x(izc)
              
C     The x, y, and z coordinates for C2
              if (text4(i).ne. ' GLY   ') then
                 ixd = i3+10
                 iyd = i3+11 
                 izd = i3+12
              else
                 ixd = i3+7
                 iyd = i3+8 
                 izd = i3+9 
              endif
              xd = x(ixd)
              yd = x(iyd)
              zd = x(izd)
C     The x, y, z components of a vector from one atom to another atom are:
              xba = xb - xa     !vector p from C1 to N2
              yba = yb - ya
              zba = zb - za
              xcb = xc - xb     !vector r from N2 to C_alpha 
              ycb = yc - yb
              zcb = zc - zb
              xdc = xd - xc     !vector q from C_alpha to C2
              ydc = yd - yc
              zdc = zd - zc
              
C     If required, we apply periodic boundary conditions
              if(periodicBC)then
                 xba = pbc_mic( xba ) 
                 yba = pbc_mic( yba ) 
                 zba = pbc_mic( zba ) 
                 xcb = pbc_mic( xcb ) 
                 ycb = pbc_mic( ycb ) 
                 zcb = pbc_mic( zcb ) 
                 xdc = pbc_mic( xdc ) 
                 ydc = pbc_mic( ydc ) 
                 zdc = pbc_mic( zdc ) 
              endif

C        cross product of p and r (pxr)
              xt = yba*zcb - ycb*zba
              yt = zba*xcb - zcb*xba
              zt = xba*ycb - xcb*yba
C     Vector product of r and q (rxq)
              xu = ycb*zdc - ydc*zcb
              yu = zcb*xdc - zdc*xcb
              zu = xcb*ydc - xdc*ycb
C     Vector product of (pxr)x(rxq)
              xtu = yt*zu - yu*zt
              ytu = zt*xu - zu*xt
              ztu = xt*yu - xu*yt
C     Calculating |pxr|**2
              rt2 = xt*xt + yt*yt + zt*zt
C     Calculating |rxq|**2
              ru2 = xu*xu + yu*yu + zu*zu
              rtru = sqrt(rt2 * ru2)
C     Calculating (pxr,rxq)
              dot_prq = xt*xu + yt*yu + zt*zu
              if (rtru .ne. 0.0d0) then 
               rcb = sqrt(xcb*xcb + ycb*ycb + zcb*zcb)
               cos_psi = dot_prq / rtru
               cos_psi = min(1.0d0,max(-1.0d0,cos_psi)) 
               rprq = xcb*xtu + ycb*ytu + zcb*ztu       
               sin_psi = rprq / (rcb*rtru)
C     calculating psi 
               psi = dacos(cos_psi) * radian 
               if (sin_psi .lt. 0.0d0) psi = -psi 
               if ((psi .gt. psi_lower) .and. (psi .lt. psi_upper)) then
                  psi0 = psi
               else if(psi.gt.psi_lower.and.psi_lower.gt.psi_upper) then
                  psi0 = psi
               else if(psi.lt.psi_upper.and.psi_lower.gt.psi_upper) then
                  psi0 = psi
               else
                  t1 = psi - psi_lower
                  t2 = psi - psi_upper
                  if (t1 .gt. 180.0d0) then
                     t1 = t1 - 360.0d0
                  else if (t1 .lt. -180.0d0) then
                     t1 = t1 + 360.0d0
                  end if
                  if (t2 .gt. 180.0d0) then
                     t2 = t2 - 360.0d0
                  else if (t2 .lt. -180.0d0) then
                     t2 = t2 + 360.0d0
                  end if
                  if (abs(t1) .lt. abs(t2)) then
                     psi0 = psi_lower
                  else
                     psi0 = psi_upper
                  end if
               endif
               dt = psi - psi0
               if (dt .gt. 180.0d0) then
                  dt = dt - 360.0d0
               else if (dt .lt. -180.0d0) then
                  dt = dt + 360.0d0
               end if
                 
C     Using E(psi) = k * (psi-psi0)**2
               dt2 = dt * dt
c     e_psi = force_k * dt2 !in degrees
               if (text4(i).ne.' GLY   '.and.text4(i).ne. ' ASP   ')then
                    fpsi = force_k * scaling_factor / (rad2)
                    fdpsi = fpsi * radian
                    e_psi = fpsi * dt2 !in radian
                    dedpsi = 2.0d0 * fdpsi * dt
                 else
                    fpsi = forceg_k * scaling_factor / (rad2)
                    fdpsi = fpsi * radian
                    e_psi = fpsi * dt2 !in radian
                    dedpsi = 2.0d0 * fdpsi * dt
                 endif
                
C     chain rule terms for first derivative components
C     x,y,z component of vector from C1 to C_alpha  
                 xca = xc - xa
                 yca = yc - ya
                 zca = zc - za
C     x,y,z component of vector from C2 to N2 
                 xdb = xd - xb
                 ydb = yd - yb
                 zdb = zd - zb
                 
C     if required, we apply periodic boundary conditions
                 if(periodicBC)then
                    xca = pbc_mic( xca )
                    yca = pbc_mic( yca )
                    zca = pbc_mic( zca )
                    
                    xdb = pbc_mic( xdb )
                    ydb = pbc_mic( ydb )
                    zdb = pbc_mic( zdb )
                 endif
                 
                 dr = dedpsi/rcb
                 drtr = dr/rt2
                 drur = dr/ru2
                 dedxt =  drtr * (yt*zcb - ycb*zt)
                 dedyt =  drtr * (zt*xcb - zcb*xt)
                 dedzt =  drtr * (xt*ycb - xcb*yt)
                 dedxu = -drur * (yu*zcb - ycb*zu)
                 dedyu = -drur * (zu*xcb - zcb*xu)
                 dedzu = -drur * (xu*ycb - xcb*yu)           
                 
C     compute derivative components for this interaction
                 dedxa = zcb*dedyt - ycb*dedzt
                 dedya = xcb*dedzt - zcb*dedxt
                 dedza = ycb*dedxt - xcb*dedyt
                 dedxb = yca*dedzt - zca*dedyt + zdc*dedyu - ydc*dedzu
                 dedyb = zca*dedxt - xca*dedzt + xdc*dedzu - zdc*dedxu
                 dedzb = xca*dedyt - yca*dedxt + ydc*dedxu - xdc*dedyu
                 dedxc = zba*dedyt - yba*dedzt + ydb*dedzu - zdb*dedyu
                 dedyc = xba*dedzt - zba*dedxt + zdb*dedxu - xdb*dedzu
                 dedzc = yba*dedxt - xba*dedyt + xdb*dedyu - ydb*dedxu
                 dedxd = zcb*dedyu - ycb*dedzu
                 dedyd = xcb*dedzu - zcb*dedxu
                 dedzd = ycb*dedxu - xcb*dedyu
                 
C     increment the overall energy term and derivatives
                 
                 ener_psi = ener_psi + e_psi !total energy of psi>0 
                 
                 deg(ixa) = deg(ixa) + dedxa
                 deg(iya) = deg(iya) + dedya
                 deg(iza) = deg(iza) + dedza
                 deg(ixb) = deg(ixb) + dedxb
                 deg(iyb) = deg(iyb) + dedyb
                 deg(izb) = deg(izb) + dedzb
                 deg(ixc) = deg(ixc) + dedxc
                 deg(iyc) = deg(iyc) + dedyc
                 deg(izc) = deg(izc) + dedzc
                 deg(ixd) = deg(ixd) + dedxd
                 deg(iyd) = deg(iyd) + dedyd
                 deg(izd) = deg(izd) + dedzd
                 
              endif
           endif
c     enddo  !! loop j 
        endif 
 5200   continue
      enddo
      ftot = 0.0d0
      f(1:natom3) = f(1:natom3) - deg(1:natom3)
      return
      end subroutine epsipv
      
c---------------------------------------------------------------------------
      subroutine ephipvha(x,f,ener_phi,NATOM) 
      
C     This subroutine is used to calculate Phi positive penalty energy 
C     term E=k*(phi-phi0)**2, and the cooresponding force. 
C     if -180 < phi < 0, phi0 = phi, E=0; else, phi0=0, E=k*phi**2 
      
      implicit none
      
      real*8 pbc_mic
      
      integer MAXPRE,MAXNAT,MAXXC,NATOM,MAXPAI
      parameter (MAXPRE = 1500)  !! maximum number of residus
      parameter (MAXNAT = MAXPRE*6) !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT) !! maximum number of cart coord
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2) !! max number of nonbonded-pairs 
      
      real*8 force_k, radian, rad2, rad4
      parameter (force_k = 7.6d0) ! 10.0d0*0.76d0) !scale 10 from OPEP3.0
      parameter (radian = 57.29577951308232088d0) 
      parameter (rad2 = radian*radian)
      parameter (rad4 = rad2*rad2)
      
      common/textt/text2,text3,text4
      common/nnumres/numres,Id_atom
      
      
!!      common/propens/ialpha(MAXNAT),ibeta(MAXNAT),icoeff(MAXPAI),
!!     1     foal(20),walpha(20),fobe(20),wbeta(20)
      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)

      integer ialpha,ibeta,icoeff,nfrag, lenfrag,ichain 
      real*8  foal,walpha,fobe,wbeta

      integer i,i3 
      integer Id_atom(MAXNAT), numres(MAXNAT) !Id of atom and residue
      integer ixa,iya,iza,ixb,iyb,izb,ixc,iyc,izc,ixd,iyd,izd
      real*8  x,f,deg           ! deg: first derivative of phi>0 energy term 
      dimension x(MAXXC), f(MAXXC), deg(MAXXC) 
      real*8 xa,ya,za,xb,yb,zb,xc,yc,zc,xd,yd,zd
      real*8 xba,yba,zba,xcb,ycb,zcb,xdc,ydc,zdc
      real*8 xca,yca,zca,xdb,ydb,zdb
      real*8 xt,yt,zt,dot_prq,rcb,rprq
      real*8 xu,yu,zu,xtu,ytu,ztu,rt2,ru2,rtru
      real*8 phi_lower,phi_upper,phi,sin_phi,cos_phi,phi0  
      real*8 dt,dt2,e_phi, ener_phi,dedphi
      real*8 dedxt,dedyt,dedzt,dedxu,dedyu,dedzu
      real*8 dedxa,dedya,dedza,dedxb,dedyb,dedzb
      real*8 dedxc,dedyc,dedzc,dedxd,dedyd,dedzd 
      real*8 t1,t2
      real*8 dr,drtr,drur,fphi,fdphi

      character*7 text2(MAXNAT)
      character*5 text3(MAXNAT)
      character*7 text4(MAXNAT)

      common/PBC_R/periodicBC,CM
      logical periodicBC,CM

      integer  natom3
      natom3 = natom*3
      

C     zero out the restraint energy term and first derivatives
      ener_phi = 0.0d0
      f(1:natom3) = 0.0d0
      deg(1:natom3) = 0.0d0
      
      phi_lower = -160.0d0
      phi_upper = -60.0d0 
      

      do i = 7, NATOM-4
        if ( text3(i).eq.'  CA ' .and. text4(i).ne. ' GLY ') then
           if (ichain(i-4) .eq. ichain(i+2)) then 
              
              i3 = i*3

C     The x, y, and z coordinates for C1, N2, C_alpha, C2 are the following: 
C     The x, y, and z coordinates for C1
              ixa = i3 - 14
              iya = i3 - 13
              iza = i3 - 12
              xa = x(ixa)
              ya = x(iya)
              za = x(iza)
              
C     The x, y, and z coordinates for N2 
              ixb = i3 - 8
              iyb = i3 - 7 
              izb = i3 - 6 
              xb = x(ixb) 
              yb = x(iyb)
              zb = x(izb)
              
C     The x, y, and z coordinates for C_alpha
              ixc = i3 - 2
              iyc = i3 - 1 
              izc = i3 
              xc = x(ixc)
              yc = x(iyc)
              zc = x(izc)
C     The x, y, and z coordinates for C2
              ixd = i3 + 7
              iyd = i3 + 8 
              izd = i3 + 9
              xd = x(ixd)
              yd = x(iyd)
              zd = x(izd)
C     The x, y, z components of a vector from one atom to another atom are:
              xba = xb - xa     !vector p from C1 to N2
              yba = yb - ya
              zba = zb - za
              xcb = xc - xb     !vector r from N2 to C_alpha 
              ycb = yc - yb
              zcb = zc - zb
              xdc = xd - xc     !vector q from C_alpha to C2
              ydc = yd - yc
              zdc = zd - zc
C-----------------------------------------------------------RL    ----------------------
              
              if(periodicBC)then
                 xba = pbc_mic( xba )
                 yba = pbc_mic( yba )
                 zba = pbc_mic( zba )

                 xcb = pbc_mic( xcb )
                 ycb = pbc_mic( ycb )
                 zcb = pbc_mic( zcb )
                 
                 xdc = pbc_mic( xdc )
                 ydc = pbc_mic( ydc )
                 zdc = pbc_mic( zdc )
              endif

C-----------------------------------------------------------RL    ----------------------
C     cross product of p and r (pxr)
              xt = yba*zcb - ycb*zba
              yt = zba*xcb - zcb*xba
              zt = xba*ycb - xcb*yba
C     Vector product of r and q (rxq)
              xu = ycb*zdc - ydc*zcb
              yu = zcb*xdc - zdc*xcb
              zu = xcb*ydc - xdc*ycb
C     Vector product of (pxr)x(rxq)
              xtu = yt*zu - yu*zt
              ytu = zt*xu - zu*xt
              ztu = xt*yu - xu*yt
C     Calculating |pxr|**2
              rt2 = xt*xt + yt*yt + zt*zt
C     Calculating |rxq|**2
              ru2 = xu*xu + yu*yu + zu*zu
              rtru = sqrt(rt2 * ru2)
C     Calculating (pxr,rxq)
              dot_prq = xt*xu + yt*yu + zt*zu
              if (rtru .ne. 0.0d0) then 
               rcb = sqrt(xcb*xcb + ycb*ycb + zcb*zcb)
               cos_phi = dot_prq / rtru
               cos_phi = min(1.0d0,max(-1.0d0,cos_phi)) 
               rprq = xcb*xtu + ycb*ytu + zcb*ztu       
               sin_phi = rprq / (rcb*rtru)
C     calculating phi 
               phi = dacos(cos_phi) * radian 
               if (sin_phi .lt. 0.0d0) phi = -phi 
               if ((phi .gt. phi_lower) .and. (phi .lt. phi_upper)) then
                  phi0 = phi
               else if(phi.gt.phi_lower.and.phi_lower.gt.phi_upper) then
                  phi0 = phi
               else if(phi.lt.phi_upper.and.phi_lower.gt.phi_upper) then
                  phi0 = phi
               else
                  t1 = phi - phi_lower
                  t2 = phi - phi_upper
                  if (t1 .gt. 180.0d0) then
                     t1 = t1 - 360.0d0
                  else if (t1 .lt. -180.0d0) then
                     t1 = t1 + 360.0d0
                  end if
                  if (t2 .gt. 180.0d0) then
                     t2 = t2 - 360.0d0
                  else if (t2 .lt. -180.0d0) then
                     t2 = t2 + 360.0d0
                  end if
                  if (abs(t1) .lt. abs(t2)) then
                     phi0 = phi_lower
                  else
                     phi0 = phi_upper
                  end if
               endif
               dt = phi - phi0
               if (dt .gt. 180.0d0) then
                  dt = dt - 360.0d0
               else if (dt .lt. -180.0d0) then
                  dt = dt + 360.0d0
               end if
               
C     Using E(phi) = k * (phi-phi0)**2
               dt2 = dt * dt
c     e_phi = force_k * dt2 !in degrees
               fphi = force_k / (rad2)
               fdphi = fphi * radian
               e_phi = fphi * dt2 !in radian
               dedphi = 2.0d0 * fdphi * dt
               
                
C     chain rule terms for first derivative components
C     x,y,z component of vector from C1 to C_alpha  


                 xca = xc - xa
                 yca = yc - ya
                 zca = zc - za
C     x,y,z component of vector from C2 to N2 
                 xdb = xd - xb
                 ydb = yd - yb
                 zdb = zd - zb
C-----------------------------------------------------------RL    ----------------------

                 if(periodicBC)then
                    xca = pbc_mic( xca )
                    yca = pbc_mic( yca )
                    zca = pbc_mic( zca )

                    xdb = pbc_mic( xdb )
                    ydb = pbc_mic( ydb )
                    zdb = pbc_mic( zdb )
                 endif

C-----------------------------------------------------------RL    ----------------------

                 dr = dedphi/rcb
                 drtr = dr/rt2
                 drur = dr/ru2
                 dedxt =  drtr * (yt*zcb - ycb*zt)
                 dedyt =  drtr * (zt*xcb - zcb*xt)
                 dedzt =  drtr * (xt*ycb - xcb*yt)
                 dedxu = -drur * (yu*zcb - ycb*zu)
                 dedyu = -drur * (zu*xcb - zcb*xu)
                 dedzu = -drur * (xu*ycb - xcb*yu)    
                 
C     compute derivative components for this interaction
                 dedxa = zcb*dedyt - ycb*dedzt
                 dedya = xcb*dedzt - zcb*dedxt
                 dedza = ycb*dedxt - xcb*dedyt
                 dedxb = yca*dedzt - zca*dedyt + zdc*dedyu - ydc*dedzu
                 dedyb = zca*dedxt - xca*dedzt + xdc*dedzu - zdc*dedxu
                 dedzb = xca*dedyt - yca*dedxt + ydc*dedxu - xdc*dedyu
                 dedxc = zba*dedyt - yba*dedzt + ydb*dedzu - zdb*dedyu
                 dedyc = xba*dedzt - zba*dedxt + zdb*dedxu - xdb*dedzu
                 dedzc = yba*dedxt - xba*dedyt + xdb*dedyu - ydb*dedxu
                 dedxd = zcb*dedyu - ycb*dedzu
                 dedyd = xcb*dedzu - zcb*dedxu
                 dedzd = ycb*dedxu - xcb*dedyu

C     increment the overall energy term and derivatives

                 ener_phi = ener_phi + e_phi !total energy of phi>0 
                 
                 deg(ixa) = deg(ixa) + dedxa
                 deg(iya) = deg(iya) + dedya
                 deg(iza) = deg(iza) + dedza
                 deg(ixb) = deg(ixb) + dedxb
                 deg(iyb) = deg(iyb) + dedyb
                 deg(izb) = deg(izb) + dedzb
                 deg(ixc) = deg(ixc) + dedxc
                 deg(iyc) = deg(iyc) + dedyc
                 deg(izc) = deg(izc) + dedzc
                 deg(ixd) = deg(ixd) + dedxd
                 deg(iyd) = deg(iyd) + dedyd
                 deg(izd) = deg(izd) + dedzd

              endif
           endif
c     enddo  !! loop j
        endif 
      enddo
      
      f(1:natom3) = -deg(1:natom3)

      return
      end subroutine ephipvha 

c     --------------------------------------------------------------------
      subroutine epsipvha(x,f,ener_psi,NATOM) 

C     This subroutine is used to calculate Phi positive penalty energy 
C     term E=k*(phi-phi0)**2, and the cooresponding force. 
C     if -180 < phi < 0, phi0 = phi, E=0; else, phi0=0, E=k*phi**2 

      implicit none
      
      real*8 pbc_mic

      integer MAXPRE,MAXNAT,MAXXC,NATOM,MAXPAI
      parameter (MAXPRE = 1500)  !! maximum number of residus
      parameter (MAXNAT = MAXPRE*6) !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT) !! maximum number of cart coord
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2) !! max number of nonbonded-pairs 
      
      real*8 force_k, radian, rad2, rad4
      parameter (force_k = 7.6d0) !10*0.76d0) ! scale 10 from OPEP3.0 
      parameter (radian = 57.29577951308232088d0) 
      parameter (rad2 = radian*radian)
      parameter (rad4 = rad2*rad2)

      common/textt/text2,text3,text4
      common/nnumres/numres,Id_atom

!!      common/propens/ialpha(MAXNAT),ibeta(MAXNAT),icoeff(MAXPAI),
!!     1     foal(20),walpha(20),fobe(20),wbeta(20)
      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)

      integer ialpha,ibeta,icoeff,nfrag, lenfrag,ichain 
      real*8  foal,walpha,fobe,wbeta


      integer i,i3 
      integer Id_atom(MAXNAT), numres(MAXNAT) !Id of atom and residue
      integer ixa,iya,iza,ixb,iyb,izb,ixc,iyc,izc,ixd,iyd,izd
      real*8  x,f,deg           ! deg: first derivative of psi>0 energy term 
      dimension x(MAXXC), f(MAXXC), deg(MAXXC) 
      real*8 xa,ya,za,xb,yb,zb,xc,yc,zc,xd,yd,zd
      real*8 xba,yba,zba,xcb,ycb,zcb,xdc,ydc,zdc
      real*8 xca,yca,zca,xdb,ydb,zdb
      real*8 xt,yt,zt,dot_prq,rcb,rprq
      real*8 xu,yu,zu,xtu,ytu,ztu,rt2,ru2,rtru
      real*8 psi_lower,psi_upper,psi,sin_psi,cos_psi,psi0  
      real*8 dt,dt2,e_psi, ener_psi,dedpsi
      real*8 dedxt,dedyt,dedzt,dedxu,dedyu,dedzu
      real*8 dedxa,dedya,dedza,dedxb,dedyb,dedzb
      real*8 dedxc,dedyc,dedzc,dedxd,dedyd,dedzd 
      real*8 t1,t2, ftot
      real*8 dr,drtr,drur,fpsi,fdpsi

      character*7 text2(MAXNAT)
      character*5 text3(MAXNAT)
      character*7 text4(MAXNAT)

      common/PBC_R/periodicBC,CM
      logical periodicBC,CM

      integer natom3
      natom3 = natom*3
      

C     zero out the restraint energy term and first derivatives
      ener_psi = 0.0d0
      deg(1:natom3) = 0.0d0
      
      psi_lower = -60.0D0
      psi_upper = 160.0d0 
      

      do i = 1, NATOM-5

        if ( text3(i).eq.'  CA ' .and. text4(i).ne. ' GLY ') then
           if (ichain(i-2) .eq. ichain(i+4)) then 
              
              i3 = i*3

C     The x, y, and z coordinates for C1, N2, C_alpha, C2 are the following: 
C     The x, y, and z coordinates for N1
              ixa = i3 - 8
              iya = i3 - 7
              iza = i3 - 6
              xa = x(ixa)
              ya = x(iya)
              za = x(iza)
              
C     The x, y, and z coordinates for C_alpha 
              ixb = i3 - 2
              iyb = i3 - 1 
              izb = i3 
              xb = x(ixb) 
              yb = x(iyb)
              zb = x(izb)
              
C     The x, y, and z coordinates for C(O)
              ixc = i3 + 7
              iyc = i3 + 8 
              izc = i3 + 9 
              xc = x(ixc)
              yc = x(iyc)
              zc = x(izc)
C     The x, y, and z coordinates for N2 
              ixd = i3 + 13
              iyd = i3 + 14 
              izd = i3 + 15
              xd = x(ixd)
              yd = x(iyd)
              zd = x(izd)
C     The x, y, z components of a vector from one atom to another atom are:
              xba = xb - xa     !vector p from C1 to N2
              yba = yb - ya
              zba = zb - za
              xcb = xc - xb     !vector r from N2 to C_alpha 
              ycb = yc - yb
              zcb = zc - zb
              xdc = xd - xc     !vector q from C_alpha to C2
              ydc = yd - yc
              zdc = zd - zc

C-----------------------------------------------------------RL    ----------------------
              
              if(periodicBC)then
                 xba = pbc_mic( xba )
                 yba = pbc_mic( yba )
                 zba = pbc_mic( zba )

                 xcb = pbc_mic( xcb )
                 ycb = pbc_mic( ycb )
                 zcb = pbc_mic( zcb )
                 
                 xdc = pbc_mic( xdc )
                 ydc = pbc_mic( ydc )
                 zdc = pbc_mic( zdc )
              endif

C-----------------------------------------------------------RL    ----------------------

C     cross product of p and r (pxr)
              xt = yba*zcb - ycb*zba
              yt = zba*xcb - zcb*xba
              zt = xba*ycb - xcb*yba
C     Vector product of r and q (rxq)
              xu = ycb*zdc - ydc*zcb
              yu = zcb*xdc - zdc*xcb
              zu = xcb*ydc - xdc*ycb
C     Vector product of (pxr)x(rxq)
              xtu = yt*zu - yu*zt
              ytu = zt*xu - zu*xt
              ztu = xt*yu - xu*yt
C     Calculating |pxr|**2
              rt2 = xt*xt + yt*yt + zt*zt
C     Calculating |rxq|**2
              ru2 = xu*xu + yu*yu + zu*zu
              rtru = sqrt(rt2 * ru2)
C     Calculating (pxr,rxq)
              dot_prq = xt*xu + yt*yu + zt*zu
              if (rtru .ne. 0.0d0) then 
               rcb = sqrt(xcb*xcb + ycb*ycb + zcb*zcb)
               cos_psi = dot_prq / rtru
               cos_psi = min(1.0d0,max(-1.0d0,cos_psi)) 
               rprq = xcb*xtu + ycb*ytu + zcb*ztu       
               sin_psi = rprq / (rcb*rtru)
C     calculating psi 
               psi = dacos(cos_psi) * radian 
               if (sin_psi .lt. 0.0d0) psi = -psi
               if ((psi .gt. psi_lower) .and. (psi .lt. psi_upper)) then
                  psi0 = psi
               else if(psi.gt.psi_lower.and.psi_lower.gt.psi_upper) then
                  psi0 = psi
               else if(psi.lt.psi_upper.and.psi_lower.gt.psi_upper) then
                  psi0 = psi
               else
                    t1 = psi - psi_lower
                    t2 = psi - psi_upper
                    if (t1 .gt. 180.0d0) then
                       t1 = t1 - 360.0d0
                    else if (t1 .lt. -180.0d0) then
                       t1 = t1 + 360.0d0
                    end if
                    if (t2 .gt. 180.0d0) then
                       t2 = t2 - 360.0d0
                    else if (t2 .lt. -180.0d0) then
                       t2 = t2 + 360.0d0
                    end if
                    if (abs(t1) .lt. abs(t2)) then
                       psi0 = psi_lower
                    else
                       psi0 = psi_upper
                    end if
                 endif
                 dt = psi - psi0
                 if (dt .gt. 180.0d0) then
                    dt = dt - 360.0d0
                 else if (dt .lt. -180.0d0) then
                    dt = dt + 360.0d0
                 end if
                 
C     Using E(psi) = k * (psi-psi0)**2
                 dt2 = dt * dt
c     e_psi = force_k * dt2 !in degrees
                 fpsi = force_k / (rad2)
                 fdpsi = fpsi * radian
                 e_psi = fpsi * dt2 !in radian
                 dedpsi = 2.0d0 * fdpsi * dt
                 
C     chain rule terms for first derivative components
C     x,y,z component of vector from C1 to C_alpha  
                 xca = xc - xa
                 yca = yc - ya
                 zca = zc - za
C     x,y,z component of vector from C2 to N2 
                 xdb = xd - xb
                 ydb = yd - yb
                 zdb = zd - zb

C-----------------------------------------------------------RL    ----------------------

                 if(periodicBC)then
                    xca = pbc_mic( xca )
                    yca = pbc_mic( yca )
                    zca = pbc_mic( zca )

                    xdb = pbc_mic( xdb )
                    ydb = pbc_mic( ydb )
                    zdb = pbc_mic( zdb )
                 endif

C-----------------------------------------------------------RL    ----------------------


                 dr = dedpsi/rcb
                 drtr = dr/rt2
                 drur = dr/ru2
                 dedxt =  drtr * (yt*zcb - ycb*zt)
                 dedyt =  drtr * (zt*xcb - zcb*xt)
                 dedzt =  drtr * (xt*ycb - xcb*yt)
                 dedxu = -drur * (yu*zcb - ycb*zu)
                 dedyu = -drur * (zu*xcb - zcb*xu)
                 dedzu = -drur * (xu*ycb - xcb*yu)    
                 
C     compute derivative components for this interaction
                 dedxa = zcb*dedyt - ycb*dedzt
                 dedya = xcb*dedzt - zcb*dedxt
                 dedza = ycb*dedxt - xcb*dedyt
                 dedxb = yca*dedzt - zca*dedyt + zdc*dedyu - ydc*dedzu
                 dedyb = zca*dedxt - xca*dedzt + xdc*dedzu - zdc*dedxu
                 dedzb = xca*dedyt - yca*dedxt + ydc*dedxu - xdc*dedyu
                 dedxc = zba*dedyt - yba*dedzt + ydb*dedzu - zdb*dedyu
                 dedyc = xba*dedzt - zba*dedxt + zdb*dedxu - xdb*dedzu
                 dedzc = yba*dedxt - xba*dedyt + xdb*dedyu - ydb*dedxu
                 dedxd = zcb*dedyu - ycb*dedzu
                 dedyd = xcb*dedzu - zcb*dedxu
                 dedzd = ycb*dedxu - xcb*dedyu

C     increment the overall energy term and derivatives

                 ener_psi = ener_psi + e_psi !total energy of psi>0 
                 
                 deg(ixa) = deg(ixa) + dedxa
                 deg(iya) = deg(iya) + dedya
                 deg(iza) = deg(iza) + dedza
                 deg(ixb) = deg(ixb) + dedxb
                 deg(iyb) = deg(iyb) + dedyb
                 deg(izb) = deg(izb) + dedzb
                 deg(ixc) = deg(ixc) + dedxc
                 deg(iyc) = deg(iyc) + dedyc
                 deg(izc) = deg(izc) + dedzc
                 deg(ixd) = deg(ixd) + dedxd
                 deg(iyd) = deg(iyd) + dedyd
                 deg(izd) = deg(izd) + dedzd

              endif
           endif
c     enddo  !! loop j 
        endif 
      enddo
      ftot = 0.0d0
      f(1:natom3) = f(1:natom3) - deg(1:natom3)

      return
      end subroutine epsipvha 
c----------------------------------------------------



C=========================================================================
C=======================      writing the pdb file       =================
C=======================       with center of mass       =================       
C=======================         inside the box          =================
C=========================================================================


      subroutine writeCM(NATOM,X)

      implicit none

      integer MAXPRE,MAXNAT,MAXPAI,MAXXC,MAXTTY
      parameter (MAXPRE = 1500)    !! maximum number of residus
      parameter (MAXNAT = MAXPRE*6)  !! maximum number of atoms
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2)!! max number of nonbonded-pairs
      parameter (MAXXC = 3*MAXNAT)  !! maximum number of cart coord
      parameter (MAXTTY = 50000)       !! maximum number of residue name types 

      integer NATOM, ii, jj, chain_length
      integer a,b, ll
      
      real*8 AMASS_2(MAXNAT)
      real*8 x(MAXXC)
      real*8 xx1(MAXNAT)
      real*8 yy1(MAXNAT)
      real*8 zz1(MAXNAT)

      COMMON/MISC2/AMASS(MAXNAT),IAC(MAXNAT),NNO(MAXTTY)
      double precision amass
      integer iac, nno
  
      common/pbcBL/box_length, inv_box_length
      real*8 box_length, inv_box_length


!!      common/propens/ialpha(MAXNAT),ibeta(MAXNAT),icoeff(MAXPAI),
!!     1     foal(20),walpha(20),fobe(20),wbeta(20)
      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)

      integer ialpha,ibeta,icoeff,nfrag, lenfrag,ichain
      real*8  foal,walpha,fobe,wbeta


      real*8  cm1, cm2, cm3, total_mass
      dimension cm1(MAXPRE),cm2(MAXPRE),cm3(MAXPRE)


      ll = 0

      xx1 = x(1:3*NATOM:3)
      yy1 = x(2:3*NATOM:3)
      zz1 = x(3:3*NATOM:3)
  
      AMASS_2(1:NATOM) = 1.0d0/AMASS(1:NATOM)

      do ii = 1, nfrag
        chain_length = lenfrag(ii)
        total_mass = 0.0d0
        cm1(ii) = 0.0d0
        cm2(ii) = 0.0d0
        cm3(ii) = 0.0d0

        do jj = 1, chain_length
          total_mass = total_mass + AMASS_2(jj+ll)
          cm1(ii)=cm1(ii)+(AMASS_2(jj+ll)*xx1(jj+ll))
          cm2(ii)=cm2(ii)+(AMASS_2(jj+ll)*yy1(jj+ll))
          cm3(ii)=cm3(ii)+(AMASS_2(jj+ll)*zz1(jj+ll))
        end do 

        a = ll + 1
        b = ll + lenfrag(ii)
        cm1(ii) = cm1(ii) / total_mass
        cm2(ii) = cm2(ii) / total_mass
        cm3(ii) = cm3(ii) / total_mass
        xx1(a:b)=xx1(a:b)-box_length*dnint(cm1(ii)*inv_box_length)
        yy1(a:b)=yy1(a:b)-box_length*dnint(cm2(ii)*inv_box_length)
        zz1(a:b)=zz1(a:b)-box_length*dnint(cm3(ii)*inv_box_length)

        ll = ll + chain_length
      end do

      x(1:3*NATOM:3) = xx1
      x(2:3*NATOM:3) = yy1
      x(3:3*NATOM:3) = zz1
    
      return
 
      end subroutine writeCM

      endmodule calcforces
