      module RNAnb
        double precision, allocatable, dimension(:,:) :: nbcoef,nbct2
        integer, allocatable, dimension(:,:) :: nbscore
        integer :: Nrests
        integer, allocatable, dimension(:) :: resti, restj
        double precision, allocatable, dimension(:) :: restlens
        save
      end module RNAnb
      module rnabase
      integer, allocatable, dimension(:) :: blist, btype
      endmodule rnabase

      SUBROUTINE INITIALISE_RNA(P_B_C,BoxL,CofM,NATOM_CHECK,
     &                              XFORT,AMASSES,
     &                              ATOMIC_TYPE,
     &                              a_scaling_factor,
     &                              use_qbug_)
C
C   1.READ THE TOPOLOGY FILE (INTERNAL COORDINATES,
C     PARAMETERS OF THE OPEP FUNCTION) AND THE STARTING
C     PDB FILE: (UNIT 14).
C
C   2.READ THE PARAMETERS FOR THE SIDE-CHAIN SIDE-CHAIN INTERACTIONS
C     (UNIT 28).
C
C   3.COMPUTE ENERGY and FORCES (NO CUTOFF FOR THE NONBONDED-INTERACTIONS. 
C
C     THIS PROGRAM WAS WRITTEN BY P. DERREUMAUX while at IBPC, UPR 9080
C     CNRS, PARIS, FRANCE.  DECEMBER 1998
C
      use RNAnb
      use fileio
      use rnabase

      parameter (MAXPRE = 1500)    !! maximum number of residus 
      parameter (MAXNAT = MAXPRE*6)  !! maximum number of atoms
      parameter (MAXXC = 3*MAXNAT)  !! maximum number of cart coord 
      parameter (MAXPNB = 3*MAXPRE*MAXPRE)!! max number of SC-SC interactions 
      parameter (MAXBO  = MAXNAT)  !! maximum number of bonds
      parameter (MAXTH = MAXNAT*3)  !! maximum number of bond angles 
      parameter (MAXPHI = MAXNAT*4)  !! maximum number of torsional angles
      parameter (MAXTTY = 50000)       !! maximum number of residue name types 
      parameter (MAXPAI = MAXNAT*(MAXNAT+1)/2)!! max number of nonbonded-pairs 

      implicit double precision (a-h,o-z)
      double precision :: xfort(3*NATOM_CHECK), amasses(NATOM_CHECK)
      character*5  ATOMIC_TYPE(NATOM_CHECK)

      COMMON/MISC1/NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $             NPHIA,NNB,NTYPES,
     $             MBONA,MTHETA,MPHIA
      integer NATOM,NRES,NBONH,NBONA,NTHETH,NTHETA,NPHIH,natom3,
     $             NPHIA,NNB,NTYPES,MBONA,MTHETA,MPHIA
      COMMON/NBPARA/CUT,SCNB,SCEE,IDIEL,DIELC

      COMMON/ENER1/IB(MAXBO),JB(MAXBO),ICB(MAXBO),IBH(MAXBO),JBH(MAXBO),
     $             ICBH(MAXBO)
      COMMON/ENER2/IT(MAXTH),JT(MAXTH),KT(MAXTH),ICT(MAXTH),ITH(MAXTH),
     $             JTH(MAXTH),KTH(MAXTH),ICTH(MAXTH)
      COMMON/ENER3/IP(MAXPHI),JP(MAXPHI),KP(MAXPHI),LP(MAXPHI),
     1             ICP(MAXPHI)
      COMMON/ENER4/
     1 IPH(MAXPHI),JPH(MAXPHI),KPH(MAXPHI),LPH(MAXPHI),ICPH(MAXPHI)
      
      COMMON/PARM1/RK(MAXBO),REQ(MAXBO),TK(MAXTH),TEQ(MAXTH),
     $             PK(MAXPHI),PN(MAXPHI),
     $             PHASE(MAXPHI),CN1(MAXTTY),CN2(MAXTTY),SOLTY(60),
     $             GAMC(MAXPHI),GAMS(MAXPHI),IPN(MAXPHI),FMN(MAXPHI)
      COMMON/MISC2/AMASS(MAXNAT),IAC(MAXNAT),NNO(MAXTTY)
      double precision amass
      integer iac, nno

      common/scalingfactor/scaling_factor
      common/charge/cg,k1
!-------------------------------------------------------------------------------
      common/PBC_R/periodicBC,CM
!-------------------------------------------------------------------------------

C      common/texte/header,text
      common/texte/header


      COMMON/REWARD/ EHHB1
      COMMON/PROPE/ RESP(MAXPRE)
      COMMON/PRMLIM/NUMBND,NUMANG,NPTRA,NPHB,NIMPRP
      common/pos/x_natv(maxxc)
c      common/forcek/force_const,rmsd
      common/textt/text2,text3,text4
      common/nnumres/numres,Id_atom

      common/frags/nfrag,lenfrag(MAXPRE),ichain(MAXNAT)

      integer nfrag,lenfrag,ichain 

      common/scor/score(272),score_RNA(35)
      common/JANV06/NHB,ref_NHB,NHBH,NHBB

      common/alpm/alpam, alpbm, bcoef
      double precision alpam(4,4), alpbm(4,4)
      integer bcoef(4,4)

      logical qbug
      common/debug/qbug
      logical use_qbug_
C---------------------------------------------------------------------	  
      logical P_B_C,CofM
      real*8 BoxL
C---------------------------------------------------------------------	  

      REAL*8 IDIEL
      DIMENSION X(MAXXC),CG(MAXNAT)

      character*7 text2(MAXNAT)
      character*5 text3(MAXNAT)
      character*7 text4(MAXNAT)
      integer     numres(MAXNAT),Id_atom(MAXNAT)
      integer  ref_NHB

      CHARACTER*3 RESP 

      integer*8 bn, bt

      real*8 score_temp

      common/cacascsc/ct0lj(maxpnb),ct2lj(maxpnb)

      common/cutoffs/rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $               rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $               rcut2_4b_out, rcut2_4b_in,
     $               rcut2_lj_out, rcut2_lj_in

      real*8 box_length, inv_box_length

      common/pbcBL/box_length, inv_box_length

      character(50) dummy

      integer i, j

      logical fileexists

C________________________________________________________________________
      character*30 path_for_inits
      logical      single_conf_init, periodicBC,CM
      periodicBC = P_B_C
      CM = CofM
      write(*,*) 'PBC and CM are : ',P_B_C, CofM
C________________________________________________________________________

      qbug = use_qbug_

C --- SET THE PREFACTOR FOR SCALING THE POTENTIAL - ESSENTIAL FOR MD
      scaling_factor = a_scaling_factor !!3.2 for MD with alpha and
c      beta OPEP propensities 

C --- SET SOME PARAMETERS
      SCNB = 80.0      !! divide the 1-4 VDW interactions by 8.0
      SCEE = 80.0      !! divide the 1-4 ELEC interactions by 2.0
      DIELC = 1.0     !! 2.0 dielectric constant epsilon = 2r
      IDIEL = 0.0    !! ...............................
      CUT = 100.0      !! NO CUTOFF
      NHB = 13

C--   save data for optimization
C      OPEN(UNIT=56,FILE="proteinA-opt.dat",status="unknown")
c      OPEN(UNIT=56,FILE="Ab42-opt.dat",status="unknown")


C---  read TOPOLOGY file
      nf=21
C     This was the original configuration
      OPEN(UNIT=nf,FILE="parametres.top",status="unknown")
      CALL RDTOP(nf,CG)
      CLOSE(UNIT=nf)
 

C---  read INPUT PDB file
      CALL init_remd(path_for_inits,single_conf_init)
      if(.not. single_conf_init)  then 
         nf=41
         OPEN(UNIT=nf,FILE=path_for_inits,status="unknown")
         CALL RDPDB(nf,X,text2,Id_atom,text3,text4,numres) 
         close(nf)
      else  
         nf=14
         OPEN(UNIT=nf,FILE="conf_initiale_RNA.pdb",status="old")
         CALL RDPDB(nf,X,text2,Id_atom,text3,text4,numres) 
         close(nf)
      endif



c---  NEW JANV05
C---- Set-up the vector associating each atom with a fragment of the protein
C----    NFRAG : number of fragments
C----    length_fragment: table containing the length of each fragment
C----    ichain : the fragment to which atom idatom belongs to

C---  read ichain file
      nf=55
      OPEN(UNIT=nf,FILE="ichain.dat",status="old")
      read(55,*)  NFRAG 
      do i=1, NFRAG
         read(55,*) id, lenfrag(i)
      enddo
      idatom = 1
      do i=1, NFRAG
         do j=1, lenfrag(i)
            ichain(idatom) = i
            idatom = idatom +1
         end do
      end do
      close(55)
c      do ikl=1,NATOM
c      enddo


C---  read the restraints
      inquire(file="restraints.dat", exist=fileexists)
      if(fileexists .eqv. .true.) then
c      if(testfile("restraints.dat") .eqv. .true.) then
        open(unit=55, file="restraints.dat", status="unknown")
        read(55,*) Nrests
        allocate(resti(Nrests))
        allocate(restj(Nrests))
        allocate(restlens(Nrests))
!       read a blank line for comments at the top of the list
        read(55, *) 
        read(55, *) (resti(I), restj(i), restlens(i),i = 1,Nrests)

c        read(55,'(2i4, f15.10)') (resti(I), restj(i), restlens(i),
c     $      i = 1,Nrests)
      else
        print *, 'No restraints file'
      endif

      do i = 1, Nrests
        print *, resti(i), restj(i), restlens(i)
      enddo



C---  read list of bases, for RNA
      if (.not. allocated(blist)) then
        allocate( blist(NRES))
        allocate( btype(NRES))
      endif
      open(unit=38,file="baselist.dat",status="old")
      read(38,*) (blist(i), btype(i), i =1, NRES)
      close(38)

C---  read weight file for RNA
      OPEN(UNIT=55,FILE="scale_RNA.dat",status="old")
      do ih=1,35
         read(55,'(i4,f15.10,A)') ikl, score_temp, dummy
         score_RNA(ih)=dble(score_temp)
      enddo
      close(55)

      ! NTYPES is the number of particle types, found in the .top file
      ! Currently, it's taken to be :
      ! 1: C5*  2: O5*  3: P  4: CA  5: CY
      ! 6,7: G1,2  8,9: A1,2  10: U1  11: C1
      if (.not. allocated(nbcoef)) then
        allocate( nbcoef(NTYPES, NTYPES))
        allocate( nbct2(NTYPES, NTYPES))
        allocate( nbscore(NTYPES, NTYPES))
      endif
      nbcoef = 1.0
      nbct2 = 3.5
      nbscore = 1
      ! P-P interactions
      nbcoef(3,3) = 1.0
      nbct2(3,3) = 5.0
      nbscore(3,3) = 7

      do i = 1, NTYPES
        do j = 1, NTYPES
          nbcoef(i,j) = nbcoef(i,j)*score_RNA(nbscore(i,j))
        enddo
      enddo

      alpam = 2
      alpbm = 2
      bcoef = 35

      !                G   A   C  U
      bcoef(1,:) = (/ 34, 20, 19, 21 /)
      bcoef(2,:) = (/ 20, 32, 22, 18 /)
      bcoef(3,:) = (/ 19, 22, 33, 27 /)
      bcoef(4,:) = (/ 21, 18, 27, 35 /)

      !                G     A     C     U
      alpam(1,:) = (/ 2.00, 2.88, 2.18, 1.90 /)
      alpam(2,:) = (/ 2.53, 2.00, 1.75, 2.18 /)
      alpam(3,:) = (/ 2.53, 2.54, 2.00, 2.18 /)
      alpam(4,:) = (/ 2.35, 2.88, 2.18, 2.00 /)

      alpbm = transpose(alpam)

C---------------------------------------------------------------

      if (natom .ne. natom_check) then
        write(*,*) 'ERROR : Number of atom does not match input file'
        stop
      endif

      do i=1, 3*natom_check
        xfort(i) = x(i)
      enddo

      do i=1, natom_check
        amasses(i) = amass(i)
        atomic_type(i) = text3(i)
      end do 

      open(57, file="cutoffs.dat")
      read(57, *)  rcut2_caca_scsc_out, rcut2_caca_scsc_in,
     $             rcut2_hb_mcmc_out, rcut2_hb_mcmc_in,
     $             rcut2_4b_out, rcut2_4b_in,
     $             rcut2_lj_out, rcut2_lj_in
      close(57)

c     We copy the box length and define the inverse box-length
      box_length = BoxL
      inv_box_length = 1.0d0 / box_length

      return
      end
      
