      SUBROUTINE GTHOMSON(X,V,ETHOMSON,GTEST)
      USE commons
      IMPLICIT NONE
      LOGICAL GTEST
      INTEGER J1, J2, J3, J4
      DOUBLE PRECISION X(*), DIST, V(*), ETHOMSON
      DOUBLE PRECISION :: TMPCOORDS(3*NATOMS), DR(3), Gradient11(3), Gradient12(3), Gradient21(3), Gradient22(3) 

      TMPCOORDS(1:3*NATOMS) = X(1:3*NATOMS)

      CALL GTHOMSONANGTOC(TMPCOORDS,NATOMS)      

      ETHOMSON=0.0D0
      V(1:3*NATOMS)=0.0D0

      DO J1=1,NATOMS-1
         J3=3*J1

         IF (GTEST) THEN
            IF ( GTHOMMET .EQ. 1) THEN
               CALL GRADMETRICCYLINDER (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( GTHOMMET .EQ. 2) THEN
               CALL GRADMETRICCATENOID (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
               CALL GRADMETRICUNDULOID (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( GTHOMMET .EQ. 5 ) THEN
               CALL GRADMETRICSPHERE (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ELSEIF ( GTHOMMET .EQ. 6 ) THEN
               CALL GRADMETRICMOBIUS (X(2*J1-1:2*J1), Gradient11, Gradient12)
            ENDIF
         ENDIF

         DO J2=J1+1,NATOMS
            J4=3*J2
            DR(1) = TMPCOORDS(J3-2)-TMPCOORDS(J4-2)
            DR(2) = TMPCOORDS(J3-1)-TMPCOORDS(J4-1)
            DR(3) = TMPCOORDS(J3  )-TMPCOORDS(J4  )
            DIST  = SQRT(DOT_PRODUCT(DR, DR))

            IF (GTHOMPOT .EQ. 1) THEN
               ETHOMSON = ETHOMSON + 1/DIST ! Coulomb
            ELSEIF (GTHOMPOT .EQ. 2) THEN 
               ETHOMSON = ETHOMSON + 1/DIST**3 ! 1/R^3
            ELSEIF (GTHOMPOT .EQ. 3) THEN
               ETHOMSON = ETHOMSON + 1/DIST*EXP(-1.0D0*DIST/GThomsonSigma)                !Yukawa
            ELSEIF (GTHOMPOT .EQ. 4) THEN
               ETHOMSON = ETHOMSON + (GThomsonSigma/DIST)**12 - (GThomsonSigma/DIST)**6  ! LJ
            ELSEIF (GTHOMPOT .EQ. 5) THEN
               ETHOMSON = ETHOMSON + (GThomsonSigma/DIST)**12                            !Repulsive LJ 
            ELSEIF (GTHOMPOT .EQ. 6) THEN
               ETHOMSON = ETHOMSON + (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST)))**2 -1.0D0 ! Morse
            ENDIF


            IF (GTEST) THEN

               IF (GTHOMPOT .EQ. 1) THEN
                  V(2*J1-1) = V(2*J1-1) - 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient12)               
               ELSEIF (GTHOMPOT .EQ. 2) THEN 
                  V(2*J1-1) = V(2*J1-1) - 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient12)               
               ELSEIF (GTHOMPOT .EQ. 3) THEN
                  V(2*J1-1) = V(2*J1-1) - (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient12)               
               ELSEIF (GTHOMPOT .EQ. 4) THEN
                  V(2*J1-1) = V(2*J1-1) - ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8)) &
                       * DOT_PRODUCT(DR,Gradient11)
                  V(2*J1  ) = V(2*J1  ) - ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8)) & 
                       * DOT_PRODUCT(DR,Gradient12)
               ELSEIF (GTHOMPOT .EQ. 5) THEN
                  V(2*J1-1) = V(2*J1-1) - (12.0D0*GThomsonSigma**12/DIST**14)* DOT_PRODUCT(DR,Gradient11) ! Repulsive LJ
                  V(2*J1  ) = V(2*J1  ) - (12.0D0*GThomsonSigma**12/DIST**14)* DOT_PRODUCT(DR,Gradient12) ! Replusive LJ
               ELSEIF (GTHOMPOT .EQ. 6) THEN
                  V(2*J1-1) = V(2*J1-1) + 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                       * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient11) ! Morse
                  V(2*J1  ) = V(2*J1  ) + 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                       * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient12) ! Morse
               ENDIF
 
               IF ( GTHOMMET .EQ. 1) THEN
                  CALL GRADMETRICCYLINDER (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( GTHOMMET .EQ. 2) THEN
                  CALL GRADMETRICCATENOID (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
                  CALL GRADMETRICUNDULOID (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( GTHOMMET .EQ. 5 ) THEN
                  CALL GRADMETRICSPHERE (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ELSEIF ( GTHOMMET .EQ. 6 ) THEN
                  CALL GRADMETRICMOBIUS (X(2*J2-1:2*J2), Gradient21, Gradient22)
               ENDIF

               IF (GTHOMPOT .EQ. 1) THEN
                  V(2*J2-1) = V(2*J2-1) + 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient21)               
                  V(2*J2  ) = V(2*J2  ) + 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 2) THEN 
                  V(2*J2-1) = V(2*J2-1) + 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient21)               
                  V(2*J2  ) = V(2*J2  ) + 3.0D0/DIST**5 * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 3) THEN
                  V(2*J2-1) = V(2*J2-1) + (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient21)               
                  V(2*J2  ) = V(2*J2  ) + (1.0D0/DIST**3 + 1.0D0/GThomsonSigma/DIST**2) * EXP(-1.0D0*DIST/GThomsonSigma) &
                       * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 4) THEN
                  V(2*J2-1) = V(2*J2-1) + ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8))&
                       * DOT_PRODUCT(DR,Gradient21)
                  V(2*J2  ) = V(2*J2  ) + ((12.0D0*GThomsonSigma**12/DIST**14) - (6.0D0*GThomsonSigma**6/DIST**8))&
                       * DOT_PRODUCT(DR,Gradient22)
               ELSEIF (GTHOMPOT .EQ. 5) THEN
                  V(2*J2-1) = V(2*J2-1) + (12.0D0*GThomsonSigma**12/DIST**14)* DOT_PRODUCT(DR,Gradient21) ! Repulsive LJ
                  V(2*J2  ) = V(2*J2  ) + (12.0D0*GThomsonSigma**12/DIST**14)* DOT_PRODUCT(DR,Gradient22) ! Repulsive LJ
               ELSEIF (GTHOMPOT .EQ. 6) THEN
                  V(2*J2-1) = V(2*J2-1) - 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                       * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient21)
                  V(2*J2  ) = V(2*J2  ) - 2.0D0 * (1.0D0 - EXP(GThomsonRho*(GThomsonSigma-DIST))) * EXP(GThomsonRho*(GThomsonSigma-DIST)) &
                       * GThomsonRho / DIST * DOT_PRODUCT(DR,Gradient22) 
               ENDIF
               !PRINT *, 1.0D0/DIST**3 * DOT_PRODUCT(DR,Gradient2), (1/DIST2 - 1/DIST)/0.00001

            ENDIF

         ENDDO
      ENDDO

      RETURN
    END SUBROUTINE GTHOMSON

!----------------------------------------------------------------
!  Subroutine to convert Cartesians to theta, phi.

      SUBROUTINE GTHOMSONCTOANG(COORDS,P,NATOMS,MYUNIT)
      USE COMMONS, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET,   GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      INTEGER NATOMS, J1, MYUNIT
      DOUBLE PRECISION COORDS(3*NATOMS), P(3*NATOMS), DIST
      DOUBLE PRECISION :: pi, phi, u
      DOUBLE PRECISION, PARAMETER :: HALFPI=1.570796327D0
      DOUBLE PRECISION RADIUS

      IF (GTHOMMET .EQ. 5) THEN
         RADIUS = GTHOMSONZ
      ENDIF

      pi = 4.0D0*ATAN(1.0D0)

      DO J1=1,NATOMS

         IF ( (COORDS(3*J1-2) .GE. 0.0D0) .AND. (COORDS(3*J1-1) .GE. 0.0D0) ) THEN
            IF (COORDS(3*J1-2) .EQ. 0.0D0) THEN
               P(2*J1-1) = HALFPI
            ELSE IF (COORDS(3*J1-1) .EQ. 0.0D0) THEN
               P(2*J1-1) = 0.0D0
            ELSE
               P(2*J1-1) = ATAN(COORDS(3*J1-1)/COORDS(3*J1-2))
            ENDIF
         ELSEIF ( (COORDS(3*J1-2) < 0.0D0) .AND. (COORDS(3*J1-1) .GE. 0.0D0) ) THEN
            IF (COORDS(3*J1-1) .EQ. 0.0D0) THEN
               P(2*J1-1) = 2*HALFPI
            ELSE
               P(2*J1-1) = 2*HALFPI - ATAN(-1.0D0*COORDS(3*J1-1)/COORDS(3*J1-2))
            ENDIF
         ELSEIF ( (COORDS(3*J1-2) < 0.0D0) .AND. (COORDS(3*J1-1) < 0.0D0) ) THEN
               P(2*J1-1) = 2*HALFPI + ATAN(COORDS(3*J1-1)/COORDS(3*J1-2))
         ELSEIF ( (COORDS(3*J1-2) .GE. 0.0D0) .AND. (COORDS(3*J1-1) < 0.0D0) ) THEN
            IF (COORDS(3*J1-2) .EQ. 0.0D0) THEN
               P(2*J1-1) = 3*HALFPI
            ELSE
               P(2*J1-1) = 4*HALFPI - ATAN(-COORDS(3*J1-1)/COORDS(3*J1-2))
            ENDIF
         ENDIF

         IF ( (GTHOMMET .EQ. 1) .OR. (GTHOMMET .EQ. 2) ) THEN

            IF (COORDS(3*J1) > GThomsonZ) COORDS(3*J1) = GThomsonZ
            IF (COORDS(3*J1) <-GThomsonZ) COORDS(3*J1) = -GThomsonZ
            P(2*J1) = ACOS(COORDS(3*J1)/GThomsonZ)

         ELSE IF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) )  THEN

            IF ( COS(P(2*J1-1)) .EQ. 0.0D0 ) THEN
               u = ASIN( (COORDS(3*J1-1)**2- GTn)/GTm )/GTmu
            ELSE
               u = ASIN( (COORDS(3*J1-2)/COS(P(2*J1-1)))**2/GTm - GTn/GTm )/GTmu
            ENDIF

            IF ( GTHOMMET .EQ. 3 ) THEN
               IF (COORDS(3*J1) .GE. 0.0D0) u = u+2*pi/GTmu
               IF (COORDS(3*J1) <    0.0D0) u = pi/GTmu-u
            ELSEIF ( GTHOMMET .EQ. 4 ) THEN
               IF (COORDS(3*J1) .GE. 0.0D0) u = pi/GTmu-u
            ENDIF

            phi = (u - GTrefU/GTmu)*GTmu/pi/GThomsonZ
            if (phi > 1.0D0) phi = 1.0D0
            if (phi <-1.0D0) phi =-1.0D0
            P(2*J1) = ACOS(phi)

         ELSE IF ( GTHOMMET .EQ. 5 )  THEN

            IF (COORDS(3*J1) > RADIUS) COORDS(3*J1) = RADIUS
            IF (COORDS(3*J1) < -RADIUS) COORDS(3*J1) = -RADIUS
            
            IF ( COORDS(3*J1) < 0.0D0 ) THEN               
               P(2*J1) = 2*HALFPI - ACOS(-COORDS(3*J1)/RADIUS)
            ELSE
               P(2*J1) = ACOS(COORDS(3*J1)/RADIUS)
            ENDIF

         ELSE IF ( GTHOMMET .EQ. 6 )  THEN
            
            IF ( ABS(SIN(P(2*J1-1)/2.0D0)) < 1.0D-6 ) THEN
               P(2*J1) = ACOS(((COORDS(3*J1-2) / COS(P(2*J1-1))) - GThomsonC)/(COS(P(2*J1-1)/2.0D0))/GThomsonZ)
            ELSE
               P(2*J1) = ACOS(COORDS(3*J1) / (SIN(P(2*J1-1)/2.0D0)) / GThomsonZ)
            ENDIF

         ENDIF

         IF ( P(2*J1-1) > 4*HALFPI ) P(2*J1-1) = P(2*J1-1) - 4*HALFPI 
         IF ( P(2*J1-1) < 0.0D0    ) P(2*J1-1) = P(2*J1-1) + 4*HALFPI 
         IF ( P(2*J1  ) > 4*HALFPI ) P(2*J1  ) = P(2*J1  ) - 4*HALFPI 
         IF ( P(2*J1  ) < 0.0D0    ) P(2*J1  ) = P(2*J1  ) + 4*HALFPI 

      ENDDO

      P(2*NATOMS+1:3*NATOMS) = 0.0D0
      RETURN
      
    END SUBROUTINE GTHOMSONCTOANG

!----------------------------------------------------------------
!  Subroutine to convert theta, phi to Cartesians.

      SUBROUTINE GTHOMSONANGTOC(P,NATOMS)
      USE COMMONS, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET, COORDS, GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      INTEGER NATOMS, J1
      DOUBLE PRECISION TMPCOORDS(3*NATOMS), P(3*NATOMS)
      DOUBLE PRECISION :: pi, Felint, Selint, u
      DOUBLE PRECISION :: ARG1, COSHARG
      DOUBLE PRECISION :: RADIUS

      IF (GTHOMMET .EQ. 5) THEN
         RADIUS = GTHOMSONZ
      ENDIF
      pi = 4.0D0*ATAN(1.0D0)

      TMPCOORDS(1:3*NATOMS) = P(1:3*NATOMS)
      DO J1=1,NATOMS
         IF ( GTHOMMET .EQ. 1) THEN
            P(3*(J1-1)+1)= GThomsonC * COS(TMPCOORDS(2*J1-1))
            P(3*(J1-1)+2)= GThomsonC * SIN(TMPCOORDS(2*J1-1))
            P(3*(J1-1)+3)= GThomsonZ * COS(TMPCOORDS(2*J1))

         ELSE IF ( GTHOMMET .EQ. 2) THEN
            COSHARG = GThomsonC * COSH(GThomsonZ/GThomsonC*COS(TMPCOORDS(2*J1)))
            P(3*(J1-1)+1)= COSHARG * COS(TMPCOORDS(2*J1-1))
            P(3*(J1-1)+2)= COSHARG * SIN(TMPCOORDS(2*J1-1))
            P(3*(J1-1)+3)= GThomsonZ * COS(TMPCOORDS(2*J1))

         ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN

            u = GTrefU/GTmu + GThomsonZ*pi/GTmu * COS(TMPCOORDS(2*J1))
            CALL EllipIntegral(Felint, Selint, (GTmu*u/2.0D0-pi/4.0D0), GTk)
            ARG1 = SQRT(GTm*SIN(GTmu*u)+GTn)
            P(3*(J1-1)+1) = ARG1 * COS(TMPCOORDS(2*J1-1))
            P(3*(J1-1)+2) = ARG1 * SIN(TMPCOORDS(2*J1-1))
            P(3*(J1-1)+3) = GTa*Felint + GTc*Selint

            IF (GTHOMMET .EQ. 3) THEN
               P(3*(J1-1)+3) = P(3*(J1-1)+3) - GTrefZ
            ENDIF

         ELSE IF ( GTHOMMET .EQ. 5) THEN

            ARG1 = RADIUS * SIN(TMPCOORDS(2*J1))
            P(3*J1-2)= ARG1 * COS(TMPCOORDS(2*J1-1))
            P(3*J1-1)= ARG1 * SIN(TMPCOORDS(2*J1-1))
            P(3*J1  )= RADIUS * COS(TMPCOORDS(2*J1))

         ELSE IF ( GTHOMMET .EQ. 6) THEN

            ARG1 = GThomsonZ * COS(TMPCOORDS(2*J1))            
            P(3*J1-2)= (GThomsonC + ARG1 * COS(TMPCOORDS(2*J1-1)/2.0D0)) * COS(TMPCOORDS(2*J1-1))
            P(3*J1-1)= (GThomsonC + ARG1 * COS(TMPCOORDS(2*J1-1)/2.0D0)) * SIN(TMPCOORDS(2*J1-1))
            P(3*J1  )= ARG1 * SIN(TMPCOORDS(2*J1-1)/2.0D0)

         ENDIF
      ENDDO

      RETURN
    END SUBROUTINE GTHOMSONANGTOC

!----------------------------------------------------------------
! take step routine      

      SUBROUTINE TAKESTEPGTHOMSON ()

      USE COMMONS, ONLY : COORDS, NATOMS, TMOVE, OMOVE, STEP, OSTEP, GTHOMMET, GTHOMPOT, GThomsonSigma
      USE ROTATIONS
      IMPLICIT NONE
      DOUBLE PRECISION P(3*NATOMS), LOCALSTEP, RANDOM, DPRAND
      DOUBLE PRECISION RMI(3,3)
      INTEGER NP, J1
      LOGICAL PERCT
      
      NP = 1
      LOCALSTEP = STEP(NP)

      IF ( GTHOMMET .EQ. 5) THEN

         DO J1 = 1, NATOMS
            RMI = rot_aa2mx(rot_small_random_aa(LOCALSTEP))
            COORDS(3*J1-2:3*J1,NP) = MATMUL(RMI(:,:),COORDS(3*J1-2:3*J1,NP))
         ENDDO

      ELSE

         CALL GTHOMSONCTOANG(COORDS,P,NATOMS,NP)
         DO J1 = 1, NATOMS
            LOCALSTEP = 0.0D0
            IF (TMOVE(NP)) LOCALSTEP = STEP(NP)
            RANDOM            = (DPRAND() - 0.5D0)*2.0D0
            P(2*J1-1) = P(2*J1-1) + LOCALSTEP*RANDOM
            
            LOCALSTEP = 0.0D0
            IF (OMOVE(NP)) LOCALSTEP = OSTEP(NP)
            RANDOM            = (DPRAND() - 0.5D0)*2.0D0
            P(2*J1)   = P(2*J1  ) + LOCALSTEP*RANDOM            
         ENDDO
         CALL GTHOMSONANGTOC(P,NATOMS)
         COORDS(1:3*NATOMS,NP) = P(1:3*NATOMS)
      
      ENDIF

!      DO J1 = 1, NATOMS
!         LOCALSTEP = 0.0D0
!         IF (TMOVE(NP)) LOCALSTEP = STEP(NP)
!         RANDOM            = (DPRAND() - 0.5D0)*2.0D0
!         P(2*J1-1) = P(2*J1-1) + LOCALSTEP*RANDOM         
!      ENDDO      
!      CALL GTHOMSONANGTOC(P,NATOMS)
!      COORDS(1:3*NATOMS,NP) = P(1:3*NATOMS)
!      DO J1 = 1, NATOMS
!         LOCALSTEP = 0.0D0
!         IF (OMOVE(NP)) LOCALSTEP = OSTEP(NP)
!         RANDOM            = (DPRAND() - 0.5D0)*2.0D0
!         COORDS(3*J1,NP)   = COORDS(3*J1,NP) + LOCALSTEP*RANDOM          
!      ENDDO


! hk286 - 12/5/2013
      IF ( (GTHOMMET .EQ. 5) .AND. ((GTHOMPOT .EQ. 4) .OR. (GTHOMPOT .EQ. 6)) ) THEN
         CALL PERCSPHERE(COORDS(:,NP),NATOMS,1.5D0*GThomsonSigma,PERCT)
      ENDIF


    END SUBROUTINE TAKESTEPGTHOMSON

!----------------------------------------------------------------
! newrestart routine      

      SUBROUTINE NEWRESTARTGTHOMSON ()

      USE COMMONS, ONLY : COORDS, NATOMS
      IMPLICIT NONE
      DOUBLE PRECISION P(3*NATOMS), LOCALSTEP, RANDOM, DPRAND
      DOUBLE PRECISION EREAL, GRAD(3*NATOMS)
      INTEGER NP, J1
      
      PRINT *, "NEWRESTART IS CALLED"
      NP = 1
      CALL GTHOMSONCTOANG(COORDS,P,NATOMS,NP)

      DO J1 = 1, NATOMS

         LOCALSTEP = 0.5D0
         RANDOM            = (DPRAND() - 0.5D0)*2.0D0
         P(2*J1-1) = P(2*J1-1) + LOCALSTEP*RANDOM
         
         LOCALSTEP = 0.5D0
         RANDOM            = (DPRAND() - 0.5D0)*2.0D0
         P(2*J1)   = P(2*J1  ) + LOCALSTEP*RANDOM
          
      ENDDO
      
      CALL GTHOMSONANGTOC(P,NATOMS)
      CALL GTHOMSON(P,GRAD,EREAL,.FALSE.)
      COORDS(1:3*NATOMS,NP) = P(1:3*NATOMS)
      
      PRINT *, "NEWRESTART DONE"

    END SUBROUTINE NEWRESTARTGTHOMSON

!----------------------------------------------------------------
! Initialization of random coordinates
      SUBROUTINE INIGTHOMSON ()

      USE COMMONS, ONLY : NATOMS, GTHOMMET, GTHOMSONZ, GTHOMSONC2, GTHOMSONC, GTrefU, GTrefZ, GTmu, GTk, GTm, GTn, GTa, GTc
      USE ROTATIONS
      USE VEC3
      IMPLICIT NONE
      DOUBLE PRECISION P(3*NATOMS), RANDOM, DPRAND, pi, c, a, Felint, Selint
      INTEGER NP, J1
      LOGICAL :: YESNO
      character(len=10)       :: datechar,timechar,zonechar
      integer                 :: values(8),itime1
      DOUBLE PRECISION :: RADIUS, COORDS(3*NATOMS)

      IF (GTHOMMET .EQ. 5) THEN
         RADIUS = GTHOMSONZ
      ENDIF
      NP = 1

      IF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN

         pi = 4.0D0*ATAN(1.0D0)
         IF (GTHOMMET .EQ. 3) THEN
            GTrefU = 1.50D0*pi
         ELSEIF (GTHOMMET .EQ. 4) THEN
            GTrefU = 0.50D0*pi
         ENDIF
         IF (GThomsonC > GThomsonC2) THEN
            c = GThomsonC
            a = GThomsonC2
         ELSE
            c = GThomsonC2
            a = GThomsonC
         ENDIF
         GTa = a
         GTc = c
         GTmu = 2.0D0/(a+c)
         GTk = SQRT(1-(a/c)**2)
         GTm = (c**2-a**2)/2.0D0
         GTn = (c**2+a**2)/2.0D0      
      
      ENDIF
      IF (GTHOMMET .EQ. 3) THEN
         CALL EllipIntegral(Felint, Selint, (GTrefU/2.0D0-pi/4.0D0), GTk)
         GTrefZ = GTa*Felint + GTc*Selint
      ENDIF

      CALL DATE_AND_TIME(datechar,timechar,zonechar,values)
      itime1= values(7)*39 + values(8)
      CALL SDPRND(itime1+NP)

!      OPEN(UNIT = 28, FILE = 'coords')            
!      DO J1 = 1, NATOMS
!         READ(28, *) COORDS(3*J1-2:3*J1)
!      ENDDO
!      CLOSE (UNIT=28)
!      PRINT *, COORDS(1:3)
!      CALL GTHOMSONCTOANG(COORDS,P,NATOMS,1)
!      PRINT *, P(1:2)
!      CALL GTHOMSONANGTOC(P,NATOMS)
!      PRINT *, P(1:3)
     
      IF ( GTHOMMET .EQ. 5 ) THEN

         DO J1 = 1, NATOMS
            COORDS(3*J1-2:3*J1) = RADIUS * vec_random()
         ENDDO

         OPEN(UNIT = 28, FILE = 'coordsini', STATUS = 'REPLACE')            
         DO J1 = 1, NATOMS
            WRITE(28, *) COORDS(3*J1-2:3*J1)
         ENDDO
         CLOSE (UNIT=28)

      ELSE

         DO J1 = 1, NATOMS
            RANDOM  = DPRAND()*8*ATAN(1.0D0)
            P(2*J1-1) = RANDOM
            RANDOM  = DPRAND()*4*ATAN(1.0D0)
            P(2*J1  ) = RANDOM          
         ENDDO

         CALL GTHOMSONANGTOC(P,NATOMS)
         OPEN(UNIT = 28, FILE = 'coordsini', STATUS = 'REPLACE')            
         DO J1 = 1, NATOMS
            WRITE(28, *) P(3*J1-2:3*J1)
         ENDDO
         CLOSE (UNIT=28)

      ENDIF
         
    END SUBROUTINE INIGTHOMSON


!----------------------------------------------------------------
! CYLINDER     
      SUBROUTINE GRADMETRICCYLINDER (X, Gradient1, Gradient2)

      USE COMMONS, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)

      Gradient1(1) = -GThomsonC * SIN(X(1))
      Gradient1(2) =  GThomsonC * COS(X(1))
      Gradient1(3) =  0.0D0

      Gradient2(1) = 0.0D0
      Gradient2(2) = 0.0D0
      Gradient2(3) = -GThomsonZ * SIN(X(2))

      END SUBROUTINE GRADMETRICCYLINDER

!----------------------------------------------------------------
! catenoid      
      SUBROUTINE GRADMETRICCATENOID (X, Gradient1, Gradient2)

      USE COMMONS, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2), ARGHY, COSHA, SINHA, SINX2, SINX1, COSX1
      
      ARGHY = GThomsonZ/GThomsonC*COS(X(2))
      COSHA = COSH(ARGHY)
      SINHA = SINH(ARGHY)
      SINX2 = SIN(X(2))
      SINX1 = SIN(X(1))
      COSX1 = COS(X(1))
      Gradient1(1) = -GThomsonC * COSHA * SINX1
      Gradient1(2) =  GThomsonC * COSHA * COSX1
      Gradient1(3) =  0.0D0

      Gradient2(1) = -GThomsonZ * SINHA * COSX1 * SINX2
      Gradient2(2) = -GThomsonZ * SINHA * SINX1 * SINX2
      Gradient2(3) = -GThomsonZ * SINX2

    END SUBROUTINE GRADMETRICCATENOID

!----------------------------------------------------------------
! unduloid      
      SUBROUTINE GRADMETRICUNDULOID (X, Gradient1, Gradient2)

      USE COMMONS, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET,   GTrefU, GTmu, GTk, GTm, GTn, GTa, GTc
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)
      DOUBLE PRECISION :: pi, u
      DOUBLE PRECISION :: ARG1, ARG2, SINMU, CSINX2

      pi = 4.0D0*ATAN(1.0D0)

      u = GTrefU/GTmu + GThomsonZ*pi/GTmu * COS(X(2))
      
      ARG1 = SQRT(GTm*SIN(GTmu*u)+GTn)
      ARG2 = 0.5D0 / ARG1 * GTm * GTmu * COS(GTmu*u)
      SINMU = SIN(GTmu*u/2.0D0-pi/4.0D0)
      Gradient2(1) = ARG2* COS(X(1))
      Gradient2(2) = ARG2* SIN(X(1))
      Gradient2(3) = 1.0D0*(GTmu/2.0D0)*(GTa/SQRT(1-GTk**2*(SINMU)**2) + GTc*SQRT(1-GTk**2*(SINMU)**2))

      CSINX2 = GThomsonZ*pi/GTmu * SIN(X(2))
      Gradient2(1) = -Gradient2(1) *  CSINX2
      Gradient2(2) = -Gradient2(2) *  CSINX2
      Gradient2(3) = -Gradient2(3) *  CSINX2

      Gradient1(1) =-ARG1 * SIN(X(1))
      Gradient1(2) = ARG1 * COS(X(1))
      Gradient1(3) = 0.0D0


    END SUBROUTINE GRADMETRICUNDULOID

!----------------------------------------------------------------
! SPHERE
      SUBROUTINE GRADMETRICSPHERE (X, Gradient1, Gradient2)
        
      USE COMMONS, ONLY: GTHOMSONZ, GTHOMMET
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)
      DOUBLE PRECISION ARG1, ARG2, ARG3, ARG4
      DOUBLE PRECISION RADIUS
      
      IF (GTHOMMET .EQ. 5) THEN
         RADIUS = GTHOMSONZ
      ENDIF

      ARG1 = SIN(X(1))
      ARG2 = COS(X(1))
      ARG3 = SIN(X(2))
      ARG4 = COS(X(2))
      
      Gradient1(1) = -ARG3 * ARG1 * RADIUS
      Gradient1(2) =  ARG3 * ARG2 * RADIUS
      Gradient1(3) =  0.0D0

      Gradient2(1) = ARG4 * ARG2 * RADIUS
      Gradient2(2) = ARG4 * ARG1 * RADIUS
      Gradient2(3) = - ARG3 * RADIUS
      
    END SUBROUTINE GRADMETRICSPHERE


!----------------------------------------------------------------
! CYLINDER     
      SUBROUTINE GRADMETRICMOBIUS (X, Gradient1, Gradient2)

      USE COMMONS, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION Gradient1(3), Gradient2(3), X(2)
      DOUBLE PRECISION SINQ2, COSQ2, COSQ12, COSQ1, SINQ1, SINQ12
      DOUBLE PRECISION ARG1, ARG2, ARG3

      SINQ2 = SIN(X(2))
      COSQ2 = COS(X(2))
      COSQ1 = COS(X(1))
      SINQ1 = SIN(X(1))
      SINQ12 = SIN(X(1)/2.0D0)
      COSQ12 = COS(X(1)/2.0D0)
      ARG1 = GThomsonC + GThomsonZ * COSQ2 * COSQ12
      ARG2 = GThomsonZ * COSQ2 * SINQ12 / 2.0D0
      ARG3 = GThomsonZ * SINQ2 * COSQ12

      Gradient1(1) = -ARG1*SINQ1 - ARG2 * COSQ1
      Gradient1(2) =  ARG1*COSQ1 - ARG2 * SINQ1
      Gradient1(3) =  GThomsonZ * COSQ2 * COSQ12 /2.0D0

      Gradient2(1) = -ARG3 * COSQ1
      Gradient2(2) = -ARG3 * SINQ1
      Gradient2(3) = -GThomsonZ * SINQ2 * SINQ12

    END SUBROUTINE GRADMETRICMOBIUS
      

!----------------------------------------------------------------
! Check limits of the unduloids      
      SUBROUTINE FINDNGZ()

      USE COMMONS, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET
      IMPLICIT NONE
      DOUBLE PRECISION :: c, a, pi, mu, k, m, n, Felint, Selint, u
      DOUBLE PRECISION :: refZ, refU, TEMPZ, GZMIN, GZMAX, ZPOS
      LOGICAL :: TEST

      TEMPZ = GThomsonZ
      GZMAX = 1.0D0
      GZMIN = 0.0D0
      TEST = .FALSE.

      pi = 4.0D0*ATAN(1.0D0)
      IF (GTHOMMET .EQ. 3) THEN
         refU = 1.50D0*pi
      ELSEIF (GTHOMMET .EQ. 4) THEN
         refU = 0.50D0*pi
      ENDIF

      IF (GThomsonC > GThomsonC2) THEN
         c = GThomsonC
         a = GThomsonC2
      ELSE
         c = GThomsonC2
         a = GThomsonC
      ENDIF
      mu = 2.0D0/(a+c)
      k = SQRT(1-(a/c)**2)
      m = (c**2-a**2)/2.0D0
      n = (c**2+a**2)/2.0D0      

      u = refU/mu + GZMAX*pi/mu
      CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)
      ZPOS = a*Felint + c*Selint
      IF (GTHOMMET .EQ. 3) THEN
         CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
         refZ = a*Felint + c*Selint
         ZPOS = ZPOS -refZ
      ENDIF

      IF ( (ZPOS < TEMPZ) .OR. (ZPOS < 0) ) THEN
         PRINT *, "ERROR in the definition of unduloids"
         STOP
      ENDIF

      DO WHILE ( (.NOT. TEST) )
         GThomsonZ = (GZMAX + GZMIN)/2.0D0
         u    = refU/mu + GThomsonZ*pi/mu
         CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)
         ZPOS = a*Felint + c*Selint
         IF (GTHOMMET .EQ. 3) THEN
            CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
            refZ = a*Felint + c*Selint
            ZPOS = ZPOS -refZ
         ENDIF

         IF (TEMPZ > ZPOS) GZMIN = GThomsonZ
         IF (TEMPZ < ZPOS) GZMAX = GThomsonZ

         IF ( (TEMPZ - ZPOS < 0.00001) .AND. (TEMPZ - ZPOS > -0.00001) ) THEN
            TEST = .TRUE.
            !PRINT *, GThomsonZ
         ENDIF
      ENDDO 
     
    END SUBROUTINE FINDNGZ


!----------------------------------------------------------------
! Check limits of the unduloids      
      SUBROUTINE CONVERTUNDULOIDPARAMETERS(V)

      USE COMMONS, ONLY : GThomsonC, GThomsonC2, GThomsonZ, GTHOMMET
      IMPLICIT NONE
      DOUBLE PRECISION :: c, a, pi, mu, k, m, n, Felint, Selint, u
      DOUBLE PRECISION :: refZ, refU, TEMPZ, GZMIN, GZMAX, ZPOS
      DOUBLE PRECISION :: amax, amin, cmax, cmin
      DOUBLE PRECISION :: V, Volume
      LOGICAL :: TEST, TEST2


      TEMPZ = GThomsonZ
      TEST2 = .FALSE.

      pi = 4.0D0*ATAN(1.0D0)
      IF (GTHOMMET .EQ. 3) THEN
         refU = 1.50D0*pi
      ELSEIF (GTHOMMET .EQ. 4) THEN
         refU = 0.50D0*pi
      ENDIF

      IF (GThomsonC > GThomsonC2) THEN
         c = GThomsonC
         a = GThomsonC2
      ELSE
         c = GThomsonC2
         a = GThomsonC
      ENDIF
      cmax = c
      cmin = a
      amax = c
      amin = a
 
      DO WHILE ( (.NOT. TEST2) )
         
         IF (GTHOMMET .EQ. 3) THEN
            c = (cmax + cmin)/2.0D0
         ELSE IF (GTHOMMET .EQ. 4) THEN
            a = (amax + amin)/2.0D0
         ENDIF

         GZMAX = 1.0D0
         GZMIN = 0.0D0
         TEST = .FALSE.
         mu = 2.0D0/(a+c)
         k = SQRT(1-(a/c)**2)
         m = (c**2-a**2)/2.0D0
         n = (c**2+a**2)/2.0D0      
                  
         DO WHILE ( (.NOT. TEST) )
            GThomsonZ = (GZMAX + GZMIN)/2.0D0
            u    = refU/mu + GThomsonZ*pi/mu
            CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)
            ZPOS = a*Felint + c*Selint
            IF (GTHOMMET .EQ. 3) THEN
               CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
               refZ = a*Felint + c*Selint
               ZPOS = ZPOS -refZ
            ENDIF
            
            IF (TEMPZ > ZPOS) GZMIN = GThomsonZ
            IF (TEMPZ < ZPOS) GZMAX = GThomsonZ
            
            IF ( (TEMPZ - ZPOS < 0.00001) .AND. (TEMPZ - ZPOS > -0.00001) ) THEN
               TEST = .TRUE.
            ENDIF

         ENDDO

         IF (GTHOMMET .EQ. 3) THEN

            CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)            
            Volume = pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(mu*u)+n)*COS(mu*u)
            CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
            Volume = Volume - ( pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(refU)+n)*COS(refU) )            
            IF (Volume > V) THEN 
               cmax = c
            ELSEIF (Volume < V) THEN
               cmin = c
            ENDIF

         ELSEIF (GTHOMMET .EQ. 4) THEN

            CALL EllipIntegral(Felint, Selint, (mu*u/2.0D0-pi/4.0D0), k)            
            Volume = pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(mu*u)+n)*COS(mu*u)
            CALL EllipIntegral(Felint, Selint, (refU/2.0D0-pi/4.0D0), k)
            Volume = Volume - ( pi * (2.0D0*(a**2+c**2)*c+3.0D0*a*c**2)/3.0D0 * Selint - pi*a**2*c/3.0D0*Felint &
                 - pi*(c**2-a**2)/6.0D0*SQRT(m*SIN(refU)+n)*COS(refU) )            

            IF (Volume > V) THEN 
               amax = a
            ELSEIF (Volume < V) THEN
               amin = a
            ENDIF

         ENDIF

         IF ( (Volume - V < 0.00001) .AND. (Volume - V > -0.00001) ) THEN
            TEST2 = .TRUE.
         ENDIF
         
      ENDDO

      PRINT *, "GTHOMSONC ", c
      PRINT *, "GTHOMSONA ", a
      PRINT *, "umax ", GTHOMSONZ

      GThomsonC = c
      GThomsonC2 = a
      GThomsonZ = TEMPZ
         
      PRINT *, "zmax ", GTHOMSONZ

    END SUBROUTINE CONVERTUNDULOIDPARAMETERS


!----------------------------------------------------------------

SUBROUTINE GTHOMSONHESSIAN(X,HESS)

  USE commons, ONLY: GTHOMMET, GTHOMPOT, GThomsonSigma, NATOMS
  IMPLICIT NONE
  LOGICAL GTEST
  INTEGER J1, J2, J3, J4
  DOUBLE PRECISION X(*), DIST, D2VDR2, DVDR
  DOUBLE PRECISION :: TMPCOORDS(3*NATOMS), DR(3), Gradient11(3), Gradient12(3), Gradient21(3), Gradient22(3) 
  DOUBLE PRECISION :: HESS111(3), HESS112(3), HESS122(3)
  DOUBLE PRECISION :: HESS211(3), HESS212(3), HESS222(3)
  DOUBLE PRECISION :: HESS(2*NATOMS, 2*NATOMS)
  
  DOUBLE PRECISION :: TEMP11, TEMP22, TEMP33, TEMP44

  TMPCOORDS(1:3*NATOMS) = X(1:3*NATOMS)
  CALL GTHOMSONANGTOC(TMPCOORDS,NATOMS)      
  HESS(1:2*NATOMS,1:2*NATOMS)=0.0D0
  
  DO J1=1,NATOMS
     J3=3*J1

     IF ( GTHOMMET .EQ. 1) THEN
        PRINT *, "METRIC NOT IMPLEMENTED IN HESSIAN"
        STOP
     ELSEIF ( GTHOMMET .EQ. 2) THEN
        CALL GRADMETRICCATENOID (X(2*J1-1:2*J1), Gradient11, Gradient12)
        CALL HESSMETRICCATENOID (X(2*J1-1:2*J1), HESS111, HESS112, HESS122)
     ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
        PRINT *, "METRIC NOT IMPLEMENTED IN HESSIAN"
        STOP
     ELSEIF ( GTHOMMET .EQ. 5 ) THEN
        CALL GRADMETRICSPHERE (X(2*J1-1:2*J1), Gradient11, Gradient12)
        CALL HESSMETRICSPHERE (X(2*J1-1:2*J1), HESS111, HESS112, HESS122)
     ENDIF
     
     DO J2=J1+1,NATOMS
        J4=3*J2
        DR(1) = TMPCOORDS(J3-2)-TMPCOORDS(J4-2)
        DR(2) = TMPCOORDS(J3-1)-TMPCOORDS(J4-1)
        DR(3) = TMPCOORDS(J3  )-TMPCOORDS(J4  )
        DIST  = SQRT(DOT_PRODUCT(DR, DR))

        IF (GTHOMPOT .EQ. 1) THEN
           D2VDR2 =   3/DIST**5 
           DVDR   = - 1/DIST**3
        ELSEIF (GTHOMPOT .EQ. 2) THEN 
           PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
           STOP
        ELSEIF (GTHOMPOT .EQ. 3) THEN
           D2VDR2 =  ( 3/DIST**5 + 3/GThomsonSigma/DIST**4 + 1/GThomsonSigma**2/DIST**3 ) * EXP(-1.0D0*DIST/GThomsonSigma)
           DVDR   = -( 1/DIST**3 + 1/GThomsonSigma/DIST**2 ) * EXP(-1.0D0*DIST/GThomsonSigma)
        ELSEIF (GTHOMPOT .EQ. 4) THEN
           PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
           STOP
        ELSEIF (GTHOMPOT .EQ. 5) THEN
           PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
           STOP
        ELSEIF (GTHOMPOT .EQ. 6) THEN
           PRINT *, "POTENTIAL NOT IMPLEMENTED IN HESSIAN"
           STOP
        ENDIF
        
        HESS(2*J1-1,2*J1-1) = HESS(2*J1-1,2*J1-1) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient11))**2 &
             + DVDR * (DOT_PRODUCT(Gradient11,Gradient11)+ DOT_PRODUCT(DR,HESS111)) 
        HESS(2*J1  ,2*J1  ) = HESS(2*J1  ,2*J1  ) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient12))**2 &
             + DVDR * (DOT_PRODUCT(Gradient12,Gradient12)+ DOT_PRODUCT(DR,HESS122)) 
        HESS(2*J1-1,2*J1  ) = HESS(2*J1-1,2*J1  ) +  D2VDR2 * DOT_PRODUCT(DR,Gradient11) * DOT_PRODUCT(DR,Gradient12) &
             + DVDR * (DOT_PRODUCT(Gradient11,Gradient12) + DOT_PRODUCT(DR,HESS112)) 

        IF ( GTHOMMET .EQ. 1) THEN
        ELSEIF ( GTHOMMET .EQ. 2) THEN
           CALL GRADMETRICCATENOID (X(2*J2-1:2*J2), Gradient21, Gradient22)
           CALL HESSMETRICCATENOID (X(2*J2-1:2*J2), HESS211, HESS212, HESS222)
        ELSEIF ( (GTHOMMET .EQ. 3) .OR. (GTHOMMET .EQ. 4) ) THEN
        ELSEIF ( GTHOMMET .EQ. 5 ) THEN
           CALL GRADMETRICSPHERE (X(2*J2-1:2*J2), Gradient21, Gradient22)
           CALL HESSMETRICSPHERE (X(2*J2-1:2*J2), HESS211, HESS212, HESS222)
        ENDIF

        HESS(2*J2-1,2*J2-1) = HESS(2*J2-1,2*J2-1) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient21))**2 &
             + DVDR * (DOT_PRODUCT(Gradient21,Gradient21) - DOT_PRODUCT(DR,HESS211)) 
        HESS(2*J2  ,2*J2  ) = HESS(2*J2  ,2*J2  ) +  D2VDR2 * (DOT_PRODUCT(DR,Gradient22))**2 &
             + DVDR * (DOT_PRODUCT(Gradient22,Gradient22) - DOT_PRODUCT(DR,HESS222)) 
        HESS(2*J2-1,2*J2  ) = HESS(2*J2-1,2*J2  ) +  D2VDR2 * DOT_PRODUCT(DR,Gradient21) * DOT_PRODUCT(DR,Gradient22) &
             + DVDR * (DOT_PRODUCT(Gradient11,Gradient12) - DOT_PRODUCT(DR,HESS212)) 
        
        HESS(2*J1-1,2*J2-1) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient11) * DOT_PRODUCT(DR,Gradient21) - DVDR * DOT_PRODUCT(Gradient11,Gradient21)          
        HESS(2*J1-1,2*J2  ) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient11) * DOT_PRODUCT(DR,Gradient22) - DVDR * DOT_PRODUCT(Gradient11,Gradient22)
        HESS(2*J1  ,2*J2-1) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient12) * DOT_PRODUCT(DR,Gradient21) - DVDR * DOT_PRODUCT(Gradient12,Gradient21)
        HESS(2*J1  ,2*J2  ) =  -D2VDR2 * DOT_PRODUCT(DR,Gradient12) * DOT_PRODUCT(DR,Gradient22) - DVDR * DOT_PRODUCT(Gradient12,Gradient22)

     ENDDO
  ENDDO

  DO J1=1,2*NATOMS
     DO J2 = J1+1,2*NATOMS
        HESS(J2,J1) = HESS(J1,J2)
     ENDDO
  ENDDO

  RETURN

END SUBROUTINE GTHOMSONHESSIAN

!----------------------------------------------------------------

SUBROUTINE GTHOMSONNUMHESSIAN(X,HESS)

  USE commons, ONLY : NATOMS
  IMPLICIT NONE
  INTEGER J1, J2
  DOUBLE PRECISION :: X(3*NATOMS), X1(3*NATOMS), X2(3*NATOMS), DX, ETHOMSON
  DOUBLE PRECISION :: V1(3*NATOMS), V2(3*NATOMS)
  DOUBLE PRECISION :: HESS(2*NATOMS,2*NATOMS)
  
  DX = 0.00001

  DO J1=1,2*NATOMS
     X1(:) = X(:)
     X1(J1) = X1(J1) - DX
     CALL GTHOMSON(X1,V1,ETHOMSON,.TRUE.)
     X2(:) = X(:)
     X2(J1) = X2(J1) + DX
     CALL GTHOMSON(X2,V2,ETHOMSON,.TRUE.)
     
     DO J2=J1,2*NATOMS
        HESS(J1,J2) = (V2(J2)-V1(J2))/(2.0D0*DX)
        HESS(J2,J1) = HESS(J1,J2)
     END DO

  END DO
  
  RETURN
  
END SUBROUTINE GTHOMSONNUMHESSIAN

!----------------------------------------------------------------
! catenoid      
      SUBROUTINE HESSMETRICCATENOID (X, HESS11, HESS12, HESS22)

      USE COMMONS, ONLY : GThomsonC, GThomsonZ
      IMPLICIT NONE
      DOUBLE PRECISION HESS11(3), HESS12(3), HESS22(3), X(2)
      DOUBLE PRECISION ARGHY, COSHA, SINHA, SINX2, SINX1, COSX2, COSX1

      COSX2 = COS(X(2))
      ARGHY = GThomsonZ/GThomsonC*COSX2
      COSHA = COSH(ARGHY)
      SINHA = SINH(ARGHY)
      SINX2 = SIN(X(2))
      SINX1 = SIN(X(1))
      COSX1 = COS(X(1))
      
      HESS11(1) = -GThomsonC * COSHA * COSX1
      HESS11(2) = -GThomsonC * COSHA * SINX1
      HESS11(3) =  0.0D0

      HESS12(1) =  GThomsonZ * SINHA * SINX1 * SINX2
      HESS12(2) = -GThomsonZ * SINHA * COSX1 * SINX2
      HESS12(3) =  0.0D0

      HESS22(1) = -GThomsonZ * COSX1 * (COSX2 * SINHA - GThomsonZ/GThomsonC *SINX2**2 *COSHA)
      HESS22(2) = -GThomsonZ * SINX1 * (COSX2 * SINHA - GThomsonZ/GThomsonC *SINX2**2 *COSHA)
      HESS22(3) = -GThomsonC * ARGHY

    END SUBROUTINE HESSMETRICCATENOID


!----------------------------------------------------------------
! sphere
      SUBROUTINE HESSMETRICSPHERE (X, HESS11, HESS12, HESS22)

        USE COMMONS, ONLY : GThomsonZ, GTHOMMET
        IMPLICIT NONE
        DOUBLE PRECISION HESS11(3), HESS12(3), HESS22(3), X(2)
        DOUBLE PRECISION ARG1, ARG2, ARG3, ARG4
        DOUBLE PRECISION RADIUS
        
        IF ( GTHOMMET .EQ. 5 ) THEN
           RADIUS = GTHOMSONZ
        ENDIF

        ARG1 = SIN(X(1))
        ARG2 = COS(X(1))
        ARG3 = SIN(X(2))
        ARG4 = COS(X(2))

        HESS11(1) = -ARG3 * ARG2 * RADIUS
        HESS11(2) = -ARG3 * ARG1 * RADIUS
        HESS11(3) = 0.0

        HESS12(1) = -ARG4 * ARG1 * RADIUS
        HESS12(2) =  ARG4 * ARG2 * RADIUS
        HESS12(3) = 0.0
        
        HESS22(1) = -ARG3 * ARG1 * RADIUS
        HESS22(2) = -ARG3 * ARG2 * RADIUS
        HESS22(3) = -ARG4 * RADIUS
        
      END SUBROUTINE HESSMETRICSPHERE
