SUBROUTINE CSMINIT
USE COMMONS,ONLY : CSMGP, NATOMS, CSMIMAGES, CSMGPINDEX, MYUNIT, COORDS, CSMNORM, QMINPCSMAV, CSMAV, NSAVE, QMINAV, PTGP, &
                   CSMGUIDET, CSMGUIDENORM, CSMGUIDEGPINDEX, CSMGUIDEGP, PTGPGUIDE
IMPLICIT NONE
INTEGER J1
DOUBLE PRECISION X(3*NATOMS)
CHARACTER(LEN=3) CSMGPSAVE
INTEGER CSMGPINDEXSAVE
DOUBLE PRECISION, ALLOCATABLE :: PTGPSAVE(:,:,:)

X(1:3*NATOMS)=COORDS(1:3*NATOMS,1)
CALL CENTRE2(X)
COORDS(1:3*NATOMS,1)=X(1:3*NATOMS)
CSMNORM=0.0D0
DO J1=1,NATOMS
   CSMNORM=CSMNORM+X(3*(J1-1)+1)**2+X(3*(J1-1)+2)**2+X(3*(J1-1)+3)**2
ENDDO

IF (TRIM(ADJUSTL(CSMGP)).EQ.'C2H') THEN
   CSMGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C2') THEN
   CSMGPINDEX=2
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C2V') THEN
   CSMGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3H') THEN
   CSMGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3') THEN
   CSMGPINDEX=3
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3V') THEN
   CSMGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4H') THEN
   CSMGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4') THEN
   CSMGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4V') THEN
   CSMGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5') THEN
   CSMGPINDEX=5
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5V') THEN
   CSMGPINDEX=10
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5H') THEN
   CSMGPINDEX=10
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6H') THEN
   CSMGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6') THEN
   CSMGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6V') THEN
   CSMGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C7') THEN
   CSMGPINDEX=7
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'CI') THEN
   CSMGPINDEX=2
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'CS') THEN
   CSMGPINDEX=2
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2D') THEN
   CSMGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2H') THEN
   CSMGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2') THEN
   CSMGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3D') THEN
   CSMGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3H') THEN
   CSMGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3') THEN
   CSMGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4D') THEN
   CSMGPINDEX=16
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4H') THEN
   CSMGPINDEX=16
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4') THEN
   CSMGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5') THEN
   CSMGPINDEX=10
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5H') THEN
   CSMGPINDEX=20
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5D') THEN
   CSMGPINDEX=20
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6D') THEN
   CSMGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6H') THEN
   CSMGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6') THEN
   CSMGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'IH') THEN
   CSMGPINDEX=120
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'I') THEN
   CSMGPINDEX=60
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'OH') THEN
   CSMGPINDEX=48
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'O') THEN
   CSMGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S4') THEN
   CSMGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S6') THEN
   CSMGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S8') THEN
   CSMGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'TD') THEN
   CSMGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'T') THEN
   CSMGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'TH') THEN
   CSMGPINDEX=24
ELSE
   WRITE(MYUNIT,'(A,A)') 'CSMinit> ERROR *** point group not recognised: ',TRIM(ADJUSTL(CSMGP))
   STOP
ENDIF

ALLOCATE(CSMIMAGES(3*NATOMS*CSMGPINDEX))
ALLOCATE(QMINPCSMAV(NSAVE,3*NATOMS),CSMAV(3*NATOMS),QMINAV(NSAVE),PTGP(3,3,2*CSMGPINDEX)) 
CSMNORM=2*CSMGPINDEX*CSMNORM
WRITE(MYUNIT,'(A,I6,A,G20.10)') 'CSMinit> Calculating continuous symmetry measure for point group ' // TRIM(ADJUSTL(CSMGP)) &
  &  // ' order=',CSMGPINDEX,' normalisation=',CSMNORM

CALL CSMGETOPS

IF (.NOT.CSMGUIDET) RETURN

IF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C2H') THEN
   CSMGUIDEGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C2') THEN
   CSMGUIDEGPINDEX=2
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C2V') THEN
   CSMGUIDEGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C3H') THEN
   CSMGUIDEGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C3') THEN
   CSMGUIDEGPINDEX=3
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C3V') THEN
   CSMGUIDEGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C4H') THEN
   CSMGUIDEGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C4') THEN
   CSMGUIDEGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C4V') THEN
   CSMGUIDEGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C5') THEN
   CSMGUIDEGPINDEX=5
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C5V') THEN
   CSMGUIDEGPINDEX=10
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C5H') THEN
   CSMGUIDEGPINDEX=10
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C6H') THEN
   CSMGUIDEGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C6') THEN
   CSMGUIDEGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C6V') THEN
   CSMGUIDEGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'C7') THEN
   CSMGUIDEGPINDEX=7
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'CI') THEN
   CSMGUIDEGPINDEX=2
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'CS') THEN
   CSMGUIDEGPINDEX=2
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D2D') THEN
   CSMGUIDEGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D2H') THEN
   CSMGUIDEGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D2') THEN
   CSMGUIDEGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D3D') THEN
   CSMGUIDEGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D3H') THEN
   CSMGUIDEGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D3') THEN
   CSMGUIDEGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D4D') THEN
   CSMGUIDEGPINDEX=16
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D4H') THEN
   CSMGUIDEGPINDEX=16
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D4') THEN
   CSMGUIDEGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D5') THEN
   CSMGUIDEGPINDEX=10
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D5H') THEN
   CSMGUIDEGPINDEX=20
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D5D') THEN
   CSMGUIDEGPINDEX=20
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D6D') THEN
   CSMGUIDEGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D6H') THEN
   CSMGUIDEGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'D6') THEN
   CSMGUIDEGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'IH') THEN
   CSMGUIDEGPINDEX=120
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'I') THEN
   CSMGUIDEGPINDEX=60
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'OH') THEN
   CSMGUIDEGPINDEX=48
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'O') THEN
   CSMGUIDEGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'S4') THEN
   CSMGUIDEGPINDEX=4
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'S6') THEN
   CSMGUIDEGPINDEX=6
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'S8') THEN
   CSMGUIDEGPINDEX=8
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'TD') THEN
   CSMGUIDEGPINDEX=24
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'T') THEN
   CSMGUIDEGPINDEX=12
ELSEIF (TRIM(ADJUSTL(CSMGUIDEGP)).EQ.'TH') THEN
   CSMGUIDEGPINDEX=24
ELSE
   WRITE(MYUNIT,'(A,A)') 'CSMinit> ERROR *** guide point group not recognised: ',TRIM(ADJUSTL(CSMGUIDEGP))
   STOP
ENDIF

IF (CSMGUIDEGPINDEX.GT.CSMGPINDEX) THEN
   WRITE(MYUNIT,'(A,I6,A,I6,A)') 'CSMinit> ERROR *** size of guide point group ',CSMGUIDEGPINDEX,' for ' &
  & // TRIM(ADJUSTL(CSMGUIDEGP)) // ' exceeds size ',CSMGPINDEX,' of ' // TRIM(ADJUSTL(CSMGP))
   STOP
ENDIF

ALLOCATE(PTGPGUIDE(3,3,2*CSMGUIDEGPINDEX)) 
CSMGUIDENORM=CSMNORM*CSMGUIDEGPINDEX/CSMGPINDEX
WRITE(MYUNIT,'(A,I6,A,G20.10)') 'CSMinit> Using guiding point group ' // TRIM(ADJUSTL(CSMGUIDEGP)) &
  &  // ' order=',CSMGUIDEGPINDEX,' normalisation=',CSMGUIDENORM

ALLOCATE(PTGPSAVE(3,3,2*CSMGPINDEX))
PTGPSAVE(1:3,1:3,1:2*CSMGPINDEX)=PTGP(1:3,1:3,1:2*CSMGPINDEX)
CSMGPSAVE=CSMGP
CSMGP=CSMGUIDEGP
CSMGPINDEXSAVE=CSMGPINDEX
CSMGPINDEX=CSMGUIDEGPINDEX

CALL CSMGETOPS

PTGPGUIDE(1:3,1:3,1:2*CSMGPINDEX)=PTGP(1:3,1:3,1:2*CSMGPINDEX)
CSMGP=CSMGPSAVE
CSMGPINDEX=CSMGPINDEXSAVE
PTGP(1:3,1:3,1:2*CSMGPINDEX)=PTGPSAVE(1:3,1:3,1:2*CSMGPINDEX)
DEALLOCATE(PTGPSAVE)

END SUBROUTINE CSMINIT

SUBROUTINE CSMGETOPS
USE COMMONS,ONLY : CSMGP, CSMGPINDEX, PTGP
IMPLICIT NONE
DOUBLE PRECISION X(1), DUMMY(1)
INTEGER LNATOMS

LNATOMS=1
IF (TRIM(ADJUSTL(CSMGP)).EQ.'C2H') THEN
   CALL CSMC2H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C2') THEN
   CALL CSMC2(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C2V') THEN
   CALL CSMC2V(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3H') THEN
   CALL CSMC3H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3') THEN
   CALL CSMC3(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3V') THEN
   CALL CSMC3V(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4H') THEN
   CALL CSMC4H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4') THEN
   CALL CSMC4(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4V') THEN
   CALL CSMC4V(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5') THEN
   CALL CSMC5(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5V') THEN
   CALL CSMC5V(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5H') THEN
   CALL CSMC5H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6H') THEN
   CALL CSMC6H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6') THEN
   CALL CSMC6(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6V') THEN
   CALL CSMC6V(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C7') THEN
   CALL CSMC7(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'CI') THEN
   CALL CSMCI(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'CS') THEN
   CALL CSMCS(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2D') THEN
   CALL CSMD2D(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2H') THEN
   CALL CSMD2H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2') THEN
   CALL CSMD2(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3D') THEN
   CALL CSMD3D(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3H') THEN
   CALL CSMD3H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3') THEN
   CALL CSMD3(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4D') THEN
   CALL CSMD4D(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4H') THEN
   CALL CSMD4H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4') THEN
   CALL CSMD4(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5') THEN
   CALL CSMD5(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5H') THEN
   CALL CSMD5H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5D') THEN
   CALL CSMD5D(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6D') THEN
   CALL CSMD6D(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6H') THEN
   CALL CSMD6H(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6') THEN
   CALL CSMD6(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'IH') THEN
   CALL CSMIH(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'I') THEN
   CALL CSMI(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'OH') THEN
   CALL CSMOH(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'O') THEN
   CALL CSMO(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S4') THEN
   CALL CSMS4(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S6') THEN
   CALL CSMS6(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S8') THEN
   CALL CSMS8(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'TD') THEN
   CALL CSMTD(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'T') THEN
   CALL CSMT(X,DUMMY,1,1,LNATOMS,.TRUE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'TH') THEN
   CALL CSMTH(X,DUMMY,1,1,LNATOMS,.TRUE.)
ENDIF

END SUBROUTINE CSMGETOPS
!
! Subroutine CSMMIN returns the value of the unnormalised CSM minimised
! with respect to orientation. The constant term is omitted from CSMVAL.
! X is the reoriented reference structure on exit.
! Could also set CSMAV for the closest structure with the required symmetry.
!
SUBROUTINE CSMMIN(X,ENERGY,RMS,ITDONE)
USE COMMONS,ONLY : NATOMS, CSMGPINDEX, MYUNIT, CSMEPS, MAXBFGS, CSMPMAT, PTGP, DEBUG, CSMMAXIT
USE PORFUNCS
IMPLICIT NONE
DOUBLE PRECISION X(3*NATOMS), CSMVAL
INTEGER N,M, ITDONE, NFAIL
LOGICAL PTEST, MFLAG
PARAMETER (N=3,M=10)
DOUBLE PRECISION AA(3), G(3), DIAG(N),W(N*(2*M+1)+2*M),SLENGTH,DDOT,OVERLAP
DOUBLE PRECISION DUMMY1,ENERGY,ENEW,RMS,ALPHA,GSAVE(3),XTEMP(3*NATOMS)
DOUBLE PRECISION GNORM,STP,YS,YY,SQ,YR,BETA,DPRAND,MAXMBFGS,MAXRISE
INTEGER ITER,POINT,ISPT,IYPT,BOUND,NPT,CP,I,INMC,IYCN,ISCN,NDECREASE,ITMAX,J1
!
! Initialise angle-axis variables to random small values.
!
ITMAX=CSMMAXIT
MAXMBFGS=MAXBFGS
PTEST=.FALSE.
IF (DEBUG) PTEST=.TRUE.
ALPHA=1.0D0
MAXRISE=1.0D-1
NFAIL=0
ITER=0
ITDONE=0
AA(1)=DPRAND()*1.0D-3; AA(2)=DPRAND()*1.0D-3; AA(3)=DPRAND()*1.0D-3
CALL CSMPOTGRAD(X,AA,ENERGY,.TRUE.,GSAVE)
RMS=SQRT((GSAVE(1)**2+GSAVE(2)**2+GSAVE(3)**2)/3)
G(1:N)=GSAVE(1:N)
IF (PTEST) WRITE(MYUNIT,'(A,2F20.10,A,I6,A)') 'csmmin> CSM and RMS force=',ENERGY,RMS,' after ',ITDONE,' LBFGS steps'
10    CALL FLUSH(6)
MFLAG=.FALSE.
IF (RMS.LE.CSMEPS) THEN
   MFLAG=.TRUE.
   IF (MFLAG) THEN
!     WRITE(*,'(A,F20.10)') ' Diagonal inverse Hessian elements are now ',DIAG(1)
      DO J1=1,NATOMS
         XTEMP(3*(J1-1)+1)=CSMPMAT(1,1)*X(3*(J1-1)+1)+CSMPMAT(1,2)*X(3*(J1-1)+2)+CSMPMAT(1,3)*X(3*(J1-1)+3)
         XTEMP(3*(J1-1)+2)=CSMPMAT(2,1)*X(3*(J1-1)+1)+CSMPMAT(2,2)*X(3*(J1-1)+2)+CSMPMAT(2,3)*X(3*(J1-1)+3)
         XTEMP(3*(J1-1)+3)=CSMPMAT(3,1)*X(3*(J1-1)+1)+CSMPMAT(3,2)*X(3*(J1-1)+2)+CSMPMAT(3,3)*X(3*(J1-1)+3)
      ENDDO
      X(1:3*NATOMS)=XTEMP(1:3*NATOMS)
!     WRITE(MYUNIT,'(A,3G20.10)') ' Optimal aa parameters: ',AA(1:3)
      RETURN
   ENDIF
ENDIF

IF (ITDONE.EQ.ITMAX) THEN
!  WRITE(*,'(A,F20.10)') ' Diagonal inverse Hessian elements are now ',DIAG(1)
   DO J1=1,NATOMS
      XTEMP(3*(J1-1)+1)=CSMPMAT(1,1)*X(3*(J1-1)+1)+CSMPMAT(1,2)*X(3*(J1-1)+2)+CSMPMAT(1,3)*X(3*(J1-1)+3)
      XTEMP(3*(J1-1)+2)=CSMPMAT(2,1)*X(3*(J1-1)+1)+CSMPMAT(2,2)*X(3*(J1-1)+2)+CSMPMAT(2,3)*X(3*(J1-1)+3)
      XTEMP(3*(J1-1)+3)=CSMPMAT(3,1)*X(3*(J1-1)+1)+CSMPMAT(3,2)*X(3*(J1-1)+2)+CSMPMAT(3,3)*X(3*(J1-1)+3)
   ENDDO
   X(1:3*NATOMS)=XTEMP(1:3*NATOMS)
!  WRITE(MYUNIT,'(A,3G20.10)') ' Optimal aa parameters: ',AA(1:3)
   RETURN
ENDIF

IF (ITER.EQ.0) THEN
   POINT=0
   MFLAG=.FALSE.
   DIAG(1:3)=1.0D0
   ISPT= N+2*M
   IYPT= ISPT+N*M
!
!  NR step for diagonal inverse Hessian
!
   DO I=1,N
      W(ISPT+I)= -G(I)*DIAG(I)
      W(I)= -G(I)*DIAG(I)
   ENDDO
   GNORM=DSQRT(DDOT(N,G,1,G,1))
!
!  Make the first guess for the step length cautious.
!
   STP=MIN(1.0D0/GNORM,GNORM)
!  STP=1.0D0
ELSE 
   BOUND=ITER
   IF (ITER.GT.M) BOUND=M
   YS= DDOT(N,W(IYPT+NPT+1),1,W(ISPT+NPT+1),1)
   IF (YS.EQ.0.0D0) YS=1.0D0
!
!  Update estimate of diagonal inverse Hessian elements
!  We divide by both YS and YY at different points, so
!  they had better not be zero!
!
   YY= DDOT(N,W(IYPT+NPT+1),1,W(IYPT+NPT+1),1)
   IF (YY.EQ.0.0D0) YY=1.0D0
   DUMMY1=YS/YY
!  DUMMY1=ABS(YS/YY)
   DO I=1,N
      DIAG(I)= DUMMY1
   ENDDO
!
!     COMPUTE -H*G USING THE FORMULA GIVEN IN: Nocedal, J. 1980,
!     "Updating quasi-Newton matrices with limited storage",
!     Mathematics of Computation, Vol.24, No.151, pp. 773-782.
!     ---------------------------------------------------------
!
   CP= POINT
   IF (POINT.EQ.0) CP=M
   W(N+CP)= 1.0D0/YS
   DO I=1,N
      W(I)= -G(I)
   ENDDO
   CP= POINT
   DO I= 1,BOUND
      CP=CP-1
      IF (CP.EQ. -1)CP=M-1
      SQ= DDOT(N,W(ISPT+CP*N+1),1,W,1)
      INMC=N+M+CP+1
      IYCN=IYPT+CP*N
      W(INMC)= W(N+CP+1)*SQ
      CALL DAXPY(N,-W(INMC),W(IYCN+1),1,W,1)
   ENDDO
  
   DO I=1,N
      W(I)=DIAG(I)*W(I)
   ENDDO

   DO I=1,BOUND
      YR= DDOT(N,W(IYPT+CP*N+1),1,W,1)
      BETA= W(N+CP+1)*YR
      INMC=N+M+CP+1
      BETA= W(INMC)-BETA
      ISCN=ISPT+CP*N
      CALL DAXPY(N,BETA,W(ISCN+1),1,W,1)
      CP=CP+1
      IF (CP.EQ.M) CP=0
   ENDDO
   STP=1.0D0
ENDIF
!
!  Store the new search direction
!
IF (ITER.GT.0) THEN
   DO I=1,N
      W(ISPT+POINT*N+I)= W(I)
   ENDDO
ENDIF

OVERLAP=DDOT(N,G,1,W,1)/SQRT(DDOT(N,G,1,G,1)*DDOT(N,W,1,W,1))
IF (OVERLAP.GT.0.0D0) THEN
   IF (PTEST) WRITE(MYUNIT,'(A)') 'csmmin> Search direction has positive projection onto gradient - reversing step'
   DO I=1,N
      W(ISPT+POINT*N+I)= -W(I)
   ENDDO
ENDIF

DO I=1,N
   W(I)=G(I)
ENDDO
SLENGTH=0.0D0
DO J1=1,N
   SLENGTH=SLENGTH+W(ISPT+POINT*N+J1)**2
ENDDO
SLENGTH=SQRT(SLENGTH)
IF (STP*SLENGTH.GT.MAXMBFGS) STP=MAXMBFGS/SLENGTH
!
!  We now have the proposed step.
!
DO J1=1,N
   AA(J1)=AA(J1)+STP*W(ISPT+POINT*N+J1)
ENDDO 
NDECREASE=0
20    CALL CSMPOTGRAD(X,AA,ENEW,.TRUE.,GSAVE)

IF (ENEW-ENERGY.LE.MAXRISE) THEN
   ITER=ITER+1
   ITDONE=ITDONE+1
   ENERGY=ENEW
ELSE 
!
!  Energy increased - try again with a smaller step size
!
!        IF (STP*SLENGTH.LT.1.0D-10) THEN
   IF (NDECREASE.GT.5) THEN
      WRITE(MYUNIT,*) 'csmmin> LBFGS step cannot find a lower CSM - try again'
      NFAIL=NFAIL+1
      IF (NFAIL.GT.20) THEN
         WRITE(MYUNIT,'(A)') ' Too many failures - give up'
         DO J1=1,NATOMS
            XTEMP(3*(J1-1)+1)=CSMPMAT(1,1)*X(3*(J1-1)+1)+CSMPMAT(1,2)*X(3*(J1-1)+2)+CSMPMAT(1,3)*X(3*(J1-1)+3)
            XTEMP(3*(J1-1)+2)=CSMPMAT(2,1)*X(3*(J1-1)+1)+CSMPMAT(2,2)*X(3*(J1-1)+2)+CSMPMAT(2,3)*X(3*(J1-1)+3)
            XTEMP(3*(J1-1)+3)=CSMPMAT(3,1)*X(3*(J1-1)+1)+CSMPMAT(3,2)*X(3*(J1-1)+2)+CSMPMAT(3,3)*X(3*(J1-1)+3)
         ENDDO
         X(1:3*NATOMS)=XTEMP(1:3*NATOMS)
!        WRITE(MYUNIT,'(A,3G20.10)') ' Optimal aa parameters: ',AA(1:3)
         RETURN
      ENDIF
      DO J1=1,N
         AA(J1)=AA(J1)-STP*W(ISPT+POINT*N+J1)
      ENDDO 
      GOTO 30
   ENDIF
   DO J1=1,N
      AA(J1)=AA(J1)-0.9*STP*W(ISPT+POINT*N+J1)
   ENDDO 
   NDECREASE=NDECREASE+1
   STP=STP/10.0D0
   IF (PTEST) WRITE(MYUNIT,'(A,F19.10,A,F16.10,A,F15.8)') 'csmmin> CSM increased from ',ENERGY,' to ',ENEW,' decreasing step to ', &
  &                                                   STP*SLENGTH
      GOTO 20
   ENDIF
   RMS=SQRT((GSAVE(1)**2+GSAVE(2)**2+GSAVE(3)**2)/3)
   G(1:N)=GSAVE(1:N)
   IF (PTEST) WRITE(MYUNIT,'(A,2F20.10,A,I6,A,G15.5)') 'csmmin> CSM and RMS force=',ENERGY,RMS,' after ',ITDONE, &
  &        ' LBFGS steps, step:',STP*SLENGTH
!
!     Compute the new step and gradient change
!
30    NPT=POINT*N
DO I=1,N
   W(ISPT+NPT+I)= STP*W(ISPT+NPT+I)
   W(IYPT+NPT+I)= G(I)-W(I)
ENDDO
POINT=POINT+1
IF (POINT.EQ.M) POINT=0
GOTO 10

!
! Set CSMAV the closest structure with the required point group.
!

END SUBROUTINE CSMMIN

!
! Subroutine CSMPOTGRAD returns the value of the unnormalised CSM for a
! given orientation and the derivatives with respect to angle-axis parameters
! if GRADT is true. The constant term is omitted from CSMVAL.
!
SUBROUTINE CSMPOTGRAD(X,AA,CSMVAL,GRADT,GRAD)
USE COMMONS,ONLY : NATOMS, CSMGPINDEX, CSMIMAGES, CSMNORM, CSMPMAT, PTGP, MYUNIT
IMPLICIT NONE
DOUBLE PRECISION X(3*NATOMS), CSMVAL, GRAD(3), AA(3), DRM1(3,3), DRM2(3,3), DRM3(3,3)
DOUBLE PRECISION TEMP(3,3), TEMP2(3,3), TEMP3(3,3,3), TEMP4(3,3,3)
INTEGER J1, J2, J3
LOGICAL GRADT

CSMVAL=0.0D0
GRAD(1:3)=0.0D0
CALL RMDRVT(AA, CSMPMAT, DRM1, DRM2, DRM3, GRADT)
DO J1=1,CSMGPINDEX
   DO J2=1,3
      DO J3=1,3
         TEMP(J3,J2)   =PTGP(J3,1,J1)*CSMPMAT(1,J2)+PTGP(J3,2,J1)*CSMPMAT(2,J2)+PTGP(J3,3,J1)*CSMPMAT(3,J2)
         TEMP3(J3,J2,1)=PTGP(J3,1,J1)*DRM1(1,J2)+PTGP(J3,2,J1)*DRM1(2,J2)+PTGP(J3,3,J1)*DRM1(3,J2)
         TEMP3(J3,J2,2)=PTGP(J3,1,J1)*DRM2(1,J2)+PTGP(J3,2,J1)*DRM2(2,J2)+PTGP(J3,3,J1)*DRM2(3,J2)
         TEMP3(J3,J2,3)=PTGP(J3,1,J1)*DRM3(1,J2)+PTGP(J3,2,J1)*DRM3(2,J2)+PTGP(J3,3,J1)*DRM2(3,J2)
      ENDDO
   ENDDO
!
!                T 
! TEMP2 = CSMPMAT  . R(J1) . CSMPMAT
!
   DO J2=1,3
      DO J3=1,3
         TEMP2(J3,J2)=CSMPMAT(1,J3)*TEMP(1,J2)+CSMPMAT(2,J3)*TEMP(2,J2)+CSMPMAT(3,J3)*TEMP(3,J2)
      ENDDO
   ENDDO
!
!                T                                      T 
! TEMP4 = CSMPMAT  . R(J1) . grad CSMPMAT + grad CSMPMAT . R(J1) . CSMPMAT
!
   DO J2=1,3
      DO J3=1,3
         TEMP4(J3,J2,1)=CSMPMAT(1,J3)*TEMP3(1,J2,1)+CSMPMAT(2,J3)*TEMP3(2,J2,1)+CSMPMAT(3,J3)*TEMP3(3,J2,1) &
  &                    +DRM1(1,J3)* TEMP(1,J2)  +DRM1(2,J3)* TEMP(2,J2)  +DRM1(3,J3)*TEMP(3,J2)
         TEMP4(J3,J2,2)=CSMPMAT(1,J3)*TEMP3(1,J2,2)+CSMPMAT(2,J3)*TEMP3(2,J2,2)+CSMPMAT(3,J3)*TEMP3(3,J2,2) &
  &                    +DRM2(1,J3)* TEMP(1,J2)  +DRM2(2,J3)* TEMP(2,J2)  +DRM2(3,J3)*TEMP(3,J2)
         TEMP4(J3,J2,3)=CSMPMAT(1,J3)*TEMP3(1,J2,3)+CSMPMAT(2,J3)*TEMP3(2,J2,3)+CSMPMAT(3,J3)*TEMP3(3,J2,3) &
  &                    +DRM3(1,J3)* TEMP(1,J2)  +DRM3(2,J3)* TEMP(2,J2)  +DRM3(3,J3)*TEMP(3,J2)
      ENDDO
   ENDDO
   DO J2=1,NATOMS
      CSMVAL=CSMVAL+X(3*(J2-1)+1)*TEMP2(1,1)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+1) &
  &                +X(3*(J2-1)+1)*TEMP2(1,2)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+2) &
  &                +X(3*(J2-1)+1)*TEMP2(1,3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+3) &
  &                +X(3*(J2-1)+2)*TEMP2(2,1)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+1) &
  &                +X(3*(J2-1)+2)*TEMP2(2,2)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+2) &
  &                +X(3*(J2-1)+2)*TEMP2(2,3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+3) &
  &                +X(3*(J2-1)+3)*TEMP2(3,1)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+1) &
  &                +X(3*(J2-1)+3)*TEMP2(3,2)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+2) &
  &                +X(3*(J2-1)+3)*TEMP2(3,3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+3) 
      DO J3=1,3
         GRAD(J3)=GRAD(J3)+X(3*(J2-1)+1)*TEMP4(1,1,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+1) &
  &                       +X(3*(J2-1)+1)*TEMP4(1,2,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+2) &
  &                       +X(3*(J2-1)+1)*TEMP4(1,3,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+3) &
  &                       +X(3*(J2-1)+2)*TEMP4(2,1,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+1) &
  &                       +X(3*(J2-1)+2)*TEMP4(2,2,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+2) &
  &                       +X(3*(J2-1)+2)*TEMP4(2,3,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+3) &
  &                       +X(3*(J2-1)+3)*TEMP4(3,1,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+1) &
  &                       +X(3*(J2-1)+3)*TEMP4(3,2,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+2) &
  &                       +X(3*(J2-1)+3)*TEMP4(3,3,J3)*CSMIMAGES(3*NATOMS*(J1-1)+3*(J2-1)+3) 
      ENDDO
   ENDDO
ENDDO
CSMVAL=1.0D0-2*CSMVAL/CSMNORM
GRAD(1:3)=-2*GRAD(1:3)

RETURN

END SUBROUTINE CSMPOTGRAD

SUBROUTINE CSMROT(X,DUMMY,NINV,J1)
USE COMMONS,ONLY : CSMGP, NATOMS, CSMGPINDEX
IMPLICIT NONE
INTEGER J1, NINV
DOUBLE PRECISION X(3*NATOMS), DUMMY(3*NATOMS)

IF (TRIM(ADJUSTL(CSMGP)).EQ.'C2H') THEN
   CALL CSMC2H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C2') THEN
   CALL CSMC2(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C2V') THEN
   CALL CSMC2V(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3H') THEN
   CALL CSMC3H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3') THEN
   CALL CSMC3(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C3V') THEN
   CALL CSMC3V(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4H') THEN
   CALL CSMC4H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4') THEN
   CALL CSMC4(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C4V') THEN
   CALL CSMC4V(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5') THEN
   CALL CSMC5(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5V') THEN
   CALL CSMC5V(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C5H') THEN
   CALL CSMC5H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6H') THEN
   CALL CSMC6H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6') THEN
   CALL CSMC6(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C6V') THEN
   CALL CSMC6V(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'C7') THEN
   CALL CSMC7(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'CI') THEN
   CALL CSMCI(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'CS') THEN
   CALL CSMCS(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2D') THEN
   CALL CSMD2D(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2H') THEN
   CALL CSMD2H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D2') THEN
   CALL CSMD2(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3D') THEN
   CALL CSMD3D(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3H') THEN
   CALL CSMD3H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D3') THEN
   CALL CSMD3(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4D') THEN
   CALL CSMD4D(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4H') THEN
   CALL CSMD4H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D4') THEN
   CALL CSMD4(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5') THEN
   CALL CSMD5(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5H') THEN
   CALL CSMD5H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D5D') THEN
   CALL CSMD5D(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6D') THEN
   CALL CSMD6D(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6H') THEN
   CALL CSMD6H(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'D6') THEN
   CALL CSMD6(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'IH') THEN
   CALL CSMIH(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'I') THEN
   CALL CSMI(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'OH') THEN
   CALL CSMOH(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'O') THEN
   CALL CSMO(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S4') THEN
   CALL CSMS4(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S6') THEN
   CALL CSMS6(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'S8') THEN
   CALL CSMS8(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'TD') THEN
   CALL CSMTD(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'T') THEN
   CALL CSMT(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ELSEIF (TRIM(ADJUSTL(CSMGP)).EQ.'TH') THEN
   CALL CSMTH(X,DUMMY,J1,NINV,NATOMS,.FALSE.)
ENDIF

END SUBROUTINE CSMROT
!
! Apply all point group operations of Ih to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMIH(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,240), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,     -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  1.00000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,     1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0,  1.00000000000,  0,     0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,     1.00000000000,  0,  0,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0,  0,  1.00000000000,     1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,     -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  1.00000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0,  -1.00000000000,  0,     0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,     -1.00000000000,  0,  0,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0,  0,  1.00000000000,     -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,     -1.00000000000,  0,  0,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0,  0,  -1.00000000000,     -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0,  1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,     1.00000000000,  0,  0,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0,  0,  -1.00000000000,     1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,     -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  1.00000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,     1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0,  0,  1.00000000000,     1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  1.0000000000,    &
  & -1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0,  1.00000000000,  0,     0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  1.0000000000,     -1.00000000000,  0,  0,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,     -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  1.00000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0,  0,  -1.0000000000,     -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,     0,  0,  -1.0000000000,    &
  & 1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.0000000000,    &
  & 1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  -1.0000000000,     -1.00000000000,  0,  0,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0,  0,  -1.0000000000,     -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.0000000000,    &
  & 1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0,  -1.00000000000,  0,     0,  0,  -1.0000000000,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & 0,  0,  -1.0000000000,     1.00000000000,  0,  0,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0,  0,  1.0000000000,     1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,     0,  0,  1.0000000000,    &
  & -1.00000000000,  0,  0,     0,  1.00000000000,  0,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,     0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,     0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0,  1.00000000000,  0,     0,  0,  1.0000000000,    &
  & -1.00000000000,  0,  0,     0,  -1.00000000000,  0,    &
  & 0,  0,  1.0000000000,     1.00000000000,  0,  0,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,     0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,     0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,     -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,     -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,     -0.500000000000,  0.809016994375,  0.309016994375  /

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF

IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMIH
!
! Apply all point group operations of I to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMI(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,120), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.0000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.0000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0,  0,  -1.0000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.0000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & 0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.0000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.0000000000,    &
  & -1.00000000000,  0,  0,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & 0.309016994375,  0.500000000000,  -0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  -0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & -0.500000000000,  0.809016994375,  0.309016994375,    &
  & -0.809016994375,  -0.309016994375,  -0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  0.309016994375,    &
  & 0.809016994375,  0.309016994375,  -0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.809016994375,  -0.309016994375,  0.500000000000,    &
  & 0.309016994375,  0.500000000000,  0.809016994375,    &
  & -0.500000000000,  0.809016994375,  -0.309016994375,    &
  & 0.809016994375,  0.309016994375,  0.500000000000,    &
  & -0.309016994375,  -0.500000000000,  0.809016994375,    &
  & 0.500000000000,  -0.809016994375,  -0.309016994375 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF

IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMI
!
! Apply all point group operations of C5 to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMC5(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,10), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC5
!
! Apply all point group operations of C5V to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMC5V(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,20), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC5V
!
! Apply all point group operations of C5H to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMC5H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,20), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC5H
!
! Apply all point group operations of D5 to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMD5(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,20), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD5
!
! Apply all point group operations of D5H to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMD5H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,40), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0,  -1.00000000000,  0,    &
  & -1.00000000000,  0,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0,  -1.00000000000,  0,    &
  & -1.00000000000,  0,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0,  -1.00000000000,  0,    &
  & -1.00000000000,  0,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0,  -1.00000000000,  0,    &
  & -1.00000000000,  0,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & 0,  0,  -1.00000000000 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD5H
!
! Apply all point group operations of D5D to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMD5D(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,40), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.0000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -1.0000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  -1.0000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.309016994375,  -0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  1.00000000000,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & -0.587785252292,  -0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.809016994375,  -0.587785252292,  0,    &
  & 0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & 0.809016994375,  0.587785252292,  0,    &
  & -0.587785252292,  0.809016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.309016994375,  0.951056516295,  0,    &
  & -0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -1.00000000000,  0,  0,    &
  & 0,  -1.00000000000,  0,    &
  & 0,  0,  -1.00000000000,    &
  & -0.309016994375,  -0.951056516295,  0,    &
  & 0.951056516295,  -0.309016994375,  0,    &
  & 0,  0,  -1.00000000000 /
  
IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD5D
!
! Apply all point group operations of C3 to initial coordinates and store in CSMIMAGES
!
SUBROUTINE CSMC3(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,6), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.500000000000,  -0.866025403784,  0,    &
  & 0.866025403784,  -0.500000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.500000000000,  0.866025403784,  0,    &
  & -0.866025403784,  -0.500000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & 1.00000000000,  0,  0,    &
  & 0,  1.00000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.500000000000,  0.866025403784,  0,    &
  & -0.866025403784,  -0.500000000000,  0,    &
  & 0,  0,  1.00000000000,    &
  & -0.500000000000,  -0.866025403784,  0,    &
  & 0.866025403784,  -0.500000000000,  0,    &
  & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC3

SUBROUTINE CSMC2H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,8), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC2H

SUBROUTINE CSMC2(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,4), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000/  

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC2

SUBROUTINE CSMC2V(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,8), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC2V

SUBROUTINE CSMC3H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,12), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC3H

SUBROUTINE CSMC3V(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,12), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
 DATA RMAT / & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC3V

SUBROUTINE CSMC4H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,16), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC4H

SUBROUTINE CSMC4(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,8), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC4

SUBROUTINE CSMC4V(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,16), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC4V

SUBROUTINE CSMC6H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,24), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC6H

SUBROUTINE CSMC6(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,12), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC6

SUBROUTINE CSMC6V(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,24), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC6V

SUBROUTINE CSMC7(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,14), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.62349,  -0.781831,  0,   & 
 & 0.781831,  0.62349,  0,   & 
 & 0,  0,  1.,   & 
 & -0.222521,  -0.974928,  0,   & 
 & 0.974928,  -0.222521,  0,   & 
 & 0,  0,  1.,   & 
 & -0.900969,  -0.433884,  0,   & 
 & 0.433884,  -0.900969,  0,   & 
 & 0,  0,  1.,   & 
 & -0.900969,  0.433884,  0,   & 
 & -0.433884,  -0.900969,  0,   & 
 & 0,  0,  1.,   & 
 & -0.222521,  0.974928,  0,   & 
 & -0.974928,  -0.222521,  0,   & 
 & 0,  0,  1.,   & 
 & 0.62349,  0.781831,  0,   & 
 & -0.781831,  0.62349,  0,   & 
 & 0,  0,  1.,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.62349,  0.781831,  0,   & 
 & -0.781831,  0.62349,  0,   & 
 & 0,  0,  1.,   & 
 & -0.222521,  0.974928,  0,   & 
 & -0.974928,  -0.222521,  0,   & 
 & 0,  0,  1.,   & 
 & -0.900969,  0.433884,  0,   & 
 & -0.433884,  -0.900969,  0,   & 
 & 0,  0,  1.,   & 
 & -0.900969,  -0.433884,  0,   & 
 & 0.433884,  -0.900969,  0,   & 
 & 0,  0,  1.,   & 
 & -0.222521,  -0.974928,  0,   & 
 & 0.974928,  -0.222521,  0,   & 
 & 0,  0,  1.,   & 
 & 0.62349,  -0.781831,  0,   & 
 & 0.781831,  0.62349,  0,   & 
 & 0,  0,  1./

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMC7

SUBROUTINE CSMCI(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,4), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMCI

SUBROUTINE CSMCS(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,4), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMCS

SUBROUTINE CSMD2D(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,16), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD2D

SUBROUTINE CSMD2H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,16), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD2H

SUBROUTINE CSMD2(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,8), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD2

SUBROUTINE CSMD3D(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,24), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 &  1.00000000000,  0,  0,    & 
 &  0,  1.00000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  -0.500000000000,  -0.866025403784,  0,    & 
 &  0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  1.00000000000,  0,  0,    & 
 &  0,  -1.00000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  0.500000000000,  0.866025403784,  0,    & 
 &  0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  -0.500000000000,  0.866025403784,  0,    & 
 &  -0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  -0.500000000000,  0.866025403784,  0,    & 
 &  0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  -1.00000000000,  0,  0,    & 
 &  0,  1.00000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  -0.500000000000,  -0.866025403784,  0,    & 
 &  -0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  0.500000000000,  -0.866025403784,  0,    & 
 &  -0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  0.500000000000,  0.866025403784,  0,    & 
 &  -0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  0.500000000000,  -0.866025403784,  0,    & 
 &  0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  -1.00000000000,  0,  0,    & 
 &  0,  -1.00000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  1.00000000000,  0,  0,    & 
 &  0,  1.00000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  -0.500000000000,  0.866025403784,  0,    & 
 &  -0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  1.00000000000,  0,  0,    & 
 &  0,  -1.00000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  0.500000000000,  0.866025403784,  0,    & 
 &  0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  -0.500000000000,  -0.866025403784,  0,    & 
 &  0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  -0.500000000000,  0.866025403784,  0,    & 
 &  0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  -1.00000000000,  0,  0,    & 
 &  0,  1.00000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  -0.500000000000,  -0.866025403784,  0,    & 
 &  -0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  1.00000000000,    & 
 &  0.500000000000,  -0.866025403784,  0,    & 
 &  -0.866025403784,  -0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  0.500000000000,  -0.866025403784,  0,    & 
 &  0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  0.500000000000,  0.866025403784,  0,    & 
 &  -0.866025403784,  0.500000000000,  0,    & 
 &  0,  0,  -1.00000000000,    & 
 &  -1.00000000000,  0,  0,    & 
 &  0,  -1.00000000000,  0,    & 
 &  0,  0,  -1.00000000000/ 
 
IF (GETOPS) THEN 
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX) 
   RETURN 
ENDIF 
   
IF (INV.GE.0) THEN 
   DO J2=1,NLOCAL 
      J3=3*(J2-1) 
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3) 
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3) 
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3) 
   ENDDO 
ELSE 
   DO J2=1,NLOCAL 
      J3=3*(J2-1) 
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3) 
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3) 
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3) 
   ENDDO 
ENDIF 
 
END SUBROUTINE CSMD3D 
 
SUBROUTINE CSMD3H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP 
IMPLICIT NONE 
INTEGER OPNUM, J2, J3, INV, NLOCAL 
DOUBLE PRECISION RMAT(3,3,24), X(3*NLOCAL), Y(3*NLOCAL) 
LOGICAL GETOPS 
DATA RMAT / & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD3H

SUBROUTINE CSMD3(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,12), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD3

SUBROUTINE CSMD4D(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,32), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.707106781187,  0.707106781187,  0,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.707106781187,  0.707106781187,  0,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.707106781187,  -0.707106781187,  0,   & 
 & 0.707106781187,  -0.707106781187,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD4D

SUBROUTINE CSMD4H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,32), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD4H

SUBROUTINE CSMD4(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,16), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD4

SUBROUTINE CSMD6D(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,48), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD6D

SUBROUTINE CSMD6H(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,48), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000/ 

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD6H

SUBROUTINE CSMD6(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,24), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & 0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0.500000000000,  -0.866025403784,  0,   & 
 & -0.866025403784,  -0.500000000000,  0,   & 
 & 0,  0,  -1.00000000000/ 

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMD6

SUBROUTINE CSMOH(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,96), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMOH

SUBROUTINE CSMO(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,48), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMO

SUBROUTINE CSMS4(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,8), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 0,  1.,  0,   & 
 & -1.,  0,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.,  0,   & 
 & -1.,  0,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 0,  -1.,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  0,  -1./

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMS4

SUBROUTINE CSMS6(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,12), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.5,  -0.866025,  0,   & 
 & 0.866025,  0.5,  0,   & 
 & 0,  0,  -1.,   & 
 & -0.5,  -0.866025,  0,   & 
 & 0.866025,  -0.5,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -0.5,  0.866025,  0,   & 
 & -0.866025,  -0.5,  0,   & 
 & 0,  0,  1.,   & 
 & 0.5,  0.866025,  0,   & 
 & -0.866025,  0.5,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.5,  0.866025,  0,   & 
 & -0.866025,  0.5,  0,   & 
 & 0,  0,  -1.,   & 
 & -0.5,  0.866025,  0,   & 
 & -0.866025,  -0.5,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -0.5,  -0.866025,  0,   & 
 & 0.866025,  -0.5,  0,   & 
 & 0,  0,  1.,   & 
 & 0.5,  -0.866025,  0,   & 
 & 0.866025,  0.5,  0,   & 
 & 0,  0,  -1./

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMS6

SUBROUTINE CSMS8(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,16), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.707107,  -0.707107,  0,   & 
 & 0.707107,  0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  -1.,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  0,  1.,   & 
 & -0.707107,  -0.707107,  0,   & 
 & 0.707107,  -0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & -0.707107,  0.707107,  0,   & 
 & -0.707107,  -0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  1.,  0,   & 
 & -1.,  0,  0,   & 
 & 0,  0,  1.,   & 
 & 0.707107,  0.707107,  0,   & 
 & -0.707107,  0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0.707107,  0.707107,  0,   & 
 & -0.707107,  0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  1.,  0,   & 
 & -1.,  0,  0,   & 
 & 0,  0,  1.,   & 
 & -0.707107,  0.707107,  0,   & 
 & -0.707107,  -0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & -0.707107,  -0.707107,  0,   & 
 & 0.707107,  -0.707107,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  -1.,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  0,  1.,   & 
 & 0.707107,  -0.707107,  0,   & 
 & 0.707107,  0.707107,  0,   & 
 & 0,  0,  -1./

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMS8

SUBROUTINE CSMTD(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,48), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMTD

SUBROUTINE CSMT(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,24), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000/

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMT

SUBROUTINE CSMTH(X,Y,OPNUM,INV,NLOCAL,GETOPS)
USE COMMONS,ONLY : CSMGPINDEX, PTGP
IMPLICIT NONE
INTEGER OPNUM, J2, J3, INV, NLOCAL
DOUBLE PRECISION RMAT(3,3,48), X(3*NLOCAL), Y(3*NLOCAL)
LOGICAL GETOPS
DATA RMAT / &
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  1.,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  0,  1.00000000000,   & 
 & 1.00000000000,  0,  0,   & 
 & 0,  1.00000000000,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1.,   & 
 & 1.,  0,  0,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  -1.,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  -1.,   & 
 & 0,  0,  -1.00000000000,   & 
 & -1.00000000000,  0,  0,   & 
 & 0,  -1.00000000000,  0,   & 
 & 0,  0,  -1.,   & 
 & 1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & -1.,  0,  0,   & 
 & 0,  1.,  0,   & 
 & 0,  0,  1.,   & 
 & 1.,  0,  0,   & 
 & 0,  -1.,  0,   & 
 & 0,  0,  1./ 

IF (GETOPS) THEN
   PTGP(1:3,1:3,1:CSMGPINDEX)=RMAT(1:3,1:3,1:CSMGPINDEX)
   RETURN
ENDIF
  
IF (INV.GE.0) THEN
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM)*X(J3+1)+RMAT(1,2,OPNUM)*X(J3+2)+RMAT(1,3,OPNUM)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM)*X(J3+1)+RMAT(2,2,OPNUM)*X(J3+2)+RMAT(2,3,OPNUM)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM)*X(J3+1)+RMAT(3,2,OPNUM)*X(J3+2)+RMAT(3,3,OPNUM)*X(J3+3)
   ENDDO
ELSE
   DO J2=1,NLOCAL
      J3=3*(J2-1)
      Y(J3+1)=RMAT(1,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(1,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(1,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+2)=RMAT(2,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(2,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(2,3,OPNUM+CSMGPINDEX)*X(J3+3)
      Y(J3+3)=RMAT(3,1,OPNUM+CSMGPINDEX)*X(J3+1)+RMAT(3,2,OPNUM+CSMGPINDEX)*X(J3+2)+RMAT(3,3,OPNUM+CSMGPINDEX)*X(J3+3)
   ENDDO
ENDIF

END SUBROUTINE CSMTH
