# setup fortran compiler
set(CMAKE_SHARED_LIBRARY_LINK_Fortran_FLAGS "")

enable_language(Fortran)

GET_FILENAME_COMPONENT(FC_PROGNAME ${CMAKE_Fortran_COMPILER} NAME)
message("FC_PROGNAME = ${FC_PROGNAME}")

# if no compiler switch is given try to automatically determine it
if(NOT COMPILER_SWITCH)
   GET_FILENAME_COMPONENT(FC_PROGNAME ${CMAKE_Fortran_COMPILER} NAME)

   if(FC_PROGNAME MATCHES "pgf90")
      set(COMPILER_SWITCH "pgi" CACHE TYPE STRING)
#   elseif(FC_PROGNAME MATCHES "mpif90")
#      set(COMPILER_SWITCH "pgi" CACHE TYPE STRING)
   elseif(FC_PROGNAME MATCHES "gfortran")
      set(COMPILER_SWITCH "gfortran" CACHE TYPE STRING)
   elseif(FC_PROGNAME MATCHES "nagfor")
      set(COMPILER_SWITCH "nag" CACHE TYPE STRING)
   elseif(FC_PROGNAME MATCHES "ifort")
      set(COMPILER_SWITCH "ifort" CACHE TYPE STRING)
   else(FC_PROGNAME MATCHES "pgf90")
         if(FC_PROGNAME MATCHES "mpif90") 
           message(FATAL_ERROR "mpi compilation currently works with pgi only. Use -DCOMPILER_SWITCH=pgi with cmake.") 
         else(FC_PROGNAME MATCHES "mpif90")
           message(FATAL_ERROR "ERROR: could not determine compiler switch from fortran compiler name (${FC_PROGNAME})\nplease specify with -DCOMPILER_SWITCH=<pgi/gfortran/nag/ifort>")
         endif(FC_PROGNAME MATCHES "mpif90") 
   endif(FC_PROGNAME MATCHES "pgf90")
endif(NOT COMPILER_SWITCH)

message("Compiler switch = ${COMPILER_SWITCH}")

# STRING(REGEX REPLACE "mpif90$" "blah" result "${CMAKE_Fortran_COMPILER}" )
# MESSAGE(STATUS "result= ${result}")

# check if the compiler is mpif90 
# if("${CMAKE_Fortran_COMPILER}" MATCHES "mpif90$") 
#  message("MPI build") 
# endif("${CMAKE_Fortran_COMPILER}" MATCHES "mpif90$") 

# now setup some special variablesi
if(NOT COMPILER_FLAGS_WERE_SET)
   message("Setting initial values for compiler flags")
   if(COMPILER_SWITCH MATCHES "pgi")
      set (CMAKE_Fortran_FLAGS "-Mextend" CACHE TYPE STRING FORCE)
      set (CMAKE_Fortran_FLAGS_RELEASE "-O3 -Munroll -Mnoframe" CACHE TYPE STRING FORCE)
      set (CMAKE_Fortran_FLAGS_DEBUG "-O0 -g" CACHE TYPE STRING FORCE)
      set (FORTRAN_FREEFORM_FLAG "-Mfree" CACHE TYPE STRING)
   elseif(COMPILER_SWITCH MATCHES "gfortran")
      set (CMAKE_Fortran_FLAGS "-ffixed-line-length-200 -ffree-line-length-200 -fPIC" CACHE TYPE STRING FORCE)
# commented out, use standard flag
#     SET (CMAKE_Fortran_FLAGS_DEBUG "-g -fbounds-check -Wuninitialized -O1 -ftrapv" CACHE TYPE STRING FORCE)
#     SET (CMAKE_Fortran_FLAGS_RELEASE "-g -fbounds-check -Wuninitialized -O3 -ftrapv" CACHE TYPE STRING FORCE)
      set (FORTRAN_FREEFORM_FLAG "-ffree-form" CACHE TYPE STRING)
   elseif(COMPILER_SWITCH MATCHES "nag")
      set (CMAKE_Fortran_FLAGS "-132 -kind=byte -maxcontin=3000 -mismatch_all" CACHE TYPE STRING FORCE)
      set (FORTRAN_FREEFORM_FLAG "-free" CACHE TYPE STRING)
   elseif(COMPILER_SWITCH MATCHES "ifort")
      set (CMAKE_Fortran_FLAGS "-132 -heap-arrays" CACHE TYPE STRING FORCE)
      set (FORTRAN_FREEFORM_FLAG "-free" CACHE TYPE STRING)
   else(COMPILER_SWITCH MATCHES "pgi")
      message(FATAL_ERROR "unknown comiler switch: ${COMPILER_SWITCH}")
   endif(COMPILER_SWITCH MATCHES "pgi")
    SET(COMPILER_FLAGS_WERE_SET yes CACHE TYPE INTERNAL)
endif(NOT COMPILER_FLAGS_WERE_SET)

mark_as_advanced(FORTRAN_FREEFORM_FLAG COMPILER_SWITCH COMPILER_FLAGS_WERE_SET)
