PROGRAM pyamff
  USE fpCalc

  IMPLICIT NONE
  
  INTEGER, PARAMETER :: nAtoms=3
  INTEGER, PARAMETER :: MAX_FPs = 6
  INTEGER, PARAMETER :: MAX_NEIGHS = 48
  DOUBLE PRECISION,DIMENSION(nAtoms,3) :: pos_car
  INTEGER, DIMENSION(nAtoms) :: symbols
  DOUBLE PRECISION,DIMENSION(3,3) :: cell
  DOUBLE PRECISION,DIMENSION(3) :: cell1
  DOUBLE PRECISION,DIMENSION(3) :: cell2
  DOUBLE PRECISION,DIMENSION(3) :: cell3
  DOUBLE PRECISION,DIMENSION(3) :: atom1
  DOUBLE PRECISION,DIMENSION(3) :: atom2
  DOUBLE PRECISION,DIMENSION(3) :: atom3
  DOUBLE PRECISION,DIMENSION(3) :: atom4
  DOUBLE PRECISION,DIMENSION(3) :: atom5
  DOUBLE PRECISION,DIMENSION(3) :: atom6

  INTEGER, PARAMETER :: nelement=1
  CHARACTER*20 :: filename
  CHARACTER*3, DIMENSION(nelement) :: uniq_elements
  
  DOUBLE PRECISION, DIMENSION(nAtoms, MAX_FPS) :: fps
  DOUBLE PRECISION, DIMENSION(nAtoms, MAX_NEIGHS, 3, MAX_FPS) :: dfps
  INTEGER, DIMENSION(nAtoms, MAX_NEIGHS) :: neighs

  filename = 'fpParas.dat'
  uniq_elements(1) = 'Pd'

  print *, 'fp defined'
  !TODO:Read in structures
  DATA cell1 /20.0000000000000000,    0.0000000000000000,    0.0000000000000000/
  DATA cell2 /0.0000000000000000,   20.0000000000000000,    0.0000000000000000/
  DATA cell3 /0.0000000000000000,    0.0000000000000000,   20.0000000000000000/
  cell(1,:) = cell1
  cell(2,:) = cell2
  cell(3,:) = cell3
  !DATA atom1 /5.6128260000000001,  4.6917624999999994,  7.3510355000000001/
  DATA atom1 /5.6628260000000001,  4.6917624999999994,  7.3510355000000001/
  DATA atom2 /6.9089170000000006,  6.4751075000000000,  5.8988344999999995/
  DATA atom3 /6.4358810000000002,  5.8617894999999995,  9.5827825000000004/
  !DATA atom3 /6.4858810000000002,  5.8617894999999995,  9.5827825000000004/
  pos_car(1,:) = atom1
  pos_car(2,:) = atom2
  pos_car(3,:) = atom3
  DATA symbols /1, 1, 1/
  CALL read_fpParas(filename, nelement, uniq_elements, fpParas, max_rcut)

  CALL calcfps(filename, nAtoms, nelement, symbols, uniq_elements, pos_car, cell, MAX_FPs,&
                      fps, dfps, neighs)

END PROGRAM
